# Contributor Code of Conduct

## Related Code of Conduct 

Participant Code of Conduct
[https://www2.fin.ucar.edu/ethics/participant-code-conduct](https://www2.fin.ucar.edu/ethics/participant-code-conduct)

## Our Pledge

We, as contributors and maintainers (participants), of the NCAR Command Language (NCL) pledge to make participation in our software project and community a safe, productive, welcoming and inclusive experience for everyone. All participants are required to abide by this Code of Conduct. This includes respectful treatment of everyone regardless of age, body size, disability, ethnicity, gender identity or expression, level of experience, nationality, political affiliation, veteran status, pregnancy, genetic information, physical appearance, race, religion, or sexual orientation, as well as any other characteristic protected under applicable US federal or state law.

## Our Standards

Examples of behaviors that contribute to a positive environment include:

* Using welcoming and inclusive language
* Respectful when offering and gracefully accepting constructive criticism
* Acknowledging the contributions of others
* Focusing on what is best for the community
* Showing empathy towards other community members
* Treating everyone with respect and consideration, valuing a diversity of views and opinions
* Communicating openly with respect for others, critiquing ideas rather than individuals

Examples of unacceptable behavior include, but are not limited to:

* Harassment, intimidation, or discrimination in any form
* Personal attacks directed toward other participants
* Unwelcome sexual attention or advances
* Inappropriate, negative, derogatory comments and/or attacks on personal beliefs
* Publishing others' private information, such as a physical or electronic address, without explicit permission
* Refusing to use the pronouns that someone requests
* Alarming, intimidating, threatening, or hostile comments or conduct
* Physical or verbal abuse by anyone to anyone, including but not limited to a participant, member of the public, guest, member of any institution or sponsor
* Comments related to characteristics given in the pledge at the top
* Inappropriate use of nudity and/or sexual images
* Threatening or stalking other participants
* Other conduct which could reasonably be considered inappropriate in a professional setting

## Scope

This Code of Conduct applies to all spaces managed by the Project whether it be online or face-to-face. This includes project code, code repository, associated web pages, documentation, mailing lists, project websites and wiki pages, issue tracker, meetings, telecons, events, project social media accounts, and any other forums created by the project team which the community uses for communication. In addition, violations of this Code of Conduct outside these spaces may affect a person's ability to participate within them. Representation of a project may be further defined and clarified by project maintainers.

## Community Responsibilities

Everyone in the community is empowered to respond to people who are showing unacceptable behavior. They can talk to them privately or publicly. Anyone requested to stop unacceptable behavior is expected to comply immediately. If the behavior continues concerns may be brought to the project administrators or to any other party listed in the Reporting section below.

## Project Administrator Responsibilities

Project Administrators are responsible for clarifying the standards of acceptable behavior and are encouraged to model appropriate behavior and provide support when people in the community point out inappropriate behavior. Project administrator(s) are normally the ones that would be tasked to carry out the actions in the Consequences section below.

Project Administrators are also expected to keep this Code of Conduct updated with the main one housed at UCAR as listed below in the Attribution section.

## Reporting

Instances of unacceptable behavior can be brought to the attention of the project administrator(s) who may take any action as outlined in the Consequences section below. However, making a report to a project administrator is not considered an 'official report' to UCAR.

Instances of unacceptable behavior may also be reported directly to UCAR via UCAR's Harassment Reporting and Complaint Procedure at [https://www2.fin.ucar.edu/procedures/hr/harassment-reporting-and-complaint-procedure](https://www2.fin.ucar.edu/procedures/hr/harassment-reporting-and-complaint-procedure), or anonymously through UCAR's EthicsPoint Hotline at [https://www2.fin.ucar.edu/ethics/anonymous-reporting](https://www2.fin.ucar.edu/ethics/anonymous-reporting).

Complaints received by UCAR will be handled pursuant to the procedures outlined in UCAR's Harassment Reporting and Complaint Procedure. Complaints to UCAR will be held as confidential as practicable under the circumstances, and retaliation against a person who initiates a complaint or an inquiry about inappropriate behavior will not be tolerated.

Any Contributor can use these reporting methods even if they are not directly affiliated with UCAR. The Frequently Asked Questions (FAQ) page for reporting is here: [https://www2.fin.ucar.edu/procedures/hr/reporting-faqs](https://www2.fin.ucar.edu/procedures/hr/reporting-faqs).

## Consequences

Upon receipt of a complaint, the project administrator(s) may take any action deemed necessary and appropriate under the circumstances. Such action can include things such as: removing, editing, or rejecting comments, commits, code, wiki edits, email, issues, and other contributions that are not aligned to this Code of Conduct, or banning temporarily or permanently any contributor for other behaviors that are deemed inappropriate, threatening, offensive, or harmful. Project Administrators also have the right to report violations to UCAR HR and/or UCAR's Office of Diversity, Equity and Inclusion (ODEI) as well as a participant's home institution and/or law enforcement. In the event an incident is reported to UCAR, UCAR will follow its Harassment Reporting and Complaint Procedure.

## Process for Changes

All UCAR managed projects are required to adopt this Contributor Code of Conduct. Adoption is assumed even if not expressly stated in the repository. Projects should fill in sections where prompted with project-specific information, including, project name, email addresses, adoption date, etc. There is one section below marked "optional" that may not apply to a given project.

Projects that adopt this Code of Conduct need to stay up to date with UCAR's Contributor Code of Conduct, linked with a DOI in the "Attribution" section below. Projects can make limited substantive changes to the Code of Conduct, however, the changes must be limited in scope and may not contradict the UCAR Contributor Code of Conduct.

## Attribution

This Code of Conduct was originally adapted from the Contributor Covenant, version 1.4, available at [Contributor-Covenant](http://contributor-covenant.org/version/1/4). We then aligned it with the UCAR Participant Code of Conduct, which also borrows from the American Geophysical Union (AGU) Code of Conduct. The UCAR Participant Code of Conduct applies to both UCAR employees as well as participants in activities run by UCAR. We modified the "scope" section with the django project description, and we added "Publication Ethics" from the NGEET/FATES project. The original version of this for all software projects that have strong management from UCAR or UCAR staff is available on the UCAR website at [*Enter DOI link name*] (the date that it was adopted by this project was [*Enter date adopted*]). When responding to complaints UCAR HR and ODEI will do so based on the latest published version. Therefore, any project-specific changes should follow the Process for Changes section above.

## Publication Ethics (optional)

We aim to create an open development environment where developers can be confident that all members of the community are publishing any research on the project in an ethical manner. In particular, writing code is a form of intellectual contribution, and one should expect that all such intellectual contributions are respected and given credit in any resulting published work. To support the community and avoid issues of misconduct related to the above principle, please respect the following rules:

* Document the version of the code used in any publication, preferably by either using a release tag (existing or newly created) if possible, or a commit hash if not.

* Do not use code from anywhere other than the central project's development repository main development branch without discussing with the author(s) of the modified code your intentions for using the code and receiving their permission to do so.

* When using project features that have recently been integrated into the central Project development repository, be mindful of the contributions of others and, where the novel features qualitatively affect the results, involve the author(s) of these features in any resulting manuscripts. Be particularly aware of the concerns of early career researchers, and ensure they have sufficient time to lead publications using their developments.

* When discussing results arising from older project features that have been described in the literature or releases, accurately cite the publications describing those features or releases.
