# genreset.py - represents a "set" of valid genres.
#
#  Copyright 2004 Daniel Burrows

import sets

class GenreSet:
    """Represents a set of genres.  It can be either a finite listing of
    genres, or an infinite set containing all genres."""
    def __init__(self, genres):
        """Instantiate a GenreSet.  If genres is True, every genre is
        contained in this set; otherwise, it must be a list of strings
        enumerating the genres in the set or a dictionary whose keys
        are the set members."""

        if genres == True or isinstance(genres, sets.ImmutableSet):
            self.genres=genres
        else:
            assert(type(genres)==list)

            self.genres=sets.ImmutableSet(map(lambda x:x.upper(), genres))

    def member(self, genre):
        """Returns true if the given genre is contained in this set of genres."""
        return self.genres == True or genre.upper() in self.genres

    def members(self):
        """Returns a list of all genres in this set, or True."""

        if self.genres == True:
            return True
        else:
            return list(self.genres)

    def union(self, other):
        """Returns the union of this set with another set of genres."""

        # Special case when the object identities are the same.
        if self == other:
            return self
        elif self.genres == True:
            return self
        elif other.genres == True:
            return other
        else:
            return GenreSet(self.genres | other.genres)

    def intersect(self, other):
        """Returns the intersection of this set with another set of genres."""

        if self == other:
            return self
        elif self.genres == True:
            return other
        elif other.genres == True:
            return self
        else:
            return GenreSet(self.genres & other.genres)
