/* A Bison parser, made by GNU Bison 3.5.1.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Undocumented macros, especially those whose name start with YY_,
   are private implementation details.  Do not rely on them.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.5.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 2

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         msc_parse
#define yylex           msc_lex
#define yyerror         msc_error
#define yydebug         msc_debug
#define yynerrs         msc_nerrs

/* First part of user prologue.  */
#line 15 "msc_lang.yy"

/*
    This file is part of Msc-generator.
    Copyright (C) 2008-2021 Zoltan Turanyi
    Distributed under GNU Affero General Public License.

    Msc-generator is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Msc-generator is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with Msc-generator.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifdef COLOR_SYNTAX_HIGHLIGHT
    #undef COLOR_SYNTAX_HIGHLIGHT //so that subsequent definition in msc_csh_lang2.h causes no warning
    #define C_S_H (1)
    #define C_S_H_IS_COMPILED
    #define YYMSC_RESULT_TYPE MscCsh
    #define RESULT csh
    #include "msccsh.h"
    #include "cgen_shapes.h"
    #define YYGET_EXTRA msccsh_get_extra
    #define YYLTYPE_IS_DECLARED
    #define YYLTYPE CshPos
    #define CHAR_IF_CSH(A) char
#else
    #define C_S_H (0)
    #define YYMSC_RESULT_TYPE MscChart
    #define RESULT chart
    #define YYGET_EXTRA msc_get_extra
    #define CHAR_IF_CSH(A) A
#endif

#include "commands.h"//For AttrNames and AttrValues
#include "msc.h" //For AttrNames and AttrValues

using namespace msc;


#line 122 "msc_lang.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_MSC_MSC_LANG_H_INCLUDED
# define YY_MSC_MSC_LANG_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int msc_debug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    TOK_EOF = 0,
    TOK_STRING = 258,
    TOK_QSTRING = 259,
    TOK_NUMBER = 260,
    TOK_DASH = 261,
    TOK_EQUAL = 262,
    TOK_COMMA = 263,
    TOK_TILDE = 264,
    TOK_SEMICOLON = 265,
    TOK_PLUS = 266,
    TOK_PLUS_EQUAL = 267,
    TOK_PIPE_SYMBOL = 268,
    TOK_OCBRACKET = 269,
    TOK_CCBRACKET = 270,
    TOK_OSBRACKET = 271,
    TOK_CSBRACKET = 272,
    TOK_OPARENTHESIS = 273,
    TOK_CPARENTHESIS = 274,
    TOK_PARAM_NAME = 275,
    TOK_ASTERISK = 276,
    TOK_MSC = 277,
    TOK_COLON_STRING = 278,
    TOK_COLON_QUOTED_STRING = 279,
    TOK_STYLE_NAME = 280,
    TOK_COLORDEF = 281,
    TOK_COLORDEF_NAME_NUMBER = 282,
    TOK_REL_TO = 283,
    TOK_REL_FROM = 284,
    TOK_REL_BIDIR = 285,
    TOK_REL_X = 286,
    TOK_REL_DASH_X = 287,
    TOK_REL_MSCGEN = 288,
    TOK_SPECIAL_ARC = 289,
    TOK_EMPH = 290,
    TOK_EMPH_PLUS_PLUS = 291,
    TOK_COMMAND_HEADING = 292,
    TOK_COMMAND_NUDGE = 293,
    TOK_COMMAND_NEWPAGE = 294,
    TOK_COMMAND_DEFSHAPE = 295,
    TOK_COMMAND_DEFCOLOR = 296,
    TOK_COMMAND_DEFSTYLE = 297,
    TOK_COMMAND_DEFDESIGN = 298,
    TOK_COMMAND_DEFPROC = 299,
    TOK_COMMAND_REPLAY = 300,
    TOK_COMMAND_SET = 301,
    TOK_COMMAND_INCLUDE = 302,
    TOK_COMMAND_BIG = 303,
    TOK_COMMAND_BOX = 304,
    TOK_COMMAND_PIPE = 305,
    TOK_COMMAND_MARK = 306,
    TOK_COMMAND_MARK_SRC = 307,
    TOK_COMMAND_MARK_DST = 308,
    TOK_COMMAND_PARALLEL = 309,
    TOK_COMMAND_OVERLAP = 310,
    TOK_COMMAND_INLINE = 311,
    TOK_VERTICAL = 312,
    TOK_VERTICAL_SHAPE = 313,
    TOK_AT = 314,
    TOK_LOST = 315,
    TOK_AT_POS = 316,
    TOK_SHOW = 317,
    TOK_HIDE = 318,
    TOK_ACTIVATE = 319,
    TOK_DEACTIVATE = 320,
    TOK_BYE = 321,
    TOK_START = 322,
    TOK_BEFORE = 323,
    TOK_END = 324,
    TOK_AFTER = 325,
    TOK_COMMAND_VSPACE = 326,
    TOK_COMMAND_HSPACE = 327,
    TOK_COMMAND_SYMBOL = 328,
    TOK_COMMAND_NOTE = 329,
    TOK_COMMAND_COMMENT = 330,
    TOK_COMMAND_ENDNOTE = 331,
    TOK_COMMAND_FOOTNOTE = 332,
    TOK_COMMAND_TITLE = 333,
    TOK_COMMAND_SUBTITLE = 334,
    TOK_COMMAND_TEXT = 335,
    TOK_SHAPE_COMMAND = 336,
    TOK_JOIN = 337,
    TOK_IF = 338,
    TOK_THEN = 339,
    TOK_ELSE = 340,
    TOK_MSCGEN_RBOX = 341,
    TOK_MSCGEN_ABOX = 342,
    TOK_UNRECOGNIZED_CHAR = 343
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 86 "msc_lang.yy"

    gsl::owner<char*>                                          str;
    const char*                                                input_text_ptr;
    int                                                        condition; //0:false, 1:true, 2:had_error
    ECompareOperator                                           compare_op;
    multi_segment_string                                       multi_str;
    gsl::owner<CHAR_IF_CSH(ArcBase)*>                          arcbase;
    gsl::owner<CHAR_IF_CSH(ArcList)*>                          arclist;
    gsl::owner<CHAR_IF_CSH(Arrow)*>                            arcarrow;
    gsl::owner<CHAR_IF_CSH(Vertical)*>                         arcvertarrow;
    gsl::owner<CHAR_IF_CSH(Box)*>                              arcbox;
    gsl::owner<CHAR_IF_CSH(Pipe)*>                             arcpipe;
    gsl::owner<CHAR_IF_CSH(BoxSeries)*>                        arcboxseries;
    gsl::owner<CHAR_IF_CSH(PipeSeries)*>                       arcpipeseries;
    gsl::owner<CHAR_IF_CSH(ParallelBlocks)*>                   arcparallel;
    EArcSymbol                                                 arcsymbol;
    gsl::owner<CHAR_IF_CSH(EntityAppHelper)*>                  entitylist;
    gsl::owner<CHAR_IF_CSH(Attribute)*>                        attrib;
    gsl::owner<CHAR_IF_CSH(AttributeList)*>                    attriblist;
    gsl::owner<CHAR_IF_CSH(VertXPos)*>                         vertxpos;
    gsl::owner<CHAR_IF_CSH(ExtVertXPos)*>                      extvertxpos;
    gsl::owner<CHAR_IF_CSH(NamePair)*>                         namerel;
    gsl::owner<std::list<std::string>*>                        stringlist;
    CHAR_IF_CSH(ESide)                                         eside;
    gsl::owner<CHAR_IF_CSH(ArrowSegmentData)*>                 arcsegdata;
    CHAR_IF_CSH(Vertical::EVerticalShape)                      vshape;
    gsl::owner<CHAR_IF_CSH(ArcTypePlusDir)*>                   arctypeplusdir;
    ShapeElement::Type                                         shapecommand;
    gsl::owner<CHAR_IF_CSH(Shape)*>                            shape;
    gsl::owner<CHAR_IF_CSH(ShapeElement)*>                     shapeelement;
    gsl::owner<CHAR_IF_CSH(ArrowEnding)*>                      arrowending;
    gsl::owner<CHAR_IF_CSH(Procedure)*>                        procedure;
    CHAR_IF_CSH(const Procedure)*                              cprocedure;
    gsl::owner<CHAR_IF_CSH(ProcParamDef)*>                     procparamdef;
    gsl::owner<CHAR_IF_CSH(ProcParamDefList)*>                 procparamdeflist;
    gsl::owner<CHAR_IF_CSH(ProcParamInvocation)*>              procparaminvoc;
    gsl::owner<CHAR_IF_CSH(ProcParamInvocationList)*>          procparaminvoclist;
    gsl::owner<CHAR_IF_CSH(ProcDefParseHelper<AttributeList>)*>procdefhelper;

#line 304 "msc_lang.cc"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif



int msc_parse (YYMSC_RESULT_TYPE &RESULT, void *yyscanner);

#endif /* !YY_MSC_MSC_LANG_H_INCLUDED  */

/* Second part of user prologue.  */
#line 208 "msc_lang.yy"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <list>
#include <iostream>

#ifdef C_S_H_IS_COMPILED
    #include "msc_lang_misc.h"  //Must be after RESULT and YYMSC_RESULT_TYPE is defined
    #include "msc_csh_lang2.h"  //Needs parse_param from msc_lang_misc.h
    /* yyerror
     *  Error handling function.  Do nothing for CSH */
    void yyerror(YYLTYPE* /*loc*/, Csh & /*csh*/, void * /*yyscanner*/, const char * /*str*/) {}
#else
    #include "msc_lang_misc.h"  //Must be after RESULT and YYMSC_RESULT_TYPE is defined
    #include "msc_lang2.h"      //Needs parse_param from msc_lang_misc.h
    /* Use verbose error reporting such that the expected token names are dumped */
    //#define YYERROR_VERBOSE
    #include "msc_parse_tools.h" //includes yyerror()
#endif

#ifdef C_S_H_IS_COMPILED
void MscCshParse(YYMSC_RESULT_TYPE &RESULT, const char *buff, unsigned len)
#else
void MscParse(YYMSC_RESULT_TYPE &RESULT, const char *buff, unsigned len)
#endif
{
    std::remove_pointer<YY_EXTRA_TYPE>::type pp;
    pp.RESULT = &RESULT;
#ifdef C_S_H_IS_COMPILED
    pp.buff.buf = buff;
    pp.buff.length = len;
    pp.buff.pos = 0;
    msccsh_lex_init(&pp.yyscanner);
    msccsh_set_extra(&pp, pp.yyscanner);
    msccsh_parse(RESULT, pp.yyscanner);
    msccsh_lex_destroy(pp.yyscanner);
#else
    pp.buffs.emplace_back(buff, len);
    pp.pos_stack.file = RESULT.current_file;
    msc_lex_init(&pp.yyscanner);
    msc_set_extra(&pp, pp.yyscanner);
    msc_parse(RESULT, pp.yyscanner);
    msc_lex_destroy(pp.yyscanner);
#endif
}


#line 382 "msc_lang.cc"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))

/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  274
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3696

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  89
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  125
/* YYNRULES -- Number of rules.  */
#define YYNRULES  600
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  656

#define YYUNDEFTOK  2
#define YYMAXUTOK   343


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   259,   259,   264,   265,   274,   286,   296,   315,   330,
     342,   360,   361,   371,   386,   396,   409,   433,   442,   454,
     466,   478,   490,   501,   514,   528,   567,   586,   604,   616,
     627,   637,   646,   654,   663,   678,   694,   705,   722,   733,
     757,   766,   777,   787,   799,   810,   820,   831,   842,   858,
     876,   895,   917,   941,   955,   968,   986,  1005,  1024,  1040,
    1060,  1078,  1090,  1102,  1103,  1118,  1135,  1144,  1152,  1167,
    1180,  1198,  1215,  1239,  1258,  1281,  1307,  1327,  1345,  1361,
    1383,  1394,  1421,  1430,  1441,  1451,  1463,  1474,  1484,  1495,
    1504,  1517,  1527,  1543,  1561,  1572,  1585,  1600,  1600,  1600,
    1602,  1603,  1630,  1647,  1656,  1669,  1685,  1704,  1726,  1746,
    1768,  1789,  1820,  1845,  1871,  1906,  1924,  1936,  1951,  1971,
    1986,  1994,  2011,  2027,  2041,  2055,  2076,  2095,  2106,  2117,
    2124,  2131,  2135,  2154,  2178,  2194,  2212,  2228,  2246,  2263,
    2286,  2293,  2300,  2314,  2331,  2345,  2362,  2382,  2397,  2415,
    2438,  2461,  2478,  2498,  2520,  2545,  2570,  2586,  2607,  2621,
    2638,  2639,  2640,  2641,  2658,  2680,  2699,  2721,  2738,  2760,
    2769,  2769,  2771,  2772,  2798,  2820,  2837,  2841,  2845,  2849,
    2853,  2858,  2866,  2879,  2902,  2918,  2946,  2967,  2981,  2995,
    3016,  3047,  3068,  3082,  3094,  3108,  3124,  3138,  3166,  3182,
    3199,  3200,  3211,  3222,  3222,  3224,  3240,  3255,  3264,  3283,
    3295,  3310,  3324,  3334,  3352,  3352,  3352,  3352,  3354,  3364,
    3383,  3396,  3411,  3434,  3459,  3479,  3507,  3526,  3554,  3574,
    3580,  3592,  3605,  3627,  3645,  3667,  3686,  3709,  3729,  3752,
    3773,  3774,  3784,  3797,  3813,  3824,  3848,  3863,  3879,  3904,
    3922,  3934,  3949,  3971,  3992,  4015,  4027,  4040,  4054,  4069,
    4081,  4094,  4103,  4113,  4129,  4157,  4181,  4198,  4216,  4245,
    4273,  4303,  4336,  4337,  4348,  4363,  4363,  4365,  4365,  4366,
    4376,  4404,  4433,  4454,  4473,  4513,  4556,  4568,  4569,  4580,
    4595,  4613,  4628,  4646,  4648,  4649,  4659,  4669,  4676,  4697,
    4719,  4737,  4763,  4789,  4806,  4825,  4834,  4850,  4861,  4878,
    4895,  4895,  4906,  4914,  4932,  4948,  4968,  4988,  5004,  5011,
    5025,  5034,  5048,  5062,  5081,  5091,  5107,  5117,  5136,  5143,
    5155,  5163,  5178,  5196,  5214,  5229,  5251,  5262,  5278,  5300,
    5301,  5310,  5310,  5312,  5331,  5346,  5362,  5372,  5372,  5372,
    5372,  5374,  5407,  5429,  5453,  5477,  5502,  5525,  5550,  5594,
    5621,  5648,  5677,  5706,  5726,  5735,  5745,  5754,  5766,  5774,
    5782,  5791,  5812,  5829,  5847,  5856,  5873,  5884,  5899,  5917,
    5925,  5936,  5943,  5957,  5968,  5987,  6002,  6019,  6040,  6057,
    6074,  6095,  6114,  6124,  6138,  6149,  6161,  6174,  6189,  6213,
    6213,  6213,  6214,  6242,  6263,  6314,  6329,  6360,  6377,  6387,
    6403,  6423,  6439,  6456,  6474,  6495,  6517,  6534,  6550,  6569,
    6589,  6605,  6622,  6640,  6661,  6683,  6700,  6716,  6735,  6755,
    6772,  6788,  6806,  6825,  6846,  6863,  6879,  6897,  6897,  6898,
    6898,  6899,  6899,  6901,  6910,  6919,  6928,  6940,  6949,  6958,
    6967,  6979,  6988,  6997,  7006,  7018,  7026,  7038,  7050,  7065,
    7073,  7085,  7097,  7112,  7120,  7132,  7144,  7161,  7162,  7176,
    7192,  7211,  7211,  7211,  7213,  7239,  7269,  7305,  7329,  7356,
    7377,  7400,  7428,  7449,  7467,  7475,  7489,  7517,  7537,  7557,
    7581,  7588,  7595,  7603,  7619,  7634,  7642,  7651,  7659,  7667,
    7679,  7687,  7690,  7701,  7712,  7724,  7737,  7749,  7761,  7773,
    7786,  7793,  7802,  7814,  7837,  7856,  7876,  7896,  7915,  7932,
    7948,  7959,  7975,  7984,  7997,  8004,  8005,  8006,  8013,  8014,
    8014,  8014,  8015,  8015,  8015,  8015,  8016,  8016,  8016,  8017,
    8017,  8017,  8018,  8018,  8018,  8019,  8019,  8020,  8020,  8020,
    8020,  8020,  8021,  8021,  8021,  8021,  8021,  8022,  8022,  8022,
    8022,  8022,  8023,  8023,  8023,  8024,  8024,  8025,  8025,  8026,
    8026,  8026,  8026,  8026,  8027,  8027,  8027,  8029,  8050,  8072,
    8093,  8104,  8113,  8124,  8126,  8126,  8129,  8161,  8173,  8178,
    8182,  8184,  8188,  8193,  8194,  8198,  8203,  8204,  8208,  8213,
    8242
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "TOK_EOF", "error", "$undefined", "TOK_STRING", "TOK_QSTRING",
  "TOK_NUMBER", "TOK_DASH", "TOK_EQUAL", "TOK_COMMA", "TOK_TILDE",
  "TOK_SEMICOLON", "TOK_PLUS", "TOK_PLUS_EQUAL", "TOK_PIPE_SYMBOL",
  "TOK_OCBRACKET", "TOK_CCBRACKET", "TOK_OSBRACKET", "TOK_CSBRACKET",
  "TOK_OPARENTHESIS", "TOK_CPARENTHESIS", "TOK_PARAM_NAME", "TOK_ASTERISK",
  "TOK_MSC", "TOK_COLON_STRING", "TOK_COLON_QUOTED_STRING",
  "TOK_STYLE_NAME", "TOK_COLORDEF", "TOK_COLORDEF_NAME_NUMBER",
  "TOK_REL_TO", "TOK_REL_FROM", "TOK_REL_BIDIR", "TOK_REL_X",
  "TOK_REL_DASH_X", "TOK_REL_MSCGEN", "TOK_SPECIAL_ARC", "TOK_EMPH",
  "TOK_EMPH_PLUS_PLUS", "TOK_COMMAND_HEADING", "TOK_COMMAND_NUDGE",
  "TOK_COMMAND_NEWPAGE", "TOK_COMMAND_DEFSHAPE", "TOK_COMMAND_DEFCOLOR",
  "TOK_COMMAND_DEFSTYLE", "TOK_COMMAND_DEFDESIGN", "TOK_COMMAND_DEFPROC",
  "TOK_COMMAND_REPLAY", "TOK_COMMAND_SET", "TOK_COMMAND_INCLUDE",
  "TOK_COMMAND_BIG", "TOK_COMMAND_BOX", "TOK_COMMAND_PIPE",
  "TOK_COMMAND_MARK", "TOK_COMMAND_MARK_SRC", "TOK_COMMAND_MARK_DST",
  "TOK_COMMAND_PARALLEL", "TOK_COMMAND_OVERLAP", "TOK_COMMAND_INLINE",
  "TOK_VERTICAL", "TOK_VERTICAL_SHAPE", "TOK_AT", "TOK_LOST", "TOK_AT_POS",
  "TOK_SHOW", "TOK_HIDE", "TOK_ACTIVATE", "TOK_DEACTIVATE", "TOK_BYE",
  "TOK_START", "TOK_BEFORE", "TOK_END", "TOK_AFTER", "TOK_COMMAND_VSPACE",
  "TOK_COMMAND_HSPACE", "TOK_COMMAND_SYMBOL", "TOK_COMMAND_NOTE",
  "TOK_COMMAND_COMMENT", "TOK_COMMAND_ENDNOTE", "TOK_COMMAND_FOOTNOTE",
  "TOK_COMMAND_TITLE", "TOK_COMMAND_SUBTITLE", "TOK_COMMAND_TEXT",
  "TOK_SHAPE_COMMAND", "TOK_JOIN", "TOK_IF", "TOK_THEN", "TOK_ELSE",
  "TOK_MSCGEN_RBOX", "TOK_MSCGEN_ABOX", "TOK_UNRECOGNIZED_CHAR", "$accept",
  "msc_with_bye", "eof", "msc", "top_level_arclist", "msckey",
  "braced_arclist", "defproc", "defprochelp1", "defprochelp2",
  "defprochelp3", "defprochelp4", "scope_open_proc_body",
  "scope_close_proc_body", "proc_def_arglist_tested", "proc_def_arglist",
  "proc_def_param_list", "proc_def_param", "procedure_body", "set",
  "arclist_maybe_no_semicolon", "arclist", "arc_with_parallel_semicolon",
  "proc_invocation", "proc_param_list", "proc_invoc_param_list",
  "proc_invoc_param", "include", "overlap_or_parallel",
  "arc_with_parallel", "arc", "titlecommandtoken", "hspace_location",
  "comp", "condition", "ifthen_condition", "else", "ifthen",
  "full_arcattrlist_with_label_or_number", "dash_or_dashdash", "entityrel",
  "markerrel_no_string", "entity_command_prefixes", "optlist", "opt",
  "entitylist", "entity", "first_entity", "styledeflist", "styledef",
  "stylenamelist", "shapedef", "shapedeflist", "shapeline", "colordeflist",
  "color_def_string", "color_string", "colordef", "designdef",
  "scope_open_empty", "designelementlist", "designelement",
  "designoptlist", "designopt", "parallel", "optional_box_keyword",
  "box_list", "mscgen_box", "mscgen_boxlist", "first_box", "first_pipe",
  "pipe_list_no_content", "pipe_list", "emphrel", "boxrel",
  "mscgen_emphrel", "mscgen_boxrel", "vertxpos", "empharcrel_straight",
  "vertrel_no_xpos", "vertrel", "arcrel",
  "arrow_with_specifier_incomplete", "arrow_with_specifier",
  "special_ending", "arcrel_arrow", "arcrel_to", "arcrel_from",
  "arcrel_bidir", "relation_to_cont_no_loss", "relation_from_cont_no_loss",
  "relation_bidir_cont_no_loss", "relation_to", "relation_from",
  "relation_bidir", "relation_to_cont", "relation_from_cont",
  "relation_bidir_cont", "extvertxpos", "extvertxpos_no_string",
  "symbol_type_string", "symbol_command_no_attr", "symbol_command", "note",
  "comment_command", "comment", "colon_string",
  "full_arcattrlist_with_label", "full_arcattrlist", "arcattrlist",
  "arcattr", "vertical_shape", "entity_string_single",
  "reserved_word_string", "symbol_string", "alpha_string_single",
  "string_single", "tok_param_name_as_multi", "multi_string_continuation",
  "entity_string_single_or_param", "entity_string", "alpha_string",
  "string", "scope_open", "scope_close", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343
};
# endif

#define YYPACT_NINF (-433)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-509)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    3171,  -433,  -433,    60,  -433,   426,  -433,   918,  -433,   506,
     266,  -433,  -433,    27,    68,    88,  -433,  -433,  -433,  -433,
     107,   107,   107,    60,  2516,  1496,   137,  2261,  2516,   124,
     143,  3560,  3581,   158,  2346,  -433,  -433,  3478,  -433,  -433,
    -433,  -433,   573,  3552,  3615,   133,  -433,  -433,  -433,  -433,
    -433,   189,  -433,  -433,   830,   175,    41,    30,   172,  -433,
    -433,  -433,  -433,   181,  3252,  -433,  2688,  2772,  3414,   297,
    -433,   270,  1092,  -433,    60,   191,  -433,   198,   316,   187,
    -433,   223,  -433,  -433,   335,  -433,    60,   446,   270,   270,
     435,   757,  -433,   110,   161,    98,    60,    60,    60,   270,
    -433,  -433,   270,  -433,   107,   202,  -433,  -433,   225,  3102,
    2940,  -433,    60,    60,    60,   220,  -433,  -433,  -433,  -433,
    -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,
    -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,
    -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,
    -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,
    -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,
    -433,  -433,  -433,  -433,   549,  -433,  -433,  -433,   225,   225,
    -433,   235,  -433,   241,   255,   281,    41,  1581,  2176,  -433,
    -433,  -433,  -433,  -433,  -433,  -433,   242,   279,  -433,   298,
    -433,   303,  -433,   192,  -433,  -433,   301,  -433,  -433,    52,
    -433,  -433,  -433,  3024,   332,  -433,  -433,   308,   515,  -433,
     346,  -433,  -433,   270,  3135,  -433,  -433,   107,   172,    19,
     211,  -433,   270,  -433,   107,   107,   631,  -433,  -433,  -433,
      60,   333,  -433,    60,   305,   270,  -433,  -433,  -433,  3518,
     603,   270,  -433,  -433,  -433,  -433,   287,  -433,   573,  -433,
      60,  -433,    49,  -433,   487,  -433,  -433,  1241,  -433,   270,
    -433,   272,   285,  1006,  -433,  -433,   363,  -433,    41,  -433,
    -433,  3252,   138,  -433,   527,   365,  -433,   669,  2856,   376,
    -433,  -433,   382,  -433,  -433,   304,    36,   392,   446,   313,
      60,  -433,   172,  -433,  -433,   408,   172,    60,  -433,   270,
    -433,  -433,   172,  -433,  -433,  -433,  -433,   305,    25,   139,
    -433,  -433,    64,  -433,   380,   321,  -433,    72,  -433,   388,
     393,  -433,    70,  -433,   397,   781,  -433,  -433,  -433,  -433,
    -433,  -433,  -433,   107,  2176,  -433,    60,  1666,   413,    60,
      60,  -433,  -433,  -433,  -433,  -433,    60,    60,   796,  3109,
    3142,   172,  -433,  -433,  -433,   254,  -433,  -433,  -433,  -433,
    -433,   404,  1751,  -433,  -433,  -433,  1156,  -433,  -433,  -433,
    -433,   412,  -433,    39,  2516,  1326,  1496,  1836,  -433,  -433,
     615,   411,  -433,   496,  -433,  -433,  -433,  -433,  -433,   433,
    -433,  -433,  -433,  1921,  -433,  -433,  -433,   107,  -433,  -433,
    -433,   410,   379,  -433,  -433,  -433,  -433,   270,  -433,    60,
    -433,  -433,  -433,  -433,    60,   305,    60,   306,  -433,   306,
      49,  -433,   270,  -433,  -433,  -433,  2176,  -433,  -433,  -433,
    -433,  -433,  2176,  -433,  -433,  -433,  2176,  -433,   421,  -433,
    2006,  -433,  2604,  -433,  -433,   431,  -433,  -433,  -433,  -433,
    3333,   304,  3333,    60,  -433,  -433,   445,   463,  -433,   446,
    -433,   446,  -433,  -433,   203,  -433,  -433,  -433,   149,  -433,
     149,  -433,   432,  -433,  -433,  -433,   451,  -433,  -433,  -433,
     454,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,    60,
    -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,
    -433,  -433,    59,  -433,  -433,  -433,  -433,  -433,  -433,  -433,
    1411,  -433,  -433,   395,   473,   407,   475,  -433,  -433,  -433,
    1411,  -433,  -433,  -433,  -433,  -433,   216,  2516,  1496,   476,
    -433,   102,  -433,   488,  -433,   464,   124,  -433,  -433,   164,
    -433,  -433,  -433,  -433,  -433,  -433,  -433,   536,   489,    60,
    -433,  -433,  -433,  -433,  -433,  -433,   306,  -433,  -433,  -433,
      60,  -433,  -433,  -433,  -433,  -433,  -433,   479,  2006,  -433,
    -433,  -433,  3333,  -433,   463,    60,  -433,   172,  -433,   172,
    -433,  -433,   497,  -433,  -433,  -433,  -433,  -433,  -433,  -433,
    -433,   493,   500,   494,  -433,  -433,   498,  -433,  -433,  2176,
    2176,   279,   303,   218,  -433,   572,  2091,  -433,  -433,  -433,
    -433,  -433,   508,  -433,   509,   306,  -433,  -433,  -433,  -433,
    -433,  -433,  -433,  -433,  -433,  2431,  -433,  -433,  -433,  -433,
     502,  -433,  -433,  -433,  -433,  -433,  -433,  -433,  -433,   514,
     519,  -433,   533,  -433,   538,  -433
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       6,   525,   524,     0,    69,     0,   599,     0,   586,     0,
       0,   496,   495,   443,   447,   451,   526,   379,   342,   341,
     142,   144,   158,   133,   135,   137,   139,    26,    80,    62,
      95,   105,   313,     0,   152,    97,    98,   108,   215,   214,
     216,   217,   168,   165,   483,     0,   490,   491,   492,   170,
     171,   148,   527,    99,     0,     0,     0,     0,     0,   305,
     140,    25,   141,    11,    63,    66,     0,     0,   102,     0,
     100,   147,     0,   169,   121,   127,   218,   120,   131,   310,
     326,   128,   312,   336,   339,   130,   346,   328,   324,   103,
       0,     0,   392,   399,   400,   401,   411,   420,   430,   484,
     160,   161,   494,   162,   116,   115,   589,   590,   591,   237,
       0,   408,     0,     0,     0,   509,   502,   528,   585,   577,
     578,   579,   580,   581,   582,   520,   529,   530,   531,   532,
     533,   534,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,   556,   569,   570,   571,   572,   557,   558,
     559,   561,   562,   563,   564,   565,   566,   560,   573,   574,
     575,   576,   567,   568,     0,   510,   583,   584,   594,   597,
     593,   596,   519,   444,   448,   452,     0,   226,   228,   445,
     449,   453,   143,   145,   159,   132,   250,   134,   272,   283,
     246,   136,   240,   244,   596,   245,     0,   138,    37,     0,
      27,    30,    33,     0,    31,    39,    36,    34,    28,    81,
      49,    61,    96,   106,     0,   314,   317,   497,   316,   501,
       0,   333,   332,   155,   156,   153,     0,   523,   522,   521,
     363,   364,   378,   374,   377,   109,   369,   368,   370,   111,
     375,   201,   167,   200,   203,   204,   174,   175,   164,   166,
     207,   172,   209,   473,   482,   471,   472,   488,   487,   151,
     149,   188,   186,     0,     1,     3,     4,     2,     0,     9,
       7,    12,     0,    67,     0,     0,    71,     0,     0,     0,
      77,   101,     0,    68,   146,   193,     0,   122,   237,     0,
     123,   307,   309,   311,   322,     0,     0,     0,   340,   337,
     344,   330,   329,   325,   104,   383,   382,   385,   386,   389,
     384,   438,     0,   437,   455,   417,   440,     0,   439,   459,
     426,   442,     0,   441,   463,   435,   412,   421,   429,   485,
     493,   117,   306,   119,   587,   592,   409,   224,     0,   405,
       0,   349,   350,   347,   348,   239,   345,     0,   414,   423,
     432,   236,    22,   600,    24,     0,    18,   413,   422,   431,
     505,   507,   512,   503,   595,   598,   518,   446,   450,   454,
       8,   225,   227,     0,   274,   282,   242,   247,   243,   286,
       0,     0,    40,     0,    46,    58,    38,    60,    54,     0,
      32,    35,    29,    50,   107,   498,   315,   500,   335,   157,
     154,   365,   352,   366,   372,   376,   112,   110,   114,   373,
     202,   173,   163,   206,   205,   470,   212,   480,   479,   477,
     481,   489,     0,   150,   189,   185,     0,   178,   179,   180,
     177,   176,   182,     5,    10,    13,   226,    72,     0,    94,
      89,    82,     0,    88,    93,     0,    74,    79,    70,   190,
     196,     0,   194,   125,   221,   219,     0,   124,   229,   233,
     308,   318,   323,   327,     0,   338,   331,   393,   388,   387,
     391,   390,   456,   457,   418,   416,   460,   461,   427,   425,
     464,   465,   436,   434,   118,   588,   407,   222,   223,   406,
     403,   402,   343,   351,   415,   410,   424,   419,   433,   428,
     238,    21,     0,    23,    17,   504,   511,   517,   275,   276,
     516,   514,   513,     0,   263,     0,   256,   273,   277,   278,
       0,   280,   279,   241,   249,   248,     0,   290,   292,     0,
     287,     0,   294,     0,    41,     0,    47,    45,    57,     0,
      59,    53,    52,    51,   499,   367,   353,   354,   356,   342,
     358,   113,   371,   208,   469,   211,   474,   467,   468,   478,
     210,   486,   184,   183,   225,    83,    90,     0,    91,    87,
      75,   199,   195,   197,   126,   231,   235,   232,   320,   319,
     398,   394,   396,   395,   458,   462,   466,   404,    20,    19,
     515,   258,   264,   261,   262,   253,   260,   255,   281,   303,
     304,   289,   291,     0,   297,   296,   300,    43,    48,    56,
      55,   355,   359,   357,   360,   475,   213,    85,    92,   198,
     230,   234,   321,   397,   257,   265,   254,   259,   301,   302,
       0,   284,   288,   295,   298,   299,   361,   362,   476,   268,
     266,   285,   269,   267,   270,   271
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -433,  -433,   -51,  -433,   263,  -433,    76,  -433,  -433,  -433,
     336,   337,  -433,  -383,  -433,  -433,  -433,  -201,   338,  -433,
     -91,  -433,   513,  -433,  -433,  -433,  -432,  -433,  -433,   -57,
     511,  -433,  -433,  -433,  -433,  -433,  -284,  -433,   -29,  -239,
    -433,  -433,  -433,  -433,   262,   119,   -15,   516,    50,   201,
    -433,  -433,  -433,  -196,    58,  -433,  -394,   215,  -433,  -433,
    -433,   -13,  -433,    -8,  -433,  -433,  -433,   295,  -433,   576,
    -433,  -433,  -433,   -32,   -24,  -433,  -433,   -49,   359,  -433,
     362,   582,  -433,  -433,   141,  -433,  -433,  -433,  -433,   300,
     293,   294,     8,    21,    42,  -433,  -433,  -433,  -418,   361,
    -433,  -433,  -433,  -433,  -433,  -433,    22,   378,    61,  -433,
     264,  -433,   -34,   606,   597,  -433,  -433,  -433,   140,  -433,
       1,    -7,    -4,  -433,  -338
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    55,   277,    56,    57,    58,    59,    60,    61,   210,
     211,   212,   213,   398,   214,   215,   393,   221,   216,    62,
      63,    64,    65,    66,   288,   452,   453,    67,    68,    69,
      70,    71,   258,   442,   272,    72,   460,    73,   252,   260,
     261,   427,    74,    75,    76,   467,   468,    77,   201,   202,
     203,   195,   525,   526,   197,   521,   531,   198,   207,   390,
     539,   540,   541,   542,    78,   305,    79,    80,    81,    82,
      83,    84,    85,    86,    87,   357,    88,   242,   243,   244,
     245,    89,    90,    91,   591,    92,    93,    94,    95,   324,
     329,   334,    96,    97,    98,   325,   330,   335,   566,   567,
     264,    99,   100,   101,   102,   103,   227,   253,   229,   174,
     175,   249,   106,   176,   177,   178,   179,   107,   345,   108,
     180,   204,   205,   110,   366
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     181,   109,   269,   182,   111,   241,   279,   284,   394,   232,
     265,   569,   462,   112,   259,   296,   551,   199,   576,   365,
     218,   219,   104,   424,   196,   426,   113,   514,     1,     2,
     275,   278,   224,   230,   230,   235,  -191,   461,   250,  -251,
     523,   275,    11,    12,   262,   246,  -191,   114,   189,  -251,
     273,  -191,   -42,   391,  -251,   254,    16,   320,   247,   598,
     309,   105,   -42,     1,     2,   109,   -42,   -42,   -42,   109,
     321,   392,   220,   109,   363,   298,   331,   356,   326,   248,
       8,   192,   193,   194,   255,   230,   104,   310,   217,   190,
     104,    16,   323,   478,   104,   233,   276,   336,   337,   338,
     333,   328,  -191,   614,   331,  -251,    52,   276,   225,   191,
     615,   109,  -293,   367,   368,   369,   321,   358,   -42,   332,
     524,   459,   399,     7,  -251,   105,   600,   343,   333,   105,
     359,   322,   104,   105,   280,   380,   608,   -42,   323,   302,
     206,    52,     1,     2,   220,   446,   628,   222,   625,     7,
     188,   360,     1,     2,   301,   304,    11,    12,  -334,   231,
     308,     1,     2,   311,   619,   341,   620,   326,  -334,     8,
      16,   105,  -334,  -334,   599,   274,   590,   582,     8,   396,
      16,   342,   327,   381,   382,   355,     6,  -129,  -129,    16,
     328,   570,   267,    18,    19,   415,   281,  -129,   356,   299,
     387,     6,  -129,     7,   411,     7,   300,   648,     7,   480,
      11,    12,    11,    12,   109,   428,     6,   241,   241,   640,
      52,     1,     2,   609,  -334,    11,    12,   444,   610,   422,
      52,   307,   358,   641,   344,   104,   303,   370,     8,    52,
     536,   412,   376,  -334,   414,   359,    18,    19,   240,    16,
     250,   407,   351,  -129,   511,   512,   383,   246,   246,   537,
     538,   423,   377,   432,   388,   430,   360,   186,   477,   363,
     247,   247,  -129,   187,   105,   217,   378,   352,   188,   217,
     -14,   471,   109,   454,   479,   481,     7,   384,   405,   353,
     354,   248,   248,    11,    12,   409,   410,   -65,   292,    52,
     466,   469,   379,   104,   406,   385,   230,   293,   474,     1,
       2,   386,   -65,  -220,   464,   389,     1,     2,   374,   375,
     513,  -220,   208,  -220,     1,     2,   485,   601,  -220,   606,
       6,   489,     7,     8,   484,   282,   493,    16,     1,     2,
     495,     8,   105,   498,    16,   618,   208,   496,     7,     6,
     500,   501,    16,   403,   413,     8,   434,   502,   503,   505,
     507,   509,   421,   -65,   240,   181,    16,   425,   182,   435,
      18,    19,   522,   443,   355,   447,   564,   199,   470,  -220,
     560,   532,   472,   535,   556,   557,   457,    52,   476,   459,
     558,   543,   458,   568,    52,   568,     1,     2,  -220,   553,
     463,   483,    52,   581,   494,   583,   488,  -252,   603,   487,
     228,     1,     2,     8,   559,    19,    52,   604,   491,   499,
     562,   515,   605,   268,    16,   563,   -16,   565,     8,   270,
     544,   555,   572,   548,   549,  -381,   315,   510,   573,    16,
     575,   580,   574,    18,    19,  -381,   454,     9,   396,   294,
    -381,  -381,   347,   594,    13,    14,    15,   306,  -381,  -381,
       6,   109,     7,   109,   469,   312,   313,   314,   554,    11,
      12,   585,   595,  -252,    52,   596,   524,   339,   602,   592,
     340,   592,   104,   617,   104,   607,   613,   361,   524,    52,
       1,     2,  -252,   254,   623,   616,   -44,   545,   627,   550,
     597,  -381,   633,   634,   546,   635,   -44,     8,   637,   636,
     -44,   -44,   -44,   646,   647,   547,   532,   651,    16,   652,
    -381,   105,   255,   105,   653,   629,   532,   -64,   292,   208,
     199,     7,   568,   209,   183,   184,   185,   293,   654,     1,
       2,   621,   -64,   655,   445,   586,   240,   588,   425,  -506,
     371,   400,  -506,  -506,   402,   401,     8,   372,   622,  -506,
     624,   465,   -44,  -506,  -506,  -506,   373,    16,    52,  -506,
     630,   626,  -506,  -506,   454,     1,     2,   283,   251,   291,
    -506,   -44,   584,   109,  -506,  -506,   469,   533,   612,     7,
     297,   568,     8,   -64,   536,   611,    11,    12,  -506,   527,
     642,   404,   473,    16,   104,   638,   639,   643,   226,   419,
     408,   417,   645,   223,   543,  -506,   543,    52,     1,     2,
     486,   593,   482,   416,   236,   429,   490,   418,   650,   420,
    -506,    13,    14,    15,  -506,     8,   516,   536,    18,    19,
     234,   266,     0,   105,     0,   431,    16,   433,     0,     0,
       0,     0,     0,    52,     0,     0,   537,   538,     0,   183,
     184,   185,     0,   631,     0,   632,    18,    19,     0,   -84,
     448,     0,     1,     2,   449,   -84,   361,   450,     0,   -84,
       0,     0,   -84,   -84,   -84,   -84,     0,   475,   451,     8,
     -84,   117,   -84,   -84,   118,     0,    52,   119,   120,   121,
      16,     0,   122,   123,   124,   -84,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   -84,   136,   137,   138,
     139,   140,   141,   142,   143,     0,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
      52,   168,   169,   170,   171,   172,   173,  -380,   316,     0,
       1,     2,     0,     0,     0,     0,     0,  -380,     0,     0,
       0,     0,  -380,  -380,     0,     0,     0,     0,     0,     0,
    -380,  -380,     0,     0,     1,     2,     0,     0,    16,     0,
       0,     0,     0,     0,   492,   561,     0,     0,     0,     1,
       2,     8,     0,     0,     0,     0,     0,     0,     0,   504,
     571,     0,    16,     0,     0,     0,     8,   317,     0,     0,
       0,     0,     0,  -380,   318,     0,   319,    16,     0,     0,
    -187,   271,     0,     1,     2,     0,  -187,     0,    52,     0,
    -187,     0,  -380,  -187,  -187,  -187,  -187,   587,     0,   589,
       8,  -187,   117,  -187,  -187,   118,     0,     0,   119,   120,
     121,    16,    52,   122,   123,   124,  -187,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    52,   136,   137,
     138,   139,   140,   141,   142,   143,     0,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,    52,   168,   169,   170,   171,   172,   173,  -508,   115,
       0,     1,     2,     0,     0,     0,  -508,     0,  -508,     0,
       0,     0,  -508,  -508,  -508,   116,     0,     0,     8,     0,
     117,  -508,  -508,   118,     0,     0,   119,   120,   121,    16,
       0,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,     0,   136,   137,   138,   139,
     140,   141,   142,   143,     0,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,    52,
     168,   169,   170,   171,   172,   173,  -181,   436,     0,  -181,
    -181,     0,  -181,     0,     0,     0,  -181,     0,     0,  -181,
    -181,  -181,  -181,     0,     0,     0,  -181,  -181,  -181,  -181,
    -181,     0,     0,     0,   437,   438,   439,  -181,     0,   440,
    -181,   441,  -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,
    -181,     0,  -181,     0,  -181,  -181,  -181,  -181,     0,     0,
    -181,  -181,     0,  -181,     0,     0,     0,     0,  -181,  -181,
    -181,  -181,  -181,     0,     0,     0,     0,  -181,  -181,  -181,
    -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,
    -181,  -181,  -192,   295,     0,     1,     2,     0,     3,     0,
       0,     0,  -192,     0,     0,     5,     6,  -192,     7,     0,
       0,     0,     8,     9,   282,    11,    12,     0,     0,     0,
      13,    14,    15,    16,     0,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,     0,    29,     0,
      31,    32,    33,    34,     0,     0,    35,    36,     0,    37,
       0,     0,     0,     0,    38,    39,    40,    41,  -192,     1,
       2,   517,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,     8,  -192,   117,     0,
       0,   118,   518,   519,   119,   120,   121,    16,     0,   122,
     123,   124,   520,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,   136,   137,   138,   139,   140,   141,
     142,   143,     0,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,    52,   168,   169,
     170,   171,   172,   173,     1,     2,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     7,     0,     0,
       0,     8,     0,   117,    11,    12,   118,     0,     0,   119,
     120,   121,    16,     0,   122,   123,   124,     0,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,     0,   136,
     137,   138,   139,   140,   141,   142,   143,     0,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,    52,   168,   169,   170,   171,   172,   173,     1,
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     8,     0,   117,     0,
       0,   118,   528,   529,   119,   120,   121,    16,     0,   122,
     123,   124,   530,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,   136,   137,   138,   139,   140,   141,
     142,   143,     0,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,    52,   168,   169,
     170,   171,   172,   173,     1,     2,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     8,     0,   117,     0,     0,   118,   528,   529,   119,
     120,   121,    16,     0,   122,   123,   124,     0,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,     0,   136,
     137,   138,   139,   140,   141,   142,   143,     0,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,    52,   168,   169,   170,   171,   172,   173,     1,
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     8,     0,   117,     0,
       0,   118,     0,     0,   119,   120,   121,    16,     0,   122,
     123,   124,   200,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,   136,   137,   138,   139,   140,   141,
     142,   143,     0,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,    52,   168,   169,
     170,   171,   172,   173,     1,     2,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   -15,     0,     0,     0,     0,
       0,     8,     0,   117,     0,     0,   118,     0,     0,   119,
     120,   121,    16,     0,   122,   123,   124,     0,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,     0,   136,
     137,   138,   139,   140,   141,   142,   143,     0,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,    52,   168,   169,   170,   171,   172,   173,     1,
       2,   497,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     8,     0,   117,     0,
       0,   118,     0,     0,   119,   120,   121,    16,     0,   122,
     123,   124,     0,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,   136,   137,   138,   139,   140,   141,
     142,   143,     0,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,    52,   168,   169,
     170,   171,   172,   173,     1,     2,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     8,     0,   117,     0,     0,   118,     0,     0,   119,
     120,   121,    16,     0,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,     0,   136,
     137,   138,   139,   140,   141,   142,   143,     0,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,    52,   168,   169,   170,   171,   172,   173,     1,
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     8,     0,   117,     0,
       0,   118,     0,     0,   119,   120,   121,    16,     0,   122,
     123,   124,   534,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,   136,   137,   138,   139,   140,   141,
     142,   143,     0,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,    52,   168,   169,
     170,   171,   172,   173,     1,     2,   552,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     8,     0,   117,     0,     0,   118,     0,     0,   119,
     120,   121,    16,     0,   122,   123,   124,     0,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,     0,   136,
     137,   138,   139,   140,   141,   142,   143,     0,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,    52,   168,   169,   170,   171,   172,   173,     1,
       2,   449,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     8,     0,   117,     0,
       0,   118,     0,     0,   119,   120,   121,    16,     0,   122,
     123,   124,     0,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,   136,   137,   138,   139,   140,   141,
     142,   143,     0,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,    52,   168,   169,
     170,   171,   172,   173,     1,     2,   644,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     8,     0,   117,     0,     0,   118,     0,     0,   119,
     120,   121,    16,     0,   122,   123,   124,     0,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,     0,   136,
     137,   138,   139,   140,   141,   142,   143,     0,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,    52,   168,   169,   170,   171,   172,   173,     1,
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     8,     0,   117,     0,
       0,   118,     0,     0,   119,   120,   121,    16,     0,   122,
     123,   124,     0,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,   136,   137,   138,   139,   140,   141,
     142,   143,     0,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,    52,   168,   169,
     170,   171,   172,   173,     1,     2,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   208,     0,     7,     0,   209,
       0,     8,     0,   117,     0,     0,     0,     0,     0,     0,
       0,     0,    16,     0,     0,     0,     0,     0,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,     0,   136,
     137,   138,   139,   140,   141,   142,   143,     0,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,    52,   168,   169,   170,   171,   172,   173,     1,
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     7,     0,     0,     0,     8,     0,   117,     0,
       0,     0,     0,     0,     0,     0,     0,    16,     0,     0,
       0,     0,     0,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,   136,   137,   138,   139,   140,   141,
     142,   143,     0,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,    52,   168,   169,
     170,   171,   172,   173,     1,     2,   649,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     8,     0,   117,     0,     0,     0,     0,     0,     0,
       0,     0,    16,     0,     0,     0,     0,     0,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,     0,   136,
     137,   138,   139,   140,   141,   142,   143,     0,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,    52,   168,   169,   170,   171,   172,   173,     1,
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     8,     0,   117,     0,
       0,     0,     0,     0,     0,     0,     0,    16,     0,     0,
       0,     0,     0,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,     0,   136,   137,   138,   139,   140,   141,
     142,   143,     0,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,    52,   168,   169,
     170,   171,   172,   173,   -86,   577,     0,   -86,   -86,     0,
     -86,     0,   578,     0,   -86,     0,     0,   -86,   -86,   -86,
     -86,     0,     0,   579,   -86,   -86,   -86,   -86,   -86,     0,
       0,     0,   -86,   -86,   -86,   -86,     0,     0,   -86,   -86,
     -86,   -86,   -86,   -86,   -86,   -86,   -86,   -86,   -86,   -86,
     -86,   -86,   -86,   -86,   -86,   -86,     0,     0,   -86,   -86,
       0,   -86,     0,     0,     0,     0,   -86,   -86,   -86,   -86,
     -86,     0,     0,     0,     0,   -86,   -86,   -86,   -86,   -86,
     -86,   -86,   -86,   -86,   -86,   -86,   -86,   -86,   -73,   285,
       0,   -73,   -73,     0,   -73,     0,     0,     0,   286,     0,
       0,   -73,   -73,   -73,   -73,     0,   287,     0,   -73,   -73,
     -73,   -73,   -73,     0,     0,     0,   -73,   -73,   -73,   -73,
       0,     0,   -73,   -73,   -73,   -73,   -73,   -73,   -73,   -73,
     -73,   -73,   -73,   -73,   -73,   -73,   -73,   -73,   -73,   -73,
       0,     0,   -73,   -73,     0,   -73,     0,     0,     0,     0,
     -73,   -73,   -73,   -73,   -73,     0,     0,     0,     0,   -73,
     -73,   -73,   -73,   -73,   -73,   -73,   -73,   -73,   -73,   -73,
     -73,   -73,   -78,   289,     0,   -78,   -78,     0,   -78,     0,
       0,     0,   290,     0,     0,   -78,   -78,   -78,   -78,     0,
       0,     0,   -78,   -78,   -78,   -78,   -78,     0,     0,     0,
     -78,   -78,   -78,   -78,     0,     0,   -78,   -78,   -78,   -78,
     -78,   -78,   -78,   -78,   -78,   -78,   -78,   -78,   -78,   -78,
     -78,   -78,   -78,   -78,     0,     0,   -78,   -78,     0,   -78,
       0,     0,     0,     0,   -78,   -78,   -78,   -78,   -78,     0,
       0,     0,     0,   -78,   -78,   -78,   -78,   -78,   -78,   -78,
     -78,   -78,   -78,   -78,   -78,   -78,   -76,   455,     0,   -76,
     -76,     0,   -76,     0,     0,     0,   456,     0,     0,   -76,
     -76,   -76,   -76,     0,     0,     0,   -76,   -76,   -76,   -76,
     -76,     0,     0,     0,   -76,   -76,   -76,   -76,     0,     0,
     -76,   -76,   -76,   -76,   -76,   -76,   -76,   -76,   -76,   -76,
     -76,   -76,   -76,   -76,   -76,   -76,   -76,   -76,     0,     0,
     -76,   -76,     0,   -76,     0,     0,     0,     0,   -76,   -76,
     -76,   -76,   -76,     0,     0,     0,     0,   -76,   -76,   -76,
     -76,   -76,   -76,   -76,   -76,   -76,   -76,   -76,   -76,   -76,
     362,     0,     0,     1,     2,     0,     3,     0,     0,     0,
       4,     0,     0,     5,     6,   363,     7,     0,     0,     0,
       8,     9,   282,    11,    12,     0,     0,     0,    13,    14,
      15,    16,     0,     0,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,     0,     0,    35,    36,     0,    37,     0,     0,
       0,     0,    38,    39,    40,    41,   364,     0,     0,     0,
       0,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,   395,     0,     0,     1,     2,     0,
       3,     0,     0,     0,     4,     0,     0,     5,     6,   396,
       7,     0,     0,     0,     8,     9,   282,    11,    12,     0,
       0,     0,    13,    14,    15,    16,     0,     0,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,     0,     0,    35,    36,
       0,    37,     0,     0,     0,     0,    38,    39,    40,    41,
     397,     0,     0,     0,     0,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,   346,   347,
       0,     0,     1,     2,     0,     0,     6,     0,     7,     0,
       0,     0,   506,     9,     0,    11,    12,     0,     0,     8,
      13,    14,    15,   348,   349,   350,     0,    18,    19,     0,
      16,   346,     0,     0,     0,     1,     2,     0,     0,     0,
       0,   351,     0,     0,     0,   508,     9,     0,     0,     0,
       0,     0,     8,    13,    14,    15,   348,   349,   350,     0,
       0,     0,     0,    16,     1,     2,   352,     3,     0,     0,
       0,     4,     0,     0,     5,     6,     0,     7,   353,   354,
      52,     8,     9,    10,    11,    12,     0,     0,     0,    13,
      14,    15,    16,     0,     0,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    52,     0,    35,    36,     0,    37,     0,
       0,     0,     0,    38,    39,    40,    41,     0,     0,     0,
       0,     0,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,     1,     2,     0,     3,     0,
       0,     0,     4,     0,     0,     5,     6,     0,     7,     0,
       0,     0,     8,     9,   282,    11,    12,     0,     0,     0,
      13,    14,    15,    16,     0,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,     0,     0,    35,    36,     0,    37,
       0,     0,     0,     0,    38,    39,    40,    41,     0,     0,
       0,     0,     0,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,     1,     2,     0,     3,
       0,     0,     0,     0,     0,     0,     5,     6,     0,     7,
       0,     0,     0,     8,     9,   282,    11,    12,     0,     0,
       0,    13,    14,    15,    16,     0,     0,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,     0,    29,
       0,    31,    32,    33,    34,     0,     0,    35,    36,     0,
      37,     0,     0,     0,     0,    38,    39,    40,    41,     0,
       0,     0,     0,     0,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,     1,     2,     0,
       3,     0,     0,     0,     0,     0,     0,     5,     6,     0,
       7,     0,     0,     0,     8,     9,   282,    11,    12,     0,
       0,     0,    13,    14,    15,    16,     0,     0,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,     0,
      29,     0,    31,    32,    33,    34,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,    38,    39,    40,    41,
       0,     1,     2,     0,     0,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,     0,    54,     8,   236,
       0,     0,     0,     0,     0,     0,    13,    14,    15,    16,
       0,     0,     0,    18,    19,     0,     0,     0,     0,     0,
       0,     1,     2,     0,     0,     0,   237,   238,     0,     0,
       0,     0,     0,     0,     7,     0,   239,   240,     8,   236,
       0,    11,    12,     0,     0,     0,    13,    14,    15,    16,
       0,     0,     0,    18,    19,     1,     2,   251,   254,    52,
       0,     0,     0,     1,     2,     0,     3,     0,     7,     0,
       0,     0,     8,     5,     0,    11,    12,   240,     0,     0,
       8,     9,     0,    16,     1,     2,     0,   255,    13,    14,
      15,    16,     0,     0,    17,     6,     0,     7,     0,    52,
       0,     8,     0,     0,    11,    12,     0,     0,     0,     0,
       0,     0,    16,   256,     0,     0,    18,    19,     1,     2,
       0,     0,     0,     0,     0,     0,     0,   257,     0,     0,
       0,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,    52,     0,   119,   120,   121,    16,     0,   122,   123,
     124,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    52,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   263,    52
};

static const yytype_int16 yycheck[] =
{
       7,     0,    51,     7,     3,    37,    57,    64,   209,    33,
      44,   429,   296,     5,    43,    72,   399,    24,   450,   110,
      27,    28,     0,   262,    23,   264,     5,   365,     3,     4,
       0,     1,    31,    32,    33,    34,     0,     1,    37,     0,
       1,     0,    23,    24,    43,    37,    10,     5,    21,    10,
      54,    15,     0,     1,    15,     6,    31,    91,    37,     0,
      84,     0,    10,     3,     4,    64,    14,    15,    16,    68,
       6,    19,    20,    72,    15,    74,     6,   109,     6,    37,
      20,    20,    21,    22,    35,    84,    64,    86,    27,    21,
      68,    31,    28,    68,    72,    34,    66,    96,    97,    98,
      30,    29,    66,     1,     6,    66,    81,    66,    32,    21,
       8,   110,    10,   112,   113,   114,     6,   109,    66,    21,
      81,    85,   213,    16,    85,    64,   520,   105,    30,    68,
     109,    21,   110,    72,    58,   186,   530,    85,    28,    78,
       3,    81,     3,     4,    20,     7,   578,     4,   566,    16,
      12,   109,     3,     4,    78,    79,    23,    24,     0,     1,
      84,     3,     4,    87,     0,   104,   549,     6,    10,    20,
      31,   110,    14,    15,   512,     0,    27,   461,    20,    15,
      31,   105,    21,   187,   188,   109,    14,     0,     1,    31,
      29,   430,    59,    35,    36,   244,    15,    10,   230,     8,
       8,    14,    15,    16,   236,    16,     8,   625,    16,    70,
      23,    24,    23,    24,   213,   264,    14,   249,   250,     1,
      81,     3,     4,     7,    66,    23,    24,   278,    12,   258,
      81,     8,   224,    15,     9,   213,    49,    17,    20,    81,
      22,   240,     7,    85,   243,   224,    35,    36,    59,    31,
     249,   229,    49,    66,     0,     1,    14,   249,   250,    41,
      42,   260,    21,   267,   203,   264,   224,     1,   317,    15,
     249,   250,    85,     7,   213,   214,    21,    74,    12,   218,
      14,   305,   281,   287,   318,   319,    16,     8,   227,    86,
      87,   249,   250,    23,    24,   234,   235,     0,     1,    81,
     299,   300,    21,   281,   228,     7,   305,    10,   307,     3,
       4,     8,    15,     0,     1,    14,     3,     4,   178,   179,
      66,     8,    14,    10,     3,     4,   325,   523,    15,   525,
      14,   330,    16,    20,    13,    22,   335,    31,     3,     4,
     344,    20,   281,   347,    31,   546,    14,   346,    16,    14,
     349,   350,    31,     7,    21,    20,    84,   356,   357,   358,
     359,   360,    75,    66,    59,   372,    31,    61,   372,    84,
      35,    36,   376,    10,   298,    10,   425,   384,   302,    66,
     412,   385,   306,   387,     5,     6,    10,    81,   312,    85,
      11,   390,    10,   427,    81,   429,     3,     4,    85,   403,
       8,    21,    81,   460,   343,   462,    13,     0,     1,    21,
      32,     3,     4,    20,    35,    36,    81,    10,    21,     6,
     419,    17,    15,    45,    31,   424,    14,   426,    20,    51,
      19,    21,   436,     0,     1,     0,     1,   361,   442,    31,
      19,    10,   446,    35,    36,    10,   450,    21,    15,    71,
      15,    16,     7,    21,    28,    29,    30,    79,    23,    24,
      14,   460,    16,   462,   463,    87,    88,    89,   407,    23,
      24,     8,    21,    66,    81,    21,    81,    99,     5,   478,
     102,   480,   460,    19,   462,    10,    10,   109,    81,    81,
       3,     4,    85,     6,     5,     7,     0,     1,    19,    66,
     499,    66,     5,    10,     8,     5,    10,    20,    10,    15,
      14,    15,    16,     5,     5,    19,   520,    15,    31,     5,
      85,   460,    35,   462,     5,   582,   530,     0,     1,    14,
     537,    16,   566,    18,    28,    29,    30,    10,     5,     3,
       4,     5,    15,     5,   281,   469,    59,   471,    61,     0,
       1,   214,     3,     4,   218,   217,    20,     8,   557,    10,
     559,   299,    66,    14,    15,    16,    17,    31,    81,    20,
     585,   570,    23,    24,   578,     3,     4,    64,     5,    68,
      31,    85,   463,   582,    35,    36,   585,   386,   538,    16,
      74,   625,    20,    66,    22,   537,    23,    24,    49,   384,
     613,   223,   307,    31,   582,   609,   610,   615,    32,   250,
     232,   249,   616,    31,   613,    66,   615,    81,     3,     4,
     327,   480,   322,   245,    21,   264,   332,   249,   635,   251,
      81,    28,    29,    30,    85,    20,   372,    22,    35,    36,
      34,    44,    -1,   582,    -1,   267,    31,   269,    -1,    -1,
      -1,    -1,    -1,    81,    -1,    -1,    41,    42,    -1,    28,
      29,    30,    -1,   587,    -1,   589,    35,    36,    -1,     0,
       1,    -1,     3,     4,     5,     6,   298,     8,    -1,    10,
      -1,    -1,    13,    14,    15,    16,    -1,   309,    19,    20,
      21,    22,    23,    24,    25,    -1,    81,    28,    29,    30,
      31,    -1,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    -1,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,     0,     1,    -1,
       3,     4,    -1,    -1,    -1,    -1,    -1,    10,    -1,    -1,
      -1,    -1,    15,    16,    -1,    -1,    -1,    -1,    -1,    -1,
      23,    24,    -1,    -1,     3,     4,    -1,    -1,    31,    -1,
      -1,    -1,    -1,    -1,    13,   417,    -1,    -1,    -1,     3,
       4,    20,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,
     432,    -1,    31,    -1,    -1,    -1,    20,    60,    -1,    -1,
      -1,    -1,    -1,    66,    67,    -1,    69,    31,    -1,    -1,
       0,     1,    -1,     3,     4,    -1,     6,    -1,    81,    -1,
      10,    -1,    85,    13,    14,    15,    16,   469,    -1,   471,
      20,    21,    22,    23,    24,    25,    -1,    -1,    28,    29,
      30,    31,    81,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    81,    48,    49,
      50,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,     0,     1,
      -1,     3,     4,    -1,    -1,    -1,     8,    -1,    10,    -1,
      -1,    -1,    14,    15,    16,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    -1,    -1,    28,    29,    30,    31,
      -1,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    -1,    48,    49,    50,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,     0,     1,    -1,     3,
       4,    -1,     6,    -1,    -1,    -1,    10,    -1,    -1,    13,
      14,    15,    16,    -1,    -1,    -1,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    28,    29,    30,    31,    -1,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    -1,    46,    -1,    48,    49,    50,    51,    -1,    -1,
      54,    55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,
      64,    65,    66,    -1,    -1,    -1,    -1,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,     0,     1,    -1,     3,     4,    -1,     6,    -1,
      -1,    -1,    10,    -1,    -1,    13,    14,    15,    16,    -1,
      -1,    -1,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      28,    29,    30,    31,    -1,    -1,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    -1,    46,    -1,
      48,    49,    50,    51,    -1,    -1,    54,    55,    -1,    57,
      -1,    -1,    -1,    -1,    62,    63,    64,    65,    66,     3,
       4,     5,    -1,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    20,    85,    22,    -1,
      -1,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     3,     4,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    16,    -1,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    -1,    -1,    28,
      29,    30,    31,    -1,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,     3,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,    22,    -1,
      -1,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     3,     4,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    20,    -1,    22,    -1,    -1,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,     3,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,    22,    -1,
      -1,    25,    -1,    -1,    28,    29,    30,    31,    -1,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     3,     4,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    14,    -1,    -1,    -1,    -1,
      -1,    20,    -1,    22,    -1,    -1,    25,    -1,    -1,    28,
      29,    30,    31,    -1,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,     3,
       4,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,    22,    -1,
      -1,    25,    -1,    -1,    28,    29,    30,    31,    -1,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     3,     4,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    20,    -1,    22,    -1,    -1,    25,    -1,    -1,    28,
      29,    30,    31,    -1,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,     3,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,    22,    -1,
      -1,    25,    -1,    -1,    28,    29,    30,    31,    -1,    33,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     3,     4,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    20,    -1,    22,    -1,    -1,    25,    -1,    -1,    28,
      29,    30,    31,    -1,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,     3,
       4,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,    22,    -1,
      -1,    25,    -1,    -1,    28,    29,    30,    31,    -1,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     3,     4,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    20,    -1,    22,    -1,    -1,    25,    -1,    -1,    28,
      29,    30,    31,    -1,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,     3,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,    22,    -1,
      -1,    25,    -1,    -1,    28,    29,    30,    31,    -1,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     3,     4,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    14,    -1,    16,    -1,    18,
      -1,    20,    -1,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    31,    -1,    -1,    -1,    -1,    -1,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,     3,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    16,    -1,    -1,    -1,    20,    -1,    22,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    31,    -1,    -1,
      -1,    -1,    -1,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     3,     4,     5,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    20,    -1,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    31,    -1,    -1,    -1,    -1,    -1,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,     3,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,    22,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    31,    -1,    -1,
      -1,    -1,    -1,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    -1,    48,    49,    50,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,     0,     1,    -1,     3,     4,    -1,
       6,    -1,     8,    -1,    10,    -1,    -1,    13,    14,    15,
      16,    -1,    -1,    19,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    28,    29,    30,    31,    -1,    -1,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    -1,    -1,    54,    55,
      -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,
      66,    -1,    -1,    -1,    -1,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,     0,     1,
      -1,     3,     4,    -1,     6,    -1,    -1,    -1,    10,    -1,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    28,    29,    30,    31,
      -1,    -1,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      -1,    -1,    54,    55,    -1,    57,    -1,    -1,    -1,    -1,
      62,    63,    64,    65,    66,    -1,    -1,    -1,    -1,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,     0,     1,    -1,     3,     4,    -1,     6,    -1,
      -1,    -1,    10,    -1,    -1,    13,    14,    15,    16,    -1,
      -1,    -1,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      28,    29,    30,    31,    -1,    -1,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    -1,    -1,    54,    55,    -1,    57,
      -1,    -1,    -1,    -1,    62,    63,    64,    65,    66,    -1,
      -1,    -1,    -1,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,     0,     1,    -1,     3,
       4,    -1,     6,    -1,    -1,    -1,    10,    -1,    -1,    13,
      14,    15,    16,    -1,    -1,    -1,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    28,    29,    30,    31,    -1,    -1,
      34,    35,    36,    37,    38,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    -1,    -1,
      54,    55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,
      64,    65,    66,    -1,    -1,    -1,    -1,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
       0,    -1,    -1,     3,     4,    -1,     6,    -1,    -1,    -1,
      10,    -1,    -1,    13,    14,    15,    16,    -1,    -1,    -1,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    28,    29,
      30,    31,    -1,    -1,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    -1,    -1,    54,    55,    -1,    57,    -1,    -1,
      -1,    -1,    62,    63,    64,    65,    66,    -1,    -1,    -1,
      -1,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,     0,    -1,    -1,     3,     4,    -1,
       6,    -1,    -1,    -1,    10,    -1,    -1,    13,    14,    15,
      16,    -1,    -1,    -1,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    28,    29,    30,    31,    -1,    -1,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    -1,    -1,    54,    55,
      -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,
      66,    -1,    -1,    -1,    -1,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,     6,     7,
      -1,    -1,     3,     4,    -1,    -1,    14,    -1,    16,    -1,
      -1,    -1,    13,    21,    -1,    23,    24,    -1,    -1,    20,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    -1,
      31,     6,    -1,    -1,    -1,     3,     4,    -1,    -1,    -1,
      -1,    49,    -1,    -1,    -1,    13,    21,    -1,    -1,    -1,
      -1,    -1,    20,    28,    29,    30,    31,    32,    33,    -1,
      -1,    -1,    -1,    31,     3,     4,    74,     6,    -1,    -1,
      -1,    10,    -1,    -1,    13,    14,    -1,    16,    86,    87,
      81,    20,    21,    22,    23,    24,    -1,    -1,    -1,    28,
      29,    30,    31,    -1,    -1,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    81,    -1,    54,    55,    -1,    57,    -1,
      -1,    -1,    -1,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,     3,     4,    -1,     6,    -1,
      -1,    -1,    10,    -1,    -1,    13,    14,    -1,    16,    -1,
      -1,    -1,    20,    21,    22,    23,    24,    -1,    -1,    -1,
      28,    29,    30,    31,    -1,    -1,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    -1,    -1,    54,    55,    -1,    57,
      -1,    -1,    -1,    -1,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,     3,     4,    -1,     6,
      -1,    -1,    -1,    -1,    -1,    -1,    13,    14,    -1,    16,
      -1,    -1,    -1,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    28,    29,    30,    31,    -1,    -1,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    -1,    46,
      -1,    48,    49,    50,    51,    -1,    -1,    54,    55,    -1,
      57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,     3,     4,    -1,
       6,    -1,    -1,    -1,    -1,    -1,    -1,    13,    14,    -1,
      16,    -1,    -1,    -1,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    28,    29,    30,    31,    -1,    -1,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    -1,
      46,    -1,    48,    49,    50,    51,    -1,    -1,    -1,    -1,
      -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,    65,
      -1,     3,     4,    -1,    -1,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    -1,    83,    20,    21,
      -1,    -1,    -1,    -1,    -1,    -1,    28,    29,    30,    31,
      -1,    -1,    -1,    35,    36,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,    -1,    -1,    -1,    48,    49,    -1,    -1,
      -1,    -1,    -1,    -1,    16,    -1,    58,    59,    20,    21,
      -1,    23,    24,    -1,    -1,    -1,    28,    29,    30,    31,
      -1,    -1,    -1,    35,    36,     3,     4,     5,     6,    81,
      -1,    -1,    -1,     3,     4,    -1,     6,    -1,    16,    -1,
      -1,    -1,    20,    13,    -1,    23,    24,    59,    -1,    -1,
      20,    21,    -1,    31,     3,     4,    -1,    35,    28,    29,
      30,    31,    -1,    -1,    34,    14,    -1,    16,    -1,    81,
      -1,    20,    -1,    -1,    23,    24,    -1,    -1,    -1,    -1,
      -1,    -1,    31,    61,    -1,    -1,    35,    36,     3,     4,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    75,    -1,    -1,
      -1,    -1,    -1,    81,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    81,    -1,    28,    29,    30,    31,    -1,    33,    34,
      35,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    80,    81
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,     4,     6,    10,    13,    14,    16,    20,    21,
      22,    23,    24,    28,    29,    30,    31,    34,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    54,    55,    57,    62,    63,
      64,    65,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    90,    92,    93,    94,    95,
      96,    97,   108,   109,   110,   111,   112,   116,   117,   118,
     119,   120,   124,   126,   131,   132,   133,   136,   153,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   165,   170,
     171,   172,   174,   175,   176,   177,   181,   182,   183,   190,
     191,   192,   193,   194,   195,   197,   201,   206,   208,   209,
     212,   209,   181,   182,   183,     1,    17,    22,    25,    28,
      29,    30,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    48,    49,    50,    51,
      52,    53,    54,    55,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    82,    83,
      84,    85,    86,    87,   198,   199,   202,   203,   204,   205,
     209,   210,   211,    28,    29,    30,     1,     7,    12,    21,
      21,    21,   197,   197,   197,   140,   209,   143,   146,   210,
      36,   137,   138,   139,   210,   211,     3,   147,    14,    18,
      98,    99,   100,   101,   103,   104,   107,   197,   210,   210,
      20,   106,     4,   170,   209,    95,   158,   195,   196,   197,
     209,     1,   163,   197,   202,   209,    21,    48,    49,    58,
      59,   162,   166,   167,   168,   169,   181,   182,   183,   200,
     209,     5,   127,   196,     6,    35,    61,    75,   121,   127,
     128,   129,   209,    80,   189,   201,   203,    59,   196,   166,
     196,     1,   123,   211,     0,     0,    66,    91,     1,    91,
      95,    15,    22,   111,   118,     1,    10,    18,   113,     1,
      10,   119,     1,    10,   196,     1,   118,   136,   209,     8,
       8,    95,   197,    49,    95,   154,   196,     8,    95,   163,
     209,    95,   196,   196,   196,     1,     1,    60,    67,    69,
     201,     6,    21,    28,   178,   184,     6,    21,    29,   179,
     185,     6,    21,    30,   180,   186,   209,   209,   209,   196,
     196,   197,    95,   195,     9,   207,     6,     7,    31,    32,
      33,    49,    74,    86,    87,    95,   162,   164,   181,   182,
     183,   196,     0,    15,    66,   109,   213,   209,   209,   209,
      17,     1,     8,    17,   207,   207,     7,    21,    21,    21,
      91,   211,   211,    14,     8,     7,     8,     8,   197,    14,
     148,     1,    19,   105,   106,     0,    15,    66,   102,   109,
     100,   107,    99,     7,   196,   197,    95,   195,   196,   197,
     197,   162,   209,    21,   209,   166,   196,   169,   196,   167,
     196,    75,   127,   209,   128,    61,   128,   130,   166,   188,
     209,   196,   211,   196,    84,    84,     1,    28,    29,    30,
      33,    35,   122,    10,    91,    93,     7,    10,     1,     5,
       8,    19,   114,   115,   211,     1,    10,    10,    10,    85,
     125,     1,   125,     8,     1,   133,   209,   134,   135,   209,
      95,   163,    95,   156,   209,   196,    95,   166,    68,   201,
      70,   201,   178,    21,    13,   209,   179,    21,    13,   209,
     180,    21,    13,   209,   197,   211,   209,     5,   211,     6,
     209,   209,   209,   209,    13,   209,    13,   209,    13,   209,
      95,     0,     1,    66,   213,    17,   199,     5,    26,    27,
      36,   144,   211,     1,    81,   141,   142,   146,    26,    27,
      36,   145,   211,   138,    36,   211,    22,    41,    42,   149,
     150,   151,   152,   209,    19,     1,     8,    19,     0,     1,
      66,   102,     5,   211,   197,    21,     5,     6,    11,    35,
     162,   196,   209,   209,   166,   209,   187,   188,   201,   187,
     128,   196,   211,   211,   211,    19,   115,     1,     8,    19,
      10,   118,   125,   118,   134,     8,    95,   196,    95,   196,
      27,   173,   209,   173,    21,    21,    21,   209,     0,   213,
     145,   142,     5,     1,    10,    15,   142,    10,   145,     7,
      12,   143,   137,    10,     1,     8,     7,    19,   106,     0,
     102,     5,   209,     5,   209,   187,   209,    19,   115,   118,
     135,    95,    95,     5,    10,     5,    15,    10,   211,   211,
       1,    15,   150,   152,     5,   211,     5,     5,   187,     5,
     210,    15,     5,     5,     5,     5
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    89,    90,    91,    91,    91,    92,    92,    92,    92,
      92,    93,    93,    93,    94,    94,    94,    95,    95,    95,
      95,    95,    95,    95,    95,    96,    97,    97,    98,    98,
      98,    99,    99,    99,   100,   100,   100,   101,   102,   103,
     104,   104,   104,   104,   104,   104,   105,   105,   105,   106,
     106,   106,   106,   107,   107,   107,   107,   107,   107,   107,
     107,   108,   108,   109,   109,   109,   110,   110,   111,   111,
     111,   111,   111,   111,   111,   111,   111,   111,   111,   111,
     112,   112,   113,   113,   113,   113,   113,   113,   114,   114,
     114,   114,   114,   115,   115,   116,   116,   117,   117,   117,
     118,   118,   118,   119,   119,   119,   119,   119,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   119,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   119,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   119,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   119,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   119,   119,   119,
     119,   119,   119,   119,   119,   119,   119,   119,   119,   119,
     120,   120,   121,   121,   121,   121,   122,   122,   122,   122,
     122,   123,   123,   123,   123,   124,   124,   124,   124,   124,
     125,   126,   126,   126,   126,   126,   126,   126,   126,   126,
     127,   127,   127,   128,   128,   129,   129,   129,   129,   129,
     130,   130,   130,   130,   131,   131,   131,   131,   132,   132,
     132,   132,   133,   133,   133,   133,   133,   133,   133,   134,
     134,   134,   135,   135,   135,   135,   136,   136,   136,   136,
     137,   137,   137,   138,   138,   139,   139,   139,   139,   139,
     140,   140,   140,   140,   140,   141,   141,   141,   141,   141,
     141,   141,   141,   142,   142,   142,   142,   142,   142,   142,
     142,   142,   143,   143,   143,   144,   144,   145,   145,   145,
     146,   146,   146,   146,   147,   147,   148,   149,   149,   150,
     150,   150,   150,   150,   151,   151,   151,   151,   152,   152,
     152,   152,   152,   152,   152,   153,   153,   153,   153,   153,
     154,   154,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   156,   156,   157,   157,   158,   158,
     158,   158,   159,   159,   159,   159,   160,   160,   160,   161,
     161,   162,   162,   163,   163,   163,   163,   164,   164,   164,
     164,   165,   166,   166,   166,   166,   166,   166,   166,   166,
     166,   166,   166,   166,   167,   167,   167,   167,   167,   167,
     167,   168,   168,   168,   168,   168,   169,   169,   169,   170,
     170,   170,   170,   170,   171,   171,   171,   171,   171,   171,
     171,   171,   172,   172,   172,   172,   173,   173,   173,   174,
     174,   174,   174,   174,   174,   174,   174,   174,   174,   174,
     175,   175,   175,   175,   175,   175,   175,   175,   175,   176,
     176,   176,   176,   176,   176,   176,   176,   176,   177,   177,
     177,   177,   177,   177,   177,   177,   177,   178,   178,   179,
     179,   180,   180,   181,   181,   181,   181,   182,   182,   182,
     182,   183,   183,   183,   183,   184,   184,   184,   184,   185,
     185,   185,   185,   186,   186,   186,   186,   187,   187,   188,
     188,   189,   189,   189,   190,   190,   190,   190,   190,   190,
     190,   190,   190,   190,   191,   191,   192,   192,   192,   192,
     193,   193,   193,   194,   194,   195,   195,   196,   196,   196,
     196,   196,   197,   197,   197,   197,   197,   197,   197,   197,
     198,   198,   198,   199,   199,   199,   199,   199,   199,   199,
     199,   200,   200,   200,   201,   201,   201,   201,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   202,   202,   202,
     202,   202,   202,   202,   202,   202,   202,   203,   203,   203,
     203,   203,   203,   204,   205,   205,   206,   207,   207,   208,
     208,   209,   209,   210,   210,   210,   211,   211,   211,   212,
     213
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     2,     1,     1,     2,     0,     2,     3,     2,
       3,     1,     2,     3,     1,     2,     3,     3,     2,     4,
       4,     3,     2,     3,     2,     1,     1,     2,     1,     2,
       1,     1,     2,     1,     1,     2,     1,     1,     1,     1,
       2,     3,     1,     4,     2,     3,     1,     2,     3,     1,
       2,     3,     3,     3,     2,     4,     4,     3,     2,     3,
       2,     2,     1,     1,     2,     1,     1,     2,     2,     1,
       3,     2,     3,     1,     3,     4,     2,     2,     1,     3,
       1,     2,     2,     3,     1,     4,     2,     3,     1,     1,
       2,     2,     3,     1,     1,     1,     2,     1,     1,     1,
       1,     2,     1,     1,     2,     1,     2,     3,     1,     2,
       3,     2,     3,     4,     3,     1,     1,     2,     3,     2,
       1,     1,     2,     2,     3,     3,     4,     1,     1,     1,
       1,     1,     2,     1,     2,     1,     2,     1,     2,     1,
       1,     1,     1,     2,     1,     2,     2,     1,     1,     2,
       3,     2,     1,     2,     3,     2,     2,     3,     1,     2,
       1,     1,     1,     3,     2,     1,     2,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     3,     3,     2,     1,     2,     3,
       1,     2,     1,     2,     3,     4,     3,     4,     5,     4,
       1,     1,     2,     1,     1,     2,     2,     1,     3,     1,
       2,     2,     1,     3,     1,     1,     1,     1,     1,     3,
       2,     3,     3,     3,     2,     3,     2,     3,     2,     1,
       3,     2,     2,     1,     3,     2,     2,     1,     3,     2,
       1,     3,     2,     2,     1,     1,     1,     2,     3,     3,
       1,     2,     3,     4,     5,     2,     1,     3,     2,     3,
       2,     2,     2,     1,     2,     3,     4,     5,     4,     5,
       6,     7,     1,     3,     2,     1,     1,     1,     1,     1,
       3,     4,     2,     1,     5,     6,     1,     1,     3,     2,
       1,     2,     1,     1,     1,     3,     2,     2,     3,     3,
       2,     3,     3,     2,     2,     1,     2,     2,     3,     2,
       0,     1,     1,     1,     2,     3,     2,     2,     3,     4,
       4,     5,     2,     3,     1,     2,     1,     3,     1,     2,
       2,     3,     2,     2,     1,     3,     1,     2,     3,     1,
       2,     1,     1,     3,     2,     2,     1,     1,     1,     1,
       1,     3,     2,     3,     3,     4,     3,     4,     3,     4,
       4,     5,     5,     1,     1,     2,     2,     3,     1,     1,
       1,     3,     2,     2,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     3,     3,     2,
       3,     3,     1,     3,     4,     4,     1,     2,     1,     1,
       1,     1,     3,     3,     4,     2,     3,     3,     2,     2,
       3,     1,     2,     3,     2,     3,     3,     2,     3,     3,
       1,     2,     3,     2,     3,     3,     2,     3,     3,     2,
       1,     3,     2,     3,     3,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     3,     1,     2,     2,
       3,     1,     2,     2,     3,     1,     2,     2,     3,     1,
       2,     2,     3,     1,     2,     2,     3,     1,     1,     2,
       1,     1,     1,     1,     4,     5,     6,     3,     4,     3,
       3,     3,     2,     1,     1,     2,     4,     2,     2,     3,
       1,     1,     1,     2,     1,     1,     1,     1,     2,     3,
       2,     1,     2,     3,     4,     3,     2,     3,     1,     2,
       1,     3,     2,     3,     3,     4,     3,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     2,     1,     1,     2,     1,     1,     2,     1,
       1
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, RESULT, yyscanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#  define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value, Location, RESULT, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  YYUSE (yylocationp);
  YYUSE (RESULT);
  YYUSE (yyscanner);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yytype], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  YY_LOCATION_PRINT (yyo, *yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yytype, yyvaluep, yylocationp, RESULT, yyscanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[+yyssp[yyi + 1 - yynrhs]],
                       &yyvsp[(yyi + 1) - (yynrhs)]
                       , &(yylsp[(yyi + 1) - (yynrhs)])                       , RESULT, yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, RESULT, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
#  else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                yy_state_t *yyssp, int yytoken)
{
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Actual size of YYARG. */
  int yycount = 0;
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[+*yyssp];
      YYPTRDIFF_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
      yysize = yysize0;
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYPTRDIFF_T yysize1
                    = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
                    yysize = yysize1;
                  else
                    return 2;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    /* Don't count the "%s"s in the final size, but reserve room for
       the terminator.  */
    YYPTRDIFF_T yysize1 = yysize + (yystrlen (yyformat) - 2 * yycount) + 1;
    if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
      yysize = yysize1;
    else
      return 2;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (RESULT);
  YYUSE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yytype)
    {
    case 3: /* TOK_STRING  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2557 "msc_lang.cc"
        break;

    case 4: /* TOK_QSTRING  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2563 "msc_lang.cc"
        break;

    case 5: /* TOK_NUMBER  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2569 "msc_lang.cc"
        break;

    case 14: /* TOK_OCBRACKET  */
#line 199 "msc_lang.yy"
            {}
#line 2575 "msc_lang.cc"
        break;

    case 15: /* TOK_CCBRACKET  */
#line 199 "msc_lang.yy"
            {}
#line 2581 "msc_lang.cc"
        break;

    case 20: /* TOK_PARAM_NAME  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2587 "msc_lang.cc"
        break;

    case 22: /* TOK_MSC  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2593 "msc_lang.cc"
        break;

    case 23: /* TOK_COLON_STRING  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2599 "msc_lang.cc"
        break;

    case 24: /* TOK_COLON_QUOTED_STRING  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2605 "msc_lang.cc"
        break;

    case 25: /* TOK_STYLE_NAME  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2611 "msc_lang.cc"
        break;

    case 26: /* TOK_COLORDEF  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2617 "msc_lang.cc"
        break;

    case 27: /* TOK_COLORDEF_NAME_NUMBER  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2623 "msc_lang.cc"
        break;

    case 31: /* TOK_REL_X  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2629 "msc_lang.cc"
        break;

    case 37: /* TOK_COMMAND_HEADING  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2635 "msc_lang.cc"
        break;

    case 38: /* TOK_COMMAND_NUDGE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2641 "msc_lang.cc"
        break;

    case 39: /* TOK_COMMAND_NEWPAGE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2647 "msc_lang.cc"
        break;

    case 40: /* TOK_COMMAND_DEFSHAPE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2653 "msc_lang.cc"
        break;

    case 41: /* TOK_COMMAND_DEFCOLOR  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2659 "msc_lang.cc"
        break;

    case 42: /* TOK_COMMAND_DEFSTYLE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2665 "msc_lang.cc"
        break;

    case 43: /* TOK_COMMAND_DEFDESIGN  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2671 "msc_lang.cc"
        break;

    case 44: /* TOK_COMMAND_DEFPROC  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2677 "msc_lang.cc"
        break;

    case 45: /* TOK_COMMAND_REPLAY  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2683 "msc_lang.cc"
        break;

    case 46: /* TOK_COMMAND_SET  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2689 "msc_lang.cc"
        break;

    case 47: /* TOK_COMMAND_INCLUDE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2695 "msc_lang.cc"
        break;

    case 48: /* TOK_COMMAND_BIG  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2701 "msc_lang.cc"
        break;

    case 49: /* TOK_COMMAND_BOX  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2707 "msc_lang.cc"
        break;

    case 50: /* TOK_COMMAND_PIPE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2713 "msc_lang.cc"
        break;

    case 51: /* TOK_COMMAND_MARK  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2719 "msc_lang.cc"
        break;

    case 52: /* TOK_COMMAND_MARK_SRC  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2725 "msc_lang.cc"
        break;

    case 53: /* TOK_COMMAND_MARK_DST  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2731 "msc_lang.cc"
        break;

    case 54: /* TOK_COMMAND_PARALLEL  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2737 "msc_lang.cc"
        break;

    case 55: /* TOK_COMMAND_OVERLAP  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2743 "msc_lang.cc"
        break;

    case 56: /* TOK_COMMAND_INLINE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2749 "msc_lang.cc"
        break;

    case 57: /* TOK_VERTICAL  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2755 "msc_lang.cc"
        break;

    case 58: /* TOK_VERTICAL_SHAPE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2761 "msc_lang.cc"
        break;

    case 59: /* TOK_AT  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2767 "msc_lang.cc"
        break;

    case 60: /* TOK_LOST  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2773 "msc_lang.cc"
        break;

    case 61: /* TOK_AT_POS  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2779 "msc_lang.cc"
        break;

    case 62: /* TOK_SHOW  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2785 "msc_lang.cc"
        break;

    case 63: /* TOK_HIDE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2791 "msc_lang.cc"
        break;

    case 64: /* TOK_ACTIVATE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2797 "msc_lang.cc"
        break;

    case 65: /* TOK_DEACTIVATE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2803 "msc_lang.cc"
        break;

    case 66: /* TOK_BYE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2809 "msc_lang.cc"
        break;

    case 67: /* TOK_START  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2815 "msc_lang.cc"
        break;

    case 68: /* TOK_BEFORE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2821 "msc_lang.cc"
        break;

    case 69: /* TOK_END  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2827 "msc_lang.cc"
        break;

    case 70: /* TOK_AFTER  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2833 "msc_lang.cc"
        break;

    case 71: /* TOK_COMMAND_VSPACE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2839 "msc_lang.cc"
        break;

    case 72: /* TOK_COMMAND_HSPACE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2845 "msc_lang.cc"
        break;

    case 73: /* TOK_COMMAND_SYMBOL  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2851 "msc_lang.cc"
        break;

    case 74: /* TOK_COMMAND_NOTE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2857 "msc_lang.cc"
        break;

    case 75: /* TOK_COMMAND_COMMENT  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2863 "msc_lang.cc"
        break;

    case 76: /* TOK_COMMAND_ENDNOTE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2869 "msc_lang.cc"
        break;

    case 77: /* TOK_COMMAND_FOOTNOTE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2875 "msc_lang.cc"
        break;

    case 78: /* TOK_COMMAND_TITLE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2881 "msc_lang.cc"
        break;

    case 79: /* TOK_COMMAND_SUBTITLE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2887 "msc_lang.cc"
        break;

    case 80: /* TOK_COMMAND_TEXT  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2893 "msc_lang.cc"
        break;

    case 82: /* TOK_JOIN  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2899 "msc_lang.cc"
        break;

    case 83: /* TOK_IF  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2905 "msc_lang.cc"
        break;

    case 84: /* TOK_THEN  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2911 "msc_lang.cc"
        break;

    case 85: /* TOK_ELSE  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2917 "msc_lang.cc"
        break;

    case 86: /* TOK_MSCGEN_RBOX  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2923 "msc_lang.cc"
        break;

    case 87: /* TOK_MSCGEN_ABOX  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 2929 "msc_lang.cc"
        break;

    case 93: /* top_level_arclist  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arclist);}
#line 2935 "msc_lang.cc"
        break;

    case 95: /* braced_arclist  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arclist);}
#line 2941 "msc_lang.cc"
        break;

    case 97: /* defprochelp1  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procdefhelper);}
#line 2947 "msc_lang.cc"
        break;

    case 98: /* defprochelp2  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procdefhelper);}
#line 2953 "msc_lang.cc"
        break;

    case 99: /* defprochelp3  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procdefhelper);}
#line 2959 "msc_lang.cc"
        break;

    case 100: /* defprochelp4  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procdefhelper);}
#line 2965 "msc_lang.cc"
        break;

    case 101: /* scope_open_proc_body  */
#line 199 "msc_lang.yy"
            {}
#line 2971 "msc_lang.cc"
        break;

    case 102: /* scope_close_proc_body  */
#line 199 "msc_lang.yy"
            {}
#line 2977 "msc_lang.cc"
        break;

    case 103: /* proc_def_arglist_tested  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procparamdeflist);}
#line 2983 "msc_lang.cc"
        break;

    case 104: /* proc_def_arglist  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procparamdeflist);}
#line 2989 "msc_lang.cc"
        break;

    case 105: /* proc_def_param_list  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procparamdeflist);}
#line 2995 "msc_lang.cc"
        break;

    case 106: /* proc_def_param  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procparamdef);}
#line 3001 "msc_lang.cc"
        break;

    case 107: /* procedure_body  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procedure);}
#line 3007 "msc_lang.cc"
        break;

    case 109: /* arclist_maybe_no_semicolon  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arclist);}
#line 3013 "msc_lang.cc"
        break;

    case 110: /* arclist  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arclist);}
#line 3019 "msc_lang.cc"
        break;

    case 111: /* arc_with_parallel_semicolon  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3025 "msc_lang.cc"
        break;

    case 112: /* proc_invocation  */
#line 199 "msc_lang.yy"
            {}
#line 3031 "msc_lang.cc"
        break;

    case 113: /* proc_param_list  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procparaminvoclist);}
#line 3037 "msc_lang.cc"
        break;

    case 114: /* proc_invoc_param_list  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procparaminvoclist);}
#line 3043 "msc_lang.cc"
        break;

    case 115: /* proc_invoc_param  */
#line 195 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).procparaminvoc);}
#line 3049 "msc_lang.cc"
        break;

    case 116: /* include  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3055 "msc_lang.cc"
        break;

    case 117: /* overlap_or_parallel  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3061 "msc_lang.cc"
        break;

    case 118: /* arc_with_parallel  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3067 "msc_lang.cc"
        break;

    case 119: /* arc  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3073 "msc_lang.cc"
        break;

    case 120: /* titlecommandtoken  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3079 "msc_lang.cc"
        break;

    case 121: /* hspace_location  */
#line 194 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).namerel);}
#line 3085 "msc_lang.cc"
        break;

    case 122: /* comp  */
#line 199 "msc_lang.yy"
            {}
#line 3091 "msc_lang.cc"
        break;

    case 123: /* condition  */
#line 199 "msc_lang.yy"
            {}
#line 3097 "msc_lang.cc"
        break;

    case 124: /* ifthen_condition  */
#line 200 "msc_lang.yy"
            {
  #ifdef C_S_H_IS_COMPILED
    csh.PopContext();
  #else
    chart.PopContext();
  #endif
}
#line 3109 "msc_lang.cc"
        break;

    case 125: /* else  */
#line 200 "msc_lang.yy"
            {
  #ifdef C_S_H_IS_COMPILED
    csh.PopContext();
  #else
    chart.PopContext();
  #endif
}
#line 3121 "msc_lang.cc"
        break;

    case 126: /* ifthen  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3127 "msc_lang.cc"
        break;

    case 127: /* full_arcattrlist_with_label_or_number  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).attriblist);}
#line 3133 "msc_lang.cc"
        break;

    case 129: /* entityrel  */
#line 194 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).namerel);}
#line 3139 "msc_lang.cc"
        break;

    case 130: /* markerrel_no_string  */
#line 194 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).namerel);}
#line 3145 "msc_lang.cc"
        break;

    case 131: /* entity_command_prefixes  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3151 "msc_lang.cc"
        break;

    case 132: /* optlist  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arclist);}
#line 3157 "msc_lang.cc"
        break;

    case 133: /* opt  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3163 "msc_lang.cc"
        break;

    case 134: /* entitylist  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).entitylist);}
#line 3169 "msc_lang.cc"
        break;

    case 135: /* entity  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).entitylist);}
#line 3175 "msc_lang.cc"
        break;

    case 136: /* first_entity  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).entitylist);}
#line 3181 "msc_lang.cc"
        break;

    case 139: /* stylenamelist  */
#line 198 "msc_lang.yy"
            {delete ((*yyvaluep).stringlist);}
#line 3187 "msc_lang.cc"
        break;

    case 141: /* shapedeflist  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).shape);}
#line 3193 "msc_lang.cc"
        break;

    case 142: /* shapeline  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).shapeelement);}
#line 3199 "msc_lang.cc"
        break;

    case 144: /* color_def_string  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3205 "msc_lang.cc"
        break;

    case 145: /* color_string  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3211 "msc_lang.cc"
        break;

    case 153: /* parallel  */
#line 192 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcparallel);}
#line 3217 "msc_lang.cc"
        break;

    case 155: /* box_list  */
#line 192 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcboxseries);}
#line 3223 "msc_lang.cc"
        break;

    case 156: /* mscgen_box  */
#line 192 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcboxseries);}
#line 3229 "msc_lang.cc"
        break;

    case 157: /* mscgen_boxlist  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arclist);}
#line 3235 "msc_lang.cc"
        break;

    case 158: /* first_box  */
#line 192 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcboxseries);}
#line 3241 "msc_lang.cc"
        break;

    case 159: /* first_pipe  */
#line 192 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcpipe);}
#line 3247 "msc_lang.cc"
        break;

    case 160: /* pipe_list_no_content  */
#line 192 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcpipeseries);}
#line 3253 "msc_lang.cc"
        break;

    case 161: /* pipe_list  */
#line 192 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcpipeseries);}
#line 3259 "msc_lang.cc"
        break;

    case 163: /* boxrel  */
#line 192 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbox);}
#line 3265 "msc_lang.cc"
        break;

    case 164: /* mscgen_emphrel  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3271 "msc_lang.cc"
        break;

    case 165: /* mscgen_boxrel  */
#line 192 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbox);}
#line 3277 "msc_lang.cc"
        break;

    case 166: /* vertxpos  */
#line 194 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).vertxpos);}
#line 3283 "msc_lang.cc"
        break;

    case 168: /* vertrel_no_xpos  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcvertarrow);}
#line 3289 "msc_lang.cc"
        break;

    case 169: /* vertrel  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcvertarrow);}
#line 3295 "msc_lang.cc"
        break;

    case 170: /* arcrel  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3301 "msc_lang.cc"
        break;

    case 171: /* arrow_with_specifier_incomplete  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcarrow);}
#line 3307 "msc_lang.cc"
        break;

    case 172: /* arrow_with_specifier  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcarrow);}
#line 3313 "msc_lang.cc"
        break;

    case 173: /* special_ending  */
#line 194 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arrowending);}
#line 3319 "msc_lang.cc"
        break;

    case 174: /* arcrel_arrow  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcarrow);}
#line 3325 "msc_lang.cc"
        break;

    case 175: /* arcrel_to  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcarrow);}
#line 3331 "msc_lang.cc"
        break;

    case 176: /* arcrel_from  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcarrow);}
#line 3337 "msc_lang.cc"
        break;

    case 177: /* arcrel_bidir  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcarrow);}
#line 3343 "msc_lang.cc"
        break;

    case 187: /* extvertxpos  */
#line 194 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).extvertxpos);}
#line 3349 "msc_lang.cc"
        break;

    case 188: /* extvertxpos_no_string  */
#line 194 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).extvertxpos);}
#line 3355 "msc_lang.cc"
        break;

    case 189: /* symbol_type_string  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3361 "msc_lang.cc"
        break;

    case 190: /* symbol_command_no_attr  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3367 "msc_lang.cc"
        break;

    case 191: /* symbol_command  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3373 "msc_lang.cc"
        break;

    case 192: /* note  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3379 "msc_lang.cc"
        break;

    case 194: /* comment  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3385 "msc_lang.cc"
        break;

    case 195: /* colon_string  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3391 "msc_lang.cc"
        break;

    case 196: /* full_arcattrlist_with_label  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).attriblist);}
#line 3397 "msc_lang.cc"
        break;

    case 197: /* full_arcattrlist  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).attriblist);}
#line 3403 "msc_lang.cc"
        break;

    case 198: /* arcattrlist  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).attriblist);}
#line 3409 "msc_lang.cc"
        break;

    case 199: /* arcattr  */
#line 193 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).attrib);}
#line 3415 "msc_lang.cc"
        break;

    case 201: /* entity_string_single  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3421 "msc_lang.cc"
        break;

    case 202: /* reserved_word_string  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3427 "msc_lang.cc"
        break;

    case 203: /* symbol_string  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3433 "msc_lang.cc"
        break;

    case 204: /* alpha_string_single  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3439 "msc_lang.cc"
        break;

    case 205: /* string_single  */
#line 196 "msc_lang.yy"
            {free(((*yyvaluep).str));}
#line 3445 "msc_lang.cc"
        break;

    case 206: /* tok_param_name_as_multi  */
#line 197 "msc_lang.yy"
            {free(((*yyvaluep).multi_str).str);}
#line 3451 "msc_lang.cc"
        break;

    case 207: /* multi_string_continuation  */
#line 197 "msc_lang.yy"
            {free(((*yyvaluep).multi_str).str);}
#line 3457 "msc_lang.cc"
        break;

    case 208: /* entity_string_single_or_param  */
#line 197 "msc_lang.yy"
            {free(((*yyvaluep).multi_str).str);}
#line 3463 "msc_lang.cc"
        break;

    case 209: /* entity_string  */
#line 197 "msc_lang.yy"
            {free(((*yyvaluep).multi_str).str);}
#line 3469 "msc_lang.cc"
        break;

    case 210: /* alpha_string  */
#line 197 "msc_lang.yy"
            {free(((*yyvaluep).multi_str).str);}
#line 3475 "msc_lang.cc"
        break;

    case 211: /* string  */
#line 197 "msc_lang.yy"
            {free(((*yyvaluep).multi_str).str);}
#line 3481 "msc_lang.cc"
        break;

    case 213: /* scope_close  */
#line 191 "msc_lang.yy"
            {if (!C_S_H) delete ((*yyvaluep).arcbase);}
#line 3487 "msc_lang.cc"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/*----------.
| yyparse.  |
`----------*/

int
yyparse (YYMSC_RESULT_TYPE &RESULT, void *yyscanner)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    yy_state_fast_t yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss;
    yy_state_t *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

    /* The locations where the error started and ended.  */
    YYLTYPE yyerror_range[3];

    YYPTRDIFF_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

/* User initialization code.  */
#line 8 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    yylloc.first_pos = 0;
    yylloc.last_pos = 0;
  #endif
}

#line 3602 "msc_lang.cc"

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
# undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2:
#line 260 "msc_lang.yy"
{
	YYACCEPT;
}
#line 3803 "msc_lang.cc"
    break;

  case 4:
#line 266 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
	csh.AddCSH_AllCommentBeyond((yylsp[0]));
  #else
  #endif
    free((yyvsp[0].str));
}
#line 3816 "msc_lang.cc"
    break;

  case 5:
#line 275 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
	csh.AddCSH_AllCommentBeyond((yylsp[0]));
  #else
  #endif
    free((yyvsp[-1].str));
}
#line 3830 "msc_lang.cc"
    break;

  case 6:
#line 286 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddLineBeginToHints();
    csh.hintStatus = HINT_READY;
    csh.hintSource = EHintSourceType::LINE_START;
    csh.hintsForcedOnly = true;
  #else
    //no action for empty file
  #endif
}
#line 3845 "msc_lang.cc"
    break;

  case 7:
#line 297 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintBefore((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        csh.AddDesignsToHints(true);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1]))) {
        csh.AddOptionsToHints();
        csh.AllowAnything();
    } else if (csh.CheckHintLocated(EHintSourceType::LINE_START, (yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.AddArcs((yyvsp[0].arclist));
  #endif
}
#line 3868 "msc_lang.cc"
    break;

  case 8:
#line 316 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintBefore((yylsp[-2])) || csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH_Error((yylsp[-1]), "Missing an equal sign or a list of elements between braces ('{' and '}').");
  #else
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Missing an equal sign or a list of elements between braces ('{' and '}').");
  #endif
    free((yyvsp[-2].str));
	YYACCEPT; //We should noty parse further in msc_with_bye as we may have something beyond BYE (in eof)
}
#line 3887 "msc_lang.cc"
    break;

  case 9:
#line 331 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintBefore((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
#else
    chart.AddArcs((yyvsp[-1].arclist));
  #endif
	YYACCEPT; //We should not parse further in msc_with_bye as we may have something beyond BYE (in eof)
}
#line 3903 "msc_lang.cc"
    break;

  case 10:
#line 343 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintBefore((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    CshPos pos = (yylsp[-1]);
    if (((yylsp[-2])).last_pos >= ((yylsp[-1])).first_pos)
        pos.first_pos = ((yylsp[-2])).last_pos;
    csh.AddCSH_Error(pos, "Could not recognize this as a valid line.");
  #else
    chart.AddArcs((yyvsp[-2].arclist));
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Could not recognize this as a valid line.");
  #endif
	YYACCEPT; //We should noty parse further in msc_with_bye as we may have something beyond BYE (in eof)
}
#line 3924 "msc_lang.cc"
    break;

  case 12:
#line 362 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[0]), "Closing brace missing its opening pair.");
  #else
    (yyval.arclist) = (yyvsp[-1].arclist);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Unexpected '}'.");
  #endif
  (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 3938 "msc_lang.cc"
    break;

  case 13:
#line 372 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[-1]), "Closing brace missing its opening pair.");
  #else
    //Merge $3 into $1
    ((yyvsp[-2].arclist))->splice(((yyvsp[-2].arclist))->end(), *((yyvsp[0].arclist)));
    delete ((yyvsp[0].arclist));
    (yyval.arclist) = (yyvsp[-2].arclist);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Unexpected '}'.");
  #endif
  (yyvsp[-1].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 3955 "msc_lang.cc"
    break;

  case 14:
#line 387 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.SwitchToMscgenCompatMode();
  #else
    chart.SwitchToMscgenCompatMode();
  #endif
    free((yyvsp[0].str));
}
#line 3969 "msc_lang.cc"
    break;

  case 15:
#line 397 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a design name.");
    csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME);
    csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, "msc");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing design name.");
  #endif
    free((yyvsp[-1].str));
}
#line 3986 "msc_lang.cc"
    break;

  case 16:
#line 410 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH((yylsp[0]), COLOR_DESIGNNAME);
    csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME);
    csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, "msc");
    csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_VALUE, "msc");
    if (!csh.SkipContent()) {
        std::string msg = csh.SetDesignTo((yyvsp[0].multi_str).str, true);
        if (msg.length())
            csh.AddCSH_Error((yylsp[0]), std::move(msg));
    }
  #else
    if (!(yyvsp[0].multi_str).had_error && !chart.SkipContent()) {
        ArcBase *dummy = chart.AddAttribute(Attribute("msc", (yyvsp[0].multi_str).str, CHART_POS((yylsp[-2])), CHART_POS((yylsp[0]))));
        if (dummy) delete dummy;
    }
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].multi_str).str);
}
#line 4013 "msc_lang.cc"
    break;

  case 17:
#line 434 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
  #else
    if ((yyvsp[0].arcbase)) ((yyvsp[-1].arclist))->Append((yyvsp[0].arcbase)); //Append any potential SetNumbering
    (yyval.arclist) = (yyvsp[-1].arclist);
  #endif
}
#line 4026 "msc_lang.cc"
    break;

  case 18:
#line 443 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
  #else
    (yyval.arclist) = new ArcList;
    //scope_close should not return here with a SetNumbering
    //but just in case
    if ((yyvsp[0].arcbase))
        delete((yyvsp[0].arcbase));
  #endif
}
#line 4042 "msc_lang.cc"
    break;

  case 19:
#line 455 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as a valid line.");
  #else
    if ((yyvsp[0].arcbase)) ((yyvsp[-2].arclist))->Append((yyvsp[0].arcbase)); //Append any potential SetNumbering
    (yyval.arclist) = (yyvsp[-2].arclist);
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "syntax error.");
  #endif
    yyerrok;
}
#line 4058 "msc_lang.cc"
    break;

  case 20:
#line 467 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddOpenBracePair((yyloc));
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as a valid line.");
  #else
    (yyval.arclist) = (yyvsp[-2].arclist);
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Missing '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-3])), CHART_POS_START((yylsp[-1])), "Here is the corresponding '{'.");
  #endif
}
#line 4074 "msc_lang.cc"
    break;

  case 21:
#line 479 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddOpenBracePair((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing a closing brace ('}').");
  #else
    (yyval.arclist) = (yyvsp[-1].arclist);
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_AFTER((yylsp[-1])), "Missing '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_AFTER((yylsp[-1])), "Here is the corresponding '{'.");
  #endif
}
#line 4090 "msc_lang.cc"
    break;

  case 22:
#line 491 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddOpenBracePair((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing a closing brace ('}').");
  #else
    (yyval.arclist) = nullptr;
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_AFTER((yylsp[-1])), "Missing a corresponding '}'.");
  #endif
}
#line 4105 "msc_lang.cc"
    break;

  case 23:
#line 502 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
    csh.AddCSH_Error((yylsp[0]), "The command 'bye' can only be used at the top level.");
  #else
    (yyval.arclist) = (yyvsp[-1].arclist);
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_START((yylsp[0])), "The command 'bye' can not be used between curly braces '{' and '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_START((yylsp[0])), "Here is the opening '{'.");
  #endif
  free((yyvsp[0].str));
}
#line 4122 "msc_lang.cc"
    break;

  case 24:
#line 515 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
    csh.AddCSH_Error((yylsp[0]), "The command 'bye' can only be used at the top level and not inside curly braces '{' and '}'.");
  #else
    (yyval.arclist) = nullptr;
    //Do not pop context, as the missing scope_close would have done
    chart.Error.Error(CHART_POS_START((yylsp[0])), "The command 'bye' can not be used between curly braces '{' and '}'.");
  #endif
  free((yyvsp[0].str));
}
#line 4138 "msc_lang.cc"
    break;

  case 25:
#line 529 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    if ((yyvsp[0].procdefhelper)) {
        if (chart.SkipContent()) {
            chart.Error.Error(CHART_POS_START((yyloc)), "Cannot define procedures inside a procedure.");
        } else if ((yyvsp[0].procdefhelper)->name.had_error) {
            //do nothing, error already reported
        } else if ((yyvsp[0].procdefhelper)->name.str==nullptr || (yyvsp[0].procdefhelper)->name.str[0]==0) {
            chart.Error.Error((yyvsp[0].procdefhelper)->linenum_name, "Missing a procedure name to (re-)define. Ignoring this.");
        } else if (!(yyvsp[0].procdefhelper)->had_error && (yyvsp[0].procdefhelper)->body) {
            if (chart.MyCurrentContext().num_error != chart.Error.GetErrorNum(true, false)) {
                chart.Error.Error(CHART_POS_START((yyloc)), "There are warnings or errors inside the procedure definition. Ignoring it.");
                chart.MyCurrentContext().Procedures[(yyvsp[0].procdefhelper)->name.str].name = (yyvsp[0].procdefhelper)->name.str;
                chart.MyCurrentContext().Procedures[(yyvsp[0].procdefhelper)->name.str].status = EDefProcResult::PROBLEM;
                chart.MyCurrentContext().Procedures[(yyvsp[0].procdefhelper)->name.str].file_pos = (yyvsp[0].procdefhelper)->linenum_body;
            } else if ((yyvsp[0].procdefhelper)->body->status==EDefProcResult::OK || (yyvsp[0].procdefhelper)->body->status==EDefProcResult::EMPTY) {
                if ((yyvsp[0].procdefhelper)->parameters) {
                    auto &p = chart.MyCurrentContext().Procedures[(yyvsp[0].procdefhelper)->name.str] = *(yyvsp[0].procdefhelper)->body;
                    p.name = (yyvsp[0].procdefhelper)->name.str;
                    p.parameters = std::move(*(yyvsp[0].procdefhelper)->parameters);
                    if ((yyvsp[0].procdefhelper)->attrs) for (auto &a : *(yyvsp[0].procdefhelper)->attrs)
                        p.AddAttribute(*a, chart);
                    if ((yyvsp[0].procdefhelper)->body->status==EDefProcResult::EMPTY)
                        chart.Error.Warning((yyvsp[0].procdefhelper)->linenum_body, "Empty procedure. Is this what you want?");
                } else {
                     chart.Error.Error(CHART_POS_START((yyloc)), "Ill-formed procedure parameter list. Ignoring this procedure definition.");
                }
            } else {
                 chart.Error.Error(CHART_POS_START((yyloc)), "Ill-formed procedure body. Ignoring this procedure definition.");
            }
        }
        delete (yyvsp[0].procdefhelper);
    }
  #endif
}
#line 4179 "msc_lang.cc"
    break;

  case 26:
#line 568 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.SkipContent()) {
        csh.AddCSH_Error((yylsp[0]), "Cannot define procedures inside a procedure.");
    } else {
        csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
        csh.AddCSH_ErrorAfter((yyloc), "Missing procedure name to (re-)define.");
    }
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.procdefhelper) = new ProcDefParseHelper<AttributeList>;
    (yyval.procdefhelper)->linenum_name = CHART_POS_AFTER((yyloc));
  #endif
    free((yyvsp[0].str));
}
#line 4202 "msc_lang.cc"
    break;

  case 27:
#line 587 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.SkipContent()) {
        csh.AddCSH_Error((yylsp[-1]), "Cannot define procedures inside a procedure.");
    } else {
        csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    }
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.procdefhelper) = (yyvsp[0].procdefhelper);
  #endif
    free((yyvsp[-1].str));
}
#line 4223 "msc_lang.cc"
    break;

  case 28:
#line 605 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_PROCNAME);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a procedure definition starting with '{'.");
    free((yyvsp[0].multi_str).str);
  #else
    (yyval.procdefhelper) = new ProcDefParseHelper<AttributeList>;
    (yyval.procdefhelper)->name = (yyvsp[0].multi_str);
    (yyval.procdefhelper)->linenum_name = CHART_POS_START((yylsp[0]));
  #endif
}
#line 4239 "msc_lang.cc"
    break;

  case 29:
#line 617 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_PROCNAME);
    free((yyvsp[-1].multi_str).str);
  #else
    (yyval.procdefhelper) = (yyvsp[0].procdefhelper);
    (yyval.procdefhelper)->name = (yyvsp[-1].multi_str);
    (yyval.procdefhelper)->linenum_name = CHART_POS_START((yylsp[-1]));
  #endif
}
#line 4254 "msc_lang.cc"
    break;

  case 30:
#line 628 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error(CshPos((yylsp[0]).first_pos, (yylsp[0]).first_pos), "Missing procedure name.");
  #else
    (yyval.procdefhelper) = (yyvsp[0].procdefhelper);
    (yyval.procdefhelper)->linenum_name = CHART_POS_START((yylsp[0]));
  #endif
}
#line 4267 "msc_lang.cc"
    break;

  case 31:
#line 638 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a procedure definition starting with '{'.");
  #else
    (yyval.procdefhelper) = new ProcDefParseHelper<AttributeList>;
    (yyval.procdefhelper)->parameters = (yyvsp[0].procparamdeflist);
  #endif
}
#line 4280 "msc_lang.cc"
    break;

  case 32:
#line 647 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.procdefhelper) = (yyvsp[0].procdefhelper);
    (yyval.procdefhelper)->parameters = (yyvsp[-1].procparamdeflist);
  #endif
}
#line 4292 "msc_lang.cc"
    break;

  case 33:
#line 655 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.procdefhelper) = (yyvsp[0].procdefhelper);
    (yyval.procdefhelper)->parameters = new ProcParamDefList;
  #endif
}
#line 4304 "msc_lang.cc"
    break;

  case 34:
#line 664 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a procedure definition starting with '{'.");
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_ATTRNAME) + "export",
            "Set if styles and colors defined in the procedure remain valid after calling it.",
            EHintType::ATTR_NAME));
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        csh.AddYesNoToHints();
  #else
    (yyval.procdefhelper) = new ProcDefParseHelper<AttributeList>;
    (yyval.procdefhelper)->attrs = (yyvsp[0].attriblist);
  #endif
}
#line 4323 "msc_lang.cc"
    break;

  case 35:
#line 679 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_ATTRNAME) + "export",
            "Set if styles and colors defined in the procedure remain valid after calling it.",
            EHintType::ATTR_NAME));
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        csh.AddYesNoToHints();
  #else
    (yyval.procdefhelper) = new ProcDefParseHelper<AttributeList>;
    (yyval.procdefhelper)->body = (yyvsp[0].procedure);
    (yyval.procdefhelper)->linenum_body = CHART_POS_START((yylsp[0]));
    (yyval.procdefhelper)->attrs = (yyvsp[-1].attriblist);
  #endif
}
#line 4343 "msc_lang.cc"
    break;

  case 36:
#line 695 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.procdefhelper) = new ProcDefParseHelper<AttributeList>;
    (yyval.procdefhelper)->body = (yyvsp[0].procedure);
    (yyval.procdefhelper)->linenum_body = CHART_POS_START((yylsp[0]));
  #endif
}
#line 4356 "msc_lang.cc"
    break;

  case 37:
#line 706 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.PushContext(true, EContextParse::SKIP_CONTENT);
  #else
    chart.MyCurrentContext().num_error = chart.Error.GetErrorNum(true, false);
    chart.PushContext(CHART_POS_START((yylsp[0])), EContextParse::SKIP_CONTENT, EContextCreate::EMPTY);  //We have all the styles, but empty
    chart.MyCurrentContext().hscale = {true, 1.}; //Set to arbitrary value so that Msc::GetDefaultSpecialEndingSize() does not complain.
    chart.MyCurrentContext().parameters = std::move(YYGET_EXTRA(yyscanner)->last_procedure_params);
    chart.MyCurrentContext().starts_procedure = true;
    _ASSERT(YYGET_EXTRA(yyscanner)->open_context_mode == base_parse_parm::EScopeOpenMode::NORMAL);
    YYGET_EXTRA(yyscanner)->open_context_mode = base_parse_parm::EScopeOpenMode::NORMAL;
  #endif
    (yyval.input_text_ptr) = (yyvsp[0].input_text_ptr);
}
#line 4376 "msc_lang.cc"
    break;

  case 38:
#line 723 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.PopContext();
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
  #else
    delete chart.PopContext();
  #endif
    (yyval.input_text_ptr) = (yyvsp[0].input_text_ptr);
}
#line 4390 "msc_lang.cc"
    break;

  case 39:
#line 734 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    if ((yyvsp[0].procparamdeflist)) {
        auto pair = Procedure::AreAllParameterNamesUnique(*(yyvsp[0].procparamdeflist));
        if (pair.first) {
            chart.Error.Error(pair.second->linenum_name, "This parameter name is already used.");
            chart.Error.Error(pair.first->linenum_name, pair.second->linenum_name, "This parameter name is already used.");
            delete (yyvsp[0].procparamdeflist);
            (yyval.procparamdeflist) = nullptr;
        } else {
            //Also copy to YYGET_EXTRA(yyscanner)->last_procedure_params and set open_context_mode
            auto &store = YYGET_EXTRA(yyscanner)->last_procedure_params;
            store.clear();
            for (const auto &p : *(yyvsp[0].procparamdeflist))
                store.emplace(p->name, ProcParamResolved(std::string(), FileLineCol(), true));
            (yyval.procparamdeflist) = (yyvsp[0].procparamdeflist);
        }
    } else
        (yyval.procparamdeflist) = nullptr;
  #endif
}
#line 4417 "msc_lang.cc"
    break;

  case 40:
#line 758 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_PARENTHESIS);
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
  #else
    (yyval.procparamdeflist) = new ProcParamDefList;
  #endif
}
#line 4430 "msc_lang.cc"
    break;

  case 41:
#line 767 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_PARENTHESIS);
    csh.AddCSH_Error((yylsp[-1]), "Invalid parameter definitions.");
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
  #else
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Invalid parameter definitions.", "Say something like '($first, $second=default)'.");
    (yyval.procparamdeflist) = nullptr;
  #endif
}
#line 4445 "msc_lang.cc"
    break;

  case 42:
#line 778 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing parameter list closed by a parenthesis ')'.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing parameter list closed by a parenthesis ')'.");
    (yyval.procparamdeflist) = nullptr;
  #endif
}
#line 4459 "msc_lang.cc"
    break;

  case 43:
#line 788 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_PARENTHESIS);
    csh.AddCSH_Error((yylsp[-1]), "Invalid parameter definitions.");
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
  #else
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Invalid parameter definitions.");
    delete (yyvsp[-2].procparamdeflist);
    (yyval.procparamdeflist) = nullptr;
  #endif
}
#line 4475 "msc_lang.cc"
    break;

  case 44:
#line 800 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_PARENTHESIS);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing closing parenthesis ')'.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing closing parenthesis ')'.");
    delete (yyvsp[0].procparamdeflist);
    (yyval.procparamdeflist) = nullptr;
  #endif
}
#line 4490 "msc_lang.cc"
    break;

  case 45:
#line 811 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_PARENTHESIS);
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
  #else
    (yyval.procparamdeflist) = (yyvsp[-1].procparamdeflist);
  #endif
}
#line 4503 "msc_lang.cc"
    break;

  case 46:
#line 821 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    if ((yyvsp[0].procparamdef)) {
        (yyval.procparamdeflist) = new ProcParamDefList;
        ((yyval.procparamdeflist))->Append((yyvsp[0].procparamdef));
    } else
        (yyval.procparamdeflist)= nullptr;
  #endif
}
#line 4518 "msc_lang.cc"
    break;

  case 47:
#line 832 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing parameter after the comma.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing parameter after the comma.");
    delete (yyvsp[-1].procparamdeflist);
    (yyval.procparamdeflist)= nullptr;
  #endif
}
#line 4533 "msc_lang.cc"
    break;

  case 48:
#line 843 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
  #else
    if ((yyvsp[-2].procparamdeflist) && (yyvsp[0].procparamdef)) {
        ((yyvsp[-2].procparamdeflist))->Append((yyvsp[0].procparamdef));
        (yyval.procparamdeflist) = (yyvsp[-2].procparamdeflist);
    } else {
        delete (yyvsp[-2].procparamdeflist);
        delete (yyvsp[0].procparamdef);
        (yyval.procparamdeflist)= nullptr;
    }
  #endif
}
#line 4552 "msc_lang.cc"
    break;

  case 49:
#line 859 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if ((yyvsp[0].str) && (yyvsp[0].str)[0]=='$' && (yyvsp[0].str)[1])
        csh.AddCSH((yylsp[0]), COLOR_PARAMNAME);
    else
        csh.AddCSH_Error((yylsp[0]), "Need name after the '$' sign.");
    (yyval.procparamdef) = nullptr; //no value
  #else
    if ((yyvsp[0].str) && (yyvsp[0].str)[0]=='$' && (yyvsp[0].str)[1]) {
        (yyval.procparamdef) = new ProcParamDef((yyvsp[0].str), CHART_POS_START((yylsp[0])));
    } else {
        chart.Error.Error(CHART_POS_START((yylsp[0])), "Need name after the '$' sign.");
        (yyval.procparamdef) = nullptr;
    }
  #endif
    free((yyvsp[0].str));
}
#line 4574 "msc_lang.cc"
    break;

  case 50:
#line 877 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    if ((yyvsp[-1].str) && (yyvsp[-1].str)[0]=='$' && (yyvsp[-1].str)[1])
        csh.AddCSH((yylsp[-1]), COLOR_PARAMNAME);
    else
        csh.AddCSH_Error((yylsp[-1]), "Need name after the '$' sign.");
    (yyval.procparamdef) = nullptr; //no value
  #else
    if ((yyvsp[-1].str) && (yyvsp[-1].str)[0]=='$' && (yyvsp[-1].str)[1]) {
        (yyval.procparamdef) = new ProcParamDef((yyvsp[-1].str), CHART_POS_START((yylsp[-1])));
    } else {
        chart.Error.Error(CHART_POS_START((yylsp[-1])), "Need name after the '$' sign.");
        (yyval.procparamdef) = nullptr;
    }
  #endif
    free((yyvsp[-1].str));
}
#line 4597 "msc_lang.cc"
    break;

  case 51:
#line 896 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if ((yyvsp[-2].str) && (yyvsp[-2].str)[0]=='$' && (yyvsp[-2].str)[1])
        csh.AddCSH((yylsp[-2]), COLOR_PARAMNAME);
    else
        csh.AddCSH_Error((yylsp[-2]), "Need name after the '$' sign.");
    (yyval.procparamdef) = (char*)1; //has value
  #else
    if ((yyvsp[0].multi_str).had_error) {
        (yyval.procparamdef) = nullptr;
    } else if ((yyvsp[-2].str) && (yyvsp[-2].str)[0]=='$' && (yyvsp[-2].str)[1]) {
        (yyval.procparamdef) = new ProcParamDef((yyvsp[-2].str), CHART_POS_START((yylsp[-2])), (yyvsp[0].multi_str).str, CHART_POS_START((yylsp[0])));
    } else {
        chart.Error.Error(CHART_POS_START((yylsp[-2])), "Need name after the '$' sign.");
        (yyval.procparamdef) = nullptr;
    }
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].multi_str).str);
}
#line 4623 "msc_lang.cc"
    break;

  case 52:
#line 918 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if ((yyvsp[-2].str) && (yyvsp[-2].str)[0]=='$' && (yyvsp[-2].str)[1])
        csh.AddCSH((yylsp[-2]), COLOR_PARAMNAME);
    else
        csh.AddCSH_Error((yylsp[-2]), "Need name after the '$' sign.");
    (yyval.procparamdef) = (char*)1; //has value
  #else
    if ((yyvsp[-2].str) && (yyvsp[-2].str)[0]=='$' && (yyvsp[-2].str)[1]) {
        (yyval.procparamdef) = new ProcParamDef((yyvsp[-2].str), CHART_POS_START((yylsp[-2])), (yyvsp[0].str), CHART_POS_START((yylsp[0])));
    } else {
        chart.Error.Error(CHART_POS_START((yylsp[-2])), "Need name after the '$' sign.");
        (yyval.procparamdef) = nullptr;
    }
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 4647 "msc_lang.cc"
    break;

  case 53:
#line 942 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
  #else
    auto tmp = new Procedure;
    tmp->status = EDefProcResult::OK;
    tmp->text = std::string(((yyvsp[-2].input_text_ptr)), ((yyvsp[0].input_text_ptr))+1)+";";
    tmp->file_pos = CHART_POS_START((yyloc));
    if ((yyvsp[-1].arclist))
        delete (yyvsp[-1].arclist);
    (yyval.procedure) = tmp;
  #endif
}
#line 4665 "msc_lang.cc"
    break;

  case 54:
#line 956 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
  #else
    auto tmp = new Procedure;
    tmp->status = EDefProcResult::EMPTY;
    tmp->file_pos = CHART_POS_START((yyloc));
    (yyval.procedure) = tmp;
  #endif
  (yyvsp[-1].input_text_ptr); //to silence 'unused parameter' warnings
  (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 4682 "msc_lang.cc"
    break;

  case 55:
#line 969 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as a valid line.");
  #else
    auto tmp = new Procedure;
    tmp->status = EDefProcResult::PROBLEM;
    tmp->file_pos = CHART_POS_START((yyloc));
    (yyval.procedure) = tmp;
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "syntax error.");
    if ((yyvsp[-2].arclist))
        delete (yyvsp[-2].arclist);
  #endif
    yyerrok;
  (yyvsp[-3].input_text_ptr); //to silence 'unused parameter' warnings
  (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 4704 "msc_lang.cc"
    break;

  case 56:
#line 987 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddOpenBracePair((yyloc));
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as a valid line.");
    csh.PopContext();
  #else
    auto tmp = new Procedure;
    tmp->status = EDefProcResult::PROBLEM;
    tmp->file_pos = CHART_POS_START((yyloc));
    (yyval.procedure) = tmp;
    delete chart.PopContext();
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Missing '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-3])), CHART_POS_START((yylsp[-1])), "Here is the corresponding '{'.");
    if ((yyvsp[-2].arclist))
        delete (yyvsp[-2].arclist);
  #endif
  (yyvsp[-3].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 4727 "msc_lang.cc"
    break;

  case 57:
#line 1006 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddOpenBracePair((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing a closing brace ('}').");
    csh.PopContext();
  #else
    auto tmp = new Procedure;
    tmp->status = EDefProcResult::PROBLEM;
    tmp->file_pos = CHART_POS_START((yyloc));
    (yyval.procedure) = tmp;
    delete chart.PopContext();
    chart.Error.Error(CHART_POS_AFTER((yylsp[-1])), "Missing '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_AFTER((yylsp[-1])), "Here is the corresponding '{'.");
    if ((yyvsp[-1].arclist))
        delete (yyvsp[-1].arclist);
  #endif
  (yyvsp[-2].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 4750 "msc_lang.cc"
    break;

  case 58:
#line 1025 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddOpenBracePair((yyloc));
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing a closing brace ('}').");
    csh.PopContext();
  #else
    auto tmp = new Procedure;
    tmp->status = EDefProcResult::PROBLEM;
    tmp->file_pos = CHART_POS_START((yyloc));
    (yyval.procedure) = tmp;
    delete chart.PopContext();
    chart.Error.Error(CHART_POS_AFTER((yylsp[-1])), "Missing a corresponding '}'.");
  #endif
  (yyvsp[-1].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 4770 "msc_lang.cc"
    break;

  case 59:
#line 1041 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
    csh.AddCSH_Error((yylsp[0]), "The command 'bye' can only be used at the top level.");
    csh.PopContext();
  #else
    auto tmp = new Procedure;
    tmp->status = EDefProcResult::PROBLEM;
    tmp->file_pos = CHART_POS_START((yyloc));
    (yyval.procedure) = tmp;
    delete chart.PopContext();
    chart.Error.Error(CHART_POS_START((yylsp[0])), "The command 'bye' can not be used between curly braces '{' and '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_START((yylsp[0])), "Here is the opening '{'.");
    if ((yyvsp[-1].arclist))
        delete (yyvsp[-1].arclist);
  #endif
  (yyvsp[-2].input_text_ptr); //to silence 'unused parameter' warnings
  free((yyvsp[0].str));
}
#line 4794 "msc_lang.cc"
    break;

  case 60:
#line 1061 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yyloc));
    csh.AddCSH_Error((yylsp[0]), "The command 'bye' can only be used at the top level and not inside curly braces '{' and '}'.");
    csh.PopContext();
  #else
    auto tmp = new Procedure;
    tmp->status = EDefProcResult::PROBLEM;
    tmp->file_pos = CHART_POS_START((yyloc));
    (yyval.procedure) = tmp;
    delete chart.PopContext();
    chart.Error.Error(CHART_POS_START((yylsp[0])), "The command 'bye' can not be used between curly braces '{' and '}'.");
  #endif
  (yyvsp[-1].input_text_ptr); //to silence 'unused parameter' warnings
  free((yyvsp[0].str));
}
#line 4815 "msc_lang.cc"
    break;

  case 61:
#line 1079 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (!(yyvsp[0].procparamdef))
        csh.AddCSH_ErrorAfter((yylsp[0]), "Missing value.");
  #else
    if (!chart.SkipContent())
        chart.SetVariable((yyvsp[0].procparamdef), CHART_POS((yyloc)));
  #endif
    free((yyvsp[-1].str));
}
#line 4831 "msc_lang.cc"
    break;

  case 62:
#line 1091 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing variable or parameter name to set.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing variable or parameter name to set.");
  #endif
    free((yyvsp[0].str));
}
#line 4845 "msc_lang.cc"
    break;

  case 64:
#line 1104 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yylsp[0]));
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a semicolon (';').");
  #else
    if ((yyvsp[0].arcbase)) {
		((yyvsp[-1].arclist))->Append((yyvsp[0].arcbase));
		((yyvsp[0].arcbase))->SetLineEnd(CHART_POS((yylsp[0])));
	}
    (yyval.arclist) = (yyvsp[-1].arclist);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[0])), CHART_POS_AFTER((yylsp[0])), "Here is the beginning of the command as I understood it.");
  #endif
}
#line 4864 "msc_lang.cc"
    break;

  case 65:
#line 1119 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yylsp[0]));
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a semicolon (';').");
  #else
    if ((yyvsp[0].arcbase)) {
		((yyvsp[0].arcbase))->SetLineEnd(CHART_POS((yylsp[0])));
        (yyval.arclist) = (new ArcList)->Append((yyvsp[0].arcbase)); /* New list */
    } else
        (yyval.arclist) = new ArcList;
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[0])), CHART_POS_AFTER((yylsp[0])), "Here is the beginning of the command as I understood it.");
  #endif
}
#line 4883 "msc_lang.cc"
    break;

  case 66:
#line 1136 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].arcbase))
        (yyval.arclist) = (new ArcList)->Append((yyvsp[0].arcbase)); /* New list */
    else
        (yyval.arclist) = new ArcList;
  #endif
}
#line 4896 "msc_lang.cc"
    break;

  case 67:
#line 1145 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].arcbase)) ((yyvsp[-1].arclist))->Append((yyvsp[0].arcbase));     /* Add to existing list */
    (yyval.arclist) = ((yyvsp[-1].arclist));
  #endif
}
#line 4907 "msc_lang.cc"
    break;

  case 68:
#line 1153 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-1].arcbase))
		((yyvsp[-1].arcbase))->SetLineEnd(CHART_POS((yyloc)));
    (yyval.arcbase)=(yyvsp[-1].arcbase);
  #endif
}
#line 4926 "msc_lang.cc"
    break;

  case 69:
#line 1168 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arcbase)=nullptr;
  #endif
}
#line 4943 "msc_lang.cc"
    break;

  case 70:
#line 1181 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstruction((yyloc));
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is coming here.");
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-2].arcbase))
		((yyvsp[-2].arcbase))->SetLineEnd(CHART_POS((yylsp[-2])));
    (yyval.arcbase)=(yyvsp[-2].arcbase);
    chart.Error.Error(CHART_POS_AFTER((yylsp[-2])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_AFTER((yylsp[-2])), "Here is the beginning of the command as I understood it.");
  #endif
}
#line 4965 "msc_lang.cc"
    break;

  case 71:
#line 1199 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
  #else
    if ((yyvsp[-1].cprocedure)) {
        auto ctx = ((yyvsp[-1].cprocedure))->MatchParameters(nullptr, CHART_POS_AFTER((yylsp[-1])), &chart);
        if (!ctx.first) {
            MscPushFlex(*YYGET_EXTRA(yyscanner), ((yyvsp[-1].cprocedure))->text.c_str(), ((yyvsp[-1].cprocedure))->text.length(), &((yylsp[-1])), ((yyvsp[-1].cprocedure))->file_pos, EInclusionReason::PROCEDURE);
            YYGET_EXTRA(yyscanner)->last_procedure = (yyvsp[-1].cprocedure);
            YYGET_EXTRA(yyscanner)->last_procedure_params = std::move(ctx.second);
            YYGET_EXTRA(yyscanner)->open_context_mode = base_parse_parm::EScopeOpenMode::PROC_REPLAY;
        }
    }
    (yyval.arcbase) = nullptr;
  #endif
}
#line 4986 "msc_lang.cc"
    break;

  case 72:
#line 1216 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is coming here.");
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[-2])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_AFTER((yylsp[-2])), "Here is the beginning of the command as I understood it.");
    if ((yyvsp[-2].cprocedure)) {
        auto ctx = ((yyvsp[-2].cprocedure))->MatchParameters(nullptr, CHART_POS_AFTER((yylsp[-2])), &chart);
        if (!ctx.first) {
            MscPushFlex(*YYGET_EXTRA(yyscanner), ((yyvsp[-2].cprocedure))->text.c_str(), ((yyvsp[-2].cprocedure))->text.length(), &((yylsp[-2])), ((yyvsp[-2].cprocedure))->file_pos, EInclusionReason::PROCEDURE);
            YYGET_EXTRA(yyscanner)->last_procedure = (yyvsp[-2].cprocedure);
            YYGET_EXTRA(yyscanner)->last_procedure_params = std::move(ctx.second);
            YYGET_EXTRA(yyscanner)->open_context_mode = base_parse_parm::EScopeOpenMode::PROC_REPLAY;
        }
    }
    (yyval.arcbase) = nullptr;
  #endif
}
#line 5014 "msc_lang.cc"
    break;

  case 73:
#line 1240 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[0])), CHART_POS_AFTER((yylsp[0])), "Here is the beginning of the command as I understood it.");
    if ((yyvsp[0].cprocedure)) {
        auto ctx = ((yyvsp[0].cprocedure))->MatchParameters(nullptr, CHART_POS_AFTER((yylsp[0])), &chart);
        if (!ctx.first) {
            MscPushFlex(*YYGET_EXTRA(yyscanner), ((yyvsp[0].cprocedure))->text.c_str(), ((yyvsp[0].cprocedure))->text.length(), &((yylsp[0])), ((yyvsp[0].cprocedure))->file_pos, EInclusionReason::PROCEDURE);
            YYGET_EXTRA(yyscanner)->last_procedure = (yyvsp[0].cprocedure);
            YYGET_EXTRA(yyscanner)->last_procedure_params = std::move(ctx.second);
            YYGET_EXTRA(yyscanner)->open_context_mode = base_parse_parm::EScopeOpenMode::PROC_REPLAY;
        }
    }
    (yyval.arcbase) = nullptr;
  #endif
}
#line 5037 "msc_lang.cc"
    break;

  case 74:
#line 1259 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-2].cprocedure) && (yyvsp[-1].procparaminvoclist)) {
        auto ctx = ((yyvsp[-2].cprocedure))->MatchParameters((yyvsp[-1].procparaminvoclist), CHART_POS((yylsp[-1])).end, &chart);
        if (!ctx.first) {
            MscPushFlex(*YYGET_EXTRA(yyscanner), ((yyvsp[-2].cprocedure))->text.c_str(), ((yyvsp[-2].cprocedure))->text.length(), &((yylsp[-2])), ((yyvsp[-2].cprocedure))->file_pos, EInclusionReason::PROCEDURE);
            YYGET_EXTRA(yyscanner)->last_procedure = (yyvsp[-2].cprocedure);
            YYGET_EXTRA(yyscanner)->last_procedure_params = std::move(ctx.second);
            YYGET_EXTRA(yyscanner)->open_context_mode = base_parse_parm::EScopeOpenMode::PROC_REPLAY;
        }
    } else {
        delete (yyvsp[-1].procparaminvoclist);
    }
    (yyval.arcbase) = nullptr;
  #endif
}
#line 5064 "msc_lang.cc"
    break;

  case 75:
#line 1282 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is coming here.");
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[-2])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[-3])), CHART_POS_AFTER((yylsp[-2])), "Here is the beginning of the command as I understood it.");
    if ((yyvsp[-3].cprocedure) && (yyvsp[-2].procparaminvoclist)) {
        auto ctx = ((yyvsp[-3].cprocedure))->MatchParameters((yyvsp[-2].procparaminvoclist), CHART_POS((yylsp[-2])).end, &chart);
        if (!ctx.first) {
            MscPushFlex(*YYGET_EXTRA(yyscanner), ((yyvsp[-3].cprocedure))->text.c_str(), ((yyvsp[-3].cprocedure))->text.length(), &((yylsp[-3])), ((yyvsp[-3].cprocedure))->file_pos, EInclusionReason::PROCEDURE);
            YYGET_EXTRA(yyscanner)->last_procedure = (yyvsp[-3].cprocedure);
            YYGET_EXTRA(yyscanner)->last_procedure_params = std::move(ctx.second);
            YYGET_EXTRA(yyscanner)->open_context_mode = base_parse_parm::EScopeOpenMode::PROC_REPLAY;
        }
    } else {
        delete (yyvsp[-2].procparaminvoclist);
    }
    (yyval.arcbase) = nullptr;
  #endif
}
#line 5094 "msc_lang.cc"
    break;

  case 76:
#line 1308 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[-1])), CHART_POS_AFTER((yylsp[0])), "Here is the beginning of the command as I understood it.");
    if ((yyvsp[-1].cprocedure) && (yyvsp[0].procparaminvoclist)) {
        auto ctx = ((yyvsp[-1].cprocedure))->MatchParameters((yyvsp[0].procparaminvoclist), CHART_POS((yylsp[0])).end, &chart);
        if (!ctx.first) {
            MscPushFlex(*YYGET_EXTRA(yyscanner), ((yyvsp[-1].cprocedure))->text.c_str(), ((yyvsp[-1].cprocedure))->text.length(), &((yylsp[-1])), ((yyvsp[-1].cprocedure))->file_pos, EInclusionReason::PROCEDURE);
            YYGET_EXTRA(yyscanner)->last_procedure = (yyvsp[-1].cprocedure);
            YYGET_EXTRA(yyscanner)->last_procedure_params = std::move(ctx.second);
            YYGET_EXTRA(yyscanner)->open_context_mode = base_parse_parm::EScopeOpenMode::PROC_REPLAY;
        }
    } else
        delete (yyvsp[0].procparaminvoclist);
    (yyval.arcbase) = nullptr;
  #endif
}
#line 5118 "msc_lang.cc"
    break;

  case 77:
#line 1328 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-1].str)) {
        auto text = chart.Include((yyvsp[-1].str), CHART_POS_START((yylsp[-1])));
        if (text.first && text.first->length() && text.second.IsValid())
            MscPushFlex(*YYGET_EXTRA(yyscanner), text.first->c_str(), text.first->length(), &((yylsp[-1])), text.second, EInclusionReason::INCLUDE);
    }
    (yyval.arcbase) = nullptr;
  #endif
    if ((yyvsp[-1].str)) free((yyvsp[-1].str));
}
#line 5140 "msc_lang.cc"
    break;

  case 78:
#line 1346 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon.");
  #else
    if ((yyvsp[0].str)) {
        auto text = chart.Include((yyvsp[0].str), CHART_POS_START((yylsp[0])));
        if (text.first && text.first->length() && text.second.IsValid())
            MscPushFlex(*YYGET_EXTRA(yyscanner), text.first->c_str(), text.first->length(), &((yylsp[0])), text.second, EInclusionReason::INCLUDE);
    }
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[0])), CHART_POS_AFTER((yylsp[0])), "Here is the beginning of the command as I understood it.");
    (yyval.arcbase) = nullptr;
  #endif
    if ((yyvsp[0].str)) free((yyvsp[0].str));
}
#line 5160 "msc_lang.cc"
    break;

  case 79:
#line 1362 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is coming here.");
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
       csh.AddLineBeginToHints();
       csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[-2])), "Missing a semicolon ';'.");
    chart.Error.Error(CHART_POS_START((yylsp[-2])), CHART_POS_AFTER((yylsp[-2])), "Here is the beginning of the command as I understood it.");
    if ((yyvsp[-2].str)) {
        auto text = chart.Include((yyvsp[-2].str), CHART_POS_START((yylsp[-2])));
        if (text.first && text.first->length() && text.second.IsValid())
            MscPushFlex(*YYGET_EXTRA(yyscanner), text.first->c_str(), text.first->length(), &((yylsp[-2])), text.second, EInclusionReason::INCLUDE);
    }
    (yyval.arcbase) = nullptr;
  #endif
    if ((yyvsp[-2].str)) free((yyvsp[-2].str));
}
#line 5185 "msc_lang.cc"
    break;

  case 80:
#line 1384 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing procedure name.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing procedure name.");
    (yyval.cprocedure) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 5200 "msc_lang.cc"
    break;

  case 81:
#line 1395 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_PROCNAME);
  #else
    (yyval.cprocedure) = nullptr;
    if (!(yyvsp[0].multi_str).had_error) {
        auto proc = chart.GetProcedure((yyvsp[0].multi_str).str);
        if (proc==nullptr)
            chart.Error.Error(CHART_POS_START((yylsp[0])), "Undefined procedure. Ignoring procedure call.");
        else if (proc->status==EDefProcResult::PROBLEM)
            chart.Error.Error(CHART_POS_START((yylsp[0])), "Ill-formed procedure. Ignoring procedure call.");
        else if (proc->status==EDefProcResult::OK) {
            //Only return the procedure if we are not inside a procedure definition
            if (!chart.SkipContent())
                (yyval.cprocedure) = proc;
            //else just move on parsing - we do not reparse procedure replays during
            //the definition of an outer procedure.
        }
        //else return null, emit no error for EMPTY
    }
  #endif
    free((yyvsp[-1].str));
    free((yyvsp[0].multi_str).str);
}
#line 5230 "msc_lang.cc"
    break;

  case 82:
#line 1422 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_PARENTHESIS);
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
  #else
    (yyval.procparaminvoclist) = new ProcParamInvocationList;
  #endif
}
#line 5243 "msc_lang.cc"
    break;

  case 83:
#line 1431 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_PARENTHESIS);
    csh.AddCSH_Error((yylsp[-1]), "Invalid parameter syntax.");
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
  #else
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Invalid parameter syntax. Ignoring procedure call.");
    (yyval.procparaminvoclist) = nullptr;
  #endif
}
#line 5258 "msc_lang.cc"
    break;

  case 84:
#line 1442 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing parameter list closed by a parenthesis ')'.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing parameter list closed by a parenthesis ')'. Ignoring procedure call.");
    (yyval.procparaminvoclist) = nullptr;
  #endif
}
#line 5272 "msc_lang.cc"
    break;

  case 85:
#line 1452 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_PARENTHESIS);
    csh.AddCSH_Error((yylsp[-1]), "Invalid parameter syntax.");
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
  #else
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Invalid parameter syntax. Ignoring procedure call.");
    delete (yyvsp[-2].procparaminvoclist);
    (yyval.procparaminvoclist) = nullptr;
  #endif
}
#line 5288 "msc_lang.cc"
    break;

  case 86:
#line 1464 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_PARENTHESIS);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing closing parenthesis ')'.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing closing parenthesis ')'. Ignoring procedure call.");
    delete (yyvsp[0].procparaminvoclist);
    (yyval.procparaminvoclist) = nullptr;
  #endif
}
#line 5303 "msc_lang.cc"
    break;

  case 87:
#line 1475 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_PARENTHESIS);
    csh.AddCSH((yylsp[0]), COLOR_PARENTHESIS);
  #else
    (yyval.procparaminvoclist) = (yyvsp[-1].procparaminvoclist);
  #endif
}
#line 5316 "msc_lang.cc"
    break;

  case 88:
#line 1485 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    if ((yyvsp[0].procparaminvoc)) {
        (yyval.procparaminvoclist) = new ProcParamInvocationList;
        ((yyval.procparaminvoclist))->Append((yyvsp[0].procparaminvoc));
    } else
        (yyval.procparaminvoclist)= nullptr;
  #endif
}
#line 5331 "msc_lang.cc"
    break;

  case 89:
#line 1496 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
  #else
    (yyval.procparaminvoclist) = new ProcParamInvocationList;
    ((yyval.procparaminvoclist))->Append(std::make_unique<ProcParamInvocation>(CHART_POS_START((yylsp[0]))));
  #endif
}
#line 5344 "msc_lang.cc"
    break;

  case 90:
#line 1505 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
  #else
    if ((yyvsp[0].procparaminvoc)) {
        (yyval.procparaminvoclist) = new ProcParamInvocationList;
        ((yyval.procparaminvoclist))->Append(std::make_unique<ProcParamInvocation>(CHART_POS_START((yylsp[-1]))));
        ((yyval.procparaminvoclist))->Append((yyvsp[0].procparaminvoc));
    } else
        (yyval.procparaminvoclist)= nullptr;
  #endif
}
#line 5361 "msc_lang.cc"
    break;

  case 91:
#line 1518 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
  #else
    if ((yyvsp[-1].procparaminvoclist))
        ((yyvsp[-1].procparaminvoclist))->Append(std::make_unique<ProcParamInvocation>(CHART_POS_AFTER((yylsp[0]))));
    (yyval.procparaminvoclist) = (yyvsp[-1].procparaminvoclist);
  #endif
}
#line 5375 "msc_lang.cc"
    break;

  case 92:
#line 1528 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
  #else
    if ((yyvsp[-2].procparaminvoclist) && (yyvsp[0].procparaminvoc)) {
        ((yyvsp[-2].procparaminvoclist))->Append((yyvsp[0].procparaminvoc));
        (yyval.procparaminvoclist) = (yyvsp[-2].procparaminvoclist);
    } else {
        delete (yyvsp[-2].procparaminvoclist);
        delete (yyvsp[0].procparaminvoc);
        (yyval.procparaminvoclist)= nullptr;
    }
  #endif
}
#line 5394 "msc_lang.cc"
    break;

  case 93:
#line 1544 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[0].multi_str).had_error) {
        //If this is a quoted string, color as a label, else as an attribute value
        if ((yylsp[0]).first_pos>0 && YYGET_EXTRA(yyscanner)->buff.buf[(yylsp[0]).first_pos-1]=='\"')
            csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].multi_str).str, {});
        else
            csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    }
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.procparaminvoc) = nullptr;
    else
        (yyval.procparaminvoc) = new ProcParamInvocation((yyvsp[0].multi_str).str, CHART_POS_START((yylsp[0])));
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 5416 "msc_lang.cc"
    break;

  case 94:
#line 1562 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
  #else
    //value of number is actually a string (containing digits)
    (yyval.procparaminvoc) = new ProcParamInvocation((yyvsp[0].str), CHART_POS_START((yylsp[0])));
  #endif
    free((yyvsp[0].str));
}
#line 5430 "msc_lang.cc"
    break;

  case 95:
#line 1573 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a file name to include. You must use quotation marks ('\"').");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE))
        csh.AddIncludeFilesToHints();
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a file name to include. You must use quotation marks ('\"').");
  #endif
    (yyval.str) = nullptr;
    free((yyvsp[0].str));
}
#line 5447 "msc_lang.cc"
    break;

  case 96:
#line 1586 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_INCLUDEFILE);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE))
        csh.AddIncludeFilesToHints();
    else if(csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_VALUE))
        csh.AddIncludeFilesToHints((yyvsp[0].str), (yylsp[0]));
  #endif
    (yyval.str) = (yyvsp[0].str);
    free((yyvsp[-1].str));
}
#line 5464 "msc_lang.cc"
    break;

  case 101:
#line 1604 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckLineStartHintBetween((yylsp[-1]), (yylsp[0]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[0].arcbase)) {
        if (CaseInsensitiveEqual((yyvsp[-1].str), "parallel"))
            ((yyvsp[0].arcbase))->SetParallel();
        else if (CaseInsensitiveEqual((yyvsp[-1].str), "overlap"))
            ((yyvsp[0].arcbase))->SetOverlap();
        else if (CaseInsensitiveEqual((yyvsp[-1].str), "join"))
            ((yyvsp[0].arcbase))->SetJoin(CHART_POS((yylsp[-1])));
        else {
            _ASSERT(0);
        }
    }
    (yyval.arcbase) = (yyvsp[0].arcbase);
  #endif
    free((yyvsp[-1].str));
}
#line 5495 "msc_lang.cc"
    break;

  case 102:
#line 1631 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::LINE_START)) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 5515 "msc_lang.cc"
    break;

  case 103:
#line 1648 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    if ((yyvsp[0].arcbase))
        ((yyvsp[0].arcbase))->AddAttributeList(nullptr);
    (yyval.arcbase)=((yyvsp[0].arcbase));
  #endif
}
#line 5528 "msc_lang.cc"
    break;

  case 104:
#line 1657 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Arrow::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Arrow::AttributeValues(csh.hintAttrName, csh);
  #else
    if ((yyvsp[-1].arcbase))
        ((yyvsp[-1].arcbase))->AddAttributeList((yyvsp[0].attriblist));
    (yyval.arcbase) = ((yyvsp[-1].arcbase));
  #endif
}
#line 5545 "msc_lang.cc"
    break;

  case 105:
#line 1670 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintAfter((yylsp[0])))
        csh.AllowAnything();
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing an arrow specification.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing an arrow specification.");
  #endif
    free((yyvsp[0].str));
    (yyval.arcbase) = nullptr;
}
#line 5565 "msc_lang.cc"
    break;

  case 106:
#line 1686 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintAt((yylsp[0])) || csh.CheckEntityHintBetween((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
  #else
    //Returns nullptr, if BIG is before a self-pointing arrow
    ArcBase *arc = chart.CreateBlockArrow((yyvsp[0].arcbase));
    if (arc)
        arc->AddAttributeList(nullptr);
    delete (yyvsp[0].arcbase);
    (yyval.arcbase) = arc;
  #endif
    free((yyvsp[-1].str));
}
#line 5588 "msc_lang.cc"
    break;

  case 107:
#line 1705 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        BlockArrow::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        BlockArrow::AttributeValues(csh.hintAttrName, csh);
    else if (csh.CheckEntityHintAt((yylsp[-1])) || csh.CheckEntityHintBetween((yylsp[-2]), (yylsp[-1])))
        csh.AllowAnything();
  #else
    //Returns nullptr, if BIG is before a self-pointing arrow
    BlockArrow *arrow = chart.CreateBlockArrow((yyvsp[-1].arcbase));
    if (arrow) arrow->AddAttributeList((yyvsp[0].attriblist));
    (yyval.arcbase) = arrow;
    delete (yyvsp[-1].arcbase);
  #endif
    free((yyvsp[-2].str));
}
#line 5614 "msc_lang.cc"
    break;

  case 108:
#line 1727 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVerticalTypesToHints();
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.addMarkersAtEnd = true;
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a marker or one of 'brace', 'bracket', 'range', 'box' or an arrow or box symbol, such as '->' or '--'.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a marker or one of 'brace', 'bracket', 'range', 'box' or an arrow or box symbol, such as '->' or '--'.");
  #endif
    free((yyvsp[0].str));
    (yyval.arcbase) = nullptr;
}
#line 5638 "msc_lang.cc"
    break;

  case 109:
#line 1747 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVerticalTypesToHints();
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.addMarkersAtEnd = true;
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
  #else
    if ((yyvsp[0].arcvertarrow)) {
      ((yyvsp[0].arcvertarrow))->SetVerticalShape(Vertical::ARROW_OR_BOX);
      ((yyvsp[0].arcvertarrow))->AddAttributeList(nullptr);
      (yyval.arcbase) = ((yyvsp[0].arcvertarrow));
    } else (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 5664 "msc_lang.cc"
    break;

  case 110:
#line 1769 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddVerticalTypesToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[0].arcvertarrow)) {
      ((yyvsp[0].arcvertarrow))->SetVerticalShape((yyvsp[-1].vshape));
      ((yyvsp[0].arcvertarrow))->AddAttributeList(nullptr);
      (yyval.arcbase) = ((yyvsp[0].arcvertarrow));
    } else (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-2].str));
}
#line 5689 "msc_lang.cc"
    break;

  case 111:
#line 1790 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVerticalTypesToHints();
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.addMarkersAtEnd = true;
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::MARKER)) {
        csh.hintStatus = HINT_FILLING;
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
    }
#else
	ArcTypePlusDir typeplusdir;
	typeplusdir.arc.type = EArcSymbol::ARC_SOLID;
	typeplusdir.arc.lost = EArrowLost::NOT;
	typeplusdir.dir = EDirType::RIGHT;
	Vertical *ava = new Vertical(&typeplusdir, MARKER_HERE_STR, MARKER_HERE_STR, &chart);
	VertXPos vxp;
	ava->AddXpos(&vxp);
    ava->SetVerticalShape((yyvsp[0].vshape));
    ava->AddAttributeList(nullptr);
	(yyval.arcbase) = ava;
  #endif
    free((yyvsp[-1].str));
}
#line 5724 "msc_lang.cc"
    break;

  case 112:
#line 1821 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddVerticalTypesToHints();
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.addMarkersAtEnd = true;
        csh.hintStatus = HINT_READY;
    } if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Vertical::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Vertical::AttributeValues(csh.hintAttrName, csh);
  #else
    if ((yyvsp[-1].arcvertarrow)) {
      ((yyvsp[-1].arcvertarrow))->SetVerticalShape(Vertical::ARROW_OR_BOX);
      ((yyvsp[-1].arcvertarrow))->AddAttributeList((yyvsp[0].attriblist));
      (yyval.arcbase) = ((yyvsp[-1].arcvertarrow));
    } else (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-2].str));
}
#line 5753 "msc_lang.cc"
    break;

  case 113:
#line 1846 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-3]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::KEYWORD)) {
        csh.AddVerticalTypesToHints();
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.addMarkersAtEnd = true;
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Vertical::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Vertical::AttributeValues(csh.hintAttrName, csh);
  #else
    if ((yyvsp[-1].arcvertarrow)) {
      ((yyvsp[-1].arcvertarrow))->SetVerticalShape((yyvsp[-2].vshape));
      ((yyvsp[-1].arcvertarrow))->AddAttributeList((yyvsp[0].attriblist));
      (yyval.arcbase) = ((yyvsp[-1].arcvertarrow));
    } else (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-3].str));
}
#line 5783 "msc_lang.cc"
    break;

  case 114:
#line 1872 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginAndParallelToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddVerticalTypesToHints();
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_KEYWORD) + "at", nullptr, EHintType::KEYWORD, true));
        csh.addMarkersAtEnd = true;
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::MARKER)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.addMarkersAtEnd = true;
        csh.hintStatus = HINT_FILLING;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Vertical::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Vertical::AttributeValues(csh.hintAttrName, csh);
  #else
	ArcTypePlusDir typeplusdir;
    typeplusdir.arc.type = EArcSymbol::ARC_SOLID;
	typeplusdir.arc.lost = EArrowLost::NOT;
	typeplusdir.dir = EDirType::RIGHT;
	Vertical *ava = new Vertical(&typeplusdir, MARKER_HERE_STR, MARKER_HERE_STR, &chart);
	VertXPos vxp;
	ava->AddXpos(&vxp);
    ava->SetVerticalShape((yyvsp[-1].vshape));
    ava->AddAttributeList((yyvsp[0].attriblist));
	(yyval.arcbase) = ava;
  #endif
    free((yyvsp[-2].str));
}
#line 5822 "msc_lang.cc"
    break;

  case 115:
#line 1907 "msc_lang.yy"
{
    //Here we have no label and may continue as a parallel block
    //->offer parallel attributes, as well...
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0]))) {
        Divider::AttributeNames(csh, false, false);
        ParallelBlocks::AttributeNames(csh, true);
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0]))) {
        Divider::AttributeValues(csh.hintAttrName, csh, false, false);
        ParallelBlocks::AttributeValues(csh.hintAttrName, csh, true);
    }
  #else
    //... but due to the lack of curly brace we are a divider
    (yyval.arcbase) = new Divider(EArcSymbol::DIV_VSPACE, &chart);
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
}
#line 5844 "msc_lang.cc"
    break;

  case 116:
#line 1925 "msc_lang.yy"
{
    //Here we have a colon label added: this is a divider
  #ifdef C_S_H_IS_COMPILED
  #else
    AttributeList *al = new AttributeList;
    al->Append(std::make_unique<Attribute>("label", (yyvsp[0].str), CHART_POS((yyloc)), CHART_POS((yyloc)).IncStartCol()));
    (yyval.arcbase) = new Divider(EArcSymbol::DIV_VSPACE, &chart);
    ((yyval.arcbase))->AddAttributeList(al);
  #endif
    free((yyvsp[0].str));
}
#line 5860 "msc_lang.cc"
    break;

  case 117:
#line 1937 "msc_lang.yy"
{
    //Here we have a colon label added: this is a divider
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Divider::AttributeNames(csh, false, false);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Divider::AttributeValues(csh.hintAttrName, csh, false, false);
  #else
    ((yyvsp[0].attriblist))->Prepend(std::make_unique<Attribute>("label", (yyvsp[-1].str), CHART_POS((yylsp[-1])), CHART_POS((yylsp[-1])).IncStartCol()));
    (yyval.arcbase) = new Divider(EArcSymbol::DIV_VSPACE, &chart);
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
#endif
    free((yyvsp[-1].str));
}
#line 5879 "msc_lang.cc"
    break;

  case 118:
#line 1952 "msc_lang.yy"
{
    //Here we have a colon label added: this is a divider
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-2])) ||
        csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Divider::AttributeNames(csh, false, false);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-2])) ||
             csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Divider::AttributeValues(csh.hintAttrName, csh, false, false);
  #else
    ((yyvsp[-2].attriblist))->Append(std::make_unique<Attribute>("label", (yyvsp[-1].str), CHART_POS((yylsp[-1])), CHART_POS((yylsp[-1])).IncStartCol()));
    //Merge $3 at the end of $1 (after the colon label, so ordering is kept)
    ((yyvsp[-2].attriblist))->splice(((yyvsp[-2].attriblist))->end(), *((yyvsp[0].attriblist)));
    delete ((yyvsp[0].attriblist)); //empty list now
    (yyval.arcbase) = new Divider(EArcSymbol::DIV_VSPACE, &chart);
    ((yyval.arcbase))->AddAttributeList((yyvsp[-2].attriblist));
#endif
    free((yyvsp[-1].str));
}
#line 5903 "msc_lang.cc"
    break;

  case 119:
#line 1972 "msc_lang.yy"
{
    //Here we have a colon label added: this is a divider
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        Divider::AttributeNames(csh, false, false);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        Divider::AttributeValues(csh.hintAttrName, csh, false, false);
  #else
    ((yyvsp[-1].attriblist))->Append(std::make_unique<Attribute>("label", (yyvsp[0].str), CHART_POS((yylsp[0])), CHART_POS((yylsp[0])).IncStartCol()));
    (yyval.arcbase) = new Divider(EArcSymbol::DIV_VSPACE, &chart);
    ((yyval.arcbase))->AddAttributeList((yyvsp[-1].attriblist));
  #endif
    free((yyvsp[0].str));
}
#line 5922 "msc_lang.cc"
    break;

  case 120:
#line 1987 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.arcbase) = (new EntityCommand((yyvsp[0].entitylist), &chart, false));
    ((yyval.arcbase))->AddAttributeList(nullptr);
  #endif
}
#line 5934 "msc_lang.cc"
    break;

  case 121:
#line 1995 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintAfter((yylsp[0])))
        csh.AllowAnything();
  #else
    //Show/Hide/Activate/Deactivate all entities so far.
    //Call constructor specifically created for this case.
    (yyval.arcbase) = new EntityCommand(&chart, (yyvsp[0].str), CHART_POS((yyloc)));
	((yyval.arcbase))->AddAttributeList(nullptr);
  #endif
    free((yyvsp[0].str));
}
#line 5955 "msc_lang.cc"
    break;

  case 122:
#line 2012 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetween((yylsp[-1]), (yylsp[0])) || csh.CheckEntityHintAt((yylsp[-1])))
        csh.AllowAnything();
  #else
    EntityCommand *ce = new EntityCommand((yyvsp[0].entitylist), &chart, false);
    ce->AddAttributeList(nullptr);
    (yyval.arcbase) = ce->ApplyPrefix((yyvsp[-1].str));
  #endif
    free((yyvsp[-1].str));
}
#line 5975 "msc_lang.cc"
    break;

  case 123:
#line 2028 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckEntityHintAfter((yylsp[0])))
        csh.AllowAnything();
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing an entity.");
  #else
    EntityCommand *ce = new EntityCommand((yyvsp[-1].entitylist), &chart, false);
    ce->AddAttributeList(nullptr);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing an entity.");
    (yyval.arcbase) = ce;
  #endif
}
#line 5993 "msc_lang.cc"
    break;

  case 124:
#line 2042 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckEntityHintBetween((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
  #else
    ((yyvsp[0].entitylist))->Prepend((yyvsp[-2].entitylist));
    EntityCommand *ce = new EntityCommand((yyvsp[0].entitylist), &chart, false);
    delete ((yyvsp[-2].entitylist));
    ce->AddAttributeList(nullptr);
    (yyval.arcbase) = ce;
  #endif
}
#line 6011 "msc_lang.cc"
    break;

  case 125:
#line 2056 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetween((yylsp[-2]), (yylsp[-1])) || csh.CheckEntityHintAt((yylsp[-2])))
        csh.AllowAnything();
    else if (csh.CheckEntityHintAfter((yylsp[0])))
        csh.AllowAnything();
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing an entity.");
  #else
    EntityCommand *ce = new EntityCommand((yyvsp[-1].entitylist), &chart, false);
    ce->AddAttributeList(nullptr);
    (yyval.arcbase) = ce->ApplyPrefix((yyvsp[-2].str));
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing an entity.");
  #endif
    free((yyvsp[-2].str));
}
#line 6036 "msc_lang.cc"
    break;

  case 126:
#line 2077 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckLineStartHintAt((yylsp[-3]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetween((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
#else
    ((yyvsp[0].entitylist))->Prepend((yyvsp[-2].entitylist));
    EntityCommand *ce = new EntityCommand((yyvsp[0].entitylist), &chart, false);
    delete ((yyvsp[-2].entitylist));
    ce->AddAttributeList(nullptr);
    (yyval.arcbase) = ce->ApplyPrefix((yyvsp[-3].str));
  #endif
    free((yyvsp[-3].str));
}
#line 6059 "msc_lang.cc"
    break;

  case 127:
#line 2096 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    /* If there were arcs defined by the options (e.g., background)
     * enclose them in an "ParallelBlocks" element used only for this.
     * This will be an internally defined ParallelBlocks that will
     * get unrolled in MscChart::PostParseArcList()*/
    (yyval.arcbase) = ((yyvsp[0].arclist)) ? new ParallelBlocks(&chart, (yyvsp[0].arclist), nullptr, true, true) : nullptr;
  #endif
}
#line 6074 "msc_lang.cc"
    break;

  case 128:
#line 2107 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    /* This may be a list of BoxSeries (each with one emptybox), we
     * enclose them in an "ParallelBlocks" element used only for this.
     * This will be an internally defined ParallelBlocks that will
     * get unrolled in MscChart::PostParseArcList()*/
    (yyval.arcbase) = ((yyvsp[0].arclist)) ? new ParallelBlocks(&chart, (yyvsp[0].arclist), nullptr, false, true) : nullptr;
  #endif
}
#line 6089 "msc_lang.cc"
    break;

  case 129:
#line 2118 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.arcbase) = (yyvsp[0].arcboxseries); //to remove warning for downcast
  #endif
}
#line 6100 "msc_lang.cc"
    break;

  case 130:
#line 2125 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.arcbase) = (yyvsp[0].arcpipeseries); //to remove warning for downcast
  #endif
}
#line 6111 "msc_lang.cc"
    break;

  case 131:
#line 2132 "msc_lang.yy"
{
    (yyval.arcbase) = (yyvsp[0].arcparallel);
}
#line 6119 "msc_lang.cc"
    break;

  case 132:
#line 2136 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    if (csh.SkipContent()) {
        csh.AddCSH_Error((yylsp[-1]), "Cannot define shapes inside a procedure.");
    }
  #else
    if (chart.SkipContent()) {
        chart.Error.Error(CHART_POS_START((yylsp[-1])), "Cannot define shapes inside a procedure.");
    }
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 6142 "msc_lang.cc"
    break;

  case 133:
#line 2155 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    if (csh.SkipContent()) {
        csh.AddCSH_Error((yylsp[0]), "Cannot define shapes inside a procedure.");
    } else {
        csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
        csh.AddCSH_ErrorAfter((yyloc), "Missing shape name and definition.");
    }
#else
    if (chart.SkipContent()) {
        chart.Error.Error(CHART_POS_START((yyloc)), "Cannot define shapes inside a procedure.");
    } else {
        chart.Error.Error(CHART_POS((yyloc)).end, "Missing shape name and definition.");
    }
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 6170 "msc_lang.cc"
    break;

  case 134:
#line 2179 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 6190 "msc_lang.cc"
    break;

  case 135:
#line 2195 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(true);
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing color name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a color name to (re-)define.");
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 6212 "msc_lang.cc"
    break;

  case 136:
#line 2213 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 6232 "msc_lang.cc"
    break;

  case 137:
#line 2229 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing style name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a style name to (re-)define.");
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 6254 "msc_lang.cc"
    break;

  case 138:
#line 2247 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    if (csh.SkipContent())
        csh.AddCSH_Error((yylsp[-1]), "Cannot define designs inside a procedure.");
  #else
    if (chart.SkipContent()) {
        chart.Error.Error(CHART_POS_START((yylsp[-1])), "Cannot define designs inside a procedure.");
    }
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 6275 "msc_lang.cc"
    break;

  case 139:
#line 2264 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    if (csh.SkipContent()) {
        csh.AddCSH_Error((yylsp[0]), "Cannot define designs inside a procedure.");
    } else {
        csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
        csh.AddCSH_ErrorAfter((yyloc), "Missing design name to (re-)define.");
    }
  #else
    if (chart.SkipContent()) {
        chart.Error.Error(CHART_POS_START((yyloc)), "Cannot define designs inside a procedure.");
    } else {
        chart.Error.Error(CHART_POS((yyloc)).end, "Missing a design name to (re-)define.");
    }
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 6302 "msc_lang.cc"
    break;

  case 140:
#line 2287 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.arcbase) = nullptr;
  #endif
}
#line 6313 "msc_lang.cc"
    break;

  case 141:
#line 2294 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.arcbase) = nullptr;
  #endif
}
#line 6324 "msc_lang.cc"
    break;

  case 142:
#line 2301 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arcbase) = new EntityCommand(&chart, (yyvsp[0].str), CHART_POS((yyloc)));
    ((yyval.arcbase))->AddAttributeList(nullptr);
  #endif
    free((yyvsp[0].str));
}
#line 6342 "msc_lang.cc"
    break;

  case 143:
#line 2315 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        EntityCommand::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        EntityCommand::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.arcbase) = (new EntityCommand(nullptr, &chart, false));
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
    free((yyvsp[-1].str));
}
#line 6363 "msc_lang.cc"
    break;

  case 144:
#line 2332 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arcbase) = (new Divider(EArcSymbol::DIV_VSPACE, &chart));
    ((yyval.arcbase))->AddAttributeList(nullptr);
  #endif
    free((yyvsp[0].str));
}
#line 6381 "msc_lang.cc"
    break;

  case 145:
#line 2346 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Divider::AttributeNames(csh, true, false);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Divider::AttributeValues(csh.hintAttrName, csh, true, false);
  #else
    (yyval.arcbase) = (new Divider(EArcSymbol::DIV_VSPACE, &chart));
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
    free((yyvsp[-1].str));
}
#line 6402 "msc_lang.cc"
    break;

  case 146:
#line 2363 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Divider::AttributeNames(csh, false, true);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Divider::AttributeValues(csh.hintAttrName, csh, false, true);
  #else
    const EArcSymbol t = CaseInsensitiveEqual("title", (yyvsp[-1].str)) ? EArcSymbol::DIV_TITLE :
                         CaseInsensitiveEqual("subtitle", (yyvsp[-1].str)) ? EArcSymbol::DIV_SUBTITLE :
                         EArcSymbol::INVALID;
    (yyval.arcbase) = (new Divider(t, &chart));
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
    free((yyvsp[-1].str));
}
#line 6426 "msc_lang.cc"
    break;

  case 147:
#line 2383 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yyloc), "Missing label.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing label. Ignoring (sub)title.", "Titles and subtitles must have a label.");
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 6445 "msc_lang.cc"
    break;

  case 148:
#line 2398 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing 'at' keyword.");
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing 'at' clause.");
#endif
    free((yyvsp[0].str));
}
#line 6467 "msc_lang.cc"
    break;

  case 149:
#line 2416 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Symbol::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Symbol::AttributeValues(csh.hintAttrName, csh);
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing 'at' keyword.");
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS((yylsp[-1])).end, "Missing 'at' clause. Ignoring this.");
    if ((yyvsp[0].attriblist))
        delete (yyvsp[0].attriblist);
  #endif
    free((yyvsp[-1].str));
}
#line 6494 "msc_lang.cc"
    break;

  case 150:
#line 2439 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Symbol::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Symbol::AttributeValues(csh.hintAttrName, csh);
#else
    if ((yyvsp[-1].vertxpos)) {
        Symbol *s = new Symbol(&chart, "text", (yyvsp[-1].vertxpos), CHART_POS((yylsp[-1])));
        s->AddAttributeList((yyvsp[0].attriblist));
        (yyval.arcbase) = s;
        delete (yyvsp[-1].vertxpos);
    } else {
        (yyval.arcbase) = nullptr;
    }
  #endif
    free((yyvsp[-2].str));
}
#line 6521 "msc_lang.cc"
    break;

  case 151:
#line 2462 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing label.");
  #else
    if ((yyvsp[0].vertxpos))
        delete (yyvsp[0].vertxpos);
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing actual text - specify a label. Ignoring this.");
    (yyval.arcbase) = nullptr;
#endif
    free((yyvsp[-1].str));
}
#line 6542 "msc_lang.cc"
    break;

  case 152:
#line 2479 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefixNonSelectable() + "<marker name>",
            "Specify the name of the marker.",
            EHintType::KEYWORD, false));
        csh.hintStatus=HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing marker name.");
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing marker name. Ignoring this.", "You need to supply a name which then can be used to refer to this vertical position you are marking here.");
  #endif
  free((yyvsp[0].str));
}
#line 6566 "msc_lang.cc"
    break;

  case 153:
#line 2499 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH((yylsp[0]), COLOR_MARKERNAME);
    if (!csh.SkipContent() && !(yyvsp[0].multi_str).had_error)
        csh.MarkerNames.insert((yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[0].multi_str).had_error) {
        (yyval.arcbase) = nullptr;
    } else {
        (yyval.arcbase) = new Marker((yyvsp[0].multi_str).str, CHART_POS((yyloc)), &chart);
        ((yyval.arcbase))->AddAttributeList(nullptr);
    }
  #endif
    free((yyvsp[-1].str));
    free((yyvsp[0].multi_str).str);
}
#line 6592 "msc_lang.cc"
    break;

  case 154:
#line 2521 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_MARKERNAME);
    if (!csh.SkipContent() && !(yyvsp[-1].multi_str).had_error)
        csh.MarkerNames.insert((yyvsp[-1].multi_str).str);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Marker::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Marker::AttributeValues(csh.hintAttrName, csh);
  #else
    if ((yyvsp[-1].multi_str).had_error) {
        (yyval.arcbase) = nullptr;
    } else {
        (yyval.arcbase) = new Marker((yyvsp[-1].multi_str).str, CHART_POS((yyloc)), &chart);
        ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
    }
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].multi_str).str);
}
#line 6621 "msc_lang.cc"
    break;

  case 155:
#line 2546 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefixNonSelectable() + "<marker name>",
            "Specify the name of the marker.",
            EHintType::KEYWORD, false));
        csh.hintStatus=HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Marker::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Marker::AttributeValues(csh.hintAttrName, csh);
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing marker name.");
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS((yylsp[-1])).end, "Missing marker name. Ignoring this.", "You need to supply a name which then can be used to refer to this vertical position you are marking here.");
    if ((yyvsp[0].attriblist))
        delete (yyvsp[0].attriblist);
  #endif
    free((yyvsp[-1].str));
}
#line 6650 "msc_lang.cc"
    break;

  case 156:
#line 2571 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_Error((yylsp[0]), "This is a reserved word and cannot be used as a marker name.");
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS_START((yylsp[0])), "This is a reserved word and cannot be used as a marker name. Ignoring this.");
  #endif
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 6670 "msc_lang.cc"
    break;

  case 157:
#line 2587 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Marker::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Marker::AttributeValues(csh.hintAttrName, csh);
    csh.AddCSH_Error((yylsp[-1]), "This is a reserved word and cannot be used as a marker name.");
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "This is a reserved word and cannot be used as a marker name. Ignoring this.");
    if ((yyvsp[0].attriblist))
        delete (yyvsp[0].attriblist);
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
}
#line 6695 "msc_lang.cc"
    break;

  case 158:
#line 2608 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
#else
    (yyval.arcbase) = new Newpage(&chart, true);
    ((yyval.arcbase))->AddAttributeList(nullptr);
  #endif
    free((yyvsp[0].str));
}
#line 6713 "msc_lang.cc"
    break;

  case 159:
#line 2622 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Newpage::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Newpage::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.arcbase) = new Newpage(&chart, true);
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
    free((yyvsp[-1].str));
}
#line 6734 "msc_lang.cc"
    break;

  case 163:
#line 2642 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        AddHSpace::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        AddHSpace::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.arcbase) = new AddHSpace(&chart, (yyvsp[-1].namerel));
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
    free((yyvsp[-2].str));
}
#line 6755 "msc_lang.cc"
    break;

  case 164:
#line 2659 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefixNonSelectable() + "<number>",
            "Enter a number in pixels to set horizontal spacing.",
            EHintType::KEYWORD, false));
        csh.AddToHints(CshHint(csh.HintPrefixNonSelectable() + "<label>",
            "Enter some text the width of which will be used as horizontal spacing.",
            EHintType::KEYWORD, false));
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing either a number or a label.");
  #else
    (yyval.arcbase) = new AddHSpace(&chart, (yyvsp[0].namerel)); //Will trigger an error: either label or space attr is needed
  #endif
    free((yyvsp[-1].str));
}
#line 6781 "msc_lang.cc"
    break;

  case 165:
#line 2681 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ENTITY)) {
        csh.AddEntitiesToHints();
        csh.AddLeftRightHSpaceToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing an entity, 'left comment' or 'right comment'.");
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing an entity, 'left comment' or 'right comment'. Ignoring this command.");
  #endif
    free((yyvsp[0].str));
}
#line 6804 "msc_lang.cc"
    break;

  case 166:
#line 2700 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ENTITY)) {
        csh.AddEntitiesToHints();
        csh.AddLeftRightHSpaceToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        AddHSpace::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        AddHSpace::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS((yylsp[-1])).end, "Missing an entity, 'left comment' or 'right comment'. Ignoring this command.");
    delete (yyvsp[0].attriblist);
  #endif
    free((yyvsp[-1].str));
}
#line 6830 "msc_lang.cc"
    break;

  case 167:
#line 2722 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        AddVSpace::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        AddVSpace::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.arcbase) = new AddVSpace(&chart);
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
    free((yyvsp[-1].str));
}
#line 6851 "msc_lang.cc"
    break;

  case 168:
#line 2739 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefixNonSelectable() + "<number>",
            "Enter a number in pixels to add that much empty vertical spacing.",
            EHintType::KEYWORD, false));
        csh.AddToHints(CshHint(csh.HintPrefixNonSelectable() + "<label>",
            "Enter some text the height of which will be added as vertical empty space.",
            EHintType::KEYWORD, false));
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing either a number or a label.");
  #else
    (yyval.arcbase) = new AddVSpace(&chart); //will result in an error, since label or space attribute is needed
  #endif
    free((yyvsp[0].str));
}
#line 6877 "msc_lang.cc"
    break;

  case 169:
#line 2761 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.IfThenElses.push_back((yyloc));
  #endif
    (yyval.arcbase) = (yyvsp[0].arcbase);
}
#line 6888 "msc_lang.cc"
    break;

  case 173:
#line 2773 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (CaseInsensitiveEqual((yyvsp[-1].str), "left") || CaseInsensitiveEqual((yyvsp[-1].str), "right"))
        csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    else
        csh.AddCSH_Error((yylsp[-1]), "Use either `left comment` or `right comment` to specify which comment column to size.");
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ENTITY)) {
        csh.AddEntitiesToHints();
        csh.AddLeftRightHSpaceToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (CaseInsensitiveEqual((yyvsp[-1].str), "left"))
        (yyval.namerel) = new NamePair(LNOTE_ENT_STR, CHART_POS((yylsp[-1])), nullptr, CHART_POS((yylsp[-1])));
    else if (CaseInsensitiveEqual((yyvsp[-1].str), "right"))
        (yyval.namerel) = new NamePair(RNOTE_ENT_STR, CHART_POS((yylsp[-1])), nullptr, CHART_POS((yylsp[-1])));
    else {
        chart.Error.Error(CHART_POS_START((yylsp[-1])), "Use either `left` or `right` to specify which comment column to size. Ignoring command.");
        (yyval.namerel) = nullptr;
    }
  #endif
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 6918 "msc_lang.cc"
    break;

  case 174:
#line 2799 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (CaseInsensitiveEqual((yyvsp[0].str), "left") || CaseInsensitiveEqual((yyvsp[0].str), "right")) {
        csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
        if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
            csh.AddToHints(CshHint(csh.HintPrefix(COLOR_KEYWORD) + "comment", nullptr, EHintType::KEYWORD, true));
            csh.hintStatus = HINT_READY;
        }
    }  else
        csh.AddCSH_Error((yylsp[0]), "Use either `left comment` or `right comment` to specify which comment column to size.");
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::ENTITY)) {
        csh.AddEntitiesToHints();
        csh.AddLeftRightHSpaceToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Use <entity>-<entity>, `left comment`, `right comment` to specify horizontal spacing. Ignoring command.");
    (yyval.namerel) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 6944 "msc_lang.cc"
    break;

  case 175:
#line 2821 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::ENTITY)) {
        csh.AddEntitiesToHints();
        csh.AddLeftRightHSpaceToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Use `left comment` or `right comment` to specify horizontal spacing for comments. Ignoring command.");
    (yyval.namerel) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 6963 "msc_lang.cc"
    break;

  case 176:
#line 2838 "msc_lang.yy"
{
    (yyval.compare_op) = (yyvsp[0].arcsymbol)==EArcSymbol::BOX_DOUBLE ? ECompareOperator::EQUAL : ECompareOperator::INVALID;
}
#line 6971 "msc_lang.cc"
    break;

  case 177:
#line 2842 "msc_lang.yy"
{
    (yyval.compare_op) = (yyvsp[0].arcsymbol)==EArcSymbol::ARC_DOUBLE_BIDIR ? ECompareOperator::EQUAL : ECompareOperator::INVALID;
}
#line 6979 "msc_lang.cc"
    break;

  case 178:
#line 2846 "msc_lang.yy"
{
    (yyval.compare_op) = (yyvsp[0].arcsymbol)==EArcSymbol::ARC_DOUBLE ? ECompareOperator::GREATER_OR_EQUAL : (yyvsp[0].arcsymbol)==EArcSymbol::ARC_DOTTED ? ECompareOperator::GREATER : ECompareOperator::INVALID;
}
#line 6987 "msc_lang.cc"
    break;

  case 179:
#line 2850 "msc_lang.yy"
{
    (yyval.compare_op) = (yyvsp[0].arcsymbol)==EArcSymbol::ARC_DOUBLE ? ECompareOperator::SMALLER_OR_EQUAL : (yyvsp[0].arcsymbol)==EArcSymbol::ARC_DOTTED ? ECompareOperator::SMALLER : ECompareOperator::INVALID;
}
#line 6995 "msc_lang.cc"
    break;

  case 180:
#line 2854 "msc_lang.yy"
{
    (yyval.compare_op) = (yyvsp[0].arcsymbol)==EArcSymbol::ARC_DOTTED_BIDIR ? ECompareOperator::NOT_EQUAL : ECompareOperator::INVALID;
}
#line 7003 "msc_lang.cc"
    break;

  case 181:
#line 2859 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
  #endif
    (yyval.condition) = (yyvsp[0].multi_str).had_error ? 2 : (yyvsp[0].multi_str).str && (yyvsp[0].multi_str).str[0];
    free((yyvsp[0].multi_str).str);
}
#line 7015 "msc_lang.cc"
    break;

  case 182:
#line 2867 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_ATTRVALUE);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing string to compare to.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing string to compare to.");
  #endif
    (yyval.condition) = 2;
    free((yyvsp[-1].multi_str).str);
    (yyvsp[0].compare_op); //to suppress
}
#line 7032 "msc_lang.cc"
    break;

  case 183:
#line 2880 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_ATTRVALUE);
    if ((yyvsp[-1].compare_op)!=ECompareOperator::INVALID) {
        csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
        (yyval.condition) = (yyvsp[-2].multi_str).Compare((yyvsp[-1].compare_op), (yyvsp[0].multi_str));
    } else {
        csh.AddCSH_Error((yylsp[-1]), "Bad comparison operator. Use one of '==', '<>', '<=', '=>', '<' or '>'.");
        (yyval.condition) = 2;
    }
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
  #else
    if ((yyvsp[-1].compare_op)!=ECompareOperator::INVALID)
        (yyval.condition) = (yyvsp[-2].multi_str).Compare((yyvsp[-1].compare_op), (yyvsp[0].multi_str));
    else {
        chart.Error.Error(CHART_POS_START((yylsp[-1])), "Bad comparison operator. Use one of '==', '<>', '<=', '=>', '<' or '>'.");
        (yyval.condition) = 2;
    }
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 7059 "msc_lang.cc"
    break;

  case 184:
#line 2903 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_ATTRVALUE);
    csh.AddCSH_Error((yylsp[-1]), "Bad comparison operator. Use one of '==', '<>', '<=', '=>', '<' or '>'.");
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
  #else
     chart.Error.Error(CHART_POS_START((yylsp[-1])), "Bad comparison operator. Use one of '==', '<>', '<=', '=>', '<' or '>'.");
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
    (yyval.condition) = 2;
}
#line 7076 "msc_lang.cc"
    break;

  case 185:
#line 2919 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    (yyval.condition) = csh.Contexts.back().if_condition = (yyvsp[-1].condition);
    const bool cond_true = (yyvsp[-1].condition)==1;
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    if (cond_true)
        csh.PushContext();
    else
        csh.PushContext(true, EContextParse::SKIP_CONTENT);
  #else
    (yyval.condition) = chart.MyCurrentContext().if_condition = (yyvsp[-1].condition);
    const bool cond_true = (yyvsp[-1].condition)==1;
    if (cond_true)
        chart.PushContext(CHART_POS_START((yylsp[-2])));
    else
        chart.PushContext(CHART_POS_START((yylsp[-2])), EContextParse::SKIP_CONTENT);
    chart.MyCurrentContext().export_colors = cond_true;
    chart.MyCurrentContext().export_styles = cond_true;
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 7108 "msc_lang.cc"
    break;

  case 186:
#line 2947 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    (yyval.condition) = csh.Contexts.back().if_condition = 2;
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing 'then' keyword.");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_KEYWORD) + "then",
            "Continue the 'if' statement with 'then'.",
            EHintType::KEYWORD, true));
        csh.hintStatus = HINT_READY;
    }
    csh.PushContext(true, EContextParse::SKIP_CONTENT);
  #else
    (yyval.condition) = chart.MyCurrentContext().if_condition = 2;
    chart.PushContext(CHART_POS_START((yylsp[-1])), EContextParse::SKIP_CONTENT);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing 'then' keyword.");
  #endif
    free((yyvsp[-1].str));
    (yyvsp[0].condition); //to supress warnings
}
#line 7133 "msc_lang.cc"
    break;

  case 187:
#line 2968 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    (yyval.condition) = csh.Contexts.back().if_condition = 2;
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing condition.");
    csh.PushContext(true, EContextParse::SKIP_CONTENT);
  #else
    (yyval.condition) = chart.MyCurrentContext().if_condition = 2;
    chart.PushContext(CHART_POS_START((yylsp[0])), EContextParse::SKIP_CONTENT);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing condition after 'if'.");
  #endif
    free((yyvsp[0].str));
}
#line 7151 "msc_lang.cc"
    break;

  case 188:
#line 2982 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    (yyval.condition) = csh.Contexts.back().if_condition = 2;
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH_Error((yylsp[0]), "Missing condition instead of this.");
    csh.PushContext(true, EContextParse::SKIP_CONTENT);
  #else
    (yyval.condition) = chart.MyCurrentContext().if_condition = 2;
    chart.PushContext(CHART_POS_START((yylsp[-1])), EContextParse::SKIP_CONTENT);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Missing condition after 'if'.");
  #endif
    free((yyvsp[-1].str));
}
#line 7169 "msc_lang.cc"
    break;

  case 189:
#line 2996 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    (yyval.condition) = csh.Contexts.back().if_condition = 2;
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH_Error((yylsp[-1]), "Missing condition instead of this.");
    csh.PushContext(true, EContextParse::SKIP_CONTENT);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.condition) = chart.MyCurrentContext().if_condition = 2;
    chart.PushContext(CHART_POS_START((yylsp[-2])), EContextParse::SKIP_CONTENT);
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Missing condition after 'if'.");
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].str));
}
#line 7192 "msc_lang.cc"
    break;

  case 190:
#line 3017 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAfter((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.PopContext();
    const bool cond_false = csh.Contexts.back().if_condition==0;
    //Return value not used, just there so that nonterminal 'else' can have destructor
    (yyval.condition) = csh.Contexts.back().if_condition;
    if (cond_false)
        csh.PushContext();
    else
        csh.PushContext(true, EContextParse::SKIP_CONTENT);
  #else
    //kill previous context and open new one - set laterreparse if error or if condition was true
    //this will ignore everything in the else clause
    chart.PopContext();
    const bool cond_false = chart.MyCurrentContext().if_condition==0;
    //Return value not used, just there so that nonterminal 'else' can have destructor
    (yyval.condition) = chart.MyCurrentContext().if_condition;
    if (cond_false)
        chart.PushContext(CHART_POS_START((yylsp[0])));
    else
        chart.PushContext(CHART_POS_START((yylsp[0])), EContextParse::SKIP_CONTENT);
  #endif
  free((yyvsp[0].str));
}
#line 7226 "msc_lang.cc"
    break;

  case 191:
#line 3048 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstructionIfNotBrace((yylsp[0]));
    csh.PopContext();
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_KEYWORD) + "else",
            "Continue the 'if/then' statement with 'else'.",
            EHintType::KEYWORD, true));
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-1].condition)==1) {
        (yyval.arcbase) = (yyvsp[0].arcbase);
    } else {
        (yyval.arcbase) = nullptr;
        delete (yyvsp[0].arcbase);
    }
    chart.PopContext();
  #endif
}
#line 7251 "msc_lang.cc"
    break;

  case 192:
#line 3069 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if ((yyvsp[0].condition)!=2)
        csh.AddCSH_ErrorAfter((yylsp[0]), "Missing command after 'then'.");
    csh.PopContext();
  #else
    if ((yyvsp[0].condition)!=2)
        chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a well-formed command after 'then'. Ignoring 'if' clause.");
    chart.PopContext();
    (yyval.arcbase) = nullptr;
  #endif
    (yyvsp[0].condition); //suppress
}
#line 7269 "msc_lang.cc"
    break;

  case 193:
#line 3083 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[0]), "Missing command after 'then'.");
    csh.PopContext();
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Missing a well-formed command. Ignoring 'if' clause.");
    chart.PopContext();
    (yyval.arcbase) = nullptr;
  #endif
    (yyvsp[-1].condition); //suppress
}
#line 7285 "msc_lang.cc"
    break;

  case 194:
#line 3095 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstructionIfNotBrace((yylsp[-1]));
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing command after 'else'.");
    csh.PopContext();
  #else
    delete (yyvsp[-1].arcbase);
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing command after 'else'. Ignoring 'if' clause.");
    chart.PopContext();
  #endif
    (yyvsp[-2].condition); (yyvsp[0].condition); //suppress
}
#line 7303 "msc_lang.cc"
    break;

  case 195:
#line 3109 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstructionIfNotBrace((yylsp[-2]));
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is coming here.");
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing command after 'else'.");
    csh.PopContext();
  #else
    delete (yyvsp[-2].arcbase);
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "I am not sure what is coming here.");
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing command after 'else'. Ignoring 'if' clause.");
    chart.PopContext();
  #endif
    (yyvsp[-3].condition); (yyvsp[0].condition); //suppress
}
#line 7323 "msc_lang.cc"
    break;

  case 196:
#line 3125 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[-1]), "I am not sure what is coming here.");
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing command after 'else'.");
    csh.PopContext();
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "I am not sure what is coming here.");
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing command after 'else'. Ignoring 'if' clause.");
    chart.PopContext();
  #endif
    (yyvsp[-2].condition); (yyvsp[0].condition); //suppress
}
#line 7341 "msc_lang.cc"
    break;

  case 197:
#line 3139 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstructionIfNotBrace((yylsp[-2]));
    csh.AddInstructionIfNotBrace((yylsp[0]));
    csh.PopContext();
  #else
    switch ((yyvsp[-3].condition)) {
    case 1: //original condition was true
        (yyval.arcbase) = (yyvsp[-2].arcbase);   //take 'then' branch
        delete (yyvsp[0].arcbase); //delete 'else' branch
        break;
    case 0: //original condition was false
        (yyval.arcbase) = (yyvsp[0].arcbase); //take 'else' branch
        delete (yyvsp[-2].arcbase); //delete 'then' branch
        break;
    default:
        _ASSERT(0);
        FALLTHROUGH;
    case 2: //we had an error, but has reported the error - delete both branches
        (yyval.arcbase) = nullptr;
        delete (yyvsp[-2].arcbase);
        delete (yyvsp[0].arcbase);
    }
    chart.PopContext();
  #endif
    (yyvsp[-1].condition); //suppress
}
#line 7373 "msc_lang.cc"
    break;

  case 198:
#line 3167 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstructionIfNotBrace((yylsp[-3]));
    csh.AddInstructionIfNotBrace((yylsp[0]));
    csh.AddCSH_Error((yylsp[-2]), "I am not sure what is coming here.");
    csh.PopContext();
  #else
    (yyval.arcbase) = nullptr;
    delete (yyvsp[-3].arcbase);
    delete (yyvsp[0].arcbase);
    chart.Error.Error(CHART_POS_START((yylsp[-2])), "I am not sure what is coming here. Ignoring 'if' command.");
    chart.PopContext();
  #endif
    (yyvsp[-4].condition); (yyvsp[-1].condition); //suppress
}
#line 7393 "msc_lang.cc"
    break;

  case 199:
#line 3183 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddInstructionIfNotBrace((yylsp[0]));
    csh.AddCSH_Error((yylsp[-2]), "I am not sure what is coming here.");
    csh.PopContext();
  #else
    (yyval.arcbase) = nullptr;
    delete (yyvsp[0].arcbase);
    chart.Error.Error(CHART_POS_START((yylsp[-2])), "I am not sure what is coming here. Ignoring 'if' command.");
    chart.PopContext();
  #endif
    (yyvsp[-3].condition); (yyvsp[-1].condition); //suppress
}
#line 7411 "msc_lang.cc"
    break;

  case 201:
#line 3201 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
  #else
    AttributeList *al = new AttributeList;
    al->Append(std::make_unique<Attribute>("space", (yyvsp[0].str), CHART_POS((yylsp[0])), CHART_POS((yylsp[0]))));
    (yyval.attriblist) = al;
  #endif
    free((yyvsp[0].str));
}
#line 7426 "msc_lang.cc"
    break;

  case 202:
#line 3212 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_ATTRVALUE);
  #else
    ((yyvsp[0].attriblist))->Append(std::make_unique<Attribute>("space", (yyvsp[-1].str), CHART_POS((yylsp[-1])), CHART_POS((yylsp[-1]))));
    (yyval.attriblist) = (yyvsp[0].attriblist);
  #endif
    free((yyvsp[-1].str));
}
#line 7440 "msc_lang.cc"
    break;

  case 205:
#line 3225 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.CheckEntityHintAt((yylsp[-1]));
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    csh.CheckEntityHintAfter((yylsp[0]));
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.namerel) = nullptr;
    else
        (yyval.namerel) = new NamePair((yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), nullptr, FileLineColRange());
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 7460 "msc_lang.cc"
    break;

  case 206:
#line 3241 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
    csh.CheckEntityHintAt((yylsp[0]));
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.namerel) = nullptr;
    else
        (yyval.namerel) = new NamePair(nullptr, FileLineColRange(), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 7479 "msc_lang.cc"
    break;

  case 207:
#line 3256 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    csh.CheckEntityHintAfter((yylsp[0]));
  #else
    (yyval.namerel) = nullptr;
  #endif
}
#line 7492 "msc_lang.cc"
    break;

  case 208:
#line 3265 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    csh.CheckEntityHintAt((yylsp[-2]));
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
    csh.CheckEntityHintAt((yylsp[0]));
  #else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error)
        (yyval.namerel) = nullptr;
    else
        (yyval.namerel) = new NamePair((yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 7515 "msc_lang.cc"
    break;

  case 209:
#line 3284 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
    csh.CheckEntityHintAt((yylsp[0]));
  #else
    (yyval.namerel) = new NamePair((yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), nullptr, FileLineColRange());
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 7529 "msc_lang.cc"
    break;

  case 210:
#line 3296 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_MARKERNAME);
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    csh.CheckHintAt((yylsp[-1]), EHintSourceType::MARKER);
    csh.CheckHintAfter((yylsp[0]), EHintSourceType::MARKER);
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.namerel) = nullptr;
    else
        (yyval.namerel) = new NamePair((yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), nullptr, FileLineColRange());
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 7548 "msc_lang.cc"
    break;

  case 211:
#line 3311 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    csh.AddCSH((yylsp[0]), COLOR_MARKERNAME);
    csh.CheckHintAt((yylsp[0]), EHintSourceType::MARKER);
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.namerel) = nullptr;
    else
        (yyval.namerel) = new NamePair(nullptr, FileLineColRange(), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 7566 "msc_lang.cc"
    break;

  case 212:
#line 3325 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    csh.CheckHintAt((yylsp[0]), EHintSourceType::MARKER);
    csh.CheckHintAfter((yylsp[0]), EHintSourceType::MARKER);
  #else
    (yyval.namerel) = nullptr;
  #endif
}
#line 7580 "msc_lang.cc"
    break;

  case 213:
#line 3335 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_MARKERNAME);
    csh.CheckHintAt((yylsp[-2]), EHintSourceType::MARKER);
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    csh.AddCSH((yylsp[0]), COLOR_MARKERNAME);
    csh.CheckHintAt((yylsp[0]), EHintSourceType::MARKER);
  #else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error)
        (yyval.namerel) = nullptr;
    else
        (yyval.namerel) = new NamePair((yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 7601 "msc_lang.cc"
    break;

  case 218:
#line 3355 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].arcbase)) {
        (yyval.arclist) = (new ArcList)->Append((yyvsp[0].arcbase)); /* New list */
        //($1)->MakeMeLastNotable(); Do not make chart options notable
    } else
        (yyval.arclist) = nullptr;
  #endif
}
#line 7615 "msc_lang.cc"
    break;

  case 219:
#line 3365 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[0].arcbase)) {
        if ((yyvsp[-2].arclist))
            (yyval.arclist) = ((yyvsp[-2].arclist))->Append((yyvsp[0].arcbase));     /* Add to existing list */
        else
            (yyval.arclist) = (new ArcList)->Append((yyvsp[0].arcbase)); /* New list */
        //($3)->MakeMeLastNotable(); Do not make chart options notable
    } else
        (yyval.arclist) = (yyvsp[-2].arclist);
  #endif
}
#line 7638 "msc_lang.cc"
    break;

  case 220:
#line 3384 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arclist) = (yyvsp[-1].arclist);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Expecting an option here.");
  #endif
}
#line 7655 "msc_lang.cc"
    break;

  case 221:
#line 3397 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_Error((yylsp[0]), "An option expected here.");
  #else
    (yyval.arclist) = (yyvsp[-2].arclist);
  #endif
}
#line 7672 "msc_lang.cc"
    break;

  case 222:
#line 3412 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].multi_str).str, COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (!(yyvsp[-2].multi_str).had_error && csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].multi_str).str)) {
        MscChart::AttributeValues((yyvsp[-2].multi_str).str, csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-2].multi_str).had_error || ((yyvsp[-2].multi_str).had_param && chart.SkipContent()))
        (yyval.arcbase) = nullptr;
    else
        (yyval.arcbase) = chart.AddAttribute(Attribute((yyvsp[-2].multi_str).str, (yyvsp[0].str), CHART_POS((yylsp[-2])), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].str));
}
#line 7699 "msc_lang.cc"
    break;

  case 223:
#line 3435 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-2].multi_str).had_error) {
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].multi_str).str, COLOR_OPTIONNAME);
        csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].multi_str).str, (yyvsp[-2].multi_str).str);
    }
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (!(yyvsp[-2].multi_str).had_error && csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].multi_str).str)) {
        MscChart::AttributeValues((yyvsp[-2].multi_str).str, csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error ||
        (((yyvsp[-2].multi_str).had_param || (yyvsp[0].multi_str).had_param) && chart.SkipContent()))
        (yyval.arcbase) = nullptr;
    else
        (yyval.arcbase) = chart.AddAttribute(Attribute((yyvsp[-2].multi_str).str, (yyvsp[0].multi_str).str, CHART_POS((yylsp[-2])), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 7728 "msc_lang.cc"
    break;

  case 224:
#line 3460 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_AttrName((yylsp[-1]), (yyvsp[-1].multi_str).str, COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing option value.");
    if (!(yyvsp[-1].multi_str).had_error && csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-1].multi_str).str)) {
        MscChart::AttributeValues((yyvsp[-1].multi_str).str, csh);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing option value.");
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 7752 "msc_lang.cc"
    break;

  case 225:
#line 3480 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_DESIGNNAME);
    if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, "msc")) {
        csh.AddDesignsToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
    if (!(yyvsp[0].multi_str).had_error && !csh.SkipContent()) {
        std::string msg = csh.SetDesignTo((yyvsp[0].multi_str).str, true);
        if (msg.length())
            csh.AddCSH_Error((yylsp[0]), std::move(msg));
    }
  #else
    if (chart.SkipContent())
        (yyval.arcbase) = nullptr;
    else
        (yyval.arcbase) = chart.AddAttribute(Attribute("msc", (yyvsp[0].multi_str).str, CHART_POS((yyloc)), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].multi_str).str);
}
#line 7784 "msc_lang.cc"
    break;

  case 226:
#line 3508 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing option value.");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, "msc")) {
        csh.AddDesignsToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing option value.");
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 7807 "msc_lang.cc"
    break;

  case 227:
#line 3527 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_DESIGNNAME);
    if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, "msc+")) {
        csh.AddDesignsToHints(false);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
    if (!(yyvsp[0].multi_str).had_error) {
        std::string msg = csh.SetDesignTo((yyvsp[0].multi_str).str, false);
        if (msg.length())
            csh.AddCSH_Error((yylsp[0]), std::move(msg));
    }
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.arcbase) = nullptr;
    else
        (yyval.arcbase) = chart.AddAttribute(Attribute("msc+", (yyvsp[0].multi_str).str, CHART_POS((yyloc)), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].multi_str).str);
}
#line 7839 "msc_lang.cc"
    break;

  case 228:
#line 3555 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing option value.");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, "msc+")) {
        csh.AddDesignsToHints(false);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing option value.");
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 7862 "msc_lang.cc"
    break;

  case 229:
#line 3575 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    (yyval.entitylist) = ((yyvsp[0].entitylist));
  #endif
}
#line 7872 "msc_lang.cc"
    break;

  case 230:
#line 3581 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckEntityHintBetween((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
#else
    ((yyvsp[0].entitylist))->Prepend((yyvsp[-2].entitylist));
    (yyval.entitylist) = (yyvsp[0].entitylist);
    delete ((yyvsp[-2].entitylist));
  #endif
}
#line 7888 "msc_lang.cc"
    break;

  case 231:
#line 3593 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckEntityHintAfter((yylsp[0])))
        csh.AllowAnything();
  #else
    (yyval.entitylist) = ((yyvsp[-1].entitylist));
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Expecting an entity here.");
  #endif
}
#line 7903 "msc_lang.cc"
    break;

  case 232:
#line 3606 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-1])))
        csh.AllowAnything();
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        EntityApp::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        EntityApp::AttributeValues(csh.hintAttrName, csh);
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.entitylist) = nullptr;
    else {
        EntityApp *ed = new EntityApp((yyvsp[-1].multi_str).str, &chart);
        ed->SetLineEnd(CHART_POS((yyloc)));
        (yyval.entitylist) = ed->AddAttributeList((yyvsp[0].attriblist), nullptr, FileLineCol());
    }
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 7929 "msc_lang.cc"
    break;

  case 233:
#line 3628 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.entitylist) = nullptr;
    else {
        EntityApp *ed = new EntityApp((yyvsp[0].multi_str).str, &chart);
        ed->SetLineEnd(CHART_POS((yyloc)));
        (yyval.entitylist) = ed->AddAttributeList(nullptr, nullptr, FileLineCol());
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 7951 "msc_lang.cc"
    break;

  case 234:
#line 3646 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        EntityApp::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        EntityApp::AttributeValues(csh.hintAttrName, csh);
  #else
    if ((yyvsp[-2].multi_str).had_error)
        (yyval.entitylist) = nullptr;
    else {
        EntityApp *ed = new EntityApp((yyvsp[-2].multi_str).str, &chart);
        ed->SetLineEnd(CHART_POS2((yylsp[-2]), (yylsp[-1])));
        (yyval.entitylist) = ed->AddAttributeList((yyvsp[-1].attriblist), (yyvsp[0].arclist), CHART_POS_START((yylsp[0])));
    }
  #endif
    free((yyvsp[-2].multi_str).str);
}
#line 7977 "msc_lang.cc"
    break;

  case 235:
#line 3668 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-1])))
        csh.AllowAnything();
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.entitylist) = nullptr;
    else {
       EntityApp *ed = new EntityApp((yyvsp[-1].multi_str).str, &chart);
       ed->SetLineEnd(CHART_POS((yylsp[-1])));
       (yyval.entitylist) = ed->AddAttributeList(nullptr, (yyvsp[0].arclist), CHART_POS_START((yylsp[0])));
    }
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 7999 "msc_lang.cc"
    break;

  case 236:
#line 3687 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        EntityApp::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        EntityApp::AttributeValues(csh.hintAttrName, csh);
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_KeywordOrEntity((yylsp[-1]), (yyvsp[-1].multi_str).str);  //Do it after AddLineBeginToHints so if this is a newly defined entity it one is not included among the hints
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.entitylist) = nullptr;
    else {
        EntityApp *ed = new EntityApp((yyvsp[-1].multi_str).str, &chart);
        ed->SetLineEnd(CHART_POS((yyloc)));
        (yyval.entitylist) = ed->AddAttributeList((yyvsp[0].attriblist), nullptr, FileLineCol());
    }
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 8026 "msc_lang.cc"
    break;

  case 237:
#line 3710 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_KeywordOrEntity((yylsp[0]), (yyvsp[0].multi_str).str);   //Do it after AddLineBeginToHints so if this is a newly defined entity it one is not included among the hints
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.entitylist) = nullptr;
    else {
        EntityApp *ed = new EntityApp((yyvsp[0].multi_str).str, &chart);
        ed->SetLineEnd(CHART_POS((yyloc)));
        (yyval.entitylist) = ed->AddAttributeList(nullptr, nullptr, FileLineCol());
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 8050 "msc_lang.cc"
    break;

  case 238:
#line 3730 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        EntityApp::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        EntityApp::AttributeValues(csh.hintAttrName, csh);
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_KeywordOrEntity((yylsp[-2]), (yyvsp[-2].multi_str).str);  //Do it after AddLineBeginToHints so this one is not included
  #else
    if ((yyvsp[-2].multi_str).had_error)
        (yyval.entitylist) = nullptr;
    else {
        EntityApp *ed = new EntityApp((yyvsp[-2].multi_str).str, &chart);
        ed->SetLineEnd(CHART_POS2((yylsp[-2]), (yylsp[-1])));
        (yyval.entitylist) = ed->AddAttributeList((yyvsp[-1].attriblist), (yyvsp[0].arclist), CHART_POS_START((yylsp[0])));
    }
  #endif
    free((yyvsp[-2].multi_str).str);
}
#line 8077 "msc_lang.cc"
    break;

  case 239:
#line 3753 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_KeywordOrEntity((yylsp[-1]), (yyvsp[-1].multi_str).str);   //Do it after AddLineBeginToHints so this one is not included
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.entitylist) = nullptr;
    else {
        EntityApp *ed = new EntityApp((yyvsp[-1].multi_str).str, &chart);
        ed->SetLineEnd(CHART_POS((yylsp[-1])));
        (yyval.entitylist) = ed->AddAttributeList(nullptr, (yyvsp[0].arclist), CHART_POS_START((yylsp[0])));
    }
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 8101 "msc_lang.cc"
    break;

  case 241:
#line 3775 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
  #endif
}
#line 8115 "msc_lang.cc"
    break;

  case 242:
#line 3785 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing style definition here.", "Try just removing the comma.");
#endif
}
#line 8131 "msc_lang.cc"
    break;

  case 243:
#line 3798 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    for (auto &str : *((yyvsp[-1].stringlist)))
        if (csh.ForbiddenStyles.find(str) == csh.ForbiddenStyles.end())
            csh.CurrentContext().StyleNames.insert(str);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        MscStyle().AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        MscStyle().AttributeValues(csh.hintAttrName, csh);
  #else
    if (!chart.SkipContent())
	    chart.AddAttributeListToStyleList((yyvsp[0].attriblist), (yyvsp[-1].stringlist)); //deletes $2, as well
  #endif
    delete((yyvsp[-1].stringlist));
}
#line 8151 "msc_lang.cc"
    break;

  case 244:
#line 3814 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddCSH_ErrorAfter((yyloc), "Missing attribute definitons in square brackets ('[' and ']').");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing attribute definitons in square brackets ('[' and ']').");
  #endif
    delete((yyvsp[0].stringlist));
}
#line 8164 "msc_lang.cc"
    break;

  case 245:
#line 3825 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    (yyval.stringlist) = new std::list<string>;
    if (!(yyvsp[0].multi_str).had_error) {
        csh.AddCSH((yylsp[0]), COLOR_STYLENAME);
        if (strcmp((yyvsp[0].multi_str).str, "emphasis")==0)
            ((yyval.stringlist))->push_back("box");
        else if (strcmp((yyvsp[0].multi_str).str, "emptyemphasis")==0)
            ((yyval.stringlist))->push_back("emptybox");
        else ((yyval.stringlist))->push_back((yyvsp[0].multi_str).str);
    }
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_NAME)) {
	    csh.AddStylesToHints(true, true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.stringlist) = new std::list<string>;
    if (!(yyvsp[0].multi_str).had_error)
        ((yyval.stringlist))->push_back(ConvertEmphasisToBox((yyvsp[0].multi_str).str, CHART_POS_START((yylsp[0])), chart));
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 8192 "msc_lang.cc"
    break;

  case 246:
#line 3849 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_STYLENAME);
    (yyval.stringlist) = new std::list<string>;
	((yyval.stringlist))->push_back("++");
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_NAME)) {
		csh.AddStylesToHints(true, true);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.stringlist) = new std::list<string>;
    ((yyval.stringlist))->push_back(ConvertEmphasisToBox("++", CHART_POS_START((yylsp[0])), chart));
  #endif
}
#line 8211 "msc_lang.cc"
    break;

  case 247:
#line 3864 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
	csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a style name to (re-)define.");
    if (csh.CheckHintAfter((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
		csh.AddStylesToHints(true, true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    }
	(yyval.stringlist) = (yyvsp[-1].stringlist);
  #else
    (yyval.stringlist) = (yyvsp[-1].stringlist);
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a style name to (re-)define.");
  #endif
}
#line 8231 "msc_lang.cc"
    break;

  case 248:
#line 3880 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    (yyval.stringlist) = (yyvsp[-2].stringlist);
    if (!(yyvsp[0].multi_str).had_error) {
        csh.AddCSH((yylsp[0]), COLOR_STYLENAME);
        if (strcmp((yyvsp[0].multi_str).str, "emphasis")==0)
            ((yyval.stringlist))->push_back("box");
        else if (strcmp((yyvsp[0].multi_str).str, "emptyemphasis")==0)
            ((yyval.stringlist))->push_back("emptybox");
        else ((yyval.stringlist))->push_back((yyvsp[0].multi_str).str);
    }
    if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddStylesToHints(true, true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (!(yyvsp[0].multi_str).had_error)
        ((yyvsp[-2].stringlist))->push_back(ConvertEmphasisToBox((yyvsp[0].multi_str).str, CHART_POS_START((yylsp[0])), chart));
    (yyval.stringlist) = (yyvsp[-2].stringlist);
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 8260 "msc_lang.cc"
    break;

  case 249:
#line 3905 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    csh.AddCSH((yylsp[0]), COLOR_STYLENAME);
    (yyval.stringlist) = (yyvsp[-2].stringlist);
	((yyval.stringlist))->push_back("++");
    if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
	    csh.AddStylesToHints(true, true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    }
  #else
    ((yyvsp[-2].stringlist))->push_back(ConvertEmphasisToBox("++", CHART_POS_START((yylsp[0])), chart));
    (yyval.stringlist) = (yyvsp[-2].stringlist);
  #endif
}
#line 8281 "msc_lang.cc"
    break;

  case 250:
#line 3923 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    csh.AddCSH_ErrorAfter((yyloc), ("Here should come a shape definition beginning with '{'. Ignoring this malformed shape definition for '"+std::string((yyvsp[0].multi_str).str) +"'.").c_str());
  #else
    if (!(yyvsp[0].multi_str).had_error)
       chart.Error.Error(CHART_POS((yyloc)).end, "Here should come a shape definition beginning with '{'. Ignoring this malformed shape definition for '"+std::string((yyvsp[0].multi_str).str) +"'.");
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 8297 "msc_lang.cc"
    break;

  case 251:
#line 3935 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddOpenBracePair((yylsp[0]));
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH((yylsp[-1]), COLOR_ATTRVALUE);
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.AddCSH_ErrorAfter((yyloc), ("Here should come a shape definition beginning with 'T', 'H', 'M', 'L', 'C', 'S', 'P' or 'E'. Ignoring this malformed shape definition for '"+std::string((yyvsp[-1].multi_str).str) +"'.").c_str());
  #else
    if (!(yyvsp[-1].multi_str).had_error)
        chart.Error.Error(CHART_POS((yyloc)).end, "Here should come a shape definition beginning with 'T', 'H', 'M', 'L', 'C', 'S', 'P' or 'E'. Ignoring this malformed shape definition for '"+std::string((yyvsp[-1].multi_str).str) +"'.");
  #endif
    free((yyvsp[-1].multi_str).str);
    (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 8316 "msc_lang.cc"
    break;

  case 252:
#line 3950 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddOpenBracePair((yylsp[-1])+(yylsp[0]));
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH((yylsp[-2]), COLOR_ATTRVALUE);
    csh.AddCSH((yylsp[-1]), COLOR_BRACE);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a closing brace ('}').");
    if (!csh.SkipContent())
    	csh.AddShapeName((yyvsp[-2].multi_str).str);
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing '}'.");
    chart.Error.Error(CHART_POS_START((yylsp[-1])), CHART_POS_AFTER((yylsp[0])), "Here is the corresponding '{'.");
    if ((yyvsp[0].shape)) {
        if (!chart.SkipContent() && !(yyvsp[-2].multi_str).had_error)
	    chart.Shapes.Add(std::string((yyvsp[-2].multi_str).str), CHART_POS_START((yylsp[-2])), chart.file_url, chart.file_info, std::move(*(yyvsp[0].shape)), chart.Error);
	delete (yyvsp[0].shape);
    }
  #endif
    free((yyvsp[-2].multi_str).str);
    (yyvsp[-1].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 8342 "msc_lang.cc"
    break;

  case 253:
#line 3972 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yylsp[-2])+(yylsp[0]));
    if (!(yyvsp[-3].multi_str).had_error)
        csh.AddCSH((yylsp[-3]), COLOR_ATTRVALUE);
    csh.AddCSH((yylsp[-2]), COLOR_BRACE);
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    if (!csh.SkipContent() && !(yyvsp[-3].multi_str).had_error)
    	csh.AddShapeName((yyvsp[-3].multi_str).str);
  #else
    if ((yyvsp[-1].shape)) {
        if (!chart.SkipContent() && !(yyvsp[-3].multi_str).had_error)
	    chart.Shapes.Add((yyvsp[-3].multi_str).str, CHART_POS_START((yylsp[-3])), chart.file_url, chart.file_info, std::move(*(yyvsp[-1].shape)), chart.Error);
	delete (yyvsp[-1].shape);
    }
  #endif
    free((yyvsp[-3].multi_str).str);
    (yyvsp[-2].input_text_ptr); //to silence 'unused parameter' warnings
    (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 8367 "msc_lang.cc"
    break;

  case 254:
#line 3993 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.BracePairs.push_back((yylsp[-3])+(yylsp[0]));
    if (!(yyvsp[-4].multi_str).had_error)
        csh.AddCSH((yylsp[-4]), COLOR_ATTRVALUE);
    csh.AddCSH((yylsp[-3]), COLOR_BRACE);
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    if (!csh.SkipContent() && !(yyvsp[-4].multi_str).had_error)
    	csh.AddShapeName((yyvsp[-4].multi_str).str);
    csh.AddCSH_Error((yylsp[-1]), "Only numbers can come after shape commands.");
  #else
    if ((yyvsp[-2].shape)) {
        if (!chart.SkipContent() && !(yyvsp[-4].multi_str).had_error)
	    chart.Shapes.Add((yyvsp[-4].multi_str).str, CHART_POS_START((yylsp[-4])), chart.file_url, chart.file_info, std::move(*(yyvsp[-2].shape)), chart.Error);
	delete (yyvsp[-2].shape);
    }
  #endif
    free((yyvsp[-4].multi_str).str);
    (yyvsp[-3].input_text_ptr); //to silence 'unused parameter' warnings
    (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 8393 "msc_lang.cc"
    break;

  case 255:
#line 4016 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
  #else
    (yyval.shape) = new Shape;
	if ((yyvsp[-1].shapeelement)) {
		((yyval.shape))->Add(std::move(*((yyvsp[-1].shapeelement))));
		delete (yyvsp[-1].shapeelement);
	}
  #endif
}
#line 8409 "msc_lang.cc"
    break;

  case 256:
#line 4028 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon.");
  #else
    (yyval.shape) = new Shape;
	if ((yyvsp[0].shapeelement)) {
		((yyval.shape))->Add(std::move(*((yyvsp[0].shapeelement))));
		delete (yyvsp[0].shapeelement);
	}
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing semicolon (';').");
  #endif
}
#line 8426 "msc_lang.cc"
    break;

  case 257:
#line 4041 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[-2]), "I do not understand this.");
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
#else
    (yyval.shape) = new Shape;
	if ((yyvsp[-1].shapeelement)) {
		((yyval.shape))->Add(std::move(*((yyvsp[-1].shapeelement))));
		delete (yyvsp[-1].shapeelement);
	}
    chart.Error.Error(CHART_POS_START((yylsp[-2])), "syntax error.");
  #endif
}
#line 8444 "msc_lang.cc"
    break;

  case 258:
#line 4055 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[-1]), "I do not understand this.");
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon.");
#else
    (yyval.shape) = new Shape;
	if ((yyvsp[0].shapeelement)) {
		((yyval.shape))->Add(std::move(*((yyvsp[0].shapeelement))));
		delete (yyvsp[0].shapeelement);
	}
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "syntax error.");
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing semicolon (';').");
  #endif
}
#line 8463 "msc_lang.cc"
    break;

  case 259:
#line 4070 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
  #else
	if ((yyvsp[-1].shapeelement)) {
		((yyvsp[-2].shape))->Add(std::move(*((yyvsp[-1].shapeelement))));
		delete (yyvsp[-1].shapeelement);
	}
    (yyval.shape) = (yyvsp[-2].shape);
  #endif
}
#line 8479 "msc_lang.cc"
    break;

  case 260:
#line 4082 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing semicolon.");
  #else
	if ((yyvsp[0].shapeelement)) {
		((yyvsp[-1].shape))->Add(std::move(*((yyvsp[0].shapeelement))));
		delete (yyvsp[0].shapeelement);
	}
    (yyval.shape) = (yyvsp[-1].shape);
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing semicolon (';').");
  #endif
}
#line 8496 "msc_lang.cc"
    break;

  case 261:
#line 4095 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[0]), "Only numbers can come after shape commands.");
  #else
    (yyval.shape) = (yyvsp[-1].shape);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "syntax error.");
  #endif
}
#line 8509 "msc_lang.cc"
    break;

  case 262:
#line 4104 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SEMICOLON);
  #else
    (yyval.shape) = (yyvsp[-1].shape);
  #endif
}
#line 8521 "msc_lang.cc"
    break;

  case 263:
#line 4114 "msc_lang.yy"
{
    const int num_args = 0;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[0].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
	if (should_args != num_args)
		csh.AddCSH_ErrorAfter((yyloc), ShapeElement::ErrorMsg((yyvsp[0].shapecommand), num_args));
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args != num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[0].shapecommand), num_args).append(" Ignoring line."));
	else
	    (yyval.shapeelement) = new ShapeElement((yyvsp[0].shapecommand));
  #endif
}
#line 8541 "msc_lang.cc"
    break;

  case 264:
#line 4130 "msc_lang.yy"
{
    const int num_args = 1;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-1].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
	if (should_args != num_args) {
		std::string msg = ShapeElement::ErrorMsg((yyvsp[-1].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-1].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	} else if ((yyvsp[-1].shapecommand)>=ShapeElement::SECTION_BG && (((yyvsp[0].str))[0]<'0' || ((yyvsp[0].str))[0]>'2' || ((yyvsp[0].str))[1]!=0))
		csh.AddCSH_Error((yylsp[0]), "S (section) commands require an integer between 0 and 2.");
  #else
	(yyval.shapeelement) = nullptr;
	const double a = atof((yyvsp[0].str));
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yylsp[0])).end, ShapeElement::ErrorMsg((yyvsp[-1].shapecommand), num_args).append(" Ignoring line."));
	else if ((yyvsp[-1].shapecommand)>=ShapeElement::SECTION_BG && (a!=0 && a!=1 && a!=2))
		chart.Error.Error(CHART_POS_START((yylsp[0])), "S (section) commands require an integer between 0 and 2. Ignoring line.");
	else if ((yyvsp[-1].shapecommand)>=ShapeElement::SECTION_BG)
	    (yyval.shapeelement) = new ShapeElement(ShapeElement::Type((yyvsp[-1].shapecommand) + unsigned(a)));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-1].shapecommand), a);
  #endif
    free((yyvsp[0].str));
}
#line 8573 "msc_lang.cc"
    break;

  case 265:
#line 4158 "msc_lang.yy"
{
    const int num_args = 2;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-2].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
	if (should_args != num_args) {
		std::string msg = ShapeElement::ErrorMsg((yyvsp[-2].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-2].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	}
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-2].shapecommand), num_args).append(" Ignoring line."));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-2].shapecommand), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 8601 "msc_lang.cc"
    break;

  case 266:
#line 4182 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    if ((yyvsp[-3].shapecommand)!=ShapeElement::PORT)
        csh.AddCSH_Error((yylsp[0]), "You need to specify a number here.");
  #else
    (yyval.shapeelement) = nullptr;
    if ((yyvsp[-3].shapecommand)!=ShapeElement::PORT)
        chart.Error.Error(CHART_POS_START((yylsp[0])), "Expecting a number here. Ignoring line.");
    else
        (yyval.shapeelement) = new ShapeElement(atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), (yyvsp[0].multi_str).str);
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
    free((yyvsp[0].multi_str).str);
}
#line 8622 "msc_lang.cc"
    break;

  case 267:
#line 4199 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-4]), COLOR_KEYWORD);
    if ((yyvsp[-4].shapecommand)!=ShapeElement::PORT)
        csh.AddCSH_Error((yylsp[-1]), "You need to specify a number here.");
  #else
    (yyval.shapeelement) = nullptr;
    if ((yyvsp[-4].shapecommand)!=ShapeElement::PORT)
        chart.Error.Error(CHART_POS_START((yylsp[-1])), "Expecting a number here. Ignoring line.");
    else
        (yyval.shapeelement) = new ShapeElement(atof((yyvsp[-3].str)), atof((yyvsp[-2].str)), (yyvsp[-1].multi_str).str, atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[-2].str));
    free((yyvsp[-1].multi_str).str);
    free((yyvsp[0].str));
}
#line 8644 "msc_lang.cc"
    break;

  case 268:
#line 4217 "msc_lang.yy"
{
    const int num_args = 3;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-3].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
	if (should_args != num_args) {
		std::string msg = ShapeElement::ErrorMsg((yyvsp[-3].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-3].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-2]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 2:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	} else if ((yyvsp[-3].shapecommand)==ShapeElement::PORT)
        csh.AddCSH_Error((yylsp[0]), "You need to specify a port name here starting with a letter.");
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-3].shapecommand), num_args).append(" Ignoring line."));
	else if ((yyvsp[-3].shapecommand)==ShapeElement::PORT)
		chart.Error.Error(CHART_POS_START((yylsp[0])), "Expecting a port name here. Ignoring line.");
    else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-3].shapecommand), atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 8677 "msc_lang.cc"
    break;

  case 269:
#line 4246 "msc_lang.yy"
{
    const int num_args = 4;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-4].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-4]), COLOR_KEYWORD);
	if (should_args != num_args) {
		std::string msg = ShapeElement::ErrorMsg((yyvsp[-4].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-4].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-3]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[-2]) + (yylsp[0]), std::move(msg)); break;
		case 2:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 3:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	}
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-4].shapecommand), num_args).append(" Ignoring line."));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-4].shapecommand), atof((yyvsp[-3].str)), atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 8709 "msc_lang.cc"
    break;

  case 270:
#line 4274 "msc_lang.yy"
{
    const int num_args = 5;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-5].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-5]), COLOR_KEYWORD);
	if (should_args != num_args) {
		std::string msg = ShapeElement::ErrorMsg((yyvsp[-5].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-5].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-4]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[-3]) + (yylsp[0]), std::move(msg)); break;
		case 2:  csh.AddCSH_Error((yylsp[-2]) + (yylsp[0]), std::move(msg)); break;
		case 3:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 4:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	}
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-5].shapecommand), num_args).append(" Ignoring line."));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-5].shapecommand), atof((yyvsp[-4].str)), atof((yyvsp[-3].str)), atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-4].str));
    free((yyvsp[-3].str));
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 8743 "msc_lang.cc"
    break;

  case 271:
#line 4304 "msc_lang.yy"
{
    const int num_args = 6;
	const int should_args = ShapeElement::GetNumArgs((yyvsp[-6].shapecommand));
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-6]), COLOR_KEYWORD);
	if (should_args != num_args) {
		std::string msg = ShapeElement::ErrorMsg((yyvsp[-6].shapecommand), num_args);
	    switch (ShapeElement::GetNumArgs((yyvsp[-6].shapecommand))) {
		case 0:  csh.AddCSH_Error((yylsp[-5]) + (yylsp[0]), std::move(msg)); break;
		case 1:  csh.AddCSH_Error((yylsp[-4]) + (yylsp[0]), std::move(msg)); break;
		case 2:  csh.AddCSH_Error((yylsp[-3]) + (yylsp[0]), std::move(msg)); break;
		case 3:  csh.AddCSH_Error((yylsp[-2]) + (yylsp[0]), std::move(msg)); break;
		case 4:  csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), std::move(msg)); break;
		case 5:  csh.AddCSH_Error((yylsp[0]), std::move(msg)); break;
		default: csh.AddCSH_ErrorAfter((yyloc), std::move(msg)); break;
		}
	}
  #else
	(yyval.shapeelement) = nullptr;
	if (should_args > num_args)
		chart.Error.Error(CHART_POS((yyloc)).end, ShapeElement::ErrorMsg((yyvsp[-6].shapecommand), num_args).append(" Ignoring line."));
	else
		(yyval.shapeelement) = new ShapeElement((yyvsp[-6].shapecommand), atof((yyvsp[-5].str)), atof((yyvsp[-4].str)), atof((yyvsp[-3].str)), atof((yyvsp[-2].str)), atof((yyvsp[-1].str)), atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-5].str));
    free((yyvsp[-4].str));
    free((yyvsp[-3].str));
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 8779 "msc_lang.cc"
    break;

  case 273:
#line 4338 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
	}
  #endif
}
#line 8794 "msc_lang.cc"
    break;

  case 274:
#line 4349 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing color name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a color name to (re-)define.");
  #endif
}
#line 8812 "msc_lang.cc"
    break;

  case 279:
#line 4367 "msc_lang.yy"
{
    if ((yyvsp[0].multi_str).had_error) {
        (yyval.str) = strdup("");
        free((yyvsp[0].multi_str).str);
    } else
        (yyval.str) = (yyvsp[0].multi_str).str;
}
#line 8824 "msc_lang.cc"
    break;

  case 280:
#line 4377 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH((yylsp[-2]), COLOR_COLORNAME);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH((yylsp[0]), COLOR_COLORDEF);
    if (!(yyvsp[-2].multi_str).had_error) {
        ColorType color = csh.CurrentContext().Colors.GetColor((yyvsp[0].str));
        if (color.type!=ColorType::INVALID)
            csh.CurrentContext().Colors[(yyvsp[-2].multi_str).str] = color;
    }
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(false);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (!chart.SkipContent() && !(yyvsp[-2].multi_str).had_error)
        chart.MyCurrentContext().colors.AddColor((yyvsp[-2].multi_str).str, (yyvsp[0].str), chart.Error, CHART_POS((yyloc)));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].str));
}
#line 8856 "msc_lang.cc"
    break;

  case 281:
#line 4405 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-3].multi_str).had_error)
        csh.AddCSH((yylsp[-3]), COLOR_COLORNAME);
    csh.AddCSH((yylsp[-2]), COLOR_EQUAL);
    csh.AddCSH((yylsp[-1]), COLOR_COLORDEF);
    csh.AddCSH((yylsp[0]), COLOR_COLORDEF);
    if (!(yyvsp[-3].multi_str).had_error) {
        ColorType color = csh.CurrentContext().Colors.GetColor("++"+string((yyvsp[0].str)));
        if (color.type!=ColorType::INVALID)
            csh.CurrentContext().Colors[(yyvsp[-3].multi_str).str] = color;
    }
    if (csh.CheckHintAt((yylsp[-3]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(false);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (!chart.SkipContent())
       chart.MyCurrentContext().colors.AddColor((yyvsp[-3].multi_str).str, "++"+string((yyvsp[0].str)), chart.Error, CHART_POS((yyloc)));
  #endif
    free((yyvsp[-3].multi_str).str);
    free((yyvsp[0].str));
}
#line 8889 "msc_lang.cc"
    break;

  case 282:
#line 4434 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH((yylsp[-1]), COLOR_COLORNAME);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE)) {
        csh.AddColorValuesToHints(false);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yyloc), "Missing color definition.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing color definition.");
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 8914 "msc_lang.cc"
    break;

  case 283:
#line 4455 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_COLORNAME);
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yyloc), "Missing equal sign ('=') and a color definition.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing equal sign ('=') and a color definition.");
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 8934 "msc_lang.cc"
    break;

  case 284:
#line 4474 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-4]), COLOR_DESIGNNAME);
    csh.AddCSH((yylsp[-1]), COLOR_SEMICOLON);
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.BracePairs.push_back((yylsp[-3])+(yylsp[0]));
    if (!csh.SkipContent()) {
        auto &d = csh.CurrentContext().IsFull() ? csh.FullDesigns : csh.PartialDesigns;
        auto i = d.find((yyvsp[-4].str));
        if (i == d.end())
            d.emplace((yyvsp[-4].str), csh.Contexts.back());
        else
            i->second += csh.Contexts.back();
    }
    csh.PopContext();
    if ((csh.CheckHintBetween((yylsp[-3]), (yylsp[-2]), EHintSourceType::LINE_START) ||
         csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::LINE_START)) ) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (!chart.SkipContent()) {
        //'scope_open_empty' pushed an empty color & style set onto the stack
        //then designelementlist added color & style definitions, procedures, etc., now we harvest those.
        //This is either a lookup if the design exists or creates a new empty design of this name
        auto i = chart.Designs.emplace(std::piecewise_construct,
                                       std::forward_as_tuple((yyvsp[-4].str)),
                                       std::forward_as_tuple(chart.MyCurrentContext().IsFull(),
                                                             EContextParse::NORMAL,
                                                             EContextCreate::EMPTY,
                                                             CHART_POS_START((yylsp[-3]))));
        //we apply the content from current context all the same if inserted or existing
        i.first->second.ApplyContextContent(std::move(chart.MyCurrentContext())); //we can move, will pop below
    }
    chart.PopContext();
  #endif
    free((yyvsp[-4].str));
  (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 8978 "msc_lang.cc"
    break;

  case 285:
#line 4514 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-5]), COLOR_DESIGNNAME);
    csh.AddCSH((yylsp[-2]), COLOR_SEMICOLON);
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as part of a design definition.");
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.BracePairs.push_back((yylsp[-4])+(yylsp[0]));
    if (!csh.SkipContent()) {
        auto &d = csh.CurrentContext().IsFull() ? csh.FullDesigns : csh.PartialDesigns;
        auto i = d.find((yyvsp[-5].str));
        if (i == d.end())
            d.emplace((yyvsp[-5].str), csh.Contexts.back());
        else
            i->second += csh.Contexts.back();
    }
    csh.PopContext();
    if ((csh.CheckHintBetween((yylsp[-4]), (yylsp[-3]), EHintSourceType::LINE_START) ||
         csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::LINE_START))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
#else
    if (!chart.SkipContent()) {
        //if closing brace missing, still do the design definition
        //'scope_open_empty' pushed an empty color & style set onto the stack
        //then designelementlist added color & style definitions, procedures, etc., now we harvest those.
        //This is either a lookup if the design exists or creates a new empty design of this name
        auto i = chart.Designs.emplace(std::piecewise_construct,
                                       std::forward_as_tuple((yyvsp[-5].str)),
                                       std::forward_as_tuple(chart.MyCurrentContext().IsFull(),
                                                             EContextParse::NORMAL,
                                                             EContextCreate::EMPTY,
                                                             CHART_POS_START((yylsp[-4]))));
        //we apply the content from current context all the same if inserted or existing
        i.first->second.ApplyContextContent(std::move(chart.MyCurrentContext())); //we can move, will pop below
    }
    chart.PopContext();
  #endif
  (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 9023 "msc_lang.cc"
    break;

  case 286:
#line 4557 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.PushContext(false, EContextParse::NORMAL);
  #else
    //push empty color & style sets for design definition
    chart.PushContext(CHART_POS_START((yylsp[0])), EContextParse::NORMAL, EContextCreate::CLEAR);
  #endif
  (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 9038 "msc_lang.cc"
    break;

  case 288:
#line 4570 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SEMICOLON);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::LINE_START)) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
#endif
}
#line 9052 "msc_lang.cc"
    break;

  case 289:
#line 4581 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
    }
  #endif
    free((yyvsp[-1].str));
}
#line 9071 "msc_lang.cc"
    break;

  case 290:
#line 4596 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddColorValuesToHints(true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing color name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a color name to (re-)define.");
  #endif
    free((yyvsp[0].str));
}
#line 9093 "msc_lang.cc"
    break;

  case 291:
#line 4614 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddStylesToHints(true, true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
	}
  #endif
    free((yyvsp[-1].str));
}
#line 9112 "msc_lang.cc"
    break;

  case 292:
#line 4629 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddDesignLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddStylesToHints(true, true);
        csh.AllowAnything();
        csh.hintStatus = HINT_READY;
	}
	csh.AddCSH_ErrorAfter((yyloc), "Missing style name to (re-)define.");
  #else
    chart.Error.Error(CHART_POS((yyloc)).end, "Missing a style name to (re-)define.");
  #endif
    free((yyvsp[0].str));
}
#line 9134 "msc_lang.cc"
    break;

  case 295:
#line 4650 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #endif
}
#line 9148 "msc_lang.cc"
    break;

  case 296:
#line 4660 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    }
  #endif
}
#line 9162 "msc_lang.cc"
    break;

  case 297:
#line 4670 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[0]), "Extra stuff after design options. Maybe missing a comma?");
  #endif
}
#line 9172 "msc_lang.cc"
    break;

  case 298:
#line 4677 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].multi_str).str, COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (!(yyvsp[-2].multi_str).had_error && csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].multi_str).str)) {
        MscChart::AttributeValues((yyvsp[-2].multi_str).str, csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    if (!(yyvsp[-2].multi_str).had_error)
        chart.AddDesignAttribute(Attribute((yyvsp[-2].multi_str).str, (yyvsp[0].str), CHART_POS((yyloc)), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].str));
}
#line 9197 "msc_lang.cc"
    break;

  case 299:
#line 4698 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].multi_str).str, COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (!(yyvsp[-2].multi_str).had_error && csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].multi_str).str)) {
        MscChart::AttributeValues((yyvsp[-2].multi_str).str, csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    if (!(yyvsp[-2].multi_str).had_error && !(yyvsp[0].multi_str).had_error)
        chart.AddDesignAttribute(Attribute((yyvsp[-2].multi_str).str, (yyvsp[0].multi_str).str, CHART_POS((yylsp[-2])), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 9223 "msc_lang.cc"
    break;

  case 300:
#line 4720 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_AttrName((yylsp[-1]), (yyvsp[-1].multi_str).str, COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (!(yyvsp[-1].multi_str).had_error && csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-1].multi_str).str)) {
        MscChart::AttributeValues((yyvsp[-1].multi_str).str, csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing option value. Ignoring this.");
#endif
    free((yyvsp[-1].multi_str).str);
}
#line 9245 "msc_lang.cc"
    break;

  case 301:
#line 4738 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_DESIGNNAME);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].str))) {
        MscChart::AttributeValues("msc", csh);
        csh.hintStatus = HINT_READY;
    }
    if (!(yyvsp[0].multi_str).had_error) {
        std::string msg = csh.SetDesignTo((yyvsp[0].multi_str).str, true);
        if (msg.length())
           csh.AddCSH_Error((yylsp[0]), std::move(msg));
    }
  #else
    if (!(yyvsp[0].multi_str).had_error)
        chart.AddDesignAttribute(Attribute("msc", (yyvsp[0].multi_str).str, CHART_POS((yyloc)), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].multi_str).str);
}
#line 9275 "msc_lang.cc"
    break;

  case 302:
#line 4764 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_DESIGNNAME);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].str))) {
        MscChart::AttributeValues("msc+", csh);
        csh.hintStatus = HINT_READY;
    }
    if (!(yyvsp[0].multi_str).had_error) {
        std::string msg = csh.SetDesignTo((yyvsp[0].multi_str).str, false);
        if (msg.length())
            csh.AddCSH_Error((yylsp[0]), std::move(msg));
    }
  #else
    if (!(yyvsp[0].multi_str).had_error)
        chart.AddDesignAttribute(Attribute("msc+", (yyvsp[0].multi_str).str, CHART_POS((yyloc)), CHART_POS((yylsp[0]))));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[0].multi_str).str);
}
#line 9305 "msc_lang.cc"
    break;

  case 303:
#line 4790 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_AttrName((yylsp[-1]), (yyvsp[-1].str), COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, "msc")) {
        MscChart::AttributeValues((yyvsp[-1].str), csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing design name. Ignoring this.");
#endif
    free((yyvsp[-1].str));
}
#line 9326 "msc_lang.cc"
    break;

  case 304:
#line 4807 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_AttrName((yylsp[-1]), (yyvsp[-1].str), COLOR_OPTIONNAME);
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME)) {
        csh.AddDesignOptionsToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, "msc+")) {
        MscChart::AttributeValues((yyvsp[-1].str), csh);
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing design name. Ignoring this.");
#endif
    free((yyvsp[-1].str));
}
#line 9347 "msc_lang.cc"
    break;

  case 305:
#line 4826 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].arclist))
        (yyval.arcparallel) = new ParallelBlocks(&chart, (yyvsp[0].arclist), nullptr, false, false);
    else
        (yyval.arcparallel) = nullptr;
  #endif
}
#line 9360 "msc_lang.cc"
    break;

  case 306:
#line 4835 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        ParallelBlocks::AttributeNames(csh, true);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        ParallelBlocks::AttributeValues(csh.hintAttrName, csh, true);
  #else
    if ((yyvsp[0].arclist)) {
        (yyval.arcparallel) = new ParallelBlocks(&chart, (yyvsp[0].arclist), (yyvsp[-1].attriblist), false, false);
    } else {
        (yyval.arcparallel) = nullptr;
        if ((yyvsp[-1].attriblist)) delete (yyvsp[-1].attriblist);
    }
  #endif
}
#line 9380 "msc_lang.cc"
    break;

  case 307:
#line 4851 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].arclist)==nullptr)
        (yyval.arcparallel) = (yyvsp[-1].arcparallel);
    else if ((yyvsp[-1].arcparallel))
        (yyval.arcparallel) = ((yyvsp[-1].arcparallel))->AddArcList((yyvsp[0].arclist), nullptr);
    else
        (yyval.arcparallel) = new ParallelBlocks(&chart, (yyvsp[0].arclist), nullptr, false, false);
  #endif
}
#line 9395 "msc_lang.cc"
    break;

  case 308:
#line 4862 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        ParallelBlocks::AttributeNames(csh, false);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        ParallelBlocks::AttributeValues(csh.hintAttrName, csh, false);
  #else
    if ((yyvsp[0].arclist)==nullptr) {
        (yyval.arcparallel) = (yyvsp[-2].arcparallel);
        if ((yyvsp[-1].attriblist)) delete (yyvsp[-1].attriblist);
    } else if ((yyvsp[-2].arcparallel))
        (yyval.arcparallel) = ((yyvsp[-2].arcparallel))->AddArcList((yyvsp[0].arclist), (yyvsp[-1].attriblist));
    else
        (yyval.arcparallel) = new ParallelBlocks(&chart, (yyvsp[0].arclist), (yyvsp[-1].attriblist), false, false);
  #endif
}
#line 9416 "msc_lang.cc"
    break;

  case 309:
#line 4879 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        ParallelBlocks::AttributeNames(csh, false);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        ParallelBlocks::AttributeValues(csh.hintAttrName, csh, false);
    csh.AddCSH_ErrorAfter((yylsp[0]),
        "Need an additional parallel block enclosed between '{' and '}'.");
  #else
    (yyval.arcparallel) = (yyvsp[-1].arcparallel);
    if ((yyvsp[0].attriblist)) delete (yyvsp[0].attriblist);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])),
        "Missing an additional parallel block enclosed between '{' and '}' after the attributes.");
  #endif
}
#line 9436 "msc_lang.cc"
    break;

  case 311:
#line 4896 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
  #else
  #endif
    free((yyvsp[0].str));
}
#line 9448 "msc_lang.cc"
    break;

  case 312:
#line 4907 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.CheckEntityHintAfter((yylsp[0]));
  #else
    (yyval.arcboxseries) = (yyvsp[0].arcboxseries);
  #endif
}
#line 9460 "msc_lang.cc"
    break;

  case 313:
#line 4915 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintAfter((yylsp[0])))
        csh.AllowAnything();
  #else
    //Allocate a solid box with no entities and no attribute list (the second param to BoxSeries())
    (yyval.arcboxseries) = new BoxSeries(
	          new Box(EArcSymbol::BOX_SOLID, CHART_POS((yylsp[0])), nullptr, CHART_POS((yylsp[0])), nullptr, CHART_POS((yylsp[0])), &chart),
			      nullptr);
    ((yyval.arcboxseries))->ExpandFirstLineEnd(CHART_POS((yyloc)));
  #endif
    free((yyvsp[0].str));
}
#line 9482 "msc_lang.cc"
    break;

  case 314:
#line 4933 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.CheckEntityHintAfter((yylsp[0]));
  #else
    FileLineColRange box_file_pos(FileLineCol(chart.current_file, ((yylsp[0])).first_line, ((yylsp[0])).first_column - 1),
						            FileLineCol(chart.current_file, ((yylsp[0])).first_line, ((yylsp[0])).first_column - 1));
    Box *temp = new Box(EArcSymbol::BOX_SOLID, box_file_pos,
                        nullptr, CHART_POS((yylsp[-1])), nullptr, CHART_POS((yylsp[-1])), &chart);
    temp->AddArcList((yyvsp[0].arclist));
	temp->SetLineEnd(box_file_pos);
    (yyval.arcboxseries) = new BoxSeries(temp, nullptr);
  #endif
    free((yyvsp[-1].str));
}
#line 9502 "msc_lang.cc"
    break;

  case 315:
#line 4949 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        Box::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        Box::AttributeValues(csh.hintAttrName, csh);
    else
        csh.CheckEntityHintAfter((yylsp[0]));
  #else
    FileLineColRange box_file_pos(FileLineCol(chart.current_file, ((yylsp[-1])).first_line, ((yylsp[-1])).first_column - 1),
						            FileLineCol(chart.current_file, ((yylsp[-1])).first_line, ((yylsp[-1])).first_column - 1));
    Box *temp = new Box(EArcSymbol::BOX_SOLID, box_file_pos,
                        nullptr, CHART_POS((yylsp[-2])), nullptr, CHART_POS((yylsp[-2])), &chart);
    temp->AddArcList((yyvsp[0].arclist))->SetLineEnd(CHART_POS2((yylsp[-1]), (yylsp[-1])));
    (yyval.arcboxseries) = new BoxSeries(temp, (yyvsp[-1].attriblist));
  #endif
    free((yyvsp[-2].str));
}
#line 9526 "msc_lang.cc"
    break;

  case 316:
#line 4969 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Box::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Box::AttributeValues(csh.hintAttrName, csh);
    else
        csh.CheckEntityHintAfter((yylsp[0]));
  #else
    FileLineColRange box_file_pos(FileLineCol(chart.current_file, ((yylsp[0])).first_line, ((yylsp[0])).first_column - 1),
						            FileLineCol(chart.current_file, ((yylsp[0])).first_line, ((yylsp[0])).first_column - 1));
    Box *temp = new Box(EArcSymbol::BOX_SOLID, box_file_pos,
                        nullptr, CHART_POS((yylsp[-1])), nullptr, CHART_POS((yylsp[-1])), &chart);
    temp->SetLineEnd(CHART_POS2((yylsp[0]), (yylsp[0])));
    (yyval.arcboxseries) = new BoxSeries(temp, (yyvsp[0].attriblist));
  #endif
    free((yyvsp[-1].str));
}
#line 9550 "msc_lang.cc"
    break;

  case 317:
#line 4989 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else
        csh.CheckEntityHintAfter((yylsp[0]));
  #else
    ((yyvsp[0].arcboxseries))->ExpandFirstLineEnd(CHART_POS((yyloc)));
    (yyval.arcboxseries) = (yyvsp[0].arcboxseries);
  #endif
  free((yyvsp[-1].str));
}
#line 9569 "msc_lang.cc"
    break;

  case 318:
#line 5005 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    ((yyvsp[0].arcbox))->SetLineEnd(CHART_POS2((yylsp[-1]), (yylsp[0])));
    (yyval.arcboxseries) = ((yyvsp[-2].arcboxseries))->AddBox((yyvsp[0].arcbox), nullptr);
  #endif
}
#line 9580 "msc_lang.cc"
    break;

  case 319:
#line 5012 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Box::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Box::AttributeValues(csh.hintAttrName, csh);
    else
        csh.CheckEntityHintAfter((yylsp[0]));
  #else
    ((yyvsp[-1].arcbox))->SetLineEnd(CHART_POS2((yylsp[-2]), (yylsp[0])));
    (yyval.arcboxseries) = ((yyvsp[-3].arcboxseries))->AddBox((yyvsp[-1].arcbox), (yyvsp[0].attriblist));
  #endif
}
#line 9598 "msc_lang.cc"
    break;

  case 320:
#line 5026 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.CheckEntityHintAfter((yylsp[0]));
  #else
    ((yyvsp[-1].arcbox))->AddArcList((yyvsp[0].arclist))->SetLineEnd(CHART_POS2((yylsp[-2]), (yylsp[-1])));
    (yyval.arcboxseries) = ((yyvsp[-3].arcboxseries))->AddBox((yyvsp[-1].arcbox), nullptr);
  #endif
}
#line 9611 "msc_lang.cc"
    break;

  case 321:
#line 5035 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        Box::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        Box::AttributeValues(csh.hintAttrName, csh);
    else
        csh.CheckEntityHintAfter((yylsp[0]));
  #else
    ((yyvsp[-2].arcbox))->AddArcList((yyvsp[0].arclist))->SetLineEnd(CHART_POS2((yylsp[-3]), (yylsp[-1])));
    (yyval.arcboxseries) = ((yyvsp[-4].arcboxseries))->AddBox((yyvsp[-2].arcbox), (yyvsp[-1].attriblist));
  #endif
}
#line 9629 "msc_lang.cc"
    break;

  case 322:
#line 5049 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.CheckEntityHintAfter((yylsp[0]));
  #else
    FileLineColRange box_file_pos(FileLineCol(chart.current_file, ((yylsp[0])).first_line, ((yylsp[0])).first_column - 1),
						            FileLineCol(chart.current_file, ((yylsp[0])).first_line, ((yylsp[0])).first_column - 1));
    Box *temp = new Box(EArcSymbol::BOX_UNDETERMINED_FOLLOW, box_file_pos,
                        nullptr, CHART_POS((yylsp[-1])), nullptr, CHART_POS((yylsp[-1])), &chart);
    temp->AddArcList((yyvsp[0].arclist));
	temp->SetLineEnd(box_file_pos);
    (yyval.arcboxseries) = ((yyvsp[-1].arcboxseries))->AddBox(temp, nullptr);
  #endif
}
#line 9647 "msc_lang.cc"
    break;

  case 323:
#line 5063 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        Box::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        Box::AttributeValues(csh.hintAttrName, csh);
    else
        csh.CheckEntityHintAfter((yylsp[0]));
  #else
    FileLineColRange box_file_pos(FileLineCol(chart.current_file, ((yylsp[-1])).first_line, ((yylsp[-1])).first_column - 1),
						            FileLineCol(chart.current_file, ((yylsp[-1])).first_line, ((yylsp[-1])).first_column - 1));
    Box *temp = new Box(EArcSymbol::BOX_UNDETERMINED_FOLLOW, box_file_pos,
                        nullptr, CHART_POS((yylsp[-2])), nullptr, CHART_POS((yylsp[-2])), &chart);
    temp->AddArcList((yyvsp[0].arclist))->SetLineEnd(CHART_POS2((yylsp[-1]), (yylsp[-1])));
    (yyval.arcboxseries) = ((yyvsp[-2].arcboxseries))->AddBox(temp, (yyvsp[-1].attriblist));
  #endif
}
#line 9669 "msc_lang.cc"
    break;

  case 324:
#line 5082 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].arcbox)) {
        ((yyvsp[0].arcbox))->SetLineEnd(CHART_POS((yyloc)));
        (yyval.arcboxseries) = new BoxSeries((yyvsp[0].arcbox), nullptr);
    } else
        (yyval.arcboxseries) = nullptr;
  #endif
}
#line 9683 "msc_lang.cc"
    break;

  case 325:
#line 5092 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Box::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Box::AttributeValues(csh.hintAttrName, csh);
  #else
    if ((yyvsp[-1].arcbox)) {
        ((yyvsp[-1].arcbox))->SetLineEnd(CHART_POS((yyloc)));
        (yyval.arcboxseries) = new BoxSeries((yyvsp[-1].arcbox), (yyvsp[0].attriblist));
    } else
        (yyval.arcboxseries) = nullptr;
  #endif
}
#line 9702 "msc_lang.cc"
    break;

  case 326:
#line 5108 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].arcboxseries)) {
        (yyval.arclist) = new ArcList;
        ((yyval.arclist))->Append((yyvsp[0].arcboxseries));
    } else
        (yyval.arclist) = nullptr;
  #endif
}
#line 9716 "msc_lang.cc"
    break;

  case 327:
#line 5118 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
  #else
    if ((yyvsp[0].arcboxseries)) {
        if ((yyvsp[-2].arclist)) {
            ((yyvsp[-2].arclist))->back()->SetParallel();
            (yyval.arclist) = (yyvsp[-2].arclist);
        } else
            (yyval.arclist) = new ArcList;
        ((yyval.arclist))->Append((yyvsp[0].arcboxseries));
    } else
        (yyval.arclist) = (yyvsp[-2].arclist);
  #endif
}
#line 9736 "msc_lang.cc"
    break;

  case 328:
#line 5137 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    ((yyvsp[0].arcbox))->SetLineEnd(CHART_POS((yyloc)));
    (yyval.arcboxseries) = new BoxSeries((yyvsp[0].arcbox), nullptr);
  #endif
}
#line 9747 "msc_lang.cc"
    break;

  case 329:
#line 5144 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Box::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Box::AttributeValues(csh.hintAttrName, csh);
  #else
    ((yyvsp[-1].arcbox))->SetLineEnd(CHART_POS((yyloc)));
    (yyval.arcboxseries) = new BoxSeries((yyvsp[-1].arcbox), (yyvsp[0].attriblist));
  #endif
}
#line 9763 "msc_lang.cc"
    break;

  case 330:
#line 5156 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    ((yyvsp[-1].arcbox))->SetLineEnd(CHART_POS((yylsp[-1])));
    ((yyvsp[-1].arcbox))->AddArcList((yyvsp[0].arclist));
    (yyval.arcboxseries) = new BoxSeries((yyvsp[-1].arcbox), nullptr);
  #endif
}
#line 9775 "msc_lang.cc"
    break;

  case 331:
#line 5164 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[-1])))
        Box::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[-1])))
        Box::AttributeValues(csh.hintAttrName, csh);
  #else
    ((yyvsp[-2].arcbox))->SetLineEnd(CHART_POS2((yylsp[-2]), (yylsp[-1])));
    ((yyvsp[-2].arcbox))->AddArcList((yyvsp[0].arclist));
    (yyval.arcboxseries) = new BoxSeries((yyvsp[-2].arcbox), (yyvsp[-1].attriblist));
  #endif
}
#line 9792 "msc_lang.cc"
    break;

  case 332:
#line 5179 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ENTITY)) {
        csh.AddEntitiesToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arcpipe) = new Pipe((yyvsp[0].arcbox));
    ((yyval.arcpipe))->SetLineEnd(CHART_POS((yyloc)));
    ((yyval.arcpipe))->AddAttributeList(nullptr);
  #endif
    free((yyvsp[-1].str));
}
#line 9814 "msc_lang.cc"
    break;

  case 333:
#line 5197 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ENTITY)) {
        csh.AddEntitiesToHints();
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a box symbol.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a box symbol. Ignoring pipe.");
    (yyval.arcpipe) = nullptr;
  #endif
    free((yyvsp[-1].str));
}
#line 9836 "msc_lang.cc"
    break;

  case 334:
#line 5215 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else
        csh.CheckEntityHintAfter((yylsp[0]));
  #else
    (yyval.arcpipe) = nullptr;
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "The keyword '" + string((yyvsp[0].str)) +"' should be followed by an entity, or '--', '..', '++' or '=='.");
  #endif
    free((yyvsp[0].str));
}
#line 9855 "msc_lang.cc"
    break;

  case 335:
#line 5230 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::ENTITY)) {
        csh.AddEntitiesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Pipe::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Pipe::AttributeValues(csh.hintAttrName, csh);
  #else
    (yyval.arcpipe) = new Pipe((yyvsp[-1].arcbox));
    ((yyval.arcpipe))->SetLineEnd(CHART_POS((yyloc)));
    ((yyval.arcpipe))->AddAttributeList((yyvsp[0].attriblist));
  #endif
    free((yyvsp[-2].str));
}
#line 9880 "msc_lang.cc"
    break;

  case 336:
#line 5252 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.CheckEntityHintAfter((yyloc));
  #else
    if ((yyvsp[0].arcpipe))
      (yyval.arcpipeseries) = new PipeSeries((yyvsp[0].arcpipe));
    else
      (yyval.arcpipeseries) = nullptr;
  #endif
}
#line 9895 "msc_lang.cc"
    break;

  case 337:
#line 5263 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.CheckEntityHintAfter((yyloc));
#else
    //($2) is never nullptr: "boxrel" always return a value (except oo memory)
    Pipe *ap = new Pipe((yyvsp[0].arcbox));
    ap->SetLineEnd(CHART_POS((yylsp[0])));
    if ((yyvsp[-1].arcpipeseries))
      (yyval.arcpipeseries) = ((yyvsp[-1].arcpipeseries))->AddFollowWithAttributes(ap, nullptr);
    else {
      ap->AddAttributeList(nullptr);
      (yyval.arcpipeseries) = new PipeSeries(ap);
    }
  #endif
}
#line 9915 "msc_lang.cc"
    break;

  case 338:
#line 5279 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Pipe::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Pipe::AttributeValues(csh.hintAttrName, csh);
    else
        csh.CheckEntityHintAfter((yyloc));
  #else
    //($2) is never nullptr: "boxrel" always return a value (except oo memory)
    Pipe *ap = new Pipe((yyvsp[-1].arcbox));
    ap->SetLineEnd(CHART_POS2((yylsp[-1]), (yylsp[0])));
    if ((yyvsp[-2].arcpipeseries))
      (yyval.arcpipeseries) = ((yyvsp[-2].arcpipeseries))->AddFollowWithAttributes(ap, (yyvsp[0].attriblist));
    else {
      ap->AddAttributeList((yyvsp[0].attriblist));
      (yyval.arcpipeseries) = new PipeSeries(ap);
    }
  #endif
}
#line 9940 "msc_lang.cc"
    break;

  case 340:
#line 5302 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.CheckEntityHintBetween((yylsp[-1]), (yylsp[0]));
  #else
    (yyval.arcpipeseries) = ((yyvsp[-1].arcpipeseries))->AddArcList((yyvsp[0].arclist));
  #endif
}
#line 9952 "msc_lang.cc"
    break;

  case 343:
#line 5313 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.CheckEntityHintAt((yylsp[-2]));
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0]));
    if (!(yyvsp[0].multi_str).had_error)
         csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error)
        (yyval.arcbox) = nullptr;
    else
        (yyval.arcbox) = new Box((yyvsp[-1].arcsymbol), CHART_POS((yylsp[-1])), (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), &chart);
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 9975 "msc_lang.cc"
    break;

  case 344:
#line 5332 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0]));
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.arcbox) = nullptr;
    else
        (yyval.arcbox) = new Box((yyvsp[-1].arcsymbol), CHART_POS((yylsp[-1])), nullptr, CHART_POS((yylsp[-1])), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), &chart);
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 9994 "msc_lang.cc"
    break;

  case 345:
#line 5347 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.CheckEntityHintAt((yylsp[-1]));
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    csh.CheckEntityHintAfter((yylsp[0]));
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.arcbox) = nullptr;
    else
        (yyval.arcbox) = new Box((yyvsp[0].arcsymbol), CHART_POS((yylsp[0])), (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), nullptr, CHART_POS((yylsp[0])), &chart);
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 10014 "msc_lang.cc"
    break;

  case 346:
#line 5363 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    csh.CheckEntityHintAfter((yylsp[0]));
  #else
    (yyval.arcbox) = new Box((yyvsp[0].arcsymbol), CHART_POS((yylsp[0])), nullptr, CHART_POS((yylsp[0])), nullptr, CHART_POS((yylsp[0])), &chart);
  #endif
}
#line 10027 "msc_lang.cc"
    break;

  case 351:
#line 5375 "msc_lang.yy"
{
    //mscgen compatibility: a box with no content or
#ifdef C_S_H_IS_COMPILED
    csh.CheckEntityHintAt((yylsp[-2]));
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (csh.mscgen_compat == EMscgenCompat::FORCE_MSCGEN)
        csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    else
        csh.AddCSH((yylsp[-1]), COLOR_KEYWORD_MSCGEN);
    csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0]));
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
#else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error) {
        (yyval.arcbox) = nullptr;
    } else {
        Box::Emscgen_compat c = Box::MSCGEN_COMPAT_NONE;
        if (CaseInsensitiveEqual((yyvsp[-1].str), "rbox")) c = Box::MSCGEN_COMPAT_RBOX;
        else if (CaseInsensitiveEqual((yyvsp[-1].str), "abox")) c = Box::MSCGEN_COMPAT_ABOX;
        else if (CaseInsensitiveEqual((yyvsp[-1].str), "box")) c = Box::MSCGEN_COMPAT_BOX;
        else if (CaseInsensitiveEqual((yyvsp[-1].str), "note")) c = Box::MSCGEN_COMPAT_NOTE;
        (yyval.arcbox) = new Box(c, CHART_POS((yylsp[-1])), (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), &chart);
    }
    if (chart.mscgen_compat != EMscgenCompat::FORCE_MSCGEN)
        chart.Error.WarnMscgen(CHART_POS_START((yylsp[-1])), "Deprecated box symbol.", "Use '--' and attribute 'line.corner' instead.");
#endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[-1].str));
    free((yyvsp[0].multi_str).str);
}
#line 10063 "msc_lang.cc"
    break;

  case 352:
#line 5408 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    }
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-1].str));
    free((yyvsp[0].multi_str).str);
}
#line 10089 "msc_lang.cc"
    break;

  case 353:
#line 5430 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-2]), (yylsp[-1]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    }
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), VertXPos::POS_AT, atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].multi_str).str);
    free((yyvsp[0].str));
}
#line 10117 "msc_lang.cc"
    break;

  case 354:
#line 5454 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-2]), (yylsp[-1]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    } else
        csh.CheckEntityHintAfter((yylsp[0]));
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), VertXPos::POS_LEFT_SIDE);
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].multi_str).str);
}
#line 10145 "msc_lang.cc"
    break;

  case 355:
#line 5478 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-3]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-3]), (yylsp[-2]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-2].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), VertXPos::POS_LEFT_SIDE, atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].str));
}
#line 10174 "msc_lang.cc"
    break;

  case 356:
#line 5503 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-2]), (yylsp[-1]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), VertXPos::POS_RIGHT_SIDE);
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].multi_str).str);
}
#line 10201 "msc_lang.cc"
    break;

  case 357:
#line 5526 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-3]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-3]), (yylsp[-2]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    }
#else
    if ((yyvsp[-2].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), VertXPos::POS_RIGHT_SIDE, atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].str));
}
#line 10230 "msc_lang.cc"
    break;

  case 358:
#line 5551 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-2]), (yylsp[-1]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else switch ((yyvsp[0].arcsymbol)) {
    default:
        _ASSERT(0);
        FALLTHROUGH;
    case EArcSymbol::BOX_SOLID:
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), VertXPos::POS_LEFT_BY);
        break;
    case EArcSymbol::BOX_DASHED:
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), VertXPos::POS_RIGHT_BY);
        break;
    case EArcSymbol::BOX_DOTTED:
        chart.Error.Error(CHART_POS_START((yylsp[0])),
                        "unexpected '..', expected '-', '--', '+' or '++'."
                        " Ignoring vertical.");
        (yyval.vertxpos) = nullptr;
        break;
    case EArcSymbol::BOX_DOUBLE:
        chart.Error.Error(CHART_POS_START((yylsp[0])),
                        "unexpected '==', expected '-', '--', '+' or '++'."
                        " Ignoring vertical.");
        (yyval.vertxpos) = nullptr;
        break;
    }
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].multi_str).str);
}
#line 10278 "msc_lang.cc"
    break;

  case 359:
#line 5595 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
    if (csh.CheckHintAt((yylsp[-3]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-3]), (yylsp[-2]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    } else
        csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0]));
  #else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 10309 "msc_lang.cc"
    break;

  case 360:
#line 5622 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
    if (csh.CheckHintAt((yylsp[-3]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-3]), (yylsp[-2]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    } else
        csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0]));
  #else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 10340 "msc_lang.cc"
    break;

  case 361:
#line 5649 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-4]), COLOR_KEYWORD);
    if (!(yyvsp[-3].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-3]), (yyvsp[-3].multi_str).str);
    csh.AddCSH((yylsp[-2]), COLOR_SYMBOL);
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-4]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-4]), (yylsp[-3]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    } else
        csh.CheckEntityHintBetweenAndAt((yylsp[-2]), (yylsp[-1]));
  #else
    if ((yyvsp[-3].multi_str).had_error || (yyvsp[-1].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-3].multi_str).str, CHART_POS((yylsp[-3])), (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-4].str));
    free((yyvsp[-3].multi_str).str);
    free((yyvsp[-1].multi_str).str);
    free((yyvsp[0].str));
}
#line 10373 "msc_lang.cc"
    break;

  case 362:
#line 5678 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-4]), COLOR_KEYWORD);
    if (!(yyvsp[-3].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-3]), (yyvsp[-3].multi_str).str);
    csh.AddCSH((yylsp[-2]), COLOR_SYMBOL);
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    if (csh.CheckHintAt((yylsp[-4]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-4]), (yylsp[-3]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    } else
        csh.CheckEntityHintBetweenAndAt((yylsp[-2]), (yylsp[-1]));
  #else
    if ((yyvsp[-3].multi_str).had_error || (yyvsp[-1].multi_str).had_error)
        (yyval.vertxpos) = nullptr;
    else
        (yyval.vertxpos) = new VertXPos(chart, (yyvsp[-3].multi_str).str, CHART_POS((yylsp[-3])), (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), atof((yyvsp[0].str)));
  #endif
    free((yyvsp[-4].str));
    free((yyvsp[-3].multi_str).str);
    free((yyvsp[-1].multi_str).str);
    free((yyvsp[0].str));
}
#line 10406 "msc_lang.cc"
    break;

  case 363:
#line 5707 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintAfter((yylsp[0]))) {
        csh.AddVertXPosSyntaxNonSelectableToHints(false);
        csh.hintStatus = HINT_READY;
    }
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing an entity name.");
  #else
    (yyval.vertxpos) = nullptr;
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing an entity name.");
  #endif
    free((yyvsp[0].str));
}
#line 10428 "msc_lang.cc"
    break;

  case 364:
#line 5727 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
	(yyval.arctypeplusdir) = 0; //dummy to supress warning
  #else
    (yyval.arctypeplusdir) = new ArcTypePlusDir((yyvsp[0].arcsymbol), EDirType::INDETERMINATE);
  #endif
}
#line 10441 "msc_lang.cc"
    break;

  case 365:
#line 5736 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    csh.CheckEntityHintBetween((yylsp[-1]), (yylsp[0]));
	(yyval.arctypeplusdir) = 0; //dummy to supress warning
  #else
    (yyval.arctypeplusdir) = new ArcTypePlusDir((yyvsp[0].arcsymbol), EArrowLost::AT_SRC, EDirType::INDETERMINATE, CHART_POS((yylsp[-1])));
  #endif
}
#line 10455 "msc_lang.cc"
    break;

  case 366:
#line 5746 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
	(yyval.arctypeplusdir) = 0; //dummy to supress warning
  #else
    (yyval.arctypeplusdir) = new ArcTypePlusDir((yyvsp[-1].arcsymbol), EArrowLost::AT_SRC, EDirType::INDETERMINATE, CHART_POS((yylsp[0])));
  #endif
}
#line 10468 "msc_lang.cc"
    break;

  case 367:
#line 5755 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_SYMBOL);
    csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
    csh.CheckEntityHintBetween((yylsp[-2]), (yylsp[-1]));
    (yyval.arctypeplusdir) = 0; //dummy to supress warning
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Only one loss can be specified. Ignoring second asterisk ('*').");
    (yyval.arctypeplusdir) = new ArcTypePlusDir((yyvsp[-1].arcsymbol), EArrowLost::AT_SRC, EDirType::INDETERMINATE, CHART_POS((yylsp[-2])));
  #endif
}
#line 10484 "msc_lang.cc"
    break;

  case 368:
#line 5767 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	(yyval.arctypeplusdir) = 0; //dummy to supress warning
  #else
    (yyval.arctypeplusdir) = new ArcTypePlusDir((yyvsp[0].arcsegdata), EDirType::LEFT);
  #endif
}
#line 10496 "msc_lang.cc"
    break;

  case 369:
#line 5775 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	(yyval.arctypeplusdir) = 0; //dummy to supress warning
  #else
    (yyval.arctypeplusdir) = new ArcTypePlusDir((yyvsp[0].arcsegdata), EDirType::RIGHT);
  #endif
}
#line 10508 "msc_lang.cc"
    break;

  case 370:
#line 5783 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	(yyval.arctypeplusdir) = 0; //dummy to supress warning
  #else
    (yyval.arctypeplusdir) = new ArcTypePlusDir((yyvsp[0].arcsegdata), EDirType::BIDIR);
  #endif
}
#line 10520 "msc_lang.cc"
    break;

  case 371:
#line 5792 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-2].multi_str).had_error)
       csh.AddCSH((yylsp[-2]), COLOR_MARKERNAME);
    if (!(yyvsp[0].multi_str).had_error)
       csh.AddCSH((yylsp[0]), COLOR_MARKERNAME);
    if (csh.CheckHintAt((yylsp[-2]), EHintSourceType::MARKER))
        if (csh.hint_vertical_shapes)
            csh.AddVerticalTypesToHints();
    csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::MARKER);
  #else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error)
        (yyval.arcvertarrow) = nullptr;
    else
        (yyval.arcvertarrow) = new Vertical((yyvsp[-1].arctypeplusdir), (yyvsp[-2].multi_str).str, (yyvsp[0].multi_str).str, &chart);
    delete (yyvsp[-1].arctypeplusdir);
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 10545 "msc_lang.cc"
    break;

  case 372:
#line 5813 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_MARKERNAME);
    if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::MARKER))
        if (csh.hint_vertical_shapes)
            csh.AddVerticalTypesToHints();
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.arcvertarrow) = nullptr;
    else
        (yyval.arcvertarrow) = new Vertical((yyvsp[-1].arctypeplusdir), MARKER_HERE_STR, (yyvsp[0].multi_str).str, &chart);
    delete (yyvsp[-1].arctypeplusdir);
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 10566 "msc_lang.cc"
    break;

  case 373:
#line 5830 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH((yylsp[-1]), COLOR_MARKERNAME);
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::MARKER))
        if (csh.hint_vertical_shapes)
            csh.AddVerticalTypesToHints();
    csh.CheckHintAfter((yylsp[0]), EHintSourceType::MARKER);
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.arcvertarrow) = nullptr;
    else
        (yyval.arcvertarrow) = new Vertical((yyvsp[0].arctypeplusdir), (yyvsp[-1].multi_str).str, MARKER_HERE_STR, &chart);
    delete (yyvsp[0].arctypeplusdir);
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 10588 "msc_lang.cc"
    break;

  case 374:
#line 5848 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.CheckHintAfter((yylsp[0]), EHintSourceType::MARKER);
  #else
    (yyval.arcvertarrow) = new Vertical((yyvsp[0].arctypeplusdir), MARKER_HERE_STR, MARKER_HERE_STR, &chart);
    delete (yyvsp[0].arctypeplusdir);
  #endif
}
#line 10601 "msc_lang.cc"
    break;

  case 375:
#line 5857 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_MARKERNAME);
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::MARKER))
        if (csh.hint_vertical_shapes)
            csh.AddVerticalTypesToHints();
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a box or arrow symbol.");
  #else
    (yyval.arcvertarrow) = nullptr;
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a box or arrow symbol.");
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 10620 "msc_lang.cc"
    break;

  case 376:
#line 5874 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    if ((yyvsp[-1].arcvertarrow))
        (yyval.arcvertarrow) = ((yyvsp[-1].arcvertarrow))->AddXpos((yyvsp[0].vertxpos));
    else
        (yyval.arcvertarrow) = nullptr;
    delete (yyvsp[0].vertxpos);
  #endif
}
#line 10635 "msc_lang.cc"
    break;

  case 377:
#line 5885 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    }
#else
    if ((yyvsp[0].arcvertarrow)) {
        VertXPos vxp;
        (yyval.arcvertarrow) = ((yyvsp[0].arcvertarrow))->AddXpos(&vxp);
    } else
        (yyval.arcvertarrow) = nullptr;
  #endif
}
#line 10654 "msc_lang.cc"
    break;

  case 378:
#line 5900 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    if ((yyvsp[0].vertxpos)) {
		ArcTypePlusDir typeplusdir;
		typeplusdir.arc.type = EArcSymbol::ARC_SOLID;
		typeplusdir.arc.lost = EArrowLost::NOT;
		typeplusdir.dir = EDirType::RIGHT;
		Vertical *ava = new Vertical(&typeplusdir, MARKER_HERE_STR, MARKER_HERE_STR, &chart);
		ava->AddXpos((yyvsp[0].vertxpos));
		(yyval.arcvertarrow) = ava;
		delete (yyvsp[0].vertxpos);
	} else
	    (yyval.arcvertarrow) = nullptr;
  #endif
}
#line 10675 "msc_lang.cc"
    break;

  case 379:
#line 5918 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
  #else
    (yyval.arcbase) = new Divider((yyvsp[0].arcsymbol), &chart);
  #endif
}
#line 10687 "msc_lang.cc"
    break;

  case 380:
#line 5926 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddArrowSpecifiersToHints();
        csh.hintStatus = HINT_READY;
    }
  #endif
    //explicit copy here to suppress bison warning (since the two types are different)
    (yyval.arcbase) = (yyvsp[0].arcarrow);
}
#line 10702 "msc_lang.cc"
    break;

  case 381:
#line 5937 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #endif
    //explicit copy here to suppress bison warning (since the two types are different)
    (yyval.arcbase) = (yyvsp[0].arcarrow);
}
#line 10713 "msc_lang.cc"
    break;

  case 382:
#line 5944 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[0]), "Could not figure out what comes here.");
    if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddArrowSpecifiersToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Could not figure out what comes here.");
  #endif
    //explicit copy here to suppress bison warning (since the two types are different)
    (yyval.arcbase) = (yyvsp[-1].arcarrow);
}
#line 10731 "msc_lang.cc"
    break;

  case 383:
#line 5958 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[0]), "Could not figure out what comes here.");
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Could not figure out what comes here.");
  #endif
    //explicit copy here to suppress bison warning (since the two types are different)
    (yyval.arcbase) = (yyvsp[-1].arcarrow);
}
#line 10745 "msc_lang.cc"
    break;

  case 384:
#line 5969 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (CaseInsensitiveBeginsWith("lost", (yyvsp[0].str)) ||
        CaseInsensitiveBeginsWith("start", (yyvsp[0].str)) ||
        CaseInsensitiveBeginsWith("end", (yyvsp[0].str)))
        csh.AddCSH((yylsp[0]), COLOR_KEYWORD_PARTIAL);
    else
        csh.AddCSH_Error((yylsp[0]), "Expecting 'lost at', 'start before' or 'end after' clauses, a semicolon ';' or attributes '['.");
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddArrowSpecifiersToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Expecting 'lost at', 'start before' or 'end after' clauses, a semicolon ';' or attributes '['.");
    (yyval.arcarrow) = ((yyvsp[-1].arcarrow));
  #endif
   free((yyvsp[0].str));
}
#line 10768 "msc_lang.cc"
    break;

  case 385:
#line 5988 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing 'at' clause.");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing 'at' clause.");
    (yyval.arcarrow) = ((yyvsp[-1].arcarrow));
  #endif
   free((yyvsp[0].str));
}
#line 10787 "msc_lang.cc"
    break;

  case 386:
#line 6003 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing 'before' keyword.");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_KEYWORD) + "before",
            "Use the 'start before' keyword to indicate where the message originates from.",
            EHintType::KEYWORD, true));
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing 'before' keyword.");
    (yyval.arcarrow) = ((yyvsp[-1].arcarrow));
  #endif
   free((yyvsp[0].str));
}
#line 10808 "msc_lang.cc"
    break;

  case 387:
#line 6020 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (CaseInsensitiveBeginsWith("before", (yyvsp[0].str)))
        csh.AddCSH((yylsp[0]), COLOR_KEYWORD_PARTIAL);
    else
        csh.AddCSH_Error((yylsp[0]), "Missing 'before' keyword.");
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_KEYWORD) + "before",
            "Use the 'start before' keyword to indicate where the message originates from.",
            EHintType::KEYWORD, true));
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Missing 'before' keyword.");
    (yyval.arcarrow) = ((yyvsp[-2].arcarrow));
  #endif
   free((yyvsp[-1].str));
   free((yyvsp[0].str));
}
#line 10833 "msc_lang.cc"
    break;

  case 388:
#line 6041 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing an entity after 'start before'.");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddStartBeforeEndAfterContentToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing entity after the 'start before' clause.");
    (yyval.arcarrow) = ((yyvsp[-2].arcarrow));
  #endif
   free((yyvsp[-1].str));
   free((yyvsp[0].str));
}
#line 10854 "msc_lang.cc"
    break;

  case 389:
#line 6058 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing 'after' keyword.");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_KEYWORD) + "after",
            "Use the 'end after' keyword to indicate where the message is sent to.",
            EHintType::KEYWORD, true));
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing 'after' keyword.");
    (yyval.arcarrow) = ((yyvsp[-1].arcarrow));
  #endif
   free((yyvsp[0].str));
}
#line 10875 "msc_lang.cc"
    break;

  case 390:
#line 6075 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (CaseInsensitiveBeginsWith("after", (yyvsp[0].str)))
        csh.AddCSH((yylsp[0]), COLOR_KEYWORD_PARTIAL);
    else
        csh.AddCSH_Error((yylsp[0]), "Missing 'after' keyword.");
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_KEYWORD) + "after",
            "Use the 'end after' keyword to indicate where the message is sent to.",
            EHintType::KEYWORD, true));
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Missing 'after' keyword.");
    (yyval.arcarrow) = ((yyvsp[-2].arcarrow));
  #endif
   free((yyvsp[-1].str));
   free((yyvsp[0].str));
}
#line 10900 "msc_lang.cc"
    break;

  case 391:
#line 6096 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing an entity after 'end after'.");
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddStartBeforeEndAfterContentToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing entity after the 'end after' clause.");
    (yyval.arcarrow) = ((yyvsp[-2].arcarrow));
  #endif
   free((yyvsp[-1].str));
   free((yyvsp[0].str));
}
#line 10921 "msc_lang.cc"
    break;

  case 392:
#line 6115 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddArrowSpecifiersToHints();
        csh.hintStatus = HINT_READY;
    }
  #endif
    (yyval.arcarrow) = (yyvsp[0].arcarrow);
}
#line 10935 "msc_lang.cc"
    break;

  case 393:
#line 6125 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
  #else
    if ((yyvsp[-2].arcarrow))
        (yyval.arcarrow) = ((yyvsp[-2].arcarrow))->AddLostPos((yyvsp[0].vertxpos), CHART_POS2((yylsp[-1]), (yylsp[0])));
    else {
        (yyval.arcarrow) = nullptr;
        delete (yyvsp[0].vertxpos);
    }
  #endif
   free((yyvsp[-1].str));
}
#line 10953 "msc_lang.cc"
    break;

  case 394:
#line 6139 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
  #else
    (yyval.arcarrow) = ((yyvsp[-3].arcarrow))->AddStartPos((yyvsp[0].arrowending));
  #endif
   free((yyvsp[-2].str));
   free((yyvsp[-1].str));
}
#line 10968 "msc_lang.cc"
    break;

  case 395:
#line 6150 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
  #else
    (yyval.arcarrow) = ((yyvsp[-3].arcarrow))->AddEndPos((yyvsp[0].arrowending));
  #endif
   free((yyvsp[-2].str));
   free((yyvsp[-1].str));
}
#line 10983 "msc_lang.cc"
    break;

  case 396:
#line 6162 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH((yylsp[0]), COLOR_ENTITYNAME);
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.arrowending) = nullptr;
    else
        (yyval.arrowending) = new ArrowEnding(chart, (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])));
  #endif
   free((yyvsp[0].multi_str).str);
}
#line 11000 "msc_lang.cc"
    break;

  case 397:
#line 6175 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH((yylsp[-1]), COLOR_ENTITYNAME);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.arrowending) = nullptr;
    else
        (yyval.arrowending) = new ArrowEnding(chart, (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), atof((yyvsp[0].str)));
  #endif
   free((yyvsp[-1].multi_str).str);
   free((yyvsp[0].str));
}
#line 11019 "msc_lang.cc"
    break;

  case 398:
#line 6190 "msc_lang.yy"
{
  //We allow this to capture <entity>+-number without space
  //Find the +-sign's offset
  unsigned off = 0;
  while (((yyvsp[0].str))[off] && ((yyvsp[0].str))[off]!='+' && ((yyvsp[0].str))[off]!='-') off++;
  #ifdef C_S_H_IS_COMPILED
    CshPos pos = (yylsp[0]);
    pos.last_pos = (pos.first_pos + off)-1;
    csh.AddCSH(pos, COLOR_ENTITYNAME);
    pos = (yylsp[0]);
    pos.first_pos = (pos.first_pos+off);
    csh.AddCSH(pos, COLOR_ATTRVALUE);
  #else
    double offset = atof(((yyvsp[0].str))+off);
    auto pos = CHART_POS((yylsp[0]));
    pos.end.col -= strlen((yyvsp[0].str))-off;
    ((yyvsp[0].str))[off] = 0; //truncate string to actual entity name
    (yyval.arrowending) = new ArrowEnding(chart, (yyvsp[0].str), pos, offset);
  #endif
   free((yyvsp[0].str));
}
#line 11045 "msc_lang.cc"
    break;

  case 402:
#line 6215 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    //This rule can happen only in mscgen compat mode
    //(or else the lexer does not return TOK_REL_MSCGEN
    _ASSERT(csh.mscgen_compat == EMscgenCompat::FORCE_MSCGEN);
    if (csh.CheckEntityHintAt((yylsp[-2])) || csh.CheckEntityHintAt((yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
#else
    //This rule can happen only in mscgen compat mode
    //(or else the lexer does not return TOK_REL_MSCGEN
    _ASSERT(chart.mscgen_compat == EMscgenCompat::FORCE_MSCGEN);
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error)
        (yyval.arcarrow) = nullptr;
    else {
        ArrowSegmentData data((yyvsp[-1].arcsymbol));
        (yyval.arcarrow) = chart.CreateArrow(data, (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, true, CHART_POS((yylsp[0])), (yyvsp[-2].multi_str).had_param || (yyvsp[0].multi_str).had_param);
        ((yyval.arcarrow))->Indicate_Mscgen_Headless();
    }
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 11077 "msc_lang.cc"
    break;

  case 403:
#line 6243 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])) || csh.CheckEntityHintAt((yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error)
        (yyval.arcarrow) = nullptr;
    else {
        ArrowSegmentData data(EArcSymbol::ARC_SOLID, EArrowLost::AT_DST, CHART_POS((yylsp[-1])));
        (yyval.arcarrow) = chart.CreateArrow(data, (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, true, CHART_POS((yylsp[0])), (yyvsp[-2].multi_str).had_param || (yyvsp[0].multi_str).had_param);
    }
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 11102 "msc_lang.cc"
    break;

  case 404:
#line 6264 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-3])) || csh.CheckEntityHintAt((yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[-3].multi_str).had_error)
    csh.AddCSH_EntityName((yylsp[-3]), (yyvsp[-3].multi_str).str);
    if (csh.mscgen_compat == EMscgenCompat::FORCE_MSCGEN) {
        if (((yylsp[-2])).last_pos+1 == ((yylsp[-1])).first_pos) {
            csh.AddCSH((yylsp[-2]) + (yylsp[-1]), COLOR_SYMBOL);
            if (!(yyvsp[0].multi_str).had_error)
                csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
        } else {
            csh.AddCSH_Error((yylsp[-2]), "Missing arrow symbol before 'x'. (Perhaps remove space after?)");
        }
    } else {
        if (((yylsp[-2])).last_pos+1 == ((yylsp[-1])).first_pos) {
            csh.AddCSH_Error((yylsp[-2]) + (yylsp[-1]), "Unsupported arrow symbol ('x-'), use '* <-' for indicating loss instead.");
        } else {
            csh.AddCSH_Error((yylsp[-2]), "Missing arrow symbol before 'x'.");
        }
    }
  #else
    if (chart.mscgen_compat == EMscgenCompat::FORCE_MSCGEN) {
        if (CHART_POS_AFTER((yylsp[-2])) == CHART_POS_START((yylsp[-1]))) {
            if ((yyvsp[-3].multi_str).had_error || (yyvsp[0].multi_str).had_error)
                (yyval.arcarrow) = nullptr;
            else {
                ArrowSegmentData data(EArcSymbol::ARC_SOLID, EArrowLost::AT_DST, CHART_POS((yylsp[-2])));
                (yyval.arcarrow) = chart.CreateArrow(data, (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), (yyvsp[-3].multi_str).str, false, CHART_POS((yylsp[-3])), (yyvsp[-3].multi_str).had_param || (yyvsp[0].multi_str).had_param);
            }
        } else {
            chart.Error.Error(CHART_POS_START((yylsp[-2])), "Missing arrow symbol before 'x'.",
                "Perhaps remove the whitespace after?");
            (yyval.arcarrow) = nullptr;
        }
    } else {
        if (CHART_POS_AFTER((yylsp[-2])) == CHART_POS_START((yylsp[-1]))) {
            chart.Error.Error(CHART_POS_START((yylsp[-2])), "This arrow symbol ('x-') is supported only in mscgen compatibility mode.",
                "Use an asterisk '*' instead to express a lost message (like '-> *').");
            (yyval.arcarrow) = nullptr;
        } else {
            chart.Error.Error(CHART_POS_START((yylsp[-2])), "Missing arrow symbol before 'x'.");
            (yyval.arcarrow) = nullptr;
        }
    }
  #endif
    free((yyvsp[-3].multi_str).str);
    free((yyvsp[-2].str));
    free((yyvsp[0].multi_str).str);
}
#line 11157 "msc_lang.cc"
    break;

  case 405:
#line 6315 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-1])))
        csh.AllowAnything();
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing an entity name.");
  #else
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing an entity name after the loss arrow symbol.");
    (yyval.arcarrow) = nullptr;
#endif
    free((yyvsp[-1].multi_str).str);
}
#line 11176 "msc_lang.cc"
    break;

  case 406:
#line 6330 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (csh.mscgen_compat == EMscgenCompat::FORCE_MSCGEN) {
        if (((yylsp[-1])).last_pos+1 == ((yylsp[0])).first_pos) {
            csh.AddCSH((yylsp[-1]) + (yylsp[0]), COLOR_SYMBOL);
            csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing an entity name.");
        } else {
            csh.AddCSH_Error((yylsp[-1]), "Missing arrow symbol before 'x'. (Perhaps remove space after?)");
        }
    } else {
        if (((yylsp[-1])).last_pos+1 == ((yylsp[0])).first_pos) {
            csh.AddCSH_Error((yylsp[-1]) + (yylsp[0]), "Unsupported arrow symbol ('x-'), use '* <-' for indicating loss instead.");
        } else {
            csh.AddCSH_Error((yylsp[-1]), "Missing arrow symbol before 'x'.");
        }
    }
  #else
    if (chart.mscgen_compat == EMscgenCompat::FORCE_MSCGEN && CHART_POS_AFTER((yylsp[-1])) == CHART_POS_START((yylsp[0])))
         chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing an entity name after the loss arrow symbol.");
    else
        chart.Error.Error(CHART_POS_START((yylsp[-1])), "Missing arrow symbol before 'x'.");
    (yyval.arcarrow) = nullptr;
#endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[-1].str));
}
#line 11211 "msc_lang.cc"
    break;

  case 407:
#line 6361 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])) || csh.CheckEntityHintAt((yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
    csh.AddCSH_Error((yylsp[-1]), "Missing an arrow or box symbol.");
  #else
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Missing an arrow or box symbol. Ignoring this line.");
    (yyval.arcarrow) = nullptr;
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 11232 "msc_lang.cc"
    break;

  case 408:
#line 6378 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_Error((yylsp[-1])+(yylsp[0]), "Missing an arrow or box symbol.");
  #else
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Missing an arrow or box symbol. Ignoring this line.");
    (yyval.arcarrow) = nullptr;
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11246 "msc_lang.cc"
    break;

  case 409:
#line 6388 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-1])))
        csh.AllowAnything();
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    csh.AddCSH_Error((yylsp[0]), "Missing an arrow or box symbol.");
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Missing an arrow or box symbol. Ignoring this line.");
    (yyval.arcarrow) = nullptr;
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 11264 "msc_lang.cc"
    break;

  case 410:
#line 6404 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])) || csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[-2].multi_str).had_error && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, true, CHART_POS((yylsp[0])), (yyvsp[-2].multi_str).had_param || (yyvsp[0].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 11288 "msc_lang.cc"
    break;

  case 411:
#line 6424 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAfter((yylsp[0]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
  #else
    if ((yyvsp[0].arcsegdata)) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[0].arcsegdata), LSIDE_ENT_STR, CHART_POS((yylsp[0])), RSIDE_ENT_STR, true, CHART_POS((yylsp[0])), false);
        delete (yyvsp[0].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
}
#line 11308 "msc_lang.cc"
    break;

  case 412:
#line 6440 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), LSIDE_ENT_STR, CHART_POS((yylsp[-1])), (yyvsp[0].multi_str).str, true, CHART_POS((yylsp[0])), (yyvsp[0].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11329 "msc_lang.cc"
    break;

  case 413:
#line 6457 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_SYMBOL);
    if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
       csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), LSIDE_PIPE_ENT_STR, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, true, CHART_POS((yylsp[0])), (yyvsp[0].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11351 "msc_lang.cc"
    break;

  case 414:
#line 6475 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-1])))
        csh.AllowAnything();
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    if (csh.CheckEntityHintAfter((yylsp[0]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
  #else
    if ((yyvsp[0].arcsegdata) && !(yyvsp[-1].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[0].arcsegdata), (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), RSIDE_ENT_STR, true, CHART_POS((yylsp[0])), (yyvsp[-1].multi_str).had_param);
        delete (yyvsp[0].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 11376 "msc_lang.cc"
    break;

  case 415:
#line 6496 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (csh.CheckEntityHintAfter((yylsp[-1]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[-2].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), RSIDE_PIPE_ENT_STR, true, CHART_POS((yylsp[0])), (yyvsp[-2].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[-2].multi_str).str);
}
#line 11402 "msc_lang.cc"
    break;

  case 416:
#line 6518 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = ((yyvsp[-2].arcarrow))->AddSegment(*(yyvsp[-1].arcsegdata), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), CHART_POS2((yylsp[-1]), (yylsp[0])));
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = (yyvsp[-2].arcarrow);
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11423 "msc_lang.cc"
    break;

  case 417:
#line 6535 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAfter((yylsp[-1]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
  #else
    if ((yyvsp[0].arcsegdata)) {
        (yyval.arcarrow) = ((yyvsp[-1].arcarrow))->AddSegment(*(yyvsp[0].arcsegdata), nullptr, CHART_POS((yylsp[0])), CHART_POS((yylsp[0])));
        delete (yyvsp[0].arcsegdata);
    } else {
        (yyval.arcarrow) = (yyvsp[-1].arcarrow);
    }
  #endif
}
#line 11443 "msc_lang.cc"
    break;

  case 418:
#line 6551 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAfter((yylsp[-2]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
  #else
    if ((yyvsp[-1].arcsegdata)) {
        (yyval.arcarrow) = ((yyvsp[-2].arcarrow))->AddSegment(*(yyvsp[-1].arcsegdata), RSIDE_PIPE_ENT_STR, CHART_POS((yylsp[-1])), CHART_POS((yylsp[-1])));
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = (yyvsp[-2].arcarrow);
    }
  #endif
}
#line 11464 "msc_lang.cc"
    break;

  case 419:
#line 6570 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])) || csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[-2].multi_str).had_error && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), (yyvsp[-2].multi_str).str, false, CHART_POS((yylsp[-2])), (yyvsp[-2].multi_str).had_param || (yyvsp[0].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 11488 "msc_lang.cc"
    break;

  case 420:
#line 6590 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAfter((yylsp[0]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
  #else
    if ((yyvsp[0].arcsegdata)) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[0].arcsegdata), RSIDE_ENT_STR, CHART_POS((yylsp[0])), LSIDE_ENT_STR, false, CHART_POS((yylsp[0])), false);
        delete (yyvsp[0].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
}
#line 11508 "msc_lang.cc"
    break;

  case 421:
#line 6606 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), LSIDE_ENT_STR, false, CHART_POS((yylsp[-1])), (yyvsp[0].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11529 "msc_lang.cc"
    break;

  case 422:
#line 6623 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_SYMBOL);
    if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), LSIDE_PIPE_ENT_STR, false, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11551 "msc_lang.cc"
    break;

  case 423:
#line 6641 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-1])))
        csh.AllowAnything();
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    if (csh.CheckEntityHintAfter((yylsp[0]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
  #else
    if ((yyvsp[0].arcsegdata) && !(yyvsp[-1].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[0].arcsegdata), RSIDE_ENT_STR, CHART_POS((yylsp[0])), (yyvsp[-1].multi_str).str, false, CHART_POS((yylsp[-1])), (yyvsp[-1].multi_str).had_param);
        delete (yyvsp[0].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 11576 "msc_lang.cc"
    break;

  case 424:
#line 6662 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (csh.CheckEntityHintAfter((yylsp[-1]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[-2].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), RSIDE_PIPE_ENT_STR, CHART_POS((yylsp[0])), (yyvsp[-2].multi_str).str, false, CHART_POS((yylsp[-2])), (yyvsp[-2].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[-2].multi_str).str);
}
#line 11602 "msc_lang.cc"
    break;

  case 425:
#line 6684 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = ((yyvsp[-2].arcarrow))->AddSegment(*(yyvsp[-1].arcsegdata), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), CHART_POS2((yylsp[-1]), (yylsp[0])));
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = (yyvsp[-2].arcarrow);
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11623 "msc_lang.cc"
    break;

  case 426:
#line 6701 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAfter((yylsp[0]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
  #else
    if ((yyvsp[0].arcsegdata)) {
        (yyval.arcarrow) = ((yyvsp[-1].arcarrow))->AddSegment(*(yyvsp[0].arcsegdata), nullptr, CHART_POS((yylsp[0])), CHART_POS((yylsp[0])));
        delete (yyvsp[0].arcsegdata);
    } else {
        (yyval.arcarrow) = (yyvsp[-1].arcarrow);
    }
  #endif
}
#line 11643 "msc_lang.cc"
    break;

  case 427:
#line 6717 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAfter((yylsp[-1]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
  #else
    if ((yyvsp[-1].arcsegdata)) {
        (yyval.arcarrow) = ((yyvsp[-2].arcarrow))->AddSegment(*(yyvsp[-1].arcsegdata), RSIDE_PIPE_ENT_STR, CHART_POS((yylsp[0])), CHART_POS((yylsp[-1])));
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = (yyvsp[-2].arcarrow);
    }
  #endif
}
#line 11664 "msc_lang.cc"
    break;

  case 428:
#line 6736 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])) ||csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[-2].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[-2].multi_str).had_error && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, true, CHART_POS((yylsp[0])), (yyvsp[-2].multi_str).had_param || (yyvsp[0].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 11688 "msc_lang.cc"
    break;

  case 429:
#line 6756 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), LSIDE_ENT_STR, CHART_POS((yylsp[-1])), (yyvsp[0].multi_str).str, true, CHART_POS((yylsp[0])), (yyvsp[0].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11709 "msc_lang.cc"
    break;

  case 430:
#line 6773 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAfter((yylsp[0]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
  #else
    if ((yyvsp[0].arcsegdata)) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[0].arcsegdata), LSIDE_ENT_STR, CHART_POS((yylsp[0])), RSIDE_ENT_STR, true, CHART_POS((yylsp[0])), false);
        delete (yyvsp[0].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
}
#line 11729 "msc_lang.cc"
    break;

  case 431:
#line 6789 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_SYMBOL);
    if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), LSIDE_PIPE_ENT_STR, CHART_POS((yylsp[-2])), (yyvsp[0].multi_str).str, true, CHART_POS((yylsp[0])), (yyvsp[0].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11751 "msc_lang.cc"
    break;

  case 432:
#line 6807 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-1])))
        csh.AllowAnything();
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    if (csh.CheckEntityHintAfter((yylsp[0])))
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
  #else
    if ((yyvsp[0].arcsegdata) && !(yyvsp[-1].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[0].arcsegdata), (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])), RSIDE_ENT_STR, true, CHART_POS((yylsp[0])), (yyvsp[-1].multi_str).had_param);
        delete (yyvsp[0].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 11774 "msc_lang.cc"
    break;

  case 433:
#line 6826 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAt((yylsp[-2])))
        csh.AllowAnything();
    csh.AddCSH_EntityName((yylsp[-2]), (yyvsp[-2].multi_str).str);
    if (csh.CheckEntityHintAfter((yylsp[-1]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[-2].multi_str).had_error) {
        (yyval.arcarrow) = chart.CreateArrow(*(yyvsp[-1].arcsegdata), (yyvsp[-2].multi_str).str, CHART_POS((yylsp[-2])), RSIDE_PIPE_ENT_STR, true, CHART_POS((yylsp[0])), (yyvsp[-2].multi_str).had_param);
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = nullptr;
    }
  #endif
    free((yyvsp[-2].multi_str).str);
}
#line 11799 "msc_lang.cc"
    break;

  case 434:
#line 6847 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.AllowAnything();
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_EntityName((yylsp[0]), (yyvsp[0].multi_str).str);
  #else
    if ((yyvsp[-1].arcsegdata) && !(yyvsp[0].multi_str).had_error) {
        (yyval.arcarrow) = ((yyvsp[-2].arcarrow))->AddSegment(*(yyvsp[-1].arcsegdata), (yyvsp[0].multi_str).str, CHART_POS((yylsp[0])), CHART_POS2((yylsp[-1]), (yylsp[0])));
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = (yyvsp[-2].arcarrow);
    }
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 11820 "msc_lang.cc"
    break;

  case 435:
#line 6864 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAfter((yylsp[0]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
  #else
    if ((yyvsp[0].arcsegdata)) {
        (yyval.arcarrow) = ((yyvsp[-1].arcarrow))->AddSegment(*(yyvsp[0].arcsegdata), nullptr, CHART_POS((yylsp[0])), CHART_POS((yylsp[0])));
        delete (yyvsp[0].arcsegdata);
    } else {
        (yyval.arcarrow) = (yyvsp[-1].arcarrow);
    }
  #endif
}
#line 11840 "msc_lang.cc"
    break;

  case 436:
#line 6880 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckEntityHintAfter((yylsp[-1]))) {
        csh.hintStatus = HINT_FILLING; //to allow adding "lost_at"
        csh.AllowAnything();
    }
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
  #else
    if ((yyvsp[-1].arcsegdata)) {
        (yyval.arcarrow) = ((yyvsp[-2].arcarrow))->AddSegment(*(yyvsp[-1].arcsegdata), RSIDE_PIPE_ENT_STR, CHART_POS((yylsp[0])), CHART_POS((yylsp[-1])));
        delete (yyvsp[-1].arcsegdata);
    } else {
        (yyval.arcarrow) = (yyvsp[-2].arcarrow);
    }
  #endif
}
#line 11861 "msc_lang.cc"
    break;

  case 438:
#line 6897 "msc_lang.yy"
                                                {(yyval.arcsymbol)=EArcSymbol::ARC_UNDETERMINED_SEGMENT;}
#line 11867 "msc_lang.cc"
    break;

  case 440:
#line 6898 "msc_lang.yy"
                                                    {(yyval.arcsymbol)=EArcSymbol::ARC_UNDETERMINED_SEGMENT;}
#line 11873 "msc_lang.cc"
    break;

  case 442:
#line 6899 "msc_lang.yy"
                                                      {(yyval.arcsymbol)=EArcSymbol::ARC_UNDETERMINED_SEGMENT;}
#line 11879 "msc_lang.cc"
    break;

  case 443:
#line 6902 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
    csh.asteriskNo = 0;
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol));
  #endif
}
#line 11892 "msc_lang.cc"
    break;

  case 444:
#line 6911 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
    csh.asteriskNo = 1;
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[-1])));
  #endif
}
#line 11905 "msc_lang.cc"
    break;

  case 445:
#line 6920 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
    csh.asteriskNo = 1;
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_DST, CHART_POS((yylsp[0])));
  #endif
}
#line 11918 "msc_lang.cc"
    break;

  case 446:
#line 6929 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]) + (yylsp[-1]), COLOR_SYMBOL);
    csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
    csh.asteriskNo = 2;
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "One arrow may be lost only once. Ignoring subsequent asterisks ('*').");
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[-2])));
  #endif
}
#line 11933 "msc_lang.cc"
    break;

  case 447:
#line 6941 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
    csh.asteriskNo = 1;
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol));
  #endif
}
#line 11946 "msc_lang.cc"
    break;

  case 448:
#line 6950 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
    csh.asteriskNo = 1;
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol), EArrowLost::AT_DST, CHART_POS((yylsp[-1])));
  #endif
}
#line 11959 "msc_lang.cc"
    break;

  case 449:
#line 6959 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
    csh.asteriskNo = 1;
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[0])));
  #endif
}
#line 11972 "msc_lang.cc"
    break;

  case 450:
#line 6968 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]) + (yylsp[-1]), COLOR_SYMBOL);
    csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
    csh.asteriskNo = 2;
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "One arrow may be lost only once. Ignoring subsequent asterisks ('*').");
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_DST, CHART_POS((yylsp[-2])));
  #endif
}
#line 11987 "msc_lang.cc"
    break;

  case 451:
#line 6980 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
    csh.asteriskNo = 0;
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol));
  #endif
}
#line 12000 "msc_lang.cc"
    break;

  case 452:
#line 6989 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
    csh.asteriskNo = 1;
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[-1])));
  #endif
}
#line 12013 "msc_lang.cc"
    break;

  case 453:
#line 6998 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
    csh.asteriskNo = 1;
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_DST, CHART_POS((yylsp[0])));
  #endif
}
#line 12026 "msc_lang.cc"
    break;

  case 454:
#line 7007 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]) + (yylsp[-1]), COLOR_SYMBOL);
    csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
    csh.asteriskNo = 2;
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "One arrow may be lost only once. Ignoring subsequent asterisks ('*').");
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[-2])));
  #endif
}
#line 12041 "msc_lang.cc"
    break;

  case 455:
#line 7019 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol));
  #endif
}
#line 12053 "msc_lang.cc"
    break;

  case 456:
#line 7027 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    if (++csh.asteriskNo == 1)
        csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    else
        csh.AddCSH_Error((yylsp[-1]), MULTIPLE_ASTERISK_ERROR_MSG);
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[-1])));
  #endif
}
#line 12069 "msc_lang.cc"
    break;

  case 457:
#line 7039 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (++csh.asteriskNo == 1)
        csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    else
        csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_DST, CHART_POS((yylsp[0])));
  #endif
}
#line 12085 "msc_lang.cc"
    break;

  case 458:
#line 7051 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (++csh.asteriskNo == 1)
        csh.AddCSH((yylsp[-2]), COLOR_SYMBOL);
    else
        csh.AddCSH_Error((yylsp[-2]), MULTIPLE_ASTERISK_ERROR_MSG);
    csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "One arrow may be lost only once. Ignoring this asterisk ('*').");
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[-2])));
  #endif
}
#line 12103 "msc_lang.cc"
    break;

  case 459:
#line 7066 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol));
  #endif
}
#line 12115 "msc_lang.cc"
    break;

  case 460:
#line 7074 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    if (++csh.asteriskNo == 1)
        csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    else
        csh.AddCSH_Error((yylsp[-1]), MULTIPLE_ASTERISK_ERROR_MSG);
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol), EArrowLost::AT_DST, CHART_POS((yylsp[-1])));
  #endif
}
#line 12131 "msc_lang.cc"
    break;

  case 461:
#line 7086 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (++csh.asteriskNo == 1)
        csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    else
        csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[0])));
  #endif
}
#line 12147 "msc_lang.cc"
    break;

  case 462:
#line 7098 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (++csh.asteriskNo == 1)
        csh.AddCSH((yylsp[-2]), COLOR_SYMBOL);
    else
        csh.AddCSH_Error((yylsp[-2]), MULTIPLE_ASTERISK_ERROR_MSG);
    csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "One arrow may be lost only once. Ignoring this asterisk ('*').");
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_DST, CHART_POS((yylsp[-2])));
  #endif
}
#line 12165 "msc_lang.cc"
    break;

  case 463:
#line 7113 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yyloc), COLOR_SYMBOL);
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol));
  #endif
}
#line 12177 "msc_lang.cc"
    break;

  case 464:
#line 7121 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    if (++csh.asteriskNo == 1)
        csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    else
        csh.AddCSH_Error((yylsp[-1]), MULTIPLE_ASTERISK_ERROR_MSG);
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[0].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[-1])));
  #endif
}
#line 12193 "msc_lang.cc"
    break;

  case 465:
#line 7133 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (++csh.asteriskNo == 1)
        csh.AddCSH((yylsp[0]), COLOR_SYMBOL);
    else
        csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
  #else
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_DST, CHART_POS((yylsp[0])));
  #endif
}
#line 12209 "msc_lang.cc"
    break;

  case 466:
#line 7145 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_SYMBOL);
    if (++csh.asteriskNo == 1)
        csh.AddCSH((yylsp[-2]), COLOR_SYMBOL);
    else
        csh.AddCSH_Error((yylsp[-2]), MULTIPLE_ASTERISK_ERROR_MSG);
    csh.AddCSH_Error((yylsp[0]), MULTIPLE_ASTERISK_ERROR_MSG);
  #else
    chart.Error.Error(CHART_POS_START((yylsp[0])), "One arrow may be lost only once. Ignoring this asterisk ('*').");
    (yyval.arcsegdata) = new ArrowSegmentData((yyvsp[-1].arcsymbol), EArrowLost::AT_SRC, CHART_POS((yylsp[-2])));
  #endif
}
#line 12227 "msc_lang.cc"
    break;

  case 468:
#line 7163 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ExtvxposDesignatorName((yylsp[0]), (yyvsp[0].str));
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_FILLING;
    }
  #else
    (yyval.extvertxpos) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 12244 "msc_lang.cc"
    break;

  case 469:
#line 7177 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ExtvxposDesignatorName((yylsp[-1]), (yyvsp[-1].str));
    if (csh.CheckHintAt((yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_FILLING;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.extvertxpos) = new ExtVertXPos((yyvsp[-1].str), CHART_POS((yylsp[-1])), (yyvsp[0].vertxpos));
  #endif
    free((yyvsp[-1].str));
}
#line 12264 "msc_lang.cc"
    break;

  case 470:
#line 7193 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ExtvxposDesignatorName((yylsp[0]), (yyvsp[0].str));
    if (csh.CheckHintAt((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_FILLING;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddVertXPosSyntaxNonSelectableToHints(true);
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.extvertxpos) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 12284 "msc_lang.cc"
    break;

  case 474:
#line 7214 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    csh.AddCSH_SymbolName((yylsp[-2]), (yyvsp[-2].str));
    if (csh.CheckLineStartHintAt((yylsp[-3]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-3]), (yylsp[-2]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[-1]), EHintSourceType::MARKER)) {
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_FILLING;
    }
  #else
    (yyval.arcbase) = new Symbol(&chart, (yyvsp[-2].str), (yyvsp[-1].namerel), (yyvsp[0].extvertxpos), nullptr);
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[-2].str));
}
#line 12314 "msc_lang.cc"
    break;

  case 475:
#line 7240 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-4]), COLOR_KEYWORD);
    csh.AddCSH_SymbolName((yylsp[-3]), (yyvsp[-3].str));
    if (csh.CheckLineStartHintAt((yylsp[-4]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-4]), (yylsp[-3]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-3]), (yylsp[-2]), EHintSourceType::MARKER)) {
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_FILLING;
    }
#else
    (yyval.arcbase) = new Symbol(&chart, (yyvsp[-3].str), (yyvsp[-2].namerel), (yyvsp[-1].extvertxpos), (yyvsp[0].extvertxpos));
  #endif
    free((yyvsp[-4].str));
    free((yyvsp[-3].str));
}
#line 12347 "msc_lang.cc"
    break;

  case 476:
#line 7270 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-5]), COLOR_KEYWORD);
    csh.AddCSH_SymbolName((yylsp[-4]), (yyvsp[-4].str));
    if (csh.CheckLineStartHintAt((yylsp[-5]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-5]), (yylsp[-4]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-4]), (yylsp[-3]), EHintSourceType::MARKER)) {
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-3]), (yylsp[-2]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_FILLING;
    }
    csh.AddCSH_Error((yylsp[0]), "Too many left/center/right specifiers here, at most two can be given.");
#else
    (yyval.arcbase) = new Symbol(&chart, (yyvsp[-4].str), (yyvsp[-3].namerel), (yyvsp[-2].extvertxpos), (yyvsp[-1].extvertxpos));
    if ((yyvsp[0].extvertxpos))
        delete (yyvsp[0].extvertxpos);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Too many specifiers here, ignoring last one.", "At most two can be given.");
  #endif
    free((yyvsp[-5].str));
    free((yyvsp[-4].str));
}
#line 12387 "msc_lang.cc"
    break;

  case 477:
#line 7306 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH_SymbolName((yylsp[-1]), (yyvsp[-1].str));
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::MARKER)) {
        csh.AddLeftRightCenterToHints(); //markers, plus left/center/right
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_FILLING;
    }
  #else
    (yyval.arcbase) = new Symbol(&chart, (yyvsp[-1].str), nullptr, (yyvsp[0].extvertxpos), nullptr);
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
}
#line 12415 "msc_lang.cc"
    break;

  case 478:
#line 7330 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    csh.AddCSH_SymbolName((yylsp[-2]), (yyvsp[-2].str));
    if (csh.CheckLineStartHintAt((yylsp[-3]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-3]), (yylsp[-2]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::MARKER)) {
        csh.AddLeftRightCenterToHints(); //markers, plus left/center/right
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_FILLING;
    }
#else
    (yyval.arcbase) = new Symbol(&chart, (yyvsp[-2].str), nullptr, (yyvsp[-1].extvertxpos), (yyvsp[0].extvertxpos));
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[-2].str));
}
#line 12446 "msc_lang.cc"
    break;

  case 479:
#line 7357 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH_SymbolName((yylsp[-1]), (yyvsp[-1].str));
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::MARKER)) {
        csh.AddLeftRightCenterToHints(); //markers, plus left/center/right
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arcbase) = new Symbol(&chart, (yyvsp[-1].str), (yyvsp[0].vertxpos), CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
}
#line 12471 "msc_lang.cc"
    break;

  case 480:
#line 7378 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH_SymbolName((yylsp[-1]), (yyvsp[-1].str));
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::MARKER)) {
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_FILLING;
    }
#else
    (yyval.arcbase) = new Symbol(&chart, (yyvsp[-1].str), (yyvsp[0].namerel), nullptr, nullptr);
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
}
#line 12498 "msc_lang.cc"
    break;

  case 481:
#line 7401 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH_SymbolName((yylsp[-1]), (yyvsp[-1].str));
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_LeftRightCenterMarker((yylsp[0]), (yyvsp[0].multi_str).str);
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[-1]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::MARKER)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.arcbase) = nullptr;
    else
        (yyval.arcbase) = new Symbol(&chart, (yyvsp[-1].str), nullptr, nullptr, nullptr);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Expecting 'left', 'right', 'center' or a marker name followed by a dash. Ignoring this piece.");
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
    free((yyvsp[0].multi_str).str);
}
#line 12530 "msc_lang.cc"
    break;

  case 482:
#line 7429 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH_SymbolName((yylsp[0]), (yyvsp[0].str));
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::MARKER)) {
        csh.AddLeftRightCenterToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    (yyval.arcbase) = new Symbol(&chart, (yyvsp[0].str), nullptr, nullptr, nullptr);
  #endif
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 12555 "msc_lang.cc"
    break;

  case 483:
#line 7450 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddSymbolTypesToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS((yylsp[0])).end, "Missing a symbol type.", "Use 'arc', '...', 'text', 'rectangle', 'cross' or 'shape'.");
    (yyval.arcbase) = nullptr;
  #endif
    free((yyvsp[0].str));
}
#line 12576 "msc_lang.cc"
    break;

  case 484:
#line 7468 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    if ((yyvsp[0].arcbase))
        ((yyvsp[0].arcbase))->AddAttributeList(nullptr);
    (yyval.arcbase) = ((yyvsp[0].arcbase));
  #endif
}
#line 12588 "msc_lang.cc"
    break;

  case 485:
#line 7476 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Symbol::AttributeNames(csh);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Symbol::AttributeValues(csh.hintAttrName, csh);
  #else
    if ((yyvsp[-1].arcbase))
        ((yyvsp[-1].arcbase))->AddAttributeList((yyvsp[0].attriblist));
    (yyval.arcbase) = ((yyvsp[-1].arcbase));
  #endif
}
#line 12605 "msc_lang.cc"
    break;

  case 486:
#line 7490 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    if (!(yyvsp[-1].multi_str).had_error)
        csh.AddCSH_EntityOrMarkerName((yylsp[-1]), (yyvsp[-1].multi_str).str);
    if (csh.CheckLineStartHintAt((yylsp[-3]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Note::AttributeNames(csh, true);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Note::AttributeValues(csh.hintAttrName, csh, true);
    else if (csh.CheckEntityHintBetweenAndAt((yylsp[-2]), (yylsp[-1])))
        csh.addMarkersAtEnd = true; //after 'at' a marker or an entity may come
  #else
    if ((yyvsp[-1].multi_str).had_error)
        (yyval.arcbase) = nullptr;
    else {
        (yyval.arcbase) = new Note(&chart, (yyvsp[-1].multi_str).str, CHART_POS((yylsp[-1])));
        ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
    }
  #endif
    free((yyvsp[-3].str));
    free((yyvsp[-2].str));
    free((yyvsp[-1].multi_str).str);
}
#line 12637 "msc_lang.cc"
    break;

  case 487:
#line 7518 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::KEYWORD)) {
        csh.AddToHints(CshHint(csh.HintPrefix(COLOR_KEYWORD) + "at", nullptr, EHintType::KEYWORD, true)); //XXX Other can come
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Note::AttributeNames(csh, true);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Note::AttributeValues(csh.hintAttrName, csh, true);
  #else
    (yyval.arcbase) = new Note(&chart);
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
    free((yyvsp[-1].str));
}
#line 12661 "msc_lang.cc"
    break;

  case 488:
#line 7538 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing an entity or marker name.");
    csh.AddCSH_ErrorAfter((yylsp[0]), "Notes need a label.");
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintAfter((yylsp[0])))
        csh.addMarkersAtEnd = true; //after 'at' a marker or an entity may come
  #else
    (yyval.arcbase) = nullptr;
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing an entity or marker name after 'at'.");
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a label, ignoring note.", "Notes and comments must have text, specify a label.");
#endif
    free((yyvsp[-1].str));
    free((yyvsp[0].str));
}
#line 12685 "msc_lang.cc"
    break;

  case 489:
#line 7558 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_KEYWORD);
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[-1]), "Missing an entity or marker name.");
    if (csh.CheckLineStartHintAt((yylsp[-2]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckEntityHintBetweenAndAt((yylsp[-1]), (yylsp[0])))
        csh.addMarkersAtEnd = true;
    if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Note::AttributeNames(csh, true);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Note::AttributeValues(csh.hintAttrName, csh, true);
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[-1])), "Missing an entity or marker name after 'at'. Ignoring 'at' clause.");
    (yyval.arcbase) = new Note(&chart);
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
    free((yyvsp[-2].str));
    free((yyvsp[-1].str));
}
#line 12712 "msc_lang.cc"
    break;

  case 490:
#line 7582 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    (yyval.eside)= ESide::LEFT;
  #endif
    free((yyvsp[0].str));
}
#line 12723 "msc_lang.cc"
    break;

  case 491:
#line 7589 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    (yyval.eside)= ESide::END;
  #endif
    free((yyvsp[0].str));
}
#line 12734 "msc_lang.cc"
    break;

  case 492:
#line 7596 "msc_lang.yy"
{
  #ifndef C_S_H_IS_COMPILED
    (yyval.eside)= ESide::END;
  #endif
    free((yyvsp[0].str));
}
#line 12745 "msc_lang.cc"
    break;

  case 493:
#line 7604 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_KEYWORD);
    if (csh.CheckLineStartHintAt((yylsp[-1]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    } else if (csh.CheckHintLocated(EHintSourceType::ATTR_NAME, (yylsp[0])))
        Note::AttributeNames(csh, false);
    else if (csh.CheckHintLocated(EHintSourceType::ATTR_VALUE, (yylsp[0])))
        Note::AttributeValues(csh.hintAttrName, csh, false);
  #else
    (yyval.arcbase) = new Note(&chart, (yyvsp[-1].eside));
    ((yyval.arcbase))->AddAttributeList((yyvsp[0].attriblist));
  #endif
}
#line 12765 "msc_lang.cc"
    break;

  case 494:
#line 7620 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_KEYWORD);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Comments and notes need a label.");
    if (csh.CheckLineStartHintAt((yylsp[0]))) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing a label, ignoring comment/note.", "Notes and comments must have text, specify a label.");
    (yyval.arcbase) = nullptr;
  #endif
}
#line 12783 "msc_lang.cc"
    break;

  case 495:
#line 7635 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ColonString_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].str), false);
    csh.AddColonLabel((yylsp[0]), (yyvsp[0].str));
  #endif
    (yyval.str) = (yyvsp[0].str);
}
#line 12795 "msc_lang.cc"
    break;

  case 496:
#line 7643 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ColonString_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].str), true);
	csh.AddColonLabel((yylsp[0]), (yyvsp[0].str));
  #endif
    (yyval.str) = (yyvsp[0].str);
}
#line 12807 "msc_lang.cc"
    break;

  case 497:
#line 7652 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
        (yyval.attriblist) = (new AttributeList)->Append(std::make_unique<Attribute>("label", (yyvsp[0].str), CHART_POS((yyloc)), CHART_POS((yyloc)).IncStartCol()));
  #endif
    free((yyvsp[0].str));
}
#line 12819 "msc_lang.cc"
    break;

  case 498:
#line 7660 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
        (yyval.attriblist) = ((yyvsp[0].attriblist))->Prepend(std::make_unique<Attribute>("label", (yyvsp[-1].str), CHART_POS((yylsp[-1])), CHART_POS((yylsp[-1])).IncStartCol()));
  #endif
    free((yyvsp[-1].str));
}
#line 12831 "msc_lang.cc"
    break;

  case 499:
#line 7668 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
        (yyval.attriblist) = ((yyvsp[-2].attriblist))->Append(std::make_unique<Attribute>("label", (yyvsp[-1].str), CHART_POS((yylsp[-1])), CHART_POS((yylsp[-1])).IncStartCol()));
        //Merge $3 at the end of $1
        ((yyvsp[-2].attriblist))->splice(((yyvsp[-2].attriblist))->end(), *((yyvsp[0].attriblist)));
        delete ((yyvsp[0].attriblist)); //empty list now
        (yyval.attriblist) = (yyvsp[-2].attriblist);
  #endif
    free((yyvsp[-1].str));
}
#line 12847 "msc_lang.cc"
    break;

  case 500:
#line 7680 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
        (yyval.attriblist) = ((yyvsp[-1].attriblist))->Append(std::make_unique<Attribute>("label", (yyvsp[0].str), CHART_POS((yylsp[0])), CHART_POS((yylsp[0])).IncStartCol()));
  #endif
    free((yyvsp[0].str));
}
#line 12859 "msc_lang.cc"
    break;

  case 502:
#line 7691 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_BRACKET);
    csh.AddCSH((yylsp[0]), COLOR_BRACKET);
	csh.SqBracketPairs.push_back((yyloc));
    csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attriblist) = new AttributeList;
  #endif
}
#line 12874 "msc_lang.cc"
    break;

  case 503:
#line 7702 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_BRACKET);
	csh.AddCSH((yylsp[0]), COLOR_BRACKET);
	csh.SqBracketPairs.push_back((yyloc));
	csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attriblist) = (yyvsp[-1].attriblist);
  #endif
}
#line 12889 "msc_lang.cc"
    break;

  case 504:
#line 7713 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-3]), COLOR_BRACKET);
    csh.AddCSH_Error((yylsp[-1]), "Extra stuff after an attribute list. Maybe missing a comma?");
    csh.AddCSH((yylsp[0]), COLOR_BRACKET);
	csh.SqBracketPairs.push_back((yyloc));
	csh.CheckHintBetween((yylsp[-3]), (yylsp[-2]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attriblist) = (yyvsp[-2].attriblist);
  #endif
}
#line 12905 "msc_lang.cc"
    break;

  case 505:
#line 7725 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_BRACKET);
    csh.AddCSH_Error((yylsp[-1]), "Could not recognize this as an attribute or style name.");
    csh.AddCSH((yylsp[0]), COLOR_BRACKET);
	csh.SqBracketPairs.push_back((yyloc));
	csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attriblist) = new AttributeList;
    chart.Error.Error(CHART_POS_START((yylsp[-1])), "Expecting an attribute or style name. Ignoring all until the closing square bracket (']').");
#endif
}
#line 12922 "msc_lang.cc"
    break;

  case 506:
#line 7738 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_BRACKET);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a square bracket (']').");
    csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME);
	csh.SqBracketPairs.push_back((yyloc));
  #else
    (yyval.attriblist) = (yyvsp[0].attriblist);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing ']'.");
  #endif
}
#line 12938 "msc_lang.cc"
    break;

  case 507:
#line 7750 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddCSH((yylsp[-2]), COLOR_BRACKET);
    csh.AddCSH_Error((yylsp[0]), "Missing a ']'.");
	csh.SqBracketPairs.push_back((yyloc));
	csh.CheckHintBetween((yylsp[-2]), (yylsp[-1]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attriblist) = (yyvsp[-1].attriblist);
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Missing ']'.");
  #endif
}
#line 12954 "msc_lang.cc"
    break;

  case 508:
#line 7762 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_BRACKET);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing a square bracket (']').");
	csh.SqBracketPairs.push_back((yyloc));
    csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attriblist) = new AttributeList;
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing ']'.");
  #endif
}
#line 12970 "msc_lang.cc"
    break;

  case 509:
#line 7774 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_BRACKET);
    csh.AddCSH_Error((yylsp[0]), "Missing a ']'.");
	csh.SqBracketPairs.push_back((yyloc));
    csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attriblist) = new AttributeList;
    chart.Error.Error(CHART_POS_START((yylsp[0])), "Missing ']'.");
  #endif
}
#line 12986 "msc_lang.cc"
    break;

  case 510:
#line 7787 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
  #else
    (yyval.attriblist) = (new AttributeList)->Append((yyvsp[0].attrib));
  #endif
}
#line 12997 "msc_lang.cc"
    break;

  case 511:
#line 7794 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_COMMA);
    csh.CheckHintBetween((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attriblist) = ((yyvsp[-2].attriblist))->Append((yyvsp[0].attrib));
  #endif
}
#line 13010 "msc_lang.cc"
    break;

  case 512:
#line 7803 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_COMMA);
    csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_NAME);
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing attribute or style name.");
  #else
    (yyval.attriblist) = (yyvsp[-1].attriblist);
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Expecting an attribute or style name here.");
  #endif
}
#line 13025 "msc_lang.cc"
    break;

  case 513:
#line 7815 "msc_lang.yy"
{
  //string=string
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if (!(yyvsp[-2].multi_str).had_error) {
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].multi_str).str, COLOR_ATTRNAME);
        if (!(yyvsp[0].multi_str).had_error) {
            csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].multi_str).str, (yyvsp[-2].multi_str).str);
            csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].multi_str).str);
        }
    }
    csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME);
  #else
    if ((yyvsp[-2].multi_str).had_error || (yyvsp[0].multi_str).had_error ||
        (((yyvsp[-2].multi_str).had_param || (yyvsp[0].multi_str).had_param) && chart.SkipContent()))
        (yyval.attrib) = nullptr;
    else
        (yyval.attrib) = new Attribute((yyvsp[-2].multi_str).str, (yyvsp[0].multi_str).str, CHART_POS((yylsp[-2])), CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].multi_str).str);
}
#line 13052 "msc_lang.cc"
    break;

  case 514:
#line 7838 "msc_lang.yy"
{
  //string=r,g,b,a or string=name,a
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if (!(yyvsp[-2].multi_str).had_error) {
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].multi_str).str, COLOR_ATTRNAME);
        csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[0]), (yyvsp[0].str), (yyvsp[-2].multi_str).str);
        csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].multi_str).str);
    }
    csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME);
  #else
    if ((yyvsp[-2].multi_str).had_error || ((yyvsp[-2].multi_str).had_param && chart.SkipContent()))
        (yyval.attrib) = nullptr;
    else
        (yyval.attrib) = new Attribute((yyvsp[-2].multi_str).str, (yyvsp[0].str), CHART_POS((yylsp[-2])), CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].str));
}
#line 13076 "msc_lang.cc"
    break;

  case 515:
#line 7857 "msc_lang.yy"
{
  //string=string
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-2]), COLOR_EQUAL);
    if (!(yyvsp[-3].multi_str).had_error) {
        csh.AddCSH_AttrName((yylsp[-3]), (yyvsp[-3].multi_str).str, COLOR_ATTRNAME);
        csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[-1])+(yylsp[0]), (string("++")+(yyvsp[0].str)).c_str(), (yyvsp[-3].multi_str).str);
        csh.CheckHintBetweenAndAt((yylsp[-2]), (yylsp[-1])+(yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-3].multi_str).str);
    }
    csh.CheckHintAt((yylsp[-3]), EHintSourceType::ATTR_NAME);
  #else
    if ((yyvsp[-3].multi_str).had_error || ((yyvsp[-3].multi_str).had_param && chart.SkipContent()))
        (yyval.attrib) = nullptr;
    else
        (yyval.attrib) = new Attribute((yyvsp[-3].multi_str).str, string("++")+(yyvsp[0].str), CHART_POS((yylsp[-3])), CHART_POS2((yylsp[-1]),(yylsp[0])));
  #endif
    free((yyvsp[-3].multi_str).str);
    free((yyvsp[0].str));
}
#line 13100 "msc_lang.cc"
    break;

  case 516:
#line 7877 "msc_lang.yy"
{
  //string=string
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    if (!(yyvsp[-2].multi_str).had_error) {
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].multi_str).str, COLOR_ATTRNAME);
        csh.AddCSH_AttrValue_CheckAndAddEscapeHint((yylsp[0]), "++", (yyvsp[-2].multi_str).str);
        csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].multi_str).str);
    }
    csh.AddCSH_ErrorAfter((yylsp[0]), "Continue with a color name or definition.");
    csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME);
  #else
    if ((yyvsp[-2].multi_str).had_error || ((yyvsp[-2].multi_str).had_param && chart.SkipContent()))
        (yyval.attrib) = nullptr;
    else
        (yyval.attrib) = new Attribute((yyvsp[-2].multi_str).str, "++", CHART_POS((yylsp[-2])), CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].multi_str).str);
}
#line 13124 "msc_lang.cc"
    break;

  case 517:
#line 7897 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-2].multi_str).had_error) {
        csh.AddCSH_AttrName((yylsp[-2]), (yyvsp[-2].multi_str).str, COLOR_ATTRNAME);
        csh.CheckHintBetweenAndAt((yylsp[-1]), (yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-2].multi_str).str);
    }
    csh.AddCSH((yylsp[-1]), COLOR_EQUAL);
    csh.AddCSH((yylsp[0]), COLOR_ATTRVALUE);
    csh.CheckHintAt((yylsp[-2]), EHintSourceType::ATTR_NAME);
  #else
    if ((yyvsp[-2].multi_str).had_error || ((yyvsp[-2].multi_str).had_param && chart.SkipContent()))
        (yyval.attrib) = nullptr;
    else
        (yyval.attrib) = new Attribute((yyvsp[-2].multi_str).str, (yyvsp[0].str), CHART_POS((yyloc)), CHART_POS((yylsp[0])));
  #endif
    free((yyvsp[-2].multi_str).str);
    free((yyvsp[0].str));
}
#line 13147 "msc_lang.cc"
    break;

  case 518:
#line 7916 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[-1].multi_str).had_error) {
        csh.AddCSH_AttrName((yylsp[-1]), (yyvsp[-1].multi_str).str, COLOR_ATTRNAME);
        csh.CheckHintAfter((yylsp[0]), EHintSourceType::ATTR_VALUE, (yyvsp[-1].multi_str).str);
    }
    csh.AddCSH((yylsp[0]), COLOR_EQUAL);
    csh.CheckHintAt((yylsp[-1]), EHintSourceType::ATTR_NAME);
  #else
    if ((yyvsp[-1].multi_str).had_error || ((yyvsp[-1].multi_str).had_param && chart.SkipContent()))
        (yyval.attrib) = nullptr;
    else
        (yyval.attrib) = new Attribute((yyvsp[-1].multi_str).str, {}, CHART_POS((yyloc)), CHART_POS((yyloc)));
  #endif
    free((yyvsp[-1].multi_str).str);
}
#line 13168 "msc_lang.cc"
    break;

  case 519:
#line 7933 "msc_lang.yy"
{
  //here we accept non alpha strings for "->" and similar style names
  #ifdef C_S_H_IS_COMPILED
    if (!(yyvsp[0].multi_str).had_error)
        csh.AddCSH_StyleOrAttrName((yylsp[0]), (yyvsp[0].multi_str).str);
    csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    if ((yyvsp[0].multi_str).had_error)
        (yyval.attrib) = nullptr;
    else
        (yyval.attrib) = new Attribute((yyvsp[0].multi_str).str, CHART_POS((yyloc)));
  #endif
    free((yyvsp[0].multi_str).str);
}
#line 13187 "msc_lang.cc"
    break;

  case 520:
#line 7949 "msc_lang.yy"
{
  //here we accept non alpha strings for "->" and similar style names
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_StyleOrAttrName((yylsp[0]), "++");
    csh.CheckHintAt((yylsp[0]), EHintSourceType::ATTR_NAME);
  #else
    (yyval.attrib) = new Attribute("++", CHART_POS((yyloc)));
  #endif
}
#line 13201 "msc_lang.cc"
    break;

  case 521:
#line 7960 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.hint_vertical_shapes = false;
  #else
    if (CaseInsensitiveEqual((yyvsp[0].str), "brace")) (yyval.vshape) = Vertical::BRACE;
    else if (CaseInsensitiveEqual((yyvsp[0].str), "bracket")) (yyval.vshape) = Vertical::BRACKET;
    else if (CaseInsensitiveEqual((yyvsp[0].str), "range")) (yyval.vshape) = Vertical::RANGE;
    else if (CaseInsensitiveEqual((yyvsp[0].str), "pointer")) (yyval.vshape) = Vertical::POINTER;
    else {
        (yyval.vshape) = Vertical::ARROW_OR_BOX;
        _ASSERT(0);
    }
  #endif
  free((yyvsp[0].str));
}
#line 13221 "msc_lang.cc"
    break;

  case 522:
#line 7976 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.hint_vertical_shapes = false;
  #else
	(yyval.vshape) = Vertical::ARROW_OR_BOX;
  #endif
  free((yyvsp[0].str));
}
#line 13234 "msc_lang.cc"
    break;

  case 523:
#line 7985 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.hint_vertical_shapes = false;
  #else
	(yyval.vshape) = Vertical::ARROW_OR_BOX;
  #endif
  free((yyvsp[0].str));
}
#line 13247 "msc_lang.cc"
    break;

  case 524:
#line 7998 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
	csh.AddQuotedString((yylsp[0]));
  #endif
  (yyval.str) = (yyvsp[0].str);
}
#line 13258 "msc_lang.cc"
    break;

  case 527:
#line 8007 "msc_lang.yy"
{
	(yyval.str) = (char*)malloc(2);
	((yyval.str))[0] = ShapeElement::act_code[(yyvsp[0].shapecommand)];
	((yyval.str))[1] = 0;
}
#line 13268 "msc_lang.cc"
    break;

  case 577:
#line 8030 "msc_lang.yy"
{
    switch ((yyvsp[0].arcsymbol)) {
    case EArcSymbol::ARC_DOTTED: (yyval.str) = strdup(">"); break;
    case EArcSymbol::ARC_DASHED: (yyval.str) = strdup(">>"); break;
    case EArcSymbol::ARC_SOLID:  (yyval.str) = strdup("->"); break;
    case EArcSymbol::ARC_DOUBLE: (yyval.str) = strdup("=>"); break;
    case EArcSymbol::ARC_DBLDBL: (yyval.str) = strdup("=>>"); break;
    case EArcSymbol::ARC_DOUBLE2:
  #ifdef C_S_H_IS_COMPILED
        if (csh.mscgen_compat == EMscgenCompat::FORCE_MSCGEN)
  #else
        if (chart.mscgen_compat == EMscgenCompat::FORCE_MSCGEN)
  #endif
            (yyval.str) = strdup(":>");
        else
            (yyval.str) = strdup("==>");
        break;
    default: _ASSERT(0);
    }
}
#line 13293 "msc_lang.cc"
    break;

  case 578:
#line 8051 "msc_lang.yy"
{
    switch ((yyvsp[0].arcsymbol)) {
    case EArcSymbol::ARC_DOTTED: (yyval.str) = strdup("<"); break;
    case EArcSymbol::ARC_DASHED: (yyval.str) = strdup("<<"); break;
    case EArcSymbol::ARC_SOLID:  (yyval.str) = strdup("<-"); break;
    case EArcSymbol::ARC_DOUBLE: (yyval.str) = strdup("<="); break;
    case EArcSymbol::ARC_DBLDBL: (yyval.str) = strdup("=>>"); break;
    case EArcSymbol::ARC_DOUBLE2:
  #ifdef C_S_H_IS_COMPILED
        if (csh.mscgen_compat == EMscgenCompat::FORCE_MSCGEN)
  #else
        if (chart.mscgen_compat == EMscgenCompat::FORCE_MSCGEN)
  #endif
            (yyval.str) = strdup("<:");
        else
            (yyval.str) = strdup("<==");
        break;
    default: _ASSERT(0);
    }
}
#line 13318 "msc_lang.cc"
    break;

  case 579:
#line 8073 "msc_lang.yy"
{
    switch ((yyvsp[0].arcsymbol)) {
    case EArcSymbol::ARC_DOTTED: (yyval.str) = strdup("<>"); break;
    case EArcSymbol::ARC_DASHED: (yyval.str) = strdup("<<>>"); break;
    case EArcSymbol::ARC_SOLID:  (yyval.str) = strdup("<->"); break;
    case EArcSymbol::ARC_DOUBLE: (yyval.str) = strdup("<=>"); break;
    case EArcSymbol::ARC_DBLDBL: (yyval.str) = strdup("=>>"); break;
    case EArcSymbol::ARC_DOUBLE2:
  #ifdef C_S_H_IS_COMPILED
        if (csh.mscgen_compat == EMscgenCompat::FORCE_MSCGEN)
  #else
        if (chart.mscgen_compat == EMscgenCompat::FORCE_MSCGEN)
  #endif
            (yyval.str) = strdup("<:>");
        else
            (yyval.str) = strdup("<==>");
        break;
    default: _ASSERT(0);
    }
}
#line 13343 "msc_lang.cc"
    break;

  case 580:
#line 8094 "msc_lang.yy"
{
    //This can only come in mscgen mode
    switch ((yyvsp[0].arcsymbol)) {
    case EArcSymbol::ARC_DOTTED: (yyval.str) = strdup(".."); break;
    case EArcSymbol::ARC_SOLID:  (yyval.str) = strdup("--"); break;
    case EArcSymbol::ARC_DOUBLE: (yyval.str) = strdup("=="); break;
    case EArcSymbol::ARC_DOUBLE2: (yyval.str) = strdup("::"); break;
    default: _ASSERT(0);
    }
}
#line 13358 "msc_lang.cc"
    break;

  case 581:
#line 8105 "msc_lang.yy"
{
    switch ((yyvsp[0].arcsymbol)) {
    case EArcSymbol::DIV_DIVIDER:  (yyval.str) = strdup("---"); break;
    case EArcSymbol::DIV_DISCO:    (yyval.str) = strdup("..."); break;
    case EArcSymbol::DIV_VSPACE:   (yyval.str) = strdup("|||"); break;
    default: _ASSERT(0);
    }
}
#line 13371 "msc_lang.cc"
    break;

  case 582:
#line 8114 "msc_lang.yy"
{
    switch ((yyvsp[0].arcsymbol)) {
    case EArcSymbol::BOX_SOLID:  (yyval.str) = strdup("--"); break;
    case EArcSymbol::BOX_DASHED: (yyval.str) = strdup("++"); break; //will likely not happen due to special handling in TOK_COLORDEF
    case EArcSymbol::BOX_DOTTED: (yyval.str) = strdup(".."); break;
    case EArcSymbol::BOX_DOUBLE: (yyval.str) = strdup("=="); break;
    default: _ASSERT(0);
    }
}
#line 13385 "msc_lang.cc"
    break;

  case 586:
#line 8130 "msc_lang.yy"
{
    (yyval.multi_str).str = nullptr;
    (yyval.multi_str).multi = true;
    (yyval.multi_str).had_param = true;
    (yyval.multi_str).had_error = false;
  #ifdef C_S_H_IS_COMPILED
    if ((yyvsp[0].str)==nullptr || (yyvsp[0].str)[0]!='$' || (yyvsp[0].str)[1]==0)
        csh.AddCSH_Error((yylsp[0]), "Need name after the '$' sign.");
  #else
    if ((yyvsp[0].str)==nullptr || (yyvsp[0].str)[0]!='$' || (yyvsp[0].str)[1]==0) {
        chart.Error.Error(CHART_POS_START((yylsp[0])), "Need name after the '$' sign.");
        (yyval.multi_str).had_error = true;
    } else if (!chart.SkipContent()) {
        //When parsing a procedure we we accept all params
        //as they may be variables defined later
        auto p = chart.GetParameter((yyvsp[0].str));
        if (p==nullptr) {
            chart.Error.Error(CHART_POS_START((yylsp[0])), "Undefined parameter or variable name.");
            (yyval.multi_str).had_error = true;
        } else {
            (yyval.multi_str).str = strdup(StringFormat::PushPosEscapes(p->value.c_str(), CHART_POS_START((yylsp[0]))).c_str());
        }
    }
  #endif
  //avoid returning null
  if ((yyval.multi_str).str==nullptr)
        (yyval.multi_str).str = strdup("");
}
#line 13418 "msc_lang.cc"
    break;

  case 587:
#line 8162 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH_ErrorAfter((yylsp[0]), "Missing string to concatenate after '~'.");
  #else
    chart.Error.Error(CHART_POS_AFTER((yylsp[0])), "Missing string to concatenate after '~'.");
  #endif
    (yyval.multi_str).str = strdup("");
    (yyval.multi_str).multi = true;
    (yyval.multi_str).had_param = false;
    (yyval.multi_str).had_error = true;
}
#line 13434 "msc_lang.cc"
    break;

  case 588:
#line 8174 "msc_lang.yy"
{
    (yyval.multi_str) = (yyvsp[0].multi_str);
}
#line 13442 "msc_lang.cc"
    break;

  case 589:
#line 8179 "msc_lang.yy"
{
    (yyval.multi_str) = multi_segment_string((yyvsp[0].str));
}
#line 13450 "msc_lang.cc"
    break;

  case 591:
#line 8185 "msc_lang.yy"
{
    (yyval.multi_str) = multi_segment_string((yyvsp[0].multi_str));
}
#line 13458 "msc_lang.cc"
    break;

  case 592:
#line 8189 "msc_lang.yy"
{
    (yyval.multi_str).CombineThemToMe((yyvsp[-1].multi_str), (yyvsp[0].multi_str));
}
#line 13466 "msc_lang.cc"
    break;

  case 594:
#line 8195 "msc_lang.yy"
{
    (yyval.multi_str) = multi_segment_string((yyvsp[0].str));
}
#line 13474 "msc_lang.cc"
    break;

  case 595:
#line 8199 "msc_lang.yy"
{
    (yyval.multi_str).CombineThemToMe((yyvsp[-1].str), (yyvsp[0].multi_str));
}
#line 13482 "msc_lang.cc"
    break;

  case 597:
#line 8205 "msc_lang.yy"
{
    (yyval.multi_str) = multi_segment_string((yyvsp[0].str));
}
#line 13490 "msc_lang.cc"
    break;

  case 598:
#line 8209 "msc_lang.yy"
{
    (yyval.multi_str).CombineThemToMe((yyvsp[-1].str), (yyvsp[0].multi_str));
}
#line 13498 "msc_lang.cc"
    break;

  case 599:
#line 8214 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
    csh.PushContext();
    if (csh.CheckHintAfter((yylsp[0]), EHintSourceType::LINE_START)) {
        csh.AddLineBeginToHints();
        csh.hintStatus = HINT_READY;
    }
  #else
    if (YYGET_EXTRA(yyscanner)->open_context_mode == base_parse_parm::EScopeOpenMode::PROC_REPLAY) {
        //Open a scope to replay a procedure. The text of the procedure has
        //already been placed to the lex buffer stack (in fact the '{' already comes
        //from there), and the parameters are in YYEXTRA.
        YYGET_EXTRA(yyscanner)->open_context_mode = base_parse_parm::EScopeOpenMode::NORMAL;
        chart.PushContext(CHART_POS_START((yylsp[0])), EContextParse::REPARSING);
        chart.MyCurrentContext().parameters = std::move(YYGET_EXTRA(yyscanner)->last_procedure_params);
        chart.MyCurrentContext().starts_procedure = true;
        chart.MyCurrentContext().export_colors = YYGET_EXTRA(yyscanner)->last_procedure->export_colors;
        chart.MyCurrentContext().export_styles = YYGET_EXTRA(yyscanner)->last_procedure->export_styles;
        YYGET_EXTRA(yyscanner)->last_procedure = nullptr;
    } else {
        //Just open a regular scope
        chart.PushContext(CHART_POS_START((yylsp[0])));
    }
  #endif
  (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 13530 "msc_lang.cc"
    break;

  case 600:
#line 8243 "msc_lang.yy"
{
  #ifdef C_S_H_IS_COMPILED
    (yyval.arcbase) = nullptr;
    csh.PopContext();
    csh.AddCSH((yylsp[0]), COLOR_BRACE);
  #else
    OptAttr<double> hscale = chart.MyCurrentContext().hscale;
    (yyval.arcbase) = chart.PopContext();
    if (hscale.is_set)
        chart.MyCurrentContext().hscale = hscale;
  #endif
  (yyvsp[0].input_text_ptr); //to silence 'unused parameter' warnings
}
#line 13548 "msc_lang.cc"
    break;


#line 13552 "msc_lang.cc"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, RESULT, yyscanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *, YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (&yylloc, RESULT, yyscanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }

  yyerror_range[1] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, RESULT, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp, yylsp, RESULT, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the lookahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, yyerror_range, 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, RESULT, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, RESULT, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[+*yyssp], yyvsp, yylsp, RESULT, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 8258 "msc_lang.yy"



/* END OF FILE */
