FUNCTION fitfunc, p, x=x, y=y, err=err
  gauss = p[0]*exp(-(x-p[1])^2/(2*p[2]^2))
  return, (y - gauss)/err
END

PRO test_mpfit
  x = findgen(101)
  y = 25.*exp(-(x-32.)^2/(2*5.^2))+2.*randomn(0,101)
  err = 0.1*y
  start_params = [10.,45.,10.]
  functargs = {x:x, y:y, err:err}
  params = mpfit("fitfunc",start_params,functargs=functargs)
  ref = [28.2524, 31.9683, -4.26773]
  print, params, ref
  for i = 0, 2 do $
     if params[i] lt ref[i]-.5 || params[i] gt ref[i]+.5 then exit, status=1
  exit, status=0
END
