//
// MonoLegacyTlsProvider.cs
//
// Author:
//       Martin Baulig <martin.baulig@xamarin.com>
//
// Copyright (c) 2015 Xamarin, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
#if SECURITY_DEP
#if MONO_SECURITY_ALIAS
extern alias MonoSecurity;
#endif

using XHttpWebRequest = System.Net.HttpWebRequest;
using XSslProtocols = System.Security.Authentication.SslProtocols;
using XX509CertificateCollection = System.Security.Cryptography.X509Certificates.X509CertificateCollection;

#if MONO_SECURITY_ALIAS
using MonoSecurity::Mono.Security.Interface;
#else
using Mono.Security.Interface;
#endif

using System;
using System.IO;
using System.Net;
using System.Net.Security;
using System.Security.Cryptography.X509Certificates;

namespace Mono.Net.Security.Private
{
	/*
	 * Strictly private - do not use outside the Mono.Net.Security directory.
	 */
	class MonoLegacyTlsProvider : MonoTlsProviderImpl
	{
		static readonly Guid id = new Guid ("809e77d5-56cc-4da8-b9f0-45e65ba9cceb");

		public override Guid ID {
			get { return id; }
		}

		public override string Name {
			get { return "legacy"; }
		}

		public MonoTlsProvider Provider {
			get { return this; }
		}

		public override bool SupportsSslStream {
			get { return true; }
		}

		public override bool SupportsConnectionInfo {
			get { return false; }
		}

		public override bool SupportsMonoExtensions {
			get { return false; }
		}

		internal override bool SupportsTlsContext {
			get { return false; }
		}

		public override XSslProtocols SupportedProtocols {
			get { return XSslProtocols.Ssl3 | XSslProtocols.Tls; }
		}

		protected override IMonoSslStream CreateSslStreamImpl (
			Stream innerStream, bool leaveInnerStreamOpen,
			MonoTlsSettings settings)
		{
			return new LegacySslStream (innerStream, leaveInnerStreamOpen, this, settings);
		}

		protected override IMonoTlsContext CreateTlsContextImpl (
			string hostname, bool serverMode, TlsProtocols protocolFlags,
			X509Certificate serverCertificate, X509CertificateCollection clientCertificates,
			bool remoteCertRequired, MonoEncryptionPolicy encryptionPolicy,
			MonoTlsSettings settings)
		{
			throw new NotSupportedException ();
		}
	}
}
#endif

