*DECK DBESY1
      DOUBLE PRECISION FUNCTION DBESY1 (X)
C***BEGIN PROLOGUE  DBESY1
C***PURPOSE  Compute the Bessel function of the second kind of order
C            one.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C10A1
C***TYPE      DOUBLE PRECISION (BESY1-S, DBESY1-D)
C***KEYWORDS  BESSEL FUNCTION, FNLIB, ORDER ONE, SECOND KIND,
C             SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C DBESY1(X) calculates the double precision Bessel function of the
C second kind of order for double precision argument X.
C
C Series for BY1        on the interval  0.          to  1.60000E+01
C                                        with weighted error   8.65E-33
C                                         log weighted error  32.06
C                               significant figures required  32.17
C                                    decimal places required  32.71
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, D9B1MP, DBESJ1, DCSEVL, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C***END PROLOGUE  DBESY1
      DOUBLE PRECISION X, BY1CS(20), AMPL, THETA, TWODPI, XMIN, XSML,
     1  Y, D1MACH, DCSEVL, DBESJ1
      LOGICAL FIRST
      SAVE BY1CS, TWODPI, NTY1, XMIN, XSML, FIRST
      DATA BY1CS(  1) / +.3208047100 6119086293 2352018628 015 D-1    /
      DATA BY1CS(  2) / +.1262707897 4335004495 3431725999 727 D+1    /
      DATA BY1CS(  3) / +.6499961899 9231750009 7490637314 144 D-2    /
      DATA BY1CS(  4) / -.8936164528 8605041165 3144160009 712 D-1    /
      DATA BY1CS(  5) / +.1325088122 1757095451 2375510370 043 D-1    /
      DATA BY1CS(  6) / -.8979059119 6483523775 3039508298 105 D-3    /
      DATA BY1CS(  7) / +.3647361487 9583067824 2287368165 349 D-4    /
      DATA BY1CS(  8) / -.1001374381 6660005554 9075523845 295 D-5    /
      DATA BY1CS(  9) / +.1994539657 3901739703 1159372421 243 D-7    /
      DATA BY1CS( 10) / -.3023065601 8033816728 4799332520 743 D-9    /
      DATA BY1CS( 11) / +.3609878156 9478119611 6252914242 474 D-11   /
      DATA BY1CS( 12) / -.3487488297 2875824241 4552947409 066 D-13   /
      DATA BY1CS( 13) / +.2783878971 5591766581 3507698517 333 D-15   /
      DATA BY1CS( 14) / -.1867870968 6194876876 6825352533 333 D-17   /
      DATA BY1CS( 15) / +.1068531533 9116825975 7070336000 000 D-19   /
      DATA BY1CS( 16) / -.5274721956 6844822894 3872000000 000 D-22   /
      DATA BY1CS( 17) / +.2270199403 1556641437 0133333333 333 D-24   /
      DATA BY1CS( 18) / -.8595390353 9452310869 3333333333 333 D-27   /
      DATA BY1CS( 19) / +.2885404379 8337945600 0000000000 000 D-29   /
      DATA BY1CS( 20) / -.8647541138 9371733333 3333333333 333 D-32   /
      DATA TWODPI / 0.6366197723 6758134307 5535053490 057 D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  DBESY1
      IF (FIRST) THEN
         NTY1 = INITDS (BY1CS, 20, 0.1*REAL(D1MACH(3)))
C
         XMIN = 1.571D0 * EXP (MAX(LOG(D1MACH(1)), -LOG(D1MACH(2))) +
     1     0.01D0)
         XSML = SQRT(4.0D0*D1MACH(3))
      ENDIF
      FIRST = .FALSE.
C
      IF (X .LE. 0.D0) CALL XERMSG ('SLATEC', 'DBESY1',
     +   'X IS ZERO OR NEGATIVE', 1, 2)
      IF (X.GT.4.0D0) GO TO 20
C
      IF (X .LT. XMIN) CALL XERMSG ('SLATEC', 'DBESY1',
     +   'X SO SMALL Y1 OVERFLOWS', 3, 2)
      Y = 0.D0
      IF (X.GT.XSML) Y = X*X
      DBESY1 = TWODPI * LOG(0.5D0*X)*DBESJ1(X) + (0.5D0 +
     1  DCSEVL (.125D0*Y-1.D0, BY1CS, NTY1))/X
      RETURN
C
 20   CALL D9B1MP (X, AMPL, THETA)
      DBESY1 = AMPL * SIN(THETA)
      RETURN
C
      END
