/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl;

import java.io.IOException;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.postgresql.PGProperty;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.ssl.jdbc4.LibPQFactory;
import org.postgresql.util.GT;
import org.postgresql.util.ObjectFactory;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class MakeSSL
extends ObjectFactory {
    public static void convert(PGStream stream, Properties info, Logger logger) throws PSQLException, IOException {
        SSLSocket newConnection;
        SSLSocketFactory factory;
        logger.debug("converting regular socket connection to ssl");
        String sslmode = PGProperty.SSL_MODE.get(info);
        String classname = PGProperty.SSL_FACTORY.get(info);
        if (classname == null) {
            factory = sslmode != null ? new LibPQFactory(info) : (SSLSocketFactory)SSLSocketFactory.getDefault();
        } else {
            try {
                factory = (SSLSocketFactory)MakeSSL.instantiate(classname, info, true, PGProperty.SSL_FACTORY_ARG.get(info));
            }
            catch (Exception e2) {
                throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e2);
            }
        }
        try {
            newConnection = (SSLSocket)factory.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
            newConnection.startHandshake();
        }
        catch (IOException ex) {
            if (factory instanceof LibPQFactory) {
                ((LibPQFactory)factory).throwKeyManagerException();
            }
            throw new PSQLException(GT.tr("SSL error: {0}", ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
        String sslhostnameverifier = PGProperty.SSL_HOSTNAME_VERIFIER.get(info);
        if (sslhostnameverifier != null) {
            HostnameVerifier hvn;
            try {
                hvn = (HostnameVerifier)MakeSSL.instantiate(sslhostnameverifier, info, false, null);
            }
            catch (Exception e3) {
                throw new PSQLException(GT.tr("The HostnameVerifier class provided {0} could not be instantiated.", sslhostnameverifier), PSQLState.CONNECTION_FAILURE, (Throwable)e3);
            }
            if (!hvn.verify(stream.getHostSpec().getHost(), newConnection.getSession())) {
                throw new PSQLException(GT.tr("The hostname {0} could not be verified by hostnameverifier {1}.", new Object[]{stream.getHostSpec().getHost(), sslhostnameverifier}), PSQLState.CONNECTION_FAILURE);
            }
        } else if ("verify-full".equals(sslmode) && factory instanceof LibPQFactory && !((LibPQFactory)factory).verify(stream.getHostSpec().getHost(), newConnection.getSession())) {
            throw new PSQLException(GT.tr("The hostname {0} could not be verified.", stream.getHostSpec().getHost()), PSQLState.CONNECTION_FAILURE);
        }
        stream.changeSocket(newConnection);
    }
}

