
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file OdaGeoDecoderAttributes.h
    \\brief Definition of OdaGeoDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "OdaGeoDecoderAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

OdaGeoDecoderAttributes::OdaGeoDecoderAttributes():
	path_(ParameterManager::getString("odb_filename")),
	latitude_(ParameterManager::getString("odb_latitude_variable")),
	longitude_(ParameterManager::getString("odb_longitude_variable")),
	value_(ParameterManager::getString("odb_value_variable")),
	y_(ParameterManager::getString("odb_y_component_variable")),
	x_(ParameterManager::getString("odb_x_component_variable")),
	nb_rows_(ParameterManager::getInt("odb_nb_rows")),
	title_(ParameterManager::getString("odb_user_title")),
	unit_(ParameterManager::getString("odb_coordinates_unit"))
	,
	odb_binning_(MagTranslator<string, BinningObject>().magics("odb_binning"))
	
{
}


OdaGeoDecoderAttributes::~OdaGeoDecoderAttributes()
{

}


void OdaGeoDecoderAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "odb";
	
	setAttribute(prefix, "odb_filename", path_, params);
	setAttribute(prefix, "odb_latitude_variable", latitude_, params);
	setAttribute(prefix, "odb_longitude_variable", longitude_, params);
	setAttribute(prefix, "odb_value_variable", value_, params);
	setAttribute(prefix, "odb_y_component_variable", y_, params);
	setAttribute(prefix, "odb_x_component_variable", x_, params);
	setAttribute(prefix, "odb_nb_rows", nb_rows_, params);
	setAttribute(prefix, "odb_user_title", title_, params);
	setAttribute(prefix, "odb_coordinates_unit", unit_, params);
	
	setMember(prefix, "odb_binning", odb_binning_, params);
	
}

void OdaGeoDecoderAttributes::copy(const OdaGeoDecoderAttributes& other)
{
	path_ = other.path_;
	latitude_ = other.latitude_;
	longitude_ = other.longitude_;
	value_ = other.value_;
	y_ = other.y_;
	x_ = other.x_;
	nb_rows_ = other.nb_rows_;
	title_ = other.title_;
	unit_ = other.unit_;
	odb_binning_ = unique_ptr<BinningObject>(other.odb_binning_->clone());
	
}


bool OdaGeoDecoderAttributes::accept(const string& node)
{

	if ( magCompare(node, "odb")  )
		return true;
	if ( acceptNode(node, odb_binning_) )
		return true;
	
	return false;
}

void OdaGeoDecoderAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "odb")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), odb_binning_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), odb_binning_, *elt);
		
	}
}

void OdaGeoDecoderAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " path = " <<  path_;
	out << " latitude = " <<  latitude_;
	out << " longitude = " <<  longitude_;
	out << " value = " <<  value_;
	out << " y = " <<  y_;
	out << " x = " <<  x_;
	out << " nb_rows = " <<  nb_rows_;
	out << " title = " <<  title_;
	out << " unit = " <<  unit_;
	out << " odb_binning = " <<  *odb_binning_;
	
	out << "]" << "\n";
}

void OdaGeoDecoderAttributes::toxml(ostream& out)  const
{
	out <<  "\"odb\"";
	out << ", \"odb_filename\":";
	niceprint(out,path_);
	out << ", \"odb_latitude_variable\":";
	niceprint(out,latitude_);
	out << ", \"odb_longitude_variable\":";
	niceprint(out,longitude_);
	out << ", \"odb_value_variable\":";
	niceprint(out,value_);
	out << ", \"odb_y_component_variable\":";
	niceprint(out,y_);
	out << ", \"odb_x_component_variable\":";
	niceprint(out,x_);
	out << ", \"odb_nb_rows\":";
	niceprint(out,nb_rows_);
	out << ", \"odb_user_title\":";
	niceprint(out,title_);
	out << ", \"odb_coordinates_unit\":";
	niceprint(out,unit_);
	out << ", \"odb_binning\":";
	odb_binning_->toxml(out);
	
}

static MagicsParameter<string> odb_filename("odb_filename", "");
static MagicsParameter<string> odb_latitude_variable("odb_latitude_variable", "lat");
static MagicsParameter<string> odb_longitude_variable("odb_longitude_variable", "lon");
static MagicsParameter<string> odb_value_variable("odb_value_variable", "");
static MagicsParameter<string> odb_y_component_variable("odb_y_component_variable", "");
static MagicsParameter<string> odb_x_component_variable("odb_x_component_variable", "");
static MagicsParameter<int> odb_nb_rows("odb_nb_rows", -1);
static MagicsParameter<string> odb_user_title("odb_user_title", "");
static MagicsParameter<string> odb_coordinates_unit("odb_coordinates_unit", "degrees");
static MagicsParameter<string> odb_binning("odb_binning", "off");
#include "BinningObject.h"
static SimpleObjectMaker<BinningObject , BinningObject> binning_BinningObject("binning");
static SimpleObjectMaker<BinningObject , BinningObject> on_BinningObject("on");
static SimpleObjectMaker<NoBinningObject , BinningObject> nobinning_NoBinningObject("nobinning");
static SimpleObjectMaker<NoBinningObject , BinningObject> off_NoBinningObject("off");
