# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20241212130805;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            3|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )|
            6[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[25-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '
          (?:
            60\\d|
            [7-9]0[1-9]
          )\\d{7}
        ',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"81583", "Gifu\,\ Gifu",
"8126176", "Omachi\,\ Nagano",
"818554", "Hamada\,\ Shimane",
"812588", "Nagaoka\,\ Niigata",
"8186698", "Kurashiki\,\ Okayama",
"818365", "Ube\,\ Yamaguchi",
"818955", "Uwajima\,\ Ehime",
"818587", "Koge\,\ Tottori",
"811354", "Yoichi\,\ Hokkaido",
"81559", "Numazu\,\ Shizuoka",
"815755", "Sekigahara\,\ Gifu",
"81863", "Tamano\,\ Okayama",
"81727", "Ikeda\,\ Osaka",
"815367", "Shitara\,\ Aichi",
"815585", "Shimoda\,\ Shizuoka",
"815984", "Matsusaka\,\ Mie",
"819965", "Satsumasendai\,\ Kagoshima",
"811986", "Tono\,\ Iwate",
"81857", "Tottori\,\ Tottori",
"819743", "Mie\,\ Oita",
"81924", "Fukuoka\,\ Fukuoka",
"81432", "Chiba\,\ Chiba",
"817993", "Sumoto\,\ Hyogo",
"8125489", "Tsugawa\,\ Niigata",
"815995", "Ago\,\ Mie",
"818872", "Muroto\,\ Kochi",
"811454", "Mukawa\,\ Hokkaido",
"815977", "Kumano\,\ Mie",
"81196", "Morioka\,\ Iwate",
"812230", "Sendai\,\ Miyagi",
"817704", "Tsuruga\,\ Fukui",
"8199331", "Kagoshima\,\ Kagoshima",
"818692", "Oku\,\ Okayama",
"812998", "Itako\,\ Ibaraki",
"81725", "Izumi\,\ Osaka",
"81878", "Takamatsu\,\ Kagawa",
"8126174", "Omachi\,\ Nagano",
"818240", "Higashi\-ku\,\ Hiroshima",
"81956", "Sasebo\,\ Nagasaki",
"81191", "Ichinoseki\,\ Iwate",
"818975", "Niihama\,\ Ehime",
"811374", "Mori\,\ Hokkaido",
"815584", "Shimoda\,\ Shizuoka",
"811586", "Nakayubetsu\,\ Hokkaido",
"819964", "Satsumasendai\,\ Kagoshima",
"815985", "Matsusaka\,\ Mie",
"81734", "Wakayama\,\ Wakayama",
"811862", "Kazuno\,\ Akita",
"81577", "Takayama\,\ Gifu",
"8161", "Osaka\,\ Osaka",
"81937", "Kitakyushu\,\ Fukuoka",
"815566", "Minobu\,\ Yamanashi",
"818682", "Tsuyama\,\ Okayama",
"8198297", "Hyuga\,\ Miyazaki",
"811564", "Kamishihoro\,\ Hokkaido",
"818555", "Gotsu\,\ Shimane",
"818293", "Hatsukaichi\,\ Hiroshima",
"818364", "Ube\,\ Yamaguchi",
"818954", "Uwajima\,\ Ehime",
"8112391", "Yubari\,\ Hokkaido",
"815754", "Sekigahara\,\ Gifu",
"811756", "Noheji\,\ Aomori",
"81124", "Ashibetsu\,\ Hokkaido",
"815959", "Kameyama\,\ Mie",
"817705", "Obama\,\ Fukui",
"815979", "Kumano\,\ Mie",
"819596", "Fukue\,\ Nagasaki",
"81744", "Yamatotakada\,\ Nara",
"811397", "Okushiri\,\ Hokkaido",
"812838", "Sano\,\ Tochigi",
"81935", "Kitakyushu\,\ Fukuoka",
"811375", "Yakumo\,\ Hokkaido",
"818974", "Niihama\,\ Ehime",
"815994", "Ago\,\ Mie",
"81947", "Tagawa\,\ Fukuoka",
"814701", "Kamogawa\,\ Chiba",
"817940", "Kakogawa\,\ Hyogo",
"811455", "Mukawa\,\ Hokkaido",
"818464", "Takehara\,\ Hiroshima",
"81486", "Urawa\,\ Saitama",
"812742", "Fujioka\,\ Gunma",
"8112392", "Yubari\,\ Hokkaido",
"81533", "Toyohashi\,\ Aichi",
"8186997", "Seto\,\ Okayama",
"818680", "Okayama\,\ Okayama",
"81992", "Kagoshima\,\ Kagoshima",
"812573", "Kashiwazaki\,\ Niigata",
"81463", "Hiratsuka\,\ Kanagawa",
"811854", "Oga\,\ Akita",
"819952", "Okuchi\,\ Kagoshima",
"819684", "Yamaga\,\ Kumamoto",
"812618", "Omachi\,\ Nagano",
"818656", "Kasaoka\,\ Okayama",
"814757", "Togane\,\ Chiba",
"81250", "Niitsu\,\ Niigata",
"81832", "Shimonoseki\,\ Yamaguchi",
"815762", "Gero\,\ Gifu",
"818667", "Ibara\,\ Okayama",
"81482", "Kawaguchi\,\ Saitama",
"819233", "Maebaru\,\ Fukuoka",
"819666", "Minamata\,\ Kumamoto",
"811552", "Obihiro\,\ Hokkaido",
"818372", "Nagato\,\ Yamaguchi",
"81543", "Shizuoka\,\ Shizuoka",
"811541", "Teshikaga\,\ Hokkaido",
"814795", "Choshi\,\ Chiba",
"811735", "Goshogawara\,\ Aomori",
"818896", "Susaki\,\ Kochi",
"817942", "Kakogawa\,\ Hyogo",
"817613", "Komatsu\,\ Ishikawa",
"812783", "Numata\,\ Gunma",
"814777", "Funabashi\,\ Chiba",
"811336", "Ishikari\,\ Hokkaido",
"819734", "Hita\,\ Oita",
"814240", "Kokubunji\,\ Tokyo",
"818676", "Kuse\,\ Okayama",
"811632", "Teshio\,\ Hokkaido",
"811937", "Miyako\,\ Iwate",
"814283", "Ome\,\ Tokyo",
"81478", "Sawara\,\ Chiba",
"811524", "Abashiri\,\ Hokkaido",
"811874", "Kakunodate\,\ Akita",
"812546", "Murakami\,\ Niigata",
"815392", "Hamamatsu\,\ Shizuoka",
"812553", "Joetsu\,\ Niigata",
"817368", "Iwade\,\ Wakayama",
"819803", "Nago\,\ Okinawa",
"812793", "Shibukawa\,\ Gunma",
"81969", "Amakusa\,\ Kumamoto",
"81192", "Ofunato\,\ Iwate",
"819782", "Bungotakada\,\ Oita",
"811952", "Ninohe\,\ Iwate",
"811362", "Kutchan\,\ Hokkaido",
"818562", "Masuda\,\ Shimane",
"81952", "Saga\,\ Saga",
"81987", "Nichinan\,\ Miyazaki",
"818669", "Soja\,\ Okayama",
"811855", "Noshiro\,\ Akita",
"8125485", "Tsugawa\,\ Niigata",
"818512", "Nishigo\,\ Fukushima",
"812413", "Kitakata\,\ Fukushima",
"819685", "Tamana\,\ Kumamoto",
"811233", "Chitose\,\ Hokkaido",
"819552", "Imari\,\ Saga",
"819727", "Usuki\,\ Oita",
"819735", "Hita\,\ Oita",
"817468", "Kamikitayama\,\ Nara",
"818690", "Okayama\,\ Okayama",
"8112390", "Yubari\,\ Hokkaido",
"81561", "Seto\,\ Aichi",
"819822", "Nobeoka\,\ Miyazaki",
"819572", "Isahaya\,\ Nagasaki",
"81985", "Miyazaki\,\ Miyazaki",
"811462", "Urakawa\,\ Hokkaido",
"818242", "Higashi\-ku\,\ Hiroshima",
"811537", "Nakashibetsu\,\ Hokkaido",
"819948", "Shibushi\,\ Kagoshima",
"8144", "Kawasaki\,\ Kanagawa",
"811875", "Kakunodate\,\ Akita",
"811525", "Abashiri\,\ Hokkaido",
"815736", "Nakatsugawa\,\ Gifu",
"81566", "Kariya\,\ Aichi",
"811972", "Mizusawa\,\ Iwate",
"811734", "Goshogawara\,\ Aomori",
"814794", "Choshi\,\ Chiba",
"811939", "Miyako\,\ Iwate",
"81495", "Honjo\,\ Saitama",
"81436", "Ichihara\,\ Chiba",
"811548", "Teshikaga\,\ Hokkaido",
"819937", "Kaseda\,\ Kagoshima",
"81886", "Tokushima\,\ Tokushima",
"819679", "Takamori\,\ Kumamoto",
"812232", "Iwanuma\,\ Miyagi",
"81822", "Hiroshima\,\ Hiroshima",
"812477", "Miharu\,\ Fukushima",
"818478", "Tojo\,\ Hiroshima",
"812612", "Omachi\,\ Nagano",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"81984", "Kobayashi\,\ Miyazaki",
"812917", "Mito\,\ Ibaraki",
"8169", "Osaka\,\ Osaka",
"815768", "Gero\,\ Gifu",
"817685", "Wajima\,\ Ishikawa",
"815733", "Ena\,\ Gifu",
"81494", "Chichibu\,\ Saitama",
"812384", "Yonezawa\,\ Yamagata",
"811558", "Hiroo\,\ Hokkaido",
"812967", "Kasama\,\ Ibaraki",
"812796", "Shibukawa\,\ Gunma",
"817948", "Miki\,\ Hyogo",
"812377", "Sagae\,\ Yamagata",
"818807", "Sukumo\,\ Kochi",
"818378", "Shimonoseki\,\ Yamaguchi",
"811647", "Haboro\,\ Hokkaido",
"811942", "Iwaizumi\,\ Iwate",
"8112393", "Yubari\,\ Hokkaido",
"817735", "Fukuchiyama\,\ Kyoto",
"819433", "Yame\,\ Fukuoka",
"819978", "Tokunoshima\,\ Kagoshima",
"815398", "Hamamatsu\,\ Shizuoka",
"812484", "Shirakawa\,\ Fukushima",
"8128798", "Otawara\,\ Tochigi",
"819542", "Takeo\,\ Saga",
"811236", "Chitose\,\ Hokkaido",
"812830", "Utsunomiya\,\ Tochigi",
"812416", "Tajima\,\ Fukushima",
"818893", "Sakawa\,\ Kochi",
"817684", "Wajima\,\ Ishikawa",
"819788", "Kunisaki\,\ Oita",
"812786", "Numata\,\ Gunma",
"817952", "Nishiwaki\,\ Hyogo",
"817616", "Komatsu\,\ Ishikawa",
"8186994", "Seto\,\ Okayama",
"81184", "Yurihonjo\,\ Akita",
"812385", "Yonezawa\,\ Yamagata",
"81792", "Himeji\,\ Hyogo",
"818568", "Tsuwano\,\ Shimane",
"811333", "Tobetsu\,\ Hokkaido",
"811958", "Iwate\,\ Iwate",
"8111", "Sapporo\,\ Hokkaido",
"812580", "Tokamachi\,\ Niigata",
"819558", "Karatsu\,\ Saga",
"8165", "Osaka\,\ Osaka",
"814286", "Sagamihara\,\ Kanagawa",
"8153965", "Hamamatsu\,\ Shizuoka",
"812556", "Itoigawa\,\ Niigata",
"812543", "Shibata\,\ Niigata",
"819828", "Takachiho\,\ Miyazaki",
"819578", "Shimabara\,\ Nagasaki",
"81426", "Hachioji\,\ Tokyo",
"812576", "Tokamachi\,\ Niigata",
"812485", "Shirakawa\,\ Fukushima",
"812247", "Ogawara\,\ Miyagi",
"818248", "Shobara\,\ Hiroshima",
"81249", "Koriyama\,\ Fukushima",
"8186996", "Seto\,\ Okayama",
"811978", "Kitakami\,\ Iwate",
"81276", "Ota\,\ Gunma",
"812238", "Sendai\,\ Miyagi",
"817734", "Fukuchiyama\,\ Kyoto",
"817677", "Nanao\,\ Ishikawa",
"814700", "Kamogawa\,\ Chiba",
"811542", "Kushiro\,\ Hokkaido",
"819663", "Hitoyoshi\,\ Kumamoto",
"812655", "Iida\,\ Nagano",
"812582", "Nagaoka\,\ Niigata",
"819593", "Oseto\,\ Nagasaki",
"817964", "Toyooka\,\ Hyogo",
"817354", "Shingu\,\ Fukuoka",
"81934", "Kitakyushu\,\ Fukuoka",
"8198294", "Nobeoka\,\ Miyazaki",
"81272", "Maebashi\,\ Gunma",
"817950", "Sanda\,\ Hyogo",
"81737", "Yuasa\,\ Wakayama",
"812857", "Mooka\,\ Tochigi",
"817914", "Aioi\,\ Hyogo",
"8198296", "Hyuga\,\ Miyazaki",
"812934", "Takahagi\,\ Ibaraki",
"811583", "Monbetsu\,\ Hokkaido",
"818383", "Hagi\,\ Yamaguchi",
"812877", "Kuroiso\,\ Tochigi",
"8153969", "Hamamatsu\,\ Shizuoka",
"817454", "Yamatotakada\,\ Nara",
"81944", "Setaka\,\ Fukuoka",
"817487", "Minakuchi\,\ Shiga",
"814702", "Tateyama\,\ Chiba",
"812895", "Utsunomiya\,\ Tochigi",
"818545", "Kisuki\,\ Shimane",
"812697", "Iiyama\,\ Nagano",
"818296", "Hiroshima\,\ Hiroshima",
"818698", "Bizen\,\ Okayama",
"812992", "Ishioka\,\ Ibaraki",
"8153976", "Hamamatsu\,\ Shizuoka",
"81288", "Imabari\,\ Ehime",
"818944", "Yawatahama\,\ Ehime",
"811753", "Mutsu\,\ Aomori",
"819940", "Shibushi\,\ Kagoshima",
"812675", "Saku\,\ Nagano",
"81125", "Takikawa\,\ Hokkaido",
"8188098", "Tosashimizu\,\ Kochi",
"815744", "Minokamo\,\ Gifu",
"8199345", "Kagoshima\,\ Kagoshima",
"817475", "Shimonoseki\,\ Yamaguchi",
"81927", "Fukuoka\,\ Fukuoka",
"817497", "Nagahama\,\ Shiga",
"8175", "Kyoto\,\ Kyoto",
"81134", "Otaru\,\ Hokkaido",
"81460", "Odawara\,\ Kanagawa",
"817915", "Aioi\,\ Hyogo",
"811868", "Takanosu\,\ Akita",
"812654", "Iida\,\ Nagano",
"812859", "Oyama\,\ Tochigi",
"817717", "Sonobe\,\ Kyoto",
"818688", "Mimasaka\,\ Okayama",
"81253", "Niigata\,\ Niigata",
"817965", "Toyooka\,\ Hyogo",
"817355", "Shingu\,\ Fukuoka",
"818493", "Onomichi\,\ Hiroshima",
"818544", "Kisuki\,\ Shimane",
"818945", "Yawatahama\,\ Ehime",
"81144", "Tomakomai\,\ Hokkaido",
"812674", "Komoro\,\ Nagano",
"812879", "Nasukarasuyama\,\ Tochigi",
"815745", "Minokamo\,\ Gifu",
"812832", "Sano\,\ Tochigi",
"812935", "Mito\,\ Ibaraki",
"811983", "Hanamaki\,\ Iwate",
"817455", "Yamatotakada\,\ Nara",
"818842", "Anan\,\ Tokushima",
"81925", "Fukuoka\,\ Fukuoka",
"819746", "Taketa\,\ Oita",
"812894", "Utsunomiya\,\ Tochigi",
"817996", "Tsuna\,\ Hyogo",
"812748", "Tomioka\,\ Gunma",
"812677", "Saku\,\ Nagano",
"8182943", "Hiroshima\,\ Hiroshima",
"818678", "Niimi\,\ Okayama",
"81776", "Fukui\,\ Fukui",
"812939", "Mito\,\ Ibaraki",
"817238", "Neyagawa\,\ Osaka",
"818547", "Kakeya\,\ Shimane",
"812695", "Nakano\,\ Nagano",
"812412", "Kitakata\,\ Fukushima",
"8198290", "Nobeoka\,\ Miyazaki",
"811232", "Chitose\,\ Hokkaido",
"819553", "Imari\,\ Saga",
"819546", "Kashima\,\ Saga",
"81268", "Ueda\,\ Nagano",
"818949", "Uwajima\,\ Ehime",
"819802", "Minamidaito\,\ Okinawa",
"812792", "Shibukawa\,\ Gunma",
"812897", "Kanuma\,\ Tochigi",
"817485", "Yokaichi\,\ Shiga",
"81928", "Fukuoka\,\ Fukuoka",
"819783", "Bungotakada\,\ Oita",
"811953", "Ninohe\,\ Iwate",
"811363", "Kutchan\,\ Hokkaido",
"8153970", "Hamamatsu\,\ Shizuoka",
"811946", "Kuji\,\ Iwate",
"812875", "Otawara\,\ Tochigi",
"818563", "Masuda\,\ Shimane",
"811973", "Mizusawa\,\ Iwate",
"817494", "Hikone\,\ Shiga",
"81950", "Hirado\,\ Nagasaki",
"812855", "Oyama\,\ Tochigi",
"819668", "Minamata\,\ Kumamoto",
"81273", "Takasaki\,\ Gunma",
"817969", "Hamasaka\,\ Hyogo",
"812233", "Iwanuma\,\ Miyagi",
"81739", "Tanabe\,\ Wakayama",
"81423", "Kokubunji\,\ Tokyo",
"81292", "Mito\,\ Ibaraki",
"81594", "Kuwana\,\ Mie",
"819823", "Nobeoka\,\ Miyazaki",
"819573", "Isahaya\,\ Nagasaki",
"812657", "Ina\,\ Nagano",
"8186552", "Kurashiki\,\ Okayama",
"818243", "Higashi\-ku\,\ Hiroshima",
"811463", "Urakawa\,\ Hokkaido",
"812616", "Omachi\,\ Nagano",
"817714", "Kameoka\,\ Kyoto",
"817457", "Yamatotakada\,\ Nara",
"817484", "Yokaichi\,\ Shiga",
"8186992", "Bizen\,\ Okayama",
"815738", "Nakatsugawa\,\ Gifu",
"815763", "Gero\,\ Gifu",
"81738", "Gobo\,\ Wakayama",
"812937", "Mito\,\ Ibaraki",
"811553", "Obihiro\,\ Hokkaido",
"819232", "Maebaru\,\ Fukuoka",
"812874", "Otawara\,\ Tochigi",
"811546", "Kushiro\,\ Hokkaido",
"812679", "Saku\,\ Nagano",
"818290", "Hiroshima\,\ Hiroshima",
"817466", "Totsukawa\,\ Nara",
"812572", "Kashiwazaki\,\ Niigata",
"812694", "Nakano\,\ Nagano",
"812899", "Kanuma\,\ Tochigi",
"819953", "Okuchi\,\ Kagoshima",
"819946", "Kanoya\,\ Kagoshima",
"818947", "Uwajima\,\ Ehime",
"817357", "Kushimoto\,\ Wakayama",
"81252", "Niigata\,\ Niigata",
"8126173", "Omachi\,\ Nagano",
"81554", "Otsuki\,\ Yamanashi",
"814282", "Ome\,\ Tokyo",
"817715", "Kameoka\,\ Kyoto",
"815393", "Hamamatsu\,\ Shizuoka",
"812552", "Joetsu\,\ Niigata",
"81480", "Kuki\,\ Saitama",
"817495", "Nagahama\,\ Shiga",
"818373", "Nagato\,\ Yamaguchi",
"8147955", "Yokaichiba\,\ Chiba",
"81929", "Fukuoka\,\ Fukuoka",
"817943", "Kakogawa\,\ Hyogo",
"812854", "Oyama\,\ Tochigi",
"812659", "Ina\,\ Nagano",
"817956", "Sanda\,\ Hyogo",
"817612", "Komatsu\,\ Ishikawa",
"817366", "Iwade\,\ Wakayama",
"812782", "Numata\,\ Gunma",
"819438", "Tanushimaru\,\ Fukuoka",
"8152", "Nagoya\,\ Aichi",
"812996", "Itako\,\ Ibaraki",
"81765", "Uozu\,\ Toyama",
"818683", "Tsuyama\,\ Okayama",
"8153972", "Hamamatsu\,\ Shizuoka",
"818292", "Hiroshima\,\ Hiroshima",
"812244", "Shiroishi\,\ Miyagi",
"811645", "Rumoi\,\ Hokkaido",
"817737", "Maizuru\,\ Kyoto",
"817674", "Hakui\,\ Ishikawa",
"817725", "Miyazu\,\ Kyoto",
"8198292", "Nobeoka\,\ Miyazaki",
"818398", "Ogori\,\ Yamaguchi",
"811863", "Kazuno\,\ Akita",
"812489", "Sukagawa\,\ Fukushima",
"812375", "Murayama\,\ Yamagata",
"812564", "Sanjo\,\ Niigata",
"812965", "Shimodate\,\ Ibaraki",
"8153971", "Hamamatsu\,\ Shizuoka",
"812780", "Maebashi\,\ Gunma",
"817687", "Noto\,\ Ishikawa",
"812743", "Fujioka\,\ Gunma",
"8167", "Osaka\,\ Osaka",
"812586", "Nagaoka\,\ Niigata",
"8198291", "Nobeoka\,\ Miyazaki",
"81474", "Funabashi\,\ Chiba",
"8124197", "Yanaizu\,\ Fukushima",
"814280", "Tachikawa\,\ Tokyo",
"8112397", "Kuriyama\,\ Hokkaido",
"81823", "Kure\,\ Hiroshima",
"812389", "Yonezawa\,\ Yamagata",
"812475", "Ishikawa\,\ Fukushima",
"812550", "Yasuzuka\,\ Niigata",
"811644", "Rumoi\,\ Hokkaido",
"817724", "Miyazu\,\ Kyoto",
"817675", "Nanao\,\ Ishikawa",
"819742", "Mie\,\ Oita",
"812374", "Murayama\,\ Yamagata",
"818391", "Ogori\,\ Yamaguchi",
"817992", "Sumoto\,\ Hyogo",
"813", "Tokyo",
"819598", "Fukue\,\ Nagasaki",
"812487", "Sukagawa\,\ Fukushima",
"812245", "Ogawara\,\ Miyagi",
"8125488", "Tsugawa\,\ Niigata",
"81235", "Tsuruoka\,\ Yamagata",
"812836", "Sano\,\ Tochigi",
"812914", "Hokota\,\ Ibaraki",
"818693", "Oku\,\ Okayama",
"812474", "Ishikawa\,\ Fukushima",
"812565", "Sanjo\,\ Niigata",
"812387", "Nagai\,\ Yamagata",
"818873", "Aki\,\ Kochi",
"81793", "Himeji\,\ Hyogo",
"818388", "Tamagawa\,\ Yamaguchi",
"812964", "Shimodate\,\ Ibaraki",
"811588", "Okoppe\,\ Hokkaido",
"81245", "Fukushima\,\ Fukushima",
"811935", "Kamaishi\,\ Iwate",
"81988", "Naha\,\ Okinawa",
"818298", "Hatsukaichi\,\ Hiroshima",
"811534", "Nakashibetsu\,\ Hokkaido",
"818696", "Bizen\,\ Okayama",
"819724", "Saiki\,\ Oita",
"819934", "Ibusuki\,\ Kagoshima",
"8186993", "Bizen\,\ Okayama",
"8126171", "Omachi\,\ Nagano",
"814775", "Funabashi\,\ Chiba",
"81542", "Shizuoka\,\ Shizuoka",
"81244", "Hobara\,\ Fukushima",
"814797", "Yokaichiba\,\ Chiba",
"811654", "Nayoro\,\ Hokkaido",
"818665", "Takahashi\,\ Okayama",
"811982", "Hanamaki\,\ Iwate",
"814755", "Togane\,\ Chiba",
"818843", "Anan\,\ Tokushima",
"81833", "Kudamatsu\,\ Yamaguchi",
"8126172", "Omachi\,\ Nagano",
"81167", "Furano\,\ Hokkaido",
"81532", "Toyohashi\,\ Aichi",
"81234", "Sakata\,\ Yamagata",
"812833", "Utsunomiya\,\ Tochigi",
"81462", "Atsugi\,\ Kanagawa",
"8183768", "Shimonoseki\,\ Yamaguchi",
"819935", "Kaseda\,\ Kagoshima",
"8188099", "Tosashimizu\,\ Kochi",
"81188", "Akita\,\ Akita",
"817998", "Tsuna\,\ Hyogo",
"8112396", "Kuriyama\,\ Hokkaido",
"812746", "Tomioka\,\ Gunma",
"81225", "Ishinomaki\,\ Miyagi",
"8124196", "Yanaizu\,\ Fukushima",
"81965", "Yatsushiro\,\ Kumamoto",
"817230", "Neyagawa\,\ Osaka",
"812583", "Nagaoka\,\ Niigata",
"811934", "Kamaishi\,\ Iwate",
"81586", "Ichinomiya\,\ Aichi",
"811877", "Omagari\,\ Akita",
"819592", "Oseto\,\ Nagasaki",
"8182942", "Hiroshima\,\ Hiroshima",
"811527", "Bihoro\,\ Hokkaido",
"811535", "Akkeshi\,\ Hokkaido",
"819737", "Kusu\,\ Oita",
"819725", "Saiki\,\ Oita",
"8153968", "Hamamatsu\,\ Shizuoka",
"81270", "Isesaki\,\ Gunma",
"81989", "Naha\,\ Okinawa",
"818686", "Tsuyama\,\ Okayama",
"81764", "Toyama\,\ Toyama",
"812993", "Ishioka\,\ Ibaraki",
"819687", "Tamana\,\ Kumamoto",
"81172", "Hirosaki\,\ Aomori",
"811752", "Mutsu\,\ Aomori",
"8186553", "Kurashiki\,\ Okayama",
"811857", "Noshiro\,\ Akita",
"811582", "Monbetsu\,\ Hokkaido",
"8182941", "Hiroshima\,\ Hiroshima",
"818664", "Takahashi\,\ Okayama",
"811655", "Nayoro\,\ Hokkaido",
"81227", "Sendai\,\ Miyagi",
"818382", "Hagi\,\ Yamaguchi",
"811866", "Takanosu\,\ Akita",
"814754", "Mobara\,\ Chiba",
"81420", "Tokorozawa\,\ Saitama",
"8112394", "Yubari\,\ Hokkaido",
"814703", "Tateyama\,\ Chiba",
"81555", "Fujiyoshida\,\ Yamanashi",
"819976", "Naze\,\ Kagoshima",
"818834", "Kamojima\,\ Tokushima",
"81938", "Kitakyushu\,\ Fukuoka",
"818977", "Hakata\,\ Ehime",
"811238", "Kuriyama\,\ Hokkaido",
"812571", "Muika\,\ Niigata",
"814298", "Hanno\,\ Saitama",
"818594", "Yonago\,\ Tottori",
"81176", "Towada\,\ Aomori",
"818205", "Yanai\,\ Yamaguchi",
"812542", "Shibata\,\ Niigata",
"811394", "Matsumae\,\ Hokkaido",
"818892", "Sakawa\,\ Kochi",
"817904", "Fukusaki\,\ Hyogo",
"818376", "Mine\,\ Yamaguchi",
"812798", "Naganohara\,\ Gunma",
"819808", "Yaeyama\ District\,\ Okinawa",
"812649", "Nagano\,\ Nagano",
"817953", "Nishiwaki\,\ Hyogo",
"81898", "Imabari\,\ Ehime",
"818797", "Tonosho\,\ Kagawa",
"817946", "Miki\,\ Hyogo",
"81578", "Kamioka\,\ Akita",
"815997", "Ago\,\ Mie",
"811332", "Tobetsu\,\ Hokkaido",
"818467", "Mima\,\ Tokushima",
"81433", "Chiba\,\ Chiba",
"815766", "Gero\,\ Gifu",
"81563", "Nishio\,\ Aichi",
"81948", "Iizuka\,\ Fukuoka",
"818559", "Kawamoto\,\ Shimane",
"819967", "Izumi\,\ Kagoshima",
"8126170", "Omachi\,\ Nagano",
"811543", "Kushiro\,\ Hokkaido",
"811556", "Obihiro\,\ Hokkaido",
"819662", "Hitoyoshi\,\ Kumamoto",
"812551", "Joetsu\,\ Niigata",
"818476", "Fuchu\,\ Hiroshima",
"81862", "Okayama\,\ Okayama",
"814281", "Sagamihara\,\ Kanagawa",
"817463", "Yoshino\,\ Nara",
"819943", "Kanoya\,\ Kagoshima",
"81557", "Ito\,\ Shizuoka",
"819956", "Kajiki\,\ Kagoshima",
"81582", "Gifu\,\ Gifu",
"8188095", "Tosashimizu\,\ Kochi",
"81284", "Ashikaga\,\ Tochigi",
"818652", "Kurashiki\,\ Okayama",
"818957", "Misho\,\ Ehime",
"818367", "Ube\,\ Yamaguchi",
"818585", "Kurayoshi\,\ Tottori",
"81729", "Yao\,\ Osaka",
"81949", "Nogata\,\ Fukuoka",
"815974", "Owase\,\ Mie",
"817905", "Fukusaki\,\ Hyogo",
"81531", "Tahara\,\ Aichi",
"8198293", "Nobeoka\,\ Miyazaki",
"811976", "Kitakami\,\ Iwate",
"815732", "Ena\,\ Gifu",
"81138", "Hakodate\,\ Hokkaido",
"812236", "Sendai\,\ Miyagi",
"814291", "Hanno\,\ Saitama",
"812578", "Muika\,\ Niigata",
"81466", "Fujisawa\,\ Kanagawa",
"818835", "Mima\,\ Tokushima",
"819576", "Shimabara\,\ Nagasaki",
"819826", "Hyuga\,\ Miyazaki",
"815999", "Tsu\,\ Mie",
"8153973", "Hamamatsu\,\ Shizuoka",
"811377", "Yakumo\,\ Hokkaido",
"812613", "Omachi\,\ Nagano",
"817707", "Obama\,\ Fukui",
"818246", "Miyoshi\,\ Hiroshima",
"81875", "Kan\'onji\,\ Kagawa",
"818595", "Yonago\,\ Tottori",
"811466", "Erimo\,\ Hokkaido",
"81728", "Neyagawa\,\ Osaka",
"812647", "Nagano\,\ Nagano",
"818204", "Yanai\,\ Yamaguchi",
"811395", "Esashi\,\ Hokkaido",
"818490", "Onomichi\,\ Hiroshima",
"81939", "Kitakyushu\,\ Fukuoka",
"81877", "Marugame\,\ Kagawa",
"818557", "Kawamoto\,\ Shimane",
"819543", "Takeo\,\ Saga",
"814288", "Ome\,\ Tokyo",
"819556", "Karatsu\,\ Saga",
"811357", "Iwanai\,\ Hokkaido",
"818584", "Kurayoshi\,\ Tottori",
"812788", "Maebashi\,\ Gunma",
"81899", "Matsuyama\,\ Ehime",
"817618", "Kaga\,\ Ishikawa",
"818369", "Ube\,\ Yamaguchi",
"819786", "Kitsuki\,\ Oita",
"81546", "Shizuoka\,\ Shizuoka",
"811943", "Iwaizumi\,\ Iwate",
"811366", "Suttsu\,\ Hokkaido",
"811956", "Iwate\,\ Iwate",
"819432", "Yame\,\ Fukuoka",
"818660", "Seto\,\ Okayama",
"81552", "Kofu\,\ Yamanashi",
"81587", "Ichinomiya\,\ Aichi",
"811867", "Takanosu\,\ Akita",
"817498", "Nagahama\,\ Shiga",
"819435", "Yame\,\ Fukuoka",
"819664", "Hitoyoshi\,\ Kumamoto",
"817733", "Fukuchiyama\,\ Kyoto",
"81723", "Sakai\,\ Osaka",
"8147957", "Yokaichiba\,\ Chiba",
"81439", "Kisarazu\,\ Chiba",
"81569", "Handa\,\ Aichi",
"81853", "Izumo\,\ Shimane",
"811856", "Noshiro\,\ Akita",
"817718", "Sonobe\,\ Kyoto",
"818687", "Mimasaka\,\ Okayama",
"819686", "Tamana\,\ Kumamoto",
"818654", "Kamogata\,\ Okayama",
"818832", "Kamojima\,\ Tokushima",
"8112399", "Kuriyama\,\ Hokkaido",
"8153978", "Hamamatsu\,\ Shizuoka",
"81226", "Kesennuma\,\ Miyagi",
"818674", "Kuse\,\ Okayama",
"818879", "Muroto\,\ Kochi",
"818592", "Yonago\,\ Tottori",
"8188096", "Tosashimizu\,\ Kochi",
"811392", "Kikonai\,\ Hokkaido",
"81471", "Kashiwa\,\ Chiba",
"811876", "Omagari\,\ Akita",
"812544", "Shibata\,\ Niigata",
"811526", "Abashiri\,\ Hokkaido",
"815735", "Ena\,\ Gifu",
"814770", "Ichikawa\,\ Chiba",
"8198298", "Hyuga\,\ Miyazaki",
"818894", "Susaki\,\ Kochi",
"81143", "Muroran\,\ Hokkaido",
"817902", "Fukusaki\,\ Hyogo",
"817683", "Wajima\,\ Ishikawa",
"812747", "Tomioka\,\ Gunma",
"8199343", "Kagoshima\,\ Kagoshima",
"81585", "Ibigawa\,\ Gifu",
"81476", "Narita\,\ Chiba",
"81893", "Ozu\,\ Ehime",
"812483", "Shirakawa\,\ Fukushima",
"818582", "Kurayoshi\,\ Tottori",
"818655", "Kamogata\,\ Okayama",
"811869", "Odate\,\ Akita",
"812858", "Mooka\,\ Tochigi",
"81933", "Kitakyushu\,\ Fukuoka",
"81592", "Tsu\,\ Mie",
"81294", "Hitachiota\,\ Ibaraki",
"818689", "Okayama\,\ Okayama",
"815362", "Shinshiro\,\ Aichi",
"8125481", "Murakami\,\ Niigata",
"819665", "Hitoyoshi\,\ Kumamoto",
"819434", "Yame\,\ Fukuoka",
"817488", "Minakuchi\,\ Shiga",
"815734", "Ena\,\ Gifu",
"815972", "Owase\,\ Mie",
"814796", "Yokaichiba\,\ Chiba",
"81166", "Asahikawa\,\ Hokkaido",
"811736", "Goshogawara\,\ Aomori",
"818895", "Susaki\,\ Kochi",
"8186697", "Kurashiki\,\ Okayama",
"812878", "Nasukarasuyama\,\ Tochigi",
"812383", "Yonezawa\,\ Yamagata",
"8182920", "Hatsukaichi\,\ Hiroshima",
"81568", "Kasugai\,\ Aichi",
"818675", "Kuse\,\ Okayama",
"81438", "Kisarazu\,\ Chiba",
"81888", "Kochi\,\ Kochi",
"812698", "Iiyama\,\ Nagano",
"8125482", "Murakami\,\ Niigata",
"812545", "Murakami\,\ Niigata",
"818697", "Bizen\,\ Okayama",
"818202", "Yanai\,\ Yamaguchi",
"811652", "Shibetsu\,\ Hokkaido",
"81537", "Kakegawa\,\ Shizuoka",
"811367", "Suttsu\,\ Hokkaido",
"811585", "Engaru\,\ Hokkaido",
"811957", "Iwate\,\ Iwate",
"815986", "Matsusaka\,\ Mie",
"81467", "Fujisawa\,\ Kanagawa",
"818567", "Tsuwano\,\ Shimane",
"811984", "Hanamaki\,\ Iwate",
"818479", "Tojo\,\ Hiroshima",
"818385", "Hagi\,\ Yamaguchi",
"81260", "Anan\,\ Nagano",
"81774", "Uji\,\ Kyoto",
"819787", "Kunisaki\,\ Oita",
"81162", "Wakkanai\,\ Hokkaido",
"812893", "Utsunomiya\,\ Tochigi",
"815769", "Shokawa\,\ Gifu",
"818556", "Gotsu\,\ Shimane",
"81183", "Yuzawa\,\ Akita",
"818543", "Yasugi\,\ Shimane",
"81489", "Soka\,\ Saitama",
"819557", "Karatsu\,\ Saga",
"811356", "Iwanai\,\ Hokkaido",
"81545", "Fuji\,\ Shizuoka",
"811559", "Obihiro\,\ Hokkaido",
"812673", "Komoro\,\ Nagano",
"81977", "Beppu\,\ Oita",
"812911", "Hokota\,\ Ibaraki",
"81839", "Yamaguchi\,\ Yamaguchi",
"81547", "Shimada\,\ Shizuoka",
"817706", "Obama\,\ Fukui",
"812248", "Ogawara\,\ Miyagi",
"817949", "Kakogawa\,\ Hyogo",
"812653", "Iida\,\ Nagano",
"818247", "Shobara\,\ Hiroshima",
"812646", "Nagano\,\ Nagano",
"811532", "Nemuro\,\ Hokkaido",
"81975", "Oita\,\ Oita",
"819722", "Saiki\,\ Oita",
"819827", "Takachiho\,\ Miyazaki",
"819577", "Shimabara\,\ Nagasaki",
"811376", "Yakumo\,\ Hokkaido",
"81591", "Tsu\,\ Mie",
"817678", "Nanao\,\ Ishikawa",
"819932", "Ibusuki\,\ Kagoshima",
"819979", "Tokunoshima\,\ Kagoshima",
"812237", "Sendai\,\ Miyagi",
"818263", "Kake\,\ Hiroshima",
"81596", "Ise\,\ Mie",
"81535", "Hamamatsu\,\ Shizuoka",
"811977", "Kitakami\,\ Iwate",
"81958", "Nagasaki\,\ Nagasaki",
"81465", "Odawara\,\ Kanagawa",
"81849", "Fukuyama\,\ Hiroshima",
"819957", "Kajiki\,\ Kagoshima",
"819789", "Kitsuki\,\ Oita",
"818956", "Uwajima\,\ Ehime",
"818366", "Ube\,\ Yamaguchi",
"818943", "Yawatahama\,\ Ehime",
"812478", "Miharu\,\ Fukushima",
"815743", "Minokamo\,\ Gifu",
"811754", "Mutsu\,\ Aomori",
"81222", "Sendai\,\ Miyagi",
"818477", "Tojo\,\ Hiroshima",
"81962", "Kumamoto\,\ Kumamoto",
"81493", "Higashimatsuyama\,\ Saitama",
"81199", "Morioka\,\ Iwate",
"81983", "Takanabe\,\ Miyazaki",
"818662", "Takahashi\,\ Okayama",
"812968", "Kasama\,\ Ibaraki",
"815586", "Shimoda\,\ Shizuoka",
"811584", "Engaru\,\ Hokkaido",
"812933", "Takahagi\,\ Ibaraki",
"819966", "Izumi\,\ Kagoshima",
"818384", "Hagi\,\ Yamaguchi",
"8112395", "Kuriyama\,\ Hokkaido",
"814752", "Mobara\,\ Chiba",
"81848", "Onomichi\,\ Hiroshima",
"817453", "Yamatotakada\,\ Nara",
"815767", "Gero\,\ Gifu",
"81177", "Aomori\,\ Aomori",
"814772", "Ichikawa\,\ Chiba",
"815996", "Ago\,\ Mie",
"8186998", "Seto\,\ Okayama",
"818466", "Mima\,\ Tokushima",
"8125480", "Murakami\,\ Niigata",
"81998", "Kagoshima\,\ Kagoshima",
"812378", "Sagae\,\ Yamagata",
"818808", "Tosashimizu\,\ Kochi",
"818377", "Shimonoseki\,\ Yamaguchi",
"818796", "Tonosho\,\ Kagawa",
"817947", "Miki\,\ Hyogo",
"818249", "Higashi\-ku\,\ Hiroshima",
"811932", "Kamaishi\,\ Iwate",
"81740", "Imazu\,\ Shiga",
"81488", "Urawa\,\ Saitama",
"819977", "Setouchi\,\ Kagoshima",
"817963", "Toyooka\,\ Hyogo",
"81551", "Nirasaki\,\ Yamanashi",
"817353", "Shingu\,\ Fukuoka",
"812239", "Sendai\,\ Miyagi",
"818976", "Niihama\,\ Ehime",
"81762", "Kanazawa\,\ Ishikawa",
"817476", "Shimonoseki\,\ Yamaguchi",
"812562", "Sanjo\,\ Niigata",
"815993", "Toba\,\ Mie",
"818463", "Takehara\,\ Hiroshima",
"81174", "Kanita\,\ Aomori",
"811658", "Kamikawa\,\ Hokkaido",
"817367", "Iwade\,\ Wakayama",
"812619", "Omachi\,\ Nagano",
"817356", "Kushimoto\,\ Wakayama",
"818973", "Niihama\,\ Ehime",
"81930", "Yukuhashi\,\ Fukuoka",
"811563", "Honbetsu\,\ Hokkaido",
"818294", "Hatsukaichi\,\ Hiroshima",
"819947", "Shibushi\,\ Kagoshima",
"81281", "Utsunomiya\,\ Tochigi",
"818946", "Uwajima\,\ Ehime",
"81798", "Nishinomiya\,\ Hyogo",
"818363", "Ube\,\ Yamaguchi",
"818953", "Uwajima\,\ Ehime",
"812242", "Shiroishi\,\ Miyagi",
"8125483", "Murakami\,\ Niigata",
"815746", "Minokamo\,\ Gifu",
"815753", "Sekigahara\,\ Gifu",
"819728", "Usuki\,\ Oita",
"812936", "Mito\,\ Ibaraki",
"815583", "Shimoda\,\ Shizuoka",
"819938", "Kaseda\,\ Kagoshima",
"811547", "Shiranuka\,\ Hokkaido",
"81286", "Utsunomiya\,\ Tochigi",
"817672", "Hakui\,\ Ishikawa",
"819963", "Satsumasendai\,\ Kagoshima",
"817456", "Yamatotakada\,\ Nara",
"81940", "Munakata\,\ Fukuoka",
"817995", "Sumoto\,\ Hyogo",
"814771", "Ichikawa\,\ Chiba",
"817959", "Sanda\,\ Hyogo",
"812656", "Ina\,\ Nagano",
"817703", "Tsuruga\,\ Fukui",
"8166", "Osaka\,\ Osaka",
"812472", "Ishikawa\,\ Fukushima",
"811453", "Hayakita\,\ Hokkaido",
"818668", "Ibara\,\ Okayama",
"812962", "Shimodate\,\ Ibaraki",
"81534", "Hamamatsu\,\ Shizuoka",
"81464", "Atsugi\,\ Kanagawa",
"814758", "Togane\,\ Chiba",
"811947", "Kuji\,\ Iwate",
"815983", "Matsusaka\,\ Mie",
"817722", "Miyazu\,\ Kyoto",
"81828", "Hiroshima\,\ Hiroshima",
"81775", "Otsu\,\ Shiga",
"819744", "Mie\,\ Oita",
"817994", "Sumoto\,\ Hyogo",
"812896", "Kanuma\,\ Tochigi",
"812372", "Murayama\,\ Yamagata",
"818295", "Hatsukaichi\,\ Hiroshima",
"818546", "Kakeya\,\ Shimane",
"818553", "Hamada\,\ Shimane",
"811353", "Yoichi\,\ Hokkaido",
"811938", "Miyako\,\ Iwate",
"819547", "Kashima\,\ Saga",
"814998", "Ogasawara\,\ Tokyo",
"812676", "Saku\,\ Nagano",
"811549", "Kushiro\,\ Hokkaido",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81544", "Fujinomiya\,\ Shizuoka",
"811733", "Goshogawara\,\ Aomori",
"81429", "Tokorozawa\,\ Saitama",
"814793", "Choshi\,\ Chiba",
"817492", "Hikone\,\ Shiga",
"812589", "Nagaoka\,\ Niigata",
"812785", "Numata\,\ Gunma",
"817615", "Komatsu\,\ Ishikawa",
"812386", "Nagai\,\ Yamagata",
"8126178", "Omachi\,\ Nagano",
"81246", "Iwaki\,\ Fukushima",
"814285", "Sagamihara\,\ Kanagawa",
"817712", "Kameoka\,\ Kyoto",
"812555", "Itoigawa\,\ Niigata",
"812837", "Sano\,\ Tochigi",
"812575", "Tokamachi\,\ Niigata",
"812486", "Sukagawa\,\ Fukushima",
"811398", "Kumaishi\,\ Hokkaido",
"814709", "Kamogawa\,\ Chiba",
"811234", "Chitose\,\ Hokkaido",
"812414", "Yanaizu\,\ Fukushima",
"812794", "Shibukawa\,\ Gunma",
"819804", "Nago\,\ Okinawa",
"81236", "Yamagata\,\ Yamagata",
"812999", "Itako\,\ Ibaraki",
"81743", "Nara\,\ Nara",
"819733", "Hita\,\ Oita",
"81923", "Fukuoka\,\ Fukuoka",
"81263", "Matsumoto\,\ Nagano",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"814284", "Tachikawa\,\ Tokyo",
"812587", "Nagaoka\,\ Niigata",
"818588", "Koge\,\ Tottori",
"811523", "Shari\,\ Hokkaido",
"811873", "Kakunodate\,\ Akita",
"812554", "Joetsu\,\ Niigata",
"817686", "Noto\,\ Ishikawa",
"81864", "Kurashiki\,\ Okayama",
"812560", "Itoigawa\,\ Niigata",
"812784", "Numata\,\ Gunma",
"812852", "Oyama\,\ Tochigi",
"817614", "Komatsu\,\ Ishikawa",
"81282", "Tochigi\,\ Tochigi",
"8188097", "Tosashimizu\,\ Kochi",
"81584", "Ogaki\,\ Gifu",
"815368", "Shitara\,\ Aichi",
"815958", "Kameyama\,\ Mie",
"812795", "Shibukawa\,\ Gunma",
"819805", "Nago\,\ Okinawa",
"815978", "Kumano\,\ Mie",
"817482", "Yokaichi\,\ Shiga",
"812839", "Sano\,\ Tochigi",
"81766", "Takaoka\,\ Toyama",
"817736", "Maizuru\,\ Kyoto",
"812872", "Otawara\,\ Tochigi",
"812574", "Kashiwazaki\,\ Niigata",
"811853", "Oga\,\ Akita",
"812997", "Itako\,\ Ibaraki",
"812692", "Nakano\,\ Nagano",
"811235", "Yubari\,\ Hokkaido",
"819683", "Yamaga\,\ Kumamoto",
"812415", "Yanaizu\,\ Fukushima",
"818663", "Soja\,\ Okayama",
"812932", "Takahagi\,\ Ibaraki",
"81742", "Nara\,\ Nara",
"817676", "Nanao\,\ Ishikawa",
"81425", "Tachikawa\,\ Tokyo",
"814753", "Mobara\,\ Chiba",
"812419", "Tajima\,\ Fukushima",
"817452", "Yamatotakada\,\ Nara",
"814704", "Tateyama\,\ Chiba",
"812994", "Ishioka\,\ Ibaraki",
"812246", "Ogawara\,\ Miyagi",
"819809", "Yaeyama\ District\,\ Okinawa",
"812799", "Naganohara\,\ Gunma",
"812648", "Nagano\,\ Nagano",
"818942", "Yawatahama\,\ Ehime",
"8186999", "Seto\,\ Okayama",
"815742", "Minokamo\,\ Gifu",
"811378", "Imakane\,\ Hokkaido",
"812577", "Muika\,\ Niigata",
"812835", "Sano\,\ Tochigi",
"811933", "Kamaishi\,\ Iwate",
"812584", "Nagaoka\,\ Niigata",
"814287", "Ome\,\ Tokyo",
"8153975", "Hamamatsu\,\ Shizuoka",
"818558", "Kawamoto\,\ Shimane",
"817962", "Toyooka\,\ Hyogo",
"817352", "Shingu\,\ Fukuoka",
"81277", "Kiryu\,\ Gunma",
"812566", "Sanjo\,\ Niigata",
"8198295", "Hyuga\,\ Miyazaki",
"81427", "Sagamihara\,\ Kanagawa",
"817912", "Aioi\,\ Hyogo",
"812787", "Numata\,\ Gunma",
"817617", "Kaga\,\ Ishikawa",
"8164", "Osaka\,\ Osaka",
"812995", "Ishioka\,\ Ibaraki",
"818542", "Yasugi\,\ Shimane",
"811237", "Kuriyama\,\ Hokkaido",
"814297", "Hanno\,\ Saitama",
"818978", "Hakata\,\ Ehime",
"812672", "Komoro\,\ Nagano",
"812834", "Utsunomiya\,\ Tochigi",
"8147950", "Yokaichiba\,\ Chiba",
"811646", "Haboro\,\ Hokkaido",
"811653", "Shibetsu\,\ Hokkaido",
"815998", "Ago\,\ Mie",
"818844", "Anan\,\ Tokushima",
"812797", "Shibukawa\,\ Gunma",
"81298", "Tsuchiura\,\ Ibaraki",
"818798", "Tonosho\,\ Kagawa",
"812376", "Sagae\,\ Yamagata",
"812892", "Utsunomiya\,\ Tochigi",
"814705", "Tateyama\,\ Chiba",
"818806", "Sukumo\,\ Kochi",
"819968", "Izumi\,\ Kagoshima",
"8163", "Osaka\,\ Osaka",
"819933", "Ibusuki\,\ Kagoshima",
"818262", "Kake\,\ Hiroshima",
"81259", "Sado\,\ Niigata",
"812559", "Yasuzuka\,\ Niigata",
"814289", "Ome\,\ Tokyo",
"8178", "Kobe\,\ Hyogo",
"812789", "Maebashi\,\ Gunma",
"812957", "Daigo\,\ Ibaraki",
"812585", "Nagaoka\,\ Niigata",
"812652", "Iida\,\ Nagano",
"818958", "Misho\,\ Ehime",
"818368", "Ube\,\ Yamaguchi",
"811533", "Nemuro\,\ Hokkaido",
"81434", "Chiba\,\ Chiba",
"819723", "Saiki\,\ Oita",
"81922", "Fukuoka\,\ Fukuoka",
"812476", "Miharu\,\ Fukushima",
"81262", "Nagano\,\ Nagano",
"81564", "Okazaki\,\ Aichi",
"819747", "Taketa\,\ Oita",
"817997", "Tsuna\,\ Hyogo",
"81825", "Hiroshima\,\ Hiroshima",
"81778", "Takefu\,\ Fukui",
"818299", "Hiroshima\,\ Hiroshima",
"8186691", "Kurashiki\,\ Okayama",
"811944", "Iwaizumi\,\ Iwate",
"815363", "Shinshiro\,\ Aichi",
"811545", "Kushiro\,\ Hokkaido",
"812890", "Utsunomiya\,\ Tochigi",
"81266", "Suwa\,\ Nagano",
"819738", "Kusu\,\ Oita",
"817465", "Yoshino\,\ Nara",
"81926", "Fukuoka\,\ Fukuoka",
"811878", "Omagari\,\ Akita",
"811528", "Bihoro\,\ Hokkaido",
"812482", "Shirakawa\,\ Fukushima",
"819945", "Kanoya\,\ Kagoshima",
"818583", "Kurayoshi\,\ Tottori",
"819544", "Takeo\,\ Saga",
"811858", "Noshiro\,\ Akita",
"819688", "Tamana\,\ Kumamoto",
"812614", "Omachi\,\ Nagano",
"818203", "Yanai\,\ Yamaguchi",
"817716", "Sonobe\,\ Kyoto",
"817496", "Nagahama\,\ Shiga",
"815973", "Owase\,\ Mie",
"817955", "Sanda\,\ Hyogo",
"8125487", "Tsugawa\,\ Niigata",
"81763", "Fukuno\,\ Toyama",
"812382", "Yonezawa\,\ Yamagata",
"81827", "Iwakuni\,\ Yamaguchi",
"81243", "Nihonmatsu\,\ Fukushima",
"817464", "Yoshino\,\ Nara",
"812696", "Iiyama\,\ Nagano",
"818297", "Hatsukaichi\,\ Hiroshima",
"8198299", "Hyuga\,\ Miyazaki",
"819944", "Kanoya\,\ Kagoshima",
"8153966", "Hamamatsu\,\ Shizuoka",
"8183766", "Shimonoseki\,\ Yamaguchi",
"812930", "Mito\,\ Ibaraki",
"81126", "Iwamizawa\,\ Hokkaido",
"817486", "Minakuchi\,\ Shiga",
"814798", "Yokaichiba\,\ Chiba",
"814220", "Kokubunji\,\ Tokyo",
"811945", "Kuji\,\ Iwate",
"8112398", "Kuriyama\,\ Hokkaido",
"811544", "Kushiro\,\ Hokkaido",
"812876", "Kuroiso\,\ Tochigi",
"817732", "Fukuchiyama\,\ Kyoto",
"8153979", "Hamamatsu\,\ Shizuoka",
"81233", "Shinjo\,\ Yamagata",
"8168", "Osaka\,\ Osaka",
"81779", "Ono\,\ Gifu",
"817903", "Fukusaki\,\ Hyogo",
"8186995", "Seto\,\ Okayama",
"817682", "Wajima\,\ Ishikawa",
"817954", "Nishiwaki\,\ Hyogo",
"812856", "Mooka\,\ Tochigi",
"818833", "Kamojima\,\ Tokushima",
"81797", "Nishinomiya\,\ Hyogo",
"81834", "Tokuyama\,\ Yamaguchi",
"81550", "Gotenba\,\ Shizuoka",
"8153964", "Hamamatsu\,\ Shizuoka",
"818593", "Yonago\,\ Tottori",
"81484", "Kawaguchi\,\ Saitama",
"812615", "Omachi\,\ Nagano",
"811393", "Matsumae\,\ Hokkaido",
"818374", "Nagato\,\ Yamaguchi",
"811975", "Mizusawa\,\ Iwate",
"81936", "Kitakyushu\,\ Fukuoka",
"817944", "Kakogawa\,\ Hyogo",
"812853", "Oyama\,\ Tochigi",
"81178", "Hachinohe\,\ Aomori",
"812235", "Sendai\,\ Miyagi",
"81549", "Shizuoka\,\ Shizuoka",
"819974", "Yakushima\,\ Kagoshima",
"819732", "Hita\,\ Oita",
"818836", "Mima\,\ Tokushima",
"819575", "Isahaya\,\ Nagasaki",
"819825", "Hyuga\,\ Miyazaki",
"81835", "Hofu\,\ Yamaguchi",
"81896", "Iyomishima\,\ Ehime",
"818596", "Yonago\,\ Tottori",
"811465", "Shizunai\,\ Hokkaido",
"818245", "Miyoshi\,\ Hiroshima",
"811634", "Hamatonbetsu\,\ Hokkaido",
"81485", "Kumagaya\,\ Saitama",
"819597", "Fukue\,\ Nagasaki",
"811522", "Shari\,\ Hokkaido",
"812488", "Sukagawa\,\ Fukushima",
"815394", "Hamamatsu\,\ Shizuoka",
"811396", "Esashi\,\ Hokkaido",
"8183767", "Shimonoseki\,\ Yamaguchi",
"811757", "Noheji\,\ Aomori",
"81487", "Urawa\,\ Saitama",
"818474", "Fuchu\,\ Hiroshima",
"81946", "Amagi\,\ Fukuoka",
"811852", "Oga\,\ Akita",
"818360", "Ogori\,\ Yamaguchi",
"819954", "Kajiki\,\ Kagoshima",
"812693", "Nakano\,\ Nagano",
"81157", "Kitami\,\ Hokkaido",
"81182", "Yokote\,\ Akita",
"81979", "Nakatsu\,\ Oita",
"819555", "Karatsu\,\ Saga",
"81280", "Koga\,\ Ibaraki",
"819682", "Yamaga\,\ Kumamoto",
"819785", "Bungotakada\,\ Oita",
"815764", "Gero\,\ Gifu",
"817483", "Yokaichi\,\ Shiga",
"81845", "Innoshima\,\ Hiroshima",
"811587", "Nakayubetsu\,\ Hokkaido",
"811365", "Kutchan\,\ Hokkaido",
"811955", "Ninohe\,\ Iwate",
"812388", "Nagai\,\ Yamagata",
"818565", "Masuda\,\ Shimane",
"811554", "Obihiro\,\ Hokkaido",
"818387", "Tamagawa\,\ Yamaguchi",
"812873", "Otawara\,\ Tochigi",
"8153967", "Hamamatsu\,\ Shizuoka",
"812640", "Nagano\,\ Nagano",
"819975", "Naze\,\ Kagoshima",
"819824", "Nobeoka\,\ Miyazaki",
"819574", "Isahaya\,\ Nagasaki",
"811635", "Hamatonbetsu\,\ Hokkaido",
"8125486", "Tsugawa\,\ Niigata",
"818244", "Miyoshi\,\ Hiroshima",
"811464", "Shizunai\,\ Hokkaido",
"818206", "Yanai\,\ Yamaguchi",
"815395", "Hamamatsu\,\ Shizuoka",
"817713", "Kameoka\,\ Kyoto",
"81721", "Tondabayashi\,\ Osaka",
"819599", "Oseto\,\ Nagasaki",
"811732", "Goshogawara\,\ Aomori",
"814792", "Choshi\,\ Chiba",
"81468", "Yokosuka\,\ Kanagawa",
"818375", "Mine\,\ Yamaguchi",
"811974", "Mizusawa\,\ Iwate",
"817493", "Hikone\,\ Shiga",
"81538", "Iwata\,\ Shizuoka",
"817945", "Kakogawa\,\ Hyogo",
"817738", "Maizuru\,\ Kyoto",
"818397", "Ogori\,\ Yamaguchi",
"81726", "Ibaraki\,\ Osaka",
"812234", "Sendai\,\ Miyagi",
"815765", "Gero\,\ Gifu",
"817688", "Noto\,\ Ishikawa",
"819784", "Bungotakada\,\ Oita",
"815366", "Shitara\,\ Aichi",
"8126179", "Omachi\,\ Nagano",
"811364", "Kutchan\,\ Hokkaido",
"811954", "Ninohe\,\ Iwate",
"81473", "Ichikawa\,\ Chiba",
"811555", "Obihiro\,\ Hokkaido",
"818564", "Masuda\,\ Shimane",
"81179", "Sannohe\,\ Aomori",
"811987", "Tono\,\ Iwate",
"818475", "Fuchu\,\ Hiroshima",
"81548", "Haibara\,\ Shizuoka",
"81963", "Kumamoto\,\ Kumamoto",
"81492", "Kawagoe\,\ Saitama",
"811589", "Okoppe\,\ Hokkaido",
"819955", "Kajiki\,\ Kagoshima",
"818514", "Ama\,\ Shimane",
"819554", "Imari\,\ Saga",
"8125484", "Murakami\,\ Niigata",
"818586", "Kurayoshi\,\ Tottori",
"819936", "Kaseda\,\ Kagoshima",
"818874", "Aki\,\ Kochi",
"818679", "Niimi\,\ Okayama",
"81986", "Miyakonojo\,\ Miyazaki",
"811452", "Hayakita\,\ Hokkaido",
"812938", "Mito\,\ Ibaraki",
"817239", "Neyagawa\,\ Osaka",
"812963", "Shimodate\,\ Ibaraki",
"815737", "Nakatsugawa\,\ Gifu",
"81142", "Date\,\ Hokkaido",
"812745", "Fujioka\,\ Gunma",
"812549", "Tsugawa\,\ Niigata",
"818948", "Uwajima\,\ Ehime",
"812913", "Hokota\,\ Ibaraki",
"817702", "Tsuruga\,\ Fukui",
"8126175", "Omachi\,\ Nagano",
"818694", "Okayama\,\ Okayama",
"81885", "Komatsushima\,\ Tokushima",
"811536", "Akkeshi\,\ Hokkaido",
"819726", "Usuki\,\ Oita",
"81565", "Toyota\,\ Aichi",
"811372", "Shikabe\,\ Hokkaido",
"812473", "Ishikawa\,\ Fukushima",
"818552", "Hamada\,\ Shimane",
"818685", "Tsuyama\,\ Okayama",
"8199347", "Kagoshima\,\ Kagoshima",
"811352", "Yoichi\,\ Hokkaido",
"81567", "Tsushima\,\ Aichi",
"817968", "Hamasaka\,\ Hyogo",
"81852", "Matsue\,\ Shimane",
"811656", "Bifuka\,\ Hokkaido",
"819437", "Tanushimaru\,\ Fukuoka",
"815982", "Matsusaka\,\ Mie",
"817723", "Miyazu\,\ Kyoto",
"81722", "Sakai\,\ Osaka",
"81553", "Yamanashi\,\ Yamanashi",
"811865", "Odate\,\ Akita",
"812373", "Murayama\,\ Yamagata",
"811936", "Miyako\,\ Iwate",
"818695", "Seto\,\ Okayama",
"812547", "Murakami\,\ Niigata",
"81942", "Kurume\,\ Fukuoka",
"819676", "Takamori\,\ Kumamoto",
"818972", "Niihama\,\ Ehime",
"812678", "Saku\,\ Nagano",
"818677", "Niimi\,\ Okayama",
"814776", "Funabashi\,\ Chiba",
"812563", "Sanjo\,\ Niigata",
"815992", "Toba\,\ Mie",
"818462", "Takehara\,\ Hiroshima",
"811337", "Ishikari\,\ Hokkaido",
"812898", "Kanuma\,\ Tochigi",
"812744", "Fujioka\,\ Gunma",
"815582", "Shimoda\,\ Shizuoka",
"818666", "Ibara\,\ Okayama",
"819667", "Minamata\,\ Kumamoto",
"817673", "Hakui\,\ Ishikawa",
"819962", "Satsumasendai\,\ Kagoshima",
"81932", "Kitakyushu\,\ Fukuoka",
"814756", "Togane\,\ Chiba",
"811864", "Odate\,\ Akita",
"81593", "Yokkaichi\,\ Mie",
"811562", "Honbetsu\,\ Hokkaido",
"8162", "Osaka\,\ Osaka",
"818684", "Tsuyama\,\ Okayama",
"812658", "Ina\,\ Nagano",
"81572", "Tajimi\,\ Gifu",
"818952", "Uwajima\,\ Ehime",
"818362", "Ube\,\ Yamaguchi",
"818657", "Kasaoka\,\ Okayama",
"8145", "Yokohama\,\ Kanagawa",
"812243", "Shiroishi\,\ Miyagi",
"81892", "Kumakogen\,\ Ehime",
"815752", "Sekigahara\,\ Gifu",};
$areanames{ja} = {"811559", "帯広",
"812673", "小諸",
"81977", "別府",
"812911", "鉾田",
"815565", "鰍沢青柳",
"815769", "荘川",
"81183", "湯沢",
"818543", "安来",
"819557", "唐津",
"81260", "阿南町",
"819787", "国東",
"812893", "宇都宮",
"81162", "稚内",
"811652", "士別",
"811585", "遠軽",
"818479", "東城",
"818385", "萩",
"81596", "伊勢",
"81535", "浜松",
"811977", "北上",
"81849", "福山",
"81465", "小田原",
"811639", "利尻礼文",
"817678", "七尾",
"819979", "徳之島",
"811456", "門別富川",
"819827", "高千穂",
"811376", "八雲",
"8153963", "天竜",
"81547", "島田",
"812248", "大河原",
"819204", "郷ノ浦",
"818247", "庄原",
"812646", "長野",
"811532", "根室",
"819595", "有川",
"8112395", "栗山",
"814752", "茂原",
"817453", "大和高田",
"818662", "高梁",
"819966", "出水",
"815743", "美濃加茂",
"81222", "仙台",
"81493", "東松山",
"819957", "加治木",
"818943", "八幡浜",
"819672", "熊本一の宮",
"812239", "仙台",
"818976", "新居浜",
"811932", "釜石",
"815397", "浜松",
"81488", "浦和",
"812378", "寒河江",
"818377", "下関",
"818796", "土庄",
"817947", "三木",
"815996", "阿児",
"8186998", "岡山瀬戸",
"811648", "焼尻",
"8125480", "村上",
"818466", "木江",
"818687", "美作",
"818654", "鴨方",
"8147957", "八日市場",
"81439", "木更津",
"81569", "半田",
"811856", "能代",
"817733", "福知山",
"81587", "一宮",
"811867", "鷹巣",
"817498", "長浜",
"814770", "市川",
"81143", "室蘭",
"817683", "輪島",
"818592", "米子",
"811392", "木古内",
"81471", "柏",
"811526", "網走",
"8112399", "栗山",
"818879", "室戸",
"8125481", "村上",
"819665", "人吉",
"819434", "八女",
"812858", "真岡",
"81933", "北九州",
"81294", "常陸太田",
"8125482", "村上",
"812545", "村上",
"818675", "久世",
"812383", "米沢",
"8182920", "廿日市",
"815734", "恵那",
"815972", "尾鷲",
"811736", "五所川原",
"818895", "須崎",
"814285", "相模原",
"812555", "糸魚川",
"814793", "銚子",
"817492", "彦根",
"812589", "長岡",
"812785", "沼田",
"818847", "牟岐",
"812794", "渋川",
"819804", "名護",
"81236", "山形",
"812486", "須賀川",
"811398", "熊石",
"814709", "鴨川",
"818598", "根雨",
"812974", "水海道",
"81282", "栃木",
"8188097", "土佐清水",
"812560", "糸魚川",
"812852", "小山",
"817614", "小松",
"812955", "常陸大宮",
"811873", "角館",
"819733", "日田",
"81263", "松本",
"812997", "潮来",
"811235", "夕張",
"819683", "山鹿",
"812415", "柳津",
"812574", "柏崎",
"812839", "佐野",
"81766", "高岡",
"815978", "熊野",
"817966", "八鹿",
"817356", "串本",
"81930", "行橋",
"817957", "丹波柏原",
"817367", "岩出",
"812619", "大町",
"817476", "下市",
"81174", "蟹田",
"811658", "上川",
"817995", "洲本",
"812936", "水戸",
"815583", "下田",
"814226", "武蔵野三鷹",
"817672", "羽咋",
"815753", "関",
"811563", "本別",
"819913", "硫黄島",
"819947", "志布志",
"811538", "根室標津",
"81281", "宇都宮",
"818363", "宇部",
"818953", "宇和島",
"812242", "白石",
"81534", "浜松",
"81464", "厚木",
"814758", "東金",
"818266", "千代田",
"818668", "井原",
"812656", "伊那",
"817703", "敦賀",
"8166", "大阪",
"811549", "釧路",
"81242", "会津若松",
"819678", "矢部",
"818295", "廿日市",
"818553", "浜田",
"811353", "余市",
"811938", "宮古",
"819547", "鹿島",
"819744", "三重",
"812372", "村山",
"811642", "石狩深川",
"815983", "松阪",
"811528", "美幌",
"812482", "白河",
"818583", "倉吉",
"819544", "武雄",
"817465", "吉野",
"81926", "福岡",
"815363", "新城",
"815953", "上野",
"811545", "釧路",
"812890", "宇都宮",
"819747", "竹田",
"818299", "広島",
"8186691", "倉敷",
"81827", "岩国",
"817496", "長浜",
"818203", "柳井",
"811858", "能代",
"811945", "久慈",
"8112398", "栗山",
"811738", "鰺ケ沢",
"819944", "鹿屋",
"81243", "二本松",
"81484", "川口",
"812615", "大町",
"818833", "鴨島",
"81797", "西宮",
"81834", "徳山",
"8168", "大阪",
"81779", "大野",
"8186995", "岡山瀬戸",
"817903", "福崎",
"817364", "和歌山橋本",
"817954", "西脇",
"812856", "真岡",
"8186999", "岡山瀬戸",
"811378", "今金",
"812577", "六日町",
"812835", "佐野",
"812994", "石岡",
"812246", "大河原",
"812648", "長野",
"81425", "立川",
"812419", "田島",
"812932", "高萩",
"817676", "七尾",
"814222", "武蔵野三鷹",
"81220", "迫",
"817617", "加賀",
"817472", "五条",
"817962", "豊岡",
"817352", "新宮",
"818844", "阿南",
"812797", "渋川",
"819807", "沖縄宮古",
"81298", "土浦",
"818798", "土庄",
"812376", "寒河江",
"814705", "館山",
"811646", "羽幌",
"815998", "阿児",
"812977", "竜ケ崎",
"8188093", "窪川",
"818978", "伯方",
"8164", "大阪",
"814297", "飯能",
"819723", "佐伯",
"81262", "長野",
"812789", "前橋",
"812585", "長岡",
"812652", "飯田",
"812559", "安塚",
"814289", "青梅",
"819968", "出水",
"819933", "指宿",
"818262", "加計",
"811372", "鹿部",
"812473", "石川",
"812642", "木曾福島",
"811536", "厚岸",
"815737", "中津川",
"812745", "藤岡",
"81142", "伊達",
"812549", "津川",
"81240", "磐城富岡",
"814228", "武蔵野三鷹",
"818679", "新見",
"81986", "都城",
"812938", "水戸",
"811452", "早来",
"812963", "下館",
"818803", "土佐中村",
"811656", "美深",
"819437", "田主丸",
"817723", "宮津",
"817968", "浜坂",
"81567", "津島",
"818792", "三本松",
"818875", "土佐山田",
"815992", "鳥羽",
"812563", "三条",
"818462", "竹原",
"811337", "石狩",
"819676", "高森",
"818972", "新居浜",
"811936", "宮古",
"818695", "岡山瀬戸",
"818684", "津山",
"8162", "大阪",
"812658", "伊那",
"818657", "笠岡",
"8145", "横浜",
"81932", "北九州",
"814756", "東金",
"81424", "武蔵野三鷹",
"811864", "大館",
"818268", "千代田",
"818666", "井原",
"819962", "川内",
"818596", "米子",
"81485", "熊谷",
"811522", "斜里",
"815394", "浜松",
"812488", "須賀川",
"811396", "江差",
"81549", "静岡",
"819575", "諫早",
"81835", "防府",
"81896", "伊予三島",
"81178", "八戸",
"812235", "仙台",
"818374", "長門",
"817944", "加古川",
"811365", "倶知安",
"811955", "二戸",
"818565", "益田",
"812873", "大田原",
"817483", "八日市",
"819954", "加治木",
"81182", "横手",
"812693", "中野",
"81280", "古河",
"81979", "中津",
"8183767", "下関",
"81946", "甘木",
"818360", "小郡",
"811852", "男鹿",
"81726", "茨木",
"818397", "小郡",
"811732", "五所川原",
"819599", "大瀬戸",
"81468", "横須賀",
"811974", "水沢",
"81538", "磐田",
"811635", "浜頓別",
"8125486", "津川",
"811464", "静内",
"818244", "三次",
"817713", "亀岡",
"819975", "名瀬",
"819824", "延岡",
"818514", "海士",
"819554", "伊万里",
"8125484", "村上",
"818475", "府中",
"81492", "川越",
"811589", "興部",
"81473", "市川",
"811555", "帯広",
"815765", "下呂",
"819784", "豊後高田",
"81482", "川口",
"819666", "水俣",
"819233", "前原",
"811552", "帯広",
"81250", "新津",
"81832", "下関",
"815762", "下呂",
"819684", "山鹿",
"812618", "大町",
"81533", "豊橋",
"818680", "岡山",
"818472", "甲山",
"812573", "柏崎",
"81463", "平塚",
"811632", "天塩",
"81478", "佐原",
"811874", "角館",
"812546", "村上",
"819734", "日田",
"819972", "種子島",
"818676", "久世",
"814777", "船橋",
"811541", "弟子屈",
"811539", "根室標津",
"811735", "五所川原",
"818896", "須崎",
"817613", "小松",
"81228", "築館",
"8125485", "津川",
"81987", "日南",
"812973", "水海道",
"811855", "能代",
"818669", "総社",
"811952", "二戸",
"811362", "倶知安",
"818562", "益田",
"812793", "渋川",
"819803", "名護",
"81969", "天草",
"81192", "大船渡",
"819937", "加世田",
"811548", "弟子屈",
"81886", "徳島",
"819679", "高森",
"812232", "岩沼",
"81566", "刈谷",
"814794", "銚子",
"81495", "本庄",
"81436", "市原",
"811939", "宮古",
"8144", "川崎",
"811525", "網走",
"819727", "臼杵",
"817468", "上北山",
"8112390", "夕張",
"819572", "諫早",
"819743", "三重",
"815957", "上野",
"815367", "設楽",
"815984", "松阪",
"819965", "川内",
"811986", "遠野",
"81857", "鳥取",
"81559", "沼津",
"81727", "池田",
"818554", "浜田",
"812588", "長岡",
"8186698", "倉敷",
"818587", "郡家",
"811354", "余市",
"818240", "東広島",
"81956", "佐世保",
"81191", "一関",
"818975", "新居浜",
"817704", "敦賀",
"8199331", "鹿児島",
"818692", "邑久",
"818207", "久賀",
"814708", "大原",
"818795", "三本松",
"815995", "阿児",
"8125489", "津川",
"818872", "室戸",
"8112391", "夕張",
"815754", "関",
"811756", "野辺地",
"81124", "芦別",
"815566", "身延",
"811564", "上士幌",
"8198297", "日向",
"818364", "宇部",
"818954", "宇和島",
"81577", "高山",
"8161", "大阪",
"815584", "下田",
"811586", "中湧別",
"81734", "和歌山",
"817907", "播磨山崎",
"812742", "藤岡",
"8112392", "夕張",
"81947", "田川",
"814701", "鴨川",
"817940", "加古川",
"811455", "鵡川",
"812838", "佐野",
"81935", "北九州",
"818837", "阿波池田",
"811375", "八雲",
"812645", "木曾福島",
"815979", "熊野",
"819596", "福江",
"817914", "相生",
"81272", "前橋",
"818265", "安芸吉田",
"817950", "三田",
"81934", "北九州",
"8153974", "天竜",
"812655", "飯田",
"812582", "長岡",
"819940", "志布志",
"81125", "滝川",
"815744", "美濃加茂",
"818296", "広島",
"812697", "飯山",
"818698", "備前",
"81288", "今市",
"818944", "八幡浜",
"817454", "大和高田",
"817487", "水口",
"814702", "館山",
"812877", "黒磯",
"818878", "嶺北",
"81253", "新潟",
"817355", "新宮",
"817965", "豊岡",
"812859", "小山",
"817717", "園部",
"81460", "小田原",
"8199345", "鹿児島",
"817475", "下市",
"81927", "福岡",
"812894", "宇都宮",
"817996", "津名",
"812748", "富岡",
"812935", "水戸",
"8126177", "長野",
"814225", "武蔵野三鷹",
"81144", "苫小牧",
"812674", "小諸",
"812832", "佐野",
"818544", "木次",
"812384", "米沢",
"811558", "広尾",
"812967", "笠間",
"815768", "下呂",
"815733", "恵那",
"81494", "秩父",
"812612", "大町",
"812956", "常陸大宮",
"8169", "大阪",
"812477", "三春",
"818478", "東城",
"811236", "千歳",
"812416", "田島",
"811638", "利尻礼文",
"819978", "徳之島",
"811942", "岩泉",
"817727", "峰山",
"819433", "八女",
"818807", "宿毛",
"814286", "相模原",
"8165", "大阪",
"812556", "糸魚川",
"8111", "札幌",
"81184", "本荘",
"812567", "巻",
"818568", "津和野",
"811333", "当別",
"811958", "岩手",
"817684", "輪島",
"811551", "十勝池田",
"812786", "沼田",
"8186994", "岡山瀬戸",
"812238", "仙台",
"817734", "福知山",
"811542", "釧路",
"8186996", "岡山瀬戸",
"812485", "白河",
"819578", "島原",
"811863", "鹿角",
"812375", "村山",
"812489", "須賀川",
"814706", "大原",
"811645", "留萌",
"817737", "舞鶴",
"818683", "津山",
"818292", "広島",
"812570", "小出",
"812586", "長岡",
"81474", "船橋",
"817687", "能都",
"8167", "大阪",
"812564", "三条",
"8125488", "津川",
"812836", "佐野",
"819598", "福江",
"812245", "大河原",
"817992", "洲本",
"818804", "土佐中村",
"817724", "宮津",
"817675", "七尾",
"81245", "福島",
"812387", "長井",
"818388", "田万川",
"812964", "下館",
"811588", "興部",
"812474", "石川",
"811946", "久慈",
"81268", "上田",
"812897", "鹿沼",
"819783", "豊後高田",
"818547", "掛合",
"812412", "喜多方",
"811232", "千歳",
"819553", "伊万里",
"814229", "武蔵野三鷹",
"812677", "佐久",
"8182943", "広島",
"818678", "新見",
"812939", "水戸",
"81776", "福井",
"811463", "浦河",
"818243", "東広島",
"812616", "大町",
"817714", "亀岡",
"81423", "国分寺",
"81292", "水戸",
"819823", "延岡",
"819668", "水俣",
"817969", "浜坂",
"81273", "高崎",
"811973", "水沢",
"812855", "小山",
"812694", "中野",
"819953", "大口",
"818947", "宇和",
"815747", "美濃白川",
"817466", "十津川",
"81738", "御坊",
"812874", "大田原",
"811546", "釧路",
"817457", "大和高田",
"817484", "八日市",
"8186992", "備前",
"817495", "長浜",
"818373", "長門",
"81929", "福岡",
"817943", "加古川",
"812659", "伊那",
"812782", "沼田",
"817917", "竜野",
"814282", "青梅",
"815393", "浜松",
"812552", "上越",
"81480", "久喜",
"81252", "新潟",
"817904", "福崎",
"818892", "佐川",
"817363", "和歌山橋本",
"817953", "西脇",
"812649", "長野",
"811238", "栗山",
"812418", "会津山口",
"811636", "北見枝幸",
"812542", "新発田",
"819976", "名瀬",
"818834", "鴨島",
"81938", "北九州",
"818672", "福渡",
"819943", "鹿屋",
"81557", "伊東",
"811567", "十勝清水",
"81284", "足利",
"818957", "御荘",
"81729", "八尾",
"818367", "宇部",
"812551", "上越",
"815757", "郡上八幡",
"818476", "府中",
"814281", "相模原",
"815587", "修善寺大仁",
"811556", "帯広",
"819662", "人吉",
"815766", "下呂",
"817707", "小浜",
"818595", "米子",
"818204", "柳井",
"811395", "江差",
"819576", "島原",
"815999", "津",
"812236", "仙台",
"81949", "直方",
"8198293", "延岡",
"81531", "田原",
"815954", "上野",
"811956", "岩手",
"811366", "寿都",
"815987", "三瀬谷",
"812788", "前橋",
"81899", "松山",
"81546", "静岡",
"812558", "新井",
"818557", "川本",
"814288", "青梅",
"819543", "武雄",
"811357", "岩内",
"818584", "倉吉",
"819969", "中甑",
"81877", "丸亀",
"814797", "八日市場",
"81244", "原町",
"819934", "指宿",
"818876", "土佐山田",
"819724", "佐伯",
"819675", "熊本一の宮",
"811935", "釜石",
"818298", "廿日市",
"818696", "備前",
"81532", "豊橋",
"81462", "厚木",
"814755", "東金",
"818843", "阿南",
"81833", "下松",
"818665", "高梁",
"811982", "花巻",
"819737", "玖珠",
"817230", "寝屋川",
"814994", "三宅",
"81586", "一宮",
"819592", "大瀬戸",
"811877", "大曲",
"811535", "厚岸",
"817998", "津名",
"8112396", "栗山",
"812746", "富岡",
"81225", "石巻",
"8124196", "柳津",
"81188", "秋田",
"81420", "所沢",
"8112394", "夕張",
"811582", "紋別",
"811655", "名寄",
"818382", "萩",
"811752", "むつ",
"8186553", "倉敷",
"81989", "那覇",
"81270", "伊勢崎",
"815562", "鰍沢青柳",
"812993", "石岡",
"819687", "玉名",
"81172", "弘前",
"81545", "富士",
"81839", "山口",
"818556", "江津",
"81489", "草加",
"811356", "岩内",
"81774", "宇治",
"81537", "掛川",
"811957", "岩手",
"811367", "寿都",
"815986", "松阪",
"812568", "巻",
"81467", "藤沢",
"811984", "花巻",
"818567", "津和野",
"815399", "天竜",
"81958", "長崎",
"819932", "指宿",
"812237", "仙台",
"818263", "加計",
"819722", "佐伯",
"819577", "島原",
"81591", "津",
"817706", "小浜",
"817949", "加古川",
"812653", "飯田",
"81975", "大分",
"81848", "尾道",
"815767", "下呂",
"81177", "青森",
"81983", "高鍋",
"812968", "笠間",
"815586", "下田",
"811584", "遠軽",
"812933", "高萩",
"818384", "萩",
"811557", "十勝池田",
"814223", "武蔵野三鷹",
"815756", "郡上八幡",
"812478", "三春",
"811754", "むつ",
"818477", "東城",
"81962", "熊本",
"81199", "盛岡",
"819789", "杵築",
"815564", "鰍沢青柳",
"811566", "十勝清水",
"818956", "宇和島",
"818366", "宇部",
"819977", "瀬戸内",
"817963", "豊岡",
"81551", "韮崎",
"817353", "新宮",
"81740", "今津",
"814992", "伊豆大島",
"811637", "北見枝幸",
"819205", "厳原",
"819594", "有川",
"81998", "鹿児島",
"818808", "土佐清水",
"818249", "東広島",
"817728", "峰山",
"814772", "市川",
"817473", "五条",
"817718", "園部",
"819686", "玉名",
"8188094", "窪川",
"81853", "出雲",
"819435", "八女",
"819664", "人吉",
"81723", "堺",
"81552", "甲府",
"818660", "岡山瀬戸",
"81585", "揖斐川",
"81476", "成田",
"815735", "恵那",
"817902", "福崎",
"8198298", "日向",
"818894", "須崎",
"812747", "富岡",
"8199343", "鹿児島",
"8188096", "土佐清水",
"812544", "新発田",
"811876", "大曲",
"818832", "鴨島",
"81226", "気仙沼",
"818674", "久世",
"815952", "上野",
"815362", "新城",
"81592", "津",
"818689", "岡山",
"812483", "白河",
"818582", "倉吉",
"818655", "鴨方",
"811869", "大館",
"81893", "大洲",
"81888", "高知",
"812698", "飯山",
"818697", "備前",
"818202", "柳井",
"81568", "春日井",
"81438", "木更津",
"812878", "烏山",
"818877", "嶺北",
"817488", "水口",
"81166", "旭川",
"814796", "八日市場",
"8186697", "倉敷",
"817712", "亀岡",
"81246", "いわき",
"812386", "長井",
"811733", "五所川原",
"81429", "所沢",
"817615", "小松",
"81743", "奈良",
"817908", "播磨山崎",
"812999", "潮来",
"811234", "千歳",
"812414", "柳津",
"812837", "佐野",
"812575", "十日町",
"818838", "阿波池田",
"81584", "大垣",
"8153961", "天竜",
"815958", "亀山",
"815368", "設楽",
"817686", "能都",
"81864", "倉敷",
"812784", "沼田",
"814284", "立川",
"812587", "長岡",
"818588", "郡家",
"811523", "斜里",
"812554", "上越",
"81923", "福岡",
"818208", "久賀",
"812692", "中野",
"8153962", "天竜",
"812975", "水海道",
"811853", "男鹿",
"817736", "舞鶴",
"812872", "大田原",
"819805", "名護",
"812795", "渋川",
"817482", "八日市",
"814707", "大原",
"818973", "新居浜",
"818793", "三本松",
"817916", "竜野",
"81762", "金沢",
"812562", "三条",
"815993", "鳥羽",
"818463", "竹原",
"817456", "大和高田",
"81940", "宗像",
"814771", "市川",
"819938", "加世田",
"811547", "白糠",
"81286", "宇都宮",
"819963", "川内",
"8125483", "村上",
"815746", "美濃加茂",
"819728", "臼杵",
"818294", "廿日市",
"818946", "宇和",
"81798", "西宮",
"811453", "早来",
"812962", "下館",
"812472", "石川",
"812643", "木曾福島",
"817959", "三田",
"812617", "大町",
"812676", "佐久",
"81544", "富士宮",
"818546", "掛合",
"814998", "小笠原",
"81775", "大津",
"81828", "広島",
"818802", "窪川",
"817994", "洲本",
"812896", "鹿沼",
"819949", "大根占",
"811947", "久慈",
"8153960", "天竜",
"817722", "宮津",
"811878", "大曲",
"819945", "鹿屋",
"81266", "諏訪",
"819738", "玖珠",
"811944", "岩泉",
"81778", "武生",
"81825", "広島",
"817997", "津名",
"8125487", "津川",
"81763", "福野",
"812382", "米沢",
"815973", "尾鷲",
"817955", "三田",
"817365", "和歌山橋本",
"819688", "玉名",
"812614", "大町",
"817716", "園部",
"811544", "釧路",
"812876", "黒磯",
"817732", "福知山",
"8183766", "下関",
"812930", "水戸",
"81126", "岩見沢",
"817486", "水口",
"814798", "八日市場",
"814220", "国分寺",
"818297", "廿日市",
"812696", "飯山",
"8198299", "日向",
"817464", "吉野",
"818593", "米子",
"817960", "八鹿",
"811393", "松前",
"81550", "御殿場",
"81233", "新庄",
"817682", "輪島",
"815742", "美濃加茂",
"812799", "長野原",
"819809", "八重山",
"818942", "八幡浜",
"818845", "丹生谷",
"814753", "茂原",
"817452", "大和高田",
"814704", "館山",
"818663", "総社",
"812979", "竜ケ崎",
"81742", "奈良",
"817912", "相生",
"812787", "沼田",
"812566", "三条",
"815988", "三瀬谷",
"81427", "相模原",
"8198295", "日向",
"819673", "熊本一の宮",
"81277", "桐生",
"814287", "青梅",
"812584", "長岡",
"811933", "釜石",
"812557", "新井",
"818558", "川本",
"812892", "宇都宮",
"818806", "宿毛",
"812579", "小出",
"811653", "士別",
"817726", "峰山",
"812672", "小諸",
"812834", "宇都宮",
"8147950", "八日市場",
"812995", "石岡",
"818542", "安来",
"811237", "栗山",
"812417", "会津山口",
"81434", "千葉",
"81922", "福岡",
"812476", "三春",
"815758", "郡上八幡",
"81564", "岡崎",
"8178", "神戸",
"812957", "大子",
"818958", "御荘",
"818368", "宇部",
"811533", "根室",
"81259", "佐渡",
"8163", "大阪",
"815588", "修善寺大仁",
"819726", "臼杵",
"81565", "豊田",
"815748", "美濃白川",
"818948", "宇和",
"812913", "鉾田",
"817702", "敦賀",
"818694", "岡山",
"81885", "小松島",
"817458", "大和榛原",
"819936", "加世田",
"818874", "安芸",
"817239", "寝屋川",
"8188090", "窪川",
"81553", "山梨",
"811865", "大館",
"812373", "村山",
"811643", "石狩深川",
"815982", "松阪",
"81722", "堺",
"81852", "松江",
"818552", "浜田",
"818685", "津山",
"8199347", "鹿児島",
"811352", "余市",
"812898", "鹿沼",
"812744", "藤岡",
"814776", "船橋",
"81942", "久留米",
"812678", "佐久",
"818677", "新見",
"814996", "八丈島",
"818548", "石見大田",
"812547", "村上",
"81892", "久万",
"815752", "関",
"819912", "中之島",
"811562", "本別",
"81572", "多治見",
"818952", "宇和島",
"818362", "宇部",
"812243", "白石",
"81593", "四日市",
"815582", "下田",
"819667", "水俣",
"817673", "羽咋",
"811465", "静内",
"818245", "三次",
"811634", "浜頓別",
"819597", "福江",
"8188092", "窪川",
"819974", "屋久島",
"819732", "日田",
"818836", "脇町",
"819825", "日向",
"817906", "播磨山崎",
"811975", "水沢",
"81936", "北九州",
"812853", "小山",
"8188091", "窪川",
"811587", "中湧別",
"812388", "長井",
"811554", "帯広",
"818387", "田万川",
"819785", "豊後高田",
"815764", "下呂",
"81845", "因島",
"81157", "北見",
"819555", "唐津",
"819682", "山鹿",
"811757", "野辺地",
"81487", "浦和",
"818474", "府中",
"817738", "舞鶴",
"812234", "仙台",
"814792", "銚子",
"818375", "美祢",
"817493", "彦根",
"817945", "加古川",
"815395", "浜松",
"818206", "柳井",
"81721", "富田林",
"812640", "長野",
"819574", "諫早",
"819955", "加治木",
"818586", "倉吉",
"81963", "熊本",
"81548", "榛原",
"815366", "設楽",
"815956", "上野",
"811364", "倶知安",
"811954", "二戸",
"81179", "三戸",
"811987", "遠野",
"818564", "益田",
"817688", "能都",
"818667", "井原",
"814757", "東金",
"819952", "大口",
"818656", "笠岡",
"8186997", "岡山瀬戸",
"81992", "鹿児島",
"811854", "男鹿",
"811937", "宮古",
"814283", "青梅",
"811524", "網走",
"815392", "浜松",
"812553", "上越",
"819677", "矢部",
"814240", "国分寺",
"811336", "石狩",
"818372", "長門",
"81543", "静岡",
"814795", "銚子",
"817942", "加古川",
"812783", "沼田",
"818512", "西郷",
"812413", "喜多方",
"819685", "玉名",
"819552", "伊万里",
"811233", "千歳",
"81952", "佐賀",
"817368", "岩出",
"817958", "丹波柏原",
"81229", "古川",
"819782", "豊後高田",
"815736", "中津川",
"811972", "水沢",
"811734", "五所川原",
"81985", "宮崎",
"818242", "東広島",
"811462", "浦河",
"819948", "志布志",
"811537", "中標津",
"811875", "角館",
"819735", "日田",
"818690", "岡山",
"81561", "瀬戸",
"819822", "延岡",
"81924", "福岡",
"81432", "千葉",
"81562", "尾張横須賀",
"817993", "洲本",
"815585", "下田",
"815755", "関",
"81863", "玉野",
"81583", "岐阜",
"818955", "宇和島",
"818365", "宇部",
"811374", "森",
"812644", "木曾福島",
"812998", "潮来",
"81725", "和泉",
"81878", "高松",
"815977", "熊野",
"81196", "盛岡",
"812230", "仙台",
"811454", "鵡川",
"815959", "亀山",
"81937", "北九州",
"818682", "津山",
"818555", "江津",
"818293", "廿日市",
"811862", "鹿角",
"819964", "川内",
"815985", "松阪",
"8153977", "天竜",
"818848", "牟岐",
"818794", "三本松",
"815994", "阿児",
"818464", "竹原",
"81486", "浦和",
"818974", "新居浜",
"817705", "小浜",
"818597", "根雨",
"81744", "大和高田",
"811397", "奥尻",
"81737", "湯浅",
"812857", "真岡",
"817474", "五条",
"8198294", "延岡",
"817354", "新宮",
"817964", "豊岡",
"819593", "大瀬戸",
"811753", "むつ",
"812675", "佐久",
"8188098", "土佐清水",
"818545", "木次",
"812992", "石岡",
"815563", "鰍沢青柳",
"81944", "瀬高",
"812895", "宇都宮",
"8198296", "日向",
"812934", "高萩",
"811583", "紋別",
"818383", "萩",
"814224", "武蔵野三鷹",
"812654", "飯田",
"81724", "岸和田貝塚",
"818688", "美作",
"81134", "小樽",
"817497", "長浜",
"8175", "京都",
"817915", "相生",
"811868", "鷹巣",
"818264", "安芸吉田",
"817455", "大和高田",
"818842", "阿南",
"81925", "福岡",
"819746", "竹田",
"811983", "花巻",
"812879", "烏山",
"815745", "美濃加茂",
"818493", "尾道",
"818945", "八幡浜",
"817685", "輪島",
"81984", "小林",
"812917", "水戸",
"81822", "広島",
"812569", "巻",
"815398", "浜松",
"812484", "白河",
"8128798", "大田原",
"819542", "武雄",
"812830", "宇都宮",
"812976", "竜ケ崎",
"811647", "羽幌",
"8112393", "夕張",
"817735", "福知山",
"812796", "渋川",
"819806", "沖縄宮古",
"817948", "三木",
"812377", "寒河江",
"818378", "下関",
"819558", "唐津",
"812543", "新発田",
"812580", "十日町",
"818673", "福渡",
"812385", "米沢",
"81792", "姫路",
"818893", "佐川",
"819788", "国東",
"817952", "西脇",
"817616", "小松",
"817362", "和歌山橋本",
"81276", "太田",
"817677", "七尾",
"814700", "鴨川",
"819663", "人吉",
"81249", "郡山",
"811978", "北上",
"819942", "大根占",
"812247", "大河原",
"818248", "庄原",
"819828", "高千穂",
"81426", "八王子",
"812576", "十日町",
"818805", "土佐中村",
"817674", "羽咋",
"817725", "宮津",
"8198292", "延岡",
"818398", "小郡",
"812996", "潮来",
"81765", "魚津",
"812244", "白石",
"819208", "対馬佐賀",
"8124197", "柳津",
"814280", "立川",
"8112397", "栗山",
"812475", "石川",
"812389", "米沢",
"81823", "呉",
"812550", "安塚",
"8198291", "延岡",
"812743", "藤岡",
"81964", "松橋",
"812965", "下館",
"812780", "前橋",
"81235", "鶴岡",
"812487", "須賀川",
"819742", "三重",
"818846", "丹生谷",
"812374", "村山",
"818391", "小郡",
"813", "東京",
"811644", "留萌",
"812565", "三条",
"818873", "安芸",
"81793", "姫路",
"812914", "鉾田",
"818693", "邑久",
"811953", "二戸",
"811363", "倶知安",
"812875", "大田原",
"818563", "益田",
"818949", "宇和",
"812792", "渋川",
"819802", "南大東",
"817485", "八日市",
"81928", "福岡",
"812695", "中野",
"8198290", "延岡",
"817459", "大和榛原",
"819546", "鹿島",
"812972", "水海道",
"817238", "寝屋川",
"8186552", "倉敷",
"812657", "伊那",
"81594", "桑名",
"819573", "諫早",
"81739", "田辺",
"812233", "岩沼",
"818267", "千代田",
"817494", "彦根",
"81950", "平戸",
"812899", "鹿沼",
"819946", "鹿屋",
"818473", "甲山",
"818290", "広島",
"812572", "柏崎",
"812937", "水戸",
"819232", "前原",
"811553", "帯広",
"812679", "佐久",
"814227", "武蔵野三鷹",
"818549", "石見大田",
"815738", "中津川",
"815763", "下呂",
"819438", "田主丸",
"8152", "名古屋",
"8147955", "八日市場",
"812854", "小山",
"817366", "岩出",
"817612", "小松",
"817956", "三田",
"817715", "亀岡",
"817967", "八鹿",
"817357", "串本",
"81554", "大月",
"819973", "種子島",
"815997", "阿児",
"81578", "神岡",
"811332", "当別",
"818467", "木江",
"818376", "美祢",
"819808", "八重山",
"812798", "長野原",
"81898", "今治",
"818797", "土庄",
"817946", "三木",
"812571", "六日町",
"814298", "飯能",
"81176", "十和田",
"818594", "米子",
"818205", "柳井",
"815396", "浜松",
"811394", "松前",
"81555", "吉田",
"812978", "竜ケ崎",
"818977", "伯方",
"819956", "加治木",
"81582", "岐阜",
"8188095", "土佐清水",
"818652", "倉敷",
"818585", "倉吉",
"81862", "岡山",
"817463", "吉野",
"815955", "上野",
"819967", "出水",
"811543", "釧路",
"81433", "千葉",
"81948", "飯塚",
"81563", "西尾",
"818559", "川本",
"812613", "大町",
"811466", "えりも",
"81728", "寝屋川",
"81875", "観音寺",
"812647", "長野",
"818246", "三次",
"812578", "六日町",
"814291", "飯能",
"818835", "脇町",
"81466", "藤沢",
"819826", "日向",
"811377", "八雲",
"811457", "門別富川",
"815974", "尾鷲",
"817905", "福崎",
"811976", "北上",
"815732", "恵那",
"81138", "函館",
"811943", "岩泉",
"819432", "八女",
"817618", "加賀",
"818369", "宇部",
"819786", "杵築",
"819556", "唐津",
"818490", "尾道",
"81939", "北九州",
"815589", "修善寺大仁",
"81542", "静岡",
"811737", "鰺ケ沢",
"8186993", "備前",
"814775", "船橋",
"81988", "那覇",
"811534", "中標津",
"81234", "酒田",
"812833", "宇都宮",
"81167", "富良野",
"811654", "名寄",
"819674", "熊本一の宮",
"819725", "佐伯",
"812583", "長岡",
"811934", "釜石",
"8182942", "広島",
"811527", "美幌",
"81965", "八代",
"8183768", "下関",
"819935", "加世田",
"8188099", "土佐清水",
"81581", "高富",
"811866", "鷹巣",
"814754", "茂原",
"814703", "館山",
"8182941", "広島",
"818664", "高梁",
"81227", "仙台",
"811857", "能代",
"818686", "津山",
"81764", "富山",};
my $timezones = {
               '' => [
                       'Asia/Tokyo'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[259]\d{6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;