#if   !defined(__OBJECTFACTORY_HPP)
#define  __OBJECTFACTORY_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__OBJECT_HPP)
#include <Object.hpp>
#endif

/**
ObjectFactory is responsible for creating new instances of Objects, deleting
Objects, or returning ones that already exists. 
*/

DECLARE_CLASS( ObjectFactory );

class ObjectFactory
{
public:

   //
   // Destructor
   //
                           /**
                           Destructor
                           */

                           ~ObjectFactory( void );

   //
   // Factory methdods
   //

            /**
            Creates a new unique identifier
            @return Identifier
            */

   static   DwordIdentifier  getNewIdentifier( void );

            /**
            Creates a new object using the unique
            identifier
            @param DwordIdentifier 
            @return Object const reference
            */

   static   ObjectCref  createObject( DwordIdentifier  );

            /**
            Destroys a object given it's identifier
            @param DwordIdentifier - object id to destroy
            */

   static   void        destroyObject( DwordIdentifier );

            /**
            Destroys a object 
            @param Object const reference - the object 
            to destroy.
            */

   static   void        destroyObject( ObjectCref );

            /**
            Destroys all objects managed by this
            Factory.
            */

   static   void        destroyAllObjects( void );

protected:


private:

   //
   // Constructors are not allowed 
   //
                           /// Default constructor

                           ObjectFactory( void );

                           /// Copy constructor

                           ObjectFactory( ObjectFactoryCref );
                     
   //
   // Operator not allowed 
   //
            /// Assignment operator
            
            ObjectFactoryRef  operator=( ObjectFactoryCref );

            /// Equality operator

            bool              operator==( ObjectFactoryCref ) const;

private:

            /// Current identifier marker

   static   DwordIdentifier  theCurrentIdentifier;

};

#endif // if !defined(__OBJECTFACTORY_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.3 $
   $Date: 2000/03/01 03:28:18 $
   $Locker:  $
*/

