/* main_window_build_tools.c generated by valac 0.23.2.3-f949, the Vala compiler
 * generated from main_window_build_tools.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "config.h"
#include <gtksourceview/gtksource.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;
typedef struct _MainWindowBuildToolsPrivate MainWindowBuildToolsPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;

#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;

#define TYPE_PERSONAL_BUILD_TOOLS (personal_build_tools_get_type ())
#define PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildTools))
#define PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))
#define IS_PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERSONAL_BUILD_TOOLS))
#define IS_PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERSONAL_BUILD_TOOLS))
#define PERSONAL_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))

typedef struct _PersonalBuildTools PersonalBuildTools;
typedef struct _PersonalBuildToolsClass PersonalBuildToolsClass;

#define TYPE_DEFAULT_BUILD_TOOLS (default_build_tools_get_type ())
#define DEFAULT_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildTools))
#define DEFAULT_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildToolsClass))
#define IS_DEFAULT_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_BUILD_TOOLS))
#define IS_DEFAULT_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_BUILD_TOOLS))
#define DEFAULT_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildToolsClass))

typedef struct _DefaultBuildTools DefaultBuildTools;
typedef struct _DefaultBuildToolsClass DefaultBuildToolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block20Data Block20Data;
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))

#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;

#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;
typedef struct _ParamSpecMainWindowBuildTools ParamSpecMainWindowBuildTools;

struct _MainWindowBuildTools {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowBuildToolsPrivate * priv;
};

struct _MainWindowBuildToolsClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowBuildTools *self);
};

struct _MainWindowBuildToolsPrivate {
	MainWindow* _main_window;
	GtkUIManager* _ui_manager;
	BuildView* _build_view;
	BottomPanel* _bottom_panel;
	GtkActionGroup* _static_action_group;
	GtkActionGroup* _dynamic_action_group;
	guint _menu_ui_id;
	BuildToolRunner* _build_tool_runner;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* _description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gchar* files_to_open;
	gboolean enabled;
	GeeArrayList* jobs;
	gint id;
};

struct _Block20Data {
	int _ref_count_;
	MainWindowBuildTools* self;
	GtkAction* stop_exec;
};

struct _ParamSpecMainWindowBuildTools {
	GParamSpec parent_instance;
};


static gpointer main_window_build_tools_parent_class = NULL;

gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_build_tools (GValue* value, gpointer v_object);
void value_take_main_window_build_tools (GValue* value, gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
GType bottom_panel_get_type (void) G_GNUC_CONST;
GType build_tool_runner_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsPrivate))
enum  {
	MAIN_WINDOW_BUILD_TOOLS_DUMMY_PROPERTY
};
void main_window_build_tools_on_clean (MainWindowBuildTools* self);
static void _main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_build_tools_on_stop_execution (MainWindowBuildTools* self);
static void _main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_build_tools_on_view_log (MainWindowBuildTools* self);
static void _main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_build_tools_on_preferences (MainWindowBuildTools* self);
static void _main_window_build_tools_on_preferences_gtk_action_callback (GtkAction* action, gpointer self);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
static void main_window_build_tools_update_menu (MainWindowBuildTools* self);
GType build_tools_get_type (void) G_GNUC_CONST;
GType personal_build_tools_get_type (void) G_GNUC_CONST;
PersonalBuildTools* personal_build_tools_get_default (void);
static void __lambda79_ (MainWindowBuildTools* self);
static void ___lambda79__build_tools_modified (BuildTools* _sender, gpointer self);
GType default_build_tools_get_type (void) G_GNUC_CONST;
DefaultBuildTools* default_build_tools_get_default (void);
static void __lambda80_ (MainWindowBuildTools* self);
static void ___lambda80__build_tools_modified (BuildTools* _sender, gpointer self);
void main_window_build_tools_set_build_view (MainWindowBuildTools* self, BuildView* build_view);
static void main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self);
void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self, BottomPanel* bottom_panel);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_is_main_file_a_tex_file (Document* self);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GeeIterator* build_tools_iterator (BuildTools* self);
static gchar* main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self, gint tool_num);
static void main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self, BuildTool* tool, const gchar* action_name);
static gchar* main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self, gint tool_num);
static BuildTool* main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self, const gchar* action_name);
BuildTool* build_tools_get_build_tool (BuildTools* self, gint tool_num);
GFile* document_get_location (Document* self);
gboolean build_tool_has_jobs (BuildTool *self);
GFile* document_get_main_file (Document* self);
gchar* utils_get_extension (const gchar* path);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
static void main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self, GtkAction* action);
static void _main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender, gpointer self);
gboolean build_tools_is_empty (BuildTools* self);
static void main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self, BuildTool* build_tool, const gchar* action_name, gint* accel_num);
static void main_window_build_tools_add_separator (MainWindowBuildTools* self);
gchar* build_tool_get_description (BuildTool *self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
gboolean document_set_tmp_location (Document* self);
gint document_get_project_id (Document* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GType latexila_get_type (void) G_GNUC_CONST;
Latexila* latexila_get_instance (void);
GeeList* latexila_get_documents (Latexila* self);
void utils_flush_queue (void);
BuildToolRunner* build_tool_runner_new (BuildTool* build_tool, GFile* on_file, BuildView* build_view);
BuildToolRunner* build_tool_runner_construct (GType object_type, BuildTool* build_tool, GFile* on_file, BuildView* build_view);
static void __lambda78_ (Block20Data* _data20_);
static void ___lambda78__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self);
void build_tool_runner_run (BuildToolRunner* self);
void build_tool_runner_abort (BuildToolRunner* self);
GType clean_build_files_get_type (void) G_GNUC_CONST;
CleanBuildFiles* clean_build_files_new (MainWindow* main_window, Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type, MainWindow* main_window, Document* doc);
void clean_build_files_clean (CleanBuildFiles* self);
gchar* utils_get_shortname (const gchar* path);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
Document* document_tab_get_document (DocumentTab* self);
void document_set_readonly (Document* self, gboolean value);
BuildToolsPreferences* build_tools_preferences_new (MainWindow* main_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type, MainWindow* main_window);
GType build_tools_preferences_get_type (void) G_GNUC_CONST;
static void main_window_build_tools_finalize (MainWindowBuildTools* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW_BUILD_TOOLS__action_entries[5] = {{"Build", NULL, "_Build"}, {"BuildClean", GTK_STOCK_CLEAR, "Cleanup Build _Files", NULL, "Clean-up build files (*.aux, *.log, *.out, *.toc, etc)", (GCallback) _main_window_build_tools_on_clean_gtk_action_callback}, {"BuildStopExecution", GTK_STOCK_STOP, "_Stop Execution", NULL, "Stop Execution", (GCallback) _main_window_build_tools_on_stop_execution_gtk_action_callback}, {"BuildViewLog", "view_log", "View _Log", NULL, "View Log", (GCallback) _main_window_build_tools_on_view_log_gtk_action_callback}, {"BuildToolsPreferences", GTK_STOCK_PREFERENCES, "_Manage Build Tools", NULL, "Manage Build Tools", (GCallback) _main_window_build_tools_on_preferences_gtk_action_callback}};
static const GtkToggleActionEntry MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries[3] = {{"BuildShowDetails", GTK_STOCK_ZOOM_IN, "Show _Details", NULL, "Show Details", (GCallback) NULL}, {"BuildShowWarnings", GTK_STOCK_DIALOG_WARNING, "Show _Warnings", NULL, "Show Warnings", (GCallback) NULL}, {"BuildShowBadBoxes", "badbox", "Show _Bad Boxes", NULL, "Show Bad Boxes", (GCallback) NULL}};

static void _main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_clean ((MainWindowBuildTools*) self);
}


static void _main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_stop_execution ((MainWindowBuildTools*) self);
}


static void _main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_view_log ((MainWindowBuildTools*) self);
}


static void _main_window_build_tools_on_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_preferences ((MainWindowBuildTools*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda79_ (MainWindowBuildTools* self) {
	main_window_build_tools_update_menu (self);
}


static void ___lambda79__build_tools_modified (BuildTools* _sender, gpointer self) {
	__lambda79_ ((MainWindowBuildTools*) self);
}


static void __lambda80_ (MainWindowBuildTools* self) {
	main_window_build_tools_update_menu (self);
}


static void ___lambda80__build_tools_modified (BuildTools* _sender, gpointer self) {
	__lambda80_ ((MainWindowBuildTools*) self);
}


MainWindowBuildTools* main_window_build_tools_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager) {
	MainWindowBuildTools* self = NULL;
	MainWindow* _tmp0_ = NULL;
	GtkUIManager* _tmp1_ = NULL;
	GtkUIManager* _tmp2_ = NULL;
	GtkActionGroup* _tmp3_ = NULL;
	GtkActionGroup* _tmp4_ = NULL;
	GtkActionGroup* _tmp5_ = NULL;
	GtkActionGroup* _tmp6_ = NULL;
	GtkAction* stop_exec = NULL;
	GtkActionGroup* _tmp7_ = NULL;
	GtkAction* _tmp8_ = NULL;
	GtkAction* _tmp9_ = NULL;
	GtkUIManager* _tmp10_ = NULL;
	GtkActionGroup* _tmp11_ = NULL;
	GtkActionGroup* _tmp12_ = NULL;
	GtkUIManager* _tmp13_ = NULL;
	GtkActionGroup* _tmp14_ = NULL;
	PersonalBuildTools* personal_build_tools = NULL;
	PersonalBuildTools* _tmp15_ = NULL;
	DefaultBuildTools* default_build_tools = NULL;
	DefaultBuildTools* _tmp16_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (MainWindowBuildTools*) g_type_create_instance (object_type);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = ui_manager;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = _tmp2_;
	_tmp3_ = gtk_action_group_new ("BuildMenuActionGroup");
	_g_object_unref0 (self->priv->_static_action_group);
	self->priv->_static_action_group = _tmp3_;
	_tmp4_ = self->priv->_static_action_group;
	gtk_action_group_set_translation_domain (_tmp4_, GETTEXT_PACKAGE);
	_tmp5_ = self->priv->_static_action_group;
	gtk_action_group_add_actions (_tmp5_, MAIN_WINDOW_BUILD_TOOLS__action_entries, G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__action_entries), self);
	_tmp6_ = self->priv->_static_action_group;
	gtk_action_group_add_toggle_actions (_tmp6_, MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries, G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries), self);
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildStopExecution");
	_tmp9_ = _g_object_ref0 (_tmp8_);
	stop_exec = _tmp9_;
	gtk_action_set_sensitive (stop_exec, FALSE);
	_tmp10_ = ui_manager;
	_tmp11_ = self->priv->_static_action_group;
	gtk_ui_manager_insert_action_group (_tmp10_, _tmp11_, 0);
	_tmp12_ = gtk_action_group_new ("BuildToolsActions");
	_g_object_unref0 (self->priv->_dynamic_action_group);
	self->priv->_dynamic_action_group = _tmp12_;
	_tmp13_ = ui_manager;
	_tmp14_ = self->priv->_dynamic_action_group;
	gtk_ui_manager_insert_action_group (_tmp13_, _tmp14_, 0);
	main_window_build_tools_update_menu (self);
	_tmp15_ = personal_build_tools_get_default ();
	personal_build_tools = _tmp15_;
	g_signal_connect ((BuildTools*) personal_build_tools, "modified", (GCallback) ___lambda79__build_tools_modified, self);
	_tmp16_ = default_build_tools_get_default ();
	default_build_tools = _tmp16_;
	g_signal_connect ((BuildTools*) default_build_tools, "modified", (GCallback) ___lambda80__build_tools_modified, self);
	_g_object_unref0 (default_build_tools);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (stop_exec);
	return self;
}


MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window, GtkUIManager* ui_manager) {
	return main_window_build_tools_construct (TYPE_MAIN_WINDOW_BUILD_TOOLS, main_window, ui_manager);
}


void main_window_build_tools_set_build_view (MainWindowBuildTools* self, BuildView* build_view) {
	BuildView* _tmp0_ = NULL;
	BuildView* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_view != NULL);
	_tmp0_ = build_view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_build_view);
	self->priv->_build_view = _tmp1_;
	main_window_build_tools_connect_toggle_actions (self);
}


void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self, BottomPanel* bottom_panel) {
	BottomPanel* _tmp0_ = NULL;
	BottomPanel* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bottom_panel != NULL);
	_tmp0_ = bottom_panel;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_bottom_panel);
	self->priv->_bottom_panel = _tmp1_;
}


void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self) {
	GtkAction* clean_action = NULL;
	GtkActionGroup* _tmp0_ = NULL;
	GtkAction* _tmp1_ = NULL;
	GtkAction* _tmp2_ = NULL;
	GtkAction* view_log_action = NULL;
	GtkActionGroup* _tmp3_ = NULL;
	GtkAction* _tmp4_ = NULL;
	GtkAction* _tmp5_ = NULL;
	MainWindow* _tmp6_ = NULL;
	DocumentTab* _tmp7_ = NULL;
	DocumentTab* _tmp8_ = NULL;
	GtkActionGroup* _tmp12_ = NULL;
	gboolean is_tex = FALSE;
	MainWindow* _tmp13_ = NULL;
	Document* _tmp14_ = NULL;
	Document* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GtkAction* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GtkAction* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gint tool_num = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_static_action_group;
	_tmp1_ = gtk_action_group_get_action (_tmp0_, "BuildClean");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clean_action = _tmp2_;
	_tmp3_ = self->priv->_static_action_group;
	_tmp4_ = gtk_action_group_get_action (_tmp3_, "BuildViewLog");
	_tmp5_ = _g_object_ref0 (_tmp4_);
	view_log_action = _tmp5_;
	_tmp6_ = self->priv->_main_window;
	_tmp7_ = main_window_get_active_tab (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		GtkActionGroup* _tmp9_ = NULL;
		GtkAction* _tmp10_ = NULL;
		GtkAction* _tmp11_ = NULL;
		_tmp9_ = self->priv->_dynamic_action_group;
		gtk_action_group_set_sensitive (_tmp9_, FALSE);
		_tmp10_ = clean_action;
		gtk_action_set_sensitive (_tmp10_, FALSE);
		_tmp11_ = view_log_action;
		gtk_action_set_sensitive (_tmp11_, FALSE);
		_g_object_unref0 (view_log_action);
		_g_object_unref0 (clean_action);
		return;
	}
	_tmp12_ = self->priv->_dynamic_action_group;
	gtk_action_group_set_sensitive (_tmp12_, TRUE);
	_tmp13_ = self->priv->_main_window;
	_tmp14_ = main_window_get_active_document (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = document_is_main_file_a_tex_file (_tmp15_);
	is_tex = _tmp16_;
	_tmp17_ = clean_action;
	_tmp18_ = is_tex;
	gtk_action_set_sensitive (_tmp17_, _tmp18_);
	_tmp19_ = view_log_action;
	_tmp20_ = is_tex;
	gtk_action_set_sensitive (_tmp19_, _tmp20_);
	tool_num = 0;
	{
		GeeIterator* _tool_it = NULL;
		DefaultBuildTools* _tmp21_ = NULL;
		DefaultBuildTools* _tmp22_ = NULL;
		GeeIterator* _tmp23_ = NULL;
		GeeIterator* _tmp24_ = NULL;
		_tmp21_ = default_build_tools_get_default ();
		_tmp22_ = _tmp21_;
		_tmp23_ = build_tools_iterator ((BuildTools*) _tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		_tool_it = _tmp24_;
		while (TRUE) {
			GeeIterator* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			BuildTool tool = {0};
			GeeIterator* _tmp27_ = NULL;
			gpointer _tmp28_ = NULL;
			BuildTool* _tmp29_ = NULL;
			BuildTool _tmp30_ = {0};
			BuildTool _tmp31_ = {0};
			gchar* action_name = NULL;
			gint _tmp32_ = 0;
			gchar* _tmp33_ = NULL;
			BuildTool _tmp34_ = {0};
			const gchar* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			_tmp25_ = _tool_it;
			_tmp26_ = gee_iterator_next (_tmp25_);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = _tool_it;
			_tmp28_ = gee_iterator_get (_tmp27_);
			_tmp29_ = (BuildTool*) _tmp28_;
			build_tool_copy (_tmp29_, &_tmp30_);
			_tmp31_ = _tmp30_;
			_build_tool_free0 (_tmp29_);
			tool = _tmp31_;
			_tmp32_ = tool_num;
			_tmp33_ = main_window_build_tools_get_default_build_tool_name (self, _tmp32_);
			action_name = _tmp33_;
			_tmp34_ = tool;
			_tmp35_ = action_name;
			main_window_build_tools_update_build_tool_sensitivity (self, &_tmp34_, _tmp35_);
			_tmp36_ = tool_num;
			tool_num = _tmp36_ + 1;
			_g_free0 (action_name);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
	tool_num = 0;
	{
		GeeIterator* _tool_it = NULL;
		PersonalBuildTools* _tmp37_ = NULL;
		PersonalBuildTools* _tmp38_ = NULL;
		GeeIterator* _tmp39_ = NULL;
		GeeIterator* _tmp40_ = NULL;
		_tmp37_ = personal_build_tools_get_default ();
		_tmp38_ = _tmp37_;
		_tmp39_ = build_tools_iterator ((BuildTools*) _tmp38_);
		_tmp40_ = _tmp39_;
		_g_object_unref0 (_tmp38_);
		_tool_it = _tmp40_;
		while (TRUE) {
			GeeIterator* _tmp41_ = NULL;
			gboolean _tmp42_ = FALSE;
			BuildTool tool = {0};
			GeeIterator* _tmp43_ = NULL;
			gpointer _tmp44_ = NULL;
			BuildTool* _tmp45_ = NULL;
			BuildTool _tmp46_ = {0};
			BuildTool _tmp47_ = {0};
			gchar* action_name = NULL;
			gint _tmp48_ = 0;
			gchar* _tmp49_ = NULL;
			BuildTool _tmp50_ = {0};
			const gchar* _tmp51_ = NULL;
			gint _tmp52_ = 0;
			_tmp41_ = _tool_it;
			_tmp42_ = gee_iterator_next (_tmp41_);
			if (!_tmp42_) {
				break;
			}
			_tmp43_ = _tool_it;
			_tmp44_ = gee_iterator_get (_tmp43_);
			_tmp45_ = (BuildTool*) _tmp44_;
			build_tool_copy (_tmp45_, &_tmp46_);
			_tmp47_ = _tmp46_;
			_build_tool_free0 (_tmp45_);
			tool = _tmp47_;
			_tmp48_ = tool_num;
			_tmp49_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp48_);
			action_name = _tmp49_;
			_tmp50_ = tool;
			_tmp51_ = action_name;
			main_window_build_tools_update_build_tool_sensitivity (self, &_tmp50_, _tmp51_);
			_tmp52_ = tool_num;
			tool_num = _tmp52_ + 1;
			_g_free0 (action_name);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
	_g_object_unref0 (view_log_action);
	_g_object_unref0 (clean_action);
}


static gchar* main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self, gint tool_num) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tool_num;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("DefaultBuildTool_", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gchar* main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self, gint tool_num) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tool_num;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("PersonalBuildTool_", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static BuildTool* main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self, const gchar* action_name) {
	BuildTool* result = NULL;
	BuildTools* build_tools = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar** name = NULL;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint name_length1 = 0;
	gint _name_size_ = 0;
	gint tool_num = 0;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	BuildTools* _tmp11_ = NULL;
	BuildTool* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	_tmp0_ = action_name;
	_tmp1_ = g_str_has_prefix (_tmp0_, "DefaultBuildTool_");
	if (_tmp1_) {
		DefaultBuildTools* _tmp2_ = NULL;
		_tmp2_ = default_build_tools_get_default ();
		_g_object_unref0 (build_tools);
		build_tools = (BuildTools*) _tmp2_;
	} else {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = action_name;
		_tmp4_ = g_str_has_prefix (_tmp3_, "PersonalBuildTool_");
		if (_tmp4_) {
			PersonalBuildTools* _tmp5_ = NULL;
			_tmp5_ = personal_build_tools_get_default ();
			_g_object_unref0 (build_tools);
			build_tools = (BuildTools*) _tmp5_;
		} else {
			g_return_val_if_reached (NULL);
		}
	}
	_tmp6_ = action_name;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "_", 0);
	name = _tmp8_;
	name_length1 = _vala_array_length (_tmp7_);
	_name_size_ = name_length1;
	g_return_val_if_fail (name_length1 == 2, NULL);
	_tmp9_ = name[1];
	_tmp10_ = atoi (_tmp9_);
	tool_num = _tmp10_;
	_tmp11_ = build_tools;
	_tmp12_ = build_tools_get_build_tool (_tmp11_, tool_num);
	result = _tmp12_;
	name = (_vala_array_free (name, name_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (build_tools);
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self, BuildTool* tool, const gchar* action_name) {
	BuildTool _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkAction* _tmp4_ = NULL;
	GtkAction* _tmp5_ = NULL;
	Document* active_doc = NULL;
	MainWindow* _tmp6_ = NULL;
	Document* _tmp7_ = NULL;
	Document* _tmp8_ = NULL;
	Document* _tmp9_ = NULL;
	gboolean unsaved_doc = FALSE;
	Document* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gchar* path = NULL;
	Document* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	GFile* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* ext = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar** extensions = NULL;
	BuildTool _tmp23_ = {0};
	const gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint extensions_length1 = 0;
	gint _extensions_size_ = 0;
	gboolean _tmp27_ = FALSE;
	BuildTool _tmp28_ = {0};
	const gchar* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gboolean sensitive = FALSE;
	GtkAction* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	g_return_if_fail (action_name != NULL);
	_tmp0_ = *tool;
	_tmp1_ = _tmp0_.enabled;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->_dynamic_action_group;
	_tmp3_ = action_name;
	_tmp4_ = gtk_action_group_get_action (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	action = _tmp5_;
	_tmp6_ = self->priv->_main_window;
	_tmp7_ = main_window_get_active_document (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	active_doc = _tmp9_;
	_tmp10_ = active_doc;
	_tmp11_ = document_get_location (_tmp10_);
	_tmp12_ = _tmp11_;
	unsaved_doc = _tmp12_ == NULL;
	_tmp13_ = unsaved_doc;
	if (_tmp13_) {
		GtkAction* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = action;
		_tmp15_ = build_tool_has_jobs (tool);
		gtk_action_set_sensitive (_tmp14_, _tmp15_);
		_g_object_unref0 (active_doc);
		_g_object_unref0 (action);
		return;
	}
	_tmp16_ = active_doc;
	_tmp17_ = document_get_main_file (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_file_get_parse_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp18_);
	path = _tmp20_;
	_tmp21_ = path;
	_tmp22_ = utils_get_extension (_tmp21_);
	ext = _tmp22_;
	_tmp23_ = *tool;
	_tmp24_ = _tmp23_.extensions;
	_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, " ", 0);
	extensions = _tmp26_;
	extensions_length1 = _vala_array_length (_tmp25_);
	_extensions_size_ = extensions_length1;
	_tmp28_ = *tool;
	_tmp29_ = _tmp28_.extensions;
	_tmp30_ = strlen (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == 0) {
		_tmp27_ = TRUE;
	} else {
		const gchar* _tmp32_ = NULL;
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		_tmp32_ = ext;
		_tmp33_ = extensions;
		_tmp33__length1 = extensions_length1;
		_tmp27_ = _vala_string_array_contains (_tmp33_, _tmp33__length1, _tmp32_);
	}
	sensitive = _tmp27_;
	_tmp34_ = action;
	_tmp35_ = sensitive;
	gtk_action_set_sensitive (_tmp34_, _tmp35_);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ext);
	_g_free0 (path);
	_g_object_unref0 (active_doc);
	_g_object_unref0 (action);
}


void main_window_build_tools_save_state (MainWindowBuildTools* self) {
	GSettings* settings = NULL;
	GSettings* _tmp0_ = NULL;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_ = NULL;
	GtkAction* _tmp2_ = NULL;
	GtkToggleAction* _tmp3_ = NULL;
	GtkToggleAction* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkActionGroup* _tmp7_ = NULL;
	GtkAction* _tmp8_ = NULL;
	GtkToggleAction* _tmp9_ = NULL;
	GtkToggleAction* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings = _tmp0_;
	_tmp1_ = self->priv->_static_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildShowWarnings");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp2_) : NULL);
	action = _tmp3_;
	_tmp4_ = action;
	_tmp5_ = gtk_toggle_action_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (settings, "show-build-warnings", _tmp6_);
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowBadBoxes");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp8_) : NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	_tmp11_ = gtk_toggle_action_get_active (_tmp10_);
	_tmp12_ = _tmp11_;
	g_settings_set_boolean (settings, "show-build-badboxes", _tmp12_);
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
}


static void _main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_build_tools_activate_dynamic_action ((MainWindowBuildTools*) self, _sender);
}


static void main_window_build_tools_update_menu (MainWindowBuildTools* self) {
	GtkActionGroup* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkActionGroup* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	DefaultBuildTools* default_build_tools = NULL;
	DefaultBuildTools* _tmp11_ = NULL;
	PersonalBuildTools* personal_build_tools = NULL;
	PersonalBuildTools* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	DefaultBuildTools* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GtkUIManager* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	gint tool_num = 0;
	gint accel_num = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dynamic_action_group;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_menu_ui_id;
	if (_tmp1_ != ((guint) 0)) {
		GtkUIManager* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		_tmp2_ = self->priv->_ui_manager;
		_tmp3_ = self->priv->_menu_ui_id;
		gtk_ui_manager_remove_ui (_tmp2_, _tmp3_);
	}
	_tmp4_ = self->priv->_dynamic_action_group;
	_tmp5_ = gtk_action_group_list_actions (_tmp4_);
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp5_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* _tmp6_ = NULL;
			GtkAction* action = NULL;
			_tmp6_ = _g_object_ref0 ((GtkAction*) action_it->data);
			action = _tmp6_;
			{
				GtkAction* _tmp7_ = NULL;
				guint _tmp8_ = 0U;
				GtkActionGroup* _tmp9_ = NULL;
				GtkAction* _tmp10_ = NULL;
				_tmp7_ = action;
				g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp8_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
				_tmp9_ = self->priv->_dynamic_action_group;
				_tmp10_ = action;
				gtk_action_group_remove_action (_tmp9_, _tmp10_);
				_g_object_unref0 (action);
			}
		}
		_g_list_free0 (action_collection);
	}
	_tmp11_ = default_build_tools_get_default ();
	default_build_tools = _tmp11_;
	_tmp12_ = personal_build_tools_get_default ();
	personal_build_tools = _tmp12_;
	_tmp14_ = default_build_tools;
	_tmp15_ = build_tools_is_empty ((BuildTools*) _tmp14_);
	if (_tmp15_) {
		PersonalBuildTools* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = personal_build_tools;
		_tmp17_ = build_tools_is_empty ((BuildTools*) _tmp16_);
		_tmp13_ = _tmp17_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		self->priv->_menu_ui_id = (guint) 0;
		_g_object_unref0 (personal_build_tools);
		_g_object_unref0 (default_build_tools);
		return;
	}
	_tmp18_ = self->priv->_ui_manager;
	_tmp19_ = gtk_ui_manager_new_merge_id (_tmp18_);
	self->priv->_menu_ui_id = _tmp19_;
	tool_num = 0;
	accel_num = 2;
	{
		GeeIterator* _build_tool_it = NULL;
		DefaultBuildTools* _tmp20_ = NULL;
		GeeIterator* _tmp21_ = NULL;
		_tmp20_ = default_build_tools;
		_tmp21_ = build_tools_iterator ((BuildTools*) _tmp20_);
		_build_tool_it = _tmp21_;
		while (TRUE) {
			GeeIterator* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			BuildTool build_tool = {0};
			GeeIterator* _tmp24_ = NULL;
			gpointer _tmp25_ = NULL;
			BuildTool* _tmp26_ = NULL;
			BuildTool _tmp27_ = {0};
			BuildTool _tmp28_ = {0};
			gchar* action_name = NULL;
			gint _tmp29_ = 0;
			gchar* _tmp30_ = NULL;
			BuildTool _tmp31_ = {0};
			const gchar* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			_tmp22_ = _build_tool_it;
			_tmp23_ = gee_iterator_next (_tmp22_);
			if (!_tmp23_) {
				break;
			}
			_tmp24_ = _build_tool_it;
			_tmp25_ = gee_iterator_get (_tmp24_);
			_tmp26_ = (BuildTool*) _tmp25_;
			build_tool_copy (_tmp26_, &_tmp27_);
			_tmp28_ = _tmp27_;
			_build_tool_free0 (_tmp26_);
			build_tool = _tmp28_;
			_tmp29_ = tool_num;
			_tmp30_ = main_window_build_tools_get_default_build_tool_name (self, _tmp29_);
			action_name = _tmp30_;
			_tmp31_ = build_tool;
			_tmp32_ = action_name;
			main_window_build_tools_add_dynamic_action (self, &_tmp31_, _tmp32_, &accel_num);
			_tmp33_ = tool_num;
			tool_num = _tmp33_ + 1;
			_g_free0 (action_name);
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_it);
	}
	main_window_build_tools_add_separator (self);
	tool_num = 0;
	{
		GeeIterator* _build_tool_it = NULL;
		PersonalBuildTools* _tmp34_ = NULL;
		GeeIterator* _tmp35_ = NULL;
		_tmp34_ = personal_build_tools;
		_tmp35_ = build_tools_iterator ((BuildTools*) _tmp34_);
		_build_tool_it = _tmp35_;
		while (TRUE) {
			GeeIterator* _tmp36_ = NULL;
			gboolean _tmp37_ = FALSE;
			BuildTool build_tool = {0};
			GeeIterator* _tmp38_ = NULL;
			gpointer _tmp39_ = NULL;
			BuildTool* _tmp40_ = NULL;
			BuildTool _tmp41_ = {0};
			BuildTool _tmp42_ = {0};
			gchar* action_name = NULL;
			gint _tmp43_ = 0;
			gchar* _tmp44_ = NULL;
			BuildTool _tmp45_ = {0};
			const gchar* _tmp46_ = NULL;
			gint _tmp47_ = 0;
			_tmp36_ = _build_tool_it;
			_tmp37_ = gee_iterator_next (_tmp36_);
			if (!_tmp37_) {
				break;
			}
			_tmp38_ = _build_tool_it;
			_tmp39_ = gee_iterator_get (_tmp38_);
			_tmp40_ = (BuildTool*) _tmp39_;
			build_tool_copy (_tmp40_, &_tmp41_);
			_tmp42_ = _tmp41_;
			_build_tool_free0 (_tmp40_);
			build_tool = _tmp42_;
			_tmp43_ = tool_num;
			_tmp44_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp43_);
			action_name = _tmp44_;
			_tmp45_ = build_tool;
			_tmp46_ = action_name;
			main_window_build_tools_add_dynamic_action (self, &_tmp45_, _tmp46_, &accel_num);
			_tmp47_ = tool_num;
			tool_num = _tmp47_ + 1;
			_g_free0 (action_name);
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_it);
	}
	main_window_build_tools_update_sensitivity (self);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (default_build_tools);
}


static void main_window_build_tools_add_separator (MainWindowBuildTools* self) {
	GtkUIManager* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkUIManager* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp0_, _tmp1_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
	_tmp2_ = self->priv->_ui_manager;
	_tmp3_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp2_, _tmp3_, "/MainToolbar/BuildToolsPlaceholderToolbar", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
}


static void main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self, BuildTool* build_tool, const gchar* action_name, gint* accel_num) {
	BuildTool _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GtkAction* action = NULL;
	const gchar* _tmp2_ = NULL;
	BuildTool _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	BuildTool _tmp7_ = {0};
	const gchar* _tmp8_ = NULL;
	GtkAction* _tmp9_ = NULL;
	GtkAction* _tmp10_ = NULL;
	gchar* accel = NULL;
	gint _tmp11_ = 0;
	GtkActionGroup* _tmp16_ = NULL;
	GtkAction* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkAction* _tmp19_ = NULL;
	GtkUIManager* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkUIManager* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tool != NULL);
	g_return_if_fail (action_name != NULL);
	_tmp0_ = *build_tool;
	_tmp1_ = _tmp0_.enabled;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action_name;
	_tmp3_ = *build_tool;
	_tmp4_ = _tmp3_.label;
	_tmp5_ = build_tool_get_description (build_tool);
	_tmp6_ = _tmp5_;
	_tmp7_ = *build_tool;
	_tmp8_ = _tmp7_.icon;
	_tmp9_ = gtk_action_new (_tmp2_, _tmp4_, _tmp6_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp6_);
	action = _tmp10_;
	accel = NULL;
	_tmp11_ = *accel_num;
	if (_tmp11_ <= 11) {
		gint _tmp12_ = 0;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp12_ = *accel_num;
		_tmp13_ = g_strdup_printf ("%i", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat ("<Release>F", _tmp14_, NULL);
		_g_free0 (accel);
		accel = _tmp15_;
		_g_free0 (_tmp14_);
	}
	_tmp16_ = self->priv->_dynamic_action_group;
	_tmp17_ = action;
	_tmp18_ = accel;
	gtk_action_group_add_action_with_accel (_tmp16_, _tmp17_, _tmp18_);
	_tmp19_ = action;
	g_signal_connect (_tmp19_, "activate", (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
	_tmp20_ = self->priv->_ui_manager;
	_tmp21_ = self->priv->_menu_ui_id;
	_tmp22_ = action_name;
	_tmp23_ = action_name;
	gtk_ui_manager_add_ui (_tmp20_, _tmp21_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", _tmp22_, _tmp23_, GTK_UI_MANAGER_MENUITEM, FALSE);
	_tmp24_ = self->priv->_ui_manager;
	_tmp25_ = self->priv->_menu_ui_id;
	_tmp26_ = action_name;
	_tmp27_ = action_name;
	gtk_ui_manager_add_ui (_tmp24_, _tmp25_, "/MainToolbar/BuildToolsPlaceholderToolbar", _tmp26_, _tmp27_, GTK_UI_MANAGER_TOOLITEM, FALSE);
	_tmp28_ = *accel_num;
	*accel_num = _tmp28_ + 1;
	_g_free0 (accel);
	_g_object_unref0 (action);
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		MainWindowBuildTools* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->stop_exec);
		_main_window_build_tools_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}


static void __lambda78_ (Block20Data* _data20_) {
	MainWindowBuildTools* self;
	self = _data20_->self;
	gtk_action_set_sensitive (_data20_->stop_exec, FALSE);
}


static void ___lambda78__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self) {
	__lambda78_ (self);
}


static void main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self, GtkAction* action) {
	Block20Data* _data20_;
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	BuildView* _tmp3_ = NULL;
	BottomPanel* _tmp4_ = NULL;
	BuildTool* tool = NULL;
	GtkAction* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	BuildTool* _tmp8_ = NULL;
	BuildTool* _tmp9_ = NULL;
	Document* active_doc = NULL;
	MainWindow* _tmp10_ = NULL;
	Document* _tmp11_ = NULL;
	Document* _tmp12_ = NULL;
	Document* _tmp13_ = NULL;
	BuildTool* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	BuildTool* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	BottomPanel* _tmp52_ = NULL;
	GtkActionGroup* _tmp53_ = NULL;
	GtkAction* _tmp54_ = NULL;
	GtkAction* _tmp55_ = NULL;
	GFile* main_file = NULL;
	Document* _tmp56_ = NULL;
	GFile* _tmp57_ = NULL;
	BuildTool* _tmp58_ = NULL;
	BuildView* _tmp59_ = NULL;
	BuildTool _tmp60_ = {0};
	BuildToolRunner* _tmp61_ = NULL;
	BuildToolRunner* _tmp62_ = NULL;
	BuildToolRunner* _tmp63_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = main_window_build_tools_ref (self);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_build_view;
	g_return_if_fail (_tmp3_ != NULL);
	_tmp4_ = self->priv->_bottom_panel;
	g_return_if_fail (_tmp4_ != NULL);
	_tmp5_ = action;
	_tmp6_ = gtk_action_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = main_window_build_tools_get_build_tool_from_name (self, _tmp7_);
	tool = _tmp8_;
	_tmp9_ = tool;
	g_return_if_fail (_tmp9_ != NULL);
	_tmp10_ = self->priv->_main_window;
	_tmp11_ = main_window_get_active_document (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	active_doc = _tmp13_;
	_tmp14_ = tool;
	_tmp15_ = build_tool_has_jobs (_tmp14_);
	if (!_tmp15_) {
		Document* _tmp16_ = NULL;
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		_tmp16_ = active_doc;
		_tmp17_ = document_get_location (_tmp16_);
		_tmp18_ = _tmp17_;
		g_return_if_fail (_tmp18_ != NULL);
	}
	_tmp19_ = tool;
	_tmp20_ = build_tool_has_jobs (_tmp19_);
	if (_tmp20_) {
		Document* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
		gint project_id = 0;
		Document* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp21_ = active_doc;
		_tmp22_ = document_get_location (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ == NULL) {
			gboolean tmp_location_set = FALSE;
			Document* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			_tmp24_ = active_doc;
			_tmp25_ = document_set_tmp_location (_tmp24_);
			tmp_location_set = _tmp25_;
			_tmp26_ = tmp_location_set;
			g_return_if_fail (_tmp26_);
		}
		_tmp27_ = active_doc;
		_tmp28_ = document_get_project_id (_tmp27_);
		_tmp29_ = _tmp28_;
		project_id = _tmp29_;
		_tmp30_ = project_id;
		if (_tmp30_ == (-1)) {
			Document* _tmp31_ = NULL;
			_tmp31_ = active_doc;
			document_save (_tmp31_, TRUE, FALSE);
		} else {
			GeeList* docs = NULL;
			Latexila* _tmp32_ = NULL;
			Latexila* _tmp33_ = NULL;
			GeeList* _tmp34_ = NULL;
			GeeList* _tmp35_ = NULL;
			_tmp32_ = latexila_get_instance ();
			_tmp33_ = _tmp32_;
			_tmp34_ = latexila_get_documents (_tmp33_);
			_tmp35_ = _tmp34_;
			_g_object_unref0 (_tmp33_);
			docs = _tmp35_;
			{
				GeeList* _doc_list = NULL;
				GeeList* _tmp36_ = NULL;
				GeeList* _tmp37_ = NULL;
				gint _doc_size = 0;
				GeeList* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _doc_index = 0;
				_tmp36_ = docs;
				_tmp37_ = _g_object_ref0 (_tmp36_);
				_doc_list = _tmp37_;
				_tmp38_ = _doc_list;
				_tmp39_ = gee_collection_get_size ((GeeCollection*) _tmp38_);
				_tmp40_ = _tmp39_;
				_doc_size = _tmp40_;
				_doc_index = -1;
				while (TRUE) {
					gint _tmp41_ = 0;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					Document* doc = NULL;
					GeeList* _tmp44_ = NULL;
					gint _tmp45_ = 0;
					gpointer _tmp46_ = NULL;
					Document* _tmp47_ = NULL;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					gint _tmp50_ = 0;
					_tmp41_ = _doc_index;
					_doc_index = _tmp41_ + 1;
					_tmp42_ = _doc_index;
					_tmp43_ = _doc_size;
					if (!(_tmp42_ < _tmp43_)) {
						break;
					}
					_tmp44_ = _doc_list;
					_tmp45_ = _doc_index;
					_tmp46_ = gee_list_get (_tmp44_, _tmp45_);
					doc = (Document*) _tmp46_;
					_tmp47_ = doc;
					_tmp48_ = document_get_project_id (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = project_id;
					if (_tmp49_ == _tmp50_) {
						Document* _tmp51_ = NULL;
						_tmp51_ = doc;
						document_save (_tmp51_, TRUE, FALSE);
					}
					_g_object_unref0 (doc);
				}
				_g_object_unref0 (_doc_list);
			}
			_g_object_unref0 (docs);
		}
		utils_flush_queue ();
	}
	_tmp52_ = self->priv->_bottom_panel;
	gtk_widget_show ((GtkWidget*) _tmp52_);
	_tmp53_ = self->priv->_static_action_group;
	_tmp54_ = gtk_action_group_get_action (_tmp53_, "BuildStopExecution");
	_tmp55_ = _g_object_ref0 (_tmp54_);
	_data20_->stop_exec = _tmp55_;
	gtk_action_set_sensitive (_data20_->stop_exec, TRUE);
	_tmp56_ = active_doc;
	_tmp57_ = document_get_main_file (_tmp56_);
	main_file = _tmp57_;
	_tmp58_ = tool;
	_tmp59_ = self->priv->_build_view;
	_tmp60_ = *_tmp58_;
	_tmp61_ = build_tool_runner_new (&_tmp60_, main_file, _tmp59_);
	_g_object_unref0 (self->priv->_build_tool_runner);
	self->priv->_build_tool_runner = _tmp61_;
	_tmp62_ = self->priv->_build_tool_runner;
	g_signal_connect_data (_tmp62_, "finished", (GCallback) ___lambda78__build_tool_runner_finished, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_tmp63_ = self->priv->_build_tool_runner;
	build_tool_runner_run (_tmp63_);
	_g_object_unref0 (main_file);
	_g_object_unref0 (active_doc);
	_build_tool_free0 (tool);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}


static void main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self) {
	BuildView* _tmp0_ = NULL;
	GSettings* settings = NULL;
	GSettings* _tmp1_ = NULL;
	GtkToggleAction* action_details = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GtkAction* _tmp3_ = NULL;
	GtkToggleAction* _tmp4_ = NULL;
	BuildView* _tmp5_ = NULL;
	BuildView* _tmp6_ = NULL;
	GtkToggleAction* action_warnings = NULL;
	GtkActionGroup* _tmp7_ = NULL;
	GtkAction* _tmp8_ = NULL;
	GtkToggleAction* _tmp9_ = NULL;
	BuildView* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GtkToggleAction* action_badboxes = NULL;
	GtkActionGroup* _tmp12_ = NULL;
	GtkAction* _tmp13_ = NULL;
	GtkToggleAction* _tmp14_ = NULL;
	BuildView* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_build_view;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings = _tmp1_;
	_tmp2_ = self->priv->_static_action_group;
	_tmp3_ = gtk_action_group_get_action (_tmp2_, "BuildShowDetails");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp3_) : NULL);
	action_details = _tmp4_;
	_tmp5_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) action_details, "active", (GObject*) _tmp5_, "show-details", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp6_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) _tmp6_, "has-details", (GObject*) action_details, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	gtk_toggle_action_set_active (action_details, FALSE);
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowWarnings");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp8_) : NULL);
	action_warnings = _tmp9_;
	_tmp10_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) _tmp10_, "show-warnings", (GObject*) action_warnings, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp11_ = g_settings_get_boolean (settings, "show-build-warnings");
	gtk_toggle_action_set_active (action_warnings, _tmp11_);
	_tmp12_ = self->priv->_static_action_group;
	_tmp13_ = gtk_action_group_get_action (_tmp12_, "BuildShowBadBoxes");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp13_) : NULL);
	action_badboxes = _tmp14_;
	_tmp15_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) _tmp15_, "show-badboxes", (GObject*) action_badboxes, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp16_ = g_settings_get_boolean (settings, "show-build-badboxes");
	gtk_toggle_action_set_active (action_badboxes, _tmp16_);
	_g_object_unref0 (action_badboxes);
	_g_object_unref0 (action_warnings);
	_g_object_unref0 (action_details);
	_g_object_unref0 (settings);
}


void main_window_build_tools_on_stop_execution (MainWindowBuildTools* self) {
	BuildToolRunner* _tmp0_ = NULL;
	BuildToolRunner* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_build_tool_runner;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_build_tool_runner;
	build_tool_runner_abort (_tmp1_);
}


void main_window_build_tools_on_clean (MainWindowBuildTools* self) {
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	CleanBuildFiles* build_files = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	Document* _tmp5_ = NULL;
	Document* _tmp6_ = NULL;
	CleanBuildFiles* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_document (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = clean_build_files_new (_tmp3_, _tmp6_);
	build_files = _tmp7_;
	clean_build_files_clean (build_files);
	_g_object_unref0 (build_files);
}


void main_window_build_tools_on_view_log (MainWindowBuildTools* self) {
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	Document* _tmp4_ = NULL;
	Document* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GFile* mainfile = NULL;
	MainWindow* _tmp7_ = NULL;
	Document* _tmp8_ = NULL;
	Document* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* directory = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	gchar* basename = NULL;
	GFile* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GFile* file = NULL;
	GFile* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GFile* _tmp22_ = NULL;
	DocumentTab* tab = NULL;
	MainWindow* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	DocumentTab* _tmp25_ = NULL;
	DocumentTab* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = main_window_get_active_document (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = document_is_main_file_a_tex_file (_tmp5_);
	g_return_if_fail (_tmp6_);
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = main_window_get_active_document (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = document_get_main_file (_tmp9_);
	mainfile = _tmp10_;
	_tmp11_ = mainfile;
	_tmp12_ = g_file_get_parent (_tmp11_);
	directory = _tmp12_;
	_tmp13_ = mainfile;
	_tmp14_ = g_file_get_basename (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = utils_get_shortname (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, ".log", NULL);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	basename = _tmp19_;
	_tmp20_ = directory;
	_tmp21_ = basename;
	_tmp22_ = g_file_get_child (_tmp20_, _tmp21_);
	file = _tmp22_;
	_tmp23_ = self->priv->_main_window;
	_tmp24_ = file;
	_tmp25_ = main_window_open_document (_tmp23_, _tmp24_, TRUE);
	tab = _tmp25_;
	_tmp26_ = tab;
	if (_tmp26_ == NULL) {
		g_warning ("main_window_build_tools.vala:423: Impossible to view log");
	} else {
		DocumentTab* _tmp27_ = NULL;
		Document* _tmp28_ = NULL;
		Document* _tmp29_ = NULL;
		_tmp27_ = tab;
		_tmp28_ = document_tab_get_document (_tmp27_);
		_tmp29_ = _tmp28_;
		document_set_readonly (_tmp29_, TRUE);
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (directory);
	_g_object_unref0 (mainfile);
}


void main_window_build_tools_on_preferences (MainWindowBuildTools* self) {
	MainWindow* _tmp0_ = NULL;
	BuildToolsPreferences* _tmp1_ = NULL;
	BuildToolsPreferences* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = build_tools_preferences_new (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
}


static void value_main_window_build_tools_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_main_window_build_tools_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		main_window_build_tools_unref (value->data[0].v_pointer);
	}
}


static void value_main_window_build_tools_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_window_build_tools_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_main_window_build_tools_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_main_window_build_tools_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		MainWindowBuildTools* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_window_build_tools_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_main_window_build_tools_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MainWindowBuildTools** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_window_build_tools_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_main_window_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMainWindowBuildTools* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_main_window_build_tools (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
	return value->data[0].v_pointer;
}


void value_set_main_window_build_tools (GValue* value, gpointer v_object) {
	MainWindowBuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_window_build_tools_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_build_tools_unref (old);
	}
}


void value_take_main_window_build_tools (GValue* value, gpointer v_object) {
	MainWindowBuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_build_tools_unref (old);
	}
}


static void main_window_build_tools_class_init (MainWindowBuildToolsClass * klass) {
	main_window_build_tools_parent_class = g_type_class_peek_parent (klass);
	MAIN_WINDOW_BUILD_TOOLS_CLASS (klass)->finalize = main_window_build_tools_finalize;
	g_type_class_add_private (klass, sizeof (MainWindowBuildToolsPrivate));
}


static void main_window_build_tools_instance_init (MainWindowBuildTools * self) {
	self->priv = MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void main_window_build_tools_finalize (MainWindowBuildTools* obj) {
	MainWindowBuildTools * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools);
	_g_object_unref0 (self->priv->_ui_manager);
	_g_object_unref0 (self->priv->_build_view);
	_g_object_unref0 (self->priv->_bottom_panel);
	_g_object_unref0 (self->priv->_static_action_group);
	_g_object_unref0 (self->priv->_dynamic_action_group);
	_g_object_unref0 (self->priv->_build_tool_runner);
}


GType main_window_build_tools_get_type (void) {
	static volatile gsize main_window_build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_build_tools_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_build_tools_init, value_main_window_build_tools_free_value, value_main_window_build_tools_copy_value, value_main_window_build_tools_peek_pointer, "p", value_main_window_build_tools_collect_value, "p", value_main_window_build_tools_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowBuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowBuildTools), 0, (GInstanceInitFunc) main_window_build_tools_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_build_tools_type_id;
		main_window_build_tools_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowBuildTools", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_window_build_tools_type_id__volatile, main_window_build_tools_type_id);
	}
	return main_window_build_tools_type_id__volatile;
}


gpointer main_window_build_tools_ref (gpointer instance) {
	MainWindowBuildTools* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void main_window_build_tools_unref (gpointer instance) {
	MainWindowBuildTools* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_WINDOW_BUILD_TOOLS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



