---
title: "Becoming a Maintainer"
---

**This guide is for contributors.** These special people have contributed to one or more of Jekyll's repositories, but do not yet have write access to any. You may find what is written here interesting, but it’s definitely not for everyone.
{: .note .info}

So you want to become a maintainer of a Jekyll project? We'd love to have you! Here are some things we like to see from community members before we promote them to maintainers.

## 1. Use Jekyll

You want to maintain Jekyll? Use it often. Do weird things with it. Do normal things with it. Does it work? Does it have any weaknesses? Is there a gap in the product that you think should be filled?

## 2. Help Triage Issues

Watch the repository you're interested in. Join [an Affinity Team](https://teams.jekyllrb.com) and receive mentions regarding a particular interest area of the project. When you receive a notification for an issue that has not been triaged by a maintainer, dive in. Can you reproduce the issue? Can you determine the fix? [More tips on Triaging an Issue in our maintainer guide](../triaging-an-issue/). Every maintainer loves an issue that is resolved before they get to it. :smiley:

## 3. Write Documentation

Good documentation means less confusion for our users and fewer issues to triage. Documentation is always in need of fixes and updates as we change the code. Read through the documentation during your normal usage of the product and submit changes as you feel they are necessary.

## 4. Write Code

As a maintainer, you will be reviewing pull requests which update code. You should feel comfortable with the Jekyll codebase enough to confidently review any pull request put forward. In order to become more comfortable, write some code of your own and send a pull request. A great place to start is with any issue labeled "bug" in the issue tracker. Write a test which replicates the problem and fails, then work on fixing the code such that the test passes.

## 5. Review Pull Requests

Start by reviewing one pull request a week. Leave detailed comments and [follow our guide for reviewing pull requests](../reviewing-a-pull-request/).

## 6. Ask!

Open an issue describing your contributions to the project and why you wish to be a maintainer. Issues are nice because you can easily reference where you have demonstrated that you help triage issues, write code & documentation, and review pull requests. You may also email any maintainer privately if you do not feel comfortable asking in the open.

We would love to expand the team and look forward to many more community members becoming maintainers!

# Helping Out Elsewhere

In addition to maintainers of our core and plugin code, the Jekyll team is comprised of moderators for our forums. These helpful community members take a look at the topics posted to [https://talk.jekyllrb.com](https://talk.jekyllrb.com) and ensure they are properly categorized and are acceptable under our Code of Conduct. If you would like to be a moderator, email one of the maintainers with links to where you have answered questions and a request to be added as a moderator. More help is always welcome.
