# ISOPALL -- Plots summary of results from isophotal analysis 
# by task ELLIPSE. The SDAS table generated by ELLIPSE is used as 
# input for nine graphs created by task SGRAPH and mosaiced by 
# GKIMOSAIC. This is to give the user a panoramic view of the main 
# results of the isophotal analysis. 
#						Ivo Busko  11/89
#
#  8/19/93  Updated pset names for sgraph parameters.  This is not the
#  optimum solution, but is a quick interim fix.  ZGL
#
#  5/03/95  Modified to enable INDEFs in error bars (sgraph crashes with
#  INDEFs in error columns).  IB


procedure isopall (input, xaxis)

file    input   = ""         {prompt="input table"}
char	xaxis   = "RSMA"     {prompt="x axis",enum="SMA|RSMA"}
char	device  = "stdgraph" {prompt="output graphics device"}

begin
	file	in, temp1, temp2
	string	xa
        
	string	sdevs, sdevg, stitl, sxlab, sylab, smark, serrc, str1
	int	iline, nlines, serra, smajx, smajy, sminx, sminy, sgknx, sgkny
	real	szmar, swl, swr, swb, swt
	bool	sappe, sroun, sflip, spoin, srot, sfill, sinte
        
	# Check for the presence of pre-requisite packages.
        str1 = ""
	if (!deftask("sgraph"))
            str1 = str1 // "stplot (tbplot)"
	if (!deftask("gkimosaic"))
            str1 = str1 // "plot "
        if (strlen (str1) > 0) {
            print ("Please load packages: ", str1)
            return
        }
        
	# Get parameters, create temporary files.
	in    = input
	xa    = xaxis
	temp1 = mktemp ("tmp$gkimos")
	temp2 = mktemp ("tmp$isopall")
        delete (temp1, go_ahead=yes, verify=no, default_action=yes,
                allversions=yes, subfiles=yes, >& "dev$null")
        delete (temp2, go_ahead=yes, verify=no, default_action=yes,
                allversions=yes, subfiles=yes, >& "dev$null")

	# Remove SMA=0 from plot.
	tabpar (in, "SMA", 1)
	if (real(tabpar.value) < 0.5) 
	    tselect (in, temp2, "row() != 1", mode="h")
	else
	    tcopy (in, temp2, verbose=no)

	tinfo (temp2, ttout=no)
	nlines = tinfo.nrows
       
	# Save called tasks parameters.
	sdevs = dvpar.device
	sappe = dvpar.append
	stitl = axispar.title
	sxlab = axispar.xlabel
	sylab = axispar.ylabel
	smark = pltpar.marker
	szmar = pltpar.szmarker
	serra = pltpar.erraxis
	sroun = axispar.round
	swl   = axispar.wl
	swr   = axispar.wr
	swb   = axispar.wb
	swt   = axispar.wt
	smajx = axispar.majrx
	smajy = axispar.majry
	sminx = axispar.minrx
	sminy = axispar.minry
	sflip = axispar.yflip
	spoin = pltpar.pointmode
	serrc = sgraph.errcolumn
	sdevg = gkimosaic.device
	srot  = gkimosaic.rotate
	sfill = gkimosaic.fill
        sinte = gkimosaic.interactive
	sgknx = gkimosaic.nx
	sgkny = gkimosaic.ny
        
	# Setup parameters
	dvpar.device = device
	dvpar.append = no
	axispar.title = ""
	axispar.xlabel = xa
	pltpar.marker = "box"
	pltpar.szmarker = 0.02
	pltpar.erraxis = 2
	sgraph.errcolumn = ""
	axispar.round = yes
	axispar.majrx = 3
	axispar.majry = 3
	axispar.minrx = 5
	axispar.minry = 5
	axispar.wl    = 0.
	axispar.wr    = 0.
	axispar.wb    = 0.
	axispar.wt    = 0.

	# Magnitude plot
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, "MAG_LERR", iline)
	    if (tabpar.undef)
	        partab (0., temp2, "MAG_LERR", iline)
	}
	axispar.ylabel = "MAG"
	axispar.yflip = yes
	pltpar.pointmode = yes
	dvpar.append = no
	sgraph (temp2 // " " // xa // " MAG", >G temp1)
	sgraph.errcolumn = "MAG_LERR MAG_LERR"
	pltpar.pointmode = no
	dvpar.append = yes
	sgraph (temp2 // " " // xa // " MAG", >>G temp1)
	axispar.yflip = no
        
	# A3 plot
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, "A3_ERR", iline)
	    if (tabpar.undef)
	        partab (0., temp2, "A3_ERR", iline)
	}
	axispar.ylabel = "A3"
	pltpar.pointmode = yes
	dvpar.append = no
	sgraph (temp2 // " " // xa // " A3", >>G temp1)
	sgraph.errcolumn = "A3_ERR A3_ERR"
	pltpar.pointmode = no
	dvpar.append = yes
	sgraph (temp2 // " " // xa // " A3", >>G temp1)
        
	# B3 plot
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, "B3_ERR", iline)
	    if (tabpar.undef)
	        partab (0., temp2, "B3_ERR", iline)
	}
	axispar.ylabel = "B3"
	pltpar.pointmode = yes
	dvpar.append = no
	sgraph (temp2 // " " // xa // " B3", >>G temp1)
	sgraph.errcolumn = "B3_ERR B3_ERR"
	pltpar.pointmode = no
	dvpar.append = yes
	sgraph (temp2 // " " // xa // " B3", >>G temp1)
        
	# Ellipticity plot
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, "ELLIP_ERR", iline)
	    if (tabpar.undef)
	        partab (0., temp2, "ELLIP_ERR", iline)
	}
	axispar.title = "imtitle"
	axispar.ylabel = "ELLIP"
	pltpar.pointmode = yes
	dvpar.append = no
	sgraph (temp2 // " " // xa // " ELLIP", >>G temp1)
	sgraph.errcolumn = "ELLIP_ERR ELLIP_ERR"
	pltpar.pointmode = no
	dvpar.append = yes
	sgraph (temp2 // " " // xa // " ELLIP", >>G temp1)
        
	# A4 plot
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, "A4_ERR", iline)
	    if (tabpar.undef)
	        partab (0., temp2, "A4_ERR", iline)
	}
	axispar.title = ""
	axispar.ylabel = "A4"
	pltpar.pointmode = yes
	dvpar.append = no
	sgraph (temp2 // " " // xa // " A4", >>G temp1)
	sgraph.errcolumn = "A4_ERR A4_ERR"
	pltpar.pointmode = no
	dvpar.append = yes
	sgraph (temp2 // " " // xa // " A4", >>G temp1)
      
	# B4 plot
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, "B4_ERR", iline)
	    if (tabpar.undef)
	        partab (0., temp2, "B4_ERR", iline)
	}
	axispar.ylabel = "B4"
	pltpar.pointmode = yes
	dvpar.append = no
	sgraph (temp2 // " " // xa // " B4", >>G temp1)
	sgraph.errcolumn = "B4_ERR B4_ERR"
	pltpar.pointmode = no
	dvpar.append = yes
	sgraph (temp2 // " " // xa // " B4", >>G temp1)
        
	# Position angle plot
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, "PA_ERR", iline)
	    if (tabpar.undef)
	        partab (0., temp2, "PA_ERR", iline)
	}
	axispar.ylabel = "PA"
	pltpar.pointmode = yes
	dvpar.append = no
	sgraph (temp2 // " " // xa // " PA", >>G temp1)
	sgraph.errcolumn = "PA_ERR PA_ERR"
	pltpar.pointmode = no
	dvpar.append = yes
	sgraph (temp2 // " " // xa // " PA", >>G temp1)
       
	# X position plot
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, "X0_ERR", iline)
	    if (tabpar.undef)
	        partab (0., temp2, "X0_ERR", iline)
	}
	axispar.ylabel = "X0"
	pltpar.pointmode = yes
	dvpar.append = no
	sgraph (temp2 // " " // xa // " X0", >>G temp1)
	sgraph.errcolumn = "X0_ERR X0_ERR"
	pltpar.pointmode = no
	dvpar.append = yes
	sgraph (temp2 // " " // xa // " X0", >>G temp1)
        
	# Y position plot
	for (iline = 1; iline <= nlines; iline = iline + 1) {
	    tabpar (temp2, "Y0_ERR", iline)
	    if (tabpar.undef)
	        partab (0., temp2, "Y0_ERR", iline)
	}
	axispar.ylabel = "Y0"
	pltpar.pointmode = yes
	dvpar.append = no
	sgraph (temp2 // " " // xa // " Y0", >>G temp1)
	sgraph.errcolumn = "Y0_ERR Y0_ERR"
	pltpar.pointmode = no
	dvpar.append = yes
	sgraph (temp2 // " " // xa // " Y0", >>G temp1)
        
	# Plots mosaic
	gkimosaic.device = device
	gkimosaic.rotate = no
	gkimosaic.fill = yes
        gkimosaic.interactive = no
	gkimosaic.nx = 3
	gkimosaic.ny = 3
	gkimosaic (temp1, rotate=no, fill=yes,
                   interactive=no, nx=3, ny=3)
        
	# Restore called tasks parameters.
	dvpar.device          = sdevs
	dvpar.append          = sappe
	axispar.title         = stitl
	axispar.xlabel        = sxlab
	axispar.ylabel        = sylab
	pltpar.marker         = smark
	pltpar.szmarker       = szmar
	pltpar.erraxis        = serra
	axispar.round         = sroun
	axispar.wl            = swl
	axispar.wr            = swr
	axispar.wb            = swb
	axispar.wt            = swt
	axispar.majrx         = smajx
	axispar.majry         = smajy
	axispar.minrx         = sminx
	axispar.minry         = sminy
	axispar.yflip         = sflip
	pltpar.pointmode      = spoin
	sgraph.errcolumn      = serrc
	gkimosaic.device      = sdevg
	gkimosaic.rotate      = srot
	gkimosaic.fill        = sfill
        gkimosaic.interactive = sinte
	gkimosaic.nx          = sgknx
	gkimosaic.ny          = sgkny
        
	# Delete temporary files.
	delete (temp1, verify = no, >& "dev$null")
        delete (temp2 // ".tab", verify = no, >& "dev$null")
end

