/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompatICS;
import android.support.v4.view.ViewPropertyAnimatorCompatJB;
import android.support.v4.view.ViewPropertyAnimatorCompatJellybeanMr2;
import android.support.v4.view.ViewPropertyAnimatorCompatKK;
import android.support.v4.view.ViewPropertyAnimatorCompatLollipop;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.view.View;
import android.view.animation.Interpolator;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class ViewPropertyAnimatorCompat {
    private static final String TAG = "ViewAnimatorCompat";
    private WeakReference<View> mView;
    private Runnable mStartAction = null;
    private Runnable mEndAction = null;
    private int mOldLayerType = -1;
    static final int LISTENER_TAG_ID = 0x7E000000;
    static final ViewPropertyAnimatorCompatImpl IMPL;

    ViewPropertyAnimatorCompat(View view) {
        this.mView = new WeakReference<View>(view);
    }

    public ViewPropertyAnimatorCompat setDuration(long value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setDuration(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat alpha(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.alpha(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat alphaBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.alphaBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationX(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationY(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat withEndAction(Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.withEndAction(this, view, runnable);
        }
        return this;
    }

    public long getDuration() {
        View view = (View)this.mView.get();
        if (view != null) {
            return IMPL.getDuration(this, view);
        }
        return 0L;
    }

    public ViewPropertyAnimatorCompat setInterpolator(Interpolator value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setInterpolator(this, view, value);
        }
        return this;
    }

    public Interpolator getInterpolator() {
        View view = (View)this.mView.get();
        if (view != null) {
            return IMPL.getInterpolator(this, view);
        }
        return null;
    }

    public ViewPropertyAnimatorCompat setStartDelay(long value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setStartDelay(this, view, value);
        }
        return this;
    }

    public long getStartDelay() {
        View view = (View)this.mView.get();
        if (view != null) {
            return IMPL.getStartDelay(this, view);
        }
        return 0L;
    }

    public ViewPropertyAnimatorCompat rotation(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotation(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationX(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationXBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationY(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat rotationYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.rotationYBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleX(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleXBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleY(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat scaleYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.scaleYBy(this, view, value);
        }
        return this;
    }

    public void cancel() {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.cancel(this, view);
        }
    }

    public ViewPropertyAnimatorCompat x(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.x(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat xBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.xBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat y(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.y(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat yBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.yBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationXBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationYBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationZBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationZBy(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat translationZ(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.translationZ(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat z(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.z(this, view, value);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat zBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.zBy(this, view, value);
        }
        return this;
    }

    public void start() {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.start(this, view);
        }
    }

    public ViewPropertyAnimatorCompat withLayer() {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.withLayer(this, view);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat withStartAction(Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.withStartAction(this, view, runnable);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat setListener(ViewPropertyAnimatorListener listener) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setListener(this, view, listener);
        }
        return this;
    }

    public ViewPropertyAnimatorCompat setUpdateListener(ViewPropertyAnimatorUpdateListener listener) {
        View view = (View)this.mView.get();
        if (view != null) {
            IMPL.setUpdateListener(this, view, listener);
        }
        return this;
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 21 ? new LollipopViewPropertyAnimatorCompatImpl() : (version >= 19 ? new KitKatViewPropertyAnimatorCompatImpl() : (version >= 18 ? new JBMr2ViewPropertyAnimatorCompatImpl() : (version >= 16 ? new JBViewPropertyAnimatorCompatImpl() : (version >= 14 ? new ICSViewPropertyAnimatorCompatImpl() : new BaseViewPropertyAnimatorCompatImpl()))));
    }

    static class LollipopViewPropertyAnimatorCompatImpl
    extends KitKatViewPropertyAnimatorCompatImpl {
        LollipopViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void translationZ(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatLollipop.translationZ(view, value);
        }

        @Override
        public void translationZBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatLollipop.translationZBy(view, value);
        }

        @Override
        public void z(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatLollipop.z(view, value);
        }

        @Override
        public void zBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatLollipop.zBy(view, value);
        }
    }

    static class KitKatViewPropertyAnimatorCompatImpl
    extends JBMr2ViewPropertyAnimatorCompatImpl {
        KitKatViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void setUpdateListener(ViewPropertyAnimatorCompat vpa, View view, ViewPropertyAnimatorUpdateListener listener) {
            ViewPropertyAnimatorCompatKK.setUpdateListener(view, listener);
        }
    }

    static class JBMr2ViewPropertyAnimatorCompatImpl
    extends JBViewPropertyAnimatorCompatImpl {
        JBMr2ViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public Interpolator getInterpolator(ViewPropertyAnimatorCompat vpa, View view) {
            return ViewPropertyAnimatorCompatJellybeanMr2.getInterpolator(view);
        }
    }

    static class JBViewPropertyAnimatorCompatImpl
    extends ICSViewPropertyAnimatorCompatImpl {
        JBViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void setListener(ViewPropertyAnimatorCompat vpa, View view, ViewPropertyAnimatorListener listener) {
            ViewPropertyAnimatorCompatJB.setListener(view, listener);
        }

        @Override
        public void withStartAction(ViewPropertyAnimatorCompat vpa, View view, Runnable runnable) {
            ViewPropertyAnimatorCompatJB.withStartAction(view, runnable);
        }

        @Override
        public void withEndAction(ViewPropertyAnimatorCompat vpa, View view, Runnable runnable) {
            ViewPropertyAnimatorCompatJB.withEndAction(view, runnable);
        }

        @Override
        public void withLayer(ViewPropertyAnimatorCompat vpa, View view) {
            ViewPropertyAnimatorCompatJB.withLayer(view);
        }
    }

    static class ICSViewPropertyAnimatorCompatImpl
    extends BaseViewPropertyAnimatorCompatImpl {
        WeakHashMap<View, Integer> mLayerMap = null;

        ICSViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void setDuration(ViewPropertyAnimatorCompat vpa, View view, long value) {
            ViewPropertyAnimatorCompatICS.setDuration(view, value);
        }

        @Override
        public void alpha(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.alpha(view, value);
        }

        @Override
        public void translationX(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.translationX(view, value);
        }

        @Override
        public void translationY(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.translationY(view, value);
        }

        @Override
        public long getDuration(ViewPropertyAnimatorCompat vpa, View view) {
            return ViewPropertyAnimatorCompatICS.getDuration(view);
        }

        @Override
        public void setInterpolator(ViewPropertyAnimatorCompat vpa, View view, Interpolator value) {
            ViewPropertyAnimatorCompatICS.setInterpolator(view, value);
        }

        @Override
        public void setStartDelay(ViewPropertyAnimatorCompat vpa, View view, long value) {
            ViewPropertyAnimatorCompatICS.setStartDelay(view, value);
        }

        @Override
        public long getStartDelay(ViewPropertyAnimatorCompat vpa, View view) {
            return ViewPropertyAnimatorCompatICS.getStartDelay(view);
        }

        @Override
        public void alphaBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.alphaBy(view, value);
        }

        @Override
        public void rotation(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.rotation(view, value);
        }

        @Override
        public void rotationBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationBy(view, value);
        }

        @Override
        public void rotationX(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationX(view, value);
        }

        @Override
        public void rotationXBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationXBy(view, value);
        }

        @Override
        public void rotationY(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationY(view, value);
        }

        @Override
        public void rotationYBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.rotationYBy(view, value);
        }

        @Override
        public void scaleX(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.scaleX(view, value);
        }

        @Override
        public void scaleXBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.scaleXBy(view, value);
        }

        @Override
        public void scaleY(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.scaleY(view, value);
        }

        @Override
        public void scaleYBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.scaleYBy(view, value);
        }

        @Override
        public void cancel(ViewPropertyAnimatorCompat vpa, View view) {
            ViewPropertyAnimatorCompatICS.cancel(view);
        }

        @Override
        public void x(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.x(view, value);
        }

        @Override
        public void xBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.xBy(view, value);
        }

        @Override
        public void y(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.y(view, value);
        }

        @Override
        public void yBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.yBy(view, value);
        }

        @Override
        public void translationXBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.translationXBy(view, value);
        }

        @Override
        public void translationYBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            ViewPropertyAnimatorCompatICS.translationYBy(view, value);
        }

        @Override
        public void start(ViewPropertyAnimatorCompat vpa, View view) {
            ViewPropertyAnimatorCompatICS.start(view);
        }

        @Override
        public void setListener(ViewPropertyAnimatorCompat vpa, View view, ViewPropertyAnimatorListener listener) {
            view.setTag(0x7E000000, (Object)listener);
            ViewPropertyAnimatorCompatICS.setListener(view, new MyVpaListener(vpa));
        }

        @Override
        public void withEndAction(ViewPropertyAnimatorCompat vpa, View view, Runnable runnable) {
            ViewPropertyAnimatorCompatICS.setListener(view, new MyVpaListener(vpa));
            vpa.mEndAction = runnable;
        }

        @Override
        public void withStartAction(ViewPropertyAnimatorCompat vpa, View view, Runnable runnable) {
            ViewPropertyAnimatorCompatICS.setListener(view, new MyVpaListener(vpa));
            vpa.mStartAction = runnable;
        }

        @Override
        public void withLayer(ViewPropertyAnimatorCompat vpa, View view) {
            vpa.mOldLayerType = ViewCompat.getLayerType(view);
            ViewPropertyAnimatorCompatICS.setListener(view, new MyVpaListener(vpa));
        }

        static class MyVpaListener
        implements ViewPropertyAnimatorListener {
            ViewPropertyAnimatorCompat mVpa;
            boolean mAnimEndCalled;

            MyVpaListener(ViewPropertyAnimatorCompat vpa) {
                this.mVpa = vpa;
            }

            @Override
            public void onAnimationStart(View view) {
                this.mAnimEndCalled = false;
                if (this.mVpa.mOldLayerType >= 0) {
                    ViewCompat.setLayerType(view, 2, null);
                }
                if (this.mVpa.mStartAction != null) {
                    Runnable startAction = this.mVpa.mStartAction;
                    this.mVpa.mStartAction = null;
                    startAction.run();
                }
                Object listenerTag = view.getTag(0x7E000000);
                ViewPropertyAnimatorListener listener = null;
                if (listenerTag instanceof ViewPropertyAnimatorListener) {
                    listener = (ViewPropertyAnimatorListener)listenerTag;
                }
                if (listener != null) {
                    listener.onAnimationStart(view);
                }
            }

            @Override
            public void onAnimationEnd(View view) {
                if (this.mVpa.mOldLayerType >= 0) {
                    ViewCompat.setLayerType(view, this.mVpa.mOldLayerType, null);
                    this.mVpa.mOldLayerType = -1;
                }
                if (Build.VERSION.SDK_INT >= 16 || !this.mAnimEndCalled) {
                    if (this.mVpa.mEndAction != null) {
                        Runnable endAction = this.mVpa.mEndAction;
                        this.mVpa.mEndAction = null;
                        endAction.run();
                    }
                    Object listenerTag = view.getTag(0x7E000000);
                    ViewPropertyAnimatorListener listener = null;
                    if (listenerTag instanceof ViewPropertyAnimatorListener) {
                        listener = (ViewPropertyAnimatorListener)listenerTag;
                    }
                    if (listener != null) {
                        listener.onAnimationEnd(view);
                    }
                    this.mAnimEndCalled = true;
                }
            }

            @Override
            public void onAnimationCancel(View view) {
                Object listenerTag = view.getTag(0x7E000000);
                ViewPropertyAnimatorListener listener = null;
                if (listenerTag instanceof ViewPropertyAnimatorListener) {
                    listener = (ViewPropertyAnimatorListener)listenerTag;
                }
                if (listener != null) {
                    listener.onAnimationCancel(view);
                }
            }
        }
    }

    static class BaseViewPropertyAnimatorCompatImpl
    implements ViewPropertyAnimatorCompatImpl {
        WeakHashMap<View, Runnable> mStarterMap = null;

        BaseViewPropertyAnimatorCompatImpl() {
        }

        @Override
        public void setDuration(ViewPropertyAnimatorCompat vpa, View view, long value) {
        }

        @Override
        public void alpha(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void translationX(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void translationY(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void withEndAction(ViewPropertyAnimatorCompat vpa, View view, Runnable runnable) {
            vpa.mEndAction = runnable;
            this.postStartMessage(vpa, view);
        }

        @Override
        public long getDuration(ViewPropertyAnimatorCompat vpa, View view) {
            return 0L;
        }

        @Override
        public void setInterpolator(ViewPropertyAnimatorCompat vpa, View view, Interpolator value) {
        }

        @Override
        public Interpolator getInterpolator(ViewPropertyAnimatorCompat vpa, View view) {
            return null;
        }

        @Override
        public void setStartDelay(ViewPropertyAnimatorCompat vpa, View view, long value) {
        }

        @Override
        public long getStartDelay(ViewPropertyAnimatorCompat vpa, View view) {
            return 0L;
        }

        @Override
        public void alphaBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void rotation(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void rotationBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void rotationX(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void rotationXBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void rotationY(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void rotationYBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void scaleX(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void scaleXBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void scaleY(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void scaleYBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void cancel(ViewPropertyAnimatorCompat vpa, View view) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void x(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void xBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void y(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void yBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void z(ViewPropertyAnimatorCompat vpa, View view, float value) {
        }

        @Override
        public void zBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
        }

        @Override
        public void translationXBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void translationYBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
            this.postStartMessage(vpa, view);
        }

        @Override
        public void translationZ(ViewPropertyAnimatorCompat vpa, View view, float value) {
        }

        @Override
        public void translationZBy(ViewPropertyAnimatorCompat vpa, View view, float value) {
        }

        @Override
        public void start(ViewPropertyAnimatorCompat vpa, View view) {
            this.removeStartMessage(view);
            this.startAnimation(vpa, view);
        }

        @Override
        public void withLayer(ViewPropertyAnimatorCompat vpa, View view) {
        }

        @Override
        public void withStartAction(ViewPropertyAnimatorCompat vpa, View view, Runnable runnable) {
            vpa.mStartAction = runnable;
            this.postStartMessage(vpa, view);
        }

        @Override
        public void setListener(ViewPropertyAnimatorCompat vpa, View view, ViewPropertyAnimatorListener listener) {
            view.setTag(0x7E000000, (Object)listener);
        }

        @Override
        public void setUpdateListener(ViewPropertyAnimatorCompat vpa, View view, ViewPropertyAnimatorUpdateListener listener) {
        }

        private void startAnimation(ViewPropertyAnimatorCompat vpa, View view) {
            Object listenerTag = view.getTag(0x7E000000);
            ViewPropertyAnimatorListener listener = null;
            if (listenerTag instanceof ViewPropertyAnimatorListener) {
                listener = (ViewPropertyAnimatorListener)listenerTag;
            }
            Runnable startAction = vpa.mStartAction;
            Runnable endAction = vpa.mEndAction;
            vpa.mStartAction = null;
            vpa.mEndAction = null;
            if (startAction != null) {
                startAction.run();
            }
            if (listener != null) {
                listener.onAnimationStart(view);
                listener.onAnimationEnd(view);
            }
            if (endAction != null) {
                endAction.run();
            }
            if (this.mStarterMap != null) {
                this.mStarterMap.remove(view);
            }
        }

        private void removeStartMessage(View view) {
            Runnable starter = null;
            if (this.mStarterMap != null && (starter = this.mStarterMap.get(view)) != null) {
                view.removeCallbacks(starter);
            }
        }

        private void postStartMessage(ViewPropertyAnimatorCompat vpa, View view) {
            Runnable starter = null;
            if (this.mStarterMap != null) {
                starter = this.mStarterMap.get(view);
            }
            if (starter == null) {
                starter = new Starter(vpa, view);
                if (this.mStarterMap == null) {
                    this.mStarterMap = new WeakHashMap();
                }
                this.mStarterMap.put(view, starter);
            }
            view.removeCallbacks(starter);
            view.post(starter);
        }

        class Starter
        implements Runnable {
            WeakReference<View> mViewRef;
            ViewPropertyAnimatorCompat mVpa;

            private Starter(ViewPropertyAnimatorCompat vpa, View view) {
                this.mViewRef = new WeakReference<View>(view);
                this.mVpa = vpa;
            }

            @Override
            public void run() {
                View view = (View)this.mViewRef.get();
                if (view != null) {
                    BaseViewPropertyAnimatorCompatImpl.this.startAnimation(this.mVpa, view);
                }
            }
        }
    }

    static interface ViewPropertyAnimatorCompatImpl {
        public void setDuration(ViewPropertyAnimatorCompat var1, View var2, long var3);

        public long getDuration(ViewPropertyAnimatorCompat var1, View var2);

        public void setInterpolator(ViewPropertyAnimatorCompat var1, View var2, Interpolator var3);

        public Interpolator getInterpolator(ViewPropertyAnimatorCompat var1, View var2);

        public void setStartDelay(ViewPropertyAnimatorCompat var1, View var2, long var3);

        public long getStartDelay(ViewPropertyAnimatorCompat var1, View var2);

        public void alpha(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void alphaBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotation(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationX(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationXBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationY(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void rotationYBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void scaleX(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void scaleXBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void scaleY(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void scaleYBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void cancel(ViewPropertyAnimatorCompat var1, View var2);

        public void x(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void xBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void y(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void yBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void z(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void zBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationX(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationXBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationY(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationYBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationZ(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void translationZBy(ViewPropertyAnimatorCompat var1, View var2, float var3);

        public void start(ViewPropertyAnimatorCompat var1, View var2);

        public void withLayer(ViewPropertyAnimatorCompat var1, View var2);

        public void withStartAction(ViewPropertyAnimatorCompat var1, View var2, Runnable var3);

        public void withEndAction(ViewPropertyAnimatorCompat var1, View var2, Runnable var3);

        public void setListener(ViewPropertyAnimatorCompat var1, View var2, ViewPropertyAnimatorListener var3);

        public void setUpdateListener(ViewPropertyAnimatorCompat var1, View var2, ViewPropertyAnimatorUpdateListener var3);
    }
}

