/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.hyperbolic.Isometry;
import hypergraph.hyperbolic.Model;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.ModelVector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractModel
implements Model {
    protected Isometry viewMatrix;
    private Isometry inversViewMatrix;
    protected ModelPoint orientationRoot;
    protected Isometry isom1 = this.getIdentity();
    protected Isometry isom2 = this.getIdentity();
    protected Isometry isom3 = this.getIdentity();
    protected ModelPoint z1 = this.getOrigin();
    protected ModelPoint z2 = this.getOrigin();
    protected ModelPoint z3 = this.getOrigin();
    protected ModelPoint z4 = this.getOrigin();
    protected ModelPoint zero = this.getOrigin();
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbstractModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbstractModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbstractModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? AbstractModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public Isometry getInversViewMatrix() {
        return this.inversViewMatrix;
    }

    public Isometry getViewMatrix() {
        return this.viewMatrix;
    }

    public void setViewMatrix(Isometry isometry) {
        if (isometry != null) {
            this.viewMatrix = isometry;
            this.inversViewMatrix = this.viewMatrix.getInvers();
        } else {
            this.viewMatrix = this.getIdentity();
            this.inversViewMatrix = this.getIdentity();
        }
        this.fireStateChanged();
    }

    public void setOrientationRoot(ModelPoint modelPoint) {
        this.orientationRoot = modelPoint;
        this.setViewMatrix(this.getViewMatrix());
    }

    public Isometry getIdentity() {
        return this.getRotation(0.0);
    }

    public Isometry getRotation(ModelPoint modelPoint, double d) {
        Isometry isometry = this.getTranslation(modelPoint);
        Isometry isometry2 = (Isometry)isometry.clone();
        isometry.invert();
        isometry2.multiplyRight(this.getRotation(d));
        isometry2.multiplyRight(isometry);
        return isometry2;
    }

    public Isometry getTranslation(ModelPoint modelPoint) {
        Isometry isometry = this.getIdentity();
        this.getTranslation(isometry, modelPoint);
        return isometry;
    }

    public void getTranslation(Isometry isometry, ModelPoint modelPoint) {
        this.getTranslation(isometry, modelPoint, 1.0);
    }

    public void getTranslation(Isometry isometry, ModelPoint modelPoint, ModelPoint modelPoint2) {
        this.getTranslation(isometry, modelPoint, modelPoint2, 1.0);
    }

    public Isometry getTranslation(ModelPoint modelPoint, ModelPoint modelPoint2) {
        Isometry isometry = this.getIdentity();
        this.getTranslation(isometry, modelPoint, modelPoint2);
        return isometry;
    }

    public Isometry getTranslation(ModelPoint modelPoint, double d) {
        Isometry isometry = this.getIdentity();
        this.getTranslation(isometry, modelPoint, d);
        return isometry;
    }

    public Isometry getTranslation(ModelPoint modelPoint, ModelPoint modelPoint2, double d) {
        Isometry isometry = this.getIdentity();
        this.getTranslation(isometry, modelPoint, modelPoint2, d);
        return isometry;
    }

    public void getTranslation(Isometry isometry, ModelPoint modelPoint, ModelPoint modelPoint2, double d) {
        this.z1.setTo(modelPoint2);
        try {
            this.getTranslation(this.isom1, modelPoint);
            isometry.setTo(this.isom1);
            this.isom1.invert();
            this.isom1.apply(this.z1);
            this.getTranslation(this.isom2, this.z1, d);
            this.isom2.multiplyRight(this.isom1);
            isometry.multiplyRight(this.isom2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(modelPoint);
            System.out.println(modelPoint2);
            System.out.println(d);
            System.out.println(this.isom1);
            System.out.println(this.isom2);
            System.out.println(isometry);
        }
    }

    public void getTranslation(Isometry isometry, ModelVector modelVector, double d) {
        this.getTranslation(isometry, modelVector.getBase(), this.exp(modelVector, d));
    }

    public Isometry getTranslation(ModelVector modelVector, double d) {
        Isometry isometry = this.getIdentity();
        this.getTranslation(isometry, modelVector, d);
        return isometry;
    }

    public double dist2(ModelPoint modelPoint) {
        double d = this.dist(modelPoint);
        return d * d;
    }

    public double dist(ModelPoint modelPoint) {
        return Math.sqrt(this.dist2(modelPoint));
    }

    public double dist(ModelPoint modelPoint, ModelPoint modelPoint2) {
        return Math.sqrt(this.dist2(modelPoint, modelPoint2));
    }

    public double dist2(ModelPoint modelPoint, ModelPoint modelPoint2) {
        double d = this.dist(modelPoint, modelPoint2);
        return d * d;
    }

    public double length2(ModelVector modelVector) {
        return this.product(modelVector, modelVector);
    }

    public double length(ModelVector modelVector) {
        return Math.sqrt(this.length2(modelVector));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

