{
    This file is part of the Free Pascal run time library.
    Copyright (c) 2006-2017 by Karoly Balogh
    member of the Free Pascal development team

    Font and color data to be used by systems where the video unit's
    console is simulated on graphics interface

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{
  This file contains the Pascal-syntax conversion of font data from the
  VGA BIOS reimplementation of the Bosch PC emulator and it is distributed
  under the GNU LGPL. It is available at:

  http://nongnu.org/vgabios

  Which in turn contains font data (c) by Joseph Gil, and was placed in
  public domain (see copyleft.txt in the archive):

  http://ftp.freenet.de/pub/ftp.simtel.net/pub/simtelnet/msdos/screen/fntcol16.zip
}

const
   vgacolors : array[0..15,0..2] of byte = (
      (   0,   0,   0 ), // black
      (   0,   0, 153 ), // blue
      (   0, 153,   0 ), // green
      (   0, 153, 153 ), // cyan
      ( 153,   0,   0 ), // red
      ( 153,   0, 153 ), // magenta
      ( 153, 102,   0 ), // brown
      ( 153, 153, 153 ), // lightgray

      ( 102, 102, 102 ), // darkgray
      ( 102, 102, 255 ), // lightblue
      ( 102, 255, 102 ), // lightgreen
      ( 102, 255, 255 ), // lightcyan
      ( 255, 102, 102 ), // lightred
      ( 255, 102, 255 ), // lightmagenta
      ( 255, 255, 102 ), // yellow
      ( 255, 255, 255 )  // white
   );


const
   vgafont8 : array[0..255,0..7] of byte = (
      ( $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $7e, $81, $a5, $81, $bd, $99, $81, $7e ),
      ( $7e, $ff, $db, $ff, $c3, $e7, $ff, $7e ),
      ( $6c, $fe, $fe, $fe, $7c, $38, $10, $00 ),
      ( $10, $38, $7c, $fe, $7c, $38, $10, $00 ),
      ( $38, $7c, $38, $fe, $fe, $7c, $38, $7c ),
      ( $10, $10, $38, $7c, $fe, $7c, $38, $7c ),
      ( $00, $00, $18, $3c, $3c, $18, $00, $00 ),
      ( $ff, $ff, $e7, $c3, $c3, $e7, $ff, $ff ),
      ( $00, $3c, $66, $42, $42, $66, $3c, $00 ),
      ( $ff, $c3, $99, $bd, $bd, $99, $c3, $ff ),
      ( $0f, $07, $0f, $7d, $cc, $cc, $cc, $78 ),
      ( $3c, $66, $66, $66, $3c, $18, $7e, $18 ),
      ( $3f, $33, $3f, $30, $30, $70, $f0, $e0 ),
      ( $7f, $63, $7f, $63, $63, $67, $e6, $c0 ),
      ( $99, $5a, $3c, $e7, $e7, $3c, $5a, $99 ),
      ( $80, $e0, $f8, $fe, $f8, $e0, $80, $00 ),
      ( $02, $0e, $3e, $fe, $3e, $0e, $02, $00 ),
      ( $18, $3c, $7e, $18, $18, $7e, $3c, $18 ),
      ( $66, $66, $66, $66, $66, $00, $66, $00 ),
      ( $7f, $db, $db, $7b, $1b, $1b, $1b, $00 ),
      ( $3e, $63, $38, $6c, $6c, $38, $cc, $78 ),
      ( $00, $00, $00, $00, $7e, $7e, $7e, $00 ),
      ( $18, $3c, $7e, $18, $7e, $3c, $18, $ff ),
      ( $18, $3c, $7e, $18, $18, $18, $18, $00 ),
      ( $18, $18, $18, $18, $7e, $3c, $18, $00 ),
      ( $00, $18, $0c, $fe, $0c, $18, $00, $00 ),
      ( $00, $30, $60, $fe, $60, $30, $00, $00 ),
      ( $00, $00, $c0, $c0, $c0, $fe, $00, $00 ),
      ( $00, $24, $66, $ff, $66, $24, $00, $00 ),
      ( $00, $18, $3c, $7e, $ff, $ff, $00, $00 ),
      ( $00, $ff, $ff, $7e, $3c, $18, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $30, $78, $78, $30, $30, $00, $30, $00 ),
      ( $6c, $6c, $6c, $00, $00, $00, $00, $00 ),
      ( $6c, $6c, $fe, $6c, $fe, $6c, $6c, $00 ),
      ( $30, $7c, $c0, $78, $0c, $f8, $30, $00 ),
      ( $00, $c6, $cc, $18, $30, $66, $c6, $00 ),
      ( $38, $6c, $38, $76, $dc, $cc, $76, $00 ),
      ( $60, $60, $c0, $00, $00, $00, $00, $00 ),
      ( $18, $30, $60, $60, $60, $30, $18, $00 ),
      ( $60, $30, $18, $18, $18, $30, $60, $00 ),
      ( $00, $66, $3c, $ff, $3c, $66, $00, $00 ),
      ( $00, $30, $30, $fc, $30, $30, $00, $00 ),
      ( $00, $00, $00, $00, $00, $30, $30, $60 ),
      ( $00, $00, $00, $fc, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $30, $30, $00 ),
      ( $06, $0c, $18, $30, $60, $c0, $80, $00 ),
      ( $7c, $c6, $ce, $de, $f6, $e6, $7c, $00 ),
      ( $30, $70, $30, $30, $30, $30, $fc, $00 ),
      ( $78, $cc, $0c, $38, $60, $cc, $fc, $00 ),
      ( $78, $cc, $0c, $38, $0c, $cc, $78, $00 ),
      ( $1c, $3c, $6c, $cc, $fe, $0c, $1e, $00 ),
      ( $fc, $c0, $f8, $0c, $0c, $cc, $78, $00 ),
      ( $38, $60, $c0, $f8, $cc, $cc, $78, $00 ),
      ( $fc, $cc, $0c, $18, $30, $30, $30, $00 ),
      ( $78, $cc, $cc, $78, $cc, $cc, $78, $00 ),
      ( $78, $cc, $cc, $7c, $0c, $18, $70, $00 ),
      ( $00, $30, $30, $00, $00, $30, $30, $00 ),
      ( $00, $30, $30, $00, $00, $30, $30, $60 ),
      ( $18, $30, $60, $c0, $60, $30, $18, $00 ),
      ( $00, $00, $fc, $00, $00, $fc, $00, $00 ),
      ( $60, $30, $18, $0c, $18, $30, $60, $00 ),
      ( $78, $cc, $0c, $18, $30, $00, $30, $00 ),
      ( $7c, $c6, $de, $de, $de, $c0, $78, $00 ),
      ( $30, $78, $cc, $cc, $fc, $cc, $cc, $00 ),
      ( $fc, $66, $66, $7c, $66, $66, $fc, $00 ),
      ( $3c, $66, $c0, $c0, $c0, $66, $3c, $00 ),
      ( $f8, $6c, $66, $66, $66, $6c, $f8, $00 ),
      ( $fe, $62, $68, $78, $68, $62, $fe, $00 ),
      ( $fe, $62, $68, $78, $68, $60, $f0, $00 ),
      ( $3c, $66, $c0, $c0, $ce, $66, $3e, $00 ),
      ( $cc, $cc, $cc, $fc, $cc, $cc, $cc, $00 ),
      ( $78, $30, $30, $30, $30, $30, $78, $00 ),
      ( $1e, $0c, $0c, $0c, $cc, $cc, $78, $00 ),
      ( $e6, $66, $6c, $78, $6c, $66, $e6, $00 ),
      ( $f0, $60, $60, $60, $62, $66, $fe, $00 ),
      ( $c6, $ee, $fe, $fe, $d6, $c6, $c6, $00 ),
      ( $c6, $e6, $f6, $de, $ce, $c6, $c6, $00 ),
      ( $38, $6c, $c6, $c6, $c6, $6c, $38, $00 ),
      ( $fc, $66, $66, $7c, $60, $60, $f0, $00 ),
      ( $78, $cc, $cc, $cc, $dc, $78, $1c, $00 ),
      ( $fc, $66, $66, $7c, $6c, $66, $e6, $00 ),
      ( $78, $cc, $e0, $70, $1c, $cc, $78, $00 ),
      ( $fc, $b4, $30, $30, $30, $30, $78, $00 ),
      ( $cc, $cc, $cc, $cc, $cc, $cc, $fc, $00 ),
      ( $cc, $cc, $cc, $cc, $cc, $78, $30, $00 ),
      ( $c6, $c6, $c6, $d6, $fe, $ee, $c6, $00 ),
      ( $c6, $c6, $6c, $38, $38, $6c, $c6, $00 ),
      ( $cc, $cc, $cc, $78, $30, $30, $78, $00 ),
      ( $fe, $c6, $8c, $18, $32, $66, $fe, $00 ),
      ( $78, $60, $60, $60, $60, $60, $78, $00 ),
      ( $c0, $60, $30, $18, $0c, $06, $02, $00 ),
      ( $78, $18, $18, $18, $18, $18, $78, $00 ),
      ( $10, $38, $6c, $c6, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $ff ),
      ( $30, $30, $18, $00, $00, $00, $00, $00 ),
      ( $00, $00, $78, $0c, $7c, $cc, $76, $00 ),
      ( $e0, $60, $60, $7c, $66, $66, $dc, $00 ),
      ( $00, $00, $78, $cc, $c0, $cc, $78, $00 ),
      ( $1c, $0c, $0c, $7c, $cc, $cc, $76, $00 ),
      ( $00, $00, $78, $cc, $fc, $c0, $78, $00 ),
      ( $38, $6c, $60, $f0, $60, $60, $f0, $00 ),
      ( $00, $00, $76, $cc, $cc, $7c, $0c, $f8 ),
      ( $e0, $60, $6c, $76, $66, $66, $e6, $00 ),
      ( $30, $00, $70, $30, $30, $30, $78, $00 ),
      ( $0c, $00, $0c, $0c, $0c, $cc, $cc, $78 ),
      ( $e0, $60, $66, $6c, $78, $6c, $e6, $00 ),
      ( $70, $30, $30, $30, $30, $30, $78, $00 ),
      ( $00, $00, $cc, $fe, $fe, $d6, $c6, $00 ),
      ( $00, $00, $f8, $cc, $cc, $cc, $cc, $00 ),
      ( $00, $00, $78, $cc, $cc, $cc, $78, $00 ),
      ( $00, $00, $dc, $66, $66, $7c, $60, $f0 ),
      ( $00, $00, $76, $cc, $cc, $7c, $0c, $1e ),
      ( $00, $00, $dc, $76, $66, $60, $f0, $00 ),
      ( $00, $00, $7c, $c0, $78, $0c, $f8, $00 ),
      ( $10, $30, $7c, $30, $30, $34, $18, $00 ),
      ( $00, $00, $cc, $cc, $cc, $cc, $76, $00 ),
      ( $00, $00, $cc, $cc, $cc, $78, $30, $00 ),
      ( $00, $00, $c6, $d6, $fe, $fe, $6c, $00 ),
      ( $00, $00, $c6, $6c, $38, $6c, $c6, $00 ),
      ( $00, $00, $cc, $cc, $cc, $7c, $0c, $f8 ),
      ( $00, $00, $fc, $98, $30, $64, $fc, $00 ),
      ( $1c, $30, $30, $e0, $30, $30, $1c, $00 ),
      ( $18, $18, $18, $00, $18, $18, $18, $00 ),
      ( $e0, $30, $30, $1c, $30, $30, $e0, $00 ),
      ( $76, $dc, $00, $00, $00, $00, $00, $00 ),
      ( $00, $10, $38, $6c, $c6, $c6, $fe, $00 ),
      ( $78, $cc, $c0, $cc, $78, $18, $0c, $78 ),
      ( $00, $cc, $00, $cc, $cc, $cc, $7e, $00 ),
      ( $1c, $00, $78, $cc, $fc, $c0, $78, $00 ),
      ( $7e, $c3, $3c, $06, $3e, $66, $3f, $00 ),
      ( $cc, $00, $78, $0c, $7c, $cc, $7e, $00 ),
      ( $e0, $00, $78, $0c, $7c, $cc, $7e, $00 ),
      ( $30, $30, $78, $0c, $7c, $cc, $7e, $00 ),
      ( $00, $00, $78, $c0, $c0, $78, $0c, $38 ),
      ( $7e, $c3, $3c, $66, $7e, $60, $3c, $00 ),
      ( $cc, $00, $78, $cc, $fc, $c0, $78, $00 ),
      ( $e0, $00, $78, $cc, $fc, $c0, $78, $00 ),
      ( $cc, $00, $70, $30, $30, $30, $78, $00 ),
      ( $7c, $c6, $38, $18, $18, $18, $3c, $00 ),
      ( $e0, $00, $70, $30, $30, $30, $78, $00 ),
      ( $c6, $38, $6c, $c6, $fe, $c6, $c6, $00 ),
      ( $30, $30, $00, $78, $cc, $fc, $cc, $00 ),
      ( $1c, $00, $fc, $60, $78, $60, $fc, $00 ),
      ( $00, $00, $7f, $0c, $7f, $cc, $7f, $00 ),
      ( $3e, $6c, $cc, $fe, $cc, $cc, $ce, $00 ),
      ( $78, $cc, $00, $78, $cc, $cc, $78, $00 ),
      ( $00, $cc, $00, $78, $cc, $cc, $78, $00 ),
      ( $00, $e0, $00, $78, $cc, $cc, $78, $00 ),
      ( $78, $cc, $00, $cc, $cc, $cc, $7e, $00 ),
      ( $00, $e0, $00, $cc, $cc, $cc, $7e, $00 ),
      ( $00, $cc, $00, $cc, $cc, $7c, $0c, $f8 ),
      ( $c3, $18, $3c, $66, $66, $3c, $18, $00 ),
      ( $cc, $00, $cc, $cc, $cc, $cc, $78, $00 ),
      ( $18, $18, $7e, $c0, $c0, $7e, $18, $18 ),
      ( $38, $6c, $64, $f0, $60, $e6, $fc, $00 ),
      ( $cc, $cc, $78, $fc, $30, $fc, $30, $30 ),
      ( $f8, $cc, $cc, $fa, $c6, $cf, $c6, $c7 ),
      ( $0e, $1b, $18, $3c, $18, $18, $d8, $70 ),
      ( $1c, $00, $78, $0c, $7c, $cc, $7e, $00 ),
      ( $38, $00, $70, $30, $30, $30, $78, $00 ),
      ( $00, $1c, $00, $78, $cc, $cc, $78, $00 ),
      ( $00, $1c, $00, $cc, $cc, $cc, $7e, $00 ),
      ( $00, $f8, $00, $f8, $cc, $cc, $cc, $00 ),
      ( $fc, $00, $cc, $ec, $fc, $dc, $cc, $00 ),
      ( $3c, $6c, $6c, $3e, $00, $7e, $00, $00 ),
      ( $38, $6c, $6c, $38, $00, $7c, $00, $00 ),
      ( $30, $00, $30, $60, $c0, $cc, $78, $00 ),
      ( $00, $00, $00, $fc, $c0, $c0, $00, $00 ),
      ( $00, $00, $00, $fc, $0c, $0c, $00, $00 ),
      ( $c3, $c6, $cc, $de, $33, $66, $cc, $0f ),
      ( $c3, $c6, $cc, $db, $37, $6f, $cf, $03 ),
      ( $18, $18, $00, $18, $18, $18, $18, $00 ),
      ( $00, $33, $66, $cc, $66, $33, $00, $00 ),
      ( $00, $cc, $66, $33, $66, $cc, $00, $00 ),
      ( $22, $88, $22, $88, $22, $88, $22, $88 ),
      ( $55, $aa, $55, $aa, $55, $aa, $55, $aa ),
      ( $db, $77, $db, $ee, $db, $77, $db, $ee ),
      ( $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $f8, $18, $18, $18 ),
      ( $18, $18, $f8, $18, $f8, $18, $18, $18 ),
      ( $36, $36, $36, $36, $f6, $36, $36, $36 ),
      ( $00, $00, $00, $00, $fe, $36, $36, $36 ),
      ( $00, $00, $f8, $18, $f8, $18, $18, $18 ),
      ( $36, $36, $f6, $06, $f6, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $00, $00, $fe, $06, $f6, $36, $36, $36 ),
      ( $36, $36, $f6, $06, $fe, $00, $00, $00 ),
      ( $36, $36, $36, $36, $fe, $00, $00, $00 ),
      ( $18, $18, $f8, $18, $f8, $00, $00, $00 ),
      ( $00, $00, $00, $00, $f8, $18, $18, $18 ),
      ( $18, $18, $18, $18, $1f, $00, $00, $00 ),
      ( $18, $18, $18, $18, $ff, $00, $00, $00 ),
      ( $00, $00, $00, $00, $ff, $18, $18, $18 ),
      ( $18, $18, $18, $18, $1f, $18, $18, $18 ),
      ( $00, $00, $00, $00, $ff, $00, $00, $00 ),
      ( $18, $18, $18, $18, $ff, $18, $18, $18 ),
      ( $18, $18, $1f, $18, $1f, $18, $18, $18 ),
      ( $36, $36, $36, $36, $37, $36, $36, $36 ),
      ( $36, $36, $37, $30, $3f, $00, $00, $00 ),
      ( $00, $00, $3f, $30, $37, $36, $36, $36 ),
      ( $36, $36, $f7, $00, $ff, $00, $00, $00 ),
      ( $00, $00, $ff, $00, $f7, $36, $36, $36 ),
      ( $36, $36, $37, $30, $37, $36, $36, $36 ),
      ( $00, $00, $ff, $00, $ff, $00, $00, $00 ),
      ( $36, $36, $f7, $00, $f7, $36, $36, $36 ),
      ( $18, $18, $ff, $00, $ff, $00, $00, $00 ),
      ( $36, $36, $36, $36, $ff, $00, $00, $00 ),
      ( $00, $00, $ff, $00, $ff, $18, $18, $18 ),
      ( $00, $00, $00, $00, $ff, $36, $36, $36 ),
      ( $36, $36, $36, $36, $3f, $00, $00, $00 ),
      ( $18, $18, $1f, $18, $1f, $00, $00, $00 ),
      ( $00, $00, $1f, $18, $1f, $18, $18, $18 ),
      ( $00, $00, $00, $00, $3f, $36, $36, $36 ),
      ( $36, $36, $36, $36, $ff, $36, $36, $36 ),
      ( $18, $18, $ff, $18, $ff, $18, $18, $18 ),
      ( $18, $18, $18, $18, $f8, $00, $00, $00 ),
      ( $00, $00, $00, $00, $1f, $18, $18, $18 ),
      ( $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff ),
      ( $00, $00, $00, $00, $ff, $ff, $ff, $ff ),
      ( $f0, $f0, $f0, $f0, $f0, $f0, $f0, $f0 ),
      ( $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ),
      ( $ff, $ff, $ff, $ff, $00, $00, $00, $00 ),
      ( $00, $00, $76, $dc, $c8, $dc, $76, $00 ),
      ( $00, $78, $cc, $f8, $cc, $f8, $c0, $c0 ),
      ( $00, $fc, $cc, $c0, $c0, $c0, $c0, $00 ),
      ( $00, $fe, $6c, $6c, $6c, $6c, $6c, $00 ),
      ( $fc, $cc, $60, $30, $60, $cc, $fc, $00 ),
      ( $00, $00, $7e, $d8, $d8, $d8, $70, $00 ),
      ( $00, $66, $66, $66, $66, $7c, $60, $c0 ),
      ( $00, $76, $dc, $18, $18, $18, $18, $00 ),
      ( $fc, $30, $78, $cc, $cc, $78, $30, $fc ),
      ( $38, $6c, $c6, $fe, $c6, $6c, $38, $00 ),
      ( $38, $6c, $c6, $c6, $6c, $6c, $ee, $00 ),
      ( $1c, $30, $18, $7c, $cc, $cc, $78, $00 ),
      ( $00, $00, $7e, $db, $db, $7e, $00, $00 ),
      ( $06, $0c, $7e, $db, $db, $7e, $60, $c0 ),
      ( $38, $60, $c0, $f8, $c0, $60, $38, $00 ),
      ( $78, $cc, $cc, $cc, $cc, $cc, $cc, $00 ),
      ( $00, $fc, $00, $fc, $00, $fc, $00, $00 ),
      ( $30, $30, $fc, $30, $30, $00, $fc, $00 ),
      ( $60, $30, $18, $30, $60, $00, $fc, $00 ),
      ( $18, $30, $60, $30, $18, $00, $fc, $00 ),
      ( $0e, $1b, $1b, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $d8, $d8, $70 ),
      ( $30, $30, $00, $fc, $00, $30, $30, $00 ),
      ( $00, $76, $dc, $00, $76, $dc, $00, $00 ),
      ( $38, $6c, $6c, $38, $00, $00, $00, $00 ),
      ( $00, $00, $00, $18, $18, $00, $00, $00 ),
      ( $00, $00, $00, $00, $18, $00, $00, $00 ),
      ( $0f, $0c, $0c, $0c, $ec, $6c, $3c, $1c ),
      ( $78, $6c, $6c, $6c, $6c, $00, $00, $00 ),
      ( $70, $18, $30, $60, $78, $00, $00, $00 ),
      ( $00, $00, $3c, $3c, $3c, $3c, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00 )
   );

const
   vgafont14 : array[0..255,0..13] of byte = (
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $7e, $81, $a5, $81, $81, $bd, $99, $81, $7e, $00, $00, $00 ),
      ( $00, $00, $7e, $ff, $db, $ff, $ff, $c3, $e7, $ff, $7e, $00, $00, $00 ),
      ( $00, $00, $00, $6c, $fe, $fe, $fe, $fe, $7c, $38, $10, $00, $00, $00 ),
      ( $00, $00, $00, $10, $38, $7c, $fe, $7c, $38, $10, $00, $00, $00, $00 ),
      ( $00, $00, $18, $3c, $3c, $e7, $e7, $e7, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $00, $18, $3c, $7e, $ff, $ff, $7e, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $18, $3c, $3c, $18, $00, $00, $00, $00, $00 ),
      ( $ff, $ff, $ff, $ff, $ff, $e7, $c3, $c3, $e7, $ff, $ff, $ff, $ff, $ff ),
      ( $00, $00, $00, $00, $3c, $66, $42, $42, $66, $3c, $00, $00, $00, $00 ),
      ( $ff, $ff, $ff, $ff, $c3, $99, $bd, $bd, $99, $c3, $ff, $ff, $ff, $ff ),
      ( $00, $00, $1e, $0e, $1a, $32, $78, $cc, $cc, $cc, $78, $00, $00, $00 ),
      ( $00, $00, $3c, $66, $66, $66, $3c, $18, $7e, $18, $18, $00, $00, $00 ),
      ( $00, $00, $3f, $33, $3f, $30, $30, $30, $70, $f0, $e0, $00, $00, $00 ),
      ( $00, $00, $7f, $63, $7f, $63, $63, $63, $67, $e7, $e6, $c0, $00, $00 ),
      ( $00, $00, $18, $18, $db, $3c, $e7, $3c, $db, $18, $18, $00, $00, $00 ),
      ( $00, $00, $80, $c0, $e0, $f8, $fe, $f8, $e0, $c0, $80, $00, $00, $00 ),
      ( $00, $00, $02, $06, $0e, $3e, $fe, $3e, $0e, $06, $02, $00, $00, $00 ),
      ( $00, $00, $18, $3c, $7e, $18, $18, $18, $7e, $3c, $18, $00, $00, $00 ),
      ( $00, $00, $66, $66, $66, $66, $66, $66, $00, $66, $66, $00, $00, $00 ),
      ( $00, $00, $7f, $db, $db, $db, $7b, $1b, $1b, $1b, $1b, $00, $00, $00 ),
      ( $00, $7c, $c6, $60, $38, $6c, $c6, $c6, $6c, $38, $0c, $c6, $7c, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $fe, $fe, $fe, $00, $00, $00 ),
      ( $00, $00, $18, $3c, $7e, $18, $18, $18, $7e, $3c, $18, $7e, $00, $00 ),
      ( $00, $00, $18, $3c, $7e, $18, $18, $18, $18, $18, $18, $00, $00, $00 ),
      ( $00, $00, $18, $18, $18, $18, $18, $18, $7e, $3c, $18, $00, $00, $00 ),
      ( $00, $00, $00, $00, $18, $0c, $fe, $0c, $18, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $30, $60, $fe, $60, $30, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $c0, $c0, $c0, $fe, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $28, $6c, $fe, $6c, $28, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $10, $38, $38, $7c, $7c, $fe, $fe, $00, $00, $00, $00 ),
      ( $00, $00, $00, $fe, $fe, $7c, $7c, $38, $38, $10, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $18, $3c, $3c, $3c, $18, $18, $00, $18, $18, $00, $00, $00 ),
      ( $00, $66, $66, $66, $24, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $6c, $6c, $fe, $6c, $6c, $6c, $fe, $6c, $6c, $00, $00, $00 ),
      ( $18, $18, $7c, $c6, $c2, $c0, $7c, $06, $86, $c6, $7c, $18, $18, $00 ),
      ( $00, $00, $00, $00, $c2, $c6, $0c, $18, $30, $66, $c6, $00, $00, $00 ),
      ( $00, $00, $38, $6c, $6c, $38, $76, $dc, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $30, $30, $30, $60, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $0c, $18, $30, $30, $30, $30, $30, $18, $0c, $00, $00, $00 ),
      ( $00, $00, $30, $18, $0c, $0c, $0c, $0c, $0c, $18, $30, $00, $00, $00 ),
      ( $00, $00, $00, $00, $66, $3c, $ff, $3c, $66, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $18, $18, $7e, $18, $18, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $18, $18, $18, $30, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $fe, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $18, $18, $00, $00, $00 ),
      ( $00, $00, $02, $06, $0c, $18, $30, $60, $c0, $80, $00, $00, $00, $00 ),
      ( $00, $00, $7c, $c6, $ce, $de, $f6, $e6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $18, $38, $78, $18, $18, $18, $18, $18, $7e, $00, $00, $00 ),
      ( $00, $00, $7c, $c6, $06, $0c, $18, $30, $60, $c6, $fe, $00, $00, $00 ),
      ( $00, $00, $7c, $c6, $06, $06, $3c, $06, $06, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $0c, $1c, $3c, $6c, $cc, $fe, $0c, $0c, $1e, $00, $00, $00 ),
      ( $00, $00, $fe, $c0, $c0, $c0, $fc, $06, $06, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $38, $60, $c0, $c0, $fc, $c6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $fe, $c6, $06, $0c, $18, $30, $30, $30, $30, $00, $00, $00 ),
      ( $00, $00, $7c, $c6, $c6, $c6, $7c, $c6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $7c, $c6, $c6, $c6, $7e, $06, $06, $0c, $78, $00, $00, $00 ),
      ( $00, $00, $00, $18, $18, $00, $00, $00, $18, $18, $00, $00, $00, $00 ),
      ( $00, $00, $00, $18, $18, $00, $00, $00, $18, $18, $30, $00, $00, $00 ),
      ( $00, $00, $06, $0c, $18, $30, $60, $30, $18, $0c, $06, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7e, $00, $00, $7e, $00, $00, $00, $00, $00 ),
      ( $00, $00, $60, $30, $18, $0c, $06, $0c, $18, $30, $60, $00, $00, $00 ),
      ( $00, $00, $7c, $c6, $c6, $0c, $18, $18, $00, $18, $18, $00, $00, $00 ),
      ( $00, $00, $7c, $c6, $c6, $de, $de, $de, $dc, $c0, $7c, $00, $00, $00 ),
      ( $00, $00, $10, $38, $6c, $c6, $c6, $fe, $c6, $c6, $c6, $00, $00, $00 ),
      ( $00, $00, $fc, $66, $66, $66, $7c, $66, $66, $66, $fc, $00, $00, $00 ),
      ( $00, $00, $3c, $66, $c2, $c0, $c0, $c0, $c2, $66, $3c, $00, $00, $00 ),
      ( $00, $00, $f8, $6c, $66, $66, $66, $66, $66, $6c, $f8, $00, $00, $00 ),
      ( $00, $00, $fe, $66, $62, $68, $78, $68, $62, $66, $fe, $00, $00, $00 ),
      ( $00, $00, $fe, $66, $62, $68, $78, $68, $60, $60, $f0, $00, $00, $00 ),
      ( $00, $00, $3c, $66, $c2, $c0, $c0, $de, $c6, $66, $3a, $00, $00, $00 ),
      ( $00, $00, $c6, $c6, $c6, $c6, $fe, $c6, $c6, $c6, $c6, $00, $00, $00 ),
      ( $00, $00, $3c, $18, $18, $18, $18, $18, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $00, $1e, $0c, $0c, $0c, $0c, $0c, $cc, $cc, $78, $00, $00, $00 ),
      ( $00, $00, $e6, $66, $6c, $6c, $78, $6c, $6c, $66, $e6, $00, $00, $00 ),
      ( $00, $00, $f0, $60, $60, $60, $60, $60, $62, $66, $fe, $00, $00, $00 ),
      ( $00, $00, $c6, $ee, $fe, $fe, $d6, $c6, $c6, $c6, $c6, $00, $00, $00 ),
      ( $00, $00, $c6, $e6, $f6, $fe, $de, $ce, $c6, $c6, $c6, $00, $00, $00 ),
      ( $00, $00, $38, $6c, $c6, $c6, $c6, $c6, $c6, $6c, $38, $00, $00, $00 ),
      ( $00, $00, $fc, $66, $66, $66, $7c, $60, $60, $60, $f0, $00, $00, $00 ),
      ( $00, $00, $7c, $c6, $c6, $c6, $c6, $d6, $de, $7c, $0c, $0e, $00, $00 ),
      ( $00, $00, $fc, $66, $66, $66, $7c, $6c, $66, $66, $e6, $00, $00, $00 ),
      ( $00, $00, $7c, $c6, $c6, $60, $38, $0c, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $7e, $7e, $5a, $18, $18, $18, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $00, $c6, $c6, $c6, $c6, $c6, $c6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $c6, $c6, $c6, $c6, $c6, $c6, $6c, $38, $10, $00, $00, $00 ),
      ( $00, $00, $c6, $c6, $c6, $c6, $d6, $d6, $fe, $7c, $6c, $00, $00, $00 ),
      ( $00, $00, $c6, $c6, $6c, $38, $38, $38, $6c, $c6, $c6, $00, $00, $00 ),
      ( $00, $00, $66, $66, $66, $66, $3c, $18, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $00, $fe, $c6, $8c, $18, $30, $60, $c2, $c6, $fe, $00, $00, $00 ),
      ( $00, $00, $3c, $30, $30, $30, $30, $30, $30, $30, $3c, $00, $00, $00 ),
      ( $00, $00, $80, $c0, $e0, $70, $38, $1c, $0e, $06, $02, $00, $00, $00 ),
      ( $00, $00, $3c, $0c, $0c, $0c, $0c, $0c, $0c, $0c, $3c, $00, $00, $00 ),
      ( $10, $38, $6c, $c6, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $ff, $00 ),
      ( $30, $30, $18, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $78, $0c, $7c, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $00, $e0, $60, $60, $78, $6c, $66, $66, $66, $7c, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7c, $c6, $c0, $c0, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $1c, $0c, $0c, $3c, $6c, $cc, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7c, $c6, $fe, $c0, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $38, $6c, $64, $60, $f0, $60, $60, $60, $f0, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $76, $cc, $cc, $cc, $7c, $0c, $cc, $78, $00 ),
      ( $00, $00, $e0, $60, $60, $6c, $76, $66, $66, $66, $e6, $00, $00, $00 ),
      ( $00, $00, $18, $18, $00, $38, $18, $18, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $00, $06, $06, $00, $0e, $06, $06, $06, $06, $66, $66, $3c, $00 ),
      ( $00, $00, $e0, $60, $60, $66, $6c, $78, $6c, $66, $e6, $00, $00, $00 ),
      ( $00, $00, $38, $18, $18, $18, $18, $18, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $ec, $fe, $d6, $d6, $d6, $c6, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $dc, $66, $66, $66, $66, $66, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7c, $c6, $c6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $dc, $66, $66, $66, $7c, $60, $60, $f0, $00 ),
      ( $00, $00, $00, $00, $00, $76, $cc, $cc, $cc, $7c, $0c, $0c, $1e, $00 ),
      ( $00, $00, $00, $00, $00, $dc, $76, $66, $60, $60, $f0, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7c, $c6, $70, $1c, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $10, $30, $30, $fc, $30, $30, $30, $36, $1c, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $cc, $cc, $cc, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $66, $66, $66, $66, $3c, $18, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $c6, $c6, $d6, $d6, $fe, $6c, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $c6, $6c, $38, $38, $6c, $c6, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $c6, $c6, $c6, $c6, $7e, $06, $0c, $f8, $00 ),
      ( $00, $00, $00, $00, $00, $fe, $cc, $18, $30, $66, $fe, $00, $00, $00 ),
      ( $00, $00, $0e, $18, $18, $18, $70, $18, $18, $18, $0e, $00, $00, $00 ),
      ( $00, $00, $18, $18, $18, $18, $00, $18, $18, $18, $18, $00, $00, $00 ),
      ( $00, $00, $70, $18, $18, $18, $0e, $18, $18, $18, $70, $00, $00, $00 ),
      ( $00, $00, $76, $dc, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $10, $38, $6c, $c6, $c6, $fe, $00, $00, $00, $00 ),
      ( $00, $00, $3c, $66, $c2, $c0, $c0, $c2, $66, $3c, $0c, $06, $7c, $00 ),
      ( $00, $00, $cc, $cc, $00, $cc, $cc, $cc, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $0c, $18, $30, $00, $7c, $c6, $fe, $c0, $c6, $7c, $00, $00, $00 ),
      ( $00, $10, $38, $6c, $00, $78, $0c, $7c, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $00, $cc, $cc, $00, $78, $0c, $7c, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $78, $0c, $7c, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $38, $6c, $38, $00, $78, $0c, $7c, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $00, $00, $00, $3c, $66, $60, $66, $3c, $0c, $06, $3c, $00, $00 ),
      ( $00, $10, $38, $6c, $00, $7c, $c6, $fe, $c0, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $cc, $cc, $00, $7c, $c6, $fe, $c0, $c6, $7c, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $7c, $c6, $fe, $c0, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $66, $66, $00, $38, $18, $18, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $18, $3c, $66, $00, $38, $18, $18, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $38, $18, $18, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $c6, $c6, $10, $38, $6c, $c6, $c6, $fe, $c6, $c6, $00, $00, $00 ),
      ( $38, $6c, $38, $00, $38, $6c, $c6, $c6, $fe, $c6, $c6, $00, $00, $00 ),
      ( $18, $30, $60, $00, $fe, $66, $60, $7c, $60, $66, $fe, $00, $00, $00 ),
      ( $00, $00, $00, $00, $cc, $76, $36, $7e, $d8, $d8, $6e, $00, $00, $00 ),
      ( $00, $00, $3e, $6c, $cc, $cc, $fe, $cc, $cc, $cc, $ce, $00, $00, $00 ),
      ( $00, $10, $38, $6c, $00, $7c, $c6, $c6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $c6, $c6, $00, $7c, $c6, $c6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $7c, $c6, $c6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $30, $78, $cc, $00, $cc, $cc, $cc, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $cc, $cc, $cc, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $00, $c6, $c6, $00, $c6, $c6, $c6, $c6, $7e, $06, $0c, $78, $00 ),
      ( $00, $c6, $c6, $38, $6c, $c6, $c6, $c6, $c6, $6c, $38, $00, $00, $00 ),
      ( $00, $c6, $c6, $00, $c6, $c6, $c6, $c6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $18, $18, $3c, $66, $60, $60, $66, $3c, $18, $18, $00, $00, $00 ),
      ( $00, $38, $6c, $64, $60, $f0, $60, $60, $60, $e6, $fc, $00, $00, $00 ),
      ( $00, $00, $66, $66, $3c, $18, $7e, $18, $7e, $18, $18, $00, $00, $00 ),
      ( $00, $f8, $cc, $cc, $f8, $c4, $cc, $de, $cc, $cc, $c6, $00, $00, $00 ),
      ( $00, $0e, $1b, $18, $18, $18, $7e, $18, $18, $18, $18, $d8, $70, $00 ),
      ( $00, $18, $30, $60, $00, $78, $0c, $7c, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $0c, $18, $30, $00, $38, $18, $18, $18, $18, $3c, $00, $00, $00 ),
      ( $00, $18, $30, $60, $00, $7c, $c6, $c6, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $18, $30, $60, $00, $cc, $cc, $cc, $cc, $cc, $76, $00, $00, $00 ),
      ( $00, $00, $76, $dc, $00, $dc, $66, $66, $66, $66, $66, $00, $00, $00 ),
      ( $76, $dc, $00, $c6, $e6, $f6, $fe, $de, $ce, $c6, $c6, $00, $00, $00 ),
      ( $00, $3c, $6c, $6c, $3e, $00, $7e, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $38, $6c, $6c, $38, $00, $7c, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $30, $30, $00, $30, $30, $60, $c6, $c6, $7c, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $fe, $c0, $c0, $c0, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $fe, $06, $06, $06, $00, $00, $00, $00 ),
      ( $00, $c0, $c0, $c6, $cc, $d8, $30, $60, $dc, $86, $0c, $18, $3e, $00 ),
      ( $00, $c0, $c0, $c6, $cc, $d8, $30, $66, $ce, $9e, $3e, $06, $06, $00 ),
      ( $00, $00, $18, $18, $00, $18, $18, $3c, $3c, $3c, $18, $00, $00, $00 ),
      ( $00, $00, $00, $00, $36, $6c, $d8, $6c, $36, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $d8, $6c, $36, $6c, $d8, $00, $00, $00, $00, $00 ),
      ( $11, $44, $11, $44, $11, $44, $11, $44, $11, $44, $11, $44, $11, $44 ),
      ( $55, $aa, $55, $aa, $55, $aa, $55, $aa, $55, $aa, $55, $aa, $55, $aa ),
      ( $dd, $77, $dd, $77, $dd, $77, $dd, $77, $dd, $77, $dd, $77, $dd, $77 ),
      ( $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $f8, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $f8, $18, $f8, $18, $18, $18, $18, $18, $18 ),
      ( $36, $36, $36, $36, $36, $36, $36, $f6, $36, $36, $36, $36, $36, $36 ),
      ( $00, $00, $00, $00, $00, $00, $00, $fe, $36, $36, $36, $36, $36, $36 ),
      ( $00, $00, $00, $00, $00, $f8, $18, $f8, $18, $18, $18, $18, $18, $18 ),
      ( $36, $36, $36, $36, $36, $f6, $06, $f6, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $00, $00, $00, $00, $00, $fe, $06, $f6, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $f6, $06, $fe, $00, $00, $00, $00, $00, $00 ),
      ( $36, $36, $36, $36, $36, $36, $36, $fe, $00, $00, $00, $00, $00, $00 ),
      ( $18, $18, $18, $18, $18, $f8, $18, $f8, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $f8, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $1f, $00, $00, $00, $00, $00, $00 ),
      ( $18, $18, $18, $18, $18, $18, $18, $ff, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $ff, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $1f, $18, $18, $18, $18, $18, $18 ),
      ( $00, $00, $00, $00, $00, $00, $00, $ff, $00, $00, $00, $00, $00, $00 ),
      ( $18, $18, $18, $18, $18, $18, $18, $ff, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $1f, $18, $1f, $18, $18, $18, $18, $18, $18 ),
      ( $36, $36, $36, $36, $36, $36, $36, $37, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $37, $30, $3f, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $3f, $30, $37, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $f7, $00, $ff, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $ff, $00, $f7, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $37, $30, $37, $36, $36, $36, $36, $36, $36 ),
      ( $00, $00, $00, $00, $00, $ff, $00, $ff, $00, $00, $00, $00, $00, $00 ),
      ( $36, $36, $36, $36, $36, $f7, $00, $f7, $36, $36, $36, $36, $36, $36 ),
      ( $18, $18, $18, $18, $18, $ff, $00, $ff, $00, $00, $00, $00, $00, $00 ),
      ( $36, $36, $36, $36, $36, $36, $36, $ff, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $ff, $00, $ff, $18, $18, $18, $18, $18, $18 ),
      ( $00, $00, $00, $00, $00, $00, $00, $ff, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $36, $36, $3f, $00, $00, $00, $00, $00, $00 ),
      ( $18, $18, $18, $18, $18, $1f, $18, $1f, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $1f, $18, $1f, $18, $18, $18, $18, $18, $18 ),
      ( $00, $00, $00, $00, $00, $00, $00, $3f, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $36, $36, $ff, $36, $36, $36, $36, $36, $36 ),
      ( $18, $18, $18, $18, $18, $ff, $18, $ff, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $f8, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $1f, $18, $18, $18, $18, $18, $18 ),
      ( $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff, $ff ),
      ( $00, $00, $00, $00, $00, $00, $00, $ff, $ff, $ff, $ff, $ff, $ff, $ff ),
      ( $f0, $f0, $f0, $f0, $f0, $f0, $f0, $f0, $f0, $f0, $f0, $f0, $f0, $f0 ),
      ( $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f, $0f ),
      ( $ff, $ff, $ff, $ff, $ff, $ff, $ff, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $76, $dc, $d8, $d8, $dc, $76, $00, $00, $00 ),
      ( $00, $00, $00, $00, $7c, $c6, $fc, $c6, $c6, $fc, $c0, $c0, $40, $00 ),
      ( $00, $00, $fe, $c6, $c6, $c0, $c0, $c0, $c0, $c0, $c0, $00, $00, $00 ),
      ( $00, $00, $00, $00, $fe, $6c, $6c, $6c, $6c, $6c, $6c, $00, $00, $00 ),
      ( $00, $00, $fe, $c6, $60, $30, $18, $30, $60, $c6, $fe, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7e, $d8, $d8, $d8, $d8, $70, $00, $00, $00 ),
      ( $00, $00, $00, $00, $66, $66, $66, $66, $7c, $60, $60, $c0, $00, $00 ),
      ( $00, $00, $00, $00, $76, $dc, $18, $18, $18, $18, $18, $00, $00, $00 ),
      ( $00, $00, $7e, $18, $3c, $66, $66, $66, $3c, $18, $7e, $00, $00, $00 ),
      ( $00, $00, $38, $6c, $c6, $c6, $fe, $c6, $c6, $6c, $38, $00, $00, $00 ),
      ( $00, $00, $38, $6c, $c6, $c6, $c6, $6c, $6c, $6c, $ee, $00, $00, $00 ),
      ( $00, $00, $1e, $30, $18, $0c, $3e, $66, $66, $66, $3c, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7e, $db, $db, $7e, $00, $00, $00, $00, $00 ),
      ( $00, $00, $03, $06, $7e, $db, $db, $f3, $7e, $60, $c0, $00, $00, $00 ),
      ( $00, $00, $1c, $30, $60, $60, $7c, $60, $60, $30, $1c, $00, $00, $00 ),
      ( $00, $00, $00, $7c, $c6, $c6, $c6, $c6, $c6, $c6, $c6, $00, $00, $00 ),
      ( $00, $00, $00, $fe, $00, $00, $fe, $00, $00, $fe, $00, $00, $00, $00 ),
      ( $00, $00, $00, $18, $18, $7e, $18, $18, $00, $00, $ff, $00, $00, $00 ),
      ( $00, $00, $30, $18, $0c, $06, $0c, $18, $30, $00, $7e, $00, $00, $00 ),
      ( $00, $00, $0c, $18, $30, $60, $30, $18, $0c, $00, $7e, $00, $00, $00 ),
      ( $00, $00, $0e, $1b, $1b, $18, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $18, $d8, $d8, $70, $00, $00, $00 ),
      ( $00, $00, $00, $18, $18, $00, $7e, $00, $18, $18, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $76, $dc, $00, $76, $dc, $00, $00, $00, $00, $00 ),
      ( $00, $38, $6c, $6c, $38, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $18, $18, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $18, $00, $00, $00, $00, $00, $00 ),
      ( $00, $0f, $0c, $0c, $0c, $0c, $0c, $ec, $6c, $3c, $1c, $00, $00, $00 ),
      ( $00, $d8, $6c, $6c, $6c, $6c, $6c, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $70, $d8, $30, $60, $c8, $f8, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $7c, $7c, $7c, $7c, $7c, $7c, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 )
   );

const
   vgafont : array[0..255,0..15] of byte = (
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $7E, $81, $A5, $81, $81, $A5, $99, $81, $81, $7E, $00, $00, $00, $00 ),
      ( $00, $00, $7E, $FF, $DB, $FF, $FF, $DB, $E7, $FF, $FF, $7E, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $6C, $FE, $FE, $FE, $FE, $7C, $38, $10, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $10, $38, $7C, $FE, $7C, $38, $10, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $18, $3C, $3C, $E7, $E7, $E7, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $18, $3C, $7E, $FF, $FF, $7E, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $18, $3C, $3C, $18, $00, $00, $00, $00, $00, $00 ),
      ( $FF, $FF, $FF, $FF, $FF, $FF, $E7, $C3, $C3, $E7, $FF, $FF, $FF, $FF, $FF, $FF ),
      ( $00, $00, $00, $00, $00, $3C, $66, $42, $42, $66, $3C, $00, $00, $00, $00, $00 ),
      ( $FF, $FF, $FF, $FF, $FF, $C3, $99, $BD, $BD, $99, $C3, $FF, $FF, $FF, $FF, $FF ),
      ( $00, $00, $1E, $06, $0E, $1A, $78, $CC, $CC, $CC, $CC, $78, $00, $00, $00, $00 ),
      ( $00, $00, $3C, $66, $66, $66, $66, $3C, $18, $7E, $18, $18, $00, $00, $00, $00 ),
      ( $00, $00, $3F, $33, $3F, $30, $30, $30, $30, $70, $F0, $E0, $00, $00, $00, $00 ),
      ( $00, $00, $7F, $63, $7F, $63, $63, $63, $63, $67, $E7, $E6, $C0, $00, $00, $00 ),
      ( $00, $00, $00, $18, $18, $DB, $3C, $E7, $3C, $DB, $18, $18, $00, $00, $00, $00 ),
      ( $00, $80, $C0, $E0, $F0, $F8, $FE, $F8, $F0, $E0, $C0, $80, $00, $00, $00, $00 ),
      ( $00, $02, $06, $0E, $1E, $3E, $FE, $3E, $1E, $0E, $06, $02, $00, $00, $00, $00 ),
      ( $00, $00, $18, $3C, $7E, $18, $18, $18, $7E, $3C, $18, $00, $00, $00, $00, $00 ),
      ( $00, $00, $66, $66, $66, $66, $66, $66, $66, $00, $66, $66, $00, $00, $00, $00 ),
      ( $00, $00, $7F, $DB, $DB, $DB, $7B, $1B, $1B, $1B, $1B, $1B, $00, $00, $00, $00 ),
      ( $00, $7C, $C6, $60, $38, $6C, $C6, $C6, $6C, $38, $0C, $C6, $7C, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $FE, $FE, $FE, $FE, $00, $00, $00, $00 ),
      ( $00, $00, $18, $3C, $7E, $18, $18, $18, $7E, $3C, $18, $7E, $00, $00, $00, $00 ),
      ( $00, $00, $18, $3C, $7E, $18, $18, $18, $18, $18, $18, $18, $00, $00, $00, $00 ),
      ( $00, $00, $18, $18, $18, $18, $18, $18, $18, $7E, $3C, $18, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $18, $0C, $FE, $0C, $18, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $30, $60, $FE, $60, $30, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $C0, $C0, $C0, $FE, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $28, $6C, $FE, $6C, $28, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $10, $38, $38, $7C, $7C, $FE, $FE, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $FE, $FE, $7C, $7C, $38, $38, $10, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $18, $3C, $3C, $3C, $18, $18, $18, $00, $18, $18, $00, $00, $00, $00 ),
      ( $00, $66, $66, $66, $24, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $6C, $6C, $FE, $6C, $6C, $6C, $FE, $6C, $6C, $00, $00, $00, $00 ),
      ( $18, $18, $7C, $C6, $C2, $C0, $7C, $06, $06, $86, $C6, $7C, $18, $18, $00, $00 ),
      ( $00, $00, $00, $00, $C2, $C6, $0C, $18, $30, $60, $C6, $86, $00, $00, $00, $00 ),
      ( $00, $00, $38, $6C, $6C, $38, $76, $DC, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $30, $30, $30, $60, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $0C, $18, $30, $30, $30, $30, $30, $30, $18, $0C, $00, $00, $00, $00 ),
      ( $00, $00, $30, $18, $0C, $0C, $0C, $0C, $0C, $0C, $18, $30, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $66, $3C, $FF, $3C, $66, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $18, $18, $7E, $18, $18, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $18, $18, $18, $30, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $FE, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $18, $18, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $02, $06, $0C, $18, $30, $60, $C0, $80, $00, $00, $00, $00 ),
      ( $00, $00, $38, $6C, $C6, $C6, $D6, $D6, $C6, $C6, $6C, $38, $00, $00, $00, $00 ),
      ( $00, $00, $18, $38, $78, $18, $18, $18, $18, $18, $18, $7E, $00, $00, $00, $00 ),
      ( $00, $00, $7C, $C6, $06, $0C, $18, $30, $60, $C0, $C6, $FE, $00, $00, $00, $00 ),
      ( $00, $00, $7C, $C6, $06, $06, $3C, $06, $06, $06, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $0C, $1C, $3C, $6C, $CC, $FE, $0C, $0C, $0C, $1E, $00, $00, $00, $00 ),
      ( $00, $00, $FE, $C0, $C0, $C0, $FC, $06, $06, $06, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $38, $60, $C0, $C0, $FC, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $FE, $C6, $06, $06, $0C, $18, $30, $30, $30, $30, $00, $00, $00, $00 ),
      ( $00, $00, $7C, $C6, $C6, $C6, $7C, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $7C, $C6, $C6, $C6, $7E, $06, $06, $06, $0C, $78, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $18, $18, $00, $00, $00, $18, $18, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $18, $18, $00, $00, $00, $18, $18, $30, $00, $00, $00, $00 ),
      ( $00, $00, $00, $06, $0C, $18, $30, $60, $30, $18, $0C, $06, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7E, $00, $00, $7E, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $60, $30, $18, $0C, $06, $0C, $18, $30, $60, $00, $00, $00, $00 ),
      ( $00, $00, $7C, $C6, $C6, $0C, $18, $18, $18, $00, $18, $18, $00, $00, $00, $00 ),
      ( $00, $00, $00, $7C, $C6, $C6, $DE, $DE, $DE, $DC, $C0, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $10, $38, $6C, $C6, $C6, $FE, $C6, $C6, $C6, $C6, $00, $00, $00, $00 ),
      ( $00, $00, $FC, $66, $66, $66, $7C, $66, $66, $66, $66, $FC, $00, $00, $00, $00 ),
      ( $00, $00, $3C, $66, $C2, $C0, $C0, $C0, $C0, $C2, $66, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $F8, $6C, $66, $66, $66, $66, $66, $66, $6C, $F8, $00, $00, $00, $00 ),
      ( $00, $00, $FE, $66, $62, $68, $78, $68, $60, $62, $66, $FE, $00, $00, $00, $00 ),
      ( $00, $00, $FE, $66, $62, $68, $78, $68, $60, $60, $60, $F0, $00, $00, $00, $00 ),
      ( $00, $00, $3C, $66, $C2, $C0, $C0, $DE, $C6, $C6, $66, $3A, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $C6, $C6, $C6, $FE, $C6, $C6, $C6, $C6, $C6, $00, $00, $00, $00 ),
      ( $00, $00, $3C, $18, $18, $18, $18, $18, $18, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $1E, $0C, $0C, $0C, $0C, $0C, $CC, $CC, $CC, $78, $00, $00, $00, $00 ),
      ( $00, $00, $E6, $66, $66, $6C, $78, $78, $6C, $66, $66, $E6, $00, $00, $00, $00 ),
      ( $00, $00, $F0, $60, $60, $60, $60, $60, $60, $62, $66, $FE, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $EE, $FE, $FE, $D6, $C6, $C6, $C6, $C6, $C6, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $E6, $F6, $FE, $DE, $CE, $C6, $C6, $C6, $C6, $00, $00, $00, $00 ),
      ( $00, $00, $7C, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $FC, $66, $66, $66, $7C, $60, $60, $60, $60, $F0, $00, $00, $00, $00 ),
      ( $00, $00, $7C, $C6, $C6, $C6, $C6, $C6, $C6, $D6, $DE, $7C, $0C, $0E, $00, $00 ),
      ( $00, $00, $FC, $66, $66, $66, $7C, $6C, $66, $66, $66, $E6, $00, $00, $00, $00 ),
      ( $00, $00, $7C, $C6, $C6, $60, $38, $0C, $06, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $7E, $7E, $5A, $18, $18, $18, $18, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $6C, $38, $10, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $C6, $C6, $C6, $D6, $D6, $D6, $FE, $EE, $6C, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $C6, $6C, $7C, $38, $38, $7C, $6C, $C6, $C6, $00, $00, $00, $00 ),
      ( $00, $00, $66, $66, $66, $66, $3C, $18, $18, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $FE, $C6, $86, $0C, $18, $30, $60, $C2, $C6, $FE, $00, $00, $00, $00 ),
      ( $00, $00, $3C, $30, $30, $30, $30, $30, $30, $30, $30, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $80, $C0, $E0, $70, $38, $1C, $0E, $06, $02, $00, $00, $00, $00 ),
      ( $00, $00, $3C, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $0C, $3C, $00, $00, $00, $00 ),
      ( $10, $38, $6C, $C6, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $FF, $00, $00 ),
      ( $30, $30, $18, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $78, $0C, $7C, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $00, $E0, $60, $60, $78, $6C, $66, $66, $66, $66, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7C, $C6, $C0, $C0, $C0, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $1C, $0C, $0C, $3C, $6C, $CC, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7C, $C6, $FE, $C0, $C0, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $38, $6C, $64, $60, $F0, $60, $60, $60, $60, $F0, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $76, $CC, $CC, $CC, $CC, $CC, $7C, $0C, $CC, $78, $00 ),
      ( $00, $00, $E0, $60, $60, $6C, $76, $66, $66, $66, $66, $E6, $00, $00, $00, $00 ),
      ( $00, $00, $18, $18, $00, $38, $18, $18, $18, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $06, $06, $00, $0E, $06, $06, $06, $06, $06, $06, $66, $66, $3C, $00 ),
      ( $00, $00, $E0, $60, $60, $66, $6C, $78, $78, $6C, $66, $E6, $00, $00, $00, $00 ),
      ( $00, $00, $38, $18, $18, $18, $18, $18, $18, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $EC, $FE, $D6, $D6, $D6, $D6, $C6, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $DC, $66, $66, $66, $66, $66, $66, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7C, $C6, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $DC, $66, $66, $66, $66, $66, $7C, $60, $60, $F0, $00 ),
      ( $00, $00, $00, $00, $00, $76, $CC, $CC, $CC, $CC, $CC, $7C, $0C, $0C, $1E, $00 ),
      ( $00, $00, $00, $00, $00, $DC, $76, $66, $60, $60, $60, $F0, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7C, $C6, $60, $38, $0C, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $10, $30, $30, $FC, $30, $30, $30, $30, $36, $1C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $CC, $CC, $CC, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $66, $66, $66, $66, $66, $3C, $18, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $C6, $C6, $D6, $D6, $D6, $FE, $6C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $C6, $6C, $38, $38, $38, $6C, $C6, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $C6, $C6, $C6, $C6, $C6, $C6, $7E, $06, $0C, $F8, $00 ),
      ( $00, $00, $00, $00, $00, $FE, $CC, $18, $30, $60, $C6, $FE, $00, $00, $00, $00 ),
      ( $00, $00, $0E, $18, $18, $18, $70, $18, $18, $18, $18, $0E, $00, $00, $00, $00 ),
      ( $00, $00, $18, $18, $18, $18, $00, $18, $18, $18, $18, $18, $00, $00, $00, $00 ),
      ( $00, $00, $70, $18, $18, $18, $0E, $18, $18, $18, $18, $70, $00, $00, $00, $00 ),
      ( $00, $00, $76, $DC, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $10, $38, $6C, $C6, $C6, $C6, $FE, $00, $00, $00, $00, $00 ),
      ( $00, $00, $3C, $66, $C2, $C0, $C0, $C0, $C2, $66, $3C, $0C, $06, $7C, $00, $00 ),
      ( $00, $00, $CC, $00, $00, $CC, $CC, $CC, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $0C, $18, $30, $00, $7C, $C6, $FE, $C0, $C0, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $10, $38, $6C, $00, $78, $0C, $7C, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $00, $CC, $00, $00, $78, $0C, $7C, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $78, $0C, $7C, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $38, $6C, $38, $00, $78, $0C, $7C, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $3C, $66, $60, $60, $66, $3C, $0C, $06, $3C, $00, $00, $00 ),
      ( $00, $10, $38, $6C, $00, $7C, $C6, $FE, $C0, $C0, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $00, $00, $7C, $C6, $FE, $C0, $C0, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $7C, $C6, $FE, $C0, $C0, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $66, $00, $00, $38, $18, $18, $18, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $18, $3C, $66, $00, $38, $18, $18, $18, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $38, $18, $18, $18, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $C6, $00, $10, $38, $6C, $C6, $C6, $FE, $C6, $C6, $C6, $00, $00, $00, $00 ),
      ( $38, $6C, $38, $00, $38, $6C, $C6, $C6, $FE, $C6, $C6, $C6, $00, $00, $00, $00 ),
      ( $18, $30, $60, $00, $FE, $66, $60, $7C, $60, $60, $66, $FE, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $CC, $76, $36, $7E, $D8, $D8, $6E, $00, $00, $00, $00 ),
      ( $00, $00, $3E, $6C, $CC, $CC, $FE, $CC, $CC, $CC, $CC, $CE, $00, $00, $00, $00 ),
      ( $00, $10, $38, $6C, $00, $7C, $C6, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $00, $00, $7C, $C6, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $7C, $C6, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $30, $78, $CC, $00, $CC, $CC, $CC, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $60, $30, $18, $00, $CC, $CC, $CC, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $00, $C6, $00, $00, $C6, $C6, $C6, $C6, $C6, $C6, $7E, $06, $0C, $78, $00 ),
      ( $00, $C6, $00, $7C, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $C6, $00, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $18, $18, $3C, $66, $60, $60, $60, $66, $3C, $18, $18, $00, $00, $00, $00 ),
      ( $00, $38, $6C, $64, $60, $F0, $60, $60, $60, $60, $E6, $FC, $00, $00, $00, $00 ),
      ( $00, $00, $66, $66, $3C, $18, $7E, $18, $7E, $18, $18, $18, $00, $00, $00, $00 ),
      ( $00, $F8, $CC, $CC, $F8, $C4, $CC, $DE, $CC, $CC, $CC, $C6, $00, $00, $00, $00 ),
      ( $00, $0E, $1B, $18, $18, $18, $7E, $18, $18, $18, $18, $18, $D8, $70, $00, $00 ),
      ( $00, $18, $30, $60, $00, $78, $0C, $7C, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $0C, $18, $30, $00, $38, $18, $18, $18, $18, $18, $3C, $00, $00, $00, $00 ),
      ( $00, $18, $30, $60, $00, $7C, $C6, $C6, $C6, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $18, $30, $60, $00, $CC, $CC, $CC, $CC, $CC, $CC, $76, $00, $00, $00, $00 ),
      ( $00, $00, $76, $DC, $00, $DC, $66, $66, $66, $66, $66, $66, $00, $00, $00, $00 ),
      ( $76, $DC, $00, $C6, $E6, $F6, $FE, $DE, $CE, $C6, $C6, $C6, $00, $00, $00, $00 ),
      ( $00, $3C, $6C, $6C, $3E, $00, $7E, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $38, $6C, $6C, $38, $00, $7C, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $30, $30, $00, $30, $30, $60, $C0, $C6, $C6, $7C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $FE, $C0, $C0, $C0, $C0, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $FE, $06, $06, $06, $06, $00, $00, $00, $00, $00 ),
      ( $00, $C0, $C0, $C2, $C6, $CC, $18, $30, $60, $DC, $86, $0C, $18, $3E, $00, $00 ),
      ( $00, $C0, $C0, $C2, $C6, $CC, $18, $30, $66, $CE, $9E, $3E, $06, $06, $00, $00 ),
      ( $00, $00, $18, $18, $00, $18, $18, $18, $3C, $3C, $3C, $18, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $36, $6C, $D8, $6C, $36, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $D8, $6C, $36, $6C, $D8, $00, $00, $00, $00, $00, $00 ),
      ( $11, $44, $11, $44, $11, $44, $11, $44, $11, $44, $11, $44, $11, $44, $11, $44 ),
      ( $55, $AA, $55, $AA, $55, $AA, $55, $AA, $55, $AA, $55, $AA, $55, $AA, $55, $AA ),
      ( $DD, $77, $DD, $77, $DD, $77, $DD, $77, $DD, $77, $DD, $77, $DD, $77, $DD, $77 ),
      ( $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $F8, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $F8, $18, $F8, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $36, $36, $36, $36, $36, $36, $36, $F6, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $00, $00, $00, $00, $00, $00, $00, $FE, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $00, $00, $00, $00, $00, $F8, $18, $F8, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $36, $36, $36, $36, $36, $F6, $06, $F6, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $00, $00, $00, $00, $00, $FE, $06, $F6, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $F6, $06, $FE, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $36, $36, $36, $36, $36, $36, $36, $FE, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $18, $18, $18, $18, $18, $F8, $18, $F8, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $F8, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $1F, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $18, $18, $18, $18, $18, $18, $18, $FF, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $FF, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $1F, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $00, $00, $00, $00, $00, $00, $00, $FF, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $18, $18, $18, $18, $18, $18, $18, $FF, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $1F, $18, $1F, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $36, $36, $36, $36, $36, $36, $36, $37, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $37, $30, $3F, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $3F, $30, $37, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $F7, $00, $FF, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $FF, $00, $F7, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $37, $30, $37, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $00, $00, $00, $00, $00, $FF, $00, $FF, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $36, $36, $36, $36, $36, $F7, $00, $F7, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $18, $18, $18, $18, $18, $FF, $00, $FF, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $36, $36, $36, $36, $36, $36, $36, $FF, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $FF, $00, $FF, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $00, $00, $00, $00, $00, $00, $00, $FF, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $36, $36, $3F, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $18, $18, $18, $18, $18, $1F, $18, $1F, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $1F, $18, $1F, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $00, $00, $00, $00, $00, $00, $00, $3F, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $36, $36, $36, $36, $36, $36, $36, $FF, $36, $36, $36, $36, $36, $36, $36, $36 ),
      ( $18, $18, $18, $18, $18, $FF, $18, $FF, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $F8, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $1F, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF ),
      ( $00, $00, $00, $00, $00, $00, $00, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF ),
      ( $F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0 ),
      ( $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F ),
      ( $FF, $FF, $FF, $FF, $FF, $FF, $FF, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $76, $DC, $D8, $D8, $D8, $DC, $76, $00, $00, $00, $00 ),
      ( $00, $00, $78, $CC, $CC, $CC, $D8, $CC, $C6, $C6, $C6, $CC, $00, $00, $00, $00 ),
      ( $00, $00, $FE, $C6, $C6, $C0, $C0, $C0, $C0, $C0, $C0, $C0, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $FE, $6C, $6C, $6C, $6C, $6C, $6C, $6C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $FE, $C6, $60, $30, $18, $30, $60, $C6, $FE, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7E, $D8, $D8, $D8, $D8, $D8, $70, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $66, $66, $66, $66, $66, $7C, $60, $60, $C0, $00, $00, $00 ),
      ( $00, $00, $00, $00, $76, $DC, $18, $18, $18, $18, $18, $18, $00, $00, $00, $00 ),
      ( $00, $00, $00, $7E, $18, $3C, $66, $66, $66, $3C, $18, $7E, $00, $00, $00, $00 ),
      ( $00, $00, $00, $38, $6C, $C6, $C6, $FE, $C6, $C6, $6C, $38, $00, $00, $00, $00 ),
      ( $00, $00, $38, $6C, $C6, $C6, $C6, $6C, $6C, $6C, $6C, $EE, $00, $00, $00, $00 ),
      ( $00, $00, $1E, $30, $18, $0C, $3E, $66, $66, $66, $66, $3C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $7E, $DB, $DB, $DB, $7E, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $03, $06, $7E, $DB, $DB, $F3, $7E, $60, $C0, $00, $00, $00, $00 ),
      ( $00, $00, $1C, $30, $60, $60, $7C, $60, $60, $60, $30, $1C, $00, $00, $00, $00 ),
      ( $00, $00, $00, $7C, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $C6, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $FE, $00, $00, $FE, $00, $00, $FE, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $18, $18, $7E, $18, $18, $00, $00, $FF, $00, $00, $00, $00 ),
      ( $00, $00, $00, $30, $18, $0C, $06, $0C, $18, $30, $00, $7E, $00, $00, $00, $00 ),
      ( $00, $00, $00, $0C, $18, $30, $60, $30, $18, $0C, $00, $7E, $00, $00, $00, $00 ),
      ( $00, $00, $0E, $1B, $1B, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18, $18 ),
      ( $18, $18, $18, $18, $18, $18, $18, $18, $D8, $D8, $D8, $70, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $18, $18, $00, $7E, $00, $18, $18, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $76, $DC, $00, $76, $DC, $00, $00, $00, $00, $00, $00 ),
      ( $00, $38, $6C, $6C, $38, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $18, $18, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $18, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $0F, $0C, $0C, $0C, $0C, $0C, $EC, $6C, $6C, $3C, $1C, $00, $00, $00, $00 ),
      ( $00, $D8, $6C, $6C, $6C, $6C, $6C, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $70, $D8, $30, $60, $C8, $F8, $00, $00, $00, $00, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $7C, $7C, $7C, $7C, $7C, $7C, $7C, $00, $00, $00, $00, $00 ),
      ( $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00 )
   );
