import fontforge

currentfont=fontforge.open("Junicode-Regular.sfd")

replacements = (("EF90","A732"),("EF91","A733"),("EF92","A734"),("EF93","A735"),("EF94","A736"),("EF95","A737"),("EF96","A738"),("EF97","A739"),("EF98","A73A"),("EF99","A73B"),("EF9A","A73C"),("EF9B","A73D"),("EF9F","A746"),("EF9C","A747"),("EEC0","1EFA"),("EEC1","1EFB"),("F20C","A74C"),("F20D","A74D"),("F20A","A74E"),("F20B","A74F"),("F212","A760"),("F213","A761"),("EF05","A730"),("EF0E","A731"),("F1A2","A76E"),("F156","A76F"),("F1A3","A73E"),("F1A4","A73F"),("F151","A770"),("F15C","A75C"),("F154","A75D"),("F15D","A76C"),("F1A8","A778"),("F15E","A76A"),("F155","A76B"),("E8A0","A771"),("E8A4","A740"),("E7C5","A741"),("F14B","A741"),("E8A5","A742"),("E8A6","A743"),("E8A7","A744"),("E8A8","A745"),("E8AF","A772"),("E8A9","A773"),("E8AA","A774"),("E8AB","A74A"),("E8AC","A74B"),("E270","A750"),("F144","A750"),("E670","A751"),("F145","A751"),("E27D","A752"),("F146","A752"),("E67D","A753"),("F147","A753"),("E8AD","A754"),("E8AE","A755"),("E8B0","A758"),("E8B1","A759"),("E8B2","A756"),("E68A","A757"),("F14D","A757"),("E8B5","A775"),("E8B6","A776"),("E7FF","1E9D"),("F14F","1E9C"),("E8B9","A777"),("E8BC","A75F"),("E336","A764"),("E736","A765"),("E3A0","A766"),("E7A0","A767"),("F152","035B"),("F1C9","1DCF"),("F157","1DD3"),("F1C3","1DD1"),("F15B","1DD2"),("F1C4","1DCE"),("F1CB","1DD0"),("F163","1DCD"),("F743","035C"),("F011","1DD4"),("F037","1DD5"),("F039","1DD6"),("F02D","1DD7"),("F014","1DD9"),("F018","1DDA"),("F019","1DDB"),("F01B","1DDC"),("F01D","1DDD"),("F01E","1DDE"),("F020","1DDF"),("F021","1DE0"),("F023","1DE1"),("F035","1DE3"),("F026","1DE2"),("F027","1DE4"),("F028","1DE5"),("F02C","1DE6"),("F1E9","2E2E"),("F1ED","2E2C"),("F1EE","2E2A"),("F1EF","2E2B"),("F1D2","2E00"),("F1D3","2E23"),("F1D4","2E24"),("F1D5","2E25"),("F16E","2E0C"),("F16F","2E0D"),("F1D7","2E1C"),("F1D6","2E1D"),("F1D8","2E21"),("F1D9","2E20"),("F1DB","2E19"),("F1DC","2E26"),("F1DD","2E27"),("F1DE","2E28"),("F1DF","2E29"),("F701","23D1"),("F702","23D3"),("F703","23D2"),("E3E4","1E9E"))

def exists(g):
    try:
        l = len(currentfont[g].foreground)
        return True
    except TypeError:
        return False

for oldglyph, newglyph in replacements:
    nname = "uni" + newglyph
    oname = "uni" + oldglyph
    if exists(nname) or exists(oname):
        print "Old:",
        print oname,
        if not exists(oname):
            print "(does not exist)",
        print "New:",
        if not exists(nname):
            print nname,
            print "(does not exist)"
        else:
            print nname
        """
        currentfont.selection.select(nname)
        currentfont.copyReference()
        currentfont.selection.select(oname)
        currentfont.paste()
        currentfont[oname].useRefsMetrics(nname)
        currentfont.selection.select("PoisonMark")
        currentfont.copyReference()
        currentfont.selection.select(oname)
        currentfont.pasteInto()
        """

# currentfont.save("newfont.sfd")
