/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package de.jensd.fx.glyphs.materialdesignicons;

import de.jensd.fx.glyphs.GlyphIcons;

/**
 *
 * Icon Enum based on Material Design Icons v1.4.57
 * https://materialdesignicons.com
 *
 * @author Jens Deters (mail@jensd.de)
 */
public enum MaterialDesignIcon implements GlyphIcons {

    ACCESS_POINT('\uf101'),
    ACCESS_POINT_NETWORK('\uf102'),
    ACCOUNT('\uf103'),
    ACCOUNT_ALERT('\uf104'),
    ACCOUNT_BOX('\uf105'),
    ACCOUNT_BOX_OUTLINE('\uf106'),
    ACCOUNT_CHECK('\uf107'),
    ACCOUNT_CIRCLE('\uf108'),
    ACCOUNT_CONVERT('\uf109'),
    ACCOUNT_KEY('\uf10A'),
    ACCOUNT_LOCATION('\uf10B'),
    ACCOUNT_MINUS('\uf10C'),
    ACCOUNT_MULTIPLE('\uf10D'),
    ACCOUNT_MULTIPLE_OUTLINE('\uf10E'),
    ACCOUNT_MULTIPLE_PLUS('\uf10F'),
    ACCOUNT_NETWORK('\uf110'),
    ACCOUNT_OFF('\uf111'),
    ACCOUNT_OUTLINE('\uf112'),
    ACCOUNT_PLUS('\uf113'),
    ACCOUNT_REMOVE('\uf114'),
    ACCOUNT_SEARCH('\uf115'),
    ACCOUNT_STAR('\uf116'),
    ACCOUNT_STAR_VARIANT('\uf117'),
    ACCOUNT_SWITCH('\uf118'),
    ADJUST('\uf119'),
    AIR_CONDITIONER('\uf11A'),
    AIRBALLOON('\uf11B'),
    AIRPLANE('\uf11C'),
    AIRPLANE_OFF('\uf11D'),
    AIRPLAY('\uf11E'),
    ALARM('\uf11F'),
    ALARM_CHECK('\uf120'),
    ALARM_MULTIPLE('\uf121'),
    ALARM_OFF('\uf122'),
    ALARM_PLUS('\uf123'),
    ALBUM('\uf124'),
    ALERT('\uf125'),
    ALERT_BOX('\uf126'),
    ALERT_CIRCLE('\uf127'),
    ALERT_OCTAGON('\uf128'),
    ALERT_OUTLINE('\uf129'),
    ALPHA('\uf12A'),
    ALPHABETICAL('\uf12B'),
    AMAZON('\uf12C'),
    AMAZON_CLOUDDRIVE('\uf12D'),
    AMBULANCE('\uf12E'),
    ANCHOR('\uf12F'),
    ANDROID('\uf130'),
    ANDROID_DEBUG_BRIDGE('\uf131'),
    ANDROID_STUDIO('\uf132'),
    APPLE('\uf133'),
    APPLE_FINDER('\uf134'),
    APPLE_IOS('\uf135'),
    APPLE_MOBILEME('\uf136'),
    APPLE_SAFARI('\uf137'),
    APPNET('\uf138'),
    APPS('\uf139'),
    ARCHIVE('\uf13A'),
    ARRANGE_BRING_FORWARD('\uf13B'),
    ARRANGE_BRING_TO_FRONT('\uf13C'),
    ARRANGE_SEND_BACKWARD('\uf13D'),
    ARRANGE_SEND_TO_BACK('\uf13E'),
    ARROW_ALL('\uf13F'),
    ARROW_BOTTOM_DROP_CIRCLE('\uf140'),
    ARROW_BOTTOM_LEFT('\uf141'),
    ARROW_BOTTOM_RIGHT('\uf142'),
    ARROW_COLLAPSE('\uf143'),
    ARROW_DOWN('\uf144'),
    ARROW_DOWN_BOLD('\uf145'),
    ARROW_DOWN_BOLD_CIRCLE('\uf146'),
    ARROW_DOWN_BOLD_CIRCLE_OUTLINE('\uf147'),
    ARROW_DOWN_BOLD_HEXAGON_OUTLINE('\uf148'),
    ARROW_EXPAND('\uf149'),
    ARROW_LEFT('\uf14A'),
    ARROW_LEFT_BOLD('\uf14B'),
    ARROW_LEFT_BOLD_CIRCLE('\uf14C'),
    ARROW_LEFT_BOLD_CIRCLE_OUTLINE('\uf14D'),
    ARROW_LEFT_BOLD_HEXAGON_OUTLINE('\uf14E'),
    ARROW_RIGHT('\uf14F'),
    ARROW_RIGHT_BOLD('\uf150'),
    ARROW_RIGHT_BOLD_CIRCLE('\uf151'),
    ARROW_RIGHT_BOLD_CIRCLE_OUTLINE('\uf152'),
    ARROW_RIGHT_BOLD_HEXAGON_OUTLINE('\uf153'),
    ARROW_TOP_LEFT('\uf154'),
    ARROW_TOP_RIGHT('\uf155'),
    ARROW_UP('\uf156'),
    ARROW_UP_BOLD('\uf157'),
    ARROW_UP_BOLD_CIRCLE('\uf158'),
    ARROW_UP_BOLD_CIRCLE_OUTLINE('\uf159'),
    ARROW_UP_BOLD_HEXAGON_OUTLINE('\uf15A'),
    ASSISTANT('\uf15B'),
    AT('\uf15C'),
    ATTACHMENT('\uf15D'),
    AUDIOBOOK('\uf15E'),
    AUTO_FIX('\uf15F'),
    AUTO_UPLOAD('\uf160'),
    AUTORENEW('\uf161'),
    AV_TIMER('\uf162'),
    BABY('\uf163'),
    BACKBURGER('\uf164'),
    BACKSPACE('\uf165'),
    BACKUP_RESTORE('\uf166'),
    BANK('\uf167'),
    BARCODE('\uf168'),
    BARCODE_SCAN('\uf169'),
    BARLEY('\uf16A'),
    BARREL('\uf16B'),
    BASECAMP('\uf16C'),
    BASKET('\uf16D'),
    BASKET_FILL('\uf16E'),
    BASKET_UNFILL('\uf16F'),
    BATTERY('\uf170'),
    BATTERY_10('\uf171'),
    BATTERY_20('\uf172'),
    BATTERY_30('\uf173'),
    BATTERY_40('\uf174'),
    BATTERY_50('\uf175'),
    BATTERY_60('\uf176'),
    BATTERY_70('\uf177'),
    BATTERY_80('\uf178'),
    BATTERY_90('\uf179'),
    BATTERY_ALERT('\uf17A'),
    BATTERY_CHARGING('\uf17B'),
    BATTERY_CHARGING_100('\uf17C'),
    BATTERY_CHARGING_20('\uf17D'),
    BATTERY_CHARGING_30('\uf17E'),
    BATTERY_CHARGING_40('\uf17F'),
    BATTERY_CHARGING_60('\uf180'),
    BATTERY_CHARGING_80('\uf181'),
    BATTERY_CHARGING_90('\uf182'),
    BATTERY_MINUS('\uf183'),
    BATTERY_NEGATIVE('\uf184'),
    BATTERY_OUTLINE('\uf185'),
    BATTERY_PLUS('\uf186'),
    BATTERY_POSITIVE('\uf187'),
    BATTERY_UNKNOWN('\uf188'),
    BEACH('\uf189'),
    BEAKER('\uf18A'),
    BEAKER_EMPTY('\uf18B'),
    BEAKER_EMPTY_OUTLINE('\uf18C'),
    BEAKER_OUTLINE('\uf18D'),
    BEATS('\uf18E'),
    BEER('\uf18F'),
    BEHANCE('\uf190'),
    BELL('\uf191'),
    BELL_OFF('\uf192'),
    BELL_OUTLINE('\uf193'),
    BELL_PLUS('\uf194'),
    BELL_RING('\uf195'),
    BELL_RING_OUTLINE('\uf196'),
    BELL_SLEEP('\uf197'),
    BETA('\uf198'),
    BIKE('\uf199'),
    BING('\uf19A'),
    BINOCULARS('\uf19B'),
    BIO('\uf19C'),
    BIOHAZARD('\uf19D'),
    BITBUCKET('\uf19E'),
    BLACK_MESA('\uf19F'),
    BLACKBERRY('\uf1A0'),
    BLENDER('\uf1A1'),
    BLINDS('\uf1A2'),
    BLOCK_HELPER('\uf1A3'),
    BLOGGER('\uf1A4'),
    BLUETOOTH('\uf1A5'),
    BLUETOOTH_AUDIO('\uf1A6'),
    BLUETOOTH_CONNECT('\uf1A7'),
    BLUETOOTH_OFF('\uf1A8'),
    BLUETOOTH_SETTINGS('\uf1A9'),
    BLUETOOTH_TRANSFER('\uf1AA'),
    BLUR('\uf1AB'),
    BLUR_LINEAR('\uf1AC'),
    BLUR_OFF('\uf1AD'),
    BLUR_RADIAL('\uf1AE'),
    BONE('\uf1AF'),
    BOOK('\uf1B0'),
    BOOK_MULTIPLE('\uf1B1'),
    BOOK_MULTIPLE_VARIANT('\uf1B2'),
    BOOK_OPEN('\uf1B3'),
    BOOK_OPEN_VARIANT('\uf1B4'),
    BOOK_VARIANT('\uf1B5'),
    BOOKMARK('\uf1B6'),
    BOOKMARK_CHECK('\uf1B7'),
    BOOKMARK_MUSIC('\uf1B8'),
    BOOKMARK_OUTLINE('\uf1B9'),
    BOOKMARK_OUTLINE_PLUS('\uf1BA'),
    BOOKMARK_PLUS('\uf1BB'),
    BOOKMARK_REMOVE('\uf1BC'),
    BORDER_ALL('\uf1BD'),
    BORDER_BOTTOM('\uf1BE'),
    BORDER_COLOR('\uf1BF'),
    BORDER_HORIZONTAL('\uf1C0'),
    BORDER_INSIDE('\uf1C1'),
    BORDER_LEFT('\uf1C2'),
    BORDER_NONE('\uf1C3'),
    BORDER_OUTSIDE('\uf1C4'),
    BORDER_RIGHT('\uf1C5'),
    BORDER_STYLE('\uf1C6'),
    BORDER_TOP('\uf1C7'),
    BORDER_VERTICAL('\uf1C8'),
    BOWLING('\uf1C9'),
    BOX('\uf1CA'),
    BOX_CUTTER('\uf1CB'),
    BRIEFCASE('\uf1CC'),
    BRIEFCASE_CHECK('\uf1CD'),
    BRIEFCASE_DOWNLOAD('\uf1CE'),
    BRIEFCASE_UPLOAD('\uf1CF'),
    BRIGHTNESS_1('\uf1D0'),
    BRIGHTNESS_2('\uf1D1'),
    BRIGHTNESS_3('\uf1D2'),
    BRIGHTNESS_4('\uf1D3'),
    BRIGHTNESS_5('\uf1D4'),
    BRIGHTNESS_6('\uf1D5'),
    BRIGHTNESS_7('\uf1D6'),
    BRIGHTNESS_AUTO('\uf1D7'),
    BROOM('\uf1D8'),
    BRUSH('\uf1D9'),
    BUG('\uf1DA'),
    BULLETIN_BOARD('\uf1DB'),
    BULLHORN('\uf1DC'),
    BUS('\uf1DD'),
    CACHED('\uf1DE'),
    CAKE('\uf1DF'),
    CAKE_LAYERED('\uf1E0'),
    CAKE_VARIANT('\uf1E1'),
    CALCULATOR('\uf1E2'),
    CALENDAR('\uf1E3'),
    CALENDAR_BLANK('\uf1E4'),
    CALENDAR_CHECK('\uf1E5'),
    CALENDAR_CLOCK('\uf1E6'),
    CALENDAR_MULTIPLE('\uf1E7'),
    CALENDAR_MULTIPLE_CHECK('\uf1E8'),
    CALENDAR_PLUS('\uf1E9'),
    CALENDAR_REMOVE('\uf1EA'),
    CALENDAR_TEXT('\uf1EB'),
    CALENDAR_TODAY('\uf1EC'),
    CALL_MADE('\uf1ED'),
    CALL_MERGE('\uf1EE'),
    CALL_MISSED('\uf1EF'),
    CALL_RECEIVED('\uf1F0'),
    CALL_SPLIT('\uf1F1'),
    CAMCORDER('\uf1F2'),
    CAMCORDER_BOX('\uf1F3'),
    CAMCORDER_BOX_OFF('\uf1F4'),
    CAMCORDER_OFF('\uf1F5'),
    CAMERA('\uf1F6'),
    CAMERA_ENHANCE('\uf1F7'),
    CAMERA_FRONT('\uf1F8'),
    CAMERA_FRONT_VARIANT('\uf1F9'),
    CAMERA_IRIS('\uf1FA'),
    CAMERA_PARTY_MODE('\uf1FB'),
    CAMERA_REAR('\uf1FC'),
    CAMERA_REAR_VARIANT('\uf1FD'),
    CAMERA_SWITCH('\uf1FE'),
    CAMERA_TIMER('\uf1FF'),
    CANDYCANE('\uf200'),
    CAR('\uf201'),
    CAR_BATTERY('\uf202'),
    CAR_CONNECTED('\uf203'),
    CAR_WASH('\uf204'),
    CARROT('\uf205'),
    CART('\uf206'),
    CART_OUTLINE('\uf207'),
    CART_PLUS('\uf208'),
    CASE_SENSITIVE_ALT('\uf209'),
    CASH('\uf20A'),
    CASH_100('\uf20B'),
    CASH_MULTIPLE('\uf20C'),
    CASH_USD('\uf20D'),
    CAST('\uf20E'),
    CAST_CONNECTED('\uf20F'),
    CASTLE('\uf210'),
    CAT('\uf211'),
    CELLPHONE('\uf212'),
    CELLPHONE_ANDROID('\uf213'),
    CELLPHONE_BASIC('\uf214'),
    CELLPHONE_DOCK('\uf215'),
    CELLPHONE_IPHONE('\uf216'),
    CELLPHONE_LINK('\uf217'),
    CELLPHONE_LINK_OFF('\uf218'),
    CELLPHONE_SETTINGS('\uf219'),
    CERTIFICATE('\uf21A'),
    CHAIR_SCHOOL('\uf21B'),
    CHART_ARC('\uf21C'),
    CHART_AREASPLINE('\uf21D'),
    CHART_BAR('\uf21E'),
    CHART_HISTOGRAM('\uf21F'),
    CHART_LINE('\uf220'),
    CHART_PIE('\uf221'),
    CHECK('\uf222'),
    CHECK_ALL('\uf223'),
    CHECKBOX_BLANK('\uf224'),
    CHECKBOX_BLANK_CIRCLE('\uf225'),
    CHECKBOX_BLANK_CIRCLE_OUTLINE('\uf226'),
    CHECKBOX_BLANK_OUTLINE('\uf227'),
    CHECKBOX_MARKED('\uf228'),
    CHECKBOX_MARKED_CIRCLE('\uf229'),
    CHECKBOX_MARKED_CIRCLE_OUTLINE('\uf22A'),
    CHECKBOX_MARKED_OUTLINE('\uf22B'),
    CHECKBOX_MULTIPLE_BLANK('\uf22C'),
    CHECKBOX_MULTIPLE_BLANK_OUTLINE('\uf22D'),
    CHECKBOX_MULTIPLE_MARKED('\uf22E'),
    CHECKBOX_MULTIPLE_MARKED_OUTLINE('\uf22F'),
    CHECKERBOARD('\uf230'),
    CHEMICAL_WEAPON('\uf231'),
    CHEVRON_DOUBLE_DOWN('\uf232'),
    CHEVRON_DOUBLE_LEFT('\uf233'),
    CHEVRON_DOUBLE_RIGHT('\uf234'),
    CHEVRON_DOUBLE_UP('\uf235'),
    CHEVRON_DOWN('\uf236'),
    CHEVRON_LEFT('\uf237'),
    CHEVRON_RIGHT('\uf238'),
    CHEVRON_UP('\uf239'),
    CHURCH('\uf23A'),
    CISCO_WEBEX('\uf23B'),
    CITY('\uf23C'),
    CLIPBOARD('\uf23D'),
    CLIPBOARD_ACCOUNT('\uf23E'),
    CLIPBOARD_ALERT('\uf23F'),
    CLIPBOARD_ARROW_DOWN('\uf240'),
    CLIPBOARD_ARROW_LEFT('\uf241'),
    CLIPBOARD_CHECK('\uf242'),
    CLIPBOARD_OUTLINE('\uf243'),
    CLIPBOARD_TEXT('\uf244'),
    CLIPPY('\uf245'),
    CLOCK('\uf246'),
    CLOCK_END('\uf247'),
    CLOCK_FAST('\uf248'),
    CLOCK_IN('\uf249'),
    CLOCK_OUT('\uf24A'),
    CLOCK_START('\uf24B'),
    CLOSE('\uf24C'),
    CLOSE_BOX('\uf24D'),
    CLOSE_BOX_OUTLINE('\uf24E'),
    CLOSE_CIRCLE('\uf24F'),
    CLOSE_CIRCLE_OUTLINE('\uf250'),
    CLOSE_NETWORK('\uf251'),
    CLOSE_OCTAGON('\uf252'),
    CLOSE_OCTAGON_OUTLINE('\uf253'),
    CLOSED_CAPTION('\uf254'),
    CLOUD('\uf255'),
    CLOUD_CHECK('\uf256'),
    CLOUD_CIRCLE('\uf257'),
    CLOUD_DOWNLOAD('\uf258'),
    CLOUD_OUTLINE('\uf259'),
    CLOUD_OUTLINE_OFF('\uf25A'),
    CLOUD_PRINT('\uf25B'),
    CLOUD_PRINT_OUTLINE('\uf25C'),
    CLOUD_UPLOAD('\uf25D'),
    CODE_ARRAY('\uf25E'),
    CODE_BRACES('\uf25F'),
    CODE_BRACKETS('\uf260'),
    CODE_EQUAL('\uf261'),
    CODE_GREATER_THAN('\uf262'),
    CODE_GREATER_THAN_OR_EQUAL('\uf263'),
    CODE_LESS_THAN('\uf264'),
    CODE_LESS_THAN_OR_EQUAL('\uf265'),
    CODE_NOT_EQUAL('\uf266'),
    CODE_NOT_EQUAL_VARIANT('\uf267'),
    CODE_PARENTHESES('\uf268'),
    CODE_STRING('\uf269'),
    CODE_TAGS('\uf26A'),
    CODEPEN('\uf26B'),
    COFFEE('\uf26C'),
    COFFEE_TO_GO('\uf26D'),
    COIN('\uf26E'),
    COLOR_HELPER('\uf26F'),
    COMMENT('\uf270'),
    COMMENT_ACCOUNT('\uf271'),
    COMMENT_ACCOUNT_OUTLINE('\uf272'),
    COMMENT_ALERT('\uf273'),
    COMMENT_ALERT_OUTLINE('\uf274'),
    COMMENT_CHECK('\uf275'),
    COMMENT_CHECK_OUTLINE('\uf276'),
    COMMENT_MULTIPLE_OUTLINE('\uf277'),
    COMMENT_OUTLINE('\uf278'),
    COMMENT_PLUS_OUTLINE('\uf279'),
    COMMENT_PROCESSING('\uf27A'),
    COMMENT_PROCESSING_OUTLINE('\uf27B'),
    COMMENT_QUESTION_OUTLINE('\uf27C'),
    COMMENT_REMOVE_OUTLINE('\uf27D'),
    COMMENT_TEXT('\uf27E'),
    COMMENT_TEXT_OUTLINE('\uf27F'),
    COMPARE('\uf280'),
    COMPASS('\uf281'),
    COMPASS_OUTLINE('\uf282'),
    CONSOLE('\uf283'),
    CONTACT_MAIL('\uf284'),
    CONTENT_COPY('\uf285'),
    CONTENT_CUT('\uf286'),
    CONTENT_DUPLICATE('\uf287'),
    CONTENT_PASTE('\uf288'),
    CONTENT_SAVE('\uf289'),
    CONTENT_SAVE_ALL('\uf28A'),
    CONTRAST('\uf28B'),
    CONTRAST_BOX('\uf28C'),
    CONTRAST_CIRCLE('\uf28D'),
    COOKIE('\uf28E'),
    COW('\uf28F'),
    CREDIT_CARD('\uf290'),
    CREDIT_CARD_MULTIPLE('\uf291'),
    CREDIT_CARD_SCAN('\uf292'),
    CROP('\uf293'),
    CROP_FREE('\uf294'),
    CROP_LANDSCAPE('\uf295'),
    CROP_PORTRAIT('\uf296'),
    CROP_SQUARE('\uf297'),
    CROSSHAIRS('\uf298'),
    CROSSHAIRS_GPS('\uf299'),
    CROWN('\uf29A'),
    CUBE('\uf29B'),
    CUBE_OUTLINE('\uf29C'),
    CUBE_SEND('\uf29D'),
    CUBE_UNFOLDED('\uf29E'),
    CUP('\uf29F'),
    CUP_WATER('\uf2A0'),
    CURRENCY_BTC('\uf2A1'),
    CURRENCY_EUR('\uf2A2'),
    CURRENCY_GBP('\uf2A3'),
    CURRENCY_INR('\uf2A4'),
    CURRENCY_NGN('\uf2A5'),
    CURRENCY_RUB('\uf2A6'),
    CURRENCY_TRY('\uf2A7'),
    CURRENCY_USD('\uf2A8'),
    CURSOR_DEFAULT('\uf2A9'),
    CURSOR_DEFAULT_OUTLINE('\uf2AA'),
    CURSOR_MOVE('\uf2AB'),
    CURSOR_POINTER('\uf2AC'),
    DATABASE('\uf2AD'),
    DATABASE_MINUS('\uf2AE'),
    DATABASE_PLUS('\uf2AF'),
    DEBUG_STEP_INTO('\uf2B0'),
    DEBUG_STEP_OUT('\uf2B1'),
    DEBUG_STEP_OVER('\uf2B2'),
    DECIMAL_DECREASE('\uf2B3'),
    DECIMAL_INCREASE('\uf2B4'),
    DELETE('\uf2B5'),
    DELETE_VARIANT('\uf2B6'),
    DELTA('\uf2B7'),
    DESKPHONE('\uf2B8'),
    DESKTOP_MAC('\uf2B9'),
    DESKTOP_TOWER('\uf2BA'),
    DETAILS('\uf2BB'),
    DEVIANTART('\uf2BC'),
    DIAMOND('\uf2BD'),
    DICE('\uf2BE'),
    DICE_1('\uf2BF'),
    DICE_2('\uf2C0'),
    DICE_3('\uf2C1'),
    DICE_4('\uf2C2'),
    DICE_5('\uf2C3'),
    DICE_6('\uf2C4'),
    DIRECTIONS('\uf2C5'),
    DISK_ALERT('\uf2C6'),
    DISQUS('\uf2C7'),
    DISQUS_OUTLINE('\uf2C8'),
    DIVISION('\uf2C9'),
    DIVISION_BOX('\uf2CA'),
    DNS('\uf2CB'),
    DOMAIN('\uf2CC'),
    DOTS_HORIZONTAL('\uf2CD'),
    DOTS_VERTICAL('\uf2CE'),
    DOWNLOAD('\uf2CF'),
    DRAG('\uf2D0'),
    DRAG_HORIZONTAL('\uf2D1'),
    DRAG_VERTICAL('\uf2D2'),
    DRAWING('\uf2D3'),
    DRAWING_BOX('\uf2D4'),
    DRIBBBLE('\uf2D5'),
    DRIBBBLE_BOX('\uf2D6'),
    DRONE('\uf2D7'),
    DROPBOX('\uf2D8'),
    DRUPAL('\uf2D9'),
    DUCK('\uf2DA'),
    DUMBBELL('\uf2DB'),
    EARTH('\uf2DC'),
    EARTH_OFF('\uf2DD'),
    EDGE('\uf2DE'),
    EJECT('\uf2DF'),
    ELEVATION_DECLINE('\uf2E0'),
    ELEVATION_RISE('\uf2E1'),
    ELEVATOR('\uf2E2'),
    EMAIL('\uf2E3'),
    EMAIL_OPEN('\uf2E4'),
    EMAIL_OUTLINE('\uf2E5'),
    EMAIL_SECURE('\uf2E6'),
    EMOTICON('\uf2E7'),
    EMOTICON_COOL('\uf2E8'),
    EMOTICON_DEVIL('\uf2E9'),
    EMOTICON_HAPPY('\uf2EA'),
    EMOTICON_NEUTRAL('\uf2EB'),
    EMOTICON_POOP('\uf2EC'),
    EMOTICON_SAD('\uf2ED'),
    EMOTICON_TONGUE('\uf2EE'),
    ENGINE('\uf2EF'),
    ENGINE_OUTLINE('\uf2F0'),
    EQUAL('\uf2F1'),
    EQUAL_BOX('\uf2F2'),
    ERASER('\uf2F3'),
    ESCALATOR('\uf2F4'),
    ETHERNET('\uf2F5'),
    ETHERNET_CABLE('\uf2F6'),
    ETHERNET_CABLE_OFF('\uf2F7'),
    ETSY('\uf2F8'),
    EVERNOTE('\uf2F9'),
    EXCLAMATION('\uf2FA'),
    EXIT_TO_APP('\uf2FB'),
    EXPORT('\uf2FC'),
    EYE('\uf2FD'),
    EYE_OFF('\uf2FE'),
    EYEDROPPER('\uf2FF'),
    EYEDROPPER_VARIANT('\uf300'),
    FACEBOOK('\uf301'),
    FACEBOOK_BOX('\uf302'),
    FACEBOOK_MESSENGER('\uf303'),
    FACTORY('\uf304'),
    FAN('\uf305'),
    FAST_FORWARD('\uf306'),
    FAX('\uf307'),
    FERRY('\uf308'),
    FILE('\uf309'),
    FILE_CHART('\uf30A'),
    FILE_CHECK('\uf30B'),
    FILE_CLOUD('\uf30C'),
    FILE_DELIMITED('\uf30D'),
    FILE_DOCUMENT('\uf30E'),
    FILE_DOCUMENT_BOX('\uf30F'),
    FILE_EXCEL('\uf310'),
    FILE_EXCEL_BOX('\uf311'),
    FILE_EXPORT('\uf312'),
    FILE_FIND('\uf313'),
    FILE_IMAGE('\uf314'),
    FILE_IMPORT('\uf315'),
    FILE_LOCK('\uf316'),
    FILE_MULTIPLE('\uf317'),
    FILE_MUSIC('\uf318'),
    FILE_OUTLINE('\uf319'),
    FILE_PDF('\uf31A'),
    FILE_PDF_BOX('\uf31B'),
    FILE_POWERPOINT('\uf31C'),
    FILE_POWERPOINT_BOX('\uf31D'),
    FILE_PRESENTATION_BOX('\uf31E'),
    FILE_SEND('\uf31F'),
    FILE_VIDEO('\uf320'),
    FILE_WORD('\uf321'),
    FILE_WORD_BOX('\uf322'),
    FILE_XML('\uf323'),
    FILM('\uf324'),
    FILMSTRIP('\uf325'),
    FILMSTRIP_OFF('\uf326'),
    FILTER('\uf327'),
    FILTER_OUTLINE('\uf328'),
    FILTER_REMOVE('\uf329'),
    FILTER_REMOVE_OUTLINE('\uf32A'),
    FILTER_VARIANT('\uf32B'),
    FINGERPRINT('\uf32C'),
    FIRE('\uf32D'),
    FIREFOX('\uf32E'),
    FISH('\uf32F'),
    FLAG('\uf330'),
    FLAG_CHECKERED('\uf331'),
    FLAG_OUTLINE('\uf332'),
    FLAG_OUTLINE_VARIANT('\uf333'),
    FLAG_TRIANGLE('\uf334'),
    FLAG_VARIANT('\uf335'),
    FLASH('\uf336'),
    FLASH_AUTO('\uf337'),
    FLASH_OFF('\uf338'),
    FLASHLIGHT('\uf339'),
    FLASHLIGHT_OFF('\uf33A'),
    FLATTR('\uf33B'),
    FLIP_TO_BACK('\uf33C'),
    FLIP_TO_FRONT('\uf33D'),
    FLOPPY('\uf33E'),
    FLOWER('\uf33F'),
    FOLDER('\uf340'),
    FOLDER_ACCOUNT('\uf341'),
    FOLDER_DOWNLOAD('\uf342'),
    FOLDER_GOOGLE_DRIVE('\uf343'),
    FOLDER_IMAGE('\uf344'),
    FOLDER_LOCK('\uf345'),
    FOLDER_LOCK_OPEN('\uf346'),
    FOLDER_MOVE('\uf347'),
    FOLDER_MULTIPLE('\uf348'),
    FOLDER_MULTIPLE_IMAGE('\uf349'),
    FOLDER_MULTIPLE_OUTLINE('\uf34A'),
    FOLDER_OUTLINE('\uf34B'),
    FOLDER_PLUS('\uf34C'),
    FOLDER_REMOVE('\uf34D'),
    FOLDER_UPLOAD('\uf34E'),
    FOOD('\uf34F'),
    FOOD_APPLE('\uf350'),
    FOOD_VARIANT('\uf351'),
    FOOTBALL('\uf352'),
    FOOTBALL_AUSTRALIAN('\uf353'),
    FOOTBALL_HELMET('\uf354'),
    FORMAT_ALIGN_CENTER('\uf355'),
    FORMAT_ALIGN_JUSTIFY('\uf356'),
    FORMAT_ALIGN_LEFT('\uf357'),
    FORMAT_ALIGN_RIGHT('\uf358'),
    FORMAT_BOLD('\uf359'),
    FORMAT_CLEAR('\uf35A'),
    FORMAT_COLOR_FILL('\uf35B'),
    FORMAT_FLOAT_CENTER('\uf35C'),
    FORMAT_FLOAT_LEFT('\uf35D'),
    FORMAT_FLOAT_NONE('\uf35E'),
    FORMAT_FLOAT_RIGHT('\uf35F'),
    FORMAT_HEADER_1('\uf360'),
    FORMAT_HEADER_2('\uf361'),
    FORMAT_HEADER_3('\uf362'),
    FORMAT_HEADER_4('\uf363'),
    FORMAT_HEADER_5('\uf364'),
    FORMAT_HEADER_6('\uf365'),
    FORMAT_HEADER_DECREASE('\uf366'),
    FORMAT_HEADER_EQUAL('\uf367'),
    FORMAT_HEADER_INCREASE('\uf368'),
    FORMAT_HEADER_POUND('\uf369'),
    FORMAT_INDENT_DECREASE('\uf36A'),
    FORMAT_INDENT_INCREASE('\uf36B'),
    FORMAT_ITALIC('\uf36C'),
    FORMAT_LINE_SPACING('\uf36D'),
    FORMAT_LIST_BULLETED('\uf36E'),
    FORMAT_LIST_BULLETED_TYPE('\uf36F'),
    FORMAT_LIST_NUMBERS('\uf370'),
    FORMAT_PAINT('\uf371'),
    FORMAT_PARAGRAPH('\uf372'),
    FORMAT_QUOTE('\uf373'),
    FORMAT_SIZE('\uf374'),
    FORMAT_STRIKETHROUGH('\uf375'),
    FORMAT_STRIKETHROUGH_VARIANT('\uf376'),
    FORMAT_SUBSCRIPT('\uf377'),
    FORMAT_SUPERSCRIPT('\uf378'),
    FORMAT_TEXT('\uf379'),
    FORMAT_TEXTDIRECTION_L_TO_R('\uf37A'),
    FORMAT_TEXTDIRECTION_R_TO_L('\uf37B'),
    FORMAT_UNDERLINE('\uf37C'),
    FORMAT_WRAP_INLINE('\uf37D'),
    FORMAT_WRAP_SQUARE('\uf37E'),
    FORMAT_WRAP_TIGHT('\uf37F'),
    FORMAT_WRAP_TOP_BOTTOM('\uf380'),
    FORUM('\uf381'),
    FORWARD('\uf382'),
    FOURSQUARE('\uf383'),
    FRIDGE('\uf384'),
    FRIDGE_FILLED('\uf385'),
    FRIDGE_FILLED_BOTTOM('\uf386'),
    FRIDGE_FILLED_TOP('\uf387'),
    FULLSCREEN('\uf388'),
    FULLSCREEN_EXIT('\uf389'),
    FUNCTION('\uf38A'),
    GAMEPAD('\uf38B'),
    GAMEPAD_VARIANT('\uf38C'),
    GAS_STATION('\uf38D'),
    GATE('\uf38E'),
    GAUGE('\uf38F'),
    GAVEL('\uf390'),
    GENDER_FEMALE('\uf391'),
    GENDER_MALE('\uf392'),
    GENDER_MALE_FEMALE('\uf393'),
    GENDER_TRANSGENDER('\uf394'),
    GHOST('\uf395'),
    GIFT('\uf396'),
    GIT('\uf397'),
    GITHUB_BOX('\uf398'),
    GITHUB_CIRCLE('\uf399'),
    GLASS_FLUTE('\uf39A'),
    GLASS_MUG('\uf39B'),
    GLASS_STANGE('\uf39C'),
    GLASS_TULIP('\uf39D'),
    GLASSES('\uf39E'),
    GMAIL('\uf39F'),
    GOOGLE('\uf3A0'),
    GOOGLE_CARDBOARD('\uf3A1'),
    GOOGLE_CHROME('\uf3A2'),
    GOOGLE_CIRCLES('\uf3A3'),
    GOOGLE_CIRCLES_COMMUNITIES('\uf3A4'),
    GOOGLE_CIRCLES_EXTENDED('\uf3A5'),
    GOOGLE_CIRCLES_GROUP('\uf3A6'),
    GOOGLE_CONTROLLER('\uf3A7'),
    GOOGLE_CONTROLLER_OFF('\uf3A8'),
    GOOGLE_DRIVE('\uf3A9'),
    GOOGLE_EARTH('\uf3AA'),
    GOOGLE_GLASS('\uf3AB'),
    GOOGLE_NEARBY('\uf3AC'),
    GOOGLE_PAGES('\uf3AD'),
    GOOGLE_PHYSICAL_WEB('\uf3AE'),
    GOOGLE_PLAY('\uf3AF'),
    GOOGLE_PLUS('\uf3B0'),
    GOOGLE_PLUS_BOX('\uf3B1'),
    GOOGLE_TRANSLATE('\uf3B2'),
    GOOGLE_WALLET('\uf3B3'),
    GRID('\uf3B4'),
    GRID_OFF('\uf3B5'),
    GROUP('\uf3B6'),
    GUITAR('\uf3B7'),
    GUITAR_PICK('\uf3B8'),
    GUITAR_PICK_OUTLINE('\uf3B9'),
    HAND_POINTING_RIGHT('\uf3BA'),
    HANGER('\uf3BB'),
    HANGOUTS('\uf3BC'),
    HARDDISK('\uf3BD'),
    HEADPHONES('\uf3BE'),
    HEADPHONES_BOX('\uf3BF'),
    HEADPHONES_SETTINGS('\uf3C0'),
    HEADSET('\uf3C1'),
    HEADSET_DOCK('\uf3C2'),
    HEADSET_OFF('\uf3C3'),
    HEART('\uf3C4'),
    HEART_BOX('\uf3C5'),
    HEART_BOX_OUTLINE('\uf3C6'),
    HEART_BROKEN('\uf3C7'),
    HEART_OUTLINE('\uf3C8'),
    HELP('\uf3C9'),
    HELP_CIRCLE('\uf3CA'),
    HEXAGON('\uf3CB'),
    HEXAGON_OUTLINE('\uf3CC'),
    HISTORY('\uf3CD'),
    HOLOLENS('\uf3CE'),
    HOME('\uf3CF'),
    HOME_MODERN('\uf3D0'),
    HOME_VARIANT('\uf3D1'),
    HOPS('\uf3D2'),
    HOSPITAL('\uf3D3'),
    HOSPITAL_BUILDING('\uf3D4'),
    HOSPITAL_MARKER('\uf3D5'),
    HOTEL('\uf3D6'),
    HOUZZ('\uf3D7'),
    HOUZZ_BOX('\uf3D8'),
    HUMAN('\uf3D9'),
    HUMAN_CHILD('\uf3DA'),
    HUMAN_MALE_FEMALE('\uf3DB'),
    IMAGE('\uf3DC'),
    IMAGE_ALBUM('\uf3DD'),
    IMAGE_AREA('\uf3DE'),
    IMAGE_AREA_CLOSE('\uf3DF'),
    IMAGE_BROKEN('\uf3E0'),
    IMAGE_BROKEN_VARIANT('\uf3E1'),
    IMAGE_FILTER('\uf3E2'),
    IMAGE_FILTER_BLACK_WHITE('\uf3E3'),
    IMAGE_FILTER_CENTER_FOCUS('\uf3E4'),
    IMAGE_FILTER_CENTER_FOCUS_WEAK('\uf3E5'),
    IMAGE_FILTER_DRAMA('\uf3E6'),
    IMAGE_FILTER_FRAMES('\uf3E7'),
    IMAGE_FILTER_HDR('\uf3E8'),
    IMAGE_FILTER_NONE('\uf3E9'),
    IMAGE_FILTER_TILT_SHIFT('\uf3EA'),
    IMAGE_FILTER_VINTAGE('\uf3EB'),
    IMAGE_MULTIPLE('\uf3EC'),
    IMPORT('\uf3ED'),
    INBOX('\uf3EE'),
    INFORMATION('\uf3EF'),
    INFORMATION_OUTLINE('\uf3F0'),
    INSTAGRAM('\uf3F1'),
    INSTAPAPER('\uf3F2'),
    INTERNET_EXPLORER('\uf3F3'),
    INVERT_COLORS('\uf3F4'),
    JEEPNEY('\uf3F5'),
    JIRA('\uf3F6'),
    JSFIDDLE('\uf3F7'),
    KEG('\uf3F8'),
    KEY('\uf3F9'),
    KEY_CHANGE('\uf3FA'),
    KEY_MINUS('\uf3FB'),
    KEY_PLUS('\uf3FC'),
    KEY_REMOVE('\uf3FD'),
    KEY_VARIANT('\uf3FE'),
    KEYBOARD('\uf3FF'),
    KEYBOARD_BACKSPACE('\uf400'),
    KEYBOARD_CAPS('\uf401'),
    KEYBOARD_CLOSE('\uf402'),
    KEYBOARD_OFF('\uf403'),
    KEYBOARD_RETURN('\uf404'),
    KEYBOARD_TAB('\uf405'),
    KEYBOARD_VARIANT('\uf406'),
    LABEL('\uf407'),
    LABEL_OUTLINE('\uf408'),
    LAN('\uf409'),
    LAN_CONNECT('\uf40A'),
    LAN_DISCONNECT('\uf40B'),
    LAN_PENDING('\uf40C'),
    LANGUAGE_CSHARP('\uf40D'),
    LANGUAGE_CSS3('\uf40E'),
    LANGUAGE_HTML5('\uf40F'),
    LANGUAGE_JAVASCRIPT('\uf410'),
    LANGUAGE_PHP('\uf411'),
    LANGUAGE_PYTHON('\uf412'),
    LANGUAGE_PYTHON_TEXT('\uf413'),
    LAPTOP('\uf414'),
    LAPTOP_CHROMEBOOK('\uf415'),
    LAPTOP_MAC('\uf416'),
    LAPTOP_WINDOWS('\uf417'),
    LASTFM('\uf418'),
    LAUNCH('\uf419'),
    LAYERS('\uf41A'),
    LAYERS_OFF('\uf41B'),
    LEAF('\uf41C'),
    LED_OFF('\uf41D'),
    LED_ON('\uf41E'),
    LED_OUTLINE('\uf41F'),
    LED_VARIANT_OFF('\uf420'),
    LED_VARIANT_ON('\uf421'),
    LED_VARIANT_OUTLINE('\uf422'),
    LIBRARY('\uf423'),
    LIBRARY_BOOKS('\uf424'),
    LIBRARY_MUSIC('\uf425'),
    LIBRARY_PLUS('\uf426'),
    LIGHTBULB('\uf427'),
    LIGHTBULB_OUTLINE('\uf428'),
    LINK('\uf429'),
    LINK_OFF('\uf42A'),
    LINK_VARIANT('\uf42B'),
    LINK_VARIANT_OFF('\uf42C'),
    LINKEDIN('\uf42D'),
    LINKEDIN_BOX('\uf42E'),
    LINUX('\uf42F'),
    LOCK('\uf430'),
    LOCK_OPEN('\uf431'),
    LOCK_OPEN_OUTLINE('\uf432'),
    LOCK_OUTLINE('\uf433'),
    LOGIN('\uf434'),
    LOGOUT('\uf435'),
    LOOKS('\uf436'),
    LOUPE('\uf437'),
    LUMX('\uf438'),
    MAGNET('\uf439'),
    MAGNET_ON('\uf43A'),
    MAGNIFY('\uf43B'),
    MAGNIFY_MINUS('\uf43C'),
    MAGNIFY_PLUS('\uf43D'),
    MAIL_RU('\uf43E'),
    MAP('\uf43F'),
    MAP_MARKER('\uf440'),
    MAP_MARKER_CIRCLE('\uf441'),
    MAP_MARKER_MULTIPLE('\uf442'),
    MAP_MARKER_OFF('\uf443'),
    MAP_MARKER_RADIUS('\uf444'),
    MARGIN('\uf445'),
    MARKDOWN('\uf446'),
    MARKER_CHECK('\uf447'),
    MARTINI('\uf448'),
    MATERIAL_UI('\uf449'),
    MATH_COMPASS('\uf44A'),
    MAXCDN('\uf44B'),
    MEDIUM('\uf44C'),
    MEMORY('\uf44D'),
    MENU('\uf44E'),
    MENU_DOWN('\uf44F'),
    MENU_LEFT('\uf450'),
    MENU_RIGHT('\uf451'),
    MENU_UP('\uf452'),
    MESSAGE('\uf453'),
    MESSAGE_ALERT('\uf454'),
    MESSAGE_DRAW('\uf455'),
    MESSAGE_IMAGE('\uf456'),
    MESSAGE_OUTLINE('\uf457'),
    MESSAGE_PROCESSING('\uf458'),
    MESSAGE_REPLY('\uf459'),
    MESSAGE_REPLY_TEXT('\uf45A'),
    MESSAGE_TEXT('\uf45B'),
    MESSAGE_TEXT_OUTLINE('\uf45C'),
    MESSAGE_VIDEO('\uf45D'),
    MICROPHONE('\uf45E'),
    MICROPHONE_OFF('\uf45F'),
    MICROPHONE_OUTLINE('\uf460'),
    MICROPHONE_SETTINGS('\uf461'),
    MICROPHONE_VARIANT('\uf462'),
    MICROPHONE_VARIANT_OFF('\uf463'),
    MICROSOFT('\uf464'),
    MINUS('\uf465'),
    MINUS_BOX('\uf466'),
    MINUS_CIRCLE('\uf467'),
    MINUS_CIRCLE_OUTLINE('\uf468'),
    MINUS_NETWORK('\uf469'),
    MONITOR('\uf46A'),
    MONITOR_MULTIPLE('\uf46B'),
    MORE('\uf46C'),
    MOTORBIKE('\uf46D'),
    MOUSE('\uf46E'),
    MOUSE_OFF('\uf46F'),
    MOUSE_VARIANT('\uf470'),
    MOUSE_VARIANT_OFF('\uf471'),
    MOVIE('\uf472'),
    MULTIPLICATION('\uf473'),
    MULTIPLICATION_BOX('\uf474'),
    MUSIC_BOX('\uf475'),
    MUSIC_BOX_OUTLINE('\uf476'),
    MUSIC_CIRCLE('\uf477'),
    MUSIC_NOTE('\uf478'),
    MUSIC_NOTE_EIGHTH('\uf479'),
    MUSIC_NOTE_HALF('\uf47A'),
    MUSIC_NOTE_OFF('\uf47B'),
    MUSIC_NOTE_QUARTER('\uf47C'),
    MUSIC_NOTE_SIXTEENTH('\uf47D'),
    MUSIC_NOTE_WHOLE('\uf47E'),
    NATURE('\uf47F'),
    NATURE_PEOPLE('\uf480'),
    NAVIGATION('\uf481'),
    NEEDLE('\uf482'),
    NEST_PROTECT('\uf483'),
    NEST_THERMOSTAT('\uf484'),
    NEWSPAPER('\uf485'),
    NFC('\uf486'),
    NFC_TAP('\uf487'),
    NFC_VARIANT('\uf488'),
    NODEJS('\uf489'),
    NOTE('\uf48A'),
    NOTE_OUTLINE('\uf48B'),
    NOTE_PLUS('\uf48C'),
    NOTE_PLUS_OUTLINE('\uf48D'),
    NOTE_TEXT('\uf48E'),
    NOTIFICATION_CLEAR_ALL('\uf48F'),
    NUMERIC('\uf490'),
    NUMERIC_0_BOX('\uf491'),
    NUMERIC_0_BOX_MULTIPLE_OUTLINE('\uf492'),
    NUMERIC_0_BOX_OUTLINE('\uf493'),
    NUMERIC_1_BOX('\uf494'),
    NUMERIC_1_BOX_MULTIPLE_OUTLINE('\uf495'),
    NUMERIC_1_BOX_OUTLINE('\uf496'),
    NUMERIC_2_BOX('\uf497'),
    NUMERIC_2_BOX_MULTIPLE_OUTLINE('\uf498'),
    NUMERIC_2_BOX_OUTLINE('\uf499'),
    NUMERIC_3_BOX('\uf49A'),
    NUMERIC_3_BOX_MULTIPLE_OUTLINE('\uf49B'),
    NUMERIC_3_BOX_OUTLINE('\uf49C'),
    NUMERIC_4_BOX('\uf49D'),
    NUMERIC_4_BOX_MULTIPLE_OUTLINE('\uf49E'),
    NUMERIC_4_BOX_OUTLINE('\uf49F'),
    NUMERIC_5_BOX('\uf4A0'),
    NUMERIC_5_BOX_MULTIPLE_OUTLINE('\uf4A1'),
    NUMERIC_5_BOX_OUTLINE('\uf4A2'),
    NUMERIC_6_BOX('\uf4A3'),
    NUMERIC_6_BOX_MULTIPLE_OUTLINE('\uf4A4'),
    NUMERIC_6_BOX_OUTLINE('\uf4A5'),
    NUMERIC_7_BOX('\uf4A6'),
    NUMERIC_7_BOX_MULTIPLE_OUTLINE('\uf4A7'),
    NUMERIC_7_BOX_OUTLINE('\uf4A8'),
    NUMERIC_8_BOX('\uf4A9'),
    NUMERIC_8_BOX_MULTIPLE_OUTLINE('\uf4AA'),
    NUMERIC_8_BOX_OUTLINE('\uf4AB'),
    NUMERIC_9_BOX('\uf4AC'),
    NUMERIC_9_BOX_MULTIPLE_OUTLINE('\uf4AD'),
    NUMERIC_9_BOX_OUTLINE('\uf4AE'),
    NUMERIC_9_PLUS_BOX('\uf4AF'),
    NUMERIC_9_PLUS_BOX_MULTIPLE_OUTLINE('\uf4B0'),
    NUMERIC_9_PLUS_BOX_OUTLINE('\uf4B1'),
    NUTRITION('\uf4B2'),
    OCTAGON('\uf4B3'),
    OCTAGON_OUTLINE('\uf4B4'),
    ODNOKLASSNIKI('\uf4B5'),
    OFFICE('\uf4B6'),
    OIL('\uf4B7'),
    OIL_TEMPERATURE('\uf4B8'),
    OMEGA('\uf4B9'),
    ONEDRIVE('\uf4BA'),
    OPEN_IN_APP('\uf4BB'),
    OPEN_IN_NEW('\uf4BC'),
    OPERA('\uf4BD'),
    ORNAMENT('\uf4BE'),
    ORNAMENT_VARIANT('\uf4BF'),
    OUTBOX('\uf4C0'),
    OWL('\uf4C1'),
    PACKAGE('\uf4C2'),
    PACKAGE_DOWN('\uf4C3'),
    PACKAGE_UP('\uf4C4'),
    PACKAGE_VARIANT('\uf4C5'),
    PACKAGE_VARIANT_CLOSED('\uf4C6'),
    PALETTE('\uf4C7'),
    PALETTE_ADVANCED('\uf4C8'),
    PANDA('\uf4C9'),
    PANDORA('\uf4CA'),
    PANORAMA('\uf4CB'),
    PANORAMA_FISHEYE('\uf4CC'),
    PANORAMA_HORIZONTAL('\uf4CD'),
    PANORAMA_VERTICAL('\uf4CE'),
    PANORAMA_WIDE_ANGLE('\uf4CF'),
    PAPER_CUT_VERTICAL('\uf4D0'),
    PAPERCLIP('\uf4D1'),
    PARKING('\uf4D2'),
    PAUSE('\uf4D3'),
    PAUSE_CIRCLE('\uf4D4'),
    PAUSE_CIRCLE_OUTLINE('\uf4D5'),
    PAUSE_OCTAGON('\uf4D6'),
    PAUSE_OCTAGON_OUTLINE('\uf4D7'),
    PAW('\uf4D8'),
    PEN('\uf4D9'),
    PENCIL('\uf4DA'),
    PENCIL_BOX('\uf4DB'),
    PENCIL_BOX_OUTLINE('\uf4DC'),
    PENCIL_LOCK('\uf4DD'),
    PENCIL_OFF('\uf4DE'),
    PERCENT('\uf4DF'),
    PHARMACY('\uf4E0'),
    PHONE('\uf4E1'),
    PHONE_BLUETOOTH('\uf4E2'),
    PHONE_FORWARD('\uf4E3'),
    PHONE_HANGUP('\uf4E4'),
    PHONE_IN_TALK('\uf4E5'),
    PHONE_INCOMING('\uf4E6'),
    PHONE_LOCKED('\uf4E7'),
    PHONE_LOG('\uf4E8'),
    PHONE_MISSED('\uf4E9'),
    PHONE_OUTGOING('\uf4EA'),
    PHONE_PAUSED('\uf4EB'),
    PHONE_SETTINGS('\uf4EC'),
    PHONE_VOIP('\uf4ED'),
    PI('\uf4EE'),
    PI_BOX('\uf4EF'),
    PIG('\uf4F0'),
    PILL('\uf4F1'),
    PIN('\uf4F2'),
    PIN_OFF('\uf4F3'),
    PINE_TREE('\uf4F4'),
    PINE_TREE_BOX('\uf4F5'),
    PINTEREST('\uf4F6'),
    PINTEREST_BOX('\uf4F7'),
    PIZZA('\uf4F8'),
    PLAY('\uf4F9'),
    PLAY_BOX_OUTLINE('\uf4FA'),
    PLAY_CIRCLE('\uf4FB'),
    PLAY_CIRCLE_OUTLINE('\uf4FC'),
    PLAY_PAUSE('\uf4FD'),
    PLAY_PROTECTED_CONTENT('\uf4FE'),
    PLAYLIST_MINUS('\uf4FF'),
    PLAYLIST_PLAY('\uf500'),
    PLAYLIST_PLUS('\uf501'),
    PLAYLIST_REMOVE('\uf502'),
    PLAYSTATION('\uf503'),
    PLUS('\uf504'),
    PLUS_BOX('\uf505'),
    PLUS_CIRCLE('\uf506'),
    PLUS_CIRCLE_MULTIPLE_OUTLINE('\uf507'),
    PLUS_CIRCLE_OUTLINE('\uf508'),
    PLUS_NETWORK('\uf509'),
    PLUS_ONE('\uf50A'),
    POCKET('\uf50B'),
    POKEBALL('\uf50C'),
    POLAROID('\uf50D'),
    POLL('\uf50E'),
    POLL_BOX('\uf50F'),
    POLYMER('\uf510'),
    POPCORN('\uf511'),
    POUND('\uf512'),
    POUND_BOX('\uf513'),
    POWER('\uf514'),
    POWER_SETTINGS('\uf515'),
    POWER_SOCKET('\uf516'),
    PRESENTATION('\uf517'),
    PRESENTATION_PLAY('\uf518'),
    PRINTER('\uf519'),
    PRINTER_3D('\uf51A'),
    PRINTER_ALERT('\uf51B'),
    PROFESSIONAL_HEXAGON('\uf51C'),
    PROJECTOR('\uf51D'),
    PROJECTOR_SCREEN('\uf51E'),
    PULSE('\uf51F'),
    PUZZLE('\uf520'),
    QRCODE('\uf521'),
    QRCODE_SCAN('\uf522'),
    QUADCOPTER('\uf523'),
    QUALITY_HIGH('\uf524'),
    QUICKTIME('\uf525'),
    RADAR('\uf526'),
    RADIATOR('\uf527'),
    RADIO('\uf528'),
    RADIO_HANDHELD('\uf529'),
    RADIO_TOWER('\uf52A'),
    RADIOACTIVE('\uf52B'),
    RADIOBOX_BLANK('\uf52C'),
    RADIOBOX_MARKED('\uf52D'),
    RASPBERRYPI('\uf52E'),
    RAY_END('\uf52F'),
    RAY_END_ARROW('\uf530'),
    RAY_START('\uf531'),
    RAY_START_ARROW('\uf532'),
    RAY_START_END('\uf533'),
    RAY_VERTEX('\uf534'),
    RDIO('\uf535'),
    READ('\uf536'),
    READABILITY('\uf537'),
    RECEIPT('\uf538'),
    RECORD('\uf539'),
    RECORD_REC('\uf53A'),
    RECYCLE('\uf53B'),
    REDDIT('\uf53C'),
    REDO('\uf53D'),
    REDO_VARIANT('\uf53E'),
    REFRESH('\uf53F'),
    REGEX('\uf540'),
    RELATIVE_SCALE('\uf541'),
    RELOAD('\uf542'),
    REMOTE('\uf543'),
    RENAME_BOX('\uf544'),
    REPEAT('\uf545'),
    REPEAT_OFF('\uf546'),
    REPEAT_ONCE('\uf547'),
    REPLAY('\uf548'),
    REPLY('\uf549'),
    REPLY_ALL('\uf54A'),
    REPRODUCTION('\uf54B'),
    RESIZE_BOTTOM_RIGHT('\uf54C'),
    RESPONSIVE('\uf54D'),
    REWIND('\uf54E'),
    RIBBON('\uf54F'),
    ROAD('\uf550'),
    ROAD_VARIANT('\uf551'),
    ROCKET('\uf552'),
    ROTATE_3D('\uf553'),
    ROTATE_LEFT('\uf554'),
    ROTATE_LEFT_VARIANT('\uf555'),
    ROTATE_RIGHT('\uf556'),
    ROTATE_RIGHT_VARIANT('\uf557'),
    ROUTER_WIRELESS('\uf558'),
    ROUTES('\uf559'),
    RSS('\uf55A'),
    RSS_BOX('\uf55B'),
    RULER('\uf55C'),
    RUN('\uf55D'),
    SALE('\uf55E'),
    SATELLITE('\uf55F'),
    SATELLITE_VARIANT('\uf560'),
    SCALE('\uf561'),
    SCALE_BATHROOM('\uf562'),
    SCHOOL('\uf563'),
    SCREEN_ROTATION('\uf564'),
    SCREEN_ROTATION_LOCK('\uf565'),
    SCREWDRIVER('\uf566'),
    SCRIPT('\uf567'),
    SD('\uf568'),
    SEAL('\uf569'),
    SEAT_FLAT('\uf56A'),
    SEAT_FLAT_ANGLED('\uf56B'),
    SEAT_INDIVIDUAL_SUITE('\uf56C'),
    SEAT_LEGROOM_EXTRA('\uf56D'),
    SEAT_LEGROOM_NORMAL('\uf56E'),
    SEAT_LEGROOM_REDUCED('\uf56F'),
    SEAT_RECLINE_EXTRA('\uf570'),
    SEAT_RECLINE_NORMAL('\uf571'),
    SECURITY('\uf572'),
    SECURITY_NETWORK('\uf573'),
    SELECT('\uf574'),
    SELECT_ALL('\uf575'),
    SELECT_INVERSE('\uf576'),
    SELECT_OFF('\uf577'),
    SELECTION('\uf578'),
    SEND('\uf579'),
    SERVER('\uf57A'),
    SERVER_MINUS('\uf57B'),
    SERVER_NETWORK('\uf57C'),
    SERVER_NETWORK_OFF('\uf57D'),
    SERVER_OFF('\uf57E'),
    SERVER_PLUS('\uf57F'),
    SERVER_REMOVE('\uf580'),
    SERVER_SECURITY('\uf581'),
    SETTINGS('\uf582'),
    SETTINGS_BOX('\uf583'),
    SHAPE_PLUS('\uf584'),
    SHARE('\uf585'),
    SHARE_VARIANT('\uf586'),
    SHIELD('\uf587'),
    SHIELD_OUTLINE('\uf588'),
    SHOPPING('\uf589'),
    SHOPPING_MUSIC('\uf58A'),
    SHREDDER('\uf58B'),
    SHUFFLE('\uf58C'),
    SHUFFLE_DISABLED('\uf58D'),
    SHUFFLE_VARIANT('\uf58E'),
    SIGMA('\uf58F'),
    SIGN_CAUTION('\uf590'),
    SIGNAL('\uf591'),
    SILVERWARE('\uf592'),
    SILVERWARE_FORK('\uf593'),
    SILVERWARE_SPOON('\uf594'),
    SILVERWARE_VARIANT('\uf595'),
    SIM('\uf596'),
    SIM_ALERT('\uf597'),
    SIM_OFF('\uf598'),
    SITEMAP('\uf599'),
    SKIP_BACKWARD('\uf59A'),
    SKIP_FORWARD('\uf59B'),
    SKIP_NEXT('\uf59C'),
    SKIP_PREVIOUS('\uf59D'),
    SKYPE('\uf59E'),
    SKYPE_BUSINESS('\uf59F'),
    SLACK('\uf5A0'),
    SLEEP('\uf5A1'),
    SLEEP_OFF('\uf5A2'),
    SMOKING('\uf5A3'),
    SMOKING_OFF('\uf5A4'),
    SNAPCHAT('\uf5A5'),
    SNOWMAN('\uf5A6'),
    SOFA('\uf5A7'),
    SORT('\uf5A8'),
    SORT_ALPHABETICAL('\uf5A9'),
    SORT_ASCENDING('\uf5AA'),
    SORT_DESCENDING('\uf5AB'),
    SORT_NUMERIC('\uf5AC'),
    SORT_VARIANT('\uf5AD'),
    SOUNDCLOUD('\uf5AE'),
    SOURCE_FORK('\uf5AF'),
    SOURCE_PULL('\uf5B0'),
    SPEAKER('\uf5B1'),
    SPEAKER_OFF('\uf5B2'),
    SPEEDOMETER('\uf5B3'),
    SPELLCHECK('\uf5B4'),
    SPOTIFY('\uf5B5'),
    SPOTLIGHT('\uf5B6'),
    SPOTLIGHT_BEAM('\uf5B7'),
    SQUARE_INC('\uf5B8'),
    SQUARE_INC_CASH('\uf5B9'),
    STACKOVERFLOW('\uf5BA'),
    STAIRS('\uf5BB'),
    STAR('\uf5BC'),
    STAR_CIRCLE('\uf5BD'),
    STAR_HALF('\uf5BE'),
    STAR_OFF('\uf5BF'),
    STAR_OUTLINE('\uf5C0'),
    STEAM('\uf5C1'),
    STEERING('\uf5C2'),
    STEP_BACKWARD('\uf5C3'),
    STEP_BACKWARD_2('\uf5C4'),
    STEP_FORWARD('\uf5C5'),
    STEP_FORWARD_2('\uf5C6'),
    STETHOSCOPE('\uf5C7'),
    STOCKING('\uf5C8'),
    STOP('\uf5C9'),
    STORE('\uf5CA'),
    STORE_24_HOUR('\uf5CB'),
    STOVE('\uf5CC'),
    SUBWAY('\uf5CD'),
    SUNGLASSES('\uf5CE'),
    SWAP_HORIZONTAL('\uf5CF'),
    SWAP_VERTICAL('\uf5D0'),
    SWIM('\uf5D1'),
    SWITCH('\uf5D2'),
    SWORD('\uf5D3'),
    SYNC('\uf5D4'),
    SYNC_ALERT('\uf5D5'),
    SYNC_OFF('\uf5D6'),
    TAB('\uf5D7'),
    TAB_UNSELECTED('\uf5D8'),
    TABLE('\uf5D9'),
    TABLE_COLUMN_PLUS_AFTER('\uf5DA'),
    TABLE_COLUMN_PLUS_BEFORE('\uf5DB'),
    TABLE_COLUMN_REMOVE('\uf5DC'),
    TABLE_COLUMN_WIDTH('\uf5DD'),
    TABLE_EDIT('\uf5DE'),
    TABLE_LARGE('\uf5DF'),
    TABLE_ROW_HEIGHT('\uf5E0'),
    TABLE_ROW_PLUS_AFTER('\uf5E1'),
    TABLE_ROW_PLUS_BEFORE('\uf5E2'),
    TABLE_ROW_REMOVE('\uf5E3'),
    TABLET('\uf5E4'),
    TABLET_ANDROID('\uf5E5'),
    TABLET_IPAD('\uf5E6'),
    TAG('\uf5E7'),
    TAG_FACES('\uf5E8'),
    TAG_MULTIPLE('\uf5E9'),
    TAG_OUTLINE('\uf5EA'),
    TAG_TEXT_OUTLINE('\uf5EB'),
    TARGET('\uf5EC'),
    TAXI('\uf5ED'),
    TEAMVIEWER('\uf5EE'),
    TELEGRAM('\uf5EF'),
    TELEVISION('\uf5F0'),
    TELEVISION_GUIDE('\uf5F1'),
    TEMPERATURE_CELSIUS('\uf5F2'),
    TEMPERATURE_FAHRENHEIT('\uf5F3'),
    TEMPERATURE_KELVIN('\uf5F4'),
    TENNIS('\uf5F5'),
    TENT('\uf5F6'),
    TERRAIN('\uf5F7'),
    TEXT_TO_SPEECH('\uf5F8'),
    TEXT_TO_SPEECH_OFF('\uf5F9'),
    TEXTURE('\uf5FA'),
    THEATER('\uf5FB'),
    THEME_LIGHT_DARK('\uf5FC'),
    THERMOMETER('\uf5FD'),
    THERMOMETER_LINES('\uf5FE'),
    THUMB_DOWN('\uf5FF'),
    THUMB_DOWN_OUTLINE('\uf600'),
    THUMB_UP('\uf601'),
    THUMB_UP_OUTLINE('\uf602'),
    THUMBS_UP_DOWN('\uf603'),
    TICKET('\uf604'),
    TICKET_ACCOUNT('\uf605'),
    TICKET_CONFIRMATION('\uf606'),
    TIE('\uf607'),
    TIMELAPSE('\uf608'),
    TIMER('\uf609'),
    TIMER_10('\uf60A'),
    TIMER_3('\uf60B'),
    TIMER_OFF('\uf60C'),
    TIMER_SAND('\uf60D'),
    TIMETABLE('\uf60E'),
    TOGGLE_SWITCH('\uf60F'),
    TOGGLE_SWITCH_OFF('\uf610'),
    TOOLTIP('\uf611'),
    TOOLTIP_EDIT('\uf612'),
    TOOLTIP_IMAGE('\uf613'),
    TOOLTIP_OUTLINE('\uf614'),
    TOOLTIP_OUTLINE_PLUS('\uf615'),
    TOOLTIP_TEXT('\uf616'),
    TOR('\uf617'),
    TRAFFIC_LIGHT('\uf618'),
    TRAIN('\uf619'),
    TRAM('\uf61A'),
    TRANSCRIBE('\uf61B'),
    TRANSCRIBE_CLOSE('\uf61C'),
    TRANSFER('\uf61D'),
    TREE('\uf61E'),
    TRELLO('\uf61F'),
    TRENDING_DOWN('\uf620'),
    TRENDING_NEUTRAL('\uf621'),
    TRENDING_UP('\uf622'),
    TRIANGLE('\uf623'),
    TRIANGLE_OUTLINE('\uf624'),
    TROPHY('\uf625'),
    TROPHY_AWARD('\uf626'),
    TROPHY_OUTLINE('\uf627'),
    TROPHY_VARIANT('\uf628'),
    TROPHY_VARIANT_OUTLINE('\uf629'),
    TRUCK('\uf62A'),
    TRUCK_DELIVERY('\uf62B'),
    TSHIRT_CREW('\uf62C'),
    TSHIRT_V('\uf62D'),
    TUMBLR('\uf62E'),
    TUMBLR_REBLOG('\uf62F'),
    TWITCH('\uf630'),
    TWITTER('\uf631'),
    TWITTER_BOX('\uf632'),
    TWITTER_CIRCLE('\uf633'),
    TWITTER_RETWEET('\uf634'),
    UBUNTU('\uf635'),
    UMBRACO('\uf636'),
    UMBRELLA('\uf637'),
    UMBRELLA_OUTLINE('\uf638'),
    UNDO('\uf639'),
    UNDO_VARIANT('\uf63A'),
    UNFOLD_LESS('\uf63B'),
    UNFOLD_MORE('\uf63C'),
    UNGROUP('\uf63D'),
    UNTAPPD('\uf63E'),
    UPLOAD('\uf63F'),
    USB('\uf640'),
    VECTOR_ARRANGE_ABOVE('\uf641'),
    VECTOR_ARRANGE_BELOW('\uf642'),
    VECTOR_CIRCLE('\uf643'),
    VECTOR_CIRCLE_VARIANT('\uf644'),
    VECTOR_COMBINE('\uf645'),
    VECTOR_CURVE('\uf646'),
    VECTOR_DIFFERENCE('\uf647'),
    VECTOR_DIFFERENCE_AB('\uf648'),
    VECTOR_DIFFERENCE_BA('\uf649'),
    VECTOR_INTERSECTION('\uf64A'),
    VECTOR_LINE('\uf64B'),
    VECTOR_POINT('\uf64C'),
    VECTOR_POLYGON('\uf64D'),
    VECTOR_POLYLINE('\uf64E'),
    VECTOR_SELECTION('\uf64F'),
    VECTOR_SQUARE('\uf650'),
    VECTOR_TRIANGLE('\uf651'),
    VECTOR_UNION('\uf652'),
    VERIFIED('\uf653'),
    VIBRATE('\uf654'),
    VIDEO('\uf655'),
    VIDEO_OFF('\uf656'),
    VIDEO_SWITCH('\uf657'),
    VIEW_AGENDA('\uf658'),
    VIEW_ARRAY('\uf659'),
    VIEW_CAROUSEL('\uf65A'),
    VIEW_COLUMN('\uf65B'),
    VIEW_DASHBOARD('\uf65C'),
    VIEW_DAY('\uf65D'),
    VIEW_GRID('\uf65E'),
    VIEW_HEADLINE('\uf65F'),
    VIEW_LIST('\uf660'),
    VIEW_MODULE('\uf661'),
    VIEW_QUILT('\uf662'),
    VIEW_STREAM('\uf663'),
    VIEW_WEEK('\uf664'),
    VIMEO('\uf665'),
    VINE('\uf666'),
    VK('\uf667'),
    VK_BOX('\uf668'),
    VK_CIRCLE('\uf669'),
    VOICEMAIL('\uf66A'),
    VOLUME_HIGH('\uf66B'),
    VOLUME_LOW('\uf66C'),
    VOLUME_MEDIUM('\uf66D'),
    VOLUME_OFF('\uf66E'),
    VPN('\uf66F'),
    WALK('\uf670'),
    WALLET('\uf671'),
    WALLET_GIFTCARD('\uf672'),
    WALLET_MEMBERSHIP('\uf673'),
    WALLET_TRAVEL('\uf674'),
    WAN('\uf675'),
    WATCH('\uf676'),
    WATCH_EXPORT('\uf677'),
    WATCH_IMPORT('\uf678'),
    WATER('\uf679'),
    WATER_OFF('\uf67A'),
    WATER_PERCENT('\uf67B'),
    WATER_PUMP('\uf67C'),
    WEATHER_CLOUDY('\uf67D'),
    WEATHER_FOG('\uf67E'),
    WEATHER_HAIL('\uf67F'),
    WEATHER_LIGHTNING('\uf680'),
    WEATHER_NIGHT('\uf681'),
    WEATHER_PARTLYCLOUDY('\uf682'),
    WEATHER_POURING('\uf683'),
    WEATHER_RAINY('\uf684'),
    WEATHER_SNOWY('\uf685'),
    WEATHER_SUNNY('\uf686'),
    WEATHER_SUNSET('\uf687'),
    WEATHER_SUNSET_DOWN('\uf688'),
    WEATHER_SUNSET_UP('\uf689'),
    WEATHER_WINDY('\uf68A'),
    WEATHER_WINDY_VARIANT('\uf68B'),
    WEB('\uf68C'),
    WEBCAM('\uf68D'),
    WEIGHT('\uf68E'),
    WEIGHT_KILOGRAM('\uf68F'),
    WHATSAPP('\uf690'),
    WHEELCHAIR_ACCESSIBILITY('\uf691'),
    WHITE_BALANCE_AUTO('\uf692'),
    WHITE_BALANCE_INCANDESCENT('\uf693'),
    WHITE_BALANCE_IRRADESCENT('\uf694'),
    WHITE_BALANCE_SUNNY('\uf695'),
    WIFI('\uf696'),
    WIFI_OFF('\uf697'),
    WII('\uf698'),
    WIKIPEDIA('\uf699'),
    WINDOW_CLOSE('\uf69A'),
    WINDOW_CLOSED('\uf69B'),
    WINDOW_MAXIMIZE('\uf69C'),
    WINDOW_MINIMIZE('\uf69D'),
    WINDOW_OPEN('\uf69E'),
    WINDOW_RESTORE('\uf69F'),
    WINDOWS('\uf6A0'),
    WORDPRESS('\uf6A1'),
    WORKER('\uf6A2'),
    WRAP('\uf6A3'),
    WRENCH('\uf6A4'),
    WUNDERLIST('\uf6A5'),
    XBOX('\uf6A6'),
    XBOX_CONTROLLER('\uf6A7'),
    XBOX_CONTROLLER_OFF('\uf6A8'),
    XDA('\uf6A9'),
    XING('\uf6AA'),
    XING_BOX('\uf6AB'),
    XING_CIRCLE('\uf6AC'),
    XML('\uf6AD'),
    YEAST('\uf6AE'),
    YELP('\uf6AF'),
    YOUTUBE_PLAY('\uf6B0'),
    ZIP_BOX('\uf6B1');

    private final char character;

    private MaterialDesignIcon(char character) {
        this.character = character;
    }

    @Override
    public char getChar() {
        return character;
    }

    @Override
    public String unicodeToString() {
        return String.format("\\u%04x", (int) character);
    }

    @Override
    public String characterToString() {
        return Character.toString(character);
    }

    @Override
    public String getFontFamily() {
        return "\'Material Design Icons\'";
    }

}
