'\" t
.\"     fhist - file history and comparison tools
.\"     Copyright (C) 2003, 2008, 2009 Peter Miller
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 3 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program. If not, see
.\"     <http://www.gnu.org/licenses/>.
.\"
.ds n) fhist
.TH "Release" "FHist" "FHist" "FHist"
.if n .ftr CB B
.if n .ftr CI I
.if n .ftr CW R
.if n .ftr C  R
.if n .ad l
.if n .hy 0
.so version.so
.de e(
.br
.ne 2i
.RS
.ft CW
.nf
.sp
..
.de e)
.sp
.fi
.ft R
.RE
..
.SH NAME
How to release a version of FHist
.SH CHECKLIST
This document describes the steps involved in issuing a new release
of FHist.
It is a simple procedure, but there is enough to do, and it happens
sufficiently rarely, that it was worth writing down.
.br
.ne 2i
.SH NEW BRANCH
The version stamping is \fIpost\fP-numbered.
You decide what major or minor version number you want
as you are about to release,
not when you start work.
.PP
Finish development of the branch in the normal way.
For example, if you are working on project \fIfhist.51.19\fP,
then you would say
.e(
% \f[CB]aede -p fhist.51 19\fP
% \f[CB]aerpass -p fhist.51 19\fP
% \f[CB]aeib -p fhist.51 19\fP
% \f[CB]aed -p fhist.51 19\fP
% \f[CB]aeb -p fhist.51 19\fP
% \f[CB]aet -p fhist.51 19\fP
% \f[CB]aet -reg -p fhist.51 -c 19\fP
% \f[CB]aeipass -reg -p fhist.51 -c 19\fP
%
.e)
At this point, branch 19 if project \fIfhist.51\fP is completed.
Cut a new branch, as follows
.e(
% \f[CB]aenbr -p fhist.51 20\fP
%
.e)
The branch number will default.  This is OK unless you ever skipped a
number - in which case it will back fill which is usually undesirable.
.PP
At this point project \fIfhist.51.20\fP is ready for use.  If you want
a major version number increment, the process is similar, however you
must also terminate the \fIfhist.51\fP branch, and you may well want to
create a branch on the branch, to get back to a two-number version scheme.
.e(
aede -p fhist.51 19 \fIet al, to complete\fP
aede -p fhist 51 \fIet al, to complete\fP
aenbr -p fhist 52
aenbr -p fhist 52 0
.e)
The purpose of a \fIpost\fP-numbered branching scheme is that, at any point,
you can cut a suitable bug-fix sub-branch.
.br
.ne 2i
.SS Verify New Branch
Create a new change on the branch you just created,
and start development of it.
.PP
Update any version numbering files,
or create any special release notes files, \fIetc\fP,
as required.
Much of this can be obtained from Aegis, but not all of it.
.br
.ne 2i
.SH ARCHIVES
Once a viable release is ready, it is necessary to upload it to the archives.
.SS Update Primary Archive
Transfer a copy to \f[CW]fhist.sourceforget.net\fP by scp.
Use the following commands
.e(
% \f[CB]aecd -bl archive\fP
% PLASTICFS=`aesub -bl 'viewpath ${split : $sp}'` \e
    LD_PRELOAD=libplasticfs.so \e
    \f[CB]/usr/bin/rsync --rsh=ssh \e
    -l -r -t -z --stats --delete \e
    --progress --exclude '*,*' -v \e
    `aegis -cd -bl archive` \e
    fhist.sourceforge.net:/home/groups/f/fh/fhist/htdocs/.\fP
%
.e)
.PP
And also transfer the Aegis project tree...
.e(
#!/bin/sh
#
# Sync this directory tree with fhist.SourceForge.net
#
/usr/bin/rsync --rsh=ssh -l -p -r -t -z --stats \e
        --exclude bin \e
        --exclude archive \e
        --exclude linux-i486 \e
        --exclude "*.[ao]" \e
        --exclude "*.[ch].d" \e
        --exclude "*.so.d" \e
        --exclude "*.gen.[ch]" \e
        --exclude "*,*" \e
        --exclude ".cook.fp" \e
        --exclude aegis.log \e
        --exclude doxygen-html \e
        --delete \e
        --delete-excluded \e
        --progress -v \e
        `aegis -cd -bl .. -p fhist` \e
        fhist.sourceforge.net:/home/groups/f/fh/fhist/fhist/.
.e)
But this is all in a shell script to reduce typing, so all you need to do is
.e(
% \f[CB]aecd -bl .. -p fhist\fP
% \f[CW]./rsync-sourceforge\fP
%
.e)
.PP
Transfer a copy to \f[CW]upload.sourceforge.net\fP by FTP.
Login as \f[CW]anonymous\fP and change to the \f[CW]/incoming\fP directory.
Use the following commands
.e(
% \f[CB]aecd -bl archive\fP
% \f[CW]ftp upload.sourceforge.net\fP
user: \f[CB]anonymous\fP
ftp> \f[CB]cd /incoming\fP
ftp> \f[CB]binary\fP
ftp> \f[CB]put fhist-\*(v).tar.gz\fP
ftp> \f[CB]quit\fP
%
.e)
.br
.ne 2i
.SH NOTIFICATION
Once the archives are ready, you can let folks know it's there.
.LP
Only send the notifications \fIafter\fP the files are actually available
at the archive site.
.br
.ne 2i
.SS SourceForge.Net
This is \fIway\fP harder than any sane person expects.
Go to http://sourceforge.net and login then go to
http://sourceforge.net/projects/fhist/
and click the \fBAdmin\fP link,
and the \fBEdit/Release Files\fP link,
and the \fB[Add Release]\fP link.
In the "\fINew Release Name\fP" box put the version number (dumb, huh?).
In the "\fIPaste The Notes In\fP" box type
.RS
http://fhist.sourceforge.net/download.html
.RE
In the "\fIPaste The Change Log In\fP" box type
.RS
http://fhist.sourceforge.net/ChangeLog
.RE
And then finish the rest of the rather cumbersome dialog gunk.
.SS Notify Mailing List
Send a notification to the \fIfhist-users@lists.sourceforge.net\fP list.
It should look like this:
.e(
To: fhist-users@lists.sourceforge.net
Reply-To: pmiller@opensource.org.au
Subject: FHist \*(v) \- file history tool

.fi
I am pleased to announce that FHist \*(v) is now available.
.sp
You are invited to visit
.ce 1
http://fhist.sourceforge.net/
for a more complete description of what FHist is, and access to the
download files.
.sp
For information about what new features are available in this
release, please see the README file available at the above site.
.sp
\fIput your \f[CW].sig\fI file here
.e)
.PP
Only send this notification \fIafter\fP the files are actually available
at the archive site.
.SS Notify Web
\(bu) Notify \f[CW]www.freshmeat.net\fP that a new release of Aegis
is available.
Search for ``fhist'' as there is already an application record.
.so ../lib/en/man1/z_cr.so
