-- $Id$ 

-- test for case stat with alternatives.

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


entity test_bench is
end entity test_bench;

architecture test_bench_impl of test_bench is
BEGIN

	p : process
		variable c : integer;
		variable d : integer;
	begin
		c := 1;

		case c is
		when 0 =>
			assert false report "c != 0" severity failure;
			d := 0;
		when 1 => 
			d := 1;
			null;
		when others =>
			d := 0;
			assert false report "c != 0" severity failure;
		end case;

		if d /= 1 then
			assert false report "case alternative not executed." 
				severity failure;
		end if;

		assert false report "simulation finished" severity note;
		wait;

	end process p;
END architecture test_bench_impl;

