/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/reporting/ErrorRegistry.hpp"

namespace ast {

void
ErrorRegistry::addError(CompileError *error)
{
	errors.push_back(error);
}

void
ErrorRegistry::addWarning(CompileError *warning)
{
	if (ErrorRegistry::werror) {
		errors.push_back(warning);
	} else {
		warnings.push_back(warning);
	}
}

void
ErrorRegistry::addPotentialError(CompileError *error)
{
	potentialErrors.push_back(error);
}

void
ErrorRegistry::rejectPotentials(void)
{
	for (std::list<CompileError*>::const_iterator i = 
		ErrorRegistry::potentialErrors.begin(); 
		i != ErrorRegistry::potentialErrors.end(); i++) {

		delete *i;
	}

	potentialErrors.clear();
}

void
ErrorRegistry::acceptPotentials(void)
{
	for (std::list<CompileError*>::const_iterator i = 
		potentialErrors.begin(); i != potentialErrors.end(); i++) {

		errors.push_back(*i);
	}
	potentialErrors.clear();
}

bool
ErrorRegistry::hasErrors(void)
{
	return not errors.empty();
}

bool
ErrorRegistry::hasWarnings(void)
{
	return not warnings.empty();
}

void
ErrorRegistry::putWarnings(std::ostream &stream)
{
	for (std::list<CompileError*>::const_iterator i = 
			warnings.begin(); i != warnings.end(); i++) {

		stream << "WARNING> " << **i << std::endl;
	}
}

void
ErrorRegistry::putErrors(std::ostream &stream)
{
	for (std::list<CompileError*>::const_iterator i = 
			errors.begin(); i != errors.end(); i++) {

		stream << "ERROR> " << **i << std::endl;
	}
}

void
ErrorRegistry::flushAll(void)
{
	ErrorRegistry::rejectPotentials();

	for (std::list<CompileError*>::iterator i = 
			errors.begin(); i != errors.end(); i++) {

		delete *i;
	}

	for (std::list<CompileError*>::iterator i = 
			warnings.begin(); i != warnings.end(); i++) {

		delete *i;
	}

	warnings.clear();
	errors.clear();
}

void
ErrorRegistry::setWerror(bool val)
{
	assert(ErrorRegistry::warnings.empty());
	ErrorRegistry::werror = true;
}

/* initialize/define statics */
std::list<CompileError*> ErrorRegistry::errors = 
				std::list<CompileError*>();
std::list<CompileError*> ErrorRegistry::warnings =
				std::list<CompileError*>();
std::list<CompileError*> ErrorRegistry::potentialErrors = 
				std::list<CompileError*>();
bool ErrorRegistry::werror = false;

}; /* namespace ast */
