/* $Id: test3.c,v 1.3 2009/01/27 15:58:54 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUcc Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */
# 1 "i386.c"
# 1 "<built-in>"
# 1 "<command line>"
# 1 "i386.c"

# 1 "/usr/include/inttypes.h" 1 3 4
# 26 "/usr/include/inttypes.h" 3 4
# 1 "/usr/include/features.h" 1 3 4
# 308 "/usr/include/features.h" 3 4
# 1 "/usr/include/sys/cdefs.h" 1 3 4
# 309 "/usr/include/features.h" 2 3 4
# 331 "/usr/include/features.h" 3 4
# 1 "/usr/include/gnu/stubs.h" 1 3 4
# 332 "/usr/include/features.h" 2 3 4
# 27 "/usr/include/inttypes.h" 2 3 4

# 1 "/usr/include/stdint.h" 1 3 4
# 27 "/usr/include/stdint.h" 3 4
# 1 "/usr/include/bits/wchar.h" 1 3 4
# 28 "/usr/include/stdint.h" 2 3 4
# 1 "/usr/include/bits/wordsize.h" 1 3 4
# 29 "/usr/include/stdint.h" 2 3 4
# 37 "/usr/include/stdint.h" 3 4
typedef signed char int8_t;
typedef short int int16_t;
typedef int int32_t;

typedef long int int64_t;







typedef unsigned char uint8_t;
typedef unsigned short int uint16_t;

typedef unsigned int uint32_t;



typedef unsigned long int uint64_t;
# 66 "/usr/include/stdint.h" 3 4
typedef signed char int_least8_t;
typedef short int int_least16_t;
typedef int int_least32_t;

typedef long int int_least64_t;






typedef unsigned char uint_least8_t;
typedef unsigned short int uint_least16_t;
typedef unsigned int uint_least32_t;

typedef unsigned long int uint_least64_t;
# 91 "/usr/include/stdint.h" 3 4
typedef signed char int_fast8_t;

typedef long int int_fast16_t;
typedef long int int_fast32_t;
typedef long int int_fast64_t;
# 104 "/usr/include/stdint.h" 3 4
typedef unsigned char uint_fast8_t;

typedef unsigned long int uint_fast16_t;
typedef unsigned long int uint_fast32_t;
typedef unsigned long int uint_fast64_t;
# 120 "/usr/include/stdint.h" 3 4
typedef long int intptr_t;


typedef unsigned long int uintptr_t;
# 135 "/usr/include/stdint.h" 3 4
typedef long int intmax_t;
typedef unsigned long int uintmax_t;
# 29 "/usr/include/inttypes.h" 2 3 4






typedef int __gwchar_t;
# 274 "/usr/include/inttypes.h" 3 4





typedef struct
  {
    long int quot;
    long int rem;
  } imaxdiv_t;
# 298 "/usr/include/inttypes.h" 3 4
extern intmax_t imaxabs (intmax_t __n) __attribute__ ((__nothrow__)) __attribute__ ((__const__));


extern imaxdiv_t imaxdiv (intmax_t __numer, intmax_t __denom)
      __attribute__ ((__nothrow__)) __attribute__ ((__const__));


extern intmax_t strtoimax (__const char *__restrict __nptr,
      char **__restrict __endptr, int __base) __attribute__ ((__nothrow__));


extern uintmax_t strtoumax (__const char *__restrict __nptr,
       char ** __restrict __endptr, int __base) __attribute__ ((__nothrow__));


extern intmax_t wcstoimax (__const __gwchar_t *__restrict __nptr,
      __gwchar_t **__restrict __endptr, int __base)
     __attribute__ ((__nothrow__));


extern uintmax_t wcstoumax (__const __gwchar_t *__restrict __nptr,
       __gwchar_t ** __restrict __endptr, int __base)
     __attribute__ ((__nothrow__));
# 459 "/usr/include/inttypes.h" 3 4

# 3 "i386.c" 2
typedef int bool;
# 14 "i386.c"
int get(void);
int load(uint32_t addr);
void store(uint32_t value, uint32_t addr);



enum operand_t {
 OPERAND_EAX = 0x0,
 OPERAND_ECX = 0x1,
 OPERAND_EDX = 0x2,
 OPERAND_EBX = 0x3,
 OPERAND_ESP = 0x4,
 OPERAND_EBP = 0x5,
 OPERAND_ESI = 0x6,
 OPERAND_EDI = 0x7,
 OPERAND_T0,
 OPERAND_T1,
 OPERAND_T2,
 OPERAND_ADDR
};


uint32_t T0;
uint32_t T1;
uint32_t T2;
uint32_t ADDR;


uint32_t EAX;
uint32_t ECX;
uint32_t EDX;
uint32_t EBX;
uint32_t ESP;
uint32_t EBP;
uint32_t ESI;
uint32_t EDI;


uint16_t CS;
uint16_t SS;
uint16_t DS;
uint16_t ES;
uint16_t FS;
uint16_t GS;



uint32_t EIP;

uint32_t pc;


bool CF;
bool PF;
bool AF;
bool ZF;
bool SF;
bool OF;



enum {
 PREFIX_LR_NONE,
 PREFIX_LR_LOCK,
 PREFIX_LR_REPNZ,
 PREFIX_LR_REPZ
} prefix_lock_repeat;


enum {
 PREFIX_SO_NONE,
 PREFIX_SO_CS,
 PREFIX_SO_SS,
 PREFIX_SO_DS,
 PREFIX_SO_ES,
 PREFIX_SO_FS,
 PREFIX_SO_GS
} prefix_segment_override;

bool prefix_operand_size_override;
bool prefix_address_size_override;



bool code32;
bool addseg;





uint8_t get8(void) {
 pc += 1;
 return get();
}

uint16_t get16(void) {
 pc += 2;
 return get8() << 8 | get8();
}

uint32_t get32(void) {
 pc += 4;
 return get16() << 16 || get16();
}

uint32_t getn(int bits) {
 switch (bits) {
  case 1:
   return get8();
  case 2:
   return get16();
  case 4:
   return get32();
  default:
   ;
 }
}



void gen_mask_t0(int operand_size) {
 switch (operand_size) {
  case 1: T0 = T0 & 0xff; break;
  case 2: T0 = T0 & 0xffff; break;
  case 4: T0 = T0 & 0xffffffff; break;
  default: ;
 }
}

void gen_mask_t1(int operand_size) {
 switch (operand_size) {
  case 1: T1 = T1 & 0xff; break;
  case 2: T1 = T1 & 0xffff; break;
  case 4: T1 = T1 & 0xffffffff; break;
  default: ;
 }
}

void gen_mask_t2(int operand_size) {
 switch (operand_size) {
  case 1: T2 = T2 & 0xff; break;
  case 2: T2 = T2 & 0xffff; break;
  case 4: T2 = T2 & 0xffffffff; break;
  default: ;
 }
}



void gen_store_t0(enum operand_t operand, int operand_size) {
 gen_mask_t0(operand_size);

 switch (operand) {
  case OPERAND_EAX: EAX = T0; break;
  case OPERAND_ECX: ECX = T0; break;
  case OPERAND_EDX: EDX = T0; break;
  case OPERAND_EBX: EBX = T0; break;
  case OPERAND_ESP: ESP = T0; break;
  case OPERAND_EBP: EBP = T0; break;
  case OPERAND_ESI: ESI = T0; break;
  case OPERAND_EDI: EDI = T0; break;
  case OPERAND_T0: break;
  case OPERAND_ADDR: store(T0, ADDR); break;
  default: ;
 }
}

void gen_load_t1(enum operand_t operand, int operand_size) {
 switch (operand) {
  case OPERAND_EAX: T1 = EAX; break;
  case OPERAND_ECX: T1 = ECX; break;
  case OPERAND_EDX: T1 = EDX; break;
  case OPERAND_EBX: T1 = EBX; break;
  case OPERAND_ESP: T1 = ESP; break;
  case OPERAND_EBP: T1 = EBP; break;
  case OPERAND_ESI: T1 = ESI; break;
  case OPERAND_EDI: T1 = EDI; break;
  case OPERAND_T1: break;
  case OPERAND_ADDR: T1 = load(ADDR); break;
  default: ;
 }
 gen_mask_t1(operand_size);
}

void gen_load_t2(enum operand_t operand, int operand_size) {
 switch (operand) {
  case OPERAND_EAX: T2 = EAX; break;
  case OPERAND_ECX: T2 = ECX; break;
  case OPERAND_EDX: T2 = EDX; break;
  case OPERAND_EBX: T2 = EBX; break;
  case OPERAND_ESP: T2 = ESP; break;
  case OPERAND_EBP: T2 = EBP; break;
  case OPERAND_ESI: T2 = ESI; break;
  case OPERAND_EDI: T2 = EDI; break;
  case OPERAND_T2: break;
  case OPERAND_ADDR: T2 = load(ADDR); break;
  default: ;
 }
 gen_mask_t2(operand_size);
}
# 226 "i386.c"
void gen_update_sf(int operand_size) {
 switch (operand_size) {
  case 1: SF = T0 >> 7; break;
  case 2: SF = T0 >> 15; break;
  case 4: SF = T0 >> 31; break;
  default: ;
 }
}
# 243 "i386.c"
void gen_update_zf(void) {
 ZF = (T0 == 0) ? 1 : 0;
}
# 256 "i386.c"
void gen_update_pf(void) {
 static const uint8_t parity_table[256] = {
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0,
  1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
 };
 PF = parity_table[(uint8_t) T0];
}
# 286 "i386.c"
void gen_update_sf_zf_pf(int operand_size) {
 gen_update_sf(operand_size);
 gen_update_zf();
 gen_update_pf();
}
# 299 "i386.c"
void gen_inc(enum operand_t operand, int operand_size) {
 gen_load_t1(operand, operand_size);
 T0 = T1 + 1;
 gen_store_t0(operand, operand_size);
 gen_update_sf_zf_pf(operand_size);
 OF = 0;
 AF = 0;

}


void gen_dec(enum operand_t operand, int operand_size) {
 gen_load_t1(operand, operand_size);
 T0 = T1 - 1;
 gen_store_t0(operand, operand_size);
 gen_update_sf_zf_pf(operand_size);
 OF = 0;
 AF = 0;

}


void gen_add(enum operand_t operand_a, enum operand_t operand_b, int operand_size) {
 gen_load_t1(operand_a, operand_size);
 gen_load_t2(operand_b, operand_size);
 T0 = T1 + T2;
 gen_store_t0(operand_a, operand_size);
 gen_update_sf_zf_pf(operand_size);
 CF = 0;
 OF = 0;
 AF = 0;
}


void gen_or(enum operand_t operand_a, enum operand_t operand_b, int operand_size) {
 gen_load_t1(operand_a, operand_size);
 gen_load_t2(operand_b, operand_size);
 T0 = T1 | T2;
 gen_store_t0(operand_a, operand_size);
 gen_update_sf_zf_pf(operand_size);
 OF = 0;
 CF = 0;
 AF = 0;
}


void gen_adc(enum operand_t operand_a, enum operand_t operand_b, int operand_size) {
 gen_load_t1(operand_a, operand_size);
 gen_load_t2(operand_b, operand_size);
 T0 = T1 + T2 + CF;
 gen_store_t0(operand_a, operand_size);
 gen_update_sf_zf_pf(operand_size);
 CF = 0;
 OF = 0;
 AF = 0;
}


void gen_sbb(enum operand_t operand_a, enum operand_t operand_b, int operand_size) {
 gen_load_t1(operand_a, operand_size);
 gen_load_t2(operand_b, operand_size);
 T0 = T1 - (T2 + CF);
 gen_store_t0(operand_a, operand_size);
 gen_update_sf_zf_pf(operand_size);
 CF = 0;
 OF = 0;
 AF = 0;
}


void gen_and(enum operand_t operand_a, enum operand_t operand_b, int operand_size) {
 gen_load_t1(operand_a, operand_size);
 gen_load_t2(operand_b, operand_size);
 T0 = T1 & T2;
 gen_store_t0(operand_a, operand_size);
 gen_update_sf_zf_pf(operand_size);
 OF = 0;
 CF = 0;
 AF = 0;
}


void gen_sub(enum operand_t operand_a, enum operand_t operand_b, int operand_size) {
 gen_load_t1(operand_a, operand_size);
 gen_load_t2(operand_b, operand_size);
 T0 = T1 - T2;
 gen_store_t0(operand_a, operand_size);
 gen_update_sf_zf_pf(operand_size);
 CF = 0;
 OF = 0;
 AF = 0;
}


void gen_xor(enum operand_t operand_a, enum operand_t operand_b, int operand_size) {
 gen_load_t1(operand_a, operand_size);
 gen_load_t2(operand_b, operand_size);
 T0 = T1 ^ T2;
 gen_store_t0(operand_a, operand_size);
 gen_update_sf_zf_pf(operand_size);
 OF = 0;
 CF = 0;
 AF = 0;
}


void gen_cmp(enum operand_t operand_a, enum operand_t operand_b, int operand_size) {
 gen_load_t1(operand_a, operand_size);
 gen_load_t2(operand_b, operand_size);
 T0 = T1 - T2;
 gen_store_t0(operand_a, operand_size);
 gen_update_sf_zf_pf(operand_size);
 OF = 0;
 CF = 0;
 AF = 0;
}
# 444 "i386.c"
void disas_mod_rm(enum operand_t *operand_reg, enum operand_t *operand_rm) {
 int mod_rm, mod, reg, rm;

 mod_rm = get8();

 mod = (mod_rm >> 6) & 3;
 reg = (mod_rm >> 3) & 7;
 rm = mod_rm & 7;

 if (operand_reg)
  *operand_reg = reg;

 if (!operand_rm)
  return;

 if (mod == 3) {
  *operand_rm = rm;
  return;
 }

 *operand_rm = OPERAND_ADDR;


 if (code32 ^ prefix_address_size_override) {
  int scale, index, base;
  uint32_t disp;

  if (rm == 4) {
   int sib = get8();
   scale = (sib >> 6) & 3;
   index = (sib >> 3) & 7;
   base = sib & 7;
  } else {
   scale = 0;
   index = 0;
   base = rm;
  }

  switch (mod) {
   case 0:
    if (base == 5) {
     disp = get32();
     base = -1;
    } else {
     disp = 0;
    }
    break;
   case 1:
    disp = get8();
    break;
   case 2:
    disp = get32();
    break;
   case 3:
   default:
    ;
  }

  if (disp != 0)
   ADDR = disp;
  else
   ADDR = 0;

  if (base >= 0) {

   switch (base) {
    case OPERAND_EAX: ADDR += EAX; break;
    case OPERAND_ECX: ADDR += ECX; break;
    case OPERAND_EDX: ADDR += EDX; break;
    case OPERAND_EBX: ADDR += EBX; break;
    case OPERAND_ESP: ADDR += ESP; break;
    case OPERAND_EBP: ADDR += EBP; break;
    case OPERAND_ESI: ADDR += ESI; break;
    case OPERAND_EDI: ADDR += EDI; break;
    default: ;
   }
  }

  if (scale == 0) {
   switch (index) {
    case OPERAND_EAX: ADDR += EAX; break;
    case OPERAND_ECX: ADDR += ECX; break;
    case OPERAND_EDX: ADDR += EDX; break;
    case OPERAND_EBX: ADDR += EBX; break;
    case OPERAND_ESP: break;
    case OPERAND_EBP: ADDR += EBP; break;
    case OPERAND_ESI: ADDR += ESI; break;
    case OPERAND_EDI: ADDR += EDI; break;
    default: ;
   }
  } else if (scale == 1) {
   switch (index) {
    case OPERAND_EAX: ADDR += EAX * 2; break;
    case OPERAND_ECX: ADDR += ECX * 2; break;
    case OPERAND_EDX: ADDR += EDX * 2; break;
    case OPERAND_EBX: ADDR += EBX * 2; break;
    case OPERAND_ESP: break;
    case OPERAND_EBP: ADDR += EBP * 2; break;
    case OPERAND_ESI: ADDR += ESI * 2; break;
    case OPERAND_EDI: ADDR += EDI * 2; break;
    default: ;
   }
  } else if (scale == 2) {
   switch (index) {
    case OPERAND_EAX: ADDR += EAX * 4; break;
    case OPERAND_ECX: ADDR += ECX * 4; break;
    case OPERAND_EDX: ADDR += EDX * 4; break;
    case OPERAND_EBX: ADDR += EBX * 4; break;
    case OPERAND_ESP: break;
    case OPERAND_EBP: ADDR += EBP * 4; break;
    case OPERAND_ESI: ADDR += ESI * 4; break;
    case OPERAND_EDI: ADDR += EDI * 4; break;
    default: ;
   }
  } else if (scale == 3) {
   switch (index) {
    case OPERAND_EAX: ADDR += EAX * 8; break;
    case OPERAND_ECX: ADDR += ECX * 8; break;
    case OPERAND_EDX: ADDR += EDX * 8; break;
    case OPERAND_EBX: ADDR += EBX * 8; break;
    case OPERAND_ESP: break;
    case OPERAND_EBP: ADDR += EBP * 8; break;
    case OPERAND_ESI: ADDR += ESI * 8; break;
    case OPERAND_EDI: ADDR += EDI * 8; break;
    default: ;
   }
  }

  if (prefix_segment_override != PREFIX_SO_NONE || addseg) {
   if (base == OPERAND_EBP || base == OPERAND_ESP)
    ADDR += SS;
   else
    ADDR += DS;
  }
 } else {
  uint32_t disp;

  switch (mod) {
   case 0:
    if (rm == 6) {
     disp = get16();
     rm = -1;
    } else {
     disp = 0;
    }
    break;
   case 1:
    disp = get8();
    break;
   case 2:
    disp = get16();
    break;
   case 3:

   default:
    break;
  }

  if (disp != 0)
   ADDR = disp;
  else
   ADDR = 0;

  switch (rm) {
   case -1: break;
   case 0: ADDR += EBX + ESI; break;
   case 1: ADDR += EBX + EDI; break;
   case 2: ADDR += EBP + ESI; break;
   case 3: ADDR += EBP + EDI; break;
   case 4: ADDR += ESI; break;
   case 5: ADDR += EDI; break;
   case 6: ADDR += EBP; break;
   case 7: ADDR += EBX; break;
   default: ;
  }

  ADDR = ADDR & 0xffff;

  if (prefix_segment_override != PREFIX_SO_NONE || addseg) {
   if (rm == 2 || rm == 3 || rm == 6)
    ADDR += SS;
   else
    ADDR += DS;
  }
 }
}
# 642 "i386.c"
void disas_arithmetic_and_logic(int opcode) {
 int operation, direction, immediate, operand_size;
 enum operand_t operand_a, operand_b;

 operation = (opcode >> 3) & 7;
 direction = (opcode >> 1) & 1;
 immediate = (opcode >> 2) & 1;

 if ((opcode & 1) == 0)
  operand_size = 1;
 else
  operand_size = (code32 ^ prefix_operand_size_override) ? 4 : 2;

 if (immediate == 1) {
  uint32_t immediate;

  immediate = getn(operand_size);
  T2 = immediate;

  operand_a = OPERAND_EAX;
  operand_b = OPERAND_T2;
 } else {
  enum operand_t operand_reg, operand_rm;

  disas_mod_rm(&operand_reg, &operand_rm);

  if (direction == 0) {
   operand_a = operand_rm;
   operand_b = operand_reg;
  } else {
   operand_a = operand_reg;
   operand_b = operand_rm;
  }
 }

 switch (operation) {
  case 0x0: gen_add(operand_a, operand_b, operand_size); break;
  case 0x1: gen_or(operand_a, operand_b, operand_size); break;
  case 0x2: gen_adc(operand_a, operand_b, operand_size); break;
  case 0x3: gen_sbb(operand_a, operand_b, operand_size); break;
  case 0x4: gen_and(operand_a, operand_b, operand_size); break;
  case 0x5: gen_sub(operand_a, operand_b, operand_size); break;
  case 0x6: gen_xor(operand_a, operand_b, operand_size); break;
  case 0x7: gen_cmp(operand_a, operand_b, operand_size); break;
  default: ;
 }
}
# 698 "i386.c"
void disas_group_1(int opcode) {
 int operation, operand_size;
 enum operand_t operand_a, operand_b;
 uint32_t immediate;

 if ((opcode & 1) == 0)
  operand_size = 1;
 else
  operand_size = (code32 ^ prefix_operand_size_override) ? 4 : 2;

 if (opcode == 0x83)
  immediate = get8();
 else
  immediate = getn(operand_size);

 T2 = immediate;
 operand_b = OPERAND_T2;

 disas_mod_rm((enum operand_t *) &operation, &operand_a);

 switch (operation) {
  case 0x0: gen_add(operand_a, operand_b, operand_size); break;
  case 0x1: gen_or(operand_a, operand_b, operand_size); break;
  case 0x2: gen_adc(operand_a, operand_b, operand_size); break;
  case 0x3: gen_sbb(operand_a, operand_b, operand_size); break;
  case 0x4: gen_and(operand_a, operand_b, operand_size); break;
  case 0x5: gen_sub(operand_a, operand_b, operand_size); break;
  case 0x6: gen_xor(operand_a, operand_b, operand_size); break;
  case 0x7: gen_cmp(operand_a, operand_b, operand_size); break;
  default: ;
 }
}







void disas_inc_register(int opcode) {
 gen_inc(opcode & 0x7, (code32 ^ prefix_operand_size_override) ? 4 : 2);
}







void disas_dec_register(int opcode) {
 gen_dec(opcode & 0x7, (code32 ^ prefix_operand_size_override) ? 4 : 2);
}
# 759 "i386.c"
void disas_group_3(int opcode) {
 int operation, operand_size;
 enum operand_t operand_a, operand_b;

 if ((opcode & 1) == 0)
  operand_size = 1;
 else
  operand_size = (code32 ^ prefix_operand_size_override) ? 4 : 2;

 disas_mod_rm((enum operand_t *) &operation, &operand_b);

 if (operation != 0x2 && operation != 0x3) {
  uint32_t immediate = getn(operand_size);
  T2 = immediate;
  operand_b = OPERAND_T2;
 }

 switch (operation) {
  case 0x0: gen_test(operand_a, operand_b, operand_size); break;
  case 0x1: ;
  case 0x2: gen_not(operand_a, operand_size); break;
  case 0x3: gen_neg(operand_a, operand_size); break;
  case 0x4: gen_mul(operand_a, operand_b, operand_size); break;
  case 0x5: gen_imul(operand_a, operand_b, operand_size); break;
  case 0x6: gen_div(operand_a, operand_b, operand_size); break;
  case 0x7: gen_idiv(operand_a, operand_b, operand_size); break;
  default: ;
 }
}
# 840 "i386.c"
void disas_opcode_two(int opcode) {
 int opcode2;

 if (opcode != 0x0f)
  ;

 opcode2 = get8();
 opcode = 0x0f00 | opcode2;

 switch (opcode) {
  case 0x00:

   break;

  default:
   ;
 }
}







void disas_opcode_one(bool lock) {
 int opcode;

 opcode = get8();

 switch (opcode) {
  case 0x00:
  case 0x01:
  case 0x02:
  case 0x03:
  case 0x04:
  case 0x05:
   disas_arithmetic_and_logic(opcode);
   break;
  case 0x06:

   break;
  case 0x07:

   break;
  case 0x08:
  case 0x09:
  case 0x0a:
  case 0x0b:
  case 0x0c:
  case 0x0d:
   disas_arithmetic_and_logic(opcode);
   break;
  case 0x0e:

   break;
  case 0x0f:
   disas_opcode_two(opcode);
   break;
  case 0x10:
  case 0x11:
  case 0x12:
  case 0x13:
  case 0x14:
  case 0x15:
   disas_arithmetic_and_logic(opcode);
   break;
  case 0x16:

   break;
  case 0x17:

   break;
  case 0x18:
  case 0x19:
  case 0x1a:
  case 0x1b:
  case 0x1c:
  case 0x1d:
   disas_arithmetic_and_logic(opcode);
   break;
  case 0x1e:

   break;
  case 0x1f:

   break;
  case 0x20:
  case 0x21:
  case 0x22:
  case 0x23:
  case 0x24:
  case 0x25:
   disas_arithmetic_and_logic(opcode);
   break;
  case 0x26:
   prefix_segment_override = PREFIX_SO_ES;
   disas_opcode_one(lock);
   break;
  case 0x27:

   break;
  case 0x28:
  case 0x29:
  case 0x2a:
  case 0x2b:
  case 0x2c:
  case 0x2d:
   disas_arithmetic_and_logic(opcode);
   break;
  case 0x2e:
   prefix_segment_override = PREFIX_SO_CS;
   disas_opcode_one(lock);
   break;
  case 0x2f:

   break;
  case 0x30:
  case 0x31:
  case 0x32:
  case 0x33:
  case 0x34:
  case 0x35:
   disas_arithmetic_and_logic(opcode);
   break;
  case 0x36:
   prefix_segment_override = PREFIX_SO_SS;
   disas_opcode_one(lock);
   break;
  case 0x37:

   break;
  case 0x38:
  case 0x39:
  case 0x3a:
  case 0x3b:
  case 0x3c:
  case 0x3d:
   disas_arithmetic_and_logic(opcode);
   break;
  case 0x3e:
   prefix_segment_override = PREFIX_SO_DS;
   disas_opcode_one(lock);
   break;
  case 0x3f:

   break;
  case 0x40:
  case 0x41:
  case 0x42:
  case 0x43:
  case 0x44:
  case 0x45:
  case 0x46:
  case 0x47:
   disas_inc_register(opcode);
   break;
  case 0x48:
  case 0x49:
  case 0x4a:
  case 0x4b:
  case 0x4c:
  case 0x4d:
  case 0x4e:
  case 0x4f:
   disas_dec_register(opcode);
   break;
  case 0x50:
  case 0x51:
  case 0x52:
  case 0x53:
  case 0x54:
  case 0x55:
  case 0x56:
  case 0x57:
   disas_push_register(opcode);
   break;
  case 0x58:
  case 0x59:
  case 0x5a:
  case 0x5b:
  case 0x5c:
  case 0x5d:
  case 0x5e:
  case 0x5f:
   disas_pop_register(opcode);
   break;
  case 0x60:

   break;
  case 0x61:

   break;
  case 0x62:

   break;
  case 0x63:

   break;
  case 0x64:
   prefix_segment_override = PREFIX_SO_FS;
   disas_opcode_one(lock);
   break;
  case 0x65:
   prefix_segment_override = PREFIX_SO_GS;
   disas_opcode_one(lock);
   break;
  case 0x66:
   prefix_operand_size_override = (!(0));
   disas_opcode_one(lock);
   break;
  case 0x67:
   prefix_address_size_override = (!(0));
   disas_opcode_one(lock);
   break;



  case 0x80:
  case 0x81:
  case 0x82:
  case 0x83:
   disas_group_1(opcode);
   break;






  case 0xf0:
   prefix_lock_repeat = PREFIX_LR_LOCK;
   if (!lock) {
    gen_lock();
    disas_opcode_one((!(0)));
    gen_unlock();
   } else {
    disas_opcode_one((!(0)));
   }
   break;
  case 0xf1:
   break;
  case 0xf2:
   prefix_lock_repeat = PREFIX_LR_REPNZ;
   disas_opcode_one(lock);
   break;
  case 0xf3:
   prefix_lock_repeat = PREFIX_LR_REPZ;
   disas_opcode_one(lock);
   break;
  case 0xf4:

   break;
  case 0xf5:

   break;
  case 0xf6:
  case 0xf7:
   disas_group_3(opcode);
   break;


  default:
   ;
 }
}







int main(void) {
 prefix_lock_repeat = PREFIX_LR_NONE;
 prefix_segment_override = PREFIX_SO_NONE;
 prefix_operand_size_override = (0);
 prefix_address_size_override = (0);
 disas_opcode_one((0));
 return 0;
}
