// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file bitset_struct.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__BITSET_STRUCT_HPP
#define FAST_DDS_GENERATED__BITSET_STRUCT_HPP

#include <cstdint>
#include <utility>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(BITSET_STRUCT_SOURCE)
#define BITSET_STRUCT_DllAPI __declspec( dllexport )
#else
#define BITSET_STRUCT_DllAPI __declspec( dllimport )
#endif // BITSET_STRUCT_SOURCE
#else
#define BITSET_STRUCT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define BITSET_STRUCT_DllAPI
#endif // _WIN32

/*!
 * @brief This structure represents the bitset ColorBitset defined by the user in the IDL file.
 * @ingroup bitset_struct
 */
struct ColorBitset
{
        uint8_t red : 3;

        bool green : 1;

        uint8_t  : 4;

        uint16_t blue : 10;

        int16_t yellow : 12;


    /*!
     * @brief Comparison operator.
     * @param x ColorBitset object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ColorBitset& x) const
    {
        return (red == x.red &&
           green == x.green &&
           blue == x.blue &&
           yellow == x.yellow);
    }

    /*!
     * @brief Comparison operator.
     * @param x ColorBitset object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ColorBitset& x) const
    {
        return !(*this == x);
    }
};
/*!
 * @brief This class represents the structure BitsetStruct defined by the user in the IDL file.
 * @ingroup bitset_struct
 */
class BitsetStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BitsetStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BitsetStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BitsetStruct that will be copied.
     */
    eProsima_user_DllExport BitsetStruct(
            const BitsetStruct& x)
    {
                    m_my_bitset = x.m_my_bitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BitsetStruct that will be copied.
     */
    eProsima_user_DllExport BitsetStruct(
            BitsetStruct&& x) noexcept
    {
        m_my_bitset = std::move(x.m_my_bitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BitsetStruct that will be copied.
     */
    eProsima_user_DllExport BitsetStruct& operator =(
            const BitsetStruct& x)
    {

                    m_my_bitset = x.m_my_bitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BitsetStruct that will be copied.
     */
    eProsima_user_DllExport BitsetStruct& operator =(
            BitsetStruct&& x) noexcept
    {

        m_my_bitset = std::move(x.m_my_bitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BitsetStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BitsetStruct& x) const
    {
        return (m_my_bitset == x.m_my_bitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x BitsetStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BitsetStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member my_bitset
     * @param _my_bitset New value to be copied in member my_bitset
     */
    eProsima_user_DllExport void my_bitset(
            const ColorBitset& _my_bitset)
    {
        m_my_bitset = _my_bitset;
    }

    /*!
     * @brief This function moves the value in member my_bitset
     * @param _my_bitset New value to be moved in member my_bitset
     */
    eProsima_user_DllExport void my_bitset(
            ColorBitset&& _my_bitset)
    {
        m_my_bitset = std::move(_my_bitset);
    }

    /*!
     * @brief This function returns a constant reference to member my_bitset
     * @return Constant reference to member my_bitset
     */
    eProsima_user_DllExport const ColorBitset& my_bitset() const
    {
        return m_my_bitset;
    }

    /*!
     * @brief This function returns a reference to member my_bitset
     * @return Reference to member my_bitset
     */
    eProsima_user_DllExport ColorBitset& my_bitset()
    {
        return m_my_bitset;
    }



private:

    ColorBitset m_my_bitset{};

};

#endif // _FAST_DDS_GENERATED_BITSET_STRUCT_HPP_


