// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file TestIncludeRegression3361TypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "TestIncludeRegression3361TypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "TestIncludeRegression3361.hpp"


using namespace eprosima::fastdds::dds::xtypes;

namespace TestModule {
void register_MACHINEID_type_identifier(
        TypeIdentifierPair& type_ids_MACHINEID)
{
    ReturnCode_t return_code_MACHINEID {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MACHINEID =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "TestModule::MACHINEID", type_ids_MACHINEID);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MACHINEID)
    {
        AliasTypeFlag alias_flags_MACHINEID = 0;
        QualifiedTypeName type_name_MACHINEID = "TestModule::MACHINEID";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MACHINEID;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MACHINEID;
        CompleteTypeDetail detail_MACHINEID = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MACHINEID, ann_custom_MACHINEID, type_name_MACHINEID.to_string());
        CompleteAliasHeader header_MACHINEID = TypeObjectUtils::build_complete_alias_header(detail_MACHINEID);
        AliasMemberFlag related_flags_MACHINEID = 0;
        return_code_MACHINEID =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "anonymous_string_unbounded", type_ids_MACHINEID);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_MACHINEID)
        {
            {
                SBound bound = 0;
                StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                        TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                        "anonymous_string_unbounded", type_ids_MACHINEID))
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                }
            }
        }
        bool common_MACHINEID_ec {false};
        CommonAliasBody common_MACHINEID {TypeObjectUtils::build_common_alias_body(related_flags_MACHINEID,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MACHINEID, common_MACHINEID_ec))};
        if (!common_MACHINEID_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "TestModule::MACHINEID related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_MACHINEID;
        ann_custom_MACHINEID.reset();
        CompleteAliasBody body_MACHINEID = TypeObjectUtils::build_complete_alias_body(common_MACHINEID,
                member_ann_builtin_MACHINEID, ann_custom_MACHINEID);
        CompleteAliasType alias_type_MACHINEID = TypeObjectUtils::build_complete_alias_type(alias_flags_MACHINEID,
                header_MACHINEID, body_MACHINEID);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_MACHINEID,
                    type_name_MACHINEID.to_string(), type_ids_MACHINEID))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "TestModule::MACHINEID already registered in TypeObjectRegistry for a different type.");
        }
    }
}


} // namespace TestModule

