# coding=utf-8

from .. import BaseProvider


class Provider(BaseProvider):
    # Format: (code, name)
    currencies = (
        ("AED", "United Arab Emirates dirham"),
        ("AFN", "Afghan afghani"),
        ("ALL", "Albanian lek"),
        ("AMD", "Armenian dram"),
        ("ANG", "Netherlands Antillean guilder"),
        ("AOA", "Angolan kwanza"),
        ("ARS", "Argentine peso"),
        ("AUD", "Australian dollar"),
        ("AWG", "Aruban florin"),
        ("AZN", "Azerbaijani manat"),
        ("BAM", "Bosnia and Herzegovina convertible mark"),
        ("BBD", "Barbadian dollar"),
        ("BDT", "Bangladeshi taka"),
        ("BGN", "Bulgarian lev"),
        ("BHD", "Bahraini dinar"),
        ("BIF", "Burundian franc"),
        ("BMD", "Bermudian dollar"),
        ("BND", "Brunei dollar"),
        ("BOB", "Bolivian boliviano"),
        ("BRL", "Brazilian real"),
        ("BSD", "Bahamian dollar"),
        ("BTN", "Bhutanese ngultrum"),
        ("BWP", "Botswana pula"),
        ("BYR", "Belarusian ruble"),
        ("BZD", "Belize dollar"),
        ("CAD", "Canadian dollar"),
        ("CDF", "Congolese franc"),
        ("CHF", "Swiss franc"),
        ("CLP", "Chilean peso"),
        ("CNY", "Renminbi"),
        ("COP", "Colombian peso"),
        ("CRC", "Costa Rican colón"),
        ("CUC", "Cuban convertible peso"),
        ("CUP", "Cuban peso"),
        ("CVE", "Cape Verdean escudo"),
        ("CZK", "Czech koruna"),
        ("DJF", "Djiboutian franc"),
        ("DKK", "Danish krone"),
        ("DOP", "Dominican peso"),
        ("DZD", "Algerian dinar"),
        ("EGP", "Egyptian pound"),
        ("ERN", "Eritrean nakfa"),
        ("ETB", "Ethiopian birr"),
        ("EUR", "Euro"),
        ("FJD", "Fijian dollar"),
        ("FKP", "Falkland Islands pound"),
        ("GBP", "Pound sterling"),
        ("GEL", "Georgian lari"),
        ("GGP", "Guernsey pound"),
        ("GHS", "Ghanaian cedi"),
        ("GIP", "Gibraltar pound"),
        ("GMD", "Gambian dalasi"),
        ("GNF", "Guinean franc"),
        ("GTQ", "Guatemalan quetzal"),
        ("GYD", "Guyanese dollar"),
        ("HKD", "Hong Kong dollar"),
        ("HNL", "Honduran lempira"),
        ("HRK", "Croatian kuna"),
        ("HTG", "Haitian gourde"),
        ("HUF", "Hungarian forint"),
        ("IDR", "Indonesian rupiah"),
        ("ILS", "Israeli new shekel"),
        ("NIS", "Israeli new shekel"),
        ("IMP", "Manx pound"),
        ("INR", "Indian rupee"),
        ("IQD", "Iraqi dinar"),
        ("IRR", "Iranian rial"),
        ("ISK", "Icelandic króna"),
        ("JEP", "Jersey pound"),
        ("JMD", "Jamaican dollar"),
        ("JOD", "Jordanian dinar"),
        ("JPY", "Japanese yen"),
        ("KES", "Kenyan shilling"),
        ("KGS", "Kyrgyzstani som"),
        ("KHR", "Cambodian riel"),
        ("KMF", "Comorian franc"),
        ("KPW", "North Korean won"),
        ("KRW", "Western Krahn language"),
        ("KWD", "Kuwaiti dinar"),
        ("KYD", "Cayman Islands dollar"),
        ("KZT", "Kazakhstani tenge"),
        ("LAK", "Lao kip"),
        ("LBP", "Lebanese pound"),
        ("LKR", "Sri Lankan rupee"),
        ("LRD", "Liberian dollar"),
        ("LSL", "Lesotho loti"),
        ("LTL", "Lithuanian litas"),
        ("LYD", "Libyan dinar"),
        ("MAD", "Moroccan dirham"),
        ("MDL", "Moldovan leu"),
        ("MGA", "Malagasy ariar"),
        ("MKD", "Macedonian denar"),
        ("MMK", "Burmese kyat"),
        ("MNT", "Mongolian tugrik"),
        ("MOP", "Macanese pataca"),
        ("MRO", "Mauritanian ouguiya"),
        ("MUR", "Mauritian rupee"),
        ("MVR", "Maldivian rufiyaa"),
        ("MWK", "Malawian kwacha"),
        ("MXN", "Mexican peso"),
        ("MYR", "Malaysian ringgit"),
        ("MZN", "Mozambican metical"),
        ("NAD", "Namibian dollar"),
        ("NGN", "Nigerian naira"),
        ("NIO", "Nicaraguan córdoba"),
        ("NOK", "Norwegian krone"),
        ("NPR", "Nepalese rupee"),
        ("NZD", "New Zealand dollar"),
        ("OMR", "Omani rial"),
        ("PAB", "Panamanian balboa"),
        ("PEN", "Peruvian sol"),
        ("PGK", "Papua New Guinean kina"),
        ("PHP", "Philippine peso"),
        ("PKR", "Pakistani rupee"),
        ("PLN", "Polish zloty"),
        ("PYG", "Paraguayan guarani"),
        ("QAR", "Qatari riyal"),
        ("RON", "Romanian leu"),
        ("RSD", "Serbian dinar"),
        ("RUB", "Russian ruble"),
        ("RWF", "Rwandan franc"),
        ("SAR", "Saudi riyal"),
        ("SBD", "Solomon Islands dollar"),
        ("SCR", "Seychellois rupee"),
        ("SDG", "Sudanese pound"),
        ("SEK", "Swedish krona"),
        ("SGD", "Singapore dollar"),
        ("SHP", "Saint Helena pound"),
        ("SLL", "Sierra Leonean leone"),
        ("SOS", "Somali shilling"),
        ("SPL", "Seborga luigino"),
        ("SRD", "Surinamese dollar"),
        ("STD", "São Tomé and Príncipe dobra"),
        ("SVC", "Salvadoran colón"),
        ("SYP", "Syrian pound"),
        ("SZL", "Swazi lilangeni"),
        ("THB", "Thai baht"),
        ("TJS", "Tajikistani somoni"),
        ("TMT", "Turkmenistan manat"),
        ("TND", "Tunisian dinar"),
        ("TOP", "Tongan paʻanga"),
        ("TRY", "Turkish lira"),
        ("TTD", "Trinidad and Tobago dollar"),
        ("TVD", "Tuvaluan dollar"),
        ("TWD", "New Taiwan dollar"),
        ("TZS", "Tanzanian shilling"),
        ("UAH", "Ukrainian hryvnia"),
        ("UGX", "Ugandan shilling"),
        ("USD", "United States dollar"),
        ("UYU", "Uruguayan peso"),
        ("UZS", "Uzbekistani soʻm"),
        ("VEF", "Venezuelan bolívar"),
        ("VND", "Vietnamese đồng"),
        ("VUV", "Vanuatu vatu"),
        ("WST", "Samoan tālā"),
        ("XAF", "Central African CFA franc"),
        ("XCD", "Eastern Caribbean dollar"),
        ("XDR", "Special drawing rights"),
        ("XOF", "West African CFA franc"),
        ("XPF", "CFP franc"),
        ("YER", "Yemeni rial"),
        ("ZAR", "South African rand"),
        ("ZMW", "Zambian kwacha"),
        ("ZWD", "Zimbabwean dollar"),
    )

    # Source: https://en.wikipedia.org/wiki/List_of_cryptocurrencies
    cryptocurrencies = (
        ('AMP', "AMP"),
        ('AUR', "Auroracoin"),
        ('BC', "BlackCoin"),
        ('BTC', "Bitcoin"),
        ('BURST', "Burstcoin"),
        ('DASH', "Dash"),
        ('DOGE', "Dogecoin"),
        ('EMC', "Emercoin"),
        ('ETH', "Ethereum"),
        ('ETC', "Ethereum Classic"),
        ('GRC', "Gridcoin"),
        ('KOI', "Coinye"),
        ('LTC', "Litecoin"),
        ('MSC', "Omni"),
        ('MZC', "MazaCoin"),
        ('NMC', "Namecoin"),
        ('NXT', "Nxt"),
        ('POT', "PotCoin"),
        ('PPC', "Peercoin"),
        ('TIT', "Titcoin"),
        ('VTC', "Vertcoin"),
        ('XDN', "DigitalNote"),
        ('XMR', "Monero"),
        ('XPM', "Primecoin"),
        ('XRP', "Ripple"),
        ('ZEC', "Zcash"),
        ('STC', "SwiftCoin"),
        ('BCN', "Bytecoin"),
        ('FTH', "Feathercoin"),
        ('NEO', "NEO"),
        ('NEM', "XEM"),
        ('USDT', "Tether"),
        ('IOTA', "IOTA"),
        ('DRC', "Decred"),
        ('WAVES', "Waves Platform"),
        ('LSK', "Lisk"),
        ('ZCL', "Zclassic"),
        ('BCH', "Bitcoin Cash"),
        ('UBQ', "Ubiq"),
        ('EOS', "EOS.IO"),
        ('SRN', "Sirin Labs"),
        ('TRX', "TRON"),
        ('ADA', "Cardano"),
    )

    def currency(self):
        return self.random_element(self.currencies)

    def currency_code(self):
        return self.currency()[0]

    def currency_name(self):
        return self.currency()[1]

    def cryptocurrency(self):
        return self.random_element(self.cryptocurrencies)

    def cryptocurrency_code(self):
        return self.cryptocurrency()[0]

    def cryptocurrency_name(self):
        return self.cryptocurrency()[1]
