/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __BWALLINTERACTION_H
#define __BWALLINTERACTION_H

#include "Model/WallInteraction.h"
#include "Model/Wall.h"

/*!
  \class CBondedWallInteraction
  \brief bonded elastic interaction between a particle and a wall

  \author Steffen Abe
  $Revision$
  $Date$  
*/

template <class T>
class CBondedWallInteraction : public AWallInteraction<T>
{
protected:
  double m_k;//!< spring constant
public:
  //  CBondedWallInteraction();
  CBondedWallInteraction(T*,CWall*,double,bool);
  virtual ~CBondedWallInteraction(){};

  virtual void calcForces();
  virtual Vec3 getForce();
  virtual void setPP(const vector<T*>){};
  virtual double getStiffness(){return m_k;};
};

#include "BWallInteraction.hpp"

#endif //__BWALLINTERACTION_H
