#include "sys"
#include "ThreadsAndMutexes/mutextable/mutextable"
#include "ThreadsAndMutexes/mutex/mutex"

extern MutexTable mt;
extern Mutex cout_lock, cerr_lock;

void mutex_lock(void *o) {
    mt.lock(o);
}

void mutex_unlock(void *o) {
    mt.unlock(o);
}

bool mutex_lock_cout() {
    return cout_lock.trylock();
}
void mutex_unlock_cout() {
    cout_lock.unlock();
}
bool mutex_lock_cerr() {
    return cerr_lock.trylock();
}
void mutex_unlock_cerr() {
    cerr_lock.unlock();
}
