#include "httpbuffer"

string &Httpbuffer::firstline() {
    PROFILE("Httpbuffer::firstline");

    // Already determined? Re-return.
    if (first_line.size()) {
	debugmsg("Previously determined first buffer line: " << first_line <<
		 '\n');
	return first_line;
    }

    // Extract the first line
    for (unsigned i = 0; i < bufsz(); i++) {
	char ch = charat(i);
	if (ch == '\n' || ch == '\r')
	    break;
	first_line += ch;
    }

    // Buffer must start with a known HTTP label, else we're in a TCP 
    // transmission
    static string http_label[] = {
	// Request labels
	"OPTIONS ", "GET ", "HEAD ", "POST ", "PUT ", "DELETE ", "TRACE ",
	"CONNECT ",
	// Response labels
	"HTTP/",
	// Stopper
	""
    };

    bool is_label = false;
    for (unsigned int i = 0; http_label[i] != ""; i++)
	if (!strncmp(first_line.c_str(), http_label[i].c_str(),
		     http_label[i].length())) {
	    is_label = true;
	    break;
	}
    if (!is_label)
	first_line = "";

    debugmsg("First line determined as: [" << first_line << "]\n");
    return first_line;
}
