# CiviCRM 5.12.0

Released April 3, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**


## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Migrate KAM smartmenus to core
  ([13582](https://github.com/civicrm/civicrm-core/pull/13582),
  [240](https://github.com/civicrm/civicrm-packages/pull/240),
  [13612](https://github.com/civicrm/civicrm-core/pull/13612),
  [13729](https://github.com/civicrm/civicrm-core/pull/13729),
  [13820](https://github.com/civicrm/civicrm-core/pull/13820), and
  [13876](https://github.com/civicrm/civicrm-core/pull/13876))**

  The Keyboard Accessible Menus extension is now moved to core, replacing the
  CiviCRM navigation menu with a grey one provided by the SmartMenus jQuery
  plugin. The new menu is mobile-responsive and more accessible.

- **[dev/core#657](https://lab.civicrm.org/dev/core/issues/657) Add filter for
  country on Repeat Contributions Report
  ([13432](https://github.com/civicrm/civicrm-core/pull/13432))**

  This change adds a filter for Country to the Repeat Contributions Report.

- **[dev/core#690](https://lab.civicrm.org/dev/core/issues/690) Support more
  entities in Attachment API by short-circuiting permission check
  ([13529](https://github.com/civicrm/civicrm-core/pull/13529))**

  You can now use the Attachment API to update attachment custom fields on
  Memberships and several other entities.

- **[dev/core#561](https://lab.civicrm.org/dev/core/issues/561) Replace
  jcalendar instances with datepicker
  ([13704](https://github.com/civicrm/civicrm-core/pull/13704),
  [13701](https://github.com/civicrm/civicrm-core/pull/13701) and
  [13746](https://github.com/civicrm/civicrm-core/pull/13746)) Continued Work**

  These changes update the following places to use the datepicker instead of the
  jcalendar widget: the age field on the Advanced Search form in the
  Demographics section, the activity date time field on the find activites form,
  and the date field on the Change Case Type Form. Additionally on the Find
  Activities form these changes make it possible to pass the activity_date_time
  criteria in the url.

- **Add install and runtime status warnings if MySQL utf8mb4 is not supported
  ([13425](https://github.com/civicrm/civicrm-core/pull/13425) and
  [13682](https://github.com/civicrm/civicrm-core/pull/13682))**

  This change adds a warning to the system status page, as well as at install
  time, if a site's MySQL server does not support the utf8mb4 character set. See
  also [dev/core#749](https://lab.civicrm.org/dev/core/issues/749) for an
  intra-release regression related to this.

- **Record change log entry when contact is moved to or restored from trash
  ([13276](https://github.com/civicrm/civicrm-core/pull/13276))**

   This change makes it so that a change log entry is created when a contact is
   moved to the trash or restored from the trash.

- **Towards supporting EntityForm for 'View Action'
  ([13578](https://github.com/civicrm/civicrm-core/pull/13578))**

  This change enhances support for viewing entities in the abstracted
  "EntityForm" code.  This may be used in the future to standardize viewing and
  editing CiviCRM entities.

- **Standardize format for entityRef create links
  ([13628](https://github.com/civicrm/civicrm-core/pull/13628))**

  This change standardizes the creation links in entity reference fields so that
  they are pre-loaded for the client and so that they work equally well with all
  entities.

- **Add in Exception API to support the refactor of Dedupe Exception Page
  ([13611](https://github.com/civicrm/civicrm-core/pull/13611))**

  This change adds an API to create, get, and delete dedupe exceptions.

- **CRM.loadScript improvements
  ([13555](https://github.com/civicrm/civicrm-core/pull/13555))**

  This change makes it so that dynamically loaded scripts are not served from
  stale browser caches and allows angular apps to dynamically load scripts.

- **Make submitOnce() button js into a button parameter
  ([13333](https://github.com/civicrm/civicrm-core/pull/13333))**

  This change makes it so that developers can set a button as submit only once
  using the parameter `submitOnce = TRUE`.

- **[dev/core#562](https://lab.civicrm.org/dev/core/issues/562) Remove instances
  of $dao->free ([13560](https://github.com/civicrm/civicrm-core/pull/13560) and
  [13564](https://github.com/civicrm/civicrm-core/pull/13564)) Continued Work**

  These changes improve performance by removing instances of $dao->free.

- **Upgrade PHPWord
  ([13686](https://github.com/civicrm/civicrm-core/pull/13686))**

  CiviCRM now contains an updated version of the code library for generating
  Word documents.

### CiviContribute

- **Add pseudoconstant for payment_processor_id to contributionrecur
  ([13702](https://github.com/civicrm/civicrm-core/pull/13702)) Continued Work**

  This change alters the schema to add support for payment_processor_id as a
  pseudoconstant for recurring contributions.

- **[dev/core#767](https://lab.civicrm.org/dev/core/issues/767) Add 'Cancelled /
  Refunded Date' and 'Cancellation / Refund Reason' in the Detail Contributions
  Report ([13726](https://github.com/civicrm/civicrm-core/pull/13726))**

  This change adds the fields and filters 'Cancelled / Refunded Date' and
  'Cancellation / Refund Reason' to the Contribution Detail report.

- **[dev/report#8](https://lab.civicrm.org/dev/report/issues/8) Contribution
  reports don't include thank-you date
  ([13653](https://github.com/civicrm/civicrm-core/pull/13653))**

  This change adds the "thank you date" field to the Contribution Summary and
  Detail reports.

- **[dev/core#735](https://lab.civicrm.org/dev/core/issues/735) Query
  performance - suppress 'product' and related fields where products are not in
  the database ([13638](https://github.com/civicrm/civicrm-core/pull/13638))**

  This change removes the "Premium" column from the Contribution tab for sites
  that do not use products and improves performance on those sites by not
  searching for product related fields.

- **Speed up contribution results by removing join on civicrm_financial_type
  table when rendering search results.
  ([13720](https://github.com/civicrm/civicrm-core/pull/13720))**

  This change improves performance when searching contributions.

- **Allow viewing of cancelled recurring contributions
  ([13745](https://github.com/civicrm/civicrm-core/pull/13745))**

  It is now possible to view canceled recurring contributions through the user
  interface.

- **Add new Payment.sendconfirmation api
  ([13610](https://github.com/civicrm/civicrm-core/pull/13610),
  [13561](https://github.com/civicrm/civicrm-core/pull/13561) and
  [13609](https://github.com/civicrm/civicrm-core/pull/13609))**

  A new Payment.sendconfirmation API method is available for generating payment
  confirmation emails.

- **Switch additional payment form to use Payment.sendconfirmation api
  ([13649](https://github.com/civicrm/civicrm-core/pull/13649))**

  The additional payment form now generates confirmation emails using the new
  Payment.sendconfirmation API.

- **Payment notification formatting, move greeting into table
  ([13669](https://github.com/civicrm/civicrm-core/pull/13669))**

  The greeting in the payment notification email is now aligned with the table
  of payment information.

- **Update Payment Notification to use greeting, remove text to 'Please print
  this confirmation for your records.
  ([13655](https://github.com/civicrm/civicrm-core/pull/13655))**

  The Payment Notification email no longer asks recipients to "Please print this
  confirmation for your records."  It also is updated to use the email_greeting
  instead of the display_name for the greeting.

- **Contribution/ContributionRecur metadata updates for EntityForm
  ([13579](https://github.com/civicrm/civicrm-core/pull/13579))**

  These changes update the metadata for Contribution and ContributionRecur so
  that they can be used to autogenerate forms with EntityForm.

### CiviMember

- **CiviCRM Membership Detail report, add column to display if membership is
  Primary or Inherited
  ([13736](https://github.com/civicrm/civicrm-core/pull/13736))**

  This change adds a column "Primary/Inherited?" to the Membership Detail
  report.

### Drupal Integration

- **Make address Supplemental line 3 available to views
  ([551](https://github.com/civicrm/civicrm-drupal/pull/551))**

  This change makes it so that one can use the address field "Supplemental
  Address 3" in a view.

### Joomla Integration

- **Improves styling on Joomla! upgrade screen
  ([13557](https://github.com/civicrm/civicrm-core/pull/13557))**

  This change improves the styling of the Joomla upgrade screen.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[dev/core#842](https://lab.civicrm.org/dev/core/issues/842) Regression??
  Inline editing of website field deletes it
  ([13939](https://github.com/civicrm/civicrm-core/pull/13939))**

  This resolves a bug where editing a website field inline on the contact
  summary tab sometimes would delete the field entirely.

- **[dev/core#190](https://lab.civicrm.org/dev/core/issues/190) custom data with
  multiple records profile: after submission, profile view shows first record
  instead of most recent
  ([12337](https://github.com/civicrm/civicrm-core/pull/12337))**

  When submitting a profile with files that allow multiple records, the most
  recently created record is now retrieved on the confirmation page.  Before
  this change, the first record was retrieved.

- **Fix (sometimes serious) performance problem on submitting profiles for
  specified contacts
  ([13606](https://github.com/civicrm/civicrm-core/pull/13606))**

- **[dev/core#748](https://lab.civicrm.org/dev/core/issues/748) Deadlocks and
  performance issues when using smartgroups / ACLs extensively
  ([13732](https://github.com/civicrm/civicrm-core/pull/13732))**

  This change improves performance of many queries by no longer using the
  `UPPER()` and `LOWER()` MySQL functions.

- **[dev/core#397](https://lab.civicrm.org/dev/core/issues/397) Dedupe for
  Individual Birth Date Results in Error
  ([13538](https://github.com/civicrm/civicrm-core/pull/13538))**

  This change fixes a fatal error when using a dedupe rule with the birth date
  field.

- **[dev/core#821](https://lab.civicrm.org/dev/core/issues/821) Activity:
  Assigned to: It is not possible to search by the "refine search" drop-down
  ([13893](https://github.com/civicrm/civicrm-core/pull/13893))**

  When setting an activity assignee, a bug prevented using the filters in the
  contact reference field.

- **[dev/core#580](https://lab.civicrm.org/dev/core/issues/580) No groups
  displayed on Manage Groups when "All Groups" is selected
  ([13373](https://github.com/civicrm/civicrm-core/pull/13373))**

  This resolves a bug where if a user had an ACL that gave them permission to
  Edit "All Groups" but did not have the permission "View All Contacts", on the
  "Manage Groups" screen no groups would appear.

- **[dev/core#642](https://lab.civicrm.org/dev/core/issues/642) New Contact
  Report: New report isn't created automatically when the user selects the
  "Create Report" action
  ([13404](https://github.com/civicrm/civicrm-core/pull/13404))**

  This resolves a Javascript error when attempting to create a new report from
  the Constituent Report (Summary) template.

- **[dev/core#683](https://lab.civicrm.org/dev/core/issues/683) Incorrectly
  encoded state and country names
  ([13591](https://github.com/civicrm/civicrm-core/pull/13591))**

  This change ensures that when countries and state/provinces are added they use
  proper character encoding.

- **[dev/core#691](https://lab.civicrm.org/dev/core/issues/691) It is no longer
  possible to have the default country not set
  ([13523](https://github.com/civicrm/civicrm-core/pull/13523))**

  This change makes the default country field on the settings form optional,
  before this change it was required.

- **[dev/core#700](https://lab.civicrm.org/dev/core/issues/700) Advanced Search:
  The reason of failed search result is not displayed, when a contact with the
  matching Contact ID was not found
  ([13549](https://github.com/civicrm/civicrm-core/pull/13549))**

  When using the Advanced Search form to search by contact ID, this change
  ensures that if there is no matching contact the message states the search
  criteria.

- **[dev/core#708](https://lab.civicrm.org/dev/core/issues/708) Advanced Search:
  The "Modified By" option was set instead of "Added by"
  ([13566](https://github.com/civicrm/civicrm-core/pull/13566))**

  In Advanced Search, the listing of search criteria for searches yielding no
  results would display "modified by" when "added by" was a criterion.

- **[dev/core#705](https://lab.civicrm.org/dev/core/issues/705) Disabling
  Alphabetical Pager is not respected for events and contribution pages.
  ([13592](https://github.com/civicrm/civicrm-core/pull/13592))**

- **[dev/core#714](https://lab.civicrm.org/dev/core/issues/714) Manage groups:
  Error: "API permission check failed for Group/create call; insufficient
  permission" when the user tries to edit some group's details
  ([13573](https://github.com/civicrm/civicrm-core/pull/13573))**

  On the Manage Groups form, if a user does not have permissions to edit a
  group, the edit link is disabled.

- **[dev/core#742](https://lab.civicrm.org/dev/core/issues/742) Repeated
  warning: "simplexml_load_file(): I/O warning : failed to load external entity
  ".../xml/Menu/Activity.xml"
  ([13654](https://github.com/civicrm/civicrm-core/pull/13654))**

  This change fixes warnings regarding failing to parse the XML file when
  clearing the CiviCRM caches.

- **[dev/report#11](https://lab.civicrm.org/dev/report/issues/11) Soft Credit
  report fails when Only Full Group By is enabled
  ([13671](https://github.com/civicrm/civicrm-core/pull/13671))**

- **Remove mcrypt system status check
  ([13770](https://github.com/civicrm/civicrm-core/pull/13770))**

  PHP 7.2 does not support mcrypt, which is being deprecated.  This removes the
  status check that would notify administrators if mcrypt is not installed.

- **Fix api bug whereby 0 & '0' are not accepted as range parameters for BETWEEN
  ([13766](https://github.com/civicrm/civicrm-core/pull/13766))**

- **Render Note field tokens correctly - they are already HTML.
  ([13283](https://github.com/civicrm/civicrm-core/pull/13283))**

- **Rationalise Activity api ACLs for consistency, to respect the hook & improve
  performance ([13664](https://github.com/civicrm/civicrm-core/pull/13664))**

  This change alters the way permissions are handled on sites that use ACLs when
  the activity.get api is called with the 'check_permissions' flag set to TRUE.
  This would usually be the case for Javascript calls.

- **Upgrader: Don't abort if state_province already exists
  ([13744](https://github.com/civicrm/civicrm-core/pull/13744))**

  This change fixes a fatal error when upgrading from 4.7.30 and 4.7.32 if
  state_province values already exists so that sites with state_province values
  can safely upgrade from 4.7.30 t0 4.7.32.

- **Do not attempt to store out-of-range street number
  ([13340](https://github.com/civicrm/civicrm-core/pull/13340))**

  Before this change attempting to geocode an address with a long street number
  would result in a fatal error "DB Error Out of range value for column
  'street_number'".  This change aborts parsing for addresses with long street
  numbers.

- **geocode job: Do not return more messages than can fit in the log data column
  ([13346](https://github.com/civicrm/civicrm-core/pull/13346))**

  This change fixes an error: "DB Error: Data too long for column 'data' at row
  1" when running the geocoder job on a site with over 500 unparseable
  addresses. This error was being thrown because the message in the job log was
  too big to be saved, and this change makes it so that the message is shortened to
  fit in the database.

- **only set custom field to null if it is really null, not string 'null'
  ([13042](https://github.com/civicrm/civicrm-core/pull/13042))**

  Custom fields saved with `NULL`, `Null`, or any value other than `null` will
  be saved as-is.  A value of `null`, however, still saves a null value.

- **CRM/Logging - Fix various bugs in schema parsing
  ([13441](https://github.com/civicrm/civicrm-core/pull/13441))**

  This change improves logging so that logs return constraints as well as
  indexes (before this change indexes were not returned), and returns column
  lengths without surrounding parenthesis and returns arrays using ['index1',
  'index2'] syntax instead of [0 => ['constraint_name' => 'foo']] syntax.

- **CRM/Logging - Fix log table exceptions
  ([13675](https://github.com/civicrm/civicrm-core/pull/13675))**

  This change ensures that log table exceptions are applied for columns
  regardless of whether or not they have backticks.

- **Fix html2pdf default PDF format when multiple pdf_format are available.
  ([13543](https://github.com/civicrm/civicrm-core/pull/13543))**

  This change ensures that the correct default PDF format is selected when
  multiple pdf format options are available.

- **Always load recaptcha JS over HTTPS
  ([13601](https://github.com/civicrm/civicrm-core/pull/13601))**

  This change ensures that reCAPTCHA is loaded regardless of whether the site is
  being served over HTTP or HTTPS.

- **If a profile is used to create a contact with a subtype the contact will not
  have any existing subtypes
  ([13499](https://github.com/civicrm/civicrm-core/pull/13499))**

  This change fixes PHP notices being thrown when creating a contact with a
  subtype via a profile.

- **Remove activitystatus js. Add submitOnce handler for activity create
  ([13342](https://github.com/civicrm/civicrm-core/pull/13342))**

  This change makes it so users can only click "save" once when creating an
  activity to prevent users from accidentally creating multiple activities by
  clicking save multiple times.

- **Fix contact ID help on advanced search
  ([13569](https://github.com/civicrm/civicrm-core/pull/13569))**

  This change ensures the help text appears when one clicks the help icon next
  to Contact ID on the Advanced Search form.

- **Used buildoptions function to get all groups
  ([13327](https://github.com/civicrm/civicrm-core/pull/13327))**

  This change fixes a "DB Error: no such field" message when using the Contact
  API to get contacts from a group where the group name and group title are
  different so that no error is thrown.

### CiviCase

- **[dev/core#684](https://lab.civicrm.org/dev/core/issues/684) Case Manager not
  updating correctly (CiviCRM 5.8.2)
  ([13528](https://github.com/civicrm/civicrm-core/pull/13528))**

  This change ensures that if the Case Manager is changed on the Manage Case
  screen the "(Case Manager)" tag appears correctly.

- **[dev/core#739](https://lab.civicrm.org/dev/core/issues/739) Field not found
  when sorting report by Case Type as a section header
  ([13666](https://github.com/civicrm/civicrm-core/pull/13666))**

  This change fixes the "Unknown column 'case_civireport.case_type_name' in
  'field list'" error thrown on a Case Detail report sorted by the field Case
  Type with the option "Section Header" checked.

- **[dev/core#770](https://lab.civicrm.org/dev/core/issues/770) View Case
  Activity page displays disabled custom fields
  ([13741](https://github.com/civicrm/civicrm-core/pull/13741))**

### CiviContribute

- **[dev/core#644](https://lab.civicrm.org/dev/core/issues/644) "From" address
  on membership renewal notices is wrong
  ([13776](https://github.com/civicrm/civicrm-core/pull/13776))**

  In some configurations, contribution receipts would be sent with a contact ID
  as the "From" address rather than an actual address.

- **[dev/core#659](https://lab.civicrm.org/dev/core/issues/659) Civi returning
  500 errors to Paypal Pro request to civicrm/extern/ipn.php
  ([13796](https://github.com/civicrm/civicrm-core/pull/13796))**

  When CiviCRM encounters an error in processing an instant payment
  notification, it no longer returns HTTP status of 500.  PayPal would disable
  IPN after too many 500 errors, assuming the site is broken.

- **[dev/core#716](https://lab.civicrm.org/dev/core/issues/716) Add decimals in
  Contribution Amount on Repeat Contributions Report
  ([13659](https://github.com/civicrm/civicrm-core/pull/13659))**

  This change ensures that the Repeat Contributions Report does not truncate the
  decimals of contributions.

- **[dev/core#801](https://lab.civicrm.org/dev/core/issues/801) Thank You
  letters have an invalid 'from' when sending from the contact's email address
  ([13825](https://github.com/civicrm/civicrm-core/pull/13825))**

- **[dev/core#720](https://lab.civicrm.org/dev/core/issues/720) Performance
  change approved - remove mode & median slow queries
  ([13607](https://github.com/civicrm/civicrm-core/pull/13607),
  [13630](https://github.com/civicrm/civicrm-core/pull/13630) and
  [13605](https://github.com/civicrm/civicrm-core/pull/13605))**

  This change removes the mode and median stats on the contribution search
  summary and contribution tab on contacts to improve performance.

- **Remove another instance of 'lower'
  ([13636](https://github.com/civicrm/civicrm-core/pull/13636))**

  This change improves performance when searching notes fields on a
  contribution.

- **[dev/core#769](https://lab.civicrm.org/dev/core/issues/769) ZIP Archive for
  multiple batch exports fail
  ([13728](https://github.com/civicrm/civicrm-core/pull/13728))**

  This change fixes ZIP Archives for multiple batch exports for instances with
  any PHP version greater than 5.6.

- **[dev/report#7](https://lab.civicrm.org/dev/report/issues/7) Transaction Date
  filter in Bookkeeping Transactions report
  ([13571](https://github.com/civicrm/civicrm-core/pull/13571))**

  This change ensures that the trxn_date field on the Bookkeeping Report filter
  respects the times designated in the filter.  Before this change it would only
  return transactions that occurred at midnight.

- **[dev/core#812](https://lab.civicrm.org/dev/core/issues/812) Contribution row
  displayed even if contact has 0 contributions.
  ([13881](https://github.com/civicrm/civicrm-core/pull/13881))**

- **Status of test contribution is not fetched on ThankYou page.
  ([13724](https://github.com/civicrm/civicrm-core/pull/13724))**

  This change ensures that on a Contribution page with a payment processor that
  captures payment instantly and does not use the confirmation page, the
  confirmation message on the Thank You page states the status of the
  transaction instead of "Your contribution has been submitted...".

- **Move assign of currency for entityForm outside of foreach so order of fields
  don't matter ([13696](https://github.com/civicrm/civicrm-core/pull/13696))**

  This change ensures assign currency works regardless of whether currency is
  before or after the money fields.

- **Find Contributions columns/headers not aligned when "Contributions OR Soft
  Credits?" filter set to "Soft Credits Only"
  ([13517](https://github.com/civicrm/civicrm-core/pull/13517))**

  This change ensures that when running a Find Contributions search with the
  "Contributions OR Soft Credits?" filter set to "Soft Credits Only" the headers
  line up with the correct columns.

### CiviEvent

- **[dev/core#696](https://lab.civicrm.org/dev/core/issues/696) Changes to
  copied event phone and email reflects in original event phone and email
  ([13534](https://github.com/civicrm/civicrm-core/pull/13534))**

  This change fixes a bug where if a user copied an event and then edited the
  email and or phone number on the copy, the changes would be applied to the
  original event.

- **Fix Custom post outer div class on event registration form
  ([13753](https://github.com/civicrm/civicrm-core/pull/13753))**

  This change updates the class applied to the outer div around a custom profile
  in the post section of the form to use 1 custom_pre-section and 1
  custom_post-section instead of two custom_pre-sections.

- **Fix the invocation of post hook for ParticipantPayment ensuring that an id
  is passed in post hook
  ([13739](https://github.com/civicrm/civicrm-core/pull/13739))**

### CiviMail

- **[dev/core#469](https://lab.civicrm.org/dev/core/issues/469) Error on action
  "Email - schedule/send via CiviMail" with multiple event names filter
  ([13539](https://github.com/civicrm/civicrm-core/pull/13539))**

- **CiviMail: Fix reply forwarding for mailers with From: and Return-path:
  limitations ([12641](https://github.com/civicrm/civicrm-core/pull/12641))**

- **"Only variable references should be returned by reference" notice in
  Mail_smtp ([220](https://github.com/civicrm/civicrm-packages/pull/220))**

  This change fixes a "Only variable references should be returned by reference"
  PHP notice under various SMTP error conditions.

### CiviMember

- **[dev/core#631](https://lab.civicrm.org/dev/core/issues/631) Problem when
  merging contacts which have membership records
  ([13588](https://github.com/civicrm/civicrm-core/pull/13588))**

  When merging contacts with memberships, the default is now that the "add new"
  box is checked.  This brings memberships over from the left-hand contact
  without attempting to merge memberships.  Merging memberships from the contact
  merge interface can result in data loss.

### Drupal Integration

- **fix broken logic in CRM_Utils_System_DrupalBase::formatResourceUrl()
  ([13400](https://github.com/civicrm/civicrm-core/pull/13400))**

  This change fixes a bug where Drupal sites were not processing absolute URLs
  containing the $base_url passed in from extensions (like Shoreditch)
  correctly.

- **[dev/core#381](https://lab.civicrm.org/dev/core/issues/381)
  civicrm/file/imagefile serving up wrong images
  ([564](https://github.com/civicrm/civicrm-drupal/pull/564)) Extends work**

  This change fixes a problem with the Views file field handler displaying
  incorrect uploaded images.

### Wordpress Integration

- **[dev/wordpress#18](https://lab.civicrm.org/dev/wordpress/issues/18) wp-cli
  sometimes fails to find cms path
  ([147](https://github.com/civicrm/civicrm-wordpress/pull/147))**

  This change ensures that the path specified to wp-cli as `--path` is passed to
  CiviCRM which fixes some URL errors specifically but not limited to when
  sending bulk mailings with trackable URLs.

## <a name="misc"></a>Miscellany

- **Upgrade Karma version to latest version
  ([13751](https://github.com/civicrm/civicrm-core/pull/13751))**

- **[infra/ops#878](https://lab.civicrm.org/infra/ops/issues/878) Add a test
  matrix for E2E tests on each CMS
  ([13808](https://github.com/civicrm/civicrm-core/pull/13808))**

  This change improves reliability by increasing test coverage.

- **Try and add data set example where email_on_hold / on_hold is NULL in the
  formValues ([13765](https://github.com/civicrm/civicrm-core/pull/13765))**

  This change adds test coverage for certain smart group criteria.

- **[dev/core#746](https://lab.civicrm.org/dev/core/issues/746) Search Builder
  searches using > 1 smart group where operator is equals is broken from 5.10.0
  ([13685](https://github.com/civicrm/civicrm-core/pull/13685)) Continued work**

  This change adds test coverage for Search Builder searches using > 1 smart
  group.

- **[dev/report#10](https://lab.civicrm.org/dev/report/issues/10) No pagination
  on Contribution Detail report
  ([13678](https://github.com/civicrm/civicrm-core/pull/13678)) Continued Work**

  This change adds a unit test for pagination on the Contribution Detail report.

- **Optimize CRM_Core_BAO_FinancialTrxn::getTotalPayment
  ([13187](https://github.com/civicrm/civicrm-core/pull/13187))**

- **Bump minimum upgradable ver to 4.2.9
  ([13580](https://github.com/civicrm/civicrm-core/pull/13580))**

- **Use CRM_Utils_SQL_TempTable to drop and create table.
  ([13688](https://github.com/civicrm/civicrm-core/pull/13688))**

- **Clean up Payment.create function
  ([13690](https://github.com/civicrm/civicrm-core/pull/13690))**

- **[dev/report#9](https://lab.civicrm.org/dev/report/issues/9) Deprecate
  `getBasicContactFields` in favor of `getColumns('Contact')`
  ([13657](https://github.com/civicrm/civicrm-core/pull/13657))**

- **Extract getSearchSQLParts function
  ([13735](https://github.com/civicrm/civicrm-core/pull/13735))**

- **[Test changes] Mailing job test use
  ([13629](https://github.com/civicrm/civicrm-core/pull/13629))**

- **Code cleanup - remove extraneous permissions clause
  ([13645](https://github.com/civicrm/civicrm-core/pull/13645))**

- **Fix typo in comments
  ([13771](https://github.com/civicrm/civicrm-core/pull/13771))**

- **Removes redundant IF
  ([13769](https://github.com/civicrm/civicrm-core/pull/13769))**

- **(NFC) formatting changes
  ([148](https://github.com/civicrm/civicrm-wordpress/pull/148))**

- **report clean up - remove redundant code
  ([13761](https://github.com/civicrm/civicrm-core/pull/13761))**

- **Fix typo and space
  ([13577](https://github.com/civicrm/civicrm-core/pull/13577))**

- **[minor cleanup] reduce params passed to searchQuery
  ([13715](https://github.com/civicrm/civicrm-core/pull/13715))**

- **[TEST FIX] Increase uniqueness in testSingleNowDates
  ([13705](https://github.com/civicrm/civicrm-core/pull/13705))**

- **Revert "[REF] Extract record refund function"
  ([13693](https://github.com/civicrm/civicrm-core/pull/13693))**

- **Minor code cleanup
  ([13687](https://github.com/civicrm/civicrm-core/pull/13687))**

- **[NFC, test class] formatting, remove unused variables
  ([13634](https://github.com/civicrm/civicrm-core/pull/13634))**

- **Authorizenet test - reduce chance of intermittent fails
  ([13642](https://github.com/civicrm/civicrm-core/pull/13642))**

- **[unused code cleanup] Remove unused 'signupType' url support
  ([13620](https://github.com/civicrm/civicrm-core/pull/13620))**

- **[Test support] Add extra output info when getsingle fails as this seems to
  be common  in intermittant fails
  ([13618](https://github.com/civicrm/civicrm-core/pull/13618))**

- **Remove tests that no longer work due to dead service
  ([13617](https://github.com/civicrm/civicrm-core/pull/13617))**

- **Refactor CRM_Utils_SQL_TempTable::build()->createWithQuery($sql) interface
  to support MEMORY tabls
  ([13644](https://github.com/civicrm/civicrm-core/pull/13644))**

- **REF Convert deprecated functions to buildOptions for case
  ([13364](https://github.com/civicrm/civicrm-core/pull/13364))**

- **[REF] Extract record refund function
  ([13691](https://github.com/civicrm/civicrm-core/pull/13691))**

- **[REF] Extract getSearchSQL from getSearchQuery.
  ([13668](https://github.com/civicrm/civicrm-core/pull/13668))**

- **[REF] minor code cleanup - do not build order var just to hurt brains
  ([13650](https://github.com/civicrm/civicrm-core/pull/13650))**

- **[REF] minor cleanup of groupBy definition.
  ([13656](https://github.com/civicrm/civicrm-core/pull/13656))**

- **[REF] extract add median to stats
  ([13616](https://github.com/civicrm/civicrm-core/pull/13616))**

- **[REF] extract cancelled stats to own function
  ([13626](https://github.com/civicrm/civicrm-core/pull/13626))**

- **[REF] Move entityRef filters into their respective BAOs
  ([13625](https://github.com/civicrm/civicrm-core/pull/13625))**

- **[REF] extract basic soft credit stats to separate function
  ([13622](https://github.com/civicrm/civicrm-core/pull/13622))**

- **[REF] Remove unused function parameter
  ([13619](https://github.com/civicrm/civicrm-core/pull/13619))**

- **[REF] Extract lines to add the pseudoconstant to the select
  ([13717](https://github.com/civicrm/civicrm-core/pull/13717))**

- **[REF] extract calculation of mode stat
  ([13614](https://github.com/civicrm/civicrm-core/pull/13614))**

- **[REF] extract calculation of basic stats
  ([13608](https://github.com/civicrm/civicrm-core/pull/13608))**

- **[REF] Move addSelectWhere-like function to be located on BAO_Contribution
  ([13587](https://github.com/civicrm/civicrm-core/pull/13587))**

- **[REF] Fix silly function to do less handling of non-existent scenarios
  ([13563](https://github.com/civicrm/civicrm-core/pull/13563))**

- **[REF] extract chunk of code to a separate function
  ([13600](https://github.com/civicrm/civicrm-core/pull/13600))**

- **[REF] Use api rather than selector for rendering contributions on user
  dashboard ([13584](https://github.com/civicrm/civicrm-core/pull/13584) and
  [13903](https://github.com/civicrm/civicrm-core/pull/13903))**

- **[REF] switch from (undeclared) class property to local variable.
  ([13583](https://github.com/civicrm/civicrm-core/pull/13583))**

- **[REF] Minor readability cleanup
  ([13562](https://github.com/civicrm/civicrm-core/pull/13562))**

- **[REF] Remove useless class CRM_Report_Form_Event
  ([13632](https://github.com/civicrm/civicrm-core/pull/13632))**

- **[REF] extract getToFinancialAccount from
  CRM_Contribute_PseudoConstantt::contributionStatus
  ([13757](https://github.com/civicrm/civicrm-core/pull/13757))**

- **[ref] Extract activity payment creation
  ([13695](https://github.com/civicrm/civicrm-core/pull/13695))**

- **[REF] separate financial handling & component transitioning in
  Payment.create ([13756](https://github.com/civicrm/civicrm-core/pull/13756))**

- **[REF] towards cleanup of update membership code
  ([13759](https://github.com/civicrm/civicrm-core/pull/13759))**

- **(REF) Rename variables and adjust variable definitions for Event Register
  form ([13287](https://github.com/civicrm/civicrm-core/pull/13287))**

- **[REF] Extract recordPayment portion
  ([13692](https://github.com/civicrm/civicrm-core/pull/13692))**

- **[REF] minor refactor around retrieving processor id for recur
  ([13643](https://github.com/civicrm/civicrm-core/pull/13643))**

- **[code cleanup] Default wrong declared
  ([13621](https://github.com/civicrm/civicrm-core/pull/13621))**

- **[Code cleanup] Remove unused $stationery_path parameter
  ([13624](https://github.com/civicrm/civicrm-core/pull/13624))**

- **Remove long block of commented out code from 4 years ago
  ([13623](https://github.com/civicrm/civicrm-core/pull/13623))**

- **Add unit test on getContributionBalance fn (#13187)
  ([13558](https://github.com/civicrm/civicrm-core/pull/13558))**

- **Phase out CIVICRM_TEMP_FORCE_UTF8
  ([13658](https://github.com/civicrm/civicrm-core/pull/13658))**

- **Extract record refund function
  ([13694](https://github.com/civicrm/civicrm-core/pull/13694))**

- **Move pear/mail from packages to composer.json
  ([13289](https://github.com/civicrm/civicrm-core/pull/13289))**

- **Decommision getPartialPaymentTrxn function
  ([13718](https://github.com/civicrm/civicrm-core/pull/13718))**

- **Fix & test searchQuery order by to be less dependent on what is selected for
  search ([13680](https://github.com/civicrm/civicrm-core/pull/13680))**

- **EntityRef - Standardize on PascalCase for entity name and fix minor bug
  ([13631](https://github.com/civicrm/civicrm-core/pull/13631))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Agileware - Alok Patel; Alexy
Mikhailichenko; Australian Greens - Seamus Lee; avall-llovera; CiviCRM - Coleman
Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy;
Electronic Frontier Foundation - Mark Burdett; Francesc Bassas i Bullich; Fuzion -
Jitendra Purohit; GreenPeace Central and Eastern Europe - Patrick Figel; JMA
Consulting - Edsel Lopez, Monish Deb; Ken West; Lighthouse Design and Consulting -
Brian Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; MJW
Consulting - Matthew Wire; Nicol Wistreich; Pradeep Nayak; Skvare - Mark Hanna;
Squiffle Consulting - Aidan Saunders; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Circle Interactive - Dave Jenkins, Reece Benson;
CiviDesk - Sunil Pawar; Dave D; Fuzion - Peter Davis; JMA Consulting - Joe
Murray; Luna Design - Andrew Wasson; Mark Westergaard; MJCO - Mikey O'Toole;
Progressive Technology Project - Jamie McClelland; Richard van Oosterhout;
Tadpole Collective - Kevin Cristiano; Third Sector Design - Michael McAndrew

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
