{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetMapping: String;
    procedure SetMapping(const Value: String);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdMapping: TSFString;
    { X3D field "mapping". } { }
    public property FdMapping: TSFString read FFdMapping;
    { X3D field "mapping". } { }
    property Mapping: String read GetMapping write SetMapping;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractSingleTextureCoordinateNode ----------------------------------------------- }

function TAbstractSingleTextureCoordinateNode.GetMapping: String;
begin
  Result := FdMapping.Value;
end;

procedure TAbstractSingleTextureCoordinateNode.SetMapping(const Value: String);
begin
  FdMapping.Send(Value);
end;

class function TAbstractSingleTextureCoordinateNode.ClassX3DType: String;
begin
  Result := 'X3DSingleTextureCoordinateNode';
end;

procedure TAbstractSingleTextureCoordinateNode.CreateNode;
begin
  inherited;

  FFdMapping := TSFString.Create(Self, True, 'mapping', '');
   FdMapping.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMapping);
end;

{$endif read_implementation}
