{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetGustiness: Single;
    procedure SetGustiness(const Value: Single);
    function GetSpeed: Single;
    procedure SetSpeed(const Value: Single);
    function GetTurbulence: Single;
    procedure SetTurbulence(const Value: Single);
  public
    { X3D field "direction". } { }
    property Direction: TVector3 read GetDirection write SetDirection;
    { X3D field "gustiness". } { }
    property Gustiness: Single read GetGustiness write SetGustiness;
    { X3D field "speed". } { }
    property Speed: Single read GetSpeed write SetSpeed;
    { X3D field "turbulence". } { }
    property Turbulence: Single read GetTurbulence write SetTurbulence;

{$endif read_interface}

{$ifdef read_implementation}

{ TWindPhysicsModelNode ----------------------------------------------- }

function TWindPhysicsModelNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TWindPhysicsModelNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

function TWindPhysicsModelNode.GetGustiness: Single;
begin
  Result := FdGustiness.Value;
end;

procedure TWindPhysicsModelNode.SetGustiness(const Value: Single);
begin
  FdGustiness.Send(Value);
end;

function TWindPhysicsModelNode.GetSpeed: Single;
begin
  Result := FdSpeed.Value;
end;

procedure TWindPhysicsModelNode.SetSpeed(const Value: Single);
begin
  FdSpeed.Send(Value);
end;

function TWindPhysicsModelNode.GetTurbulence: Single;
begin
  Result := FdTurbulence.Value;
end;

procedure TWindPhysicsModelNode.SetTurbulence(const Value: Single);
begin
  FdTurbulence.Send(Value);
end;

{$endif read_implementation}
