{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAnisotropicDegree: Single;
    procedure SetAnisotropicDegree(const Value: Single);
    function GetBorderColor: TCastleColor;
    procedure SetBorderColor(const Value: TCastleColor);
    function GetBorderWidth: Integer;
    procedure SetBorderWidth(const Value: Integer);
    function GetBoundaryModeS: String;
    procedure SetBoundaryModeS(const Value: String);
    function GetBoundaryModeT: String;
    procedure SetBoundaryModeT(const Value: String);
    function GetBoundaryModeR: String;
    procedure SetBoundaryModeR(const Value: String);
    function GetTextureCompression: String;
    procedure SetTextureCompression(const Value: String);
    function GetTexturePriority: Single;
    procedure SetTexturePriority(const Value: Single);
    function GetGenerateMipMaps: Boolean;
    procedure SetGenerateMipMaps(const Value: Boolean);
    function GetGuiTexture: Boolean;
    procedure SetGuiTexture(const Value: Boolean);
  public
    { X3D field "anisotropicDegree". } { }
    property AnisotropicDegree: Single read GetAnisotropicDegree write SetAnisotropicDegree;
    { X3D field "borderColor". } { }
    property BorderColor: TCastleColor read GetBorderColor write SetBorderColor;
    { X3D field "borderWidth". } { }
    property BorderWidth: Integer read GetBorderWidth write SetBorderWidth;
    { X3D field "boundaryModeS". } { }
    property BoundaryModeS: String read GetBoundaryModeS write SetBoundaryModeS;
    { X3D field "boundaryModeT". } { }
    property BoundaryModeT: String read GetBoundaryModeT write SetBoundaryModeT;
    { X3D field "boundaryModeR". } { }
    property BoundaryModeR: String read GetBoundaryModeR write SetBoundaryModeR;
    { X3D field "textureCompression". } { }
    property TextureCompression: String read GetTextureCompression write SetTextureCompression;
    { X3D field "texturePriority". } { }
    property TexturePriority: Single read GetTexturePriority write SetTexturePriority;
    { X3D field "generateMipMaps". } { }
    property GenerateMipMaps: Boolean read GetGenerateMipMaps write SetGenerateMipMaps;
    { X3D field "guiTexture". } { }
    property GuiTexture: Boolean read GetGuiTexture write SetGuiTexture;

{$endif read_interface}

{$ifdef read_implementation}

{ TTexturePropertiesNode ----------------------------------------------- }

function TTexturePropertiesNode.GetAnisotropicDegree: Single;
begin
  Result := FdAnisotropicDegree.Value;
end;

procedure TTexturePropertiesNode.SetAnisotropicDegree(const Value: Single);
begin
  FdAnisotropicDegree.Send(Value);
end;

function TTexturePropertiesNode.GetBorderColor: TCastleColor;
begin
  Result := FdBorderColor.Value;
end;

procedure TTexturePropertiesNode.SetBorderColor(const Value: TCastleColor);
begin
  FdBorderColor.Send(Value);
end;

function TTexturePropertiesNode.GetBorderWidth: Integer;
begin
  Result := FdBorderWidth.Value;
end;

procedure TTexturePropertiesNode.SetBorderWidth(const Value: Integer);
begin
  FdBorderWidth.Send(Value);
end;

function TTexturePropertiesNode.GetBoundaryModeS: String;
begin
  Result := FdBoundaryModeS.Value;
end;

procedure TTexturePropertiesNode.SetBoundaryModeS(const Value: String);
begin
  FdBoundaryModeS.Send(Value);
end;

function TTexturePropertiesNode.GetBoundaryModeT: String;
begin
  Result := FdBoundaryModeT.Value;
end;

procedure TTexturePropertiesNode.SetBoundaryModeT(const Value: String);
begin
  FdBoundaryModeT.Send(Value);
end;

function TTexturePropertiesNode.GetBoundaryModeR: String;
begin
  Result := FdBoundaryModeR.Value;
end;

procedure TTexturePropertiesNode.SetBoundaryModeR(const Value: String);
begin
  FdBoundaryModeR.Send(Value);
end;

function TTexturePropertiesNode.GetTextureCompression: String;
begin
  Result := FdTextureCompression.Value;
end;

procedure TTexturePropertiesNode.SetTextureCompression(const Value: String);
begin
  FdTextureCompression.Send(Value);
end;

function TTexturePropertiesNode.GetTexturePriority: Single;
begin
  Result := FdTexturePriority.Value;
end;

procedure TTexturePropertiesNode.SetTexturePriority(const Value: Single);
begin
  FdTexturePriority.Send(Value);
end;

function TTexturePropertiesNode.GetGenerateMipMaps: Boolean;
begin
  Result := FdGenerateMipMaps.Value;
end;

procedure TTexturePropertiesNode.SetGenerateMipMaps(const Value: Boolean);
begin
  FdGenerateMipMaps.Send(Value);
end;

function TTexturePropertiesNode.GetGuiTexture: Boolean;
begin
  Result := FdGuiTexture.Value;
end;

procedure TTexturePropertiesNode.SetGuiTexture(const Value: Boolean);
begin
  FdGuiTexture.Send(Value);
end;

{$endif read_implementation}
