{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetHeadlight: Boolean;
    procedure SetHeadlight(const Value: Boolean);
    function GetSpeed: Single;
    procedure SetSpeed(const Value: Single);
    function GetTransitionTime: TFloatTime;
    procedure SetTransitionTime(const Value: TFloatTime);
    function GetVisibilityLimit: Single;
    procedure SetVisibilityLimit(const Value: Single);
  public
    { Set X3D field "avatarSize". } { }
    procedure SetAvatarSize(const Value: array of Single);
    { Set X3D field "avatarSize". } { }
    procedure SetAvatarSize(const Value: TSingleList);
    { X3D field "headlight". } { }
    property Headlight: Boolean read GetHeadlight write SetHeadlight;
    { X3D field "speed". } { }
    property Speed: Single read GetSpeed write SetSpeed;
    { X3D field "transitionTime". } { }
    property TransitionTime: TFloatTime read GetTransitionTime write SetTransitionTime;
    { Set X3D field "transitionType". } { }
    procedure SetTransitionType(const Value: array of string);
    { Set X3D field "transitionType". } { }
    procedure SetTransitionType(const Value: TCastleStringList);
    { Set X3D field "type". } { }
    procedure SetType(const Value: array of string);
    { Set X3D field "type". } { }
    procedure SetType(const Value: TCastleStringList);
    { X3D field "visibilityLimit". } { }
    property VisibilityLimit: Single read GetVisibilityLimit write SetVisibilityLimit;

{$endif read_interface}

{$ifdef read_implementation}

{ TNavigationInfoNode ----------------------------------------------- }

procedure TNavigationInfoNode.SetAvatarSize(const Value: array of Single);
begin
  FdAvatarSize.Send(Value);
end;

procedure TNavigationInfoNode.SetAvatarSize(const Value: TSingleList);
begin
  FdAvatarSize.Send(Value);
end;

function TNavigationInfoNode.GetHeadlight: Boolean;
begin
  Result := FdHeadlight.Value;
end;

procedure TNavigationInfoNode.SetHeadlight(const Value: Boolean);
begin
  FdHeadlight.Send(Value);
end;

function TNavigationInfoNode.GetSpeed: Single;
begin
  Result := FdSpeed.Value;
end;

procedure TNavigationInfoNode.SetSpeed(const Value: Single);
begin
  FdSpeed.Send(Value);
end;

function TNavigationInfoNode.GetTransitionTime: TFloatTime;
begin
  Result := FdTransitionTime.Value;
end;

procedure TNavigationInfoNode.SetTransitionTime(const Value: TFloatTime);
begin
  FdTransitionTime.Send(Value);
end;

procedure TNavigationInfoNode.SetTransitionType(const Value: array of string);
begin
  FdTransitionType.Send(Value);
end;

procedure TNavigationInfoNode.SetTransitionType(const Value: TCastleStringList);
begin
  FdTransitionType.Send(Value);
end;

procedure TNavigationInfoNode.SetType(const Value: array of string);
begin
  FdType.Send(Value);
end;

procedure TNavigationInfoNode.SetType(const Value: TCastleStringList);
begin
  FdType.Send(Value);
end;

function TNavigationInfoNode.GetVisibilityLimit: Single;
begin
  Result := FdVisibilityLimit.Value;
end;

procedure TNavigationInfoNode.SetVisibilityLimit(const Value: Single);
begin
  FdVisibilityLimit.Send(Value);
end;

{$endif read_implementation}
