{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetLimitOrientation: TVector4;
    procedure SetLimitOrientation(const Value: TVector4);
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
  public
    { X3D field "center". } { }
    property Center: TVector3 read GetCenter write SetCenter;
    { Set X3D field "displacers". } { }
    procedure SetDisplacers(const Value: array of THAnimDisplacerNode);
    { X3D field "limitOrientation". } { }
    property LimitOrientation: TVector4 read GetLimitOrientation write SetLimitOrientation;
    { Set X3D field "llimit". } { }
    procedure SetLlimit(const Value: array of Single);
    { Set X3D field "llimit". } { }
    procedure SetLlimit(const Value: TSingleList);
    { X3D field "name". } { }
    property NameField: String read GetNameField write SetNameField;
    { X3D field "rotation". } { }
    property Rotation: TVector4 read GetRotation write SetRotation;
    { X3D field "scale". } { }
    property Scale: TVector3 read GetScale write SetScale;
    { X3D field "scaleOrientation". } { }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;
    { Set X3D field "skinCoordIndex". } { }
    procedure SetSkinCoordIndex(const Value: array of LongInt);
    { Set X3D field "skinCoordIndex". } { }
    procedure SetSkinCoordIndex(const Value: TLongIntList);
    { Set X3D field "skinCoordWeight". } { }
    procedure SetSkinCoordWeight(const Value: array of Single);
    { Set X3D field "skinCoordWeight". } { }
    procedure SetSkinCoordWeight(const Value: TSingleList);
    { Set X3D field "stiffness". } { }
    procedure SetStiffness(const Value: array of Single);
    { Set X3D field "stiffness". } { }
    procedure SetStiffness(const Value: TSingleList);
    { X3D field "translation". } { }
    property Translation: TVector3 read GetTranslation write SetTranslation;
    { Set X3D field "ulimit". } { }
    procedure SetUlimit(const Value: array of Single);
    { Set X3D field "ulimit". } { }
    procedure SetUlimit(const Value: TSingleList);

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimJointNode ----------------------------------------------- }

function THAnimJointNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure THAnimJointNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

procedure THAnimJointNode.SetDisplacers(const Value: array of THAnimDisplacerNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimDisplacerNode));
  FdDisplacers.Send(A);
end;

function THAnimJointNode.GetLimitOrientation: TVector4;
begin
  Result := FdLimitOrientation.Value;
end;

procedure THAnimJointNode.SetLimitOrientation(const Value: TVector4);
begin
  FdLimitOrientation.Send(Value);
end;

procedure THAnimJointNode.SetLlimit(const Value: array of Single);
begin
  FdLlimit.Send(Value);
end;

procedure THAnimJointNode.SetLlimit(const Value: TSingleList);
begin
  FdLlimit.Send(Value);
end;

function THAnimJointNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimJointNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimJointNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure THAnimJointNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function THAnimJointNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure THAnimJointNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function THAnimJointNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure THAnimJointNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordIndex(const Value: array of LongInt);
begin
  FdSkinCoordIndex.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordIndex(const Value: TLongIntList);
begin
  FdSkinCoordIndex.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordWeight(const Value: array of Single);
begin
  FdSkinCoordWeight.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordWeight(const Value: TSingleList);
begin
  FdSkinCoordWeight.Send(Value);
end;

procedure THAnimJointNode.SetStiffness(const Value: array of Single);
begin
  FdStiffness.Send(Value);
end;

procedure THAnimJointNode.SetStiffness(const Value: TSingleList);
begin
  FdStiffness.Send(Value);
end;

function THAnimJointNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure THAnimJointNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

procedure THAnimJointNode.SetUlimit(const Value: array of Single);
begin
  FdUlimit.Send(Value);
end;

procedure THAnimJointNode.SetUlimit(const Value: TSingleList);
begin
  FdUlimit.Send(Value);
end;

{$endif read_implementation}
