{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetWeight: Single;
    procedure SetWeight(const Value: Single);
  public
    { Set X3D field "coordIndex". } { }
    procedure SetCoordIndex(const Value: array of LongInt);
    { Set X3D field "coordIndex". } { }
    procedure SetCoordIndex(const Value: TLongIntList);
    { Set X3D field "displacements". } { }
    procedure SetDisplacements(const Value: array of TVector3);
    { Set X3D field "displacements". } { }
    procedure SetDisplacements(const Value: TVector3List);
    { X3D field "name". } { }
    property NameField: String read GetNameField write SetNameField;
    { X3D field "weight". } { }
    property Weight: Single read GetWeight write SetWeight;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimDisplacerNode ----------------------------------------------- }

procedure THAnimDisplacerNode.SetCoordIndex(const Value: array of LongInt);
begin
  FdCoordIndex.Send(Value);
end;

procedure THAnimDisplacerNode.SetCoordIndex(const Value: TLongIntList);
begin
  FdCoordIndex.Send(Value);
end;

procedure THAnimDisplacerNode.SetDisplacements(const Value: array of TVector3);
begin
  FdDisplacements.Send(Value);
end;

procedure THAnimDisplacerNode.SetDisplacements(const Value: TVector3List);
begin
  FdDisplacements.Send(Value);
end;

function THAnimDisplacerNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimDisplacerNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimDisplacerNode.GetWeight: Single;
begin
  Result := FdWeight.Value;
end;

procedure THAnimDisplacerNode.SetWeight(const Value: Single);
begin
  FdWeight.Send(Value);
end;

{$endif read_implementation}
