{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAddress: String;
    procedure SetAddress(const Value: String);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetArticulationParameterCount: Integer;
    procedure SetArticulationParameterCount(const Value: Integer);
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetCollisionType: Integer;
    procedure SetCollisionType(const Value: Integer);
    function GetDeadReckoning: Integer;
    procedure SetDeadReckoning(const Value: Integer);
    function GetDetonationLocation: TVector3;
    procedure SetDetonationLocation(const Value: TVector3);
    function GetDetonationRelativeLocation: TVector3;
    procedure SetDetonationRelativeLocation(const Value: TVector3);
    function GetDetonationResult: Integer;
    procedure SetDetonationResult(const Value: Integer);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetEntityCategory: Integer;
    procedure SetEntityCategory(const Value: Integer);
    function GetEntityCountry: Integer;
    procedure SetEntityCountry(const Value: Integer);
    function GetEntityDomain: Integer;
    procedure SetEntityDomain(const Value: Integer);
    function GetEntityExtra: Integer;
    procedure SetEntityExtra(const Value: Integer);
    function GetEntityID: Integer;
    procedure SetEntityID(const Value: Integer);
    function GetEntityKind: Integer;
    procedure SetEntityKind(const Value: Integer);
    function GetEntitySpecific: Integer;
    procedure SetEntitySpecific(const Value: Integer);
    function GetEntitySubCategory: Integer;
    procedure SetEntitySubCategory(const Value: Integer);
    function GetEventApplicationID: Integer;
    procedure SetEventApplicationID(const Value: Integer);
    function GetEventEntityID: Integer;
    procedure SetEventEntityID(const Value: Integer);
    function GetEventNumber: Integer;
    procedure SetEventNumber(const Value: Integer);
    function GetEventSiteID: Integer;
    procedure SetEventSiteID(const Value: Integer);
    function GetFired1: Boolean;
    procedure SetFired1(const Value: Boolean);
    function GetFired2: Boolean;
    procedure SetFired2(const Value: Boolean);
    function GetFireMissionIndex: Integer;
    procedure SetFireMissionIndex(const Value: Integer);
    function GetFiringRange: Single;
    procedure SetFiringRange(const Value: Single);
    function GetFiringRate: Integer;
    procedure SetFiringRate(const Value: Integer);
    function GetForceID: Integer;
    procedure SetForceID(const Value: Integer);
    function GetFuse: Integer;
    procedure SetFuse(const Value: Integer);
    function GetLinearVelocity: TVector3;
    procedure SetLinearVelocity(const Value: TVector3);
    function GetLinearAcceleration: TVector3;
    procedure SetLinearAcceleration(const Value: TVector3);
    function GetMarking: String;
    procedure SetMarking(const Value: String);
    function GetMulticastRelayHost: String;
    procedure SetMulticastRelayHost(const Value: String);
    function GetMulticastRelayPort: Integer;
    procedure SetMulticastRelayPort(const Value: Integer);
    function GetMunitionApplicationID: Integer;
    procedure SetMunitionApplicationID(const Value: Integer);
    function GetMunitionEndPoint: TVector3;
    procedure SetMunitionEndPoint(const Value: TVector3);
    function GetMunitionEntityID: Integer;
    procedure SetMunitionEntityID(const Value: Integer);
    function GetMunitionQuantity: Integer;
    procedure SetMunitionQuantity(const Value: Integer);
    function GetMunitionSiteID: Integer;
    procedure SetMunitionSiteID(const Value: Integer);
    function GetMunitionStartPoint: TVector3;
    procedure SetMunitionStartPoint(const Value: TVector3);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetReadInterval: TFloatTime;
    procedure SetReadInterval(const Value: TFloatTime);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
    function GetWarhead: Integer;
    procedure SetWarhead(const Value: Integer);
    function GetWriteInterval: TFloatTime;
    procedure SetWriteInterval(const Value: TFloatTime);
    function GetRtpHeaderExpected: Boolean;
    procedure SetRtpHeaderExpected(const Value: Boolean);
  public
    { X3D field "address". } { }
    property Address: String read GetAddress write SetAddress;
    { X3D field "applicationID". } { }
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;
    { X3D field "articulationParameterCount". } { }
    property ArticulationParameterCount: Integer read GetArticulationParameterCount write SetArticulationParameterCount;
    { Set X3D field "articulationParameterDesignatorArray". } { }
    procedure SetArticulationParameterDesignatorArray(const Value: array of LongInt);
    { Set X3D field "articulationParameterDesignatorArray". } { }
    procedure SetArticulationParameterDesignatorArray(const Value: TLongIntList);
    { Set X3D field "articulationParameterChangeIndicatorArray". } { }
    procedure SetArticulationParameterChangeIndicatorArray(const Value: array of LongInt);
    { Set X3D field "articulationParameterChangeIndicatorArray". } { }
    procedure SetArticulationParameterChangeIndicatorArray(const Value: TLongIntList);
    { Set X3D field "articulationParameterIdPartAttachedToArray". } { }
    procedure SetArticulationParameterIdPartAttachedToArray(const Value: array of LongInt);
    { Set X3D field "articulationParameterIdPartAttachedToArray". } { }
    procedure SetArticulationParameterIdPartAttachedToArray(const Value: TLongIntList);
    { Set X3D field "articulationParameterTypeArray". } { }
    procedure SetArticulationParameterTypeArray(const Value: array of LongInt);
    { Set X3D field "articulationParameterTypeArray". } { }
    procedure SetArticulationParameterTypeArray(const Value: TLongIntList);
    { Set X3D field "articulationParameterArray". } { }
    procedure SetArticulationParameterArray(const Value: array of Single);
    { Set X3D field "articulationParameterArray". } { }
    procedure SetArticulationParameterArray(const Value: TSingleList);
    { X3D field "center". } { }
    property Center: TVector3 read GetCenter write SetCenter;
    { X3D field "collisionType". } { }
    property CollisionType: Integer read GetCollisionType write SetCollisionType;
    { X3D field "deadReckoning". } { }
    property DeadReckoning: Integer read GetDeadReckoning write SetDeadReckoning;
    { X3D field "detonationLocation". } { }
    property DetonationLocation: TVector3 read GetDetonationLocation write SetDetonationLocation;
    { X3D field "detonationRelativeLocation". } { }
    property DetonationRelativeLocation: TVector3 read GetDetonationRelativeLocation write SetDetonationRelativeLocation;
    { X3D field "detonationResult". } { }
    property DetonationResult: Integer read GetDetonationResult write SetDetonationResult;
    { X3D field "enabled". } { }
    property Enabled: Boolean read GetEnabled write SetEnabled;
    { X3D field "entityCategory". } { }
    property EntityCategory: Integer read GetEntityCategory write SetEntityCategory;
    { X3D field "entityCountry". } { }
    property EntityCountry: Integer read GetEntityCountry write SetEntityCountry;
    { X3D field "entityDomain". } { }
    property EntityDomain: Integer read GetEntityDomain write SetEntityDomain;
    { X3D field "entityExtra". } { }
    property EntityExtra: Integer read GetEntityExtra write SetEntityExtra;
    { X3D field "entityID". } { }
    property EntityID: Integer read GetEntityID write SetEntityID;
    { X3D field "entityKind". } { }
    property EntityKind: Integer read GetEntityKind write SetEntityKind;
    { X3D field "entitySpecific". } { }
    property EntitySpecific: Integer read GetEntitySpecific write SetEntitySpecific;
    { X3D field "entitySubCategory". } { }
    property EntitySubCategory: Integer read GetEntitySubCategory write SetEntitySubCategory;
    { X3D field "eventApplicationID". } { }
    property EventApplicationID: Integer read GetEventApplicationID write SetEventApplicationID;
    { X3D field "eventEntityID". } { }
    property EventEntityID: Integer read GetEventEntityID write SetEventEntityID;
    { X3D field "eventNumber". } { }
    property EventNumber: Integer read GetEventNumber write SetEventNumber;
    { X3D field "eventSiteID". } { }
    property EventSiteID: Integer read GetEventSiteID write SetEventSiteID;
    { X3D field "fired1". } { }
    property Fired1: Boolean read GetFired1 write SetFired1;
    { X3D field "fired2". } { }
    property Fired2: Boolean read GetFired2 write SetFired2;
    { X3D field "fireMissionIndex". } { }
    property FireMissionIndex: Integer read GetFireMissionIndex write SetFireMissionIndex;
    { X3D field "firingRange". } { }
    property FiringRange: Single read GetFiringRange write SetFiringRange;
    { X3D field "firingRate". } { }
    property FiringRate: Integer read GetFiringRate write SetFiringRate;
    { X3D field "forceID". } { }
    property ForceID: Integer read GetForceID write SetForceID;
    { X3D field "fuse". } { }
    property Fuse: Integer read GetFuse write SetFuse;
    { X3D field "linearVelocity". } { }
    property LinearVelocity: TVector3 read GetLinearVelocity write SetLinearVelocity;
    { X3D field "linearAcceleration". } { }
    property LinearAcceleration: TVector3 read GetLinearAcceleration write SetLinearAcceleration;
    { X3D field "marking". } { }
    property Marking: String read GetMarking write SetMarking;
    { X3D field "multicastRelayHost". } { }
    property MulticastRelayHost: String read GetMulticastRelayHost write SetMulticastRelayHost;
    { X3D field "multicastRelayPort". } { }
    property MulticastRelayPort: Integer read GetMulticastRelayPort write SetMulticastRelayPort;
    { X3D field "munitionApplicationID". } { }
    property MunitionApplicationID: Integer read GetMunitionApplicationID write SetMunitionApplicationID;
    { X3D field "munitionEndPoint". } { }
    property MunitionEndPoint: TVector3 read GetMunitionEndPoint write SetMunitionEndPoint;
    { X3D field "munitionEntityID". } { }
    property MunitionEntityID: Integer read GetMunitionEntityID write SetMunitionEntityID;
    { X3D field "munitionQuantity". } { }
    property MunitionQuantity: Integer read GetMunitionQuantity write SetMunitionQuantity;
    { X3D field "munitionSiteID". } { }
    property MunitionSiteID: Integer read GetMunitionSiteID write SetMunitionSiteID;
    { X3D field "munitionStartPoint". } { }
    property MunitionStartPoint: TVector3 read GetMunitionStartPoint write SetMunitionStartPoint;
    { X3D field "port". } { }
    property Port: Integer read GetPort write SetPort;
    { X3D field "readInterval". } { }
    property ReadInterval: TFloatTime read GetReadInterval write SetReadInterval;
    { X3D field "rotation". } { }
    property Rotation: TVector4 read GetRotation write SetRotation;
    { X3D field "scale". } { }
    property Scale: TVector3 read GetScale write SetScale;
    { X3D field "scaleOrientation". } { }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;
    { X3D field "siteID". } { }
    property SiteID: Integer read GetSiteID write SetSiteID;
    { X3D field "translation". } { }
    property Translation: TVector3 read GetTranslation write SetTranslation;
    { X3D field "warhead". } { }
    property Warhead: Integer read GetWarhead write SetWarhead;
    { X3D field "writeInterval". } { }
    property WriteInterval: TFloatTime read GetWriteInterval write SetWriteInterval;
    { X3D field "rtpHeaderExpected". } { }
    property RtpHeaderExpected: Boolean read GetRtpHeaderExpected write SetRtpHeaderExpected;

{$endif read_interface}

{$ifdef read_implementation}

{ TEspduTransformNode ----------------------------------------------- }

function TEspduTransformNode.GetAddress: String;
begin
  Result := FdAddress.Value;
end;

procedure TEspduTransformNode.SetAddress(const Value: String);
begin
  FdAddress.Send(Value);
end;

function TEspduTransformNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TEspduTransformNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

function TEspduTransformNode.GetArticulationParameterCount: Integer;
begin
  Result := FdArticulationParameterCount.Value;
end;

procedure TEspduTransformNode.SetArticulationParameterCount(const Value: Integer);
begin
  FdArticulationParameterCount.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterDesignatorArray(const Value: array of LongInt);
begin
  FdArticulationParameterDesignatorArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterDesignatorArray(const Value: TLongIntList);
begin
  FdArticulationParameterDesignatorArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterChangeIndicatorArray(const Value: array of LongInt);
begin
  FdArticulationParameterChangeIndicatorArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterChangeIndicatorArray(const Value: TLongIntList);
begin
  FdArticulationParameterChangeIndicatorArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterIdPartAttachedToArray(const Value: array of LongInt);
begin
  FdArticulationParameterIdPartAttachedToArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterIdPartAttachedToArray(const Value: TLongIntList);
begin
  FdArticulationParameterIdPartAttachedToArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterTypeArray(const Value: array of LongInt);
begin
  FdArticulationParameterTypeArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterTypeArray(const Value: TLongIntList);
begin
  FdArticulationParameterTypeArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterArray(const Value: array of Single);
begin
  FdArticulationParameterArray.Send(Value);
end;

procedure TEspduTransformNode.SetArticulationParameterArray(const Value: TSingleList);
begin
  FdArticulationParameterArray.Send(Value);
end;

function TEspduTransformNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure TEspduTransformNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

function TEspduTransformNode.GetCollisionType: Integer;
begin
  Result := FdCollisionType.Value;
end;

procedure TEspduTransformNode.SetCollisionType(const Value: Integer);
begin
  FdCollisionType.Send(Value);
end;

function TEspduTransformNode.GetDeadReckoning: Integer;
begin
  Result := FdDeadReckoning.Value;
end;

procedure TEspduTransformNode.SetDeadReckoning(const Value: Integer);
begin
  FdDeadReckoning.Send(Value);
end;

function TEspduTransformNode.GetDetonationLocation: TVector3;
begin
  Result := FdDetonationLocation.Value;
end;

procedure TEspduTransformNode.SetDetonationLocation(const Value: TVector3);
begin
  FdDetonationLocation.Send(Value);
end;

function TEspduTransformNode.GetDetonationRelativeLocation: TVector3;
begin
  Result := FdDetonationRelativeLocation.Value;
end;

procedure TEspduTransformNode.SetDetonationRelativeLocation(const Value: TVector3);
begin
  FdDetonationRelativeLocation.Send(Value);
end;

function TEspduTransformNode.GetDetonationResult: Integer;
begin
  Result := FdDetonationResult.Value;
end;

procedure TEspduTransformNode.SetDetonationResult(const Value: Integer);
begin
  FdDetonationResult.Send(Value);
end;

function TEspduTransformNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TEspduTransformNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TEspduTransformNode.GetEntityCategory: Integer;
begin
  Result := FdEntityCategory.Value;
end;

procedure TEspduTransformNode.SetEntityCategory(const Value: Integer);
begin
  FdEntityCategory.Send(Value);
end;

function TEspduTransformNode.GetEntityCountry: Integer;
begin
  Result := FdEntityCountry.Value;
end;

procedure TEspduTransformNode.SetEntityCountry(const Value: Integer);
begin
  FdEntityCountry.Send(Value);
end;

function TEspduTransformNode.GetEntityDomain: Integer;
begin
  Result := FdEntityDomain.Value;
end;

procedure TEspduTransformNode.SetEntityDomain(const Value: Integer);
begin
  FdEntityDomain.Send(Value);
end;

function TEspduTransformNode.GetEntityExtra: Integer;
begin
  Result := FdEntityExtra.Value;
end;

procedure TEspduTransformNode.SetEntityExtra(const Value: Integer);
begin
  FdEntityExtra.Send(Value);
end;

function TEspduTransformNode.GetEntityID: Integer;
begin
  Result := FdEntityID.Value;
end;

procedure TEspduTransformNode.SetEntityID(const Value: Integer);
begin
  FdEntityID.Send(Value);
end;

function TEspduTransformNode.GetEntityKind: Integer;
begin
  Result := FdEntityKind.Value;
end;

procedure TEspduTransformNode.SetEntityKind(const Value: Integer);
begin
  FdEntityKind.Send(Value);
end;

function TEspduTransformNode.GetEntitySpecific: Integer;
begin
  Result := FdEntitySpecific.Value;
end;

procedure TEspduTransformNode.SetEntitySpecific(const Value: Integer);
begin
  FdEntitySpecific.Send(Value);
end;

function TEspduTransformNode.GetEntitySubCategory: Integer;
begin
  Result := FdEntitySubCategory.Value;
end;

procedure TEspduTransformNode.SetEntitySubCategory(const Value: Integer);
begin
  FdEntitySubCategory.Send(Value);
end;

function TEspduTransformNode.GetEventApplicationID: Integer;
begin
  Result := FdEventApplicationID.Value;
end;

procedure TEspduTransformNode.SetEventApplicationID(const Value: Integer);
begin
  FdEventApplicationID.Send(Value);
end;

function TEspduTransformNode.GetEventEntityID: Integer;
begin
  Result := FdEventEntityID.Value;
end;

procedure TEspduTransformNode.SetEventEntityID(const Value: Integer);
begin
  FdEventEntityID.Send(Value);
end;

function TEspduTransformNode.GetEventNumber: Integer;
begin
  Result := FdEventNumber.Value;
end;

procedure TEspduTransformNode.SetEventNumber(const Value: Integer);
begin
  FdEventNumber.Send(Value);
end;

function TEspduTransformNode.GetEventSiteID: Integer;
begin
  Result := FdEventSiteID.Value;
end;

procedure TEspduTransformNode.SetEventSiteID(const Value: Integer);
begin
  FdEventSiteID.Send(Value);
end;

function TEspduTransformNode.GetFired1: Boolean;
begin
  Result := FdFired1.Value;
end;

procedure TEspduTransformNode.SetFired1(const Value: Boolean);
begin
  FdFired1.Send(Value);
end;

function TEspduTransformNode.GetFired2: Boolean;
begin
  Result := FdFired2.Value;
end;

procedure TEspduTransformNode.SetFired2(const Value: Boolean);
begin
  FdFired2.Send(Value);
end;

function TEspduTransformNode.GetFireMissionIndex: Integer;
begin
  Result := FdFireMissionIndex.Value;
end;

procedure TEspduTransformNode.SetFireMissionIndex(const Value: Integer);
begin
  FdFireMissionIndex.Send(Value);
end;

function TEspduTransformNode.GetFiringRange: Single;
begin
  Result := FdFiringRange.Value;
end;

procedure TEspduTransformNode.SetFiringRange(const Value: Single);
begin
  FdFiringRange.Send(Value);
end;

function TEspduTransformNode.GetFiringRate: Integer;
begin
  Result := FdFiringRate.Value;
end;

procedure TEspduTransformNode.SetFiringRate(const Value: Integer);
begin
  FdFiringRate.Send(Value);
end;

function TEspduTransformNode.GetForceID: Integer;
begin
  Result := FdForceID.Value;
end;

procedure TEspduTransformNode.SetForceID(const Value: Integer);
begin
  FdForceID.Send(Value);
end;

function TEspduTransformNode.GetFuse: Integer;
begin
  Result := FdFuse.Value;
end;

procedure TEspduTransformNode.SetFuse(const Value: Integer);
begin
  FdFuse.Send(Value);
end;

function TEspduTransformNode.GetLinearVelocity: TVector3;
begin
  Result := FdLinearVelocity.Value;
end;

procedure TEspduTransformNode.SetLinearVelocity(const Value: TVector3);
begin
  FdLinearVelocity.Send(Value);
end;

function TEspduTransformNode.GetLinearAcceleration: TVector3;
begin
  Result := FdLinearAcceleration.Value;
end;

procedure TEspduTransformNode.SetLinearAcceleration(const Value: TVector3);
begin
  FdLinearAcceleration.Send(Value);
end;

function TEspduTransformNode.GetMarking: String;
begin
  Result := FdMarking.Value;
end;

procedure TEspduTransformNode.SetMarking(const Value: String);
begin
  FdMarking.Send(Value);
end;

function TEspduTransformNode.GetMulticastRelayHost: String;
begin
  Result := FdMulticastRelayHost.Value;
end;

procedure TEspduTransformNode.SetMulticastRelayHost(const Value: String);
begin
  FdMulticastRelayHost.Send(Value);
end;

function TEspduTransformNode.GetMulticastRelayPort: Integer;
begin
  Result := FdMulticastRelayPort.Value;
end;

procedure TEspduTransformNode.SetMulticastRelayPort(const Value: Integer);
begin
  FdMulticastRelayPort.Send(Value);
end;

function TEspduTransformNode.GetMunitionApplicationID: Integer;
begin
  Result := FdMunitionApplicationID.Value;
end;

procedure TEspduTransformNode.SetMunitionApplicationID(const Value: Integer);
begin
  FdMunitionApplicationID.Send(Value);
end;

function TEspduTransformNode.GetMunitionEndPoint: TVector3;
begin
  Result := FdMunitionEndPoint.Value;
end;

procedure TEspduTransformNode.SetMunitionEndPoint(const Value: TVector3);
begin
  FdMunitionEndPoint.Send(Value);
end;

function TEspduTransformNode.GetMunitionEntityID: Integer;
begin
  Result := FdMunitionEntityID.Value;
end;

procedure TEspduTransformNode.SetMunitionEntityID(const Value: Integer);
begin
  FdMunitionEntityID.Send(Value);
end;

function TEspduTransformNode.GetMunitionQuantity: Integer;
begin
  Result := FdMunitionQuantity.Value;
end;

procedure TEspduTransformNode.SetMunitionQuantity(const Value: Integer);
begin
  FdMunitionQuantity.Send(Value);
end;

function TEspduTransformNode.GetMunitionSiteID: Integer;
begin
  Result := FdMunitionSiteID.Value;
end;

procedure TEspduTransformNode.SetMunitionSiteID(const Value: Integer);
begin
  FdMunitionSiteID.Send(Value);
end;

function TEspduTransformNode.GetMunitionStartPoint: TVector3;
begin
  Result := FdMunitionStartPoint.Value;
end;

procedure TEspduTransformNode.SetMunitionStartPoint(const Value: TVector3);
begin
  FdMunitionStartPoint.Send(Value);
end;

function TEspduTransformNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TEspduTransformNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TEspduTransformNode.GetReadInterval: TFloatTime;
begin
  Result := FdReadInterval.Value;
end;

procedure TEspduTransformNode.SetReadInterval(const Value: TFloatTime);
begin
  FdReadInterval.Send(Value);
end;

function TEspduTransformNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure TEspduTransformNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function TEspduTransformNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure TEspduTransformNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function TEspduTransformNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure TEspduTransformNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

function TEspduTransformNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TEspduTransformNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

function TEspduTransformNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure TEspduTransformNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

function TEspduTransformNode.GetWarhead: Integer;
begin
  Result := FdWarhead.Value;
end;

procedure TEspduTransformNode.SetWarhead(const Value: Integer);
begin
  FdWarhead.Send(Value);
end;

function TEspduTransformNode.GetWriteInterval: TFloatTime;
begin
  Result := FdWriteInterval.Value;
end;

procedure TEspduTransformNode.SetWriteInterval(const Value: TFloatTime);
begin
  FdWriteInterval.Send(Value);
end;

function TEspduTransformNode.GetRtpHeaderExpected: Boolean;
begin
  Result := FdRtpHeaderExpected.Value;
end;

procedure TEspduTransformNode.SetRtpHeaderExpected(const Value: Boolean);
begin
  FdRtpHeaderExpected.Send(Value);
end;

{$endif read_implementation}
