{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetDiffuseTexture: TAbstractEnvironmentTextureNode;
    procedure SetDiffuseTexture(const Value: TAbstractEnvironmentTextureNode);
    function GetSpecularTexture: TAbstractEnvironmentTextureNode;
    procedure SetSpecularTexture(const Value: TAbstractEnvironmentTextureNode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdDiffuseTexture: TSFNode;
    { X3D field "diffuseTexture". } { }
    public property FdDiffuseTexture: TSFNode read FFdDiffuseTexture;
    { X3D field "diffuseTexture". } { }
    property DiffuseTexture: TAbstractEnvironmentTextureNode read GetDiffuseTexture write SetDiffuseTexture;

    strict private FFdSpecularTexture: TSFNode;
    { X3D field "specularTexture". } { }
    public property FdSpecularTexture: TSFNode read FFdSpecularTexture;
    { X3D field "specularTexture". } { }
    property SpecularTexture: TAbstractEnvironmentTextureNode read GetSpecularTexture write SetSpecularTexture;

{$endif read_interface}

{$ifdef read_implementation}

{ TEnvironmentLightNode ----------------------------------------------- }

function TEnvironmentLightNode.GetDiffuseTexture: TAbstractEnvironmentTextureNode;
begin
  if FdDiffuseTexture.Value is TAbstractEnvironmentTextureNode then
    Result := TAbstractEnvironmentTextureNode(FdDiffuseTexture.Value)
  else
    Result := nil;
end;

procedure TEnvironmentLightNode.SetDiffuseTexture(const Value: TAbstractEnvironmentTextureNode);
begin
  FdDiffuseTexture.Send(Value);
end;

function TEnvironmentLightNode.GetSpecularTexture: TAbstractEnvironmentTextureNode;
begin
  if FdSpecularTexture.Value is TAbstractEnvironmentTextureNode then
    Result := TAbstractEnvironmentTextureNode(FdSpecularTexture.Value)
  else
    Result := nil;
end;

procedure TEnvironmentLightNode.SetSpecularTexture(const Value: TAbstractEnvironmentTextureNode);
begin
  FdSpecularTexture.Send(Value);
end;

class function TEnvironmentLightNode.ClassX3DType: String;
begin
  Result := 'EnvironmentLight';
end;

procedure TEnvironmentLightNode.CreateNode;
begin
  inherited;

  FFdDiffuseTexture := TSFNode.Create(Self, True, 'diffuseTexture', [TAbstractEnvironmentTextureNode]);
   FdDiffuseTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseTexture);

  FFdSpecularTexture := TSFNode.Create(Self, True, 'specularTexture', [TAbstractEnvironmentTextureNode]);
   FdSpecularTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpecularTexture);
end;

{$endif read_implementation}
