{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetBounce: Single;
    procedure SetBounce(const Value: Single);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetFrictionCoefficients: TVector2;
    procedure SetFrictionCoefficients(const Value: TVector2);
    function GetMinBounceSpeed: Single;
    procedure SetMinBounceSpeed(const Value: Single);
    function GetSlipFactors: TVector2;
    procedure SetSlipFactors(const Value: TVector2);
    function GetSoftnessConstantForceMix: Single;
    procedure SetSoftnessConstantForceMix(const Value: Single);
    function GetSoftnessErrorCorrection: Single;
    procedure SetSoftnessErrorCorrection(const Value: Single);
    function GetSurfaceSpeed: TVector2;
    procedure SetSurfaceSpeed(const Value: TVector2);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdAppliedParameters: TMFString;
    { X3D field "appliedParameters". } { }
    public property FdAppliedParameters: TMFString read FFdAppliedParameters;
    { Set X3D field "appliedParameters". } { }
    procedure SetAppliedParameters(const Value: array of string);
    { Set X3D field "appliedParameters". } { }
    procedure SetAppliedParameters(const Value: TCastleStringList);

    strict private FFdBounce: TSFFloat;
    { X3D field "bounce". } { }
    public property FdBounce: TSFFloat read FFdBounce;
    { X3D field "bounce". } { }
    property Bounce: Single read GetBounce write SetBounce;

    strict private FFdCollidables: TMFNode;
    { X3D field "collidables". } { }
    public property FdCollidables: TMFNode read FFdCollidables;

    strict private FFdEnabled: TSFBool;
    { X3D field "enabled". } { }
    public property FdEnabled: TSFBool read FFdEnabled;
    { X3D field "enabled". } { }
    property Enabled: Boolean read GetEnabled write SetEnabled;

    strict private FFdFrictionCoefficients: TSFVec2f;
    { X3D field "frictionCoefficients". } { }
    public property FdFrictionCoefficients: TSFVec2f read FFdFrictionCoefficients;
    { X3D field "frictionCoefficients". } { }
    property FrictionCoefficients: TVector2 read GetFrictionCoefficients write SetFrictionCoefficients;

    strict private FFdMinBounceSpeed: TSFFloat;
    { X3D field "minBounceSpeed". } { }
    public property FdMinBounceSpeed: TSFFloat read FFdMinBounceSpeed;
    { X3D field "minBounceSpeed". } { }
    property MinBounceSpeed: Single read GetMinBounceSpeed write SetMinBounceSpeed;

    strict private FFdSlipFactors: TSFVec2f;
    { X3D field "slipFactors". } { }
    public property FdSlipFactors: TSFVec2f read FFdSlipFactors;
    { X3D field "slipFactors". } { }
    property SlipFactors: TVector2 read GetSlipFactors write SetSlipFactors;

    strict private FFdSoftnessConstantForceMix: TSFFloat;
    { X3D field "softnessConstantForceMix". } { }
    public property FdSoftnessConstantForceMix: TSFFloat read FFdSoftnessConstantForceMix;
    { X3D field "softnessConstantForceMix". } { }
    property SoftnessConstantForceMix: Single read GetSoftnessConstantForceMix write SetSoftnessConstantForceMix;

    strict private FFdSoftnessErrorCorrection: TSFFloat;
    { X3D field "softnessErrorCorrection". } { }
    public property FdSoftnessErrorCorrection: TSFFloat read FFdSoftnessErrorCorrection;
    { X3D field "softnessErrorCorrection". } { }
    property SoftnessErrorCorrection: Single read GetSoftnessErrorCorrection write SetSoftnessErrorCorrection;

    strict private FFdSurfaceSpeed: TSFVec2f;
    { X3D field "surfaceSpeed". } { }
    public property FdSurfaceSpeed: TSFVec2f read FFdSurfaceSpeed;
    { X3D field "surfaceSpeed". } { }
    property SurfaceSpeed: TVector2 read GetSurfaceSpeed write SetSurfaceSpeed;

{$endif read_interface}

{$ifdef read_implementation}

{ TCollisionCollectionNode ----------------------------------------------- }

procedure TCollisionCollectionNode.SetAppliedParameters(const Value: array of string);
begin
  FdAppliedParameters.Send(Value);
end;

procedure TCollisionCollectionNode.SetAppliedParameters(const Value: TCastleStringList);
begin
  FdAppliedParameters.Send(Value);
end;

function TCollisionCollectionNode.GetBounce: Single;
begin
  Result := FdBounce.Value;
end;

procedure TCollisionCollectionNode.SetBounce(const Value: Single);
begin
  FdBounce.Send(Value);
end;

function TCollisionCollectionNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TCollisionCollectionNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TCollisionCollectionNode.GetFrictionCoefficients: TVector2;
begin
  Result := FdFrictionCoefficients.Value;
end;

procedure TCollisionCollectionNode.SetFrictionCoefficients(const Value: TVector2);
begin
  FdFrictionCoefficients.Send(Value);
end;

function TCollisionCollectionNode.GetMinBounceSpeed: Single;
begin
  Result := FdMinBounceSpeed.Value;
end;

procedure TCollisionCollectionNode.SetMinBounceSpeed(const Value: Single);
begin
  FdMinBounceSpeed.Send(Value);
end;

function TCollisionCollectionNode.GetSlipFactors: TVector2;
begin
  Result := FdSlipFactors.Value;
end;

procedure TCollisionCollectionNode.SetSlipFactors(const Value: TVector2);
begin
  FdSlipFactors.Send(Value);
end;

function TCollisionCollectionNode.GetSoftnessConstantForceMix: Single;
begin
  Result := FdSoftnessConstantForceMix.Value;
end;

procedure TCollisionCollectionNode.SetSoftnessConstantForceMix(const Value: Single);
begin
  FdSoftnessConstantForceMix.Send(Value);
end;

function TCollisionCollectionNode.GetSoftnessErrorCorrection: Single;
begin
  Result := FdSoftnessErrorCorrection.Value;
end;

procedure TCollisionCollectionNode.SetSoftnessErrorCorrection(const Value: Single);
begin
  FdSoftnessErrorCorrection.Send(Value);
end;

function TCollisionCollectionNode.GetSurfaceSpeed: TVector2;
begin
  Result := FdSurfaceSpeed.Value;
end;

procedure TCollisionCollectionNode.SetSurfaceSpeed(const Value: TVector2);
begin
  FdSurfaceSpeed.Send(Value);
end;

class function TCollisionCollectionNode.ClassX3DType: String;
begin
  Result := 'CollisionCollection';
end;

procedure TCollisionCollectionNode.CreateNode;
begin
  inherited;

  FFdAppliedParameters := TMFString.Create(Self, True, 'appliedParameters', ['BOUNCE']);
   FdAppliedParameters.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAppliedParameters);
  { X3D specification comment: [] }

  FFdBounce := TSFFloat.Create(Self, True, 'bounce', 0);
   FdBounce.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBounce);
  { X3D specification comment: [0,1] }

  FFdCollidables := TMFNode.Create(Self, True, 'collidables', [TAbstractNBodyCollisionSpaceNode, TAbstractNBodyCollidableNode]);
   FdCollidables.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCollidables);

  FFdEnabled := TSFBool.Create(Self, True, 'enabled', true);
   FdEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnabled);

  FFdFrictionCoefficients := TSFVec2f.Create(Self, True, 'frictionCoefficients', Vector2(0, 0));
   FdFrictionCoefficients.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFrictionCoefficients);
  { X3D specification comment: [0,Inf) }

  FFdMinBounceSpeed := TSFFloat.Create(Self, True, 'minBounceSpeed', 0.1);
   FdMinBounceSpeed.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMinBounceSpeed);
  { X3D specification comment: [0,Inf) }

  FFdSlipFactors := TSFVec2f.Create(Self, True, 'slipFactors', Vector2(0, 0));
   FdSlipFactors.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSlipFactors);
  { X3D specification comment: (-Inf,Inf) }

  FFdSoftnessConstantForceMix := TSFFloat.Create(Self, True, 'softnessConstantForceMix', 0.0001);
   FdSoftnessConstantForceMix.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSoftnessConstantForceMix);
  { X3D specification comment: [0,1] }

  FFdSoftnessErrorCorrection := TSFFloat.Create(Self, True, 'softnessErrorCorrection', 0.8);
   FdSoftnessErrorCorrection.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSoftnessErrorCorrection);
  { X3D specification comment: [0,1] }

  FFdSurfaceSpeed := TSFVec2f.Create(Self, True, 'surfaceSpeed', Vector2(0, 0));
   FdSurfaceSpeed.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSurfaceSpeed);
  { X3D specification comment: (-Inf,Inf) }
end;

{$endif read_implementation}
