{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventSet_triggerTime: TSFTimeEvent;
    { X3D in event "set_triggerTime". } { }
    public property EventSet_triggerTime: TSFTimeEvent read FEventSet_triggerTime;

    strict private FEventTriggerTrue: TSFBoolEvent;
    { X3D out event "triggerTrue". } { }
    public property EventTriggerTrue: TSFBoolEvent read FEventTriggerTrue;

{$endif read_interface}

{$ifdef read_implementation}

{ TBooleanTriggerNode ----------------------------------------------- }

class function TBooleanTriggerNode.ClassX3DType: String;
begin
  Result := 'BooleanTrigger';
end;

procedure TBooleanTriggerNode.CreateNode;
begin
  inherited;

  FEventSet_triggerTime := TSFTimeEvent.Create(Self, 'set_triggerTime', true);
  AddEvent(FEventSet_triggerTime);

  FEventTriggerTrue := TSFBoolEvent.Create(Self, 'triggerTrue', false);
  AddEvent(FEventTriggerTrue);
end;

{$endif read_implementation}
