{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetToggle: Boolean;
    procedure SetToggle(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventSet_boolean: TSFBoolEvent;
    { X3D in event "set_boolean". } { }
    public property EventSet_boolean: TSFBoolEvent read FEventSet_boolean;

    strict private FFdToggle: TSFBool;
    { X3D field "toggle". } { }
    public property FdToggle: TSFBool read FFdToggle;
    { X3D field "toggle". } { }
    property Toggle: Boolean read GetToggle write SetToggle;

{$endif read_interface}

{$ifdef read_implementation}

{ TBooleanToggleNode ----------------------------------------------- }

function TBooleanToggleNode.GetToggle: Boolean;
begin
  Result := FdToggle.Value;
end;

procedure TBooleanToggleNode.SetToggle(const Value: Boolean);
begin
  FdToggle.Send(Value);
end;

class function TBooleanToggleNode.ClassX3DType: String;
begin
  Result := 'BooleanToggle';
end;

procedure TBooleanToggleNode.CreateNode;
begin
  inherited;

  FEventSet_boolean := TSFBoolEvent.Create(Self, 'set_boolean', true);
  AddEvent(FEventSet_boolean);

  FFdToggle := TSFBool.Create(Self, True, 'toggle', false);
   FdToggle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdToggle);
end;

{$endif read_implementation}
