{ -*- buffer-read-only: t -*-

  Copyright 2018-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FColorPersistent: TCastleColorPersistent;
  function GetColorForPersistent: TCastleColor;
  procedure SetColorForPersistent(const AValue: TCastleColor);
published
  { @link(Color) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(Color) directly.

    @seealso Color }
  property ColorPersistent: TCastleColorPersistent read FColorPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleShape.GetColorForPersistent: TCastleColor;
begin
  Result := Color;
end;

procedure TCastleShape.SetColorForPersistent(const AValue: TCastleColor);
begin
  Color := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FColorPersistent := TCastleColorPersistent.Create;
  FColorPersistent.InternalGetValue := @GetColorForPersistent;
  FColorPersistent.InternalSetValue := @SetColorForPersistent;
  FColorPersistent.InternalDefaultValue := Color; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FColorPersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FOutlineColorPersistent: TCastleColorPersistent;
  function GetOutlineColorForPersistent: TCastleColor;
  procedure SetOutlineColorForPersistent(const AValue: TCastleColor);
published
  { @link(OutlineColor) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(OutlineColor) directly.

    @seealso OutlineColor }
  property OutlineColorPersistent: TCastleColorPersistent read FOutlineColorPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleShape.GetOutlineColorForPersistent: TCastleColor;
begin
  Result := OutlineColor;
end;

procedure TCastleShape.SetOutlineColorForPersistent(const AValue: TCastleColor);
begin
  OutlineColor := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FOutlineColorPersistent := TCastleColorPersistent.Create;
  FOutlineColorPersistent.InternalGetValue := @GetOutlineColorForPersistent;
  FOutlineColorPersistent.InternalSetValue := @SetOutlineColorForPersistent;
  FOutlineColorPersistent.InternalDefaultValue := OutlineColor; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FOutlineColorPersistent);
{$endif read_implementation_destructor}

