{ -*- buffer-read-only: t -*-

  Copyright 2018-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FColorPersistent: TCastleColorPersistent;
  function GetColorForPersistent: TCastleColor;
  procedure SetColorForPersistent(const AValue: TCastleColor);
published
  { @link(Color) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(Color) directly.

    @seealso Color }
  property ColorPersistent: TCastleColorPersistent read FColorPersistent stored false;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleImageControl.GetColorForPersistent: TCastleColor;
begin
  Result := Color;
end;

procedure TCastleImageControl.SetColorForPersistent(const AValue: TCastleColor);
begin
  Color := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FColorPersistent := TCastleColorPersistent.Create;
  FColorPersistent.InternalGetValue := @GetColorForPersistent;
  FColorPersistent.InternalSetValue := @SetColorForPersistent;
  FColorPersistent.InternalDefaultValue := Color; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FColorPersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FClipLinePersistent: TCastleVector3Persistent;
  function GetClipLineForPersistent: TVector3;
  procedure SetClipLineForPersistent(const AValue: TVector3);
published
  { @link(ClipLine) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(ClipLine) directly.

    @seealso ClipLine }
  property ClipLinePersistent: TCastleVector3Persistent read FClipLinePersistent stored false;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleImageControl.GetClipLineForPersistent: TVector3;
begin
  Result := ClipLine;
end;

procedure TCastleImageControl.SetClipLineForPersistent(const AValue: TVector3);
begin
  ClipLine := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FClipLinePersistent := TCastleVector3Persistent.Create;
  FClipLinePersistent.InternalGetValue := @GetClipLineForPersistent;
  FClipLinePersistent.InternalSetValue := @SetClipLineForPersistent;
  FClipLinePersistent.InternalDefaultValue := ClipLine; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FClipLinePersistent);
{$endif read_implementation_destructor}

{ -*- buffer-read-only: t -*-

  Copyright 2018-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FRotationCenterPersistent: TCastleVector2Persistent;
  function GetRotationCenterForPersistent: TVector2;
  procedure SetRotationCenterForPersistent(const AValue: TVector2);
published
  { @link(RotationCenter) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(RotationCenter) directly.

    @seealso RotationCenter }
  property RotationCenterPersistent: TCastleVector2Persistent read FRotationCenterPersistent stored false;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleImageControl.GetRotationCenterForPersistent: TVector2;
begin
  Result := RotationCenter;
end;

procedure TCastleImageControl.SetRotationCenterForPersistent(const AValue: TVector2);
begin
  RotationCenter := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FRotationCenterPersistent := TCastleVector2Persistent.Create;
  FRotationCenterPersistent.InternalGetValue := @GetRotationCenterForPersistent;
  FRotationCenterPersistent.InternalSetValue := @SetRotationCenterForPersistent;
  FRotationCenterPersistent.InternalDefaultValue := RotationCenter; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FRotationCenterPersistent);
{$endif read_implementation_destructor}

