if(WIN32)
  windows_find_library(GLIBMM3_LIBRARIES REQUIRED glibmm sigc glib pcre gobject)
  if (GLIBMM3_LIBRARIES)
    set(GLIBMM3_FOUND TRUE)
  endif()
else()
  find_package(PkgConfig REQUIRED)
  if(MACOS)
    execute_process(COMMAND brew --prefix glibmm@2.64  OUTPUT_STRIP_TRAILING_WHITESPACE OUTPUT_VARIABLE GLIBMM_PREFIX)
    execute_process(COMMAND brew --prefix cairomm@1.14 OUTPUT_STRIP_TRAILING_WHITESPACE OUTPUT_VARIABLE CAIROMM_PREFIX)
    execute_process(COMMAND brew --prefix pangomm@2.42 OUTPUT_STRIP_TRAILING_WHITESPACE OUTPUT_VARIABLE PANGOMM_PREFIX)
    execute_process(COMMAND brew --prefix atkmm@2.28   OUTPUT_STRIP_TRAILING_WHITESPACE OUTPUT_VARIABLE ATKMM_PREFIX)
    set( ENV{PKG_CONFIG_PATH} "${GLIBMM_PREFIX}/lib/pkgconfig:${CAIROMM_PREFIX}/lib/pkgconfig:${PANGOMM_PREFIX}/lib/pkgconfig:${ATKMM_PREFIX}/lib/pkgconfig:$ENV{PKG_CONFIG_PATH}" )
    message(STATUS "Using PKG_CONFIG_PATH = $ENV{PKG_CONFIG_PATH}")
  endif()
  pkg_check_modules(GLIBMM3 REQUIRED glibmm-2.4)
  include_directories(${GLIBMM3_INCLUDE_DIRS})
  link_directories(${GLIBMM3_LIBRARY_DIRS})
  add_definitions(${GLIBMM3_CFLAGS_OTHER})
endif()

if (GLIBMM3_FOUND)
  message(STATUS "Found glibmm; include path ${GLIBMM3_INCLUDE_DIRS}")
  message(STATUS "Found glibmm; lib ${GLIBMM3_LIBRARIES}")
endif()
