package org.bouncycastle.dvcs.test;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.dvcs.CertEtcToken;
import org.bouncycastle.asn1.dvcs.DVCSCertInfo;
import org.bouncycastle.asn1.dvcs.DVCSCertInfoBuilder;
import org.bouncycastle.asn1.dvcs.DVCSErrorNotice;
import org.bouncycastle.asn1.dvcs.DVCSRequest;
import org.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import org.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import org.bouncycastle.asn1.dvcs.DVCSResponse;
import org.bouncycastle.asn1.dvcs.DVCSTime;
import org.bouncycastle.asn1.dvcs.Data;
import org.bouncycastle.asn1.dvcs.ServiceType;
import org.bouncycastle.asn1.dvcs.TargetEtcChain;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.dvcs.DVCSException;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class DVCSParseTest
    extends TestCase
{

    // Clepsydre requests and responses
    private static final String REQUEST_CCPD_CLEPSYDRE = "MIICRgYJKoZIhvcNAQcCoIICNzCCAjMCAQMxCzAJBgUrDgMCGgUAMIGZBgsqhkiG9w0BCRABB6CBiQSBhjCBgzBgCgEEoE2kSzBJMQswCQYDVQQGEwJGUjEOMAwGA1UEBxMFUGFyaXMxEDAOBgNVBAoTB0VkZWxXZWIxGDAWBgNVBAMTD1BldGVyIFN5bHZlc3RlcqEMBgorBgEEAak9AQIBMB8wBwYFKw4DAhoEFHW2ha9viUZ96AcVJR5Fl4/NH6VmMYIBgzCCAX8CAQEwfDBwMQswCQYDVQQGEwJGUjEVMBMGA1UEChMMRWRlbFdlYiBTLkEuMSgwJgYDVQQLEx9DbGVwc3lkcmUgRGVtb25zdHJhdGlvbiBTZXJ2aWNlMSAwHgYDVQQDExdUaW1lIFN0YW1waW5nIEF1dGhvcml0eQIIAJSIFyE0N3YwCQYFKw4DAhoFAKBfMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBzAcBgkqhkiG9w0BCQUxDxcNMDAwNDE3MTcxNDU3WjAjBgkqhkiG9w0BCQQxFgQUTajC0s58DQRBL0QTM3XbL1st+dwwDQYJKoZIhvcNAQEBBQAEgYBuew429QhfFjwxeyi7C8LGF2emtVTxmOJviZYODJnmy0DBm43Y147TK0H3FiZbtwi/5pWy2QFs/rEsUsFa0jHzjsrdEaFyBSlBat0oQKpcd8adHYBT22+cTKWjj5KLGD/VOq0Bh2nD/dPYw9DKa+YNTlNuUCCZfJTCRCUbBsCZlg==";
    private static final String RESPONSE_CCPD_CLEPSYDRE = "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";
    // Top-Cross requests and responses
    private static final String REQUEST_CPD_TOMSK = "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";
    private static final String RESPONSE_CPD_TOMSK = "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";
    //    private static final String REQUEST_VSD_TOMSK   = "";
//    private static final String RESPONSE_VSD_TOMSK  = "";
    private static final String REQUEST_VPKC_TOMSK = "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";
    private static final String RESPONSE_VPKC_TOMSK = "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";
    private static final String REQUEST_CCPD_TOMSK = "MIIFagYJKoZIhvcNAQcCoIIFWzCCBVcCAQMxDDAKBgYqhQMCAgkFADBuBgsqhkiG9w0BCRABB6BfBF0wWzAKCgEEAgUAwDELHDA1MBEGBiqFAwICCQYHKoUDAgIeAQQgvrgCrtSqJuzWwWE7XelQv0cB71ehcXkh/Oikezqvl1agFgYLKoUDAhUBAQIBAwKgBwIFAJ7ldeKgggN0MIIDcDCCAx2gAwIBAgIKJjs9ewAAAAA3FDAKBgYqhQMCAgMFADCB5zEbMBkGCSqGSIb3DQEJARYMdWRjc0B1ZGNzLnJ1MQswCQYDVQQGEwJSVTEXMBUGA1UECB4OBCIEPgQ8BEEEOgQwBE8xEzARBgNVBAceCgQiBD4EPARBBDoxRzBFBgNVBAoTPlRvbXNrIFN0YXRlIFVuaXZlcnNpdHkgb2YgQ29udHJvbCBTeXN0ZW1zIGFuZCBSYWRpb2VsZWN0cm9uaWNzMScwJQYDVQQLHh4EJgQiBBEAIAAtACAEIwQmACAEIQQ4BDEEOARABDgxGzAZBgNVBAMTElVEQyBTaWJpcmlhIFRTVUNTUjAeFw0xMTEyMDcwNDI0MDBaFw0xMjEyMDcwNDMzMDBaMB8xHTAbBgNVBAMeFABSAEMAQQBJAFIAXwB0AGUAYwBoMGMwHAYGKoUDAgITMBIGByqFAwICJAAGByqFAwICHgEDQwAEQLgMQUEkI9li1pn4dHHEWv5SSCjI77W6wfG3mSzEKw0vd3qQUTd86xZGAEwVC2dxJIdiQlSuMtyog6vSau3FriKjggFsMIIBaDAOBgNVHQ8BAf8EBAMCBPAwMAYDVR0lBCkwJwYIKwYBBQUHAwQGCCqFAwMTAgUCBgcqhQMCAiIGBggrBgEFBQcDAjAdBgNVHQ4EFgQU/hZ+9/9Tt/94ckUhTWabJMCegqQwHwYDVR0jBBgwFoAUuR6KgNhm2o7kHyiMQFiMXOrW5yIwWgYDVR0fBFMwUTBPoE2gS4YjaHR0cDovL3d3dy51ZGNzLnJ1L2NlcnRzcnYvdWRjcy5jcmyGJGh0dHA6Ly93d3cyLnVkY3MucnUvY2VydHNydi91ZGNzLmNybDBxBggrBgEFBQcBAQRlMGMwLwYIKwYBBQUHMAKGI2h0dHA6Ly93d3cudWRjcy5ydS9jZXJ0c3J2L3VkY3MuY2VyMDAGCCsGAQUFBzAChiRodHRwOi8vd3d3Mi51ZGNzLnJ1L2NlcnRzcnYvdWRjcy5jZXIwFQYDVR0gBA4wDDAKBggqhQMDEwIFATAKBgYqhQMCAgMFAANBALCWVdYVTPSLtijWd6utGC/rtl0mGvU3UjyaHC2jbFovDwyRpx13BseqbcsxBA+aNabeH2WuEQMirhVt7lpV4jMxggFaMIIBVgIBATCB9jCB5zEbMBkGCSqGSIb3DQEJARYMdWRjc0B1ZGNzLnJ1MQswCQYDVQQGEwJSVTEXMBUGA1UECB4OBCIEPgQ8BEEEOgQwBE8xEzARBgNVBAceCgQiBD4EPARBBDoxRzBFBgNVBAoTPlRvbXNrIFN0YXRlIFVuaXZlcnNpdHkgb2YgQ29udHJvbCBTeXN0ZW1zIGFuZCBSYWRpb2VsZWN0cm9uaWNzMScwJQYDVQQLHh4EJgQiBBEAIAAtACAEIwQmACAEIQQ4BDEEOARABDgxGzAZBgNVBAMTElVEQyBTaWJpcmlhIFRTVUNTUgIKJjs9ewAAAAA3FDAKBgYqhQMCAgkFADAKBgYqhQMCAhMFAARAl0/LMiXMPCJIkAgCI6x3/8wPBDTR8P5GGs40Xzbz1rdvxcBTPEsyp8kNYMzxmQNegTOFemy15KKnQq8e4Fja6w==";
    private static final String RESPONSE_CCPD_TOMSK = "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";
    // expected info initialization:
    private static final DVCSRequest REQ_CCPD_CLEPSYDRE, REQ_CCPD_TOMSK, REQ_CPD_TOMSK, REQ_VPKC_TOMSK;
    private static final DVCSResponse RES_CCPD_CLEPSYDRE, RES_CCPD_TOMSK, RES_CPD_TOMSK, RES_VPKC_TOMSK;
    private static List requests = new ArrayList();
    private static List responses = new ArrayList();

    static
    {
        GeneralName CLEPSYDRE_REQUESTER = GeneralName.getInstance(Hex.decode("A44B3049310B3009060355040613024652310E300C0603550407130550617269733110300E060355040A13074564656C576562311830160603550403130F50657465722053796C766573746572"));
        GeneralName CLEPSYDRE_RESPONDER = GeneralName.getInstance(Hex.decode("A4723070310B300906035504061302465231153013060355040A130C4564656C57656220532E412E31283026060355040B131F436C657073796472652044656D6F6E7374726174696F6E20536572766963653120301E0603550403131754696D65205374616D70696E6720417574686F72697479"));
        PolicyInformation CLEPSYDRE_POLICY = new PolicyInformation(new ASN1ObjectIdentifier("1.3.6.1.4.1.5309.1.2.1"));

        DVCSRequestInformationBuilder INFO_CCPD_CLEPSYDRE = new DVCSRequestInformationBuilder(ServiceType.CCPD);
        INFO_CCPD_CLEPSYDRE.setRequester(CLEPSYDRE_REQUESTER);
        INFO_CCPD_CLEPSYDRE.setRequestPolicy(CLEPSYDRE_POLICY);

        DigestInfo DIGEST_CCPD_CLEPSYDRE = new DigestInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.3.14.3.2.26")), Hex.decode("75B685AF6F89467DE80715251E45978FCD1FA566"));

        DVCSRequestInformationBuilder INFO_CCPD_CLEPSYDRE2 = new DVCSRequestInformationBuilder(ServiceType.CCPD);
        INFO_CCPD_CLEPSYDRE2.setRequester(CLEPSYDRE_REQUESTER);
        INFO_CCPD_CLEPSYDRE2.setRequestPolicy(CLEPSYDRE_POLICY);
        INFO_CCPD_CLEPSYDRE2.setDVCS(CLEPSYDRE_RESPONDER);

        REQ_CCPD_CLEPSYDRE = new DVCSRequest(INFO_CCPD_CLEPSYDRE.build(), new Data(DIGEST_CCPD_CLEPSYDRE));
        RES_CCPD_CLEPSYDRE = new DVCSResponse(new DVCSCertInfo(INFO_CCPD_CLEPSYDRE2.build(), DIGEST_CCPD_CLEPSYDRE, new ASN1Integer(new BigInteger(Hex.decode("01780A1ECA8823"))), new DVCSTime(new ASN1GeneralizedTime("20000417171617Z"))));

        DVCSRequestInformationBuilder INFO_CCPD_TOMSK = new DVCSRequestInformationBuilder(ServiceType.CCPD);
        INFO_CCPD_TOMSK.setNonce(new BigInteger(Hex.decode("00C0310B1C")));

        DigestInfo DIGEST_CCPD_TOMSK = new DigestInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.643.2.2.9"), new ASN1ObjectIdentifier("1.2.643.2.2.30.1")), Hex.decode("BEB802AED4AA26ECD6C1613B5DE950BF4701EF57A1717921FCE8A47B3AAF9756"));
        GeneralName ID_CCPD_TOMSK = GeneralName.getInstance(Hex.decode("A016060B2A85030215010102010302A0070205009EE575E2"));

        REQ_CCPD_TOMSK = new DVCSRequest(INFO_CCPD_TOMSK.build(), new Data(DIGEST_CCPD_TOMSK), ID_CCPD_TOMSK);

        DVCSCertInfoBuilder certInfoBldr = new DVCSCertInfoBuilder(INFO_CCPD_TOMSK.build(), DIGEST_CCPD_TOMSK, new ASN1Integer(6256), new DVCSTime(new ASN1GeneralizedTime("20121204040643Z")));
        certInfoBldr.setDvStatus(new PKIStatusInfo(PKIStatus.granted));
        RES_CCPD_TOMSK = new DVCSResponse(certInfoBldr.build());


        DVCSRequestInformationBuilder INFO_CPD_TOMSK = new DVCSRequestInformationBuilder(ServiceType.CPD);
        INFO_CPD_TOMSK.setNonce(new BigInteger("234303415"));

        DVCSRequestInformationBuilder INFO_CPD_TOMSK2 = new DVCSRequestInformationBuilder(ServiceType.CPD);
        INFO_CPD_TOMSK2.setNonce(new BigInteger("1957381177"));

        String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
        DigestInfo DIGEST_CPD_TOMSK = DIGEST_CCPD_TOMSK;
        GeneralName ID_CPD_TOMSK = GeneralName.getInstance(Hex.decode("A016060B2A85030215010102010302A00702050085BA0D41"));

        REQ_CPD_TOMSK = new DVCSRequest(INFO_CPD_TOMSK.build(), new Data(Hex.decode(CPD_DATA_TOMSK)), ID_CPD_TOMSK);

        certInfoBldr = new DVCSCertInfoBuilder(INFO_CPD_TOMSK2.build(), DIGEST_CPD_TOMSK, new ASN1Integer(6329), new DVCSTime(new ASN1GeneralizedTime("20121205065720Z")));
        certInfoBldr.setDvStatus(new PKIStatusInfo(PKIStatus.granted));
        RES_CPD_TOMSK = new DVCSResponse(certInfoBldr.build());


        DVCSRequestInformationBuilder INFO_VPKC_TOMSK = new DVCSRequestInformationBuilder(ServiceType.VPKC);
        INFO_VPKC_TOMSK.setNonce(new BigInteger(Hex.decode("00D3F85051")));

        String VPKC_DATA_TOMSK = CPD_DATA_TOMSK;
        DigestInfo DIGEST_VPKC_TOMSK = new DigestInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.643.2.2.9"), new ASN1ObjectIdentifier("1.2.643.2.2.30.1")), Hex.decode("FD97A3191C95D2AD733C11ABE0E6AEB081AF8735177F50F6B08C29D3AAFE8DE7"));
        GeneralName ID_VPKC_TOMSK = GeneralName.getInstance(Hex.decode("A016060B2A85030215010102010302A007020500AE344E64"));

        CertEtcToken target = new CertEtcToken(CertEtcToken.TAG_CERTIFICATE, Certificate.getInstance(Hex.decode(VPKC_DATA_TOMSK)));
        TargetEtcChain REQ_CERTS = new TargetEtcChain(target);

        TargetEtcChain[] RES_CERTS = TargetEtcChain.arrayFromSequence(new DERSequence(ASN1Sequence.getInstance(Hex.decode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

        REQ_VPKC_TOMSK = new DVCSRequest(INFO_VPKC_TOMSK.build(), new Data(REQ_CERTS), ID_VPKC_TOMSK);

        certInfoBldr = new DVCSCertInfoBuilder(INFO_VPKC_TOMSK.build(), DIGEST_VPKC_TOMSK, new ASN1Integer(6257), new DVCSTime(new ASN1GeneralizedTime("20121204040753Z")));

        certInfoBldr.setDvStatus(new PKIStatusInfo(PKIStatus.granted));
        certInfoBldr.setCerts(RES_CERTS);

        RES_VPKC_TOMSK = new DVCSResponse(certInfoBldr.build());

        requests.add(new Info("req_ccpd_clepsydre", REQUEST_CCPD_CLEPSYDRE, REQ_CCPD_CLEPSYDRE));
        requests.add(new Info("req_ccpd_tomsk", REQUEST_CCPD_TOMSK, REQ_CCPD_TOMSK));
        requests.add(new Info("req_cpd_tomsk", REQUEST_CPD_TOMSK, REQ_CPD_TOMSK));
        requests.add(new Info("req_vpkc_tomsk", REQUEST_VPKC_TOMSK, REQ_VPKC_TOMSK));

        responses.add(new Info("res_ccpd_clepsydre", RESPONSE_CCPD_CLEPSYDRE, RES_CCPD_CLEPSYDRE));
        responses.add(new Info("res_ccpd_tomsk", RESPONSE_CCPD_TOMSK, RES_CCPD_TOMSK));
        responses.add(new Info("res_cpd_tomsk", RESPONSE_CPD_TOMSK, RES_CPD_TOMSK));
        responses.add(new Info("res_vpkc_tomsk", RESPONSE_VPKC_TOMSK, RES_VPKC_TOMSK));

    }

    private static boolean areNull(String type, Object result, Object expected)
    {
        if (result == null && expected == null)
        {
            return true;
        }
        if (result == null && expected != null)
        {
            fail("Result '" + type + "' is null, whereas expected '" + type + "' is not null");
        }
        if (result != null && expected == null)
        {
            fail("Result '" + type + "' is not null, whereas expected '" + type + "' is null");
        }
        return false;
    }

    ////////////////////////////////////////////////////
    //                  PARSE TESTS                   //
    ////////////////////////////////////////////////////

    private static void validate(String type, Object result, Object expected)
    {
        if (areNull(type, result, expected))
        {
            return;
        }

        if (!result.equals(expected))
        {
            fail("Different " + type + ": " + result + " while expected: " + expected);
        }
    }

    private static void validateArray(String type, Object[] result, Object[] expected)
    {
        if (areNull(type, result, expected))
        {
            return;
        }

        if (result.length != expected.length)
        {
            fail("Different " + type + ": " + result + " while expected: " + expected);
        }
        for (int i = 0; i != result.length; i++)
        {
            if (!result[i].equals(expected[i]))
            {
                fail("Different " + type + ": " + result[i] + " while expected: " + expected[i]);
            }
        }
    }

    public void testParseRequests()
        throws IOException, DVCSException, CMSException
    {
        for (Iterator it = requests.iterator(); it.hasNext();)
        {
            Info info = (Info)it.next();
            testParseRequest(info.name, info.base64, (DVCSRequest)info.expected);
        }
    }

    private void testParseRequest(String name, String base64request, DVCSRequest expected)
        throws DVCSException, IOException, CMSException
    {
        byte[] requestBytes = Base64.decode(base64request);

        org.bouncycastle.dvcs.DVCSRequest request = new org.bouncycastle.dvcs.DVCSRequest(new CMSSignedData(requestBytes));

        validate(name, request.getContent(), expected);
    }

    public void testParseResponses()
        throws IOException, DVCSException, CMSException
    {
        for (Iterator it = responses.iterator(); it.hasNext();)
        {
            Info info = (Info)it.next();
            testParseResponse(info.name, info.base64, (DVCSResponse)info.expected);
        }
    }

    ////////////////////////////////////////////////////
    //                  VALIDATIONS                   //
    ////////////////////////////////////////////////////

    private void testParseResponse(String name, String base64response, DVCSResponse expected)
        throws DVCSException, IOException, CMSException
    {
        byte[] responseBytes = Base64.decode(base64response);
        org.bouncycastle.dvcs.DVCSResponse response = new org.bouncycastle.dvcs.DVCSResponse(new CMSSignedData(responseBytes));

        validate(name, response.getContent(), expected);
    }

    /*
        DVCSRequest ::= SEQUENCE  {
            requestInformation         DVCSRequestInformation,
            data                       Data,
            transactionIdentifier      GeneralName OPTIONAL
        }
     */
    private void validate(String name, DVCSRequest result, DVCSRequest expected)
    {
        validate(name + ".requestInformation", result.getRequestInformation(), expected.getRequestInformation());
        validate(name + ".data", result.getData(), expected.getData());
        validate(name + ".transactionIdentifier", result.getTransactionIdentifier(), expected.getTransactionIdentifier());
    }

    /*
        DVCSRequestInformation ::= SEQUENCE  {
                version                      INTEGER DEFAULT 1 ,
                service                      ServiceType,
                nonce                        Nonce OPTIONAL,
                requestTime                  DVCSTime OPTIONAL,
                requester                    [0] GeneralNames OPTIONAL,
                requestPolicy                [1] PolicyInformation OPTIONAL,
                dvcs                         [2] GeneralNames OPTIONAL,
                dataLocations                [3] GeneralNames OPTIONAL,
                extensions                   [4] IMPLICIT Extensions OPTIONAL
        }
     */
    private void validate(String name, DVCSRequestInformation info, DVCSRequestInformation expected)
    {
        validate(name + ".version", Integers.valueOf(info.getVersion()), Integers.valueOf(expected.getVersion()));
        validate(name + ".service", info.getService().getValue(), expected.getService().getValue());
        validate(name + ".nonce", info.getNonce(), expected.getNonce());
        validate(name + ".requestTime", info.getRequestTime(), expected.getRequestTime());
        validate(name + ".requester", info.getRequester(), expected.getRequester());
        validate(name + ".requestPolicy", info.getRequestPolicy(), expected.getRequestPolicy());
        validate(name + ".dvcs", info.getDVCS(), expected.getDVCS());
        validate(name + ".dataLocations", info.getDataLocations(), expected.getDataLocations());
        validate(name + ".extensions", info.getExtensions(), expected.getExtensions());
    }

    /*
        DVCSTime ::= CHOICE  {
             genTime                      GeneralizedTime,
             timeStampToken               ContentInfo
        }
     */
    private void validate(String name, DVCSTime result, DVCSTime expected)
    {
        if (areNull(name, result, expected))
        {
            return;
        }
        validate(name + ".genTime", result.getGenTime(), expected.getGenTime());
        validate(name + ".timeStampToken", result.getTimeStampToken(), expected.getTimeStampToken());
    }

    /*
        Data ::= CHOICE {
              message           OCTET STRING ,
              messageImprint    DigestInfo,
              certs             SEQUENCE SIZE (1..MAX) OF
                                    TargetEtcChain
        }
     */
    private void validate(String name, Data result, Data expected)
    {
        validate(name + ".message", result.getMessage(), expected.getMessage());
        validate(name + ".messageImprint", result.getMessageImprint(), expected.getMessageImprint());
        validateArray(name + ".certs", result.getCerts(), expected.getCerts());
    }

    /*
        DVCSResponse ::= CHOICE
        {
            dvCertInfo         DVCSCertInfo ,
            dvErrorNote        [0] DVCSErrorNotice
        }
     */
    private void validate(String name, DVCSResponse result, DVCSResponse expected)
    {
        validate(name + ".dvCertInfo", result.getCertInfo(), expected.getCertInfo());
        validate(name + ".dvErrorNote", result.getErrorNotice(), expected.getErrorNotice());
    }

    /*
        DVCSCertInfo::= SEQUENCE  {
                 version             Integer DEFAULT 1 ,
                 dvReqInfo           DVCSRequestInformation,
                 messageImprint      DigestInfo,
                 serialNumber        Integer,
                 responseTime        DVCSTime,
                 dvStatus            [0] PKIStatusInfo OPTIONAL,
                 policy              [1] PolicyInformation OPTIONAL,
                 reqSignature        [2] SignerInfos  OPTIONAL,
                 certs               [3] SEQUENCE SIZE (1..MAX) OF
                                         TargetEtcChain OPTIONAL,
                 extensions          Extensions OPTIONAL
        }
     */
    private void validate(String name, DVCSCertInfo result, DVCSCertInfo expected)
    {
        if (areNull(name, result, expected))
        {
            return;
        }
        validate(name + ".version", Integers.valueOf(result.getVersion()), Integers.valueOf(expected.getVersion()));
        validate(name + ".dvReqInfo", result.getDvReqInfo(), expected.getDvReqInfo());
        validate(name + ".messageImprint", result.getMessageImprint(), expected.getMessageImprint());
        validate(name + ".serialNumber", result.getSerialNumber(), expected.getSerialNumber());
        validate(name + ".responseTime", result.getResponseTime(), expected.getResponseTime());
        validate(name + ".dvStatus", result.getDvStatus(), expected.getDvStatus());
        validate(name + ".policy", result.getPolicy(), expected.getPolicy());
        validate(name + ".reqSignature", result.getReqSignature(), expected.getReqSignature());
        validateArray(name + ".certs", result.getCerts(), expected.getCerts());
        validateArray(name + ".certs", result.getCerts(), expected.getCerts());
        validate(name + ".extensions", result.getExtensions(), expected.getExtensions());
    }

    /*
        DVCSErrorNotice ::= SEQUENCE {
            transactionStatus           PKIStatusInfo ,
            transactionIdentifier       GeneralName OPTIONAL
        }
     */
    private void validate(String name, DVCSErrorNotice result, DVCSErrorNotice expected)
    {
        if (areNull(name, result, expected))
        {
            return;
        }
        validate(name + ".transactionStatus", result.getTransactionStatus(), expected.getTransactionStatus());
        validate(name + ".transactionIdentifier", result.getTransactionIdentifier(), expected.getTransactionIdentifier());
    }

    private static class Info
    {
        public String name;
        public String base64;
        public Object expected;

        public Info(String name, String base64, Object expected)
        {
            this.name = name;
            this.base64 = base64;
            this.expected = expected;
        }
    }

}
