;          RDTSC.ASM                                          Agner Fog 2003

;  2003 GNU General Public License www.gnu.org/copyleft/gpl.html

.686
.xmm
.model flat

PublicAlias MACRO MangledName ; macro for giving a function alias public names
        MangledName label near
        public MangledName
ENDM

.code

; ********** ReadClock function **********
; C++ prototype:
; extern "C" int ReadClock (void);
; or:
; extern "C" __int64 ReadClock (void);

; This function returns the value of the time stamp counter, which counts 
; clock cycles. To count how many clock cycles a piece of code takes, call
; Rdtsc before and after the code to measure and calculate the difference.
; The function itself takes approximately 700 clock cycles on a Pentium 4,
; and approximately 225 clock cycles on Pentium II and Pentium III. 
; Does not work on 80386 and 80486.

ReadClock PROC NEAR
PUBLIC ReadClock
PublicAlias _ReadClock       ; Underscore needed when called from Windows

        push    ebx
        sub     eax, eax
        cpuid                ; serialize
        rdtsc                ; read time stamp counter
        push    eax
        push    edx
        sub     eax, eax
        cpuid                ; serialize
        pop     edx
        pop     eax
        pop     ebx
        ret
ReadClock ENDP

END
