dnl Makeup aclocal macros.
dnl
dnl Copyright 2003 - 2017, Ron <ron@debian.org>
dnl
dnl These macros are distributed under the terms of the GNU GPL version 2.
dnl
dnl As a special exception to the GPL, it may be distributed without
dnl modification as a part of a program using a makeup generated build
dnl system, under the same distribution terms as the program itself.
dnl Modified versions are not obliged to also offer this exception,
dnl though if you wish not to do so then you should remove this paragraph
dnl and make it clear that your modifications are licenced strictly
dnl according to the GPL 2 or a compatible licence.


#~ SHUT_THE_FUP(AC_MACRO)
#
# Stealth mode for AC_ macros.  Exploits implementation so it's
# potentially fragile, but almost all failure modes do not
# affect the functional output, and those that do should be
# immediately obvious if they occur :)  Use it to wrap a macro
# that would output something you don't want on the console.
# Do NOT quote them.  Will honour all other nasty hack's disclaimers
# upon presentation.
# -------------------------------------------------------------------

AC_DEFUN([SHUT_THE_FUP],
[
exec 6>/dev/null
$@dnl
exec 6>&1
])
#~


#~ ACM_REQUIRE_LN_S
#
# This macro should be AC_REQUIRE'd by any macro that
# may need $LN_S to be defined before it is expanded.
# ---------------------------------------------------

AC_DEFUN([ACM_REQUIRE_LN_S],
[
if test -z "$LN_S"; then
    SHUT_THE_FUP(AC_PROG_LN_S)
fi
])
#~


#~ FIND_AND_LINK_IF_LOCAL([FILE][,DEST][,SOURCE_DIRS])
#
# If FILE does not exist in dir DEST look for it in the immediate
# parent directories and if found create a symlink to it.  Else
# try to find it in a space separated list of SOURCE_DIRS (which
# default to a list of standard system locations) and then copy it.
# If DEST is not supplied explicitly, it will default to $srcdir,
# if DEST is supplied and does not exist, it will be created too.
# DEST is assumed to always be relative to $srcdir.
# ---------------------------------------------------------------

AC_DEFUN([FIND_AND_LINK_IF_LOCAL],
[
AC_REQUIRE([ACM_REQUIRE_LN_S])

if test -n "[$2]"; then
    _filedest=$srcdir/[$2]
    mkdir -p $_filedest
else
    _filedest=$srcdir
fi
if test -n "[$3]"; then
    _filesources="[$3]"
else
    _filesources="/usr/share/misc /usr/share/automake* /usr/share/libtool"
fi
if test ! -e "$_filedest/[$1]" ; then
    AC_MSG_CHECKING([for $_filedest/[$1]])

    ( cd $_filedest
        for d in ".." "../.." ; do
            if test -r "$d/[$1]" ; then
                AC_MSG_RESULT([linking from $d/[$1].])
                $LN_S "$d/[$1]" .
                break
            fi
        done
    )

    if test ! -e "$_filedest/[$1]" ; then
        for d in $_filesources;
	do
            if test -r "$d/[$1]" ; then
                AC_MSG_RESULT([copying from $d/[$1].])
                cp -a "$d/[$1]" "$_filedest/[$1]"
                break
            fi
        done
    fi

    if test ! -e "$_filedest/[$1]" ; then
        AC_MSG_ERROR([Failed to locate [$1].  Stopping.])
    fi
fi
])
#~


#~ FIND_AND_COPY_UNLESS_LOCAL([FILE][,DEST])
#
# If FILE does not exist in dir DEST look for it in the immediate
# parent directories and if found do nothing.  Else try to find
# it in a standard system location and then copy it over.
# Note that we dereference symlinks here, which is probably what
# you want if you're using this macro..  maybe.
# If DEST is not supplied explicitly, it will default to $srcdir,
# if DEST is supplied and does not exist, it will be created too.
# ---------------------------------------------------------------

AC_DEFUN([FIND_AND_COPY_UNLESS_LOCAL],
[
if test -n "[$2]"; then
    _filedest=[$2]
    mkdir -p $_filedest
else
    _filedest=$srcdir
fi
if test ! -e "$_filedest/[$1]" ; then
    AC_MSG_CHECKING([for $_filedest/[$1]])

    if (
        if (
            cd $_filedest
            for d in ".." "../.." ; do
                if test -r "$d/[$1]" ; then
                    AC_MSG_RESULT([leeching from $d/[$1].])
                    exit 1
                fi
            done
           ) ;
        then
            for d in "/usr/share/misc" "/usr/share/automake" "/usr/share/libtool" \
	    	     "/usr/share/automake-1.6" "/usr/share/automake-1.7" 	  ; do
                if test -r "$d/[$1]" ; then
                    cp -aL "$d/[$1]" "$_filedest/[$1]"
                    AC_MSG_RESULT([copying from $d/[$1].])
                    exit 1
                fi
            done
        else
            exit 1
        fi
       ) ;
    then
        AC_MSG_ERROR([Failed to locate [$1].  Stopping.])
    fi
fi
])
#~


#~ ACM_CONFIG_MAKEFILE(MAKEUP_GMAKE_DIR,[GLOBAL_VARIABLES])
#
# This macro instantiates a forwarding Makefile in the build directory
# and its corresponding Makefile.acsubst.  It is also used to define
# global variables that need to be available in config.status.
# --------------------------------------------------------------------

AC_DEFUN([ACM_CONFIG_MAKEFILE],
[
dnl This 'before' is not strictly required, but since this macro
dnl will usually define globals needed before ACM_CONFIG_HEADER
dnl then it seems like a reasonable sanity check.  Feel free to
dnl remove or work around it if it is causing real problems.
AC_BEFORE([$0],[ACM_CONFIG_HEADER])

m4_if([$#],0,[AC_MSG_ERROR([[ACM_CONFIG_MAKEFILE] must have at least one parameter])])

AC_CONFIG_COMMANDS([Makefile],
                   [
                    cat > Makefile <<EOF
# Makeup ACM_CONFIG_MAKEFILE generated makefile.
#
#  Copyright 2003 - 2017, Ron <ron@debian.org>
#
# This file is distributed under the terms of the GNU GPL version 2.
#
# As a special exception to the GPL, it may be distributed without
# modification as a part of a program using a makeup generated build
# system, under the same distribution terms as the program itself.
# Modified versions are not obliged to also offer this exception,
# though if you wish not to do so then you should remove this paragraph
# and make it clear that your modifications are licenced strictly
# according to the GPL 2 or a compatible licence.

include Makefile.acsubst
include \$(MAKEUP_TOP_CONFIG)

ifneq (\$(strip \$(MAKEUP_VERBOSE)),)
  include \$(MAKEUP_GMAKE_DIR)/makefile.makeup
else
 -include \$(MAKEUP_GMAKE_DIR)/makefile.makeup
endif

EOF
                   ],[
                    [$2]
                   ])
AC_CONFIG_FILES([Makefile.acsubst:$1/makefile.acsubst])
])
#~


#~ ACM_DEFINE_PUBLIC(VARIABLE,[VALUE],[DESCRIPTION])
#
# Causes VARIABLE to be defined in a public config header, such as:
#
# /* DESCRIPTION */
# #ifndef VARIABLE
# #define VARIABLE VALUE
# #endif
#
# If VALUE is unspecified then VARIABLE will be defined to be empty.
# This macro should be used in conjunction with ACM_CONFIG_HEADER
# which defines the name of the config headers in which to output
# variables defined with this macro.
# ------------------------------------------------------------------

AC_DEFUN([ACM_DEFINE_PUBLIC],
[
AC_BEFORE([$0],[ACM_CONFIG_HEADER])

m4_if(m4_bregexp([$1],[^[A-Za-z_]+[A-Za-z0-9_]+$]),-1,
[AC_MSG_ERROR([Bad variable name '[$1]' supplied to [ACM_DEFINE_PUBLIC]])])

acm_public_macros="$acm_public_macros [$1]"
if test -z "$acm_public_macros_def"; then
    acm_public_macros_def="acm_public_macro_[$1]=\"[$2]\"; acm_public_macro_desc_[$1]=\"[$3]\""
else
    acm_public_macros_def="$acm_public_macros_def; acm_public_macro_[$1]=\"[$2]\"; acm_public_macro_desc_[$1]=\"[$3]\""
fi
])
#~


#~ ACM_DEFINE_PUBLIC_STRING(VARIABLE,[VALUE],[DESCRIPTION])
#
# Causes VARIABLE to be defined as a literal string
# in a public config header, such as:
#
# /* DESCRIPTION */
# #ifndef VARIABLE
# #define VARIABLE "VALUE"
# #endif
#
# If VALUE is unspecified then VARIABLE will be defined to be empty.
# This macro should be used in conjunction with ACM_CONFIG_HEADER
# which defines the name of the config headers in which to output
# variables defined with this macro.
# ------------------------------------------------------------------

AC_DEFUN([ACM_DEFINE_PUBLIC_STRING],
[
AC_BEFORE([$0],[ACM_CONFIG_HEADER])

m4_if(m4_bregexp([$1],[^[A-Za-z_]+[A-Za-z0-9_]+$]),-1,
[AC_MSG_ERROR([Bad variable name '[$1]' supplied to [ACM_DEFINE_PUBLIC_STRING]])])

acm_public_strings="$acm_public_strings [$1]"
if test -z "$acm_public_strings_def"; then
    acm_public_strings_def="acm_public_string_[$1]=\"[$2]\"; acm_public_string_desc_[$1]=\"[$3]\""
else
    acm_public_strings_def="$acm_public_strings_def; acm_public_string_[$1]=\"[$2]\"; acm_public_string_desc_[$1]=\"[$3]\""
fi
])
#~


#~ ACM_CONFIG_HEADER(NAME)
#
# This is an instantiating macro that should usually be included
# shortly before AC_OUTPUT.  If will create a config file containing
# the public symbols declared by ACM_DEFINE_PUBLIC
# -----------------------------------------------------------------

AC_DEFUN([ACM_CONFIG_HEADER],
[
AC_REQUIRE([ACM_REQUIRE_LN_S])
m4_if([$#],1,[],[AC_MSG_ERROR([[ACM_CONFIG_HEADER] must have only one parameter])])

dnl is there a way to disable this at m4 time if ACM_DEFINE_PUBLIC has never been used?

AC_CONFIG_COMMANDS([include/$1],
                   [
                    _SUBDIR="$(dirname [$1])/"
                    if test "$_SUBDIR" = "./"; then
                        _SUBDIR=
                    fi
                    _TEMPFILE="include/.tempfile"

                    _GUARD="_MAKEFILE_PLATFORM_$(echo $package_name | tr "a-z .-" "A-Z___")_CONF_H"

                    cat > $_TEMPFILE <<EOF
/* Makeup ${makeup_version} generated [$1] for ${package_name} ${package_version}
 * Do not edit this file directly, your changes will be lost.
 * Copyright 2003 - 2017, Ron <ron@debian.org>
 *
 * This file is distributed under the terms of the GNU GPL version 2.
 *
 * As a special exception to the GPL, it may be distributed without
 * modification as a part of a program using a makeup generated build
 * system, under the same distribution terms as the program itself.
 * Modified versions are not obliged to also offer this exception,
 * though if you wish not to do so then you should remove this paragraph
 * and make it clear that your modifications are licenced strictly
 * according to the GPL 2 or a compatible licence.
 */

#ifndef ${_GUARD}
#define ${_GUARD}

// Guard for POSIX dependent code
#if defined(__unix__) || defined(__unix) || (defined(__APPLE__) && defined(__MACH__))
    #if (EM_PLATFORM_POSIX != 1)
	#define EM_PLATFORM_POSIX 1
    #endif

    // Guard for Linux kernel dependent code
    #if defined(__linux__)
	#if linux == 1
	    #define SAVE_linux
	    #undef linux
	#elif defined(linux)
	    #warning Macro 'linux' is defined to a value other than 1
	#endif

	#if (EM_PLATFORM_LINUX != 1)
	    #define EM_PLATFORM_LINUX 1
	#endif
	#define EM_PLATFORM__ linux

    #else

	// Guard for BSD dependent code
	#include <sys/param.h>
	#if defined(BSD) || defined(__FreeBSD_kernel__)
	    #if (EM_PLATFORM_BSD != 1)
		#define EM_PLATFORM_BSD 1
	    #endif
	    #define EM_PLATFORM__ bsd
	#endif

	// Guard for MacOSX dependent code
	#if defined(__APPLE__) && defined(__MACH__) && (EM_PLATFORM_MAC != 1)
	    #define EM_PLATFORM_MAC 1
	#endif

    #endif
#endif

// Guard for billware dependent code
#if defined(_WIN32)
    #if (EM_PLATFORM_MSW != 1)
        #define EM_PLATFORM_MSW 1
    #endif
    #define EM_PLATFORM__ msw
#endif

#ifndef EM_PLATFORM__
    #error Platform unrecognised.
#endif

// Feature override macro.
//
// You may define the value of this macro to specify a configuration
// other than the system default. 'd' will attempt to use a debug
// build, 'r' a release build.  Other flavour options may be defined
// by individual packages in their own configuration.
#ifndef EM_CONFIG_FLAVOUR
#define EM_CONFIG_FLAVOUR
#endif

#define EM_CAT(a,b) EM_CAT_(a,b)
#define EM_CAT_(a,b) a ## b

#define EM_CONFIG_HEADER <${__package_config_dir}EM_CAT(EM_PLATFORM__,EM_CONFIG_FLAVOUR)_${__package_config_public}>
#include EM_CONFIG_HEADER

#ifndef _${_GUARD}
#error Config header cannot be located
#endif

#undef EM_CAT
#undef EM_CAT_
#undef EM_PLATFORM__
#undef EM_CONFIG_HEADER
#ifdef SAVE_linux
    #define linux 1
    #undef SAVE_linux
#endif


// Compiler version tests.
//
// This macro will return false if the version of gcc in use
// is earlier than the specified major, minor limit, or if gcc
// is not being used.  Otherwise it will evaluate to be true.
// This will also be true for the clang compiler, for whatever
// GCC version it is pretending to be compatible with.
#if defined(__GNUC__) && defined(__GNUC_MINOR__)
 #define EM_COMPILER_GCC( major, minor )   ( ( __GNUC__ > (major) )         \\
            || ( __GNUC__ == (major) && __GNUC_MINOR__ >= (minor) ) )
#else
 #define EM_COMPILER_GCC( major, minor )  0
#endif

// As above, except for the clang compiler instead.
#if defined(__clang_major__) && defined(__clang_minor__)
 #define EM_COMPILER_CLANG( major, minor )  ( ( __clang_major__ > (major) ) \\
            || ( __clang_major__ == (major) && __clang_minor__ >= (minor) ) )
#else
 #define EM_COMPILER_CLANG( major, minor )  0
#endif

#endif  // ${_GUARD}

EOF

                    if diff --brief include/[$1] $_TEMPFILE > /dev/null 2>&1; then
                        AC_MSG_NOTICE([[$1] is unchanged])
                        rm $_TEMPFILE
                    else
                        mv $_TEMPFILE include/[$1]
                    fi

                    echo "/* Makeup generated $_SUBDIR$config_flavour */" > $_TEMPFILE
                    echo                                                >> $_TEMPFILE
                    echo "#ifndef _${_GUARD}"                           >> $_TEMPFILE
                    echo "#define _${_GUARD}"                           >> $_TEMPFILE
                    echo                                                >> $_TEMPFILE
                    for m in $acm_public_macros; do
                        eval echo "/\* \$acm_public_macro_desc_$m \*/"  >> $_TEMPFILE
                             echo "#ifndef $m"                          >> $_TEMPFILE
                        eval echo "\#define $m \$acm_public_macro_$m"   >> $_TEMPFILE
                             echo "#endif"                              >> $_TEMPFILE
                             echo                                       >> $_TEMPFILE
                    done

                    for s in $acm_public_strings; do
                        eval echo "/\* \$acm_public_string_desc_$s \*/" >> $_TEMPFILE
                             echo "#ifndef $s"                          >> $_TEMPFILE
                        eval echo "\#define $s \\\"\$acm_public_string_$s\\\"" >> $_TEMPFILE
                             echo "#endif"                              >> $_TEMPFILE
                             echo                                       >> $_TEMPFILE
                    done
                    echo "#endif  // _${_GUARD}"                        >> $_TEMPFILE

                    if diff --brief include/$_SUBDIR$config_flavour $_TEMPFILE > /dev/null 2>&1; then
                        AC_MSG_NOTICE([$_SUBDIR$config_flavour is unchanged])
                        rm $_TEMPFILE
                    else
                        mv $_TEMPFILE include/$_SUBDIR$config_flavour
                    fi

                    ( cd include/$_SUBDIR
                      if test ! -e $config_platform; then
                        $LN_S $config_flavour $config_platform
                      fi
                    )
                   ],[
                    acm_public_macros="$acm_public_macros"
                    $acm_public_macros_def
                    acm_public_strings="$acm_public_strings"
                    $acm_public_strings_def
                    LN_S="$LN_S"
                    config_platform="$MAKEUP_PLATFORM_HEADER"
                    config_flavour="$MAKEUP_FLAVOUR_HEADER"
                   ])
])
#~


#~ _ACM_COMPILER_WERROR_UNKNOWN_WARNING_OPTION([FLAGS_PREFIX],[COMPILER_VAR])
#
# Check if the compiler considers unknown warning options to be an error
# by default, or if it needs an explicit extra option passed to do so.
# This macro is an implementation detail required by ACM_ADD_COMPILER_WARNING.
#
# Testing whether a warning option is supported can be tricky.  By default
# GCC will consider -Wfoo to be an error if 'foo' is an unknown warning,
# but it will not even emit a diagnostic for -Wno-foo unless some other
# diagnostic message is also triggered, in which case it will merely warn
# that an unrecognised option is also present.
#
# With the clang toolchain the behaviour in both cases is controlled by an
# explicit option: -Wunknown-warning-option, which is enabled by default.
# If that option is negated then no diagnostic is output, otherwise unknown
# warning options of either polarity will simply emit a warning.  If we want
# to test whether a warning option is supported then we need to explicitly
# add unknown-warning-option to the -Werror set to provoke a test failure
# if it is not.
#
# The FLAGS_PREFIX determines which language will be tested and so which of
# the *FLAGS variables the test options will be added to.  Supported values
# are currently C and CXX.
#
# The COMPILER_VAR is only used to report the toolchain being tested, so for
# C it should be [$CC] and for C++ it should be [$CXX].  This parameter is
# passed as a convenience, since there is no strictly consistent rule which
# maps all the related identifiers for a language together, and the caller
# should already know it, so we don't need extra logic here to look it up.
#
# The output variable ACM_${FLAGS_PREFIX}_WARNINGFAIL will be set to either
# an empty string or the additional option(s) which need to be set in the
# relevant *FLAGS when testing whether some warning option is supported.
#
# This macro shouldn't normally be invoked directly, instead the language
# specific wrappers which don't need options (but whose name can still be
# constructed from other macros) should be AC_REQUIRE'd before the output
# variable is needed for the first time.
# ----------------------------------------------------------------------------

AC_DEFUN([_ACM_COMPILER_WERROR_UNKNOWN_WARNING_OPTION],
[
m4_case([$1],
        [C],[AC_LANG_PUSH([C])],
        [CXX],[AC_LANG_PUSH([C++])],
        [m4_fatal([_ACM_COMPILER_WERROR_UNKNOWN_WARNING_OPTION: unknown toolchain type '$1'])])

acm_save_$1FLAGS="$$1FLAGS"
$1FLAGS="$$1FLAGS -Womg-wtf-not-an-option"

ACM_$1_WARNINGFAIL=""

AC_CACHE_CHECK([if $2 unknown warning options are errors],[mu_cv_$1_flag_uwo],
               [AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[]],[[]])],
                                  [mu_cv_$1_flag_uwo=no],
                                  [mu_cv_$1_flag_uwo=yes]
                                 )
              ])
AS_IF([test "$mu_cv_$1_flag_uwo" = no],[
      $1FLAGS="$acm_save_$1FLAGS -Werror=unknown-warning-option -Womg-wtf-not-an-option"
      AC_CACHE_CHECK([if $2 supports -Werror=unknown-warning-option],[mu_cv_$1_flag_werror_uwo],
                     [AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[]],[[]])],
                                        [mu_cv_$1_flag_werror_uwo=no],
                                        [mu_cv_$1_flag_werror_uwo=yes]
                                       )
                    ])
      dnl It should be safe to fail open here.  If we haven't figured out how to make the
      dnl compiler fail when passed an unknown warning option, then it should be relatively
      dnl safe to let tests default to passing them anyway.  At best, they will actually
      dnl work as intended, and at worst it might make a lot of noise spitting out non-fatal
      dnl warning diagnostics about not liking them - but it shouldn't break the build.
      dnl We bark a warning here so that this test can be improved further if that occurs,
      dnl and err on the side of including rather than excluding extra warnings.
      AS_IF([test "$mu_cv_$1_flag_werror_uwo" = yes],
            [ACM_$1_WARNINGFAIL=" -Werror=unknown-warning-option"],
            [AC_MSG_WARN([Don't know how to make $2 fail with unknown warning options,])
             AC_MSG_WARN([so later tests may (wrongly) decide to pass them to it anyway.])])
     ])

$1FLAGS="$acm_save_$1FLAGS"

m4_case([$1],
        [C],[AC_LANG_POP([C])],
        [CXX],[AC_LANG_POP([C++])],
        [m4_fatal([_ACM_COMPILER_WERROR_UNKNOWN_WARNING_OPTION: unknown toolchain type '$1'])])
])
#~


#~ _ACM_C_WERROR_UNKNOWN_WARNING_OPTION
#
# C language wrapper for _ACM_COMPILER_WERROR_UNKNOWN_WARNING_OPTION
# which can be AC_REQUIRE'd.
# -------------------------------------------------------------------

AC_DEFUN([_ACM_C_WERROR_UNKNOWN_WARNING_OPTION],
[
_ACM_COMPILER_WERROR_UNKNOWN_WARNING_OPTION([C],[$CC])
])
#~


#~ _ACM_CXX_WERROR_UNKNOWN_WARNING_OPTION
#
# C++ language wrapper for _ACM_COMPILER_WERROR_UNKNOWN_WARNING_OPTION
# which can be AC_REQUIRE'd.
# ---------------------------------------------------------------------

AC_DEFUN([_ACM_CXX_WERROR_UNKNOWN_WARNING_OPTION],
[
_ACM_COMPILER_WERROR_UNKNOWN_WARNING_OPTION([CXX],[$CXX])
])
#~


#~ __ACM_ADD_COMPILER_WARNING([FLAGS_PREFIX],[WARNING_OPTION],[CACHE_VAR_SUFFIX])
#
# Implementation of _ACM_ADD_COMPILER_WARNING for doing the individial tests of
# each of the specified WARNING_OPTIONS. The correct default language should be
# already set, so here we test if -W${WARNING_OPTION} is supported, caching the
# result of that test in mu_cv_${FLAGS_PREFIX}_flag_${CACHE_VAR_SUFFIX}, and
# appending any supported warning options to ${FLAGS_PREFIX}FLAGS.
# ------------------------------------------------------------------------------

AC_DEFUN([__ACM_ADD_COMPILER_WARNING],
[
acm_save_$1FLAGS="$$1FLAGS"
$1FLAGS="$$1FLAGS$ACM_$1_WARNINGFAIL -W$2"

dnl We need to special case C => $CC here, but CXX => $CXX can be implicit.
AC_CACHE_CHECK([if m4_case([$1],[C],[$CC],[$$1]) supports -W$2],[mu_cv_$1_flag_$3],
               [AC_COMPILE_IFELSE([AC_LANG_PROGRAM([[]],[[]])],
                                  [mu_cv_$1_flag_$3=yes],
                                  [mu_cv_$1_flag_$3=no]
                                 )
              ])
AS_IF([test "$mu_cv_$1_flag_$3" = yes],
      [$1FLAGS="$acm_save_$1FLAGS -W$2"],
      [$1FLAGS="$acm_save_$1FLAGS"])
])
#~


#~ _ACM_ADD_COMPILER_WARNING([FLAGS_PREFIX],[WARNING_OPTIONS])
#
# Implementation of ACM_ADD_COMPILER_WARNING for doing the individial tests with
# each of the specified FLAGS_PREFIXES. This will temporarily switch the default
# language based on FLAGS_PREFIX, then test if each of the comma-separated list
# of WARNING_OPTIONS is supported for that language.
# ------------------------------------------------------------------------------

AC_DEFUN([_ACM_ADD_COMPILER_WARNING],
[
dnl We do this check before the AC_REQUIRE below, because the most likely cause
dnl of this failing is a typo in user code invoking ACM_ADD_COMPILER_WARNING
dnl and this gives a more user friendly warning pointing to the correct place
dnl when the m4 is being processed by aclocal/autom4te, rather than having that
dnl propagate deeper into the implementation detail before being caught.
dnl
dnl But it will not change the default toolchain for the invocation of the
dnl requirement, since that gets expanded outside of the scope of the push/pop
dnl used here, so it will need to do this itself as well to be run with the
dnl correct toolchain.
m4_case([$1],
        [C],[AC_LANG_PUSH([C])],
        [CXX],[AC_LANG_PUSH([C++])],
        [m4_fatal([ACM_ADD_COMPILER_WARNING: unknown toolchain type '$1'])])

AC_REQUIRE([_ACM_$1_WERROR_UNKNOWN_WARNING_OPTION])

m4_foreach([opt],[$2],[__ACM_ADD_COMPILER_WARNING([$1],opt,m4_tolower(m4_bpatsubst(opt,[[^A-Za-z0-9]],[_])))])

m4_case([$1],
        [C],[AC_LANG_POP([C])],
        [CXX],[AC_LANG_POP([C++])],
        [m4_fatal([ACM_ADD_COMPILER_WARNING: unknown toolchain type '$1'])])
])
#~


#~ ACM_ADD_COMPILER_WARNING([FLAGS_PREFIXES],[WARNING_OPTIONS])
#
# For each combination of the comma-separated FLAGS_PREFIXES and WARNING_OPTIONS
# check if the corresponding compiler supports -W${WARNING_OPTION} and if it does
# add it to the *FLAGS for that language for use when compiling subsequent source.
#
# Currently supported values for FLAGS_PREFIXES are C and CXX (use [C,CXX] to
# test and set options for both the C and C++ compiler).
# ----------------------------------------------------------------------------

AC_DEFUN([ACM_ADD_COMPILER_WARNING],
[
m4_foreach([lang],[$1],[_ACM_ADD_COMPILER_WARNING(lang,[$2])])
])
#~

