/*
 * File    : IpItem.java
 * Created : 24 nov. 2003
 * By      : Olivier
 *
 * Copyright (C) 2004, 2005, 2006 Aelitis SAS, All rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details ( see the LICENSE file ).
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * AELITIS, SAS au capital de 46,603.30 euros,
 * 8 Allee Lenotre, La Grille Royale, 78600 Le Mesnil le Roi, France.
 */
 
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

/**
 *
 * @author Olivier
 * @author TuxPaper (2004/Apr/19: modified to TableCellAdapter)
 */
public class IpItem
       extends CoreTableColumn 
       implements TableCellRefreshListener, ObfusticateCellText
{
	public static final String COLUMN_ID = "ip";

	public void fillTableColumnInfo(TableColumnInfo info) {
		info.addCategories(new String[] {
			CAT_PEER_IDENTIFICATION,
			CAT_CONNECTION
		});
	}

  /** Default Constructor */
  public IpItem(String table_id) {
    super(COLUMN_ID, POSITION_LAST, 100, table_id);
    setObfustication(true);
   }

  public void refresh(TableCell cell) {
    PEPeer peer = (PEPeer)cell.getDataSource();
    String sText = (peer == null) ? "" : peer.getIp();

    if (cell.setText(sText) || !cell.isValid()) {
      String[] sBlocks = sText.split("\\.");
      if (sBlocks.length == 4) {
        try {
          long l = (Long.parseLong(sBlocks[0]) << 24) +
                   (Long.parseLong(sBlocks[1]) << 16) +
                   (Long.parseLong(sBlocks[2]) << 8) +
                   Long.parseLong(sBlocks[3]);
          cell.setSortValue(l);
        } catch (Exception e) { e.printStackTrace(); /* ignore */ }
      }
    }
  }

  public String getObfusticatedText(TableCell cell) {
  	return cell.getText().substring(0, 3);
  }
}
