/* tag: Tom Lord Tue Dec  4 14:41:50 2001 (backtrace.c)
 */
/* backtrace.c -
 *
 ****************************************************************
 * Copyright (C) 2000 Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/piw/backtrace.h"




void *
backtrace_return_addr2(void)
{

#ifndef __GNUC__

#warning backtrace functinoality not supported with this compiler (see hackerlab/machine/backtrace.c)

  return ((void *)0);

#elif defined(i386)

  unsigned long BP;

  asm volatile ("movl %%ebp,%%eax" : "=a" (BP) : "0" (BP));
  return (void *)(*(unsigned long *)(*(unsigned long *)BP + 4));

#elif defined(sparc)

  register unsigned long SP;

  asm("ta 3");			/* flush register windows */

  __asm__ __volatile__ ("mov %%sp,%0" : "=r"(SP));
  return backtrace_noop ((void *)(*(unsigned long *)(*((unsigned long *)(SP + 56)) + 60)));

#else

#warning backtrace functinoality not supported with this architecture (see hackerlab/machine/backtrace.c)

  return ((void *)0);

#endif

}
