// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __mem_pool_h__
#define __mem_pool_h__

#include "Puma/Heap.h"

namespace Puma {


class MemPool : protected Heap {
  static const unsigned long alignment = sizeof (long); // object alignment

  struct Link {
    struct Link *next;
  };

  Link *block;
  unsigned long size;
  unsigned long used;
  unsigned long defsize;

  void grow (unsigned long blocksize);
  unsigned long align (unsigned long size);

public:
  MemPool (unsigned long blocksize = 128L * 1024L);
  ~MemPool ();

  void *alloc (unsigned long objectsize);
  void dealloc (void *);
  void free ();
};


} // namespace Puma

#endif /* __mem_pool_h__ */
