/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:13:36 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.ICDIAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ICDIAlgorithm_ESTest extends ICDIAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      ICDIAlgorithm iCDIAlgorithm0 = null;
      try {
        iCDIAlgorithm0 = new ICDIAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.ICDIAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("a[7]Wq)P!pnxA[ZO");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      Integer integer0 = iCDIAlgorithm0.getDefaultStepSize(52);
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
      assertTrue(iCDIAlgorithm0.scalingFlag());
      assertEquals("Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("}(MXB1skCzi.Ep");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      Integer integer0 = iCDIAlgorithm0.getDefaultStepSize((-2046));
      assertEquals("Reverse Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
      assertTrue(iCDIAlgorithm0.scalingFlag());
      assertNull(integer0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("a[7]Wq)P!pnxA[ZO");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      Integer integer0 = iCDIAlgorithm0.getDefaultMinWindowSize();
      assertTrue(iCDIAlgorithm0.scalingFlag());
      assertEquals("Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("I['mJL5<tVgngv/]-B7", "I['mJL5<tVgngv/]-B7");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      Integer integer0 = iCDIAlgorithm0.getDefaultMaxWindowSize();
      assertEquals("Reverse Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
      assertTrue(iCDIAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals(5000, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("a[7]Wq)P!pnxA[ZO");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      Integer integer0 = iCDIAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer0);
      assertEquals(500, (int)integer0);
      assertTrue(iCDIAlgorithm0.scalingFlag());
      assertEquals("Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("N~LU@6x$/1C(3Ne");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      float[] floatArray0 = new float[5];
      iCDIAlgorithm0.getValues(2, 627, floatArray0);
      assertTrue(iCDIAlgorithm0.scalingFlag());
      assertEquals("Reverse Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      float[] floatArray0 = new float[9];
      // Undeclared exception!
      try { 
        iCDIAlgorithm0.getValues(2, 0, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 2 > end: 1
         //
         verifyException("uk.ac.sanger.artemis.plot.ICDIAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("I['mJL5<tVgngv/]-B7", "I['mJL5<tVgngv/]-B7");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      // Undeclared exception!
      try { 
        iCDIAlgorithm0.getValues(0, 2, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.ICDIAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("I['mJL5<tVgngv/]-B7", "I['mJL5<tVgngv/]-B7");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      iCDIAlgorithm0.getAverage();
      assertEquals("Reverse Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
      assertTrue(iCDIAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      Float float0 = iCDIAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals("Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
      assertTrue(iCDIAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("}(MXB1skCzi.Ep");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      Float float0 = iCDIAlgorithm0.getMaximumInternal();
      assertEquals("Reverse Intrinsic Codon Deviation Index", iCDIAlgorithm0.getAlgorithmName());
      assertTrue(iCDIAlgorithm0.scalingFlag());
      assertEquals(1000.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("a[7]Wq)P!pnxA[ZO");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      ICDIAlgorithm iCDIAlgorithm0 = new ICDIAlgorithm(strand0);
      iCDIAlgorithm0.getValueCount();
  }
}
